/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.qodana.sarif.model.streaming;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.jetbrains.qodana.sarif.SarifUtil;
import com.jetbrains.qodana.sarif.model.Result;
import com.jetbrains.qodana.sarif.model.streaming.GeneratingIterator;
import com.jetbrains.qodana.sarif.model.streaming.IndexedResult;
import com.jetbrains.qodana.sarif.model.streaming.StreamingUtil;
import java.io.IOException;
import java.io.Reader;

public class IndexedResultIterator
extends GeneratingIterator<IndexedResult> {
    private Gson gson = null;
    private final JsonReader resultsReader;
    private int currentIndex;
    private ResultIterator resultIterator;

    public IndexedResultIterator(Reader reader) {
        this.resultsReader = new JsonReader(reader);
    }

    private Gson getGson() {
        if (this.gson == null) {
            this.gson = SarifUtil.createGson();
        }
        return this.gson;
    }

    @Override
    protected IndexedResult makeInitial() {
        try {
            if (!StreamingUtil.find(this.resultsReader, "runs")) {
                return null;
            }
            this.resultsReader.beginArray();
            if (this.resultsReader.peek() != JsonToken.BEGIN_OBJECT) {
                return null;
            }
            this.currentIndex = -1;
            this.resultIterator = this.tryMakeNextResultIterator();
            return this.tryReadIndexedResult();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected IndexedResult makeNext(IndexedResult prev) {
        return this.tryReadIndexedResult();
    }

    private IndexedResult tryReadIndexedResult() {
        if (this.resultIterator == null) {
            return null;
        }
        if (!this.resultIterator.hasNext()) {
            this.skipRestOfRun(this.resultsReader);
            this.resultIterator = this.tryMakeNextResultIterator();
            return this.tryReadIndexedResult();
        }
        return new IndexedResult(this.currentIndex, (Result)this.resultIterator.next());
    }

    private void skipRestOfRun(JsonReader resultsReader) {
        try {
            resultsReader.endArray();
            StreamingUtil.skipToTheEndOfObject(resultsReader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ResultIterator tryMakeNextResultIterator() {
        try {
            ++this.currentIndex;
            if (this.resultsReader.peek() == JsonToken.END_ARRAY || !StreamingUtil.find(this.resultsReader, "results")) {
                return null;
            }
            return new ResultIterator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private class ResultIterator
    extends GeneratingIterator<Result> {
        private ResultIterator() {
        }

        @Override
        protected Result makeInitial() {
            try {
                IndexedResultIterator.this.resultsReader.beginArray();
                return this.tryReadResult(IndexedResultIterator.this.resultsReader);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected Result makeNext(Result prev) {
            return this.tryReadResult(IndexedResultIterator.this.resultsReader);
        }

        private Result tryReadResult(JsonReader reader) {
            try {
                if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                    return null;
                }
                return (Result)IndexedResultIterator.this.getGson().fromJson(reader, Result.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

