/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate;

import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.profiler.ultimate.NewProcessStartedExternallyCommunicator;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/ultimate/NewProcessStartedOnTargetCommunicator;", "Lcom/intellij/profiler/ultimate/NewProcessStartedExternallyCommunicator;", "targetName", "", "targetEnvironmentProvider", "Lkotlin/Function0;", "Lcom/intellij/execution/target/TargetEnvironment;", "targetProcessHandler", "Lcom/intellij/execution/process/BaseOSProcessHandler;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lcom/intellij/execution/process/BaseOSProcessHandler;)V", "getTargetProcessHandler", "()Lcom/intellij/execution/process/BaseOSProcessHandler;", "performDownload", "", "profilerDumpPath", "Ljava/nio/file/Path;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.profiler.ultimate"})
public final class NewProcessStartedOnTargetCommunicator
extends NewProcessStartedExternallyCommunicator {
    @NotNull
    private final Function0<TargetEnvironment> targetEnvironmentProvider;
    @NotNull
    private final BaseOSProcessHandler targetProcessHandler;

    public NewProcessStartedOnTargetCommunicator(@NotNull String targetName, @NotNull Function0<? extends TargetEnvironment> targetEnvironmentProvider, @NotNull BaseOSProcessHandler targetProcessHandler) {
        Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
        Intrinsics.checkNotNullParameter(targetEnvironmentProvider, (String)"targetEnvironmentProvider");
        Intrinsics.checkNotNullParameter((Object)targetProcessHandler, (String)"targetProcessHandler");
        super(targetName, targetProcessHandler);
        this.targetEnvironmentProvider = targetEnvironmentProvider;
        this.targetProcessHandler = targetProcessHandler;
    }

    @Override
    @NotNull
    public BaseOSProcessHandler getTargetProcessHandler() {
        return this.targetProcessHandler;
    }

    public final void performDownload(@NotNull Path profilerDumpPath, @NotNull ProgressIndicator progressIndicator) throws IOException {
        Intrinsics.checkNotNullParameter((Object)profilerDumpPath, (String)"profilerDumpPath");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        TargetEnvironment targetEnvironment = (TargetEnvironment)this.targetEnvironmentProvider.invoke();
        if (targetEnvironment == null) {
            throw new IllegalStateException(UltimateProfilerBundleKt.profilerMessage("download.profiler.dump.from.target.failed.environment.missing", new Object[0]).toString());
        }
        TargetEnvironmentFunctions.downloadFromTarget((TargetEnvironment)targetEnvironment, (Path)profilerDumpPath, (ProgressIndicator)progressIndicator);
    }
}

