/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.openapi.util.Key;
import com.intellij.psi.scope.ElementClassHint;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public enum GroovyResolveKind {
    VARIABLE(ElementClassHint.DeclarationKind.VARIABLE, new ElementClassHint.DeclarationKind[0]),
    BINDING(ElementClassHint.DeclarationKind.VARIABLE, new ElementClassHint.DeclarationKind[0]),
    METHOD(ElementClassHint.DeclarationKind.METHOD, new ElementClassHint.DeclarationKind[0]),
    FIELD(ElementClassHint.DeclarationKind.FIELD, new ElementClassHint.DeclarationKind[0]),
    PROPERTY(ElementClassHint.DeclarationKind.METHOD, ElementClassHint.DeclarationKind.FIELD),
    TYPE_PARAMETER(ElementClassHint.DeclarationKind.CLASS, new ElementClassHint.DeclarationKind[0]),
    CLASS(ElementClassHint.DeclarationKind.CLASS, new ElementClassHint.DeclarationKind[0]),
    PACKAGE(ElementClassHint.DeclarationKind.PACKAGE, new ElementClassHint.DeclarationKind[0]);

    public final Set<ElementClassHint.DeclarationKind> declarationKinds;
    public static final Key<Hint> HINT_KEY;
    public static final Hint EMPTY_HINT;

    private GroovyResolveKind(ElementClassHint.DeclarationKind kind, ElementClassHint.DeclarationKind ... kinds) {
        this.declarationKinds = Collections.unmodifiableSet(EnumSet.of(kind, kinds));
    }

    static {
        HINT_KEY = Key.create((String)"groovy.resolve.kind.hint");
        EMPTY_HINT = it -> false;
    }

    public static interface Hint {
        public boolean shouldProcess(@NotNull GroovyResolveKind var1);
    }
}

