/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaClassType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.k2.refactoring.introduce.K2SemanticMatcher;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0002\u001a\u001c\u0010\b\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\f\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0004*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a%\u0010\u0012\u001a\u00020\u0013*\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0013H\u0082\u0010\u00a8\u0006\u0015"}, d2={"getProblemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "element", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "isReadOnlyCollectionOrMap", "", "Lorg/jetbrains/kotlin/analysis/api/types/KaClassType;", "checkExpressionRepeat", "variableExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "isPrimitiveOperation", "isCommutative", "operationToken", "Lcom/intellij/psi/tree/IElementType;", "isArithmeticOperation", "buildOperatorAssignment", "buildOperatorAssignmentText", "", "tail", "kotlin.code-insight.inspections.k2"})
public final class ReplaceWithOperatorAssignmentInspectionKt {
    private static final ProblemHighlightType getProblemHighlightType(KaSession $this$getProblemHighlightType, KtBinaryExpression element) {
        KtExpression ktExpression = element.getLeft();
        KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
        KaType kaType = ktNameReferenceExpression != null ? $this$getProblemHighlightType.getExpressionType((KtExpression)ktNameReferenceExpression) : null;
        KaClassType leftType = kaType instanceof KaClassType ? (KaClassType)kaType : null;
        KaClassType kaClassType = leftType;
        return (kaClassType != null ? ReplaceWithOperatorAssignmentInspectionKt.isReadOnlyCollectionOrMap(kaClassType) : false) ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    private static final boolean isReadOnlyCollectionOrMap(KaClassType $this$isReadOnlyCollectionOrMap) {
        Object[] objectArray = new ClassId[]{StandardClassIds.INSTANCE.getList(), StandardClassIds.INSTANCE.getSet(), StandardClassIds.INSTANCE.getMap()};
        return CollectionsKt.listOf((Object[])objectArray).contains($this$isReadOnlyCollectionOrMap.getClassId());
    }

    private static final boolean checkExpressionRepeat(KaSession $this$checkExpressionRepeat, KtExpression variableExpression, KtBinaryExpression expression) {
        boolean bl;
        boolean isPrimitiveOperation = ReplaceWithOperatorAssignmentInspectionKt.isPrimitiveOperation($this$checkExpressionRepeat, expression);
        IElementType iElementType = expression.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
        IElementType operationToken = iElementType;
        KtExpression expressionLeft = expression.getLeft();
        KtExpression expressionRight = expression.getRight();
        boolean bl2 = expressionLeft != null ? K2SemanticMatcher.INSTANCE.isSemanticMatch($this$checkExpressionRepeat, (KtElement)expressionLeft, (KtElement)variableExpression) : false;
        if (bl2) {
            bl = ReplaceWithOperatorAssignmentInspectionKt.isArithmeticOperation(operationToken);
        } else {
            boolean bl3 = expressionRight != null ? K2SemanticMatcher.INSTANCE.isSemanticMatch($this$checkExpressionRepeat, (KtElement)expressionRight, (KtElement)variableExpression) : false;
            if (bl3) {
                bl = isPrimitiveOperation && ReplaceWithOperatorAssignmentInspectionKt.isCommutative(operationToken);
            } else if (expressionLeft instanceof KtBinaryExpression) {
                boolean sameCommutativeOperation;
                boolean bl4 = sameCommutativeOperation = Intrinsics.areEqual((Object)((KtBinaryExpression)expressionLeft).getOperationToken(), (Object)operationToken) && ReplaceWithOperatorAssignmentInspectionKt.isCommutative(operationToken);
                bl = isPrimitiveOperation && sameCommutativeOperation && ReplaceWithOperatorAssignmentInspectionKt.checkExpressionRepeat($this$checkExpressionRepeat, variableExpression, (KtBinaryExpression)expressionLeft);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isPrimitiveOperation(KaSession $this$isPrimitiveOperation, KtBinaryExpression expression) {
        KtOperationReferenceExpression ktOperationReferenceExpression = expression.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"getOperationReference(...)");
        KaSymbol kaSymbol = $this$isPrimitiveOperation.resolveToSymbol((KtReference)ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)ktOperationReferenceExpression)));
        KaSymbol kaSymbol2 = kaSymbol != null ? $this$isPrimitiveOperation.getContainingSymbol(kaSymbol) : null;
        KaClassSymbol kaClassSymbol = kaSymbol2 instanceof KaClassSymbol ? (KaClassSymbol)kaSymbol2 : null;
        if (kaClassSymbol == null) {
            return false;
        }
        KaClassSymbol operationSymbol = kaClassSymbol;
        return $this$isPrimitiveOperation.isPrimitive($this$isPrimitiveOperation.getDefaultType(operationSymbol));
    }

    private static final boolean isCommutative(IElementType operationToken) {
        return Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.PLUS) || Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.MUL);
    }

    private static final boolean isArithmeticOperation(IElementType operationToken) {
        return Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.PLUS) || Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.MINUS) || Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.MUL) || Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.DIV) || Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.PERC);
    }

    private static final KtBinaryExpression buildOperatorAssignment(KaSession $this$buildOperatorAssignment, KtBinaryExpression element) {
        KtExpression ktExpression = element.getLeft();
        if (ktExpression == null) {
            return null;
        }
        KtExpression variableExpression = ktExpression;
        KtExpression ktExpression2 = element.getRight();
        KtBinaryExpression ktBinaryExpression = ktExpression2 instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression2 : null;
        if (ktBinaryExpression == null) {
            return null;
        }
        KtBinaryExpression assignedExpression = ktBinaryExpression;
        String replacement = ReplaceWithOperatorAssignmentInspectionKt.buildOperatorAssignmentText($this$buildOperatorAssignment, variableExpression, assignedExpression, "");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtExpressionCodeFragment codeFragment = new KtPsiFactory(project, false, 2, null).createExpressionCodeFragment(replacement, (PsiElement)element);
        KtExpression ktExpression3 = codeFragment.getContentElement();
        return ktExpression3 instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression3 : null;
    }

    private static final String buildOperatorAssignmentText(KaSession $this$buildOperatorAssignmentText, KtExpression variableExpression, KtBinaryExpression expression, String tail) {
        String string;
        block3: {
            while (true) {
                String operationText = expression.getOperationReference().getText();
                String variableName = variableExpression.getText();
                Object object = expression.getLeft();
                boolean bl = object != null ? K2SemanticMatcher.INSTANCE.isSemanticMatch($this$buildOperatorAssignmentText, (KtElement)object, (KtElement)variableExpression) : false;
                if (bl) {
                    KtExpression ktExpression = expression.getRight();
                    Intrinsics.checkNotNull((Object)ktExpression);
                    string = ReplaceWithOperatorAssignmentInspectionKt.buildOperatorAssignmentText$appendTail(variableName + " " + operationText + "= " + ktExpression.getText(), tail);
                    break block3;
                }
                object = expression.getRight();
                boolean bl2 = object != null ? K2SemanticMatcher.INSTANCE.isSemanticMatch($this$buildOperatorAssignmentText, (KtElement)object, (KtElement)variableExpression) : false;
                if (bl2) {
                    KtExpression ktExpression = expression.getLeft();
                    Intrinsics.checkNotNull((Object)ktExpression);
                    string = ReplaceWithOperatorAssignmentInspectionKt.buildOperatorAssignmentText$appendTail(variableName + " " + operationText + "= " + ktExpression.getText(), tail);
                    break block3;
                }
                if (!(expression.getLeft() instanceof KtBinaryExpression)) break;
                object = $this$buildOperatorAssignmentText;
                KtExpression ktExpression = variableExpression;
                KtExpression ktExpression2 = expression.getLeft();
                Intrinsics.checkNotNull((Object)ktExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktExpression2;
                KtExpression ktExpression3 = expression.getRight();
                Intrinsics.checkNotNull((Object)ktExpression3);
                String string2 = ReplaceWithOperatorAssignmentInspectionKt.buildOperatorAssignmentText$appendTail(operationText + " " + ktExpression3.getText(), tail);
                $this$buildOperatorAssignmentText = object;
                variableExpression = ktExpression;
                expression = ktBinaryExpression;
                tail = string2;
            }
            string = tail;
        }
        return string;
    }

    private static final String buildOperatorAssignmentText$appendTail(String $this$buildOperatorAssignmentText_u24appendTail, String $tail) {
        return ((CharSequence)$tail).length() == 0 ? $this$buildOperatorAssignmentText_u24appendTail : $this$buildOperatorAssignmentText_u24appendTail + " " + $tail;
    }

    public static final /* synthetic */ boolean access$checkExpressionRepeat(KaSession $receiver, KtExpression variableExpression, KtBinaryExpression expression) {
        return ReplaceWithOperatorAssignmentInspectionKt.checkExpressionRepeat($receiver, variableExpression, expression);
    }

    public static final /* synthetic */ KtBinaryExpression access$buildOperatorAssignment(KaSession $receiver, KtBinaryExpression element) {
        return ReplaceWithOperatorAssignmentInspectionKt.buildOperatorAssignment($receiver, element);
    }

    public static final /* synthetic */ ProblemHighlightType access$getProblemHighlightType(KaSession $receiver, KtBinaryExpression element) {
        return ReplaceWithOperatorAssignmentInspectionKt.getProblemHighlightType($receiver, element);
    }
}

