/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.daemon.impl.GutterTooltipBuilder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0014J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tH\u0014J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0014J$\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0007H\u0014J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/markers/KotlinGutterTooltipHelper;", "Lcom/intellij/codeInsight/daemon/impl/GutterTooltipBuilder;", "<init>", "()V", "getLinkProtocol", "", "shouldSkipAsFirstElement", "", "element", "Lcom/intellij/psi/PsiElement;", "getLinkReferenceText", "getContainingElement", "getLocationString", "getPresentableName", "appendElement", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "skip", "isDeprecated", "kotlin.base.code-insight"})
@SourceDebugExtension(value={"SMAP\nKotlinGutterTooltipHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinGutterTooltipHelper.kt\norg/jetbrains/kotlin/idea/highlighter/markers/KotlinGutterTooltipHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class KotlinGutterTooltipHelper
extends GutterTooltipBuilder {
    @NotNull
    public static final KotlinGutterTooltipHelper INSTANCE = new KotlinGutterTooltipHelper();

    private KotlinGutterTooltipHelper() {
    }

    @NotNull
    protected String getLinkProtocol() {
        return "kotlinClass";
    }

    protected boolean shouldSkipAsFirstElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return LightClassUtilsKt.getUnwrapped((PsiElement)element) instanceof KtCallableDeclaration || LightClassUtilsKt.getUnwrapped((PsiElement)element) instanceof PsiMethod;
    }

    @Nullable
    protected String getLinkReferenceText(@NotNull PsiElement element) {
        String string;
        PsiElement el;
        Object moduleName;
        block11: {
            Object object;
            block10: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                object = GenericPsiUtils.getModule(element);
                if (object == null || (object = object.getName()) == null) break block10;
                Object it = object;
                boolean bl = false;
                String string2 = (String)it + ":";
                object = string2;
                if (string2 != null) break block11;
            }
            object = moduleName = "";
        }
        if ((el = LightClassUtilsKt.getUnwrapped((PsiElement)element)) instanceof PsiMethod) {
            PsiClass psiClass = ((PsiMethod)el).getContainingClass();
            string = psiClass != null ? psiClass.getQualifiedName() : null;
        } else if (el instanceof PsiClass) {
            string = ((PsiClass)el).getQualifiedName();
        } else if (el instanceof KtClass) {
            FqName fqName2 = ((KtClass)el).getFqName();
            string = fqName2 != null ? fqName2.asString() : null;
        } else {
            KtClass ktClass = (KtClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)el, KtClass.class);
            string = ktClass != null && (ktClass = ktClass.getFqName()) != null ? ktClass.asString() : null;
        }
        if (string == null) {
            return null;
        }
        String qualifiedName = string;
        return (String)moduleName + qualifiedName;
    }

    @Nullable
    protected PsiElement getContainingElement(@NotNull PsiElement element) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement unwrapped = LightClassUtilsKt.getUnwrapped((PsiElement)element);
        if (unwrapped instanceof PsiMember) {
            PsiMember psiMember = (PsiMember)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)unwrapped, PsiMember.class);
            return psiMember != null ? (PsiElement)psiMember : (PsiElement)((PsiMember)unwrapped).getContainingFile();
        }
        KtDeclaration member = null;
        member = unwrapped instanceof KtParameter ? (KtDeclaration)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)unwrapped, KtClass.class) : (KtDeclaration)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)unwrapped, KtDeclaration.class);
        if (member == null && unwrapped instanceof KtDeclaration) {
            member = (KtDeclaration)KtPsiUtilKt.containingClass((KtElement)((KtElement)unwrapped));
        }
        KtDeclaration ktDeclaration = member;
        if (ktDeclaration != null) {
            psiElement = (PsiElement)ktDeclaration;
        } else {
            PsiElement psiElement2 = unwrapped;
            psiElement = (PsiElement)(psiElement2 != null ? psiElement2.getContainingFile() : null);
        }
        return psiElement;
    }

    @Nullable
    protected String getLocationString(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = LightClassUtilsKt.getUnwrapped((PsiElement)element);
        KtClassOrObject ktClassOrObject = psiElement instanceof KtClassOrObject ? (KtClassOrObject)psiElement : null;
        if (ktClassOrObject == null) {
            return null;
        }
        KtClassOrObject classOrObject = ktClassOrObject;
        Object object = GenericPsiUtils.getModule(element);
        if (object == null || (object = object.getName()) == null) {
            return null;
        }
        Object moduleName = object;
        boolean moduleNameRequired = PsiUtilsKt.hasActualModifier((KtModifierListOwner)((KtModifierListOwner)classOrObject)) || KtPsiUtilKt.isExpectDeclaration((KtDeclaration)((KtDeclaration)classOrObject));
        return moduleNameRequired ? " [" + (String)moduleName + "]" : null;
    }

    @Nullable
    protected String getPresentableName(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiNamedElement psiNamedElement = element instanceof PsiNamedElement ? (PsiNamedElement)element : null;
        return psiNamedElement != null ? psiNamedElement.getName() : null;
    }

    protected void appendElement(@NotNull StringBuilder sb, @NotNull PsiElement element, boolean skip) {
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.appendElement(sb, element, skip);
        PsiFile file = element.getContainingFile();
        if (file instanceof PsiClassOwner) {
            GutterTooltipBuilder.appendPackageName((StringBuilder)sb, (String)((PsiClassOwner)file).getPackageName());
        }
    }

    protected boolean isDeprecated(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)element).isDeprecated();
    }
}

