; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -mtriple=amdgcn-- -passes=instcombine -S < %s | FileCheck -check-prefix=OPT %s
; RUN: opt -mtriple=amdgcn-- -mattr=+wavefrontsize32 -passes=instcombine -S < %s | FileCheck -check-prefix=OPT-W32 %s
; RUN: opt -mtriple=amdgcn-- -mattr=+wavefrontsize64 -passes=instcombine -S < %s | FileCheck -check-prefix=OPT-W64 %s
; RUN: opt -mtriple=amdgcn-- -mcpu=tonga -passes=instcombine -S < %s | FileCheck -check-prefix=OPT-W64 %s
; RUN: opt -mtriple=amdgcn-- -mcpu=gfx1010 -mattr=+wavefrontsize32 -passes=instcombine -S < %s | FileCheck -check-prefix=OPT-W32 %s
; RUN: opt -mtriple=amdgcn-- -mcpu=gfx1010 -mattr=+wavefrontsize64 -passes=instcombine -S < %s | FileCheck -check-prefix=OPT-W64 %s
; RUN: opt -mtriple=amdgcn-- -mcpu=gfx1100 -mattr=+wavefrontsize32 -passes=instcombine -S < %s | FileCheck -check-prefix=OPT-W32 %s
; RUN: opt -mtriple=amdgcn-- -mcpu=gfx1100 -mattr=+wavefrontsize64 -passes=instcombine -S < %s | FileCheck -check-prefix=OPT-W64 %s

define amdgpu_kernel void @fold_wavefrontsize(ptr addrspace(1) nocapture %arg) {
; OPT-LABEL: define amdgpu_kernel void @fold_wavefrontsize(
; OPT-SAME: ptr addrspace(1) captures(none) [[ARG:%.*]]) {
; OPT-NEXT:  [[BB:.*:]]
; OPT-NEXT:    [[TMP:%.*]] = tail call i32 @llvm.amdgcn.wavefrontsize() #[[ATTR1:[0-9]+]]
; OPT-NEXT:    store i32 [[TMP]], ptr addrspace(1) [[ARG]], align 4
; OPT-NEXT:    ret void
;
; OPT-W32-LABEL: define amdgpu_kernel void @fold_wavefrontsize(
; OPT-W32-SAME: ptr addrspace(1) captures(none) [[ARG:%.*]]) #[[ATTR0:[0-9]+]] {
; OPT-W32-NEXT:  [[BB:.*:]]
; OPT-W32-NEXT:    store i32 32, ptr addrspace(1) [[ARG]], align 4
; OPT-W32-NEXT:    ret void
;
; OPT-W64-LABEL: define amdgpu_kernel void @fold_wavefrontsize(
; OPT-W64-SAME: ptr addrspace(1) captures(none) [[ARG:%.*]]) #[[ATTR0:[0-9]+]] {
; OPT-W64-NEXT:  [[BB:.*:]]
; OPT-W64-NEXT:    store i32 64, ptr addrspace(1) [[ARG]], align 4
; OPT-W64-NEXT:    ret void
;
bb:
  %tmp = tail call i32 @llvm.amdgcn.wavefrontsize() #0
  store i32 %tmp, ptr addrspace(1) %arg, align 4
  ret void
}

define amdgpu_kernel void @fold_and_optimize_wavefrontsize(ptr addrspace(1) nocapture %arg) {
; OPT-LABEL: define amdgpu_kernel void @fold_and_optimize_wavefrontsize(
; OPT-SAME: ptr addrspace(1) captures(none) [[ARG:%.*]]) {
; OPT-NEXT:  [[BB:.*:]]
; OPT-NEXT:    [[TMP:%.*]] = tail call i32 @llvm.amdgcn.wavefrontsize() #[[ATTR1]]
; OPT-NEXT:    [[TMP1:%.*]] = icmp samesign ugt i32 [[TMP]], 32
; OPT-NEXT:    [[TMP2:%.*]] = select i1 [[TMP1]], i32 2, i32 1
; OPT-NEXT:    store i32 [[TMP2]], ptr addrspace(1) [[ARG]], align 4
; OPT-NEXT:    ret void
;
; OPT-W32-LABEL: define amdgpu_kernel void @fold_and_optimize_wavefrontsize(
; OPT-W32-SAME: ptr addrspace(1) captures(none) [[ARG:%.*]]) #[[ATTR0]] {
; OPT-W32-NEXT:  [[BB:.*:]]
; OPT-W32-NEXT:    store i32 1, ptr addrspace(1) [[ARG]], align 4
; OPT-W32-NEXT:    ret void
;
; OPT-W64-LABEL: define amdgpu_kernel void @fold_and_optimize_wavefrontsize(
; OPT-W64-SAME: ptr addrspace(1) captures(none) [[ARG:%.*]]) #[[ATTR0]] {
; OPT-W64-NEXT:  [[BB:.*:]]
; OPT-W64-NEXT:    store i32 2, ptr addrspace(1) [[ARG]], align 4
; OPT-W64-NEXT:    ret void
;
bb:
  %tmp = tail call i32 @llvm.amdgcn.wavefrontsize() #0
  %tmp1 = icmp ugt i32 %tmp, 32
  %tmp2 = select i1 %tmp1, i32 2, i32 1
  store i32 %tmp2, ptr addrspace(1) %arg
  ret void
}

define amdgpu_kernel void @fold_and_optimize_if_wavefrontsize(ptr addrspace(1) nocapture %arg) {
; OPT-LABEL: define amdgpu_kernel void @fold_and_optimize_if_wavefrontsize(
; OPT-SAME: ptr addrspace(1) captures(none) [[ARG:%.*]]) {
; OPT-NEXT:  [[BB:.*:]]
; OPT-NEXT:    [[TMP:%.*]] = tail call i32 @llvm.amdgcn.wavefrontsize() #[[ATTR1]]
; OPT-NEXT:    [[TMP1:%.*]] = icmp samesign ugt i32 [[TMP]], 32
; OPT-NEXT:    br i1 [[TMP1]], label %[[BB2:.*]], label %[[BB3:.*]]
; OPT:       [[BB2]]:
; OPT-NEXT:    store i32 1, ptr addrspace(1) [[ARG]], align 4
; OPT-NEXT:    br label %[[BB3]]
; OPT:       [[BB3]]:
; OPT-NEXT:    ret void
;
; OPT-W32-LABEL: define amdgpu_kernel void @fold_and_optimize_if_wavefrontsize(
; OPT-W32-SAME: ptr addrspace(1) captures(none) [[ARG:%.*]]) #[[ATTR0]] {
; OPT-W32-NEXT:  [[BB:.*:]]
; OPT-W32-NEXT:    br i1 false, label %[[BB2:.*]], label %[[BB3:.*]]
; OPT-W32:       [[BB2]]:
; OPT-W32-NEXT:    br label %[[BB3]]
; OPT-W32:       [[BB3]]:
; OPT-W32-NEXT:    ret void
;
; OPT-W64-LABEL: define amdgpu_kernel void @fold_and_optimize_if_wavefrontsize(
; OPT-W64-SAME: ptr addrspace(1) captures(none) [[ARG:%.*]]) #[[ATTR0]] {
; OPT-W64-NEXT:  [[BB:.*:]]
; OPT-W64-NEXT:    br i1 true, label %[[BB2:.*]], label %[[BB3:.*]]
; OPT-W64:       [[BB2]]:
; OPT-W64-NEXT:    store i32 1, ptr addrspace(1) [[ARG]], align 4
; OPT-W64-NEXT:    br label %[[BB3]]
; OPT-W64:       [[BB3]]:
; OPT-W64-NEXT:    ret void
;
bb:
  %tmp = tail call i32 @llvm.amdgcn.wavefrontsize() #0
  %tmp1 = icmp ugt i32 %tmp, 32
  br i1 %tmp1, label %bb2, label %bb3

bb2:                                              ; preds = %bb
  store i32 1, ptr addrspace(1) %arg, align 4
  br label %bb3

bb3:                                              ; preds = %bb2, %bb
  ret void
}

declare i32 @llvm.amdgcn.wavefrontsize() #0

attributes #0 = { nounwind readnone speculatable }
