; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=dse < %s | FileCheck %s

declare void @llvm.memcpy.p0.p0.i8(ptr nocapture, ptr nocapture, i8, i1) nounwind
declare void @llvm.memcpy.inline.p0.p0.i8(ptr nocapture, ptr nocapture, i8, i1) nounwind
declare void @llvm.memmove.p0.p0.i8(ptr nocapture, ptr nocapture, i8, i1) nounwind
declare void @llvm.memset.p0.i8(ptr nocapture, i8, i8, i1) nounwind

define void @test1(ptr noalias %A, ptr noalias %B) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i8(ptr [[A:%.*]], ptr [[B:%.*]], i8 12, i1 false)
; CHECK-NEXT:    ret void
;
  store i8 0, ptr %A  ;; Written to by memcpy

  call void @llvm.memcpy.p0.p0.i8(ptr %A, ptr %B, i8 12, i1 false)

  ret void
}

define void @test2(ptr noalias %A, ptr noalias %B) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    call void @llvm.memmove.p0.p0.i8(ptr [[A]], ptr [[B:%.*]], i8 12, i1 false)
; CHECK-NEXT:    ret void
;
  store i8 0, ptr %A  ;; Written to by memmove

  call void @llvm.memmove.p0.p0.i8(ptr %A, ptr %B, i8 12, i1 false)

  ret void
}

define void @test2a(ptr %A, ptr %B) {
; CHECK-LABEL: @test2a(
; CHECK-NEXT:    store i8 0, ptr [[A:%.*]], align 1
; CHECK-NEXT:    call void @llvm.memmove.p0.p0.i8(ptr [[A]], ptr [[B:%.*]], i8 12, i1 false)
; CHECK-NEXT:    ret void
;
  store i8 0, ptr %A  ;; Written to by memmove

  call void @llvm.memmove.p0.p0.i8(ptr %A, ptr %B, i8 12, i1 false)

  ret void
}

define void @test3(ptr noalias %A) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    call void @llvm.memset.p0.i8(ptr [[A:%.*]], i8 0, i8 12, i1 false)
; CHECK-NEXT:    ret void
;
  store i8 0, ptr %A  ;; Written to by memset

  call void @llvm.memset.p0.i8(ptr %A, i8 0, i8 12, i1 false)

  ret void
}

declare void @llvm.memcpy.element.unordered.atomic.p0.p0.i16(ptr nocapture, ptr nocapture, i16, i32) nounwind
declare void @llvm.memmove.element.unordered.atomic.p0.p0.i16(ptr nocapture, ptr nocapture, i16, i32) nounwind
declare void @llvm.memset.element.unordered.atomic.p0.i16(ptr nocapture, i8, i16, i32) nounwind


define void @test4() {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    ret void
;
  %A = alloca i16, i16 1024, align 2
  %B = alloca i16, i16 1024, align 2

  store atomic i16 0, ptr %A unordered, align 2 ;; Written to by memcpy
  store atomic i16 0, ptr %B unordered, align 2 ;; Read by memcpy

  call void @llvm.memcpy.element.unordered.atomic.p0.p0.i16(ptr align 2 %A, ptr align 2 %B, i16 1024, i32 2)

  ret void
}

define void @test5() {
; CHECK-LABEL: @test5(
; CHECK-NEXT:    ret void
;
  %A = alloca i16, i16 1024, align 2
  %B = alloca i16, i16 1024, align 2

  store atomic i16 0, ptr %A unordered, align 2 ;; Written to by memmove
  store atomic i16 0, ptr %B unordered, align 2 ;; Read by memmove

  call void @llvm.memmove.element.unordered.atomic.p0.p0.i16(ptr align 2 %A, ptr align 2 %B, i16 1024, i32 2)

  ret void
}

define void @test6() {
; CHECK-LABEL: @test6(
; CHECK-NEXT:    [[B:%.*]] = alloca i16, i16 1024, align 2
; CHECK-NEXT:    ret void
;
  %A = alloca i16, i16 1024, align 2
  %B = alloca i16, i16 1024, align 2

  store atomic i16 0, ptr %A unordered, align 2 ;; Written to by memset

  call void @llvm.memset.element.unordered.atomic.p0.i16(ptr align 2 %A, i8 0, i16 1024, i32 2)

  ret void
}

define void @test7(ptr noalias %A, ptr noalias %B) {
; CHECK-LABEL: @test7(
; CHECK-NEXT:    call void @llvm.memcpy.inline.p0.p0.i8(ptr [[A:%.*]], ptr [[B:%.*]], i8 12, i1 false)
; CHECK-NEXT:    ret void
;
  store i8 0, ptr %A  ;; Written to by memcpy

  call void @llvm.memcpy.inline.p0.p0.i8(ptr %A, ptr %B, i8 12, i1 false)

  ret void
}
