; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
target datalayout = "E-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v128:128:128-n32:64"
target triple = "powerpc64-unknown-linux-gnu"
; RUN: llc -ppc-gpr-icmps=all -verify-machineinstrs -O2 -ppc-asm-full-reg-names -mcpu=pwr7 -mattr=-isel < %s | FileCheck %s --implicit-check-not isel

define signext i32 @testExpandISELToIfElse(i32 signext %i, i32 signext %j) {
; CHECK-LABEL: testExpandISELToIfElse:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r3, 0
; CHECK-NEXT:    ble cr0, .LBB0_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    addi r4, r3, 1
; CHECK-NEXT:  .LBB0_2: # %entry
; CHECK-NEXT:    extsw r3, r4
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i32 %i, 0
  %add = add nsw i32 %i, 1
  %cond = select i1 %cmp, i32 %add, i32 %j
  ret i32 %cond

}

define signext i32 @testExpandISELToIf(i32 signext %i, i32 signext %j) {
; CHECK-LABEL: testExpandISELToIf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r3, 0
; CHECK-NEXT:    bgt cr0, .LBB1_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mr r4, r3
; CHECK-NEXT:  .LBB1_2: # %entry
; CHECK-NEXT:    mr r3, r4
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i32 %i, 0
  %cond = select i1 %cmp, i32 %j, i32 %i
  ret i32 %cond

}

define signext i32 @testExpandISELToElse(i32 signext %i, i32 signext %j) {
; CHECK-LABEL: testExpandISELToElse:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r3, 0
; CHECK-NEXT:    bgtlr cr0
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mr r3, r4
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i32 %i, 0
  %cond = select i1 %cmp, i32 %i, i32 %j
  ret i32 %cond

}

define signext i32 @testExpandISELToNull(i32 signext %i, i32 signext %j) {
; CHECK-LABEL: testExpandISELToNull:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i32 %i, 0
  %cond = select i1 %cmp, i32 %i, i32 %i
  ret i32 %cond

}

define signext i32 @testExpandISELsTo2ORIs2ADDIs(i32 signext %a, i32 signext %b, i32 signext %d, i32 signext %f, i32 signext %g) {
; CHECK-LABEL: testExpandISELsTo2ORIs2ADDIs:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r7, 0
; CHECK-NEXT:    bgt cr0, .LBB4_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mr r7, r4
; CHECK-NEXT:  .LBB4_2: # %entry
; CHECK-NEXT:    bgt cr0, .LBB4_4
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    mr r5, r6
; CHECK-NEXT:  .LBB4_4: # %entry
; CHECK-NEXT:    add r3, r7, r5
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i32 %g, 0
  %a.b = select i1 %cmp, i32 %g, i32 %b
  %d.f = select i1 %cmp, i32 %d, i32 %f
  %add = add nsw i32 %a.b, %d.f
  ret i32 %add
}

define signext i32 @testExpandISELsTo2ORIs1ADDI(i32 signext %a, i32 signext %b, i32 signext %d, i32 signext %f, i32 signext %g) {
; CHECK-LABEL: testExpandISELsTo2ORIs1ADDI:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r7, 0
; CHECK-NEXT:    bgt cr0, .LBB5_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mr r3, r4
; CHECK-NEXT:  .LBB5_2: # %entry
; CHECK-NEXT:    bgt cr0, .LBB5_4
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    mr r5, r6
; CHECK-NEXT:  .LBB5_4: # %entry
; CHECK-NEXT:    add r3, r3, r5
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i32 %g, 0
  %a.b = select i1 %cmp, i32 %a, i32 %b
  %d.f = select i1 %cmp, i32 %d, i32 %f
  %add = add nsw i32 %a.b, %d.f
  ret i32 %add
}

define signext i32 @testExpandISELsTo1ORI1ADDI(i32 signext %a, i32 signext %b, i32 signext %d, i32 signext %f, i32 signext %g) {
; CHECK-LABEL: testExpandISELsTo1ORI1ADDI:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r7, 0
; CHECK-NEXT:    mr r7, r3
; CHECK-NEXT:    bgt cr0, .LBB6_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mr r7, r4
; CHECK-NEXT:  .LBB6_2: # %entry
; CHECK-NEXT:    bgt cr0, .LBB6_4
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    mr r5, r6
; CHECK-NEXT:  .LBB6_4: # %entry
; CHECK-NEXT:    add r4, r7, r5
; CHECK-NEXT:    add r3, r3, r4
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i32 %g, 0
  %a.b = select i1 %cmp, i32 %a, i32 %b
  %d.f = select i1 %cmp, i32 %d, i32 %f
  %add1 = add nsw i32 %a.b, %d.f
  %add2 = add nsw i32 %a, %add1
  ret i32 %add2
}

define signext i32 @testExpandISELsTo0ORI2ADDIs(i32 signext %a, i32 signext %b, i32 signext %d, i32 signext %f, i32 signext %g) {
; CHECK-LABEL: testExpandISELsTo0ORI2ADDIs:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r7, 0
; CHECK-NEXT:    mr r7, r3
; CHECK-NEXT:    bgt cr0, .LBB7_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    mr r7, r4
; CHECK-NEXT:  .LBB7_2: # %entry
; CHECK-NEXT:    mr r4, r5
; CHECK-NEXT:    bgt cr0, .LBB7_4
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    mr r4, r6
; CHECK-NEXT:  .LBB7_4: # %entry
; CHECK-NEXT:    add r4, r7, r4
; CHECK-NEXT:    add r3, r3, r4
; CHECK-NEXT:    sub r3, r3, r5
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i32 %g, 0
  %a.b = select i1 %cmp, i32 %a, i32 %b
  %d.f = select i1 %cmp, i32 %d, i32 %f
  %add1 = add nsw i32 %a.b, %d.f
  %add2 = add nsw i32 %a, %add1
  %sub1 = sub nsw i32 %add2, %d
  ret i32 %sub1
}

@b = local_unnamed_addr global i32 0, align 4
@a = local_unnamed_addr global i32 0, align 4
; Function Attrs: norecurse nounwind readonly
define signext i32 @testComplexISEL() #0 {
; CHECK-LABEL: testComplexISEL:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, .LC0@toc@ha
; CHECK-NEXT:    ld r3, .LC0@toc@l(r3)
; CHECK-NEXT:    lwz r4, 0(r3)
; CHECK-NEXT:    li r3, 1
; CHECK-NEXT:    cmplwi r4, 0
; CHECK-NEXT:    bnelr cr0
; CHECK-NEXT:  # %bb.1: # %if.end
; CHECK-NEXT:    addis r3, r2, .LC1@toc@ha
; CHECK-NEXT:    addis r4, r2, .LC2@toc@ha
; CHECK-NEXT:    ld r3, .LC1@toc@l(r3)
; CHECK-NEXT:    ld r4, .LC2@toc@l(r4)
; CHECK-NEXT:    lwa r3, 0(r3)
; CHECK-NEXT:    xor r3, r3, r4
; CHECK-NEXT:    cntlzd r3, r3
; CHECK-NEXT:    rldicl r3, r3, 58, 63
; CHECK-NEXT:    blr
entry:
  %0 = load i32, ptr @b, align 4, !tbaa !1
  %tobool = icmp eq i32 %0, 0
  br i1 %tobool, label %if.end, label %cleanup

if.end:
  %1 = load i32, ptr @a, align 4, !tbaa !1
  %conv = sext i32 %1 to i64
  %2 = inttoptr i64 %conv to ptr
  %cmp = icmp eq ptr %2, @testComplexISEL
  %conv3 = zext i1 %cmp to i32
  br label %cleanup

cleanup:
  %retval.0 = phi i32 [ %conv3, %if.end ], [ 1, %entry ]
  ret i32 %retval.0

}

!1 = !{!2, !2, i64 0}
!2 = !{!"int", !3, i64 0}
!3 = !{!"omnipotent char", !4, i64 0}
!4 = !{!"Simple C/C++ TBAA"}
