; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck --check-prefix=GFX9 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=hawaii -verify-machineinstrs < %s | FileCheck --check-prefix=GFX7 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=tahiti -verify-machineinstrs < %s | FileCheck --check-prefix=GFX6 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck --check-prefix=GFX10 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck --check-prefix=GFX11 %s

define amdgpu_kernel void @store_lds_v4i32(ptr addrspace(3) %out, <4 x i32> %x) {
; GFX9-LABEL: store_lds_v4i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v4, s6
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-NEXT:    ds_write_b128 v4, v[0:3]
; GFX9-NEXT:    s_endpgm
;
; GFX7-LABEL: store_lds_v4i32:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, s6
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    ds_write_b128 v4, v[0:3]
; GFX7-NEXT:    s_endpgm
;
; GFX6-LABEL: store_lds_v4i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4
; GFX6-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s2
; GFX6-NEXT:    v_mov_b32_e32 v1, s3
; GFX6-NEXT:    v_mov_b32_e32 v4, s4
; GFX6-NEXT:    v_mov_b32_e32 v2, s0
; GFX6-NEXT:    v_mov_b32_e32 v3, s1
; GFX6-NEXT:    ds_write2_b64 v4, v[2:3], v[0:1] offset1:1
; GFX6-NEXT:    s_endpgm
;
; GFX10-LABEL: store_lds_v4i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, s6
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-NEXT:    v_mov_b32_e32 v3, s3
; GFX10-NEXT:    ds_write_b128 v4, v[0:3]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_lds_v4i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s6, s[4:5], 0x0
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x10
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, s6
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v1, s1 :: v_dual_mov_b32 v2, s2
; GFX11-NEXT:    ds_store_b128 v4, v[0:3]
; GFX11-NEXT:    s_endpgm
  store <4 x i32> %x, ptr addrspace(3) %out
  ret void
}

define amdgpu_kernel void @store_lds_v4i32_align1(ptr addrspace(3) %out, <4 x i32> %x) {
; GFX9-LABEL: store_lds_v4i32_align1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    ds_write_b8 v0, v1 offset:12
; GFX9-NEXT:    ds_write_b8_d16_hi v0, v1 offset:14
; GFX9-NEXT:    ds_write_b8 v0, v2 offset:8
; GFX9-NEXT:    ds_write_b8_d16_hi v0, v2 offset:10
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    ds_write_b8 v0, v1 offset:4
; GFX9-NEXT:    ds_write_b8_d16_hi v0, v1 offset:6
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    s_lshr_b32 s4, s3, 8
; GFX9-NEXT:    ds_write_b8 v0, v1
; GFX9-NEXT:    ds_write_b8_d16_hi v0, v1 offset:2
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    s_lshr_b32 s3, s3, 24
; GFX9-NEXT:    ds_write_b8 v0, v1 offset:13
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    s_lshr_b32 s3, s2, 8
; GFX9-NEXT:    ds_write_b8 v0, v1 offset:15
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    s_lshr_b32 s2, s2, 24
; GFX9-NEXT:    ds_write_b8 v0, v1 offset:9
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    s_lshr_b32 s2, s1, 8
; GFX9-NEXT:    ds_write_b8 v0, v1 offset:11
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    s_lshr_b32 s1, s1, 24
; GFX9-NEXT:    ds_write_b8 v0, v1 offset:5
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    s_lshr_b32 s1, s0, 8
; GFX9-NEXT:    ds_write_b8 v0, v1 offset:7
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    s_lshr_b32 s0, s0, 24
; GFX9-NEXT:    ds_write_b8 v0, v1 offset:1
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    ds_write_b8 v0, v1 offset:3
; GFX9-NEXT:    s_endpgm
;
; GFX7-LABEL: store_lds_v4i32_align1:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    ds_write_b8 v0, v1 offset:12
; GFX7-NEXT:    ds_write_b8 v0, v2 offset:8
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    ds_write_b8 v0, v1 offset:4
; GFX7-NEXT:    v_mov_b32_e32 v1, s0
; GFX7-NEXT:    s_lshr_b32 s4, s3, 8
; GFX7-NEXT:    ds_write_b8 v0, v1
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    s_lshr_b32 s4, s3, 24
; GFX7-NEXT:    ds_write_b8 v0, v1 offset:13
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    s_lshr_b32 s3, s3, 16
; GFX7-NEXT:    ds_write_b8 v0, v1 offset:15
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshr_b32 s3, s2, 8
; GFX7-NEXT:    ds_write_b8 v0, v1 offset:14
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshr_b32 s3, s2, 24
; GFX7-NEXT:    ds_write_b8 v0, v1 offset:9
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshr_b32 s2, s2, 16
; GFX7-NEXT:    ds_write_b8 v0, v1 offset:11
; GFX7-NEXT:    v_mov_b32_e32 v1, s2
; GFX7-NEXT:    s_lshr_b32 s2, s1, 8
; GFX7-NEXT:    ds_write_b8 v0, v1 offset:10
; GFX7-NEXT:    v_mov_b32_e32 v1, s2
; GFX7-NEXT:    s_lshr_b32 s2, s1, 24
; GFX7-NEXT:    ds_write_b8 v0, v1 offset:5
; GFX7-NEXT:    v_mov_b32_e32 v1, s2
; GFX7-NEXT:    s_lshr_b32 s1, s1, 16
; GFX7-NEXT:    ds_write_b8 v0, v1 offset:7
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    s_lshr_b32 s1, s0, 8
; GFX7-NEXT:    ds_write_b8 v0, v1 offset:6
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    s_lshr_b32 s1, s0, 24
; GFX7-NEXT:    ds_write_b8 v0, v1 offset:1
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    s_lshr_b32 s0, s0, 16
; GFX7-NEXT:    ds_write_b8 v0, v1 offset:3
; GFX7-NEXT:    v_mov_b32_e32 v1, s0
; GFX7-NEXT:    ds_write_b8 v0, v1 offset:2
; GFX7-NEXT:    s_endpgm
;
; GFX6-LABEL: store_lds_v4i32_align1:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s3
; GFX6-NEXT:    v_mov_b32_e32 v2, s2
; GFX6-NEXT:    ds_write_b8 v0, v1 offset:12
; GFX6-NEXT:    ds_write_b8 v0, v2 offset:8
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    ds_write_b8 v0, v1 offset:4
; GFX6-NEXT:    v_mov_b32_e32 v1, s0
; GFX6-NEXT:    s_lshr_b32 s4, s3, 8
; GFX6-NEXT:    ds_write_b8 v0, v1
; GFX6-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-NEXT:    s_lshr_b32 s4, s3, 24
; GFX6-NEXT:    ds_write_b8 v0, v1 offset:13
; GFX6-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-NEXT:    s_lshr_b32 s3, s3, 16
; GFX6-NEXT:    ds_write_b8 v0, v1 offset:15
; GFX6-NEXT:    v_mov_b32_e32 v1, s3
; GFX6-NEXT:    s_lshr_b32 s3, s2, 8
; GFX6-NEXT:    ds_write_b8 v0, v1 offset:14
; GFX6-NEXT:    v_mov_b32_e32 v1, s3
; GFX6-NEXT:    s_lshr_b32 s3, s2, 24
; GFX6-NEXT:    ds_write_b8 v0, v1 offset:9
; GFX6-NEXT:    v_mov_b32_e32 v1, s3
; GFX6-NEXT:    s_lshr_b32 s2, s2, 16
; GFX6-NEXT:    ds_write_b8 v0, v1 offset:11
; GFX6-NEXT:    v_mov_b32_e32 v1, s2
; GFX6-NEXT:    s_lshr_b32 s2, s1, 8
; GFX6-NEXT:    ds_write_b8 v0, v1 offset:10
; GFX6-NEXT:    v_mov_b32_e32 v1, s2
; GFX6-NEXT:    s_lshr_b32 s2, s1, 24
; GFX6-NEXT:    ds_write_b8 v0, v1 offset:5
; GFX6-NEXT:    v_mov_b32_e32 v1, s2
; GFX6-NEXT:    s_lshr_b32 s1, s1, 16
; GFX6-NEXT:    ds_write_b8 v0, v1 offset:7
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    s_lshr_b32 s1, s0, 8
; GFX6-NEXT:    ds_write_b8 v0, v1 offset:6
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    s_lshr_b32 s1, s0, 24
; GFX6-NEXT:    ds_write_b8 v0, v1 offset:1
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    s_lshr_b32 s0, s0, 16
; GFX6-NEXT:    ds_write_b8 v0, v1 offset:3
; GFX6-NEXT:    v_mov_b32_e32 v1, s0
; GFX6-NEXT:    ds_write_b8 v0, v1 offset:2
; GFX6-NEXT:    s_endpgm
;
; GFX10-LABEL: store_lds_v4i32_align1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-NEXT:    v_mov_b32_e32 v1, s3
; GFX10-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-NEXT:    s_lshr_b32 s5, s2, 8
; GFX10-NEXT:    s_lshr_b32 s2, s2, 24
; GFX10-NEXT:    v_mov_b32_e32 v3, s1
; GFX10-NEXT:    s_lshr_b32 s4, s3, 8
; GFX10-NEXT:    s_lshr_b32 s3, s3, 24
; GFX10-NEXT:    s_lshr_b32 s6, s1, 8
; GFX10-NEXT:    s_lshr_b32 s1, s1, 24
; GFX10-NEXT:    v_mov_b32_e32 v8, s2
; GFX10-NEXT:    v_mov_b32_e32 v4, s0
; GFX10-NEXT:    v_mov_b32_e32 v5, s4
; GFX10-NEXT:    v_mov_b32_e32 v6, s3
; GFX10-NEXT:    v_mov_b32_e32 v7, s5
; GFX10-NEXT:    v_mov_b32_e32 v9, s6
; GFX10-NEXT:    ds_write_b8 v0, v1 offset:12
; GFX10-NEXT:    ds_write_b8_d16_hi v0, v1 offset:14
; GFX10-NEXT:    ds_write_b8 v0, v2 offset:8
; GFX10-NEXT:    ds_write_b8_d16_hi v0, v2 offset:10
; GFX10-NEXT:    ds_write_b8 v0, v3 offset:4
; GFX10-NEXT:    ds_write_b8_d16_hi v0, v3 offset:6
; GFX10-NEXT:    ds_write_b8 v0, v4
; GFX10-NEXT:    ds_write_b8_d16_hi v0, v4 offset:2
; GFX10-NEXT:    ds_write_b8 v0, v5 offset:13
; GFX10-NEXT:    ds_write_b8 v0, v6 offset:15
; GFX10-NEXT:    ds_write_b8 v0, v7 offset:9
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    s_lshr_b32 s1, s0, 8
; GFX10-NEXT:    s_lshr_b32 s0, s0, 24
; GFX10-NEXT:    v_mov_b32_e32 v2, s1
; GFX10-NEXT:    v_mov_b32_e32 v3, s0
; GFX10-NEXT:    ds_write_b8 v0, v8 offset:11
; GFX10-NEXT:    ds_write_b8 v0, v9 offset:5
; GFX10-NEXT:    ds_write_b8 v0, v1 offset:7
; GFX10-NEXT:    ds_write_b8 v0, v2 offset:1
; GFX10-NEXT:    ds_write_b8 v0, v3 offset:3
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_lds_v4i32_align1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s6, s[4:5], 0x0
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x10
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s3
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s1
; GFX11-NEXT:    s_lshr_b32 s4, s3, 8
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v4, s0 :: v_dual_mov_b32 v5, s4
; GFX11-NEXT:    s_lshr_b32 s5, s2, 8
; GFX11-NEXT:    s_lshr_b32 s2, s2, 24
; GFX11-NEXT:    s_lshr_b32 s6, s1, 8
; GFX11-NEXT:    s_lshr_b32 s3, s3, 24
; GFX11-NEXT:    s_lshr_b32 s1, s1, 24
; GFX11-NEXT:    s_lshr_b32 s7, s0, 8
; GFX11-NEXT:    s_lshr_b32 s0, s0, 24
; GFX11-NEXT:    v_dual_mov_b32 v8, s2 :: v_dual_mov_b32 v9, s6
; GFX11-NEXT:    v_dual_mov_b32 v6, s3 :: v_dual_mov_b32 v7, s5
; GFX11-NEXT:    v_mov_b32_e32 v10, s1
; GFX11-NEXT:    ds_store_b8 v0, v2 offset:8
; GFX11-NEXT:    ds_store_b8_d16_hi v0, v2 offset:10
; GFX11-NEXT:    ds_store_b8 v0, v1 offset:12
; GFX11-NEXT:    ds_store_b8_d16_hi v0, v1 offset:14
; GFX11-NEXT:    ds_store_b8 v0, v5 offset:13
; GFX11-NEXT:    ds_store_b8 v0, v6 offset:15
; GFX11-NEXT:    ds_store_b8 v0, v7 offset:9
; GFX11-NEXT:    ds_store_b8 v0, v8 offset:11
; GFX11-NEXT:    v_dual_mov_b32 v1, s7 :: v_dual_mov_b32 v2, s0
; GFX11-NEXT:    ds_store_b8 v0, v4
; GFX11-NEXT:    ds_store_b8_d16_hi v0, v4 offset:2
; GFX11-NEXT:    ds_store_b8 v0, v3 offset:4
; GFX11-NEXT:    ds_store_b8_d16_hi v0, v3 offset:6
; GFX11-NEXT:    ds_store_b8 v0, v9 offset:5
; GFX11-NEXT:    ds_store_b8 v0, v10 offset:7
; GFX11-NEXT:    ds_store_b8 v0, v1 offset:1
; GFX11-NEXT:    ds_store_b8 v0, v2 offset:3
; GFX11-NEXT:    s_endpgm
  store <4 x i32> %x, ptr addrspace(3) %out, align 1
  ret void
}

define amdgpu_kernel void @store_lds_v4i32_align2(ptr addrspace(3) %out, <4 x i32> %x) {
; GFX9-LABEL: store_lds_v4i32_align2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    ds_write_b16 v0, v1 offset:12
; GFX9-NEXT:    ds_write_b16_d16_hi v0, v1 offset:14
; GFX9-NEXT:    ds_write_b16 v0, v2 offset:8
; GFX9-NEXT:    ds_write_b16_d16_hi v0, v2 offset:10
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    ds_write_b16 v0, v1 offset:4
; GFX9-NEXT:    ds_write_b16_d16_hi v0, v1 offset:6
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    ds_write_b16 v0, v1
; GFX9-NEXT:    ds_write_b16_d16_hi v0, v1 offset:2
; GFX9-NEXT:    s_endpgm
;
; GFX7-LABEL: store_lds_v4i32_align2:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    ds_write_b16 v0, v1 offset:12
; GFX7-NEXT:    ds_write_b16 v0, v2 offset:8
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    ds_write_b16 v0, v1 offset:4
; GFX7-NEXT:    v_mov_b32_e32 v1, s0
; GFX7-NEXT:    s_lshr_b32 s3, s3, 16
; GFX7-NEXT:    ds_write_b16 v0, v1
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshr_b32 s2, s2, 16
; GFX7-NEXT:    ds_write_b16 v0, v1 offset:14
; GFX7-NEXT:    v_mov_b32_e32 v1, s2
; GFX7-NEXT:    s_lshr_b32 s1, s1, 16
; GFX7-NEXT:    ds_write_b16 v0, v1 offset:10
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    s_lshr_b32 s0, s0, 16
; GFX7-NEXT:    ds_write_b16 v0, v1 offset:6
; GFX7-NEXT:    v_mov_b32_e32 v1, s0
; GFX7-NEXT:    ds_write_b16 v0, v1 offset:2
; GFX7-NEXT:    s_endpgm
;
; GFX6-LABEL: store_lds_v4i32_align2:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s3
; GFX6-NEXT:    v_mov_b32_e32 v2, s2
; GFX6-NEXT:    ds_write_b16 v0, v1 offset:12
; GFX6-NEXT:    ds_write_b16 v0, v2 offset:8
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    ds_write_b16 v0, v1 offset:4
; GFX6-NEXT:    v_mov_b32_e32 v1, s0
; GFX6-NEXT:    s_lshr_b32 s3, s3, 16
; GFX6-NEXT:    ds_write_b16 v0, v1
; GFX6-NEXT:    v_mov_b32_e32 v1, s3
; GFX6-NEXT:    s_lshr_b32 s2, s2, 16
; GFX6-NEXT:    ds_write_b16 v0, v1 offset:14
; GFX6-NEXT:    v_mov_b32_e32 v1, s2
; GFX6-NEXT:    s_lshr_b32 s1, s1, 16
; GFX6-NEXT:    ds_write_b16 v0, v1 offset:10
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    s_lshr_b32 s0, s0, 16
; GFX6-NEXT:    ds_write_b16 v0, v1 offset:6
; GFX6-NEXT:    v_mov_b32_e32 v1, s0
; GFX6-NEXT:    ds_write_b16 v0, v1 offset:2
; GFX6-NEXT:    s_endpgm
;
; GFX10-LABEL: store_lds_v4i32_align2:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-NEXT:    v_mov_b32_e32 v1, s3
; GFX10-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-NEXT:    v_mov_b32_e32 v3, s1
; GFX10-NEXT:    v_mov_b32_e32 v4, s0
; GFX10-NEXT:    ds_write_b16 v0, v1 offset:12
; GFX10-NEXT:    ds_write_b16_d16_hi v0, v1 offset:14
; GFX10-NEXT:    ds_write_b16 v0, v2 offset:8
; GFX10-NEXT:    ds_write_b16_d16_hi v0, v2 offset:10
; GFX10-NEXT:    ds_write_b16 v0, v3 offset:4
; GFX10-NEXT:    ds_write_b16_d16_hi v0, v3 offset:6
; GFX10-NEXT:    ds_write_b16 v0, v4
; GFX10-NEXT:    ds_write_b16_d16_hi v0, v4 offset:2
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_lds_v4i32_align2:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s6, s[4:5], 0x0
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x10
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s0
; GFX11-NEXT:    v_dual_mov_b32 v2, s1 :: v_dual_mov_b32 v3, s2
; GFX11-NEXT:    v_mov_b32_e32 v4, s3
; GFX11-NEXT:    ds_store_b16 v0, v1
; GFX11-NEXT:    ds_store_b16 v0, v2 offset:4
; GFX11-NEXT:    ds_store_b16 v0, v3 offset:8
; GFX11-NEXT:    ds_store_b16 v0, v4 offset:12
; GFX11-NEXT:    ds_store_b16_d16_hi v0, v4 offset:14
; GFX11-NEXT:    ds_store_b16_d16_hi v0, v3 offset:10
; GFX11-NEXT:    ds_store_b16_d16_hi v0, v2 offset:6
; GFX11-NEXT:    ds_store_b16_d16_hi v0, v1 offset:2
; GFX11-NEXT:    s_endpgm
  store <4 x i32> %x, ptr addrspace(3) %out, align 2
  ret void
}

define amdgpu_kernel void @store_lds_v4i32_align4(ptr addrspace(3) %out, <4 x i32> %x) {
; GFX9-LABEL: store_lds_v4i32_align4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    v_mov_b32_e32 v3, s2
; GFX9-NEXT:    ds_write2_b32 v0, v1, v2 offset1:1
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    ds_write2_b32 v0, v3, v1 offset0:2 offset1:3
; GFX9-NEXT:    s_endpgm
;
; GFX7-LABEL: store_lds_v4i32_align4:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s0
; GFX7-NEXT:    v_mov_b32_e32 v2, s1
; GFX7-NEXT:    ds_write2_b32 v0, v1, v2 offset1:1
; GFX7-NEXT:    v_mov_b32_e32 v1, s2
; GFX7-NEXT:    v_mov_b32_e32 v2, s3
; GFX7-NEXT:    ds_write2_b32 v0, v1, v2 offset0:2 offset1:3
; GFX7-NEXT:    s_endpgm
;
; GFX6-LABEL: store_lds_v4i32_align4:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s2
; GFX6-NEXT:    v_mov_b32_e32 v2, s3
; GFX6-NEXT:    ds_write2_b32 v0, v1, v2 offset0:2 offset1:3
; GFX6-NEXT:    v_mov_b32_e32 v1, s0
; GFX6-NEXT:    v_mov_b32_e32 v2, s1
; GFX6-NEXT:    ds_write2_b32 v0, v1, v2 offset1:1
; GFX6-NEXT:    s_endpgm
;
; GFX10-LABEL: store_lds_v4i32_align4:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-NEXT:    v_mov_b32_e32 v1, s2
; GFX10-NEXT:    v_mov_b32_e32 v2, s3
; GFX10-NEXT:    v_mov_b32_e32 v3, s0
; GFX10-NEXT:    v_mov_b32_e32 v4, s1
; GFX10-NEXT:    ds_write2_b32 v0, v1, v2 offset0:2 offset1:3
; GFX10-NEXT:    ds_write2_b32 v0, v3, v4 offset1:1
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_lds_v4i32_align4:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s6, s[4:5], 0x0
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x10
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s0
; GFX11-NEXT:    v_dual_mov_b32 v2, s1 :: v_dual_mov_b32 v3, s2
; GFX11-NEXT:    v_mov_b32_e32 v4, s3
; GFX11-NEXT:    ds_store_2addr_b32 v0, v1, v2 offset1:1
; GFX11-NEXT:    ds_store_2addr_b32 v0, v3, v4 offset0:2 offset1:3
; GFX11-NEXT:    s_endpgm
  store <4 x i32> %x, ptr addrspace(3) %out, align 4
  ret void
}

define amdgpu_kernel void @store_lds_v4i32_align8(ptr addrspace(3) %out, <4 x i32> %x) {
; GFX9-LABEL: store_lds_v4i32_align8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v4, s6
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-NEXT:    ds_write2_b64 v4, v[0:1], v[2:3] offset1:1
; GFX9-NEXT:    s_endpgm
;
; GFX7-LABEL: store_lds_v4i32_align8:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, s6
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    ds_write2_b64 v4, v[0:1], v[2:3] offset1:1
; GFX7-NEXT:    s_endpgm
;
; GFX6-LABEL: store_lds_v4i32_align8:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4
; GFX6-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s0
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    v_mov_b32_e32 v4, s4
; GFX6-NEXT:    v_mov_b32_e32 v2, s2
; GFX6-NEXT:    v_mov_b32_e32 v3, s3
; GFX6-NEXT:    ds_write2_b64 v4, v[0:1], v[2:3] offset1:1
; GFX6-NEXT:    s_endpgm
;
; GFX10-LABEL: store_lds_v4i32_align8:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; GFX10-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_mov_b32_e32 v4, s6
; GFX10-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-NEXT:    v_mov_b32_e32 v3, s3
; GFX10-NEXT:    ds_write2_b64 v4, v[0:1], v[2:3] offset1:1
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_lds_v4i32_align8:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s6, s[4:5], 0x0
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x10
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, s6
; GFX11-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_mov_b32_e32 v3, s3
; GFX11-NEXT:    ds_store_2addr_b64 v4, v[0:1], v[2:3] offset1:1
; GFX11-NEXT:    s_endpgm
  store <4 x i32> %x, ptr addrspace(3) %out, align 8
  ret void
}

define amdgpu_kernel void @store_lds_v4i32_align16(ptr addrspace(3) %out, <4 x i32> %x) {
; GFX9-LABEL: store_lds_v4i32_align16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v4, s6
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-NEXT:    ds_write_b128 v4, v[0:3]
; GFX9-NEXT:    s_endpgm
;
; GFX7-LABEL: store_lds_v4i32_align16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4
; GFX7-NEXT:    s_mov_b32 m0, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, s6
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    ds_write_b128 v4, v[0:3]
; GFX7-NEXT:    s_endpgm
;
; GFX6-LABEL: store_lds_v4i32_align16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4
; GFX6-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX6-NEXT:    s_mov_b32 m0, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s2
; GFX6-NEXT:    v_mov_b32_e32 v1, s3
; GFX6-NEXT:    v_mov_b32_e32 v4, s4
; GFX6-NEXT:    v_mov_b32_e32 v2, s0
; GFX6-NEXT:    v_mov_b32_e32 v3, s1
; GFX6-NEXT:    ds_write2_b64 v4, v[2:3], v[0:1] offset1:1
; GFX6-NEXT:    s_endpgm
;
; GFX10-LABEL: store_lds_v4i32_align16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, s6
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-NEXT:    v_mov_b32_e32 v3, s3
; GFX10-NEXT:    ds_write_b128 v4, v[0:3]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_lds_v4i32_align16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s6, s[4:5], 0x0
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x10
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, s6
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v1, s1 :: v_dual_mov_b32 v2, s2
; GFX11-NEXT:    ds_store_b128 v4, v[0:3]
; GFX11-NEXT:    s_endpgm
  store <4 x i32> %x, ptr addrspace(3) %out, align 16
  ret void
}
