; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=aarch64 -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc -mtriple=aarch64 -global-isel -global-isel-abort=2 -verify-machineinstrs %s -o - 2>&1 | FileCheck %s --check-prefixes=CHECK,CHECK-GI



define i64 @APlusC1MinusC2(i64 %a) {
; CHECK-LABEL: APlusC1MinusC2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub x0, x0, #1
; CHECK-NEXT:    ret
entry:
; fold (A+C1)-C2 -> A+(C1-C2)
  %add1 = add i64 %a, 5
  %sub1 = sub i64 %add1, 6
  ret i64 %sub1
}

define i64 @C2MinusAPlusC1(i64 %a) {
; CHECK-LABEL: C2MinusAPlusC1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov w8, #3 // =0x3
; CHECK-NEXT:    sub x0, x8, x0
; CHECK-NEXT:    ret
entry:
;  fold C2-(A+C1) -> (C2-C1)-A
  %add1 = add i64 %a, 6
  %sub1 = sub i64 9, %add1
  ret i64 %sub1
}

define i64 @AMinusC1MinusC2(i64 %a) {
; CHECK-LABEL: AMinusC1MinusC2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub x0, x0, #15
; CHECK-NEXT:    ret
entry:
; fold (A-C1)-C2 -> A-(C1+C2)
  %sub2 = sub i64 %a, 6
  %sub1 = sub i64 %sub2, 9
  ret i64 %sub1
}

define i64 @C1Minus2MinusC2(i64 %a) {
; CHECK-LABEL: C1Minus2MinusC2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov w8, #3 // =0x3
; CHECK-NEXT:    sub x0, x8, x0
; CHECK-NEXT:    ret
entry:
; fold (C1-A)-C2 -> (C1-C2)-A
  %sub2 = sub i64 14, %a
  %sub1 = sub i64 %sub2, 11
  ret i64 %sub1
}

define i64 @AMinusC2PlusC2(i64 %a) {
; CHECK-LABEL: AMinusC2PlusC2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub x0, x0, #4
; CHECK-NEXT:    ret
entry:
; fold ((A-C1)+C2) -> (A+(C2-C1))
  %sub1 = sub i64 %a, 21
  %add1 = add i64 %sub1, 17
  ret i64 %add1
}

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK-GI: {{.*}}
; CHECK-SD: {{.*}}
