; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes=instsimplify -S %s | FileCheck %s

define i1 @incr_sle(i32 %i, i32 %len) {
; CHECK-LABEL: define i1 @incr_sle(
; CHECK-SAME: i32 [[I:%.*]], i32 [[LEN:%.*]]) {
; CHECK-NEXT:    ret i1 true
;
  %i.incr = add nsw nuw i32 %i, 1
  %i.gt.len = icmp samesign ugt i32 %i, %len
  %i.incr.sgt.len = icmp sgt i32 %i.incr, %len
  %res = icmp sle i1 %i.incr.sgt.len, %i.gt.len
  ret i1 %res
}

define i1 @incr_sle_no_nsw_nuw(i32 %i, i32 %len) {
; CHECK-LABEL: define i1 @incr_sle_no_nsw_nuw(
; CHECK-SAME: i32 [[I:%.*]], i32 [[LEN:%.*]]) {
; CHECK-NEXT:    [[I_INCR:%.*]] = add i32 [[I]], 1
; CHECK-NEXT:    [[I_GT_LEN:%.*]] = icmp samesign ugt i32 [[I]], [[LEN]]
; CHECK-NEXT:    [[I_INCR_SGT_LEN:%.*]] = icmp sgt i32 [[I_INCR]], [[LEN]]
; CHECK-NEXT:    [[RES:%.*]] = icmp sle i1 [[I_INCR_SGT_LEN]], [[I_GT_LEN]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %i.incr = add i32 %i, 1
  %i.gt.len = icmp samesign ugt i32 %i, %len
  %i.incr.sgt.len = icmp sgt i32 %i.incr, %len
  %res = icmp sle i1 %i.incr.sgt.len, %i.gt.len
  ret i1 %res
}

define i1 @incr_sge(i32 %i, i32 %len) {
; CHECK-LABEL: define i1 @incr_sge(
; CHECK-SAME: i32 [[I:%.*]], i32 [[LEN:%.*]]) {
; CHECK-NEXT:    ret i1 true
;
  %i.incr = add nsw nuw i32 %i, 1
  %i.lt.len = icmp samesign ult i32 %i, %len
  %i.incr.slt.len = icmp slt i32 %i.incr, %len
  %res = icmp sge i1 %i.incr.slt.len, %i.lt.len
  ret i1 %res
}

define i1 @incr_sge_no_nsw_nuw(i32 %i, i32 %len) {
; CHECK-LABEL: define i1 @incr_sge_no_nsw_nuw(
; CHECK-SAME: i32 [[I:%.*]], i32 [[LEN:%.*]]) {
; CHECK-NEXT:    [[I_INCR:%.*]] = add i32 [[I]], 1
; CHECK-NEXT:    [[I_LT_LEN:%.*]] = icmp samesign ult i32 [[I]], [[LEN]]
; CHECK-NEXT:    [[I_INCR_SLT_LEN:%.*]] = icmp slt i32 [[I_INCR]], [[LEN]]
; CHECK-NEXT:    [[RES:%.*]] = icmp sge i1 [[I_INCR_SLT_LEN]], [[I_LT_LEN]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %i.incr = add i32 %i, 1
  %i.lt.len = icmp samesign ult i32 %i, %len
  %i.incr.slt.len = icmp slt i32 %i.incr, %len
  %res = icmp sge i1 %i.incr.slt.len, %i.lt.len
  ret i1 %res
}

define i1 @incr_ule(i32 %i, i32 %len) {
; CHECK-LABEL: define i1 @incr_ule(
; CHECK-SAME: i32 [[I:%.*]], i32 [[LEN:%.*]]) {
; CHECK-NEXT:    ret i1 true
;
  %i.incr = add nsw nuw i32 %i, 1
  %i.gt.len = icmp samesign ugt i32 %i, %len
  %i.incr.sgt.len = icmp sgt i32 %i.incr, %len
  %res = icmp ule i1 %i.gt.len, %i.incr.sgt.len
  ret i1 %res
}

define i1 @incr_ule_no_nsw_nuw(i32 %i, i32 %len) {
; CHECK-LABEL: define i1 @incr_ule_no_nsw_nuw(
; CHECK-SAME: i32 [[I:%.*]], i32 [[LEN:%.*]]) {
; CHECK-NEXT:    [[I_INCR:%.*]] = add i32 [[I]], 1
; CHECK-NEXT:    [[I_GT_LEN:%.*]] = icmp samesign ugt i32 [[I]], [[LEN]]
; CHECK-NEXT:    [[I_INCR_SGT_LEN:%.*]] = icmp sgt i32 [[I_INCR]], [[LEN]]
; CHECK-NEXT:    [[RES:%.*]] = icmp ule i1 [[I_GT_LEN]], [[I_INCR_SGT_LEN]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %i.incr = add i32 %i, 1
  %i.gt.len = icmp samesign ugt i32 %i, %len
  %i.incr.sgt.len = icmp sgt i32 %i.incr, %len
  %res = icmp ule i1 %i.gt.len, %i.incr.sgt.len
  ret i1 %res
}

define i1 @incr_uge(i32 %i, i32 %len) {
; CHECK-LABEL: define i1 @incr_uge(
; CHECK-SAME: i32 [[I:%.*]], i32 [[LEN:%.*]]) {
; CHECK-NEXT:    ret i1 true
;
  %i.incr = add nsw nuw i32 %i, 1
  %i.lt.len = icmp samesign ult i32 %i, %len
  %i.incr.slt.len = icmp slt i32 %i.incr, %len
  %res = icmp uge i1 %i.lt.len, %i.incr.slt.len
  ret i1 %res
}

define i1 @incr_uge_no_nsw_nuw(i32 %i, i32 %len) {
; CHECK-LABEL: define i1 @incr_uge_no_nsw_nuw(
; CHECK-SAME: i32 [[I:%.*]], i32 [[LEN:%.*]]) {
; CHECK-NEXT:    [[I_INCR:%.*]] = add i32 [[I]], 1
; CHECK-NEXT:    [[I_LT_LEN:%.*]] = icmp samesign ult i32 [[I]], [[LEN]]
; CHECK-NEXT:    [[I_INCR_SLT_LEN:%.*]] = icmp slt i32 [[I_INCR]], [[LEN]]
; CHECK-NEXT:    [[RES:%.*]] = icmp uge i1 [[I_LT_LEN]], [[I_INCR_SLT_LEN]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %i.incr = add i32 %i, 1
  %i.lt.len = icmp samesign ult i32 %i, %len
  %i.incr.slt.len = icmp slt i32 %i.incr, %len
  %res = icmp uge i1 %i.lt.len, %i.incr.slt.len
  ret i1 %res
}

define i1 @sgt_implies_ge_via_assume(i32 %i, i32 %j) {
; CHECK-LABEL: define i1 @sgt_implies_ge_via_assume(
; CHECK-SAME: i32 [[I:%.*]], i32 [[J:%.*]]) {
; CHECK-NEXT:    [[I_SGT_J:%.*]] = icmp sgt i32 [[I]], [[J]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[I_SGT_J]])
; CHECK-NEXT:    ret i1 true
;
  %i.sgt.j = icmp sgt i32 %i, %j
  call void @llvm.assume(i1 %i.sgt.j)
  %i.ge.j = icmp samesign uge i32 %i, %j
  ret i1 %i.ge.j
}

define i1 @sgt_implies_false_le_via_assume(i32 %i, i32 %j) {
; CHECK-LABEL: define i1 @sgt_implies_false_le_via_assume(
; CHECK-SAME: i32 [[I:%.*]], i32 [[J:%.*]]) {
; CHECK-NEXT:    [[I_SGT_J:%.*]] = icmp sgt i32 [[I]], [[J]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[I_SGT_J]])
; CHECK-NEXT:    ret i1 false
;
  %i.sgt.j = icmp sgt i32 %i, %j
  call void @llvm.assume(i1 %i.sgt.j)
  %i.le.j = icmp samesign ule i32 %i, %j
  ret i1 %i.le.j
}

define i32 @gt_implies_sge_dominating(i32 %a, i32 %len) {
; CHECK-LABEL: define i32 @gt_implies_sge_dominating(
; CHECK-SAME: i32 [[A:%.*]], i32 [[LEN:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[A_GT_LEN:%.*]] = icmp samesign ugt i32 [[A]], [[LEN]]
; CHECK-NEXT:    br i1 [[A_GT_LEN]], label %[[TAKEN:.*]], label %[[END:.*]]
; CHECK:       [[TAKEN]]:
; CHECK-NEXT:    ret i32 30
; CHECK:       [[END]]:
; CHECK-NEXT:    ret i32 -1
;
entry:
  %a.gt.len = icmp samesign ugt i32 %a, %len
  br i1 %a.gt.len, label %taken, label %end

taken:
  %a.sge.len = icmp sge i32 %a, %len
  %res = select i1 %a.sge.len, i32 30, i32 0
  ret i32 %res

end:
  ret i32 -1
}

define i32 @gt_implies_false_sle_dominating(i32 %a, i32 %len) {
; CHECK-LABEL: define i32 @gt_implies_false_sle_dominating(
; CHECK-SAME: i32 [[A:%.*]], i32 [[LEN:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[A_GT_LEN:%.*]] = icmp samesign ugt i32 [[A]], [[LEN]]
; CHECK-NEXT:    br i1 [[A_GT_LEN]], label %[[TAKEN:.*]], label %[[END:.*]]
; CHECK:       [[TAKEN]]:
; CHECK-NEXT:    ret i32 0
; CHECK:       [[END]]:
; CHECK-NEXT:    ret i32 -1
;
entry:
  %a.gt.len = icmp samesign ugt i32 %a, %len
  br i1 %a.gt.len, label %taken, label %end

taken:
  %a.sle.len = icmp sle i32 %a, %len
  %res = select i1 %a.sle.len, i32 30, i32 0
  ret i32 %res

end:
  ret i32 -1
}

define i32 @gt_implies_sge_dominating_cr(i32 %a, i32 %len) {
; CHECK-LABEL: define i32 @gt_implies_sge_dominating_cr(
; CHECK-SAME: i32 [[A:%.*]], i32 [[LEN:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[A_GT_20:%.*]] = icmp samesign ugt i32 [[A]], 20
; CHECK-NEXT:    br i1 [[A_GT_20]], label %[[TAKEN:.*]], label %[[END:.*]]
; CHECK:       [[TAKEN]]:
; CHECK-NEXT:    ret i32 30
; CHECK:       [[END]]:
; CHECK-NEXT:    ret i32 -1
;
entry:
  %a.gt.20 = icmp samesign ugt i32 %a, 20
  br i1 %a.gt.20, label %taken, label %end

taken:
  %a.sge.10 = icmp sge i32 %a, 10
  %res = select i1 %a.sge.10, i32 30, i32 0
  ret i32 %res

end:
  ret i32 -1
}

define i32 @sgt_implies_ge_dominating_cr(i32 %a, i32 %len) {
; CHECK-LABEL: define i32 @sgt_implies_ge_dominating_cr(
; CHECK-SAME: i32 [[A:%.*]], i32 [[LEN:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[A_SGT_MINUS_10:%.*]] = icmp sgt i32 [[A]], -10
; CHECK-NEXT:    br i1 [[A_SGT_MINUS_10]], label %[[TAKEN:.*]], label %[[END:.*]]
; CHECK:       [[TAKEN]]:
; CHECK-NEXT:    ret i32 30
; CHECK:       [[END]]:
; CHECK-NEXT:    ret i32 -1
;
entry:
  %a.sgt.minus.10 = icmp sgt i32 %a, -10
  br i1 %a.sgt.minus.10, label %taken, label %end

taken:
  %a.ge.minus.20 = icmp samesign uge i32 %a, -20
  %res = select i1 %a.ge.minus.20, i32 30, i32 0
  ret i32 %res

end:
  ret i32 -1
}

define i32 @gt_sub_nsw(i32 %x, i32 %y) {
; CHECK-LABEL: define i32 @gt_sub_nsw(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[X_GT_Y:%.*]] = icmp samesign ugt i32 [[X]], [[Y]]
; CHECK-NEXT:    br i1 [[X_GT_Y]], label %[[TAKEN:.*]], label %[[END:.*]]
; CHECK:       [[TAKEN]]:
; CHECK-NEXT:    [[SUB:%.*]] = sub nsw i32 [[X]], [[Y]]
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[SUB]], 1
; CHECK-NEXT:    ret i32 [[ADD]]
; CHECK:       [[END]]:
; CHECK-NEXT:    ret i32 0
;
entry:
  %x.gt.y = icmp samesign ugt i32 %x, %y
  br i1 %x.gt.y, label %taken, label %end

taken:
  %sub = sub nsw i32 %x, %y
  %add = add nsw i32 %sub, 1
  %neg = xor i32 %sub, -1
  %abscond = icmp samesign ult i32 %sub, -1
  %abs = select i1 %abscond, i32 %neg, i32 %add
  ret i32 %abs

end:
  ret i32 0
}

define i32 @ge_sub_nsw(i32 %x, i32 %y) {
; CHECK-LABEL: define i32 @ge_sub_nsw(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[X_GE_Y:%.*]] = icmp samesign uge i32 [[X]], [[Y]]
; CHECK-NEXT:    br i1 [[X_GE_Y]], label %[[TAKEN:.*]], label %[[END:.*]]
; CHECK:       [[TAKEN]]:
; CHECK-NEXT:    [[SUB:%.*]] = sub nsw i32 [[X]], [[Y]]
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[SUB]], 1
; CHECK-NEXT:    ret i32 [[ADD]]
; CHECK:       [[END]]:
; CHECK-NEXT:    ret i32 0
;
entry:
  %x.ge.y = icmp samesign uge i32 %x, %y
  br i1 %x.ge.y, label %taken, label %end

taken:
  %sub = sub nsw i32 %x, %y
  %add = add nsw i32 %sub, 1
  %neg = xor i32 %sub, -1
  %abscond = icmp samesign ult i32 %sub, -1
  %abs = select i1 %abscond, i32 %neg, i32 %add
  ret i32 %abs

end:
  ret i32 0
}

define i1 @gt_sub_nsw_ult(i8 %L0, i8 %L1, i1 %V) {
; CHECK-LABEL: define i1 @gt_sub_nsw_ult(
; CHECK-SAME: i8 [[L0:%.*]], i8 [[L1:%.*]], i1 [[V:%.*]]) {
; CHECK-NEXT:    [[LHS:%.*]] = icmp samesign ugt i8 [[L0]], [[L1]]
; CHECK-NEXT:    br i1 [[LHS]], label %[[LHS_TRUE:.*]], label %[[LHS_FALSE:.*]]
; CHECK:       [[LHS_TRUE]]:
; CHECK-NEXT:    [[R0:%.*]] = sub nsw i8 [[L0]], [[L1]]
; CHECK-NEXT:    [[RHS:%.*]] = icmp ult i8 [[R0]], -1
; CHECK-NEXT:    ret i1 [[RHS]]
; CHECK:       [[LHS_FALSE]]:
; CHECK-NEXT:    ret i1 [[V]]
;
  %LHS = icmp samesign ugt i8 %L0, %L1
  br i1 %LHS, label %LHS_true, label %LHS_false

LHS_true:
  %R0 = sub nsw i8 %L0, %L1
  %RHS = icmp ult i8 %R0, -1
  ret i1 %RHS

LHS_false:
  ret i1 %V
}

define i1 @lt_sub_nsw_ult(i8 %L0, i8 %L1, i1 %V) {
; CHECK-LABEL: define i1 @lt_sub_nsw_ult(
; CHECK-SAME: i8 [[L0:%.*]], i8 [[L1:%.*]], i1 [[V:%.*]]) {
; CHECK-NEXT:    [[LHS:%.*]] = icmp samesign ult i8 [[L0]], [[L1]]
; CHECK-NEXT:    br i1 [[LHS]], label %[[LHS_TRUE:.*]], label %[[LHS_FALSE:.*]]
; CHECK:       [[LHS_TRUE]]:
; CHECK-NEXT:    [[R0:%.*]] = sub nsw i8 [[L0]], [[L1]]
; CHECK-NEXT:    [[RHS:%.*]] = icmp ult i8 [[R0]], 1
; CHECK-NEXT:    ret i1 [[RHS]]
; CHECK:       [[LHS_FALSE]]:
; CHECK-NEXT:    ret i1 [[V]]
;
  %LHS = icmp samesign ult i8 %L0, %L1
  br i1 %LHS, label %LHS_true, label %LHS_false

LHS_true:
  %R0 = sub nsw i8 %L0, %L1
  %RHS = icmp ult i8 %R0, 1
  ret i1 %RHS

LHS_false:
  ret i1 %V
}
