; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

declare void @llvm.assume(i1)

define i1 @sge_0_unsigned_a_ne_0(i8 %a) {
; CHECK-LABEL: @sge_0_unsigned_a_ne_0(
; CHECK-NEXT:    [[A_NE_0:%.*]] = icmp ne i8 [[A:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[A_NE_0]])
; CHECK-NEXT:    [[EXT:%.*]] = zext i8 [[A]] to i16
; CHECK-NEXT:    ret i1 true
;
  %a.ne.0 = icmp ne i8 %a, 0
  call void @llvm.assume(i1 %a.ne.0)
  %ext = zext i8 %a to i16
  %t = icmp sge i16 %ext, 0
  ret i1 %t
}

define i1 @sgt_0_unsigned_a_ne_0(i8 %a) {
; CHECK-LABEL: @sgt_0_unsigned_a_ne_0(
; CHECK-NEXT:    [[A_NE_0:%.*]] = icmp ne i8 [[A:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[A_NE_0]])
; CHECK-NEXT:    [[EXT:%.*]] = zext i8 [[A]] to i16
; CHECK-NEXT:    ret i1 true
;
  %a.ne.0 = icmp ne i8 %a, 0
  call void @llvm.assume(i1 %a.ne.0)
  %ext = zext i8 %a to i16
  %t = icmp sgt i16 %ext, 0
  ret i1 %t
}

define i1 @sgt_0_unsigned_a_sgt_0(i8 %a) {
; CHECK-LABEL: @sgt_0_unsigned_a_sgt_0(
; CHECK-NEXT:    [[A_SGT_0:%.*]] = icmp sgt i8 [[A:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[A_SGT_0]])
; CHECK-NEXT:    [[EXT:%.*]] = zext i8 [[A]] to i16
; CHECK-NEXT:    ret i1 true
;
  %a.sgt.0 = icmp sgt i8 %a, 0
  call void @llvm.assume(i1 %a.sgt.0)
  %ext = zext i8 %a to i16
  %t = icmp sgt i16 %ext, 0
  ret i1 %t
}

define i1 @sge_0_unsigned_a_sge_0(i8 %a) {
; CHECK-LABEL: @sge_0_unsigned_a_sge_0(
; CHECK-NEXT:    [[A_SGE_0:%.*]] = icmp sge i8 [[A:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[A_SGE_0]])
; CHECK-NEXT:    [[EXT:%.*]] = zext i8 [[A]] to i16
; CHECK-NEXT:    ret i1 true
;
  %a.sge.0 = icmp sge i8 %a, 0
  call void @llvm.assume(i1 %a.sge.0)
  %ext = zext i8 %a to i16
  %t = icmp sge i16 %ext, 0
  ret i1 %t
}

define i1 @sgt_0_unsigned_a_ugt_0(i8 %a) {
; CHECK-LABEL: @sgt_0_unsigned_a_ugt_0(
; CHECK-NEXT:    [[A_UGT_0:%.*]] = icmp ugt i8 [[A:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[A_UGT_0]])
; CHECK-NEXT:    [[EXT:%.*]] = zext i8 [[A]] to i16
; CHECK-NEXT:    ret i1 true
;
  %a.ugt.0 = icmp ugt i8 %a, 0
  call void @llvm.assume(i1 %a.ugt.0)
  %ext = zext i8 %a to i16
  %t = icmp sgt i16 %ext, 0
  ret i1 %t
}

define i1 @sgt_1_unsigned_a_ne_0(i8 %a) {
; CHECK-LABEL: @sgt_1_unsigned_a_ne_0(
; CHECK-NEXT:    [[A_NE_0:%.*]] = icmp ne i8 [[A:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[A_NE_0]])
; CHECK-NEXT:    [[EXT:%.*]] = zext i8 [[A]] to i16
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i16 [[EXT]], 1
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %a.ne.0 = icmp ne i8 %a, 0
  call void @llvm.assume(i1 %a.ne.0)
  %ext = zext i8 %a to i16
  %cmp = icmp sgt i16 %ext, 1
  ret i1 %cmp
}

define i1 @sgt_1_unsigned_a_ugt_1(i8 %a) {
; CHECK-LABEL: @sgt_1_unsigned_a_ugt_1(
; CHECK-NEXT:    [[A_UGT_1:%.*]] = icmp ugt i8 [[A:%.*]], 1
; CHECK-NEXT:    call void @llvm.assume(i1 [[A_UGT_1]])
; CHECK-NEXT:    [[EXT:%.*]] = zext i8 [[A]] to i16
; CHECK-NEXT:    ret i1 true
;
  %a.ugt.1 = icmp ugt i8 %a, 1
  call void @llvm.assume(i1 %a.ugt.1)
  %ext = zext i8 %a to i16
  %t = icmp sgt i16 %ext, 1
  ret i1 %t
}

define i1 @sge_no_const_unsigned_uge(i8 %a, i16 %b) {
; CHECK-LABEL: @sge_no_const_unsigned_uge(
; CHECK-NEXT:    [[EXT:%.*]] = zext i8 [[A:%.*]] to i16
; CHECK-NEXT:    [[A_UGE_B:%.*]] = icmp uge i16 [[EXT]], [[B:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[A_UGE_B]])
; CHECK-NEXT:    [[B_POS:%.*]] = icmp sge i16 [[B]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[B_POS]])
; CHECK-NEXT:    ret i1 true
;
  %ext = zext i8 %a to i16
  %a.uge.b = icmp uge i16 %ext, %b
  call void @llvm.assume(i1 %a.uge.b)

  %b.pos = icmp sge i16 %b, 0
  call void @llvm.assume(i1 %b.pos)
  %cmp = icmp sge i16 %ext, %b
  ret i1 %cmp
}

define i1 @sgt_0_unsigned_a_ugt_neg_10(i8 %a) {
; CHECK-LABEL: @sgt_0_unsigned_a_ugt_neg_10(
; CHECK-NEXT:    [[A_UGT_0:%.*]] = icmp ugt i8 [[A:%.*]], 10
; CHECK-NEXT:    call void @llvm.assume(i1 [[A_UGT_0]])
; CHECK-NEXT:    [[EXT:%.*]] = zext i8 [[A]] to i16
; CHECK-NEXT:    ret i1 true
;
  %a.ugt.0 = icmp ugt i8 %a, 10
  call void @llvm.assume(i1 %a.ugt.0)
  %ext = zext i8 %a to i16
  %cmp = icmp sgt i16 %ext, 0
  ret i1 %cmp
}

define i1 @sge_neg_1_sge_0_known(i8 %a) {
; CHECK-LABEL: @sge_neg_1_sge_0_known(
; CHECK-NEXT:    [[EXT:%.*]] = zext i8 [[A:%.*]] to i16
; CHECK-NEXT:    [[A_NE_0:%.*]] = icmp sge i16 [[EXT]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[A_NE_0]])
; CHECK-NEXT:    ret i1 true
;
  %ext = zext i8 %a to i16
  %a.ne.0 = icmp sge i16 %ext, 0
  call void @llvm.assume(i1 %a.ne.0)
  %t = icmp sge i16 %ext, -1
  ret i1 %t
}
