# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -march=aarch64 -mcpu=exynos-m3 -resource-pressure=false < %s | FileCheck %s -check-prefixes=ALL,M3
# RUN: llvm-mca -march=aarch64 -mcpu=exynos-m4 -resource-pressure=false < %s | FileCheck %s -check-prefixes=ALL,M4
# RUN: llvm-mca -march=aarch64 -mcpu=exynos-m5 -resource-pressure=false < %s | FileCheck %s -check-prefixes=ALL,M5

fmov	d31, #1.00000000
fdiv	d30, d31, d30

# Newton series for 1 / x.
frecpe	d1, d0
frecps	d2, d0, d1
fmul	d1, d1, d2
frecps	d2, d0, d1
fmul	d1, d1, d2
frecps	d0, d0, d1
fmul	d0, d1, d0

# ALL:      Iterations:        100
# ALL-NEXT: Instructions:      900

# M3-NEXT:  Total Cycles:      2503
# M4-NEXT:  Total Cycles:      2403
# M5-NEXT:  Total Cycles:      2403

# ALL-NEXT: Total uOps:        900

# ALL:      Dispatch Width:    6

# M3-NEXT:  uOps Per Cycle:    0.36
# M3-NEXT:  IPC:               0.36
# M3-NEXT:  Block RThroughput: 3.3

# M4-NEXT:  uOps Per Cycle:    0.37
# M4-NEXT:  IPC:               0.37
# M4-NEXT:  Block RThroughput: 2.3

# M5-NEXT:  uOps Per Cycle:    0.37
# M5-NEXT:  IPC:               0.37
# M5-NEXT:  Block RThroughput: 2.3

# ALL:      Instruction Info:
# ALL-NEXT: [1]: #uOps
# ALL-NEXT: [2]: Latency
# ALL-NEXT: [3]: RThroughput
# ALL-NEXT: [4]: MayLoad
# ALL-NEXT: [5]: MayStore
# ALL-NEXT: [6]: HasSideEffects (U)

# ALL:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# ALL-NEXT:  1      1     0.33                        fmov	d31, #1.00000000

# M3-NEXT:   1      12    3.25                        fdiv	d30, d31, d30
# M3-NEXT:   1      4     0.50                        frecpe	d1, d0

# M4-NEXT:   1      12    2.25                        fdiv	d30, d31, d30
# M4-NEXT:   1      3     0.50                        frecpe	d1, d0

# M5-NEXT:   1      12    2.25                        fdiv	d30, d31, d30
# M5-NEXT:   1      3     0.50                        frecpe	d1, d0

# ALL-NEXT:  1      4     0.33                        frecps	d2, d0, d1
# ALL-NEXT:  1      3     0.33                        fmul	d1, d1, d2
# ALL-NEXT:  1      4     0.33                        frecps	d2, d0, d1
# ALL-NEXT:  1      3     0.33                        fmul	d1, d1, d2
# ALL-NEXT:  1      4     0.33                        frecps	d0, d0, d1
# ALL-NEXT:  1      3     0.33                        fmul	d0, d1, d0
