; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 -passes=separate-const-offset-from-gep,gvn \
; RUN:     -reassociate-geps-verify-no-dead-code < %s | FileCheck %s

; Make sure there's no assertion when an add/sub with two extended
; source operands have different source types.

define i64 @add_sext_different_types(i16 %arg.i16, i32 %arg.i32) {
; CHECK-LABEL: define i64 @add_sext_different_types
; CHECK-SAME: (i16 [[ARG_I16:%.*]], i32 [[ARG_I32:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X1_SEXT:%.*]] = sext i32 [[ARG_I32]] to i64
; CHECK-NEXT:    [[Y1_SEXT:%.*]] = sext i16 [[ARG_I16]] to i64
; CHECK-NEXT:    [[XY12:%.*]] = add i64 [[X1_SEXT]], [[Y1_SEXT]]
; CHECK-NEXT:    ret i64 [[XY12]]
;
entry:
  %x1.sext = sext i32 %arg.i32 to i64
  %y1.sext = sext i16 %arg.i16 to i64
  %xy12 = add i64 %x1.sext, %y1.sext
  ret i64 %xy12
}

define i64 @sub_sext_different_types(i16 %arg.i16, i32 %arg.i32) {
; CHECK-LABEL: define i64 @sub_sext_different_types
; CHECK-SAME: (i16 [[ARG_I16:%.*]], i32 [[ARG_I32:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X1_SEXT:%.*]] = sext i32 [[ARG_I32]] to i64
; CHECK-NEXT:    [[Y1_SEXT:%.*]] = sext i16 [[ARG_I16]] to i64
; CHECK-NEXT:    [[XY12:%.*]] = sub i64 [[X1_SEXT]], [[Y1_SEXT]]
; CHECK-NEXT:    ret i64 [[XY12]]
;
entry:
  %x1.sext = sext i32 %arg.i32 to i64
  %y1.sext = sext i16 %arg.i16 to i64
  %xy12 = sub i64 %x1.sext, %y1.sext
  ret i64 %xy12
}

define i64 @add_zext_different_types(i16 %arg.i16, i32 %arg.i32) {
; CHECK-LABEL: define i64 @add_zext_different_types
; CHECK-SAME: (i16 [[ARG_I16:%.*]], i32 [[ARG_I32:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X1_ZEXT:%.*]] = zext i32 [[ARG_I32]] to i64
; CHECK-NEXT:    [[Y1_ZEXT:%.*]] = zext i16 [[ARG_I16]] to i64
; CHECK-NEXT:    [[XY12:%.*]] = add i64 [[X1_ZEXT]], [[Y1_ZEXT]]
; CHECK-NEXT:    ret i64 [[XY12]]
;
entry:
  %x1.zext = zext i32 %arg.i32 to i64
  %y1.zext = zext i16 %arg.i16 to i64
  %xy12 = add i64 %x1.zext, %y1.zext
  ret i64 %xy12
}

define i64 @sub_zext_different_types(i16 %arg.i16, i32 %arg.i32) {
; CHECK-LABEL: define i64 @sub_zext_different_types
; CHECK-SAME: (i16 [[ARG_I16:%.*]], i32 [[ARG_I32:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X1_ZEXT:%.*]] = zext i32 [[ARG_I32]] to i64
; CHECK-NEXT:    [[Y1_ZEXT:%.*]] = zext i16 [[ARG_I16]] to i64
; CHECK-NEXT:    [[XY12:%.*]] = sub i64 [[X1_ZEXT]], [[Y1_ZEXT]]
; CHECK-NEXT:    ret i64 [[XY12]]
;
entry:
  %x1.zext = zext i32 %arg.i32 to i64
  %y1.zext = zext i16 %arg.i16 to i64
  %xy12 = sub i64 %x1.zext, %y1.zext
  ret i64 %xy12
}
