; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s "-passes=print<scalar-evolution>" -scalar-evolution-classify-expressions=0 -disable-output 2>&1 | FileCheck %s

define void @test1(i32 %n) {
; CHECK-LABEL: 'test1'
; CHECK-NEXT:  Determining loop execution counts for: @test1
; CHECK-NEXT:  Loop %loop: backedge-taken count is ((-32 + (96 * %n)) /u 32)
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 134217727
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is ((-32 + (96 * %n)) /u 32)
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
  %s = mul i32 %n, 96
  br label %loop
loop:
  %i = phi i32 [ 0, %entry ], [ %i.next, %loop ]
  %i.next = add i32 %i, 32
  %t = icmp ne i32 %i.next, %s
  br i1 %t, label %loop, label %exit
exit:
  ret void

}

; PR19183
define i32 @test2(i32 %n) {
; CHECK-LABEL: 'test2'
; CHECK-NEXT:  Determining loop execution counts for: @test2
; CHECK-NEXT:  Loop %loop: backedge-taken count is ((-32 + (32 * (%n /u 32))<nuw>) /u 32)
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 134217727
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is ((-32 + (32 * (%n /u 32))<nuw>) /u 32)
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
  %s = and i32 %n, -32
  br label %loop
loop:
  %i = phi i32 [ 0, %entry ], [ %i.next, %loop ]
  %i.next = add i32 %i, 32
  %t = icmp ne i32 %i.next, %s
  br i1 %t, label %loop, label %exit
exit:
  ret i32 %i

}

define void @test3(i32 %n) {
; CHECK-LABEL: 'test3'
; CHECK-NEXT:  Determining loop execution counts for: @test3
; CHECK-NEXT:  Loop %loop: backedge-taken count is ((-32 + (32 * %n)) /u 32)
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 134217727
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is ((-32 + (32 * %n)) /u 32)
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
  %s = mul i32 %n, 96
  br label %loop
loop:
  %i = phi i32 [ 0, %entry ], [ %i.next, %loop ]
  %i.next = add i32 %i, 96
  %t = icmp ne i32 %i.next, %s
  br i1 %t, label %loop, label %exit
exit:
  ret void

}

define void @test4(i32 %n) {
; CHECK-LABEL: 'test4'
; CHECK-NEXT:  Determining loop execution counts for: @test4
; CHECK-NEXT:  Loop %loop: backedge-taken count is ((-4 + (-1431655764 * %n)) /u 4)
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 1073741823
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is ((-4 + (-1431655764 * %n)) /u 4)
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
  %s = mul i32 %n, 4
  br label %loop
loop:
  %i = phi i32 [ 0, %entry ], [ %i.next, %loop ]
  %i.next = add i32 %i, 12
  %t = icmp ne i32 %i.next, %s
  br i1 %t, label %loop, label %exit
exit:
  ret void

}

define void @test5(i32 %n) {
; CHECK-LABEL: 'test5'
; CHECK-NEXT:  Determining loop execution counts for: @test5
; CHECK-NEXT:  Loop %loop: backedge-taken count is ((-4 + (4 * %n)) /u 4)
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 1073741823
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is ((-4 + (4 * %n)) /u 4)
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
  %s = mul i32 %n, 4
  br label %loop
loop:
  %i = phi i32 [ %s, %entry ], [ %i.next, %loop ]
  %i.next = add i32 %i, -4
  %t = icmp ne i32 %i.next, 0
  br i1 %t, label %loop, label %exit
exit:
  ret void

}
