; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=riscv64 -mattr=+v,+f,+d,+zfh,+zvfh -riscv-v-fixed-length-vector-lmul-max=1 < %s | FileCheck %s
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=riscv64 -mattr=+v,+f,+d,+zfh,+zvfh -riscv-v-fixed-length-vector-lmul-max=1 -intrinsic-cost-strategy=type-based-intrinsic-cost < %s | FileCheck %s
; Check that we don't crash querying costs when vectors are not enabled.
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=riscv64

define void @select() {
; CHECK-LABEL: 'select'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = select i1 undef, i1 undef, i1 undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %2 = select i1 undef, <1 x i1> undef, <1 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %3 = select i1 undef, <2 x i1> undef, <2 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %4 = select i1 undef, <4 x i1> undef, <4 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %5 = select i1 undef, <8 x i1> undef, <8 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %6 = select i1 undef, <16 x i1> undef, <16 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %7 = select i1 undef, <32 x i1> undef, <32 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %8 = select <1 x i1> undef, <1 x i1> undef, <1 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %9 = select <2 x i1> undef, <2 x i1> undef, <2 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %10 = select <4 x i1> undef, <4 x i1> undef, <4 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %11 = select <8 x i1> undef, <8 x i1> undef, <8 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %12 = select <16 x i1> undef, <16 x i1> undef, <16 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %13 = select <32 x i1> undef, <32 x i1> undef, <32 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %14 = select i1 undef, <vscale x 1 x i1> undef, <vscale x 1 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %15 = select i1 undef, <vscale x 2 x i1> undef, <vscale x 2 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %16 = select i1 undef, <vscale x 4 x i1> undef, <vscale x 4 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %17 = select i1 undef, <vscale x 8 x i1> undef, <vscale x 8 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %18 = select i1 undef, <vscale x 16 x i1> undef, <vscale x 16 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %19 = select i1 undef, <vscale x 32 x i1> undef, <vscale x 32 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %20 = select <vscale x 1 x i1> undef, <vscale x 1 x i1> undef, <vscale x 1 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %21 = select <vscale x 2 x i1> undef, <vscale x 2 x i1> undef, <vscale x 2 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %22 = select <vscale x 4 x i1> undef, <vscale x 4 x i1> undef, <vscale x 4 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %23 = select <vscale x 8 x i1> undef, <vscale x 8 x i1> undef, <vscale x 8 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %24 = select <vscale x 16 x i1> undef, <vscale x 16 x i1> undef, <vscale x 16 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %25 = select <vscale x 32 x i1> undef, <vscale x 32 x i1> undef, <vscale x 32 x i1> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %26 = call <1 x i1> @llvm.vp.select.v1i1(<1 x i1> undef, <1 x i1> undef, <1 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %27 = call <2 x i1> @llvm.vp.select.v2i1(<2 x i1> undef, <2 x i1> undef, <2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %28 = call <4 x i1> @llvm.vp.select.v4i1(<4 x i1> undef, <4 x i1> undef, <4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %29 = call <8 x i1> @llvm.vp.select.v8i1(<8 x i1> undef, <8 x i1> undef, <8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %30 = call <16 x i1> @llvm.vp.select.v16i1(<16 x i1> undef, <16 x i1> undef, <16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %31 = call <32 x i1> @llvm.vp.select.v32i1(<32 x i1> undef, <32 x i1> undef, <32 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %32 = call <vscale x 1 x i1> @llvm.vp.select.nxv1i1(<vscale x 1 x i1> undef, <vscale x 1 x i1> undef, <vscale x 1 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %33 = call <vscale x 2 x i1> @llvm.vp.select.nxv2i1(<vscale x 2 x i1> undef, <vscale x 2 x i1> undef, <vscale x 2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %34 = call <vscale x 4 x i1> @llvm.vp.select.nxv4i1(<vscale x 4 x i1> undef, <vscale x 4 x i1> undef, <vscale x 4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %35 = call <vscale x 8 x i1> @llvm.vp.select.nxv8i1(<vscale x 8 x i1> undef, <vscale x 8 x i1> undef, <vscale x 8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %36 = call <vscale x 16 x i1> @llvm.vp.select.nxv16i1(<vscale x 16 x i1> undef, <vscale x 16 x i1> undef, <vscale x 16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %37 = call <vscale x 32 x i1> @llvm.vp.select.nxv32i1(<vscale x 32 x i1> undef, <vscale x 32 x i1> undef, <vscale x 32 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = select i1 undef, i8 undef, i8 undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %39 = select i1 undef, <1 x i8> undef, <1 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %40 = select i1 undef, <2 x i8> undef, <2 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %41 = select i1 undef, <4 x i8> undef, <4 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %42 = select i1 undef, <8 x i8> undef, <8 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %43 = select i1 undef, <16 x i8> undef, <16 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %44 = select i1 undef, <32 x i8> undef, <32 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %45 = select <1 x i1> undef, <1 x i8> undef, <1 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %46 = select <2 x i1> undef, <2 x i8> undef, <2 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %47 = select <4 x i1> undef, <4 x i8> undef, <4 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %48 = select <8 x i1> undef, <8 x i8> undef, <8 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %49 = select <16 x i1> undef, <16 x i8> undef, <16 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %50 = select <32 x i1> undef, <32 x i8> undef, <32 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %51 = select i1 undef, <vscale x 1 x i8> undef, <vscale x 1 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %52 = select i1 undef, <vscale x 2 x i8> undef, <vscale x 2 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %53 = select i1 undef, <vscale x 4 x i8> undef, <vscale x 4 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %54 = select i1 undef, <vscale x 8 x i8> undef, <vscale x 8 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %55 = select i1 undef, <vscale x 16 x i8> undef, <vscale x 16 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %56 = select i1 undef, <vscale x 32 x i8> undef, <vscale x 32 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %57 = select <vscale x 1 x i1> undef, <vscale x 1 x i8> undef, <vscale x 1 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %58 = select <vscale x 2 x i1> undef, <vscale x 2 x i8> undef, <vscale x 2 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %59 = select <vscale x 4 x i1> undef, <vscale x 4 x i8> undef, <vscale x 4 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %60 = select <vscale x 8 x i1> undef, <vscale x 8 x i8> undef, <vscale x 8 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %61 = select <vscale x 16 x i1> undef, <vscale x 16 x i8> undef, <vscale x 16 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %62 = select <vscale x 32 x i1> undef, <vscale x 32 x i8> undef, <vscale x 32 x i8> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %63 = call <1 x i8> @llvm.vp.select.v1i8(<1 x i1> undef, <1 x i8> undef, <1 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %64 = call <2 x i8> @llvm.vp.select.v2i8(<2 x i1> undef, <2 x i8> undef, <2 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %65 = call <4 x i8> @llvm.vp.select.v4i8(<4 x i1> undef, <4 x i8> undef, <4 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %66 = call <8 x i8> @llvm.vp.select.v8i8(<8 x i1> undef, <8 x i8> undef, <8 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %67 = call <16 x i8> @llvm.vp.select.v16i8(<16 x i1> undef, <16 x i8> undef, <16 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %68 = call <32 x i8> @llvm.vp.select.v32i8(<32 x i1> undef, <32 x i8> undef, <32 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %69 = call <vscale x 1 x i8> @llvm.vp.select.nxv1i8(<vscale x 1 x i1> undef, <vscale x 1 x i8> undef, <vscale x 1 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %70 = call <vscale x 2 x i8> @llvm.vp.select.nxv2i8(<vscale x 2 x i1> undef, <vscale x 2 x i8> undef, <vscale x 2 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %71 = call <vscale x 4 x i8> @llvm.vp.select.nxv4i8(<vscale x 4 x i1> undef, <vscale x 4 x i8> undef, <vscale x 4 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %72 = call <vscale x 8 x i8> @llvm.vp.select.nxv8i8(<vscale x 8 x i1> undef, <vscale x 8 x i8> undef, <vscale x 8 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %73 = call <vscale x 16 x i8> @llvm.vp.select.nxv16i8(<vscale x 16 x i1> undef, <vscale x 16 x i8> undef, <vscale x 16 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %74 = call <vscale x 32 x i8> @llvm.vp.select.nxv32i8(<vscale x 32 x i1> undef, <vscale x 32 x i8> undef, <vscale x 32 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %75 = select i1 undef, i16 undef, i16 undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %76 = select i1 undef, <1 x i16> undef, <1 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %77 = select i1 undef, <2 x i16> undef, <2 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %78 = select i1 undef, <4 x i16> undef, <4 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %79 = select i1 undef, <8 x i16> undef, <8 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %80 = select i1 undef, <16 x i16> undef, <16 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %81 = select i1 undef, <32 x i16> undef, <32 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %82 = select <1 x i1> undef, <1 x i16> undef, <1 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %83 = select <2 x i1> undef, <2 x i16> undef, <2 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %84 = select <4 x i1> undef, <4 x i16> undef, <4 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %85 = select <8 x i1> undef, <8 x i16> undef, <8 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %86 = select <16 x i1> undef, <16 x i16> undef, <16 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %87 = select <32 x i1> undef, <32 x i16> undef, <32 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %88 = select i1 undef, <vscale x 1 x i16> undef, <vscale x 1 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %89 = select i1 undef, <vscale x 2 x i16> undef, <vscale x 2 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %90 = select i1 undef, <vscale x 4 x i16> undef, <vscale x 4 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %91 = select i1 undef, <vscale x 8 x i16> undef, <vscale x 8 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %92 = select i1 undef, <vscale x 16 x i16> undef, <vscale x 16 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %93 = select i1 undef, <vscale x 32 x i16> undef, <vscale x 32 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %94 = select <vscale x 1 x i1> undef, <vscale x 1 x i16> undef, <vscale x 1 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %95 = select <vscale x 2 x i1> undef, <vscale x 2 x i16> undef, <vscale x 2 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %96 = select <vscale x 4 x i1> undef, <vscale x 4 x i16> undef, <vscale x 4 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %97 = select <vscale x 8 x i1> undef, <vscale x 8 x i16> undef, <vscale x 8 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %98 = select <vscale x 16 x i1> undef, <vscale x 16 x i16> undef, <vscale x 16 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %99 = select <vscale x 32 x i1> undef, <vscale x 32 x i16> undef, <vscale x 32 x i16> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %100 = call <1 x i16> @llvm.vp.select.v1i16(<1 x i1> undef, <1 x i16> undef, <1 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %101 = call <2 x i16> @llvm.vp.select.v2i16(<2 x i1> undef, <2 x i16> undef, <2 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %102 = call <4 x i16> @llvm.vp.select.v4i16(<4 x i1> undef, <4 x i16> undef, <4 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %103 = call <8 x i16> @llvm.vp.select.v8i16(<8 x i1> undef, <8 x i16> undef, <8 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %104 = call <16 x i16> @llvm.vp.select.v16i16(<16 x i1> undef, <16 x i16> undef, <16 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %105 = call <32 x i16> @llvm.vp.select.v32i16(<32 x i1> undef, <32 x i16> undef, <32 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %106 = call <vscale x 1 x i16> @llvm.vp.select.nxv1i16(<vscale x 1 x i1> undef, <vscale x 1 x i16> undef, <vscale x 1 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %107 = call <vscale x 2 x i16> @llvm.vp.select.nxv2i16(<vscale x 2 x i1> undef, <vscale x 2 x i16> undef, <vscale x 2 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %108 = call <vscale x 4 x i16> @llvm.vp.select.nxv4i16(<vscale x 4 x i1> undef, <vscale x 4 x i16> undef, <vscale x 4 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %109 = call <vscale x 8 x i16> @llvm.vp.select.nxv8i16(<vscale x 8 x i1> undef, <vscale x 8 x i16> undef, <vscale x 8 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %110 = call <vscale x 16 x i16> @llvm.vp.select.nxv16i16(<vscale x 16 x i1> undef, <vscale x 16 x i16> undef, <vscale x 16 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %111 = call <vscale x 32 x i16> @llvm.vp.select.nxv32i16(<vscale x 32 x i1> undef, <vscale x 32 x i16> undef, <vscale x 32 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %112 = select i1 undef, i32 undef, i32 undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %113 = select i1 undef, <1 x i32> undef, <1 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %114 = select i1 undef, <2 x i32> undef, <2 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %115 = select i1 undef, <4 x i32> undef, <4 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %116 = select i1 undef, <8 x i32> undef, <8 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %117 = select i1 undef, <16 x i32> undef, <16 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %118 = select i1 undef, <32 x i32> undef, <32 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %119 = select <1 x i1> undef, <1 x i32> undef, <1 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %120 = select <2 x i1> undef, <2 x i32> undef, <2 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %121 = select <4 x i1> undef, <4 x i32> undef, <4 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %122 = select <8 x i1> undef, <8 x i32> undef, <8 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %123 = select <16 x i1> undef, <16 x i32> undef, <16 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %124 = select <32 x i1> undef, <32 x i32> undef, <32 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %125 = select i1 undef, <vscale x 1 x i32> undef, <vscale x 1 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %126 = select i1 undef, <vscale x 2 x i32> undef, <vscale x 2 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %127 = select i1 undef, <vscale x 4 x i32> undef, <vscale x 4 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %128 = select i1 undef, <vscale x 8 x i32> undef, <vscale x 8 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %129 = select i1 undef, <vscale x 16 x i32> undef, <vscale x 16 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %130 = select i1 undef, <vscale x 32 x i32> undef, <vscale x 32 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %131 = select <vscale x 1 x i1> undef, <vscale x 1 x i32> undef, <vscale x 1 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %132 = select <vscale x 2 x i1> undef, <vscale x 2 x i32> undef, <vscale x 2 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %133 = select <vscale x 4 x i1> undef, <vscale x 4 x i32> undef, <vscale x 4 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %134 = select <vscale x 8 x i1> undef, <vscale x 8 x i32> undef, <vscale x 8 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %135 = select <vscale x 16 x i1> undef, <vscale x 16 x i32> undef, <vscale x 16 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %136 = select <vscale x 32 x i1> undef, <vscale x 32 x i32> undef, <vscale x 32 x i32> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %137 = call <1 x i32> @llvm.vp.select.v1i32(<1 x i1> undef, <1 x i32> undef, <1 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %138 = call <2 x i32> @llvm.vp.select.v2i32(<2 x i1> undef, <2 x i32> undef, <2 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %139 = call <4 x i32> @llvm.vp.select.v4i32(<4 x i1> undef, <4 x i32> undef, <4 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %140 = call <8 x i32> @llvm.vp.select.v8i32(<8 x i1> undef, <8 x i32> undef, <8 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %141 = call <16 x i32> @llvm.vp.select.v16i32(<16 x i1> undef, <16 x i32> undef, <16 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %142 = call <32 x i32> @llvm.vp.select.v32i32(<32 x i1> undef, <32 x i32> undef, <32 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %143 = call <vscale x 1 x i32> @llvm.vp.select.nxv1i32(<vscale x 1 x i1> undef, <vscale x 1 x i32> undef, <vscale x 1 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %144 = call <vscale x 2 x i32> @llvm.vp.select.nxv2i32(<vscale x 2 x i1> undef, <vscale x 2 x i32> undef, <vscale x 2 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %145 = call <vscale x 4 x i32> @llvm.vp.select.nxv4i32(<vscale x 4 x i1> undef, <vscale x 4 x i32> undef, <vscale x 4 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %146 = call <vscale x 8 x i32> @llvm.vp.select.nxv8i32(<vscale x 8 x i1> undef, <vscale x 8 x i32> undef, <vscale x 8 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %147 = call <vscale x 16 x i32> @llvm.vp.select.nxv16i32(<vscale x 16 x i1> undef, <vscale x 16 x i32> undef, <vscale x 16 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %148 = call <vscale x 32 x i32> @llvm.vp.select.nxv32i32(<vscale x 32 x i1> undef, <vscale x 32 x i32> undef, <vscale x 32 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %149 = select i1 undef, i64 undef, i64 undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %150 = select i1 undef, <1 x i64> undef, <1 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %151 = select i1 undef, <2 x i64> undef, <2 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %152 = select i1 undef, <4 x i64> undef, <4 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %153 = select i1 undef, <8 x i64> undef, <8 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %154 = select i1 undef, <16 x i64> undef, <16 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %155 = select i1 undef, <32 x i64> undef, <32 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %156 = select <1 x i1> undef, <1 x i64> undef, <1 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %157 = select <2 x i1> undef, <2 x i64> undef, <2 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %158 = select <4 x i1> undef, <4 x i64> undef, <4 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %159 = select <8 x i1> undef, <8 x i64> undef, <8 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %160 = select <16 x i1> undef, <16 x i64> undef, <16 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %161 = select <32 x i1> undef, <32 x i64> undef, <32 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %162 = select i1 undef, <vscale x 1 x i64> undef, <vscale x 1 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %163 = select i1 undef, <vscale x 2 x i64> undef, <vscale x 2 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %164 = select i1 undef, <vscale x 4 x i64> undef, <vscale x 4 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %165 = select i1 undef, <vscale x 8 x i64> undef, <vscale x 8 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %166 = select i1 undef, <vscale x 16 x i64> undef, <vscale x 16 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %167 = select i1 undef, <vscale x 32 x i64> undef, <vscale x 32 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %168 = select <vscale x 1 x i1> undef, <vscale x 1 x i64> undef, <vscale x 1 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %169 = select <vscale x 2 x i1> undef, <vscale x 2 x i64> undef, <vscale x 2 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %170 = select <vscale x 4 x i1> undef, <vscale x 4 x i64> undef, <vscale x 4 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %171 = select <vscale x 8 x i1> undef, <vscale x 8 x i64> undef, <vscale x 8 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %172 = select <vscale x 16 x i1> undef, <vscale x 16 x i64> undef, <vscale x 16 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %173 = select <vscale x 32 x i1> undef, <vscale x 32 x i64> undef, <vscale x 32 x i64> undef
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %174 = call <1 x i64> @llvm.vp.select.v1i64(<1 x i1> undef, <1 x i64> undef, <1 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %175 = call <2 x i64> @llvm.vp.select.v2i64(<2 x i1> undef, <2 x i64> undef, <2 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %176 = call <4 x i64> @llvm.vp.select.v4i64(<4 x i1> undef, <4 x i64> undef, <4 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %177 = call <8 x i64> @llvm.vp.select.v8i64(<8 x i1> undef, <8 x i64> undef, <8 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %178 = call <16 x i64> @llvm.vp.select.v16i64(<16 x i1> undef, <16 x i64> undef, <16 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %179 = call <32 x i64> @llvm.vp.select.v32i64(<32 x i1> undef, <32 x i64> undef, <32 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %180 = call <vscale x 1 x i64> @llvm.vp.select.nxv1i64(<vscale x 1 x i1> undef, <vscale x 1 x i64> undef, <vscale x 1 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %181 = call <vscale x 2 x i64> @llvm.vp.select.nxv2i64(<vscale x 2 x i1> undef, <vscale x 2 x i64> undef, <vscale x 2 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %182 = call <vscale x 4 x i64> @llvm.vp.select.nxv4i64(<vscale x 4 x i1> undef, <vscale x 4 x i64> undef, <vscale x 4 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %183 = call <vscale x 8 x i64> @llvm.vp.select.nxv8i64(<vscale x 8 x i1> undef, <vscale x 8 x i64> undef, <vscale x 8 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %184 = call <vscale x 16 x i64> @llvm.vp.select.nxv16i64(<vscale x 16 x i1> undef, <vscale x 16 x i64> undef, <vscale x 16 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %185 = call <vscale x 32 x i64> @llvm.vp.select.nxv32i64(<vscale x 32 x i1> undef, <vscale x 32 x i64> undef, <vscale x 32 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  select i1 undef, i1 undef, i1 undef
  select i1 undef, <1 x i1> undef, <1 x i1> undef
  select i1 undef, <2 x i1> undef, <2 x i1> undef
  select i1 undef, <4 x i1> undef, <4 x i1> undef
  select i1 undef, <8 x i1> undef, <8 x i1> undef
  select i1 undef, <16 x i1> undef, <16 x i1> undef
  select i1 undef, <32 x i1> undef, <32 x i1> undef
  select <1 x i1> undef, <1 x i1> undef, <1 x i1> undef
  select <2 x i1> undef, <2 x i1> undef, <2 x i1> undef
  select <4 x i1> undef, <4 x i1> undef, <4 x i1> undef
  select <8 x i1> undef, <8 x i1> undef, <8 x i1> undef
  select <16 x i1> undef, <16 x i1> undef, <16 x i1> undef
  select <32 x i1> undef, <32 x i1> undef, <32 x i1> undef
  select i1 undef, <vscale x 1 x i1> undef, <vscale x 1 x i1> undef
  select i1 undef, <vscale x 2 x i1> undef, <vscale x 2 x i1> undef
  select i1 undef, <vscale x 4 x i1> undef, <vscale x 4 x i1> undef
  select i1 undef, <vscale x 8 x i1> undef, <vscale x 8 x i1> undef
  select i1 undef, <vscale x 16 x i1> undef, <vscale x 16 x i1> undef
  select i1 undef, <vscale x 32 x i1> undef, <vscale x 32 x i1> undef
  select <vscale x 1 x i1> undef, <vscale x 1 x i1> undef, <vscale x 1 x i1> undef
  select <vscale x 2 x i1> undef, <vscale x 2 x i1> undef, <vscale x 2 x i1> undef
  select <vscale x 4 x i1> undef, <vscale x 4 x i1> undef, <vscale x 4 x i1> undef
  select <vscale x 8 x i1> undef, <vscale x 8 x i1> undef, <vscale x 8 x i1> undef
  select <vscale x 16 x i1> undef, <vscale x 16 x i1> undef, <vscale x 16 x i1> undef
  select <vscale x 32 x i1> undef, <vscale x 32 x i1> undef, <vscale x 32 x i1> undef

  call <1 x i1> @llvm.vp.select.v1i1(<1 x i1> undef, <1 x i1> undef, <1 x i1> undef, i32 undef)
  call <2 x i1> @llvm.vp.select.v2i1(<2 x i1> undef, <2 x i1> undef, <2 x i1> undef, i32 undef)
  call <4 x i1> @llvm.vp.select.v4i1(<4 x i1> undef, <4 x i1> undef, <4 x i1> undef, i32 undef)
  call <8 x i1> @llvm.vp.select.v8i1(<8 x i1> undef, <8 x i1> undef, <8 x i1> undef, i32 undef)
  call <16 x i1> @llvm.vp.select.v16i1(<16 x i1> undef, <16 x i1> undef, <16 x i1> undef, i32 undef)
  call <32 x i1> @llvm.vp.select.v32i1(<32 x i1> undef, <32 x i1> undef, <32 x i1> undef, i32 undef)
  call <vscale x 1 x i1> @llvm.vp.select.nxv1i1(<vscale x 1 x i1> undef, <vscale x 1 x i1> undef, <vscale x 1 x i1> undef, i32 undef)
  call <vscale x 2 x i1> @llvm.vp.select.nxv2i1(<vscale x 2 x i1> undef, <vscale x 2 x i1> undef, <vscale x 2 x i1> undef, i32 undef)
  call <vscale x 4 x i1> @llvm.vp.select.nxv4i1(<vscale x 4 x i1> undef, <vscale x 4 x i1> undef, <vscale x 4 x i1> undef, i32 undef)
  call <vscale x 8 x i1> @llvm.vp.select.nxv8i1(<vscale x 8 x i1> undef, <vscale x 8 x i1> undef, <vscale x 8 x i1> undef, i32 undef)
  call <vscale x 16 x i1> @llvm.vp.select.nxv16i1(<vscale x 16 x i1> undef, <vscale x 16 x i1> undef, <vscale x 16 x i1> undef, i32 undef)
  call <vscale x 32 x i1> @llvm.vp.select.nxv32i1(<vscale x 32 x i1> undef, <vscale x 32 x i1> undef, <vscale x 32 x i1> undef, i32 undef)

  select i1 undef, i8 undef, i8 undef
  select i1 undef, <1 x i8> undef, <1 x i8> undef
  select i1 undef, <2 x i8> undef, <2 x i8> undef
  select i1 undef, <4 x i8> undef, <4 x i8> undef
  select i1 undef, <8 x i8> undef, <8 x i8> undef
  select i1 undef, <16 x i8> undef, <16 x i8> undef
  select i1 undef, <32 x i8> undef, <32 x i8> undef
  select <1 x i1> undef, <1 x i8> undef, <1 x i8> undef
  select <2 x i1> undef, <2 x i8> undef, <2 x i8> undef
  select <4 x i1> undef, <4 x i8> undef, <4 x i8> undef
  select <8 x i1> undef, <8 x i8> undef, <8 x i8> undef
  select <16 x i1> undef, <16 x i8> undef, <16 x i8> undef
  select <32 x i1> undef, <32 x i8> undef, <32 x i8> undef
  select i1 undef, <vscale x 1 x i8> undef, <vscale x 1 x i8> undef
  select i1 undef, <vscale x 2 x i8> undef, <vscale x 2 x i8> undef
  select i1 undef, <vscale x 4 x i8> undef, <vscale x 4 x i8> undef
  select i1 undef, <vscale x 8 x i8> undef, <vscale x 8 x i8> undef
  select i1 undef, <vscale x 16 x i8> undef, <vscale x 16 x i8> undef
  select i1 undef, <vscale x 32 x i8> undef, <vscale x 32 x i8> undef
  select <vscale x 1 x i1> undef, <vscale x 1 x i8> undef, <vscale x 1 x i8> undef
  select <vscale x 2 x i1> undef, <vscale x 2 x i8> undef, <vscale x 2 x i8> undef
  select <vscale x 4 x i1> undef, <vscale x 4 x i8> undef, <vscale x 4 x i8> undef
  select <vscale x 8 x i1> undef, <vscale x 8 x i8> undef, <vscale x 8 x i8> undef
  select <vscale x 16 x i1> undef, <vscale x 16 x i8> undef, <vscale x 16 x i8> undef
  select <vscale x 32 x i1> undef, <vscale x 32 x i8> undef, <vscale x 32 x i8> undef

  call <1 x i8> @llvm.vp.select.v1i8(<1 x i1> undef, <1 x i8> undef, <1 x i8> undef, i32 undef)
  call <2 x i8> @llvm.vp.select.v2i8(<2 x i1> undef, <2 x i8> undef, <2 x i8> undef, i32 undef)
  call <4 x i8> @llvm.vp.select.v4i8(<4 x i1> undef, <4 x i8> undef, <4 x i8> undef, i32 undef)
  call <8 x i8> @llvm.vp.select.v8i8(<8 x i1> undef, <8 x i8> undef, <8 x i8> undef, i32 undef)
  call <16 x i8> @llvm.vp.select.v16i8(<16 x i1> undef, <16 x i8> undef, <16 x i8> undef, i32 undef)
  call <32 x i8> @llvm.vp.select.v32i8(<32 x i1> undef, <32 x i8> undef, <32 x i8> undef, i32 undef)
  call <vscale x 1 x i8> @llvm.vp.select.nxv1i8(<vscale x 1 x i1> undef, <vscale x 1 x i8> undef, <vscale x 1 x i8> undef, i32 undef)
  call <vscale x 2 x i8> @llvm.vp.select.nxv2i8(<vscale x 2 x i1> undef, <vscale x 2 x i8> undef, <vscale x 2 x i8> undef, i32 undef)
  call <vscale x 4 x i8> @llvm.vp.select.nxv4i8(<vscale x 4 x i1> undef, <vscale x 4 x i8> undef, <vscale x 4 x i8> undef, i32 undef)
  call <vscale x 8 x i8> @llvm.vp.select.nxv8i8(<vscale x 8 x i1> undef, <vscale x 8 x i8> undef, <vscale x 8 x i8> undef, i32 undef)
  call <vscale x 16 x i8> @llvm.vp.select.nxv16i8(<vscale x 16 x i1> undef, <vscale x 16 x i8> undef, <vscale x 16 x i8> undef, i32 undef)
  call <vscale x 32 x i8> @llvm.vp.select.nxv32i8(<vscale x 32 x i1> undef, <vscale x 32 x i8> undef, <vscale x 32 x i8> undef, i32 undef)

  select i1 undef, i16 undef, i16 undef
  select i1 undef, <1 x i16> undef, <1 x i16> undef
  select i1 undef, <2 x i16> undef, <2 x i16> undef
  select i1 undef, <4 x i16> undef, <4 x i16> undef
  select i1 undef, <8 x i16> undef, <8 x i16> undef
  select i1 undef, <16 x i16> undef, <16 x i16> undef
  select i1 undef, <32 x i16> undef, <32 x i16> undef
  select <1 x i1> undef, <1 x i16> undef, <1 x i16> undef
  select <2 x i1> undef, <2 x i16> undef, <2 x i16> undef
  select <4 x i1> undef, <4 x i16> undef, <4 x i16> undef
  select <8 x i1> undef, <8 x i16> undef, <8 x i16> undef
  select <16 x i1> undef, <16 x i16> undef, <16 x i16> undef
  select <32 x i1> undef, <32 x i16> undef, <32 x i16> undef
  select i1 undef, <vscale x 1 x i16> undef, <vscale x 1 x i16> undef
  select i1 undef, <vscale x 2 x i16> undef, <vscale x 2 x i16> undef
  select i1 undef, <vscale x 4 x i16> undef, <vscale x 4 x i16> undef
  select i1 undef, <vscale x 8 x i16> undef, <vscale x 8 x i16> undef
  select i1 undef, <vscale x 16 x i16> undef, <vscale x 16 x i16> undef
  select i1 undef, <vscale x 32 x i16> undef, <vscale x 32 x i16> undef
  select <vscale x 1 x i1> undef, <vscale x 1 x i16> undef, <vscale x 1 x i16> undef
  select <vscale x 2 x i1> undef, <vscale x 2 x i16> undef, <vscale x 2 x i16> undef
  select <vscale x 4 x i1> undef, <vscale x 4 x i16> undef, <vscale x 4 x i16> undef
  select <vscale x 8 x i1> undef, <vscale x 8 x i16> undef, <vscale x 8 x i16> undef
  select <vscale x 16 x i1> undef, <vscale x 16 x i16> undef, <vscale x 16 x i16> undef
  select <vscale x 32 x i1> undef, <vscale x 32 x i16> undef, <vscale x 32 x i16> undef

  call <1 x i16> @llvm.vp.select.v1i16(<1 x i1> undef, <1 x i16> undef, <1 x i16> undef, i32 undef)
  call <2 x i16> @llvm.vp.select.v2i16(<2 x i1> undef, <2 x i16> undef, <2 x i16> undef, i32 undef)
  call <4 x i16> @llvm.vp.select.v4i16(<4 x i1> undef, <4 x i16> undef, <4 x i16> undef, i32 undef)
  call <8 x i16> @llvm.vp.select.v8i16(<8 x i1> undef, <8 x i16> undef, <8 x i16> undef, i32 undef)
  call <16 x i16> @llvm.vp.select.v16i16(<16 x i1> undef, <16 x i16> undef, <16 x i16> undef, i32 undef)
  call <32 x i16> @llvm.vp.select.v32i16(<32 x i1> undef, <32 x i16> undef, <32 x i16> undef, i32 undef)
  call <vscale x 1 x i16> @llvm.vp.select.nxv1i16(<vscale x 1 x i1> undef, <vscale x 1 x i16> undef, <vscale x 1 x i16> undef, i32 undef)
  call <vscale x 2 x i16> @llvm.vp.select.nxv2i16(<vscale x 2 x i1> undef, <vscale x 2 x i16> undef, <vscale x 2 x i16> undef, i32 undef)
  call <vscale x 4 x i16> @llvm.vp.select.nxv4i16(<vscale x 4 x i1> undef, <vscale x 4 x i16> undef, <vscale x 4 x i16> undef, i32 undef)
  call <vscale x 8 x i16> @llvm.vp.select.nxv8i16(<vscale x 8 x i1> undef, <vscale x 8 x i16> undef, <vscale x 8 x i16> undef, i32 undef)
  call <vscale x 16 x i16> @llvm.vp.select.nxv16i16(<vscale x 16 x i1> undef, <vscale x 16 x i16> undef, <vscale x 16 x i16> undef, i32 undef)
  call <vscale x 32 x i16> @llvm.vp.select.nxv32i16(<vscale x 32 x i1> undef, <vscale x 32 x i16> undef, <vscale x 32 x i16> undef, i32 undef)

  select i1 undef, i32 undef, i32 undef
  select i1 undef, <1 x i32> undef, <1 x i32> undef
  select i1 undef, <2 x i32> undef, <2 x i32> undef
  select i1 undef, <4 x i32> undef, <4 x i32> undef
  select i1 undef, <8 x i32> undef, <8 x i32> undef
  select i1 undef, <16 x i32> undef, <16 x i32> undef
  select i1 undef, <32 x i32> undef, <32 x i32> undef
  select <1 x i1> undef, <1 x i32> undef, <1 x i32> undef
  select <2 x i1> undef, <2 x i32> undef, <2 x i32> undef
  select <4 x i1> undef, <4 x i32> undef, <4 x i32> undef
  select <8 x i1> undef, <8 x i32> undef, <8 x i32> undef
  select <16 x i1> undef, <16 x i32> undef, <16 x i32> undef
  select <32 x i1> undef, <32 x i32> undef, <32 x i32> undef
  select i1 undef, <vscale x 1 x i32> undef, <vscale x 1 x i32> undef
  select i1 undef, <vscale x 2 x i32> undef, <vscale x 2 x i32> undef
  select i1 undef, <vscale x 4 x i32> undef, <vscale x 4 x i32> undef
  select i1 undef, <vscale x 8 x i32> undef, <vscale x 8 x i32> undef
  select i1 undef, <vscale x 16 x i32> undef, <vscale x 16 x i32> undef
  select i1 undef, <vscale x 32 x i32> undef, <vscale x 32 x i32> undef
  select <vscale x 1 x i1> undef, <vscale x 1 x i32> undef, <vscale x 1 x i32> undef
  select <vscale x 2 x i1> undef, <vscale x 2 x i32> undef, <vscale x 2 x i32> undef
  select <vscale x 4 x i1> undef, <vscale x 4 x i32> undef, <vscale x 4 x i32> undef
  select <vscale x 8 x i1> undef, <vscale x 8 x i32> undef, <vscale x 8 x i32> undef
  select <vscale x 16 x i1> undef, <vscale x 16 x i32> undef, <vscale x 16 x i32> undef
  select <vscale x 32 x i1> undef, <vscale x 32 x i32> undef, <vscale x 32 x i32> undef

  call <1 x i32> @llvm.vp.select.v1i32(<1 x i1> undef, <1 x i32> undef, <1 x i32> undef, i32 undef)
  call <2 x i32> @llvm.vp.select.v2i32(<2 x i1> undef, <2 x i32> undef, <2 x i32> undef, i32 undef)
  call <4 x i32> @llvm.vp.select.v4i32(<4 x i1> undef, <4 x i32> undef, <4 x i32> undef, i32 undef)
  call <8 x i32> @llvm.vp.select.v8i32(<8 x i1> undef, <8 x i32> undef, <8 x i32> undef, i32 undef)
  call <16 x i32> @llvm.vp.select.v16i32(<16 x i1> undef, <16 x i32> undef, <16 x i32> undef, i32 undef)
  call <32 x i32> @llvm.vp.select.v32i32(<32 x i1> undef, <32 x i32> undef, <32 x i32> undef, i32 undef)
  call <vscale x 1 x i32> @llvm.vp.select.nxv1i32(<vscale x 1 x i1> undef, <vscale x 1 x i32> undef, <vscale x 1 x i32> undef, i32 undef)
  call <vscale x 2 x i32> @llvm.vp.select.nxv2i32(<vscale x 2 x i1> undef, <vscale x 2 x i32> undef, <vscale x 2 x i32> undef, i32 undef)
  call <vscale x 4 x i32> @llvm.vp.select.nxv4i32(<vscale x 4 x i1> undef, <vscale x 4 x i32> undef, <vscale x 4 x i32> undef, i32 undef)
  call <vscale x 8 x i32> @llvm.vp.select.nxv8i32(<vscale x 8 x i1> undef, <vscale x 8 x i32> undef, <vscale x 8 x i32> undef, i32 undef)
  call <vscale x 16 x i32> @llvm.vp.select.nxv16i32(<vscale x 16 x i1> undef, <vscale x 16 x i32> undef, <vscale x 16 x i32> undef, i32 undef)
  call <vscale x 32 x i32> @llvm.vp.select.nxv32i32(<vscale x 32 x i1> undef, <vscale x 32 x i32> undef, <vscale x 32 x i32> undef, i32 undef)

  select i1 undef, i64 undef, i64 undef
  select i1 undef, <1 x i64> undef, <1 x i64> undef
  select i1 undef, <2 x i64> undef, <2 x i64> undef
  select i1 undef, <4 x i64> undef, <4 x i64> undef
  select i1 undef, <8 x i64> undef, <8 x i64> undef
  select i1 undef, <16 x i64> undef, <16 x i64> undef
  select i1 undef, <32 x i64> undef, <32 x i64> undef
  select <1 x i1> undef, <1 x i64> undef, <1 x i64> undef
  select <2 x i1> undef, <2 x i64> undef, <2 x i64> undef
  select <4 x i1> undef, <4 x i64> undef, <4 x i64> undef
  select <8 x i1> undef, <8 x i64> undef, <8 x i64> undef
  select <16 x i1> undef, <16 x i64> undef, <16 x i64> undef
  select <32 x i1> undef, <32 x i64> undef, <32 x i64> undef
  select i1 undef, <vscale x 1 x i64> undef, <vscale x 1 x i64> undef
  select i1 undef, <vscale x 2 x i64> undef, <vscale x 2 x i64> undef
  select i1 undef, <vscale x 4 x i64> undef, <vscale x 4 x i64> undef
  select i1 undef, <vscale x 8 x i64> undef, <vscale x 8 x i64> undef
  select i1 undef, <vscale x 16 x i64> undef, <vscale x 16 x i64> undef
  select i1 undef, <vscale x 32 x i64> undef, <vscale x 32 x i64> undef
  select <vscale x 1 x i1> undef, <vscale x 1 x i64> undef, <vscale x 1 x i64> undef
  select <vscale x 2 x i1> undef, <vscale x 2 x i64> undef, <vscale x 2 x i64> undef
  select <vscale x 4 x i1> undef, <vscale x 4 x i64> undef, <vscale x 4 x i64> undef
  select <vscale x 8 x i1> undef, <vscale x 8 x i64> undef, <vscale x 8 x i64> undef
  select <vscale x 16 x i1> undef, <vscale x 16 x i64> undef, <vscale x 16 x i64> undef
  select <vscale x 32 x i1> undef, <vscale x 32 x i64> undef, <vscale x 32 x i64> undef

  call <1 x i64> @llvm.vp.select.v1i64(<1 x i1> undef, <1 x i64> undef, <1 x i64> undef, i32 undef)
  call <2 x i64> @llvm.vp.select.v2i64(<2 x i1> undef, <2 x i64> undef, <2 x i64> undef, i32 undef)
  call <4 x i64> @llvm.vp.select.v4i64(<4 x i1> undef, <4 x i64> undef, <4 x i64> undef, i32 undef)
  call <8 x i64> @llvm.vp.select.v8i64(<8 x i1> undef, <8 x i64> undef, <8 x i64> undef, i32 undef)
  call <16 x i64> @llvm.vp.select.v16i64(<16 x i1> undef, <16 x i64> undef, <16 x i64> undef, i32 undef)
  call <32 x i64> @llvm.vp.select.v32i64(<32 x i1> undef, <32 x i64> undef, <32 x i64> undef, i32 undef)
  call <vscale x 1 x i64> @llvm.vp.select.nxv1i64(<vscale x 1 x i1> undef, <vscale x 1 x i64> undef, <vscale x 1 x i64> undef, i32 undef)
  call <vscale x 2 x i64> @llvm.vp.select.nxv2i64(<vscale x 2 x i1> undef, <vscale x 2 x i64> undef, <vscale x 2 x i64> undef, i32 undef)
  call <vscale x 4 x i64> @llvm.vp.select.nxv4i64(<vscale x 4 x i1> undef, <vscale x 4 x i64> undef, <vscale x 4 x i64> undef, i32 undef)
  call <vscale x 8 x i64> @llvm.vp.select.nxv8i64(<vscale x 8 x i1> undef, <vscale x 8 x i64> undef, <vscale x 8 x i64> undef, i32 undef)
  call <vscale x 16 x i64> @llvm.vp.select.nxv16i64(<vscale x 16 x i1> undef, <vscale x 16 x i64> undef, <vscale x 16 x i64> undef, i32 undef)
  call <vscale x 32 x i64> @llvm.vp.select.nxv32i64(<vscale x 32 x i1> undef, <vscale x 32 x i64> undef, <vscale x 32 x i64> undef, i32 undef)

  ret void
}

define void @select_of_constants() {
; CHECK-LABEL: 'select_of_constants'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %1 = select i1 undef, <2 x i64> splat (i64 128), <2 x i64> zeroinitializer
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %2 = select i1 undef, <2 x i64> <i64 128, i64 127>, <2 x i64> zeroinitializer
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %3 = select i1 undef, <2 x i64> <i64 0, i64 1>, <2 x i64> zeroinitializer
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %4 = select i1 undef, <2 x i64> <i64 128, i64 533>, <2 x i64> <i64 0, i64 573>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %5 = select <4 x i1> undef, <4 x i32> <i32 524288, i32 262144, i32 131072, i32 65536>, <4 x i32> zeroinitializer
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  ; Splat constants
  select i1 undef, <2 x i64> <i64 128, i64 128>, <2 x i64> zeroinitializer
  ; LHS is a VID patern
  select i1 undef, <2 x i64> <i64 128, i64 127>, <2 x i64> zeroinitializer
  select i1 undef, <2 x i64> <i64 0, i64 1>, <2 x i64> zeroinitializer
  ; 2x general (expensive) constants
  select i1 undef, <2 x i64> <i64 128, i64 533>, <2 x i64> <i64 0, i64 573>

  ; powers of two (still expensive)
  select <4 x i1> undef, <4 x i32> <i32 524288, i32 262144, i32 131072, i32 65536>, <4 x i32> zeroinitializer

  ret void
}

define void @vp_merge() {
; CHECK-LABEL: 'vp_merge'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %1 = call <1 x i1> @llvm.vp.merge.v1i1(<1 x i1> undef, <1 x i1> undef, <1 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %2 = call <2 x i1> @llvm.vp.merge.v2i1(<2 x i1> undef, <2 x i1> undef, <2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %3 = call <4 x i1> @llvm.vp.merge.v4i1(<4 x i1> undef, <4 x i1> undef, <4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %4 = call <8 x i1> @llvm.vp.merge.v8i1(<8 x i1> undef, <8 x i1> undef, <8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %5 = call <16 x i1> @llvm.vp.merge.v16i1(<16 x i1> undef, <16 x i1> undef, <16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %6 = call <32 x i1> @llvm.vp.merge.v32i1(<32 x i1> undef, <32 x i1> undef, <32 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %7 = call <vscale x 1 x i1> @llvm.vp.merge.nxv1i1(<vscale x 1 x i1> undef, <vscale x 1 x i1> undef, <vscale x 1 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %8 = call <vscale x 2 x i1> @llvm.vp.merge.nxv2i1(<vscale x 2 x i1> undef, <vscale x 2 x i1> undef, <vscale x 2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %9 = call <vscale x 4 x i1> @llvm.vp.merge.nxv4i1(<vscale x 4 x i1> undef, <vscale x 4 x i1> undef, <vscale x 4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %10 = call <vscale x 8 x i1> @llvm.vp.merge.nxv8i1(<vscale x 8 x i1> undef, <vscale x 8 x i1> undef, <vscale x 8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %11 = call <vscale x 16 x i1> @llvm.vp.merge.nxv16i1(<vscale x 16 x i1> undef, <vscale x 16 x i1> undef, <vscale x 16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %12 = call <vscale x 32 x i1> @llvm.vp.merge.nxv32i1(<vscale x 32 x i1> undef, <vscale x 32 x i1> undef, <vscale x 32 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = call <1 x i8> @llvm.vp.merge.v1i8(<1 x i1> undef, <1 x i8> undef, <1 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %14 = call <2 x i8> @llvm.vp.merge.v2i8(<2 x i1> undef, <2 x i8> undef, <2 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %15 = call <4 x i8> @llvm.vp.merge.v4i8(<4 x i1> undef, <4 x i8> undef, <4 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %16 = call <8 x i8> @llvm.vp.merge.v8i8(<8 x i1> undef, <8 x i8> undef, <8 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %17 = call <16 x i8> @llvm.vp.merge.v16i8(<16 x i1> undef, <16 x i8> undef, <16 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %18 = call <32 x i8> @llvm.vp.merge.v32i8(<32 x i1> undef, <32 x i8> undef, <32 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %19 = call <vscale x 1 x i8> @llvm.vp.merge.nxv1i8(<vscale x 1 x i1> undef, <vscale x 1 x i8> undef, <vscale x 1 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %20 = call <vscale x 2 x i8> @llvm.vp.merge.nxv2i8(<vscale x 2 x i1> undef, <vscale x 2 x i8> undef, <vscale x 2 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %21 = call <vscale x 4 x i8> @llvm.vp.merge.nxv4i8(<vscale x 4 x i1> undef, <vscale x 4 x i8> undef, <vscale x 4 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %22 = call <vscale x 8 x i8> @llvm.vp.merge.nxv8i8(<vscale x 8 x i1> undef, <vscale x 8 x i8> undef, <vscale x 8 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %23 = call <vscale x 16 x i8> @llvm.vp.merge.nxv16i8(<vscale x 16 x i1> undef, <vscale x 16 x i8> undef, <vscale x 16 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %24 = call <vscale x 32 x i8> @llvm.vp.merge.nxv32i8(<vscale x 32 x i1> undef, <vscale x 32 x i8> undef, <vscale x 32 x i8> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %25 = call <1 x i16> @llvm.vp.merge.v1i16(<1 x i1> undef, <1 x i16> undef, <1 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %26 = call <2 x i16> @llvm.vp.merge.v2i16(<2 x i1> undef, <2 x i16> undef, <2 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %27 = call <4 x i16> @llvm.vp.merge.v4i16(<4 x i1> undef, <4 x i16> undef, <4 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %28 = call <8 x i16> @llvm.vp.merge.v8i16(<8 x i1> undef, <8 x i16> undef, <8 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %29 = call <16 x i16> @llvm.vp.merge.v16i16(<16 x i1> undef, <16 x i16> undef, <16 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %30 = call <32 x i16> @llvm.vp.merge.v32i16(<32 x i1> undef, <32 x i16> undef, <32 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %31 = call <vscale x 1 x i16> @llvm.vp.merge.nxv1i16(<vscale x 1 x i1> undef, <vscale x 1 x i16> undef, <vscale x 1 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %32 = call <vscale x 2 x i16> @llvm.vp.merge.nxv2i16(<vscale x 2 x i1> undef, <vscale x 2 x i16> undef, <vscale x 2 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %33 = call <vscale x 4 x i16> @llvm.vp.merge.nxv4i16(<vscale x 4 x i1> undef, <vscale x 4 x i16> undef, <vscale x 4 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %34 = call <vscale x 8 x i16> @llvm.vp.merge.nxv8i16(<vscale x 8 x i1> undef, <vscale x 8 x i16> undef, <vscale x 8 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %35 = call <vscale x 16 x i16> @llvm.vp.merge.nxv16i16(<vscale x 16 x i1> undef, <vscale x 16 x i16> undef, <vscale x 16 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %36 = call <vscale x 32 x i16> @llvm.vp.merge.nxv32i16(<vscale x 32 x i1> undef, <vscale x 32 x i16> undef, <vscale x 32 x i16> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %37 = call <1 x i32> @llvm.vp.merge.v1i32(<1 x i1> undef, <1 x i32> undef, <1 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %38 = call <2 x i32> @llvm.vp.merge.v2i32(<2 x i1> undef, <2 x i32> undef, <2 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %39 = call <4 x i32> @llvm.vp.merge.v4i32(<4 x i1> undef, <4 x i32> undef, <4 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %40 = call <8 x i32> @llvm.vp.merge.v8i32(<8 x i1> undef, <8 x i32> undef, <8 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %41 = call <16 x i32> @llvm.vp.merge.v16i32(<16 x i1> undef, <16 x i32> undef, <16 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %42 = call <32 x i32> @llvm.vp.merge.v32i32(<32 x i1> undef, <32 x i32> undef, <32 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %43 = call <vscale x 1 x i32> @llvm.vp.merge.nxv1i32(<vscale x 1 x i1> undef, <vscale x 1 x i32> undef, <vscale x 1 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %44 = call <vscale x 2 x i32> @llvm.vp.merge.nxv2i32(<vscale x 2 x i1> undef, <vscale x 2 x i32> undef, <vscale x 2 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %45 = call <vscale x 4 x i32> @llvm.vp.merge.nxv4i32(<vscale x 4 x i1> undef, <vscale x 4 x i32> undef, <vscale x 4 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %46 = call <vscale x 8 x i32> @llvm.vp.merge.nxv8i32(<vscale x 8 x i1> undef, <vscale x 8 x i32> undef, <vscale x 8 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %47 = call <vscale x 16 x i32> @llvm.vp.merge.nxv16i32(<vscale x 16 x i1> undef, <vscale x 16 x i32> undef, <vscale x 16 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %48 = call <vscale x 32 x i32> @llvm.vp.merge.nxv32i32(<vscale x 32 x i1> undef, <vscale x 32 x i32> undef, <vscale x 32 x i32> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %49 = call <1 x i64> @llvm.vp.merge.v1i64(<1 x i1> undef, <1 x i64> undef, <1 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %50 = call <2 x i64> @llvm.vp.merge.v2i64(<2 x i1> undef, <2 x i64> undef, <2 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %51 = call <4 x i64> @llvm.vp.merge.v4i64(<4 x i1> undef, <4 x i64> undef, <4 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %52 = call <8 x i64> @llvm.vp.merge.v8i64(<8 x i1> undef, <8 x i64> undef, <8 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %53 = call <16 x i64> @llvm.vp.merge.v16i64(<16 x i1> undef, <16 x i64> undef, <16 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %54 = call <32 x i64> @llvm.vp.merge.v32i64(<32 x i1> undef, <32 x i64> undef, <32 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %55 = call <vscale x 1 x i64> @llvm.vp.merge.nxv1i64(<vscale x 1 x i1> undef, <vscale x 1 x i64> undef, <vscale x 1 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %56 = call <vscale x 2 x i64> @llvm.vp.merge.nxv2i64(<vscale x 2 x i1> undef, <vscale x 2 x i64> undef, <vscale x 2 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %57 = call <vscale x 4 x i64> @llvm.vp.merge.nxv4i64(<vscale x 4 x i1> undef, <vscale x 4 x i64> undef, <vscale x 4 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %58 = call <vscale x 8 x i64> @llvm.vp.merge.nxv8i64(<vscale x 8 x i1> undef, <vscale x 8 x i64> undef, <vscale x 8 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %59 = call <vscale x 16 x i64> @llvm.vp.merge.nxv16i64(<vscale x 16 x i1> undef, <vscale x 16 x i64> undef, <vscale x 16 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %60 = call <vscale x 32 x i64> @llvm.vp.merge.nxv32i64(<vscale x 32 x i1> undef, <vscale x 32 x i64> undef, <vscale x 32 x i64> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %61 = call <1 x float> @llvm.vp.merge.v1f32(<1 x i1> undef, <1 x float> undef, <1 x float> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %62 = call <2 x float> @llvm.vp.merge.v2f32(<2 x i1> undef, <2 x float> undef, <2 x float> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %63 = call <4 x float> @llvm.vp.merge.v4f32(<4 x i1> undef, <4 x float> undef, <4 x float> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %64 = call <8 x float> @llvm.vp.merge.v8f32(<8 x i1> undef, <8 x float> undef, <8 x float> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %65 = call <16 x float> @llvm.vp.merge.v16f32(<16 x i1> undef, <16 x float> undef, <16 x float> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %66 = call <32 x float> @llvm.vp.merge.v32f32(<32 x i1> undef, <32 x float> undef, <32 x float> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %67 = call <vscale x 1 x float> @llvm.vp.merge.nxv1f32(<vscale x 1 x i1> undef, <vscale x 1 x float> undef, <vscale x 1 x float> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %68 = call <vscale x 2 x float> @llvm.vp.merge.nxv2f32(<vscale x 2 x i1> undef, <vscale x 2 x float> undef, <vscale x 2 x float> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %69 = call <vscale x 4 x float> @llvm.vp.merge.nxv4f32(<vscale x 4 x i1> undef, <vscale x 4 x float> undef, <vscale x 4 x float> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %70 = call <vscale x 8 x float> @llvm.vp.merge.nxv8f32(<vscale x 8 x i1> undef, <vscale x 8 x float> undef, <vscale x 8 x float> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %71 = call <vscale x 16 x float> @llvm.vp.merge.nxv16f32(<vscale x 16 x i1> undef, <vscale x 16 x float> undef, <vscale x 16 x float> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %72 = call <vscale x 32 x float> @llvm.vp.merge.nxv32f32(<vscale x 32 x i1> undef, <vscale x 32 x float> undef, <vscale x 32 x float> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %73 = call <1 x double> @llvm.vp.merge.v1f64(<1 x i1> undef, <1 x double> undef, <1 x double> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %74 = call <2 x double> @llvm.vp.merge.v2f64(<2 x i1> undef, <2 x double> undef, <2 x double> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %75 = call <4 x double> @llvm.vp.merge.v4f64(<4 x i1> undef, <4 x double> undef, <4 x double> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %76 = call <8 x double> @llvm.vp.merge.v8f64(<8 x i1> undef, <8 x double> undef, <8 x double> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %77 = call <16 x double> @llvm.vp.merge.v16f64(<16 x i1> undef, <16 x double> undef, <16 x double> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %78 = call <32 x double> @llvm.vp.merge.v32f64(<32 x i1> undef, <32 x double> undef, <32 x double> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %79 = call <vscale x 1 x double> @llvm.vp.merge.nxv1f64(<vscale x 1 x i1> undef, <vscale x 1 x double> undef, <vscale x 1 x double> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %80 = call <vscale x 2 x double> @llvm.vp.merge.nxv2f64(<vscale x 2 x i1> undef, <vscale x 2 x double> undef, <vscale x 2 x double> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %81 = call <vscale x 4 x double> @llvm.vp.merge.nxv4f64(<vscale x 4 x i1> undef, <vscale x 4 x double> undef, <vscale x 4 x double> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %82 = call <vscale x 8 x double> @llvm.vp.merge.nxv8f64(<vscale x 8 x i1> undef, <vscale x 8 x double> undef, <vscale x 8 x double> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %83 = call <vscale x 16 x double> @llvm.vp.merge.nxv16f64(<vscale x 16 x i1> undef, <vscale x 16 x double> undef, <vscale x 16 x double> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %84 = call <vscale x 32 x double> @llvm.vp.merge.nxv32f64(<vscale x 32 x i1> undef, <vscale x 32 x double> undef, <vscale x 32 x double> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  call <1 x i1> @llvm.vp.merge.v1i1(<1 x i1> undef, <1 x i1> undef, <1 x i1> undef, i32 undef)
  call <2 x i1> @llvm.vp.merge.v2i1(<2 x i1> undef, <2 x i1> undef, <2 x i1> undef, i32 undef)
  call <4 x i1> @llvm.vp.merge.v4i1(<4 x i1> undef, <4 x i1> undef, <4 x i1> undef, i32 undef)
  call <8 x i1> @llvm.vp.merge.v8i1(<8 x i1> undef, <8 x i1> undef, <8 x i1> undef, i32 undef)
  call <16 x i1> @llvm.vp.merge.v16i1(<16 x i1> undef, <16 x i1> undef, <16 x i1> undef, i32 undef)
  call <32 x i1> @llvm.vp.merge.v32i1(<32 x i1> undef, <32 x i1> undef, <32 x i1> undef, i32 undef)
  call <vscale x 1 x i1> @llvm.vp.merge.nxv1i1(<vscale x 1 x i1> undef, <vscale x 1 x i1> undef, <vscale x 1 x i1> undef, i32 undef)
  call <vscale x 2 x i1> @llvm.vp.merge.nxv2i1(<vscale x 2 x i1> undef, <vscale x 2 x i1> undef, <vscale x 2 x i1> undef, i32 undef)
  call <vscale x 4 x i1> @llvm.vp.merge.nxv4i1(<vscale x 4 x i1> undef, <vscale x 4 x i1> undef, <vscale x 4 x i1> undef, i32 undef)
  call <vscale x 8 x i1> @llvm.vp.merge.nxv8i1(<vscale x 8 x i1> undef, <vscale x 8 x i1> undef, <vscale x 8 x i1> undef, i32 undef)
  call <vscale x 16 x i1> @llvm.vp.merge.nxv16i1(<vscale x 16 x i1> undef, <vscale x 16 x i1> undef, <vscale x 16 x i1> undef, i32 undef)
  call <vscale x 32 x i1> @llvm.vp.merge.nxv32i1(<vscale x 32 x i1> undef, <vscale x 32 x i1> undef, <vscale x 32 x i1> undef, i32 undef)

  call <1 x i8> @llvm.vp.merge.v1i8(<1 x i1> undef, <1 x i8> undef, <1 x i8> undef, i32 undef)
  call <2 x i8> @llvm.vp.merge.v2i8(<2 x i1> undef, <2 x i8> undef, <2 x i8> undef, i32 undef)
  call <4 x i8> @llvm.vp.merge.v4i8(<4 x i1> undef, <4 x i8> undef, <4 x i8> undef, i32 undef)
  call <8 x i8> @llvm.vp.merge.v8i8(<8 x i1> undef, <8 x i8> undef, <8 x i8> undef, i32 undef)
  call <16 x i8> @llvm.vp.merge.v16i8(<16 x i1> undef, <16 x i8> undef, <16 x i8> undef, i32 undef)
  call <32 x i8> @llvm.vp.merge.v32i8(<32 x i1> undef, <32 x i8> undef, <32 x i8> undef, i32 undef)
  call <vscale x 1 x i8> @llvm.vp.merge.nxv1i8(<vscale x 1 x i1> undef, <vscale x 1 x i8> undef, <vscale x 1 x i8> undef, i32 undef)
  call <vscale x 2 x i8> @llvm.vp.merge.nxv2i8(<vscale x 2 x i1> undef, <vscale x 2 x i8> undef, <vscale x 2 x i8> undef, i32 undef)
  call <vscale x 4 x i8> @llvm.vp.merge.nxv4i8(<vscale x 4 x i1> undef, <vscale x 4 x i8> undef, <vscale x 4 x i8> undef, i32 undef)
  call <vscale x 8 x i8> @llvm.vp.merge.nxv8i8(<vscale x 8 x i1> undef, <vscale x 8 x i8> undef, <vscale x 8 x i8> undef, i32 undef)
  call <vscale x 16 x i8> @llvm.vp.merge.nxv16i8(<vscale x 16 x i1> undef, <vscale x 16 x i8> undef, <vscale x 16 x i8> undef, i32 undef)
  call <vscale x 32 x i8> @llvm.vp.merge.nxv32i8(<vscale x 32 x i1> undef, <vscale x 32 x i8> undef, <vscale x 32 x i8> undef, i32 undef)

  call <1 x i16> @llvm.vp.merge.v1i16(<1 x i1> undef, <1 x i16> undef, <1 x i16> undef, i32 undef)
  call <2 x i16> @llvm.vp.merge.v2i16(<2 x i1> undef, <2 x i16> undef, <2 x i16> undef, i32 undef)
  call <4 x i16> @llvm.vp.merge.v4i16(<4 x i1> undef, <4 x i16> undef, <4 x i16> undef, i32 undef)
  call <8 x i16> @llvm.vp.merge.v8i16(<8 x i1> undef, <8 x i16> undef, <8 x i16> undef, i32 undef)
  call <16 x i16> @llvm.vp.merge.v16i16(<16 x i1> undef, <16 x i16> undef, <16 x i16> undef, i32 undef)
  call <32 x i16> @llvm.vp.merge.v32i16(<32 x i1> undef, <32 x i16> undef, <32 x i16> undef, i32 undef)
  call <vscale x 1 x i16> @llvm.vp.merge.nxv1i16(<vscale x 1 x i1> undef, <vscale x 1 x i16> undef, <vscale x 1 x i16> undef, i32 undef)
  call <vscale x 2 x i16> @llvm.vp.merge.nxv2i16(<vscale x 2 x i1> undef, <vscale x 2 x i16> undef, <vscale x 2 x i16> undef, i32 undef)
  call <vscale x 4 x i16> @llvm.vp.merge.nxv4i16(<vscale x 4 x i1> undef, <vscale x 4 x i16> undef, <vscale x 4 x i16> undef, i32 undef)
  call <vscale x 8 x i16> @llvm.vp.merge.nxv8i16(<vscale x 8 x i1> undef, <vscale x 8 x i16> undef, <vscale x 8 x i16> undef, i32 undef)
  call <vscale x 16 x i16> @llvm.vp.merge.nxv16i16(<vscale x 16 x i1> undef, <vscale x 16 x i16> undef, <vscale x 16 x i16> undef, i32 undef)
  call <vscale x 32 x i16> @llvm.vp.merge.nxv32i16(<vscale x 32 x i1> undef, <vscale x 32 x i16> undef, <vscale x 32 x i16> undef, i32 undef)

  call <1 x i32> @llvm.vp.merge.v1i32(<1 x i1> undef, <1 x i32> undef, <1 x i32> undef, i32 undef)
  call <2 x i32> @llvm.vp.merge.v2i32(<2 x i1> undef, <2 x i32> undef, <2 x i32> undef, i32 undef)
  call <4 x i32> @llvm.vp.merge.v4i32(<4 x i1> undef, <4 x i32> undef, <4 x i32> undef, i32 undef)
  call <8 x i32> @llvm.vp.merge.v8i32(<8 x i1> undef, <8 x i32> undef, <8 x i32> undef, i32 undef)
  call <16 x i32> @llvm.vp.merge.v16i32(<16 x i1> undef, <16 x i32> undef, <16 x i32> undef, i32 undef)
  call <32 x i32> @llvm.vp.merge.v32i32(<32 x i1> undef, <32 x i32> undef, <32 x i32> undef, i32 undef)
  call <vscale x 1 x i32> @llvm.vp.merge.nxv1i32(<vscale x 1 x i1> undef, <vscale x 1 x i32> undef, <vscale x 1 x i32> undef, i32 undef)
  call <vscale x 2 x i32> @llvm.vp.merge.nxv2i32(<vscale x 2 x i1> undef, <vscale x 2 x i32> undef, <vscale x 2 x i32> undef, i32 undef)
  call <vscale x 4 x i32> @llvm.vp.merge.nxv4i32(<vscale x 4 x i1> undef, <vscale x 4 x i32> undef, <vscale x 4 x i32> undef, i32 undef)
  call <vscale x 8 x i32> @llvm.vp.merge.nxv8i32(<vscale x 8 x i1> undef, <vscale x 8 x i32> undef, <vscale x 8 x i32> undef, i32 undef)
  call <vscale x 16 x i32> @llvm.vp.merge.nxv16i32(<vscale x 16 x i1> undef, <vscale x 16 x i32> undef, <vscale x 16 x i32> undef, i32 undef)
  call <vscale x 32 x i32> @llvm.vp.merge.nxv32i32(<vscale x 32 x i1> undef, <vscale x 32 x i32> undef, <vscale x 32 x i32> undef, i32 undef)

  call <1 x i64> @llvm.vp.merge.v1i64(<1 x i1> undef, <1 x i64> undef, <1 x i64> undef, i32 undef)
  call <2 x i64> @llvm.vp.merge.v2i64(<2 x i1> undef, <2 x i64> undef, <2 x i64> undef, i32 undef)
  call <4 x i64> @llvm.vp.merge.v4i64(<4 x i1> undef, <4 x i64> undef, <4 x i64> undef, i32 undef)
  call <8 x i64> @llvm.vp.merge.v8i64(<8 x i1> undef, <8 x i64> undef, <8 x i64> undef, i32 undef)
  call <16 x i64> @llvm.vp.merge.v16i64(<16 x i1> undef, <16 x i64> undef, <16 x i64> undef, i32 undef)
  call <32 x i64> @llvm.vp.merge.v32i64(<32 x i1> undef, <32 x i64> undef, <32 x i64> undef, i32 undef)
  call <vscale x 1 x i64> @llvm.vp.merge.nxv1i64(<vscale x 1 x i1> undef, <vscale x 1 x i64> undef, <vscale x 1 x i64> undef, i32 undef)
  call <vscale x 2 x i64> @llvm.vp.merge.nxv2i64(<vscale x 2 x i1> undef, <vscale x 2 x i64> undef, <vscale x 2 x i64> undef, i32 undef)
  call <vscale x 4 x i64> @llvm.vp.merge.nxv4i64(<vscale x 4 x i1> undef, <vscale x 4 x i64> undef, <vscale x 4 x i64> undef, i32 undef)
  call <vscale x 8 x i64> @llvm.vp.merge.nxv8i64(<vscale x 8 x i1> undef, <vscale x 8 x i64> undef, <vscale x 8 x i64> undef, i32 undef)
  call <vscale x 16 x i64> @llvm.vp.merge.nxv16i64(<vscale x 16 x i1> undef, <vscale x 16 x i64> undef, <vscale x 16 x i64> undef, i32 undef)
  call <vscale x 32 x i64> @llvm.vp.merge.nxv32i64(<vscale x 32 x i1> undef, <vscale x 32 x i64> undef, <vscale x 32 x i64> undef, i32 undef)

  call <1 x float> @llvm.vp.merge.v1f32(<1 x i1> undef, <1 x float> undef, <1 x float> undef, i32 undef)
  call <2 x float> @llvm.vp.merge.v2f32(<2 x i1> undef, <2 x float> undef, <2 x float> undef, i32 undef)
  call <4 x float> @llvm.vp.merge.v4f32(<4 x i1> undef, <4 x float> undef, <4 x float> undef, i32 undef)
  call <8 x float> @llvm.vp.merge.v8f32(<8 x i1> undef, <8 x float> undef, <8 x float> undef, i32 undef)
  call <16 x float> @llvm.vp.merge.v16f32(<16 x i1> undef, <16 x float> undef, <16 x float> undef, i32 undef)
  call <32 x float> @llvm.vp.merge.v32f32(<32 x i1> undef, <32 x float> undef, <32 x float> undef, i32 undef)
  call <vscale x 1 x float> @llvm.vp.merge.nxv1f32(<vscale x 1 x i1> undef, <vscale x 1 x float> undef, <vscale x 1 x float> undef, i32 undef)
  call <vscale x 2 x float> @llvm.vp.merge.nxv2f32(<vscale x 2 x i1> undef, <vscale x 2 x float> undef, <vscale x 2 x float> undef, i32 undef)
  call <vscale x 4 x float> @llvm.vp.merge.nxv4f32(<vscale x 4 x i1> undef, <vscale x 4 x float> undef, <vscale x 4 x float> undef, i32 undef)
  call <vscale x 8 x float> @llvm.vp.merge.nxv8f32(<vscale x 8 x i1> undef, <vscale x 8 x float> undef, <vscale x 8 x float> undef, i32 undef)
  call <vscale x 16 x float> @llvm.vp.merge.nxv16f32(<vscale x 16 x i1> undef, <vscale x 16 x float> undef, <vscale x 16 x float> undef, i32 undef)
  call <vscale x 32 x float> @llvm.vp.merge.nxv32f32(<vscale x 32 x i1> undef, <vscale x 32 x float> undef, <vscale x 32 x float> undef, i32 undef)

  call <1 x double> @llvm.vp.merge.v1f64(<1 x i1> undef, <1 x double> undef, <1 x double> undef, i32 undef)
  call <2 x double> @llvm.vp.merge.v2f64(<2 x i1> undef, <2 x double> undef, <2 x double> undef, i32 undef)
  call <4 x double> @llvm.vp.merge.v4f64(<4 x i1> undef, <4 x double> undef, <4 x double> undef, i32 undef)
  call <8 x double> @llvm.vp.merge.v8f64(<8 x i1> undef, <8 x double> undef, <8 x double> undef, i32 undef)
  call <16 x double> @llvm.vp.merge.v16f64(<16 x i1> undef, <16 x double> undef, <16 x double> undef, i32 undef)
  call <32 x double> @llvm.vp.merge.v32f64(<32 x i1> undef, <32 x double> undef, <32 x double> undef, i32 undef)
  call <vscale x 1 x double> @llvm.vp.merge.nxv1f64(<vscale x 1 x i1> undef, <vscale x 1 x double> undef, <vscale x 1 x double> undef, i32 undef)
  call <vscale x 2 x double> @llvm.vp.merge.nxv2f64(<vscale x 2 x i1> undef, <vscale x 2 x double> undef, <vscale x 2 x double> undef, i32 undef)
  call <vscale x 4 x double> @llvm.vp.merge.nxv4f64(<vscale x 4 x i1> undef, <vscale x 4 x double> undef, <vscale x 4 x double> undef, i32 undef)
  call <vscale x 8 x double> @llvm.vp.merge.nxv8f64(<vscale x 8 x i1> undef, <vscale x 8 x double> undef, <vscale x 8 x double> undef, i32 undef)
  call <vscale x 16 x double> @llvm.vp.merge.nxv16f64(<vscale x 16 x i1> undef, <vscale x 16 x double> undef, <vscale x 16 x double> undef, i32 undef)
  call <vscale x 32 x double> @llvm.vp.merge.nxv32f64(<vscale x 32 x i1> undef, <vscale x 32 x double> undef, <vscale x 32 x double> undef, i32 undef)

  ret void
}
