; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=verify,iroutliner -ir-outlining-no-cost -no-ir-sim-intrinsics < %s | FileCheck %s

; This test checks that we do not outline memcpy intrinsics since it may require
; extra address space checks.

declare void @llvm.memmove.p0.p0.i64(ptr nocapture writeonly, ptr nocapture readonly, i64, i1)

define i8 @function1(ptr noalias %s, ptr noalias %d, i64 %len) {
; CHECK-LABEL: @function1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B_LOC:%.*]] = alloca i8, align 1
; CHECK-NEXT:    [[A_LOC:%.*]] = alloca i8, align 1
; CHECK-NEXT:    [[RET_LOC:%.*]] = alloca i8, align 1
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 -1, ptr [[A_LOC]])
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 -1, ptr [[B_LOC]])
; CHECK-NEXT:    call void @outlined_ir_func_1(ptr [[S:%.*]], ptr [[D:%.*]], ptr [[A_LOC]], ptr [[B_LOC]])
; CHECK-NEXT:    [[A_RELOAD:%.*]] = load i8, ptr [[A_LOC]], align 1
; CHECK-NEXT:    [[B_RELOAD:%.*]] = load i8, ptr [[B_LOC]], align 1
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 -1, ptr [[A_LOC]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 -1, ptr [[B_LOC]])
; CHECK-NEXT:    call void @llvm.memmove.p0.p0.i64(ptr [[D]], ptr [[S]], i64 [[LEN:%.*]], i1 false)
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 -1, ptr [[RET_LOC]])
; CHECK-NEXT:    call void @outlined_ir_func_0(i8 [[A_RELOAD]], i8 [[B_RELOAD]], ptr [[S]], ptr [[RET_LOC]])
; CHECK-NEXT:    [[RET_RELOAD:%.*]] = load i8, ptr [[RET_LOC]], align 1
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 -1, ptr [[RET_LOC]])
; CHECK-NEXT:    ret i8 [[RET_RELOAD]]
;
entry:
  %a = load i8, ptr %s
  %b = load i8, ptr %d
  call void @llvm.memmove.p0.p0.i64(ptr %d, ptr %s, i64 %len, i1 false)
  %c = add i8 %a, %b
  %ret = load i8, ptr %s
  ret i8 %ret
}

define i8 @function2(ptr noalias %s, ptr noalias %d, i64 %len) {
; CHECK-LABEL: @function2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B_LOC:%.*]] = alloca i8, align 1
; CHECK-NEXT:    [[A_LOC:%.*]] = alloca i8, align 1
; CHECK-NEXT:    [[RET_LOC:%.*]] = alloca i8, align 1
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 -1, ptr [[A_LOC]])
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 -1, ptr [[B_LOC]])
; CHECK-NEXT:    call void @outlined_ir_func_1(ptr [[S:%.*]], ptr [[D:%.*]], ptr [[A_LOC]], ptr [[B_LOC]])
; CHECK-NEXT:    [[A_RELOAD:%.*]] = load i8, ptr [[A_LOC]], align 1
; CHECK-NEXT:    [[B_RELOAD:%.*]] = load i8, ptr [[B_LOC]], align 1
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 -1, ptr [[A_LOC]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 -1, ptr [[B_LOC]])
; CHECK-NEXT:    call void @llvm.memmove.p0.p0.i64(ptr [[D]], ptr [[S]], i64 [[LEN:%.*]], i1 false)
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 -1, ptr [[RET_LOC]])
; CHECK-NEXT:    call void @outlined_ir_func_0(i8 [[A_RELOAD]], i8 [[B_RELOAD]], ptr [[S]], ptr [[RET_LOC]])
; CHECK-NEXT:    [[RET_RELOAD:%.*]] = load i8, ptr [[RET_LOC]], align 1
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 -1, ptr [[RET_LOC]])
; CHECK-NEXT:    ret i8 [[RET_RELOAD]]
;
entry:
  %a = load i8, ptr %s
  %b = load i8, ptr %d
  call void @llvm.memmove.p0.p0.i64(ptr %d, ptr %s, i64 %len, i1 false)
  %c = add i8 %a, %b
  %ret = load i8, ptr %s
  ret i8 %ret
}
