; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 --mattr=+f,+d --target-abi=ilp32d --verify-machineinstrs < %s \
; RUN:   | FileCheck --check-prefix=LA32 %s
; RUN: llc --mtriple=loongarch64 --mattr=+f,+d --target-abi=lp64d --verify-machineinstrs < %s \
; RUN:   | FileCheck --check-prefix=LA64 %s

;; These test that we can use architectural names ($f[0-9]*) refer to registers in
;; inline asm constraint lists. In each case, the named register should be used
;; for the source register of the `fabs.d`. It is very likely that `$fa0` will
;; be chosen as the designation register, but this is left to the compiler to
;; choose.
;;
;; Parenthesised registers in comments are the other aliases for this register.

define double @register_f0(double %a) nounwind {
; LA32-LABEL: register_f0:
; LA32:       # %bb.0:
; LA32-NEXT:    #APP
; LA32-NEXT:    fabs.d $fa0, $fa0
; LA32-NEXT:    #NO_APP
; LA32-NEXT:    ret
;
; LA64-LABEL: register_f0:
; LA64:       # %bb.0:
; LA64-NEXT:    #APP
; LA64-NEXT:    fabs.d $fa0, $fa0
; LA64-NEXT:    #NO_APP
; LA64-NEXT:    ret
  %1 = tail call double asm "fabs.d $0, $1", "=f,{$f0}"(double %a)
  ret double %1
}

;; NOTE: This test uses `$f24` (`$fs0`) as an input, so it should be saved.
define double @register_f24(double %a) nounwind {
; LA32-LABEL: register_f24:
; LA32:       # %bb.0:
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    fst.d $fs0, $sp, 8 # 8-byte Folded Spill
; LA32-NEXT:    fmov.d $fs0, $fa0
; LA32-NEXT:    #APP
; LA32-NEXT:    fabs.d $fa0, $fs0
; LA32-NEXT:    #NO_APP
; LA32-NEXT:    fld.d $fs0, $sp, 8 # 8-byte Folded Reload
; LA32-NEXT:    addi.w $sp, $sp, 16
; LA32-NEXT:    ret
;
; LA64-LABEL: register_f24:
; LA64:       # %bb.0:
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    fst.d $fs0, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    fmov.d $fs0, $fa0
; LA64-NEXT:    #APP
; LA64-NEXT:    fabs.d $fa0, $fs0
; LA64-NEXT:    #NO_APP
; LA64-NEXT:    fld.d $fs0, $sp, 8 # 8-byte Folded Reload
; LA64-NEXT:    addi.d $sp, $sp, 16
; LA64-NEXT:    ret
  %1 = tail call double asm "fabs.d $0, $1", "=f,{$f24}"(double %a)
  ret double %1
}

;; NOTE: This test uses `$f31` (`$fs7`) as an input, so it should be saved.
define double @register_f31(double %a) nounwind {
; LA32-LABEL: register_f31:
; LA32:       # %bb.0:
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    fst.d $fs7, $sp, 8 # 8-byte Folded Spill
; LA32-NEXT:    fmov.d $fs7, $fa0
; LA32-NEXT:    #APP
; LA32-NEXT:    fabs.d $fa0, $fs7
; LA32-NEXT:    #NO_APP
; LA32-NEXT:    fld.d $fs7, $sp, 8 # 8-byte Folded Reload
; LA32-NEXT:    addi.w $sp, $sp, 16
; LA32-NEXT:    ret
;
; LA64-LABEL: register_f31:
; LA64:       # %bb.0:
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    fst.d $fs7, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    fmov.d $fs7, $fa0
; LA64-NEXT:    #APP
; LA64-NEXT:    fabs.d $fa0, $fs7
; LA64-NEXT:    #NO_APP
; LA64-NEXT:    fld.d $fs7, $sp, 8 # 8-byte Folded Reload
; LA64-NEXT:    addi.d $sp, $sp, 16
; LA64-NEXT:    ret
  %1 = tail call double asm "fabs.d $0, $1", "=f,{$f31}"(double %a)
  ret double %1
}
