; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64 | FileCheck %s

;
; trunc(nabs(sub(sext(a),sext(b)))) -> nabds(a,b)
;

define i8 @abd_ext_i8(i8 %a, i8 %b) nounwind {
; CHECK-LABEL: abd_ext_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxtb w8, w0
; CHECK-NEXT:    sub w8, w8, w1, sxtb
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cneg w0, w8, pl
; CHECK-NEXT:    ret
  %aext = sext i8 %a to i64
  %bext = sext i8 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 false)
  %nabs = sub i64 0, %abs
  %trunc = trunc i64 %nabs to i8
  ret i8 %trunc
}

define i8 @abd_ext_i8_i16(i8 %a, i16 %b) nounwind {
; CHECK-LABEL: abd_ext_i8_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxtb w8, w0
; CHECK-NEXT:    sub w8, w8, w1, sxth
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cneg w0, w8, pl
; CHECK-NEXT:    ret
  %aext = sext i8 %a to i64
  %bext = sext i16 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 false)
  %nabs = sub i64 0, %abs
  %trunc = trunc i64 %nabs to i8
  ret i8 %trunc
}

define i8 @abd_ext_i8_undef(i8 %a, i8 %b) nounwind {
; CHECK-LABEL: abd_ext_i8_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxtb w8, w0
; CHECK-NEXT:    sub w8, w8, w1, sxtb
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cneg w0, w8, pl
; CHECK-NEXT:    ret
  %aext = sext i8 %a to i64
  %bext = sext i8 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 true)
  %nabs = sub i64 0, %abs
  %trunc = trunc i64 %nabs to i8
  ret i8 %trunc
}

define i16 @abd_ext_i16(i16 %a, i16 %b) nounwind {
; CHECK-LABEL: abd_ext_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxth w8, w0
; CHECK-NEXT:    sub w8, w8, w1, sxth
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cneg w0, w8, pl
; CHECK-NEXT:    ret
  %aext = sext i16 %a to i64
  %bext = sext i16 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 false)
  %nabs = sub i64 0, %abs
  %trunc = trunc i64 %nabs to i16
  ret i16 %trunc
}

define i16 @abd_ext_i16_i32(i16 %a, i32 %b) nounwind {
; CHECK-LABEL: abd_ext_i16_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxth w8, w0
; CHECK-NEXT:    sub w9, w1, w8
; CHECK-NEXT:    subs w8, w8, w1
; CHECK-NEXT:    csel w8, w8, w9, gt
; CHECK-NEXT:    neg w0, w8
; CHECK-NEXT:    ret
  %aext = sext i16 %a to i64
  %bext = sext i32 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 false)
  %nabs = sub i64 0, %abs
  %trunc = trunc i64 %nabs to i16
  ret i16 %trunc
}

define i16 @abd_ext_i16_undef(i16 %a, i16 %b) nounwind {
; CHECK-LABEL: abd_ext_i16_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxth w8, w0
; CHECK-NEXT:    sub w8, w8, w1, sxth
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cneg w0, w8, pl
; CHECK-NEXT:    ret
  %aext = sext i16 %a to i64
  %bext = sext i16 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 true)
  %nabs = sub i64 0, %abs
  %trunc = trunc i64 %nabs to i16
  ret i16 %trunc
}

define i32 @abd_ext_i32(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: abd_ext_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w1, w0
; CHECK-NEXT:    subs w9, w0, w1
; CHECK-NEXT:    csel w8, w9, w8, gt
; CHECK-NEXT:    neg w0, w8
; CHECK-NEXT:    ret
  %aext = sext i32 %a to i64
  %bext = sext i32 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 false)
  %nabs = sub i64 0, %abs
  %trunc = trunc i64 %nabs to i32
  ret i32 %trunc
}

define i32 @abd_ext_i32_i16(i32 %a, i16 %b) nounwind {
; CHECK-LABEL: abd_ext_i32_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxth w8, w1
; CHECK-NEXT:    sub w9, w8, w0
; CHECK-NEXT:    subs w8, w0, w8
; CHECK-NEXT:    csel w8, w8, w9, gt
; CHECK-NEXT:    neg w0, w8
; CHECK-NEXT:    ret
  %aext = sext i32 %a to i64
  %bext = sext i16 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 false)
  %nabs = sub i64 0, %abs
  %trunc = trunc i64 %nabs to i32
  ret i32 %trunc
}

define i32 @abd_ext_i32_undef(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: abd_ext_i32_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w1, w0
; CHECK-NEXT:    subs w9, w0, w1
; CHECK-NEXT:    csel w8, w9, w8, gt
; CHECK-NEXT:    neg w0, w8
; CHECK-NEXT:    ret
  %aext = sext i32 %a to i64
  %bext = sext i32 %b to i64
  %sub = sub i64 %aext, %bext
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 true)
  %nabs = sub i64 0, %abs
  %trunc = trunc i64 %nabs to i32
  ret i32 %trunc
}

define i64 @abd_ext_i64(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: abd_ext_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub x8, x1, x0
; CHECK-NEXT:    subs x9, x0, x1
; CHECK-NEXT:    csel x8, x9, x8, gt
; CHECK-NEXT:    neg x0, x8
; CHECK-NEXT:    ret
  %aext = sext i64 %a to i128
  %bext = sext i64 %b to i128
  %sub = sub i128 %aext, %bext
  %abs = call i128 @llvm.abs.i128(i128 %sub, i1 false)
  %nabs = sub i128 0, %abs
  %trunc = trunc i128 %nabs to i64
  ret i64 %trunc
}

define i64 @abd_ext_i64_undef(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: abd_ext_i64_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub x8, x1, x0
; CHECK-NEXT:    subs x9, x0, x1
; CHECK-NEXT:    csel x8, x9, x8, gt
; CHECK-NEXT:    neg x0, x8
; CHECK-NEXT:    ret
  %aext = sext i64 %a to i128
  %bext = sext i64 %b to i128
  %sub = sub i128 %aext, %bext
  %abs = call i128 @llvm.abs.i128(i128 %sub, i1 true)
  %nabs = sub i128 0, %abs
  %trunc = trunc i128 %nabs to i64
  ret i64 %trunc
}

define i128 @abd_ext_i128(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: abd_ext_i128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    subs x8, x0, x2
; CHECK-NEXT:    sbc x9, x1, x3
; CHECK-NEXT:    subs x10, x2, x0
; CHECK-NEXT:    sbc x11, x3, x1
; CHECK-NEXT:    sbcs xzr, x3, x1
; CHECK-NEXT:    csel x8, x8, x10, lt
; CHECK-NEXT:    csel x9, x9, x11, lt
; CHECK-NEXT:    negs x0, x8
; CHECK-NEXT:    ngc x1, x9
; CHECK-NEXT:    ret
  %aext = sext i128 %a to i256
  %bext = sext i128 %b to i256
  %sub = sub i256 %aext, %bext
  %abs = call i256 @llvm.abs.i256(i256 %sub, i1 false)
  %nabs = sub i256 0, %abs
  %trunc = trunc i256 %nabs to i128
  ret i128 %trunc
}

define i128 @abd_ext_i128_undef(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: abd_ext_i128_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    subs x8, x0, x2
; CHECK-NEXT:    sbc x9, x1, x3
; CHECK-NEXT:    subs x10, x2, x0
; CHECK-NEXT:    sbc x11, x3, x1
; CHECK-NEXT:    sbcs xzr, x3, x1
; CHECK-NEXT:    csel x8, x8, x10, lt
; CHECK-NEXT:    csel x9, x9, x11, lt
; CHECK-NEXT:    negs x0, x8
; CHECK-NEXT:    ngc x1, x9
; CHECK-NEXT:    ret
  %aext = sext i128 %a to i256
  %bext = sext i128 %b to i256
  %sub = sub i256 %aext, %bext
  %abs = call i256 @llvm.abs.i256(i256 %sub, i1 true)
  %nabs = sub i256 0, %abs
  %trunc = trunc i256 %nabs to i128
  ret i128 %trunc
}

;
; sub(smin(a,b),smax(a,b)) -> nabds(a,b)
;

define i8 @abd_minmax_i8(i8 %a, i8 %b) nounwind {
; CHECK-LABEL: abd_minmax_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxtb w8, w1
; CHECK-NEXT:    sxtb w9, w0
; CHECK-NEXT:    cmp w9, w8
; CHECK-NEXT:    csel w10, w9, w8, lt
; CHECK-NEXT:    csel w8, w9, w8, gt
; CHECK-NEXT:    sub w0, w10, w8
; CHECK-NEXT:    ret
  %min = call i8 @llvm.smin.i8(i8 %a, i8 %b)
  %max = call i8 @llvm.smax.i8(i8 %a, i8 %b)
  %sub = sub i8 %min, %max
  ret i8 %sub
}

define i16 @abd_minmax_i16(i16 %a, i16 %b) nounwind {
; CHECK-LABEL: abd_minmax_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxth w8, w1
; CHECK-NEXT:    sxth w9, w0
; CHECK-NEXT:    cmp w9, w8
; CHECK-NEXT:    csel w10, w9, w8, lt
; CHECK-NEXT:    csel w8, w9, w8, gt
; CHECK-NEXT:    sub w0, w10, w8
; CHECK-NEXT:    ret
  %min = call i16 @llvm.smin.i16(i16 %a, i16 %b)
  %max = call i16 @llvm.smax.i16(i16 %a, i16 %b)
  %sub = sub i16 %min, %max
  ret i16 %sub
}

define i32 @abd_minmax_i32(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: abd_minmax_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp w0, w1
; CHECK-NEXT:    csel w8, w0, w1, lt
; CHECK-NEXT:    csel w9, w0, w1, gt
; CHECK-NEXT:    sub w0, w8, w9
; CHECK-NEXT:    ret
  %min = call i32 @llvm.smin.i32(i32 %a, i32 %b)
  %max = call i32 @llvm.smax.i32(i32 %a, i32 %b)
  %sub = sub i32 %min, %max
  ret i32 %sub
}

define i64 @abd_minmax_i64(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: abd_minmax_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x1
; CHECK-NEXT:    csel x8, x0, x1, lt
; CHECK-NEXT:    csel x9, x0, x1, gt
; CHECK-NEXT:    sub x0, x8, x9
; CHECK-NEXT:    ret
  %min = call i64 @llvm.smin.i64(i64 %a, i64 %b)
  %max = call i64 @llvm.smax.i64(i64 %a, i64 %b)
  %sub = sub i64 %min, %max
  ret i64 %sub
}

define i128 @abd_minmax_i128(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: abd_minmax_i128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    sbcs xzr, x1, x3
; CHECK-NEXT:    csel x8, x1, x3, lt
; CHECK-NEXT:    csel x9, x0, x2, lt
; CHECK-NEXT:    cmp x2, x0
; CHECK-NEXT:    sbcs xzr, x3, x1
; CHECK-NEXT:    csel x10, x0, x2, lt
; CHECK-NEXT:    csel x11, x1, x3, lt
; CHECK-NEXT:    subs x0, x9, x10
; CHECK-NEXT:    sbc x1, x8, x11
; CHECK-NEXT:    ret
  %min = call i128 @llvm.smin.i128(i128 %a, i128 %b)
  %max = call i128 @llvm.smax.i128(i128 %a, i128 %b)
  %sub = sub i128 %min, %max
  ret i128 %sub
}

;
; select(icmp(a,b),sub(a,b),sub(b,a)) -> nabds(a,b)
;

define i8 @abd_cmp_i8(i8 %a, i8 %b) nounwind {
; CHECK-LABEL: abd_cmp_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxtb w8, w0
; CHECK-NEXT:    sub w9, w0, w1
; CHECK-NEXT:    sub w10, w1, w0
; CHECK-NEXT:    cmp w8, w1, sxtb
; CHECK-NEXT:    csel w0, w9, w10, le
; CHECK-NEXT:    ret
  %cmp = icmp sle i8 %a, %b
  %ab = sub i8 %a, %b
  %ba = sub i8 %b, %a
  %sel = select i1 %cmp, i8 %ab, i8 %ba
  ret i8 %sel
}

define i16 @abd_cmp_i16(i16 %a, i16 %b) nounwind {
; CHECK-LABEL: abd_cmp_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sxth w8, w0
; CHECK-NEXT:    sub w9, w0, w1
; CHECK-NEXT:    sub w10, w1, w0
; CHECK-NEXT:    cmp w8, w1, sxth
; CHECK-NEXT:    csel w0, w9, w10, lt
; CHECK-NEXT:    ret
  %cmp = icmp slt i16 %a, %b
  %ab = sub i16 %a, %b
  %ba = sub i16 %b, %a
  %sel = select i1 %cmp, i16 %ab, i16 %ba
  ret i16 %sel
}

define i32 @abd_cmp_i32(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: abd_cmp_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w1, w0
; CHECK-NEXT:    subs w9, w0, w1
; CHECK-NEXT:    csel w0, w8, w9, ge
; CHECK-NEXT:    ret
  %cmp = icmp sge i32 %a, %b
  %ab = sub i32 %a, %b
  %ba = sub i32 %b, %a
  %sel = select i1 %cmp, i32 %ba, i32 %ab
  ret i32 %sel
}

define i64 @abd_cmp_i64(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: abd_cmp_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub x8, x1, x0
; CHECK-NEXT:    subs x9, x0, x1
; CHECK-NEXT:    csel x0, x9, x8, lt
; CHECK-NEXT:    ret
  %cmp = icmp slt i64 %a, %b
  %ab = sub i64 %a, %b
  %ba = sub i64 %b, %a
  %sel = select i1 %cmp, i64 %ab, i64 %ba
  ret i64 %sel
}

define i128 @abd_cmp_i128(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: abd_cmp_i128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    sbc x8, x1, x3
; CHECK-NEXT:    subs x9, x2, x0
; CHECK-NEXT:    sbc x10, x3, x1
; CHECK-NEXT:    subs x11, x0, x2
; CHECK-NEXT:    sbcs xzr, x1, x3
; CHECK-NEXT:    csel x0, x11, x9, lt
; CHECK-NEXT:    csel x1, x8, x10, lt
; CHECK-NEXT:    ret
  %cmp = icmp slt i128 %a, %b
  %ab = sub i128 %a, %b
  %ba = sub i128 %b, %a
  %sel = select i1 %cmp, i128 %ab, i128 %ba
  ret i128 %sel
}

;
; nabs(sub_nsw(x, y)) -> nabds(a,b)
;

define i8 @abd_subnsw_i8(i8 %a, i8 %b) nounwind {
; CHECK-LABEL: abd_subnsw_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w0, w1
; CHECK-NEXT:    sbfx w9, w8, #7, #1
; CHECK-NEXT:    eor w8, w8, w9
; CHECK-NEXT:    sub w0, w9, w8
; CHECK-NEXT:    ret
  %sub = sub nsw i8 %a, %b
  %abs = call i8 @llvm.abs.i8(i8 %sub, i1 false)
  %nabs = sub i8 0, %abs
  ret i8 %nabs
}

define i8 @abd_subnsw_i8_undef(i8 %a, i8 %b) nounwind {
; CHECK-LABEL: abd_subnsw_i8_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w0, w1
; CHECK-NEXT:    sbfx w9, w8, #7, #1
; CHECK-NEXT:    eor w8, w8, w9
; CHECK-NEXT:    sub w0, w9, w8
; CHECK-NEXT:    ret
  %sub = sub nsw i8 %a, %b
  %abs = call i8 @llvm.abs.i8(i8 %sub, i1 true)
  %nabs = sub i8 0, %abs
  ret i8 %nabs
}

define i16 @abd_subnsw_i16(i16 %a, i16 %b) nounwind {
; CHECK-LABEL: abd_subnsw_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w0, w1
; CHECK-NEXT:    sbfx w9, w8, #15, #1
; CHECK-NEXT:    eor w8, w8, w9
; CHECK-NEXT:    sub w0, w9, w8
; CHECK-NEXT:    ret
  %sub = sub nsw i16 %a, %b
  %abs = call i16 @llvm.abs.i16(i16 %sub, i1 false)
  %nabs = sub i16 0, %abs
  ret i16 %nabs
}

define i16 @abd_subnsw_i16_undef(i16 %a, i16 %b) nounwind {
; CHECK-LABEL: abd_subnsw_i16_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w0, w1
; CHECK-NEXT:    sbfx w9, w8, #15, #1
; CHECK-NEXT:    eor w8, w8, w9
; CHECK-NEXT:    sub w0, w9, w8
; CHECK-NEXT:    ret
  %sub = sub nsw i16 %a, %b
  %abs = call i16 @llvm.abs.i16(i16 %sub, i1 true)
  %nabs = sub i16 0, %abs
  ret i16 %nabs
}

define i32 @abd_subnsw_i32(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: abd_subnsw_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    subs w8, w0, w1
; CHECK-NEXT:    cneg w0, w8, pl
; CHECK-NEXT:    ret
  %sub = sub nsw i32 %a, %b
  %abs = call i32 @llvm.abs.i32(i32 %sub, i1 false)
  %nabs = sub i32 0, %abs
  ret i32 %nabs
}

define i32 @abd_subnsw_i32_undef(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: abd_subnsw_i32_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    subs w8, w0, w1
; CHECK-NEXT:    cneg w0, w8, pl
; CHECK-NEXT:    ret
  %sub = sub nsw i32 %a, %b
  %abs = call i32 @llvm.abs.i32(i32 %sub, i1 true)
  %nabs = sub i32 0, %abs
  ret i32 %nabs
}

define i64 @abd_subnsw_i64(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: abd_subnsw_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    subs x8, x0, x1
; CHECK-NEXT:    cneg x0, x8, pl
; CHECK-NEXT:    ret
  %sub = sub nsw i64 %a, %b
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 false)
  %nabs = sub i64 0, %abs
  ret i64 %nabs
}

define i64 @abd_subnsw_i64_undef(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: abd_subnsw_i64_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    subs x8, x0, x1
; CHECK-NEXT:    cneg x0, x8, pl
; CHECK-NEXT:    ret
  %sub = sub nsw i64 %a, %b
  %abs = call i64 @llvm.abs.i64(i64 %sub, i1 true)
  %nabs = sub i64 0, %abs
  ret i64 %nabs
}

define i128 @abd_subnsw_i128(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: abd_subnsw_i128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    subs x8, x0, x2
; CHECK-NEXT:    sbc x9, x1, x3
; CHECK-NEXT:    asr x10, x9, #63
; CHECK-NEXT:    eor x8, x8, x10
; CHECK-NEXT:    eor x9, x9, x10
; CHECK-NEXT:    subs x0, x10, x8
; CHECK-NEXT:    sbc x1, x10, x9
; CHECK-NEXT:    ret
  %sub = sub nsw i128 %a, %b
  %abs = call i128 @llvm.abs.i128(i128 %sub, i1 false)
  %nabs = sub i128 0, %abs
  ret i128 %nabs
}

define i128 @abd_subnsw_i128_undef(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: abd_subnsw_i128_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    subs x8, x0, x2
; CHECK-NEXT:    sbc x9, x1, x3
; CHECK-NEXT:    asr x10, x9, #63
; CHECK-NEXT:    eor x8, x8, x10
; CHECK-NEXT:    eor x9, x9, x10
; CHECK-NEXT:    subs x0, x10, x8
; CHECK-NEXT:    sbc x1, x10, x9
; CHECK-NEXT:    ret
  %sub = sub nsw i128 %a, %b
  %abs = call i128 @llvm.abs.i128(i128 %sub, i1 true)
  %nabs = sub i128 0, %abs
  ret i128 %nabs
}

declare i8 @llvm.abs.i8(i8, i1)
declare i16 @llvm.abs.i16(i16, i1)
declare i32 @llvm.abs.i32(i32, i1)
declare i64 @llvm.abs.i64(i64, i1)
declare i128 @llvm.abs.i128(i128, i1)

declare i8 @llvm.smax.i8(i8, i8)
declare i16 @llvm.smax.i16(i16, i16)
declare i32 @llvm.smax.i32(i32, i32)
declare i64 @llvm.smax.i64(i64, i64)

declare i8 @llvm.smin.i8(i8, i8)
declare i16 @llvm.smin.i16(i16, i16)
declare i32 @llvm.smin.i32(i32, i32)
declare i64 @llvm.smin.i64(i64, i64)
