; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -disable-output "-passes=print<scalar-evolution>" -scalar-evolution-max-iterations=0  -scalar-evolution-classify-expressions=0  2>&1 | FileCheck %s

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

@A = weak global [1000 x i32] zeroinitializer, align 32

define void @PR1101(i32 %N) {
; CHECK-LABEL: 'PR1101'
; CHECK-NEXT:  Determining loop execution counts for: @PR1101
; CHECK-NEXT:  Loop %bb3: backedge-taken count is i32 10000
; CHECK-NEXT:  Loop %bb3: constant max backedge-taken count is i32 10000
; CHECK-NEXT:  Loop %bb3: symbolic max backedge-taken count is i32 10000
; CHECK-NEXT:  Loop %bb3: Trip multiple is 10001
;
entry:
  br label %bb3

bb:             ; preds = %bb3
  %tmp = getelementptr [1000 x i32], ptr @A, i32 0, i32 %i.0          ; <ptr> [#uses=1]
  store i32 123, ptr %tmp
  %tmp2 = add i32 %i.0, 1         ; <i32> [#uses=1]
  br label %bb3

bb3:            ; preds = %bb, %entry
  %i.0 = phi i32 [ 0, %entry ], [ %tmp2, %bb ]            ; <i32> [#uses=3]
  %tmp3 = icmp sle i32 %i.0, 9999          ; <i1> [#uses=1]
  br i1 %tmp3, label %bb, label %bb5

bb5:            ; preds = %bb3
  br label %return

return:         ; preds = %bb5
  ret void
}

define i32 @PR22795() {
; CHECK-LABEL: 'PR22795'
; CHECK-NEXT:  Determining loop execution counts for: @PR22795
; CHECK-NEXT:  Loop %preheader: backedge-taken count is i64 7
; CHECK-NEXT:  Loop %preheader: constant max backedge-taken count is i64 7
; CHECK-NEXT:  Loop %preheader: symbolic max backedge-taken count is i64 7
; CHECK-NEXT:  Loop %preheader: Trip multiple is 8
;
entry:
  %bins = alloca [16 x i64], align 16
  call void @llvm.memset.p0.i64(ptr align 16 %bins, i8 0, i64 128, i1 false)
  br label %preheader

preheader:                                        ; preds = %for.inc.1, %entry
  %v11 = phi i64 [ 0, %entry ], [ %next12.1, %for.inc.1 ]
  %iv = phi i32 [ -1, %entry ], [ %next.1, %for.inc.1 ]
  %cmp = icmp sgt i64 %v11, 0
  br i1 %cmp, label %for.body, label %for.inc

for.body:                                         ; preds = %preheader
  %zext = zext i32 %iv to i64
  %arrayidx = getelementptr [16 x i64], ptr %bins, i64 0, i64 %v11
  %loaded = load i64, ptr %arrayidx, align 8
  %add = add i64 %loaded, 1
  %add2 = add i64 %add, %zext
  store i64 %add2, ptr %arrayidx, align 8
  br label %for.inc

for.inc:                                          ; preds = %for.body, %preheader
  %next12 = add nuw nsw i64 %v11, 1
  %next = add nsw i32 %iv, 1
  br i1 true, label %for.body.1, label %for.inc.1

end:                                              ; preds = %for.inc.1
  %arrayidx8 = getelementptr [16 x i64], ptr %bins, i64 0, i64 2
  %load = load i64, ptr %arrayidx8, align 16
  %shr4 = lshr i64 %load, 32
  %conv = trunc i64 %shr4 to i32
  ret i32 %conv

for.body.1:                                       ; preds = %for.inc
  %zext.1 = zext i32 %next to i64
  %arrayidx.1 = getelementptr [16 x i64], ptr %bins, i64 0, i64 %next12
  %loaded.1 = load i64, ptr %arrayidx.1, align 8
  %add.1 = add i64 %loaded.1, 1
  %add2.1 = add i64 %add.1, %zext.1
  store i64 %add2.1, ptr %arrayidx.1, align 8
  br label %for.inc.1

for.inc.1:                                        ; preds = %for.body.1, %for.inc
  %next12.1 = add nuw nsw i64 %next12, 1
  %next.1 = add nuw nsw i32 %next, 1
  %exitcond.1 = icmp eq i64 %next12.1, 16
  br i1 %exitcond.1, label %end, label %preheader
}

; Function Attrs: nounwind
declare void @llvm.memset.p0.i64(ptr nocapture, i8, i64, i1) #0

declare void @may_exit() nounwind

define void @pr28012(i32 %n) {
; CHECK-LABEL: 'pr28012'
; CHECK-NEXT:  Determining loop execution counts for: @pr28012
; CHECK-NEXT:  Loop %loop: backedge-taken count is i32 -1431655751
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 -1431655751
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is i32 -1431655751
; CHECK-NEXT:  Loop %loop: Trip multiple is 2863311546
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add nsw i32 %iv, 3
  call void @may_exit()
  %becond = icmp ne i32 %iv.inc, 46
  br i1 %becond, label %loop, label %leave

leave:
  ret void
}

define void @non_zero_from_loop_guard(i16 %n) {
; CHECK-LABEL: 'non_zero_from_loop_guard'
; CHECK-NEXT:  Determining loop execution counts for: @non_zero_from_loop_guard
; CHECK-NEXT:  Loop %loop: backedge-taken count is (-1 + (%n /u 2))<nsw>
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i16 32766
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (-1 + (%n /u 2))<nsw>
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
  %shr = lshr i16 %n, 1
  %precond = icmp ult i16 %n, 2
  br i1 %precond, label %exit, label %loop

loop:
  %iv = phi i16 [ %inc, %loop ], [ 0, %entry ]
  %inc = add nuw nsw i16 %iv, 1
  %cmp = icmp ult i16 %inc, %shr
  br i1 %cmp, label %loop, label %exit

exit:
  ret void
}

define void @dual_sext_ne_with_slt_guard(i8 %s, i8 %n) {
; CHECK-LABEL: 'dual_sext_ne_with_slt_guard'
; CHECK-NEXT:  Determining loop execution counts for: @dual_sext_ne_with_slt_guard
; CHECK-NEXT:  Loop %for.body: backedge-taken count is (-1 + (sext i8 %n to i64) + (-1 * (sext i8 %s to i64))<nsw>)
; CHECK-NEXT:  Loop %for.body: constant max backedge-taken count is i64 -2
; CHECK-NEXT:  Loop %for.body: symbolic max backedge-taken count is (-1 + (sext i8 %n to i64) + (-1 * (sext i8 %s to i64))<nsw>)
; CHECK-NEXT:  Loop %for.body: Trip multiple is 1
;
entry:
  %cmp4 = icmp slt i8 %s, %n
  br i1 %cmp4, label %for.body.preheader, label %exit

for.body.preheader:
  %0 = sext i8 %s to i64
  %wide.trip.count = sext i8 %n to i64
  br label %for.body

for.body:
  %iv = phi i64 [ %0, %for.body.preheader ], [ %iv.next, %for.body ]
  %iv.next = add nsw i64 %iv, 1
  %exitcond.not = icmp eq i64 %iv.next, %wide.trip.count
  br i1 %exitcond.not, label %exit, label %for.body

exit:
  ret void
}

define void @dual_sext_ne_with_nsw_inc(i8 %s, i64 %n) {
; CHECK-LABEL: 'dual_sext_ne_with_nsw_inc'
; CHECK-NEXT:  Determining loop execution counts for: @dual_sext_ne_with_nsw_inc
; CHECK-NEXT:  Loop %for.body: backedge-taken count is (-1 + (-1 * (sext i8 %s to i64))<nsw> + %n)
; CHECK-NEXT:  Loop %for.body: constant max backedge-taken count is i64 -1
; CHECK-NEXT:  Loop %for.body: symbolic max backedge-taken count is (-1 + (-1 * (sext i8 %s to i64))<nsw> + %n)
; CHECK-NEXT:  Loop %for.body: Trip multiple is 1
;
entry:
  %0 = sext i8 %s to i64
  br label %for.body

for.body:
  %iv = phi i64 [ %0, %entry ], [ %iv.next, %for.body ]
  %iv.next = add nsw i64 %iv, 1
  %exitcond.not = icmp eq i64 %iv.next, %n
  br i1 %exitcond.not, label %exit, label %for.body

exit:
  ret void
}

define void @dual_sext_ne_with_nuw_inc(i8 %s, i64 %n) {
; CHECK-LABEL: 'dual_sext_ne_with_nuw_inc'
; CHECK-NEXT:  Determining loop execution counts for: @dual_sext_ne_with_nuw_inc
; CHECK-NEXT:  Loop %for.body: backedge-taken count is (-1 + (-1 * (sext i8 %s to i64))<nsw> + %n)
; CHECK-NEXT:  Loop %for.body: constant max backedge-taken count is i64 -1
; CHECK-NEXT:  Loop %for.body: symbolic max backedge-taken count is (-1 + (-1 * (sext i8 %s to i64))<nsw> + %n)
; CHECK-NEXT:  Loop %for.body: Trip multiple is 1
;
entry:
  %0 = sext i8 %s to i64
  br label %for.body

for.body:
  %iv = phi i64 [ %0, %entry ], [ %iv.next, %for.body ]
  %iv.next = add nuw i64 %iv, 1
  %exitcond.not = icmp eq i64 %iv.next, %n
  br i1 %exitcond.not, label %exit, label %for.body

exit:
  ret void
}
