# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-u74 -timeline -iterations=1 < %s \
# RUN:   | FileCheck %s

jal x0, 1f
1:
jal a0, 1f
1:
jalr x0, a0
jalr t0, a0
ret

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      5
# CHECK-NEXT: Total Cycles:      200
# CHECK-NEXT: Total uOps:        5

# CHECK:      Dispatch Width:    2
# CHECK-NEXT: uOps Per Cycle:    0.03
# CHECK-NEXT: IPC:               0.03
# CHECK-NEXT: Block RThroughput: 5.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      3     1.00                        j	.Ltmp0
# CHECK-NEXT:  1      3     1.00                        jal	a0, .Ltmp1
# CHECK-NEXT:  1      3     1.00                        jr	a0
# CHECK-NEXT:  1      3     1.00                        jalr	t0, a0
# CHECK-NEXT:  1      3     1.00                        ret

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SiFive7FDiv
# CHECK-NEXT: [1]   - SiFive7IDiv
# CHECK-NEXT: [2]   - SiFive7PipeA
# CHECK-NEXT: [3]   - SiFive7PipeB
# CHECK-NEXT: [4]   - SiFive7VA
# CHECK-NEXT: [5]   - SiFive7VCQ
# CHECK-NEXT: [6]   - SiFive7VL
# CHECK-NEXT: [7]   - SiFive7VS

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]
# CHECK-NEXT:  -      -      -     5.00    -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    Instructions:
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     j	.Ltmp0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     jal	a0, .Ltmp1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     jr	a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     jalr	t0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     ret

# CHECK:      Timeline view:
# CHECK-NEXT: Index     0123

# CHECK:      [0,0]     DeeE   j	.Ltmp0
# CHECK-NEXT: Truncated display due to cycle limit

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     1     0.0    0.0    0.0       j	.Ltmp0
# CHECK-NEXT: 1.     1     0.0    0.0    0.0       jal	a0, .Ltmp1
# CHECK-NEXT: 2.     1     0.0    0.0    0.0       jr	a0
# CHECK-NEXT: 3.     1     0.0    0.0    0.0       jalr	t0, a0
# CHECK-NEXT: 4.     1     0.0    0.0    0.0       ret
# CHECK-NEXT:        1     0.0    0.0    0.0       <total>
