; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -S -loop-reduce -mtriple=x86_64-- -mcpu=core2 | FileCheck %s

declare i1 @check() nounwind
declare i1 @foo(ptr, ptr, ptr) nounwind

; Check that redundant phi elimination ran
define i32 @test(ptr %base) nounwind uwtable ssp {
; CHECK-LABEL: @test(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[WHILE_BODY_LR_PH_I:%.*]]
; CHECK:       while.body.lr.ph.i:
; CHECK-NEXT:    [[SCEVGEP:%.*]] = getelementptr i8, ptr [[BASE:%.*]], i64 16
; CHECK-NEXT:    br label [[WHILE_BODY_I:%.*]]
; CHECK:       while.body.i:
; CHECK-NEXT:    [[INDVARS_IV7_I:%.*]] = phi i64 [ 16, [[WHILE_BODY_LR_PH_I]] ], [ [[INDVARS_IV_NEXT8_I:%.*]], [[COND_TRUE29_I:%.*]] ]
; CHECK-NEXT:    [[I_05_I:%.*]] = phi i64 [ 0, [[WHILE_BODY_LR_PH_I]] ], [ [[INDVARS_IV7_I]], [[COND_TRUE29_I]] ]
; CHECK-NEXT:    [[LSR4:%.*]] = trunc i64 [[I_05_I]] to i32
; CHECK-NEXT:    [[TMP0:%.*]] = sext i32 [[LSR4]] to i64
; CHECK-NEXT:    [[SCEVGEP1:%.*]] = getelementptr i8, ptr [[SCEVGEP]], i64 [[TMP0]]
; CHECK-NEXT:    [[SEXT_I:%.*]] = shl i64 [[I_05_I]], 32
; CHECK-NEXT:    [[IDX_EXT_I:%.*]] = ashr exact i64 [[SEXT_I]], 32
; CHECK-NEXT:    [[ADD_PTR_SUM_I:%.*]] = add i64 [[IDX_EXT_I]], 16
; CHECK-NEXT:    br label [[FOR_BODY_I:%.*]]
; CHECK:       for.body.i:
; CHECK-NEXT:    [[LSR_IV2:%.*]] = phi ptr [ [[SCEVGEP3:%.*]], [[FOR_BODY_I]] ], [ [[SCEVGEP1]], [[WHILE_BODY_I]] ]
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[LSR_IV2]], align 1
; CHECK-NEXT:    [[CMP:%.*]] = call i1 @check() #[[ATTR3:[0-9]+]]
; CHECK-NEXT:    [[SCEVGEP3]] = getelementptr i8, ptr [[LSR_IV2]], i64 1
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_END_I:%.*]], label [[FOR_BODY_I]]
; CHECK:       for.end.i:
; CHECK-NEXT:    [[ADD_PTR_I144:%.*]] = getelementptr inbounds i8, ptr [[BASE]], i64 [[ADD_PTR_SUM_I]]
; CHECK-NEXT:    [[CMP2:%.*]] = tail call i1 @foo(ptr [[ADD_PTR_I144]], ptr [[ADD_PTR_I144]], ptr undef) #[[ATTR3]]
; CHECK-NEXT:    br i1 [[CMP2]], label [[COND_TRUE29_I]], label [[COND_FALSE35_I:%.*]]
; CHECK:       cond.true29.i:
; CHECK-NEXT:    [[INDVARS_IV_NEXT8_I]] = add i64 [[INDVARS_IV7_I]], 16
; CHECK-NEXT:    br i1 false, label [[EXIT:%.*]], label [[WHILE_BODY_I]]
; CHECK:       cond.false35.i:
; CHECK-NEXT:    unreachable
; CHECK:       exit:
; CHECK-NEXT:    ret i32 0
;
entry:
  br label %while.body.lr.ph.i

while.body.lr.ph.i:                               ; preds = %cond.true.i
  br label %while.body.i

while.body.i:                                     ; preds = %cond.true29.i, %while.body.lr.ph.i
  %indvars.iv7.i = phi i64 [ 16, %while.body.lr.ph.i ], [ %indvars.iv.next8.i, %cond.true29.i ]
  %i.05.i = phi i64 [ 0, %while.body.lr.ph.i ], [ %indvars.iv7.i, %cond.true29.i ]
  %sext.i = shl i64 %i.05.i, 32
  %idx.ext.i = ashr exact i64 %sext.i, 32
  %add.ptr.sum.i = add i64 %idx.ext.i, 16
  br label %for.body.i

for.body.i:                                       ; preds = %for.body.i, %while.body.i
  %indvars.iv.i = phi i64 [ 0, %while.body.i ], [ %indvars.iv.next.i, %for.body.i ]
  %add.ptr.sum = add i64 %add.ptr.sum.i, %indvars.iv.i
  %arrayidx22.i = getelementptr inbounds i8, ptr %base, i64 %add.ptr.sum
  %0 = load i8, ptr %arrayidx22.i, align 1
  %indvars.iv.next.i = add i64 %indvars.iv.i, 1
  %cmp = call i1 @check() nounwind
  br i1 %cmp, label %for.end.i, label %for.body.i

for.end.i:                                        ; preds = %for.body.i
  %add.ptr.i144 = getelementptr inbounds i8, ptr %base, i64 %add.ptr.sum.i
  %cmp2 = tail call i1 @foo(ptr %add.ptr.i144, ptr %add.ptr.i144, ptr undef) nounwind
  br i1 %cmp2, label %cond.true29.i, label %cond.false35.i

cond.true29.i:                                    ; preds = %for.end.i
  %indvars.iv.next8.i = add i64 %indvars.iv7.i, 16
  br i1 false, label %exit, label %while.body.i

cond.false35.i:                                   ; preds = %for.end.i
  unreachable

exit:                                 ; preds = %cond.true29.i, %cond.true.i
  ret i32 0
}

%struct.anon.7.91.199.307.415.475.559.643.751.835.943.1003.1111.1219.1351.1375.1399.1435.1471.1483.1519.1531.1651.1771 = type { i32, i32, i32 }

@tags = external global [5000 x %struct.anon.7.91.199.307.415.475.559.643.751.835.943.1003.1111.1219.1351.1375.1399.1435.1471.1483.1519.1531.1651.1771], align 16

; PR11782: SCEVExpander assert
;
; Test phi reuse after LSR that requires SCEVExpander to hoist an
; interesting GEP.
;
define void @test2(i32 %n, i1 %arg) nounwind uwtable {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[ARG:%.*]], label [[WHILE_END:%.*]], label [[FOR_COND468_PREHEADER:%.*]]
; CHECK:       for.cond468.preheader:
; CHECK-NEXT:    br label [[FOR_COND468:%.*]]
; CHECK:       for.cond468:
; CHECK-NEXT:    [[LSR_IV1:%.*]] = phi i32 [ 1, [[FOR_COND468_PREHEADER]] ], [ [[LSR_IV_NEXT:%.*]], [[IF_THEN477:%.*]] ]
; CHECK-NEXT:    [[LSR_IV:%.*]] = phi ptr [ getelementptr inbounds nuw (i8, ptr @tags, i64 8), [[FOR_COND468_PREHEADER]] ], [ [[SCEVGEP:%.*]], [[IF_THEN477]] ]
; CHECK-NEXT:    [[K_0:%.*]] = load i32, ptr [[LSR_IV]], align 4
; CHECK-NEXT:    [[CMP469:%.*]] = icmp slt i32 [[LSR_IV1]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[CMP469]], label [[FOR_BODY471:%.*]], label [[FOR_INC498_PREHEADER:%.*]]
; CHECK:       for.body471:
; CHECK-NEXT:    [[SCEVGEP2:%.*]] = getelementptr i8, ptr [[LSR_IV]], i64 8
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[SCEVGEP2]], align 4
; CHECK-NEXT:    br i1 [[ARG]], label [[IF_THEN477]], label [[FOR_INC498_PREHEADER]]
; CHECK:       for.inc498.preheader:
; CHECK-NEXT:    br label [[FOR_INC498:%.*]]
; CHECK:       if.then477:
; CHECK-NEXT:    [[SCEVGEP]] = getelementptr i8, ptr [[LSR_IV]], i64 12
; CHECK-NEXT:    [[LSR_IV_NEXT]] = add nuw i32 [[LSR_IV1]], 1
; CHECK-NEXT:    br label [[FOR_COND468]]
; CHECK:       for.inc498:
; CHECK-NEXT:    br label [[FOR_INC498]]
; CHECK:       while.end:
; CHECK-NEXT:    ret void
;
entry:
  br i1 %arg, label %while.end, label %for.cond468

for.cond468:                                      ; preds = %if.then477, %entry
  %indvars.iv1163 = phi i64 [ %indvars.iv.next1164, %if.then477 ], [ 1, %entry ]
  %k.0.in = phi ptr [ %last, %if.then477 ], [ getelementptr inbounds ([5000 x %struct.anon.7.91.199.307.415.475.559.643.751.835.943.1003.1111.1219.1351.1375.1399.1435.1471.1483.1519.1531.1651.1771], ptr @tags, i64 0, i64 0, i32 2), %entry ]
  %k.0 = load i32, ptr %k.0.in, align 4
  %0 = trunc i64 %indvars.iv1163 to i32
  %cmp469 = icmp slt i32 %0, %n
  br i1 %cmp469, label %for.body471, label %for.inc498

for.body471:                                      ; preds = %for.cond468
  %first = getelementptr inbounds [5000 x %struct.anon.7.91.199.307.415.475.559.643.751.835.943.1003.1111.1219.1351.1375.1399.1435.1471.1483.1519.1531.1651.1771], ptr @tags, i64 0, i64 %indvars.iv1163, i32 1
  %1 = load i32, ptr %first, align 4
  br i1 %arg, label %if.then477, label %for.inc498

if.then477:                                       ; preds = %for.body471
  %last = getelementptr inbounds [5000 x %struct.anon.7.91.199.307.415.475.559.643.751.835.943.1003.1111.1219.1351.1375.1399.1435.1471.1483.1519.1531.1651.1771], ptr @tags, i64 0, i64 %indvars.iv1163, i32 2
  %indvars.iv.next1164 = add i64 %indvars.iv1163, 1
  br label %for.cond468

for.inc498:                                       ; preds = %for.inc498, %for.body471, %for.cond468
  br label %for.inc498

while.end:                                        ; preds = %entry
  ret void
}

; PR12898: SCEVExpander crash
; Test redundant phi elimination when the deleted phi's increment is
; itself a phi.
;
define fastcc void @test3(ptr nocapture %u, i1 %arg) nounwind uwtable ssp {
; CHECK-LABEL: @test3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[ARG:%.*]], label [[MESHBB1_PREHEADER:%.*]], label [[MESHBB5:%.*]]
; CHECK:       meshBB1.preheader:
; CHECK-NEXT:    br label [[MESHBB1:%.*]]
; CHECK:       for.inc8.us.i:
; CHECK-NEXT:    br i1 [[ARG]], label [[MESHBB1_LOOPEXIT:%.*]], label [[MESHBB:%.*]]
; CHECK:       for.body3.us.i:
; CHECK-NEXT:    [[TMP:%.*]] = phi i32 [ [[LSR_IV_NEXT:%.*]], [[MESHBB]] ], [ [[TMP3:%.*]], [[FOR_BODY3_LR_PH_US_I:%.*]] ]
; CHECK-NEXT:    [[SCEVGEP:%.*]] = phi ptr [ [[SCEVGEP1:%.*]], [[MESHBB]] ], [ [[U:%.*]], [[FOR_BODY3_LR_PH_US_I]] ]
; CHECK-NEXT:    [[OPQ_SA_CALC12:%.*]] = sub i32 undef, 227
; CHECK-NEXT:    [[MUL_I_US_I:%.*]] = mul nsw i32 0, [[TMP]]
; CHECK-NEXT:    [[TMP2:%.*]] = load double, ptr [[SCEVGEP]], align 8
; CHECK-NEXT:    br i1 [[ARG]], label [[FOR_INC8_US_I:%.*]], label [[MESHBB]]
; CHECK:       for.body3.lr.ph.us.i.loopexit:
; CHECK-NEXT:    br label [[FOR_BODY3_LR_PH_US_I]]
; CHECK:       for.body3.lr.ph.us.i:
; CHECK-NEXT:    [[LSR_IV:%.*]] = phi i64 [ undef, [[MESHBB1]] ], [ [[INDVARS_IV8_I_SV_PHI24:%.*]], [[FOR_BODY3_LR_PH_US_I_LOOPEXIT:%.*]] ]
; CHECK-NEXT:    [[ARRAYIDX_US_I:%.*]] = getelementptr inbounds double, ptr undef, i64 [[LSR_IV]]
; CHECK-NEXT:    [[TMP1:%.*]] = add i64 [[LSR_IV]], 1
; CHECK-NEXT:    [[TMP3]] = trunc i64 [[LSR_IV]] to i32
; CHECK-NEXT:    br label [[FOR_BODY3_US_I:%.*]]
; CHECK:       for.inc8.us.i2:
; CHECK-NEXT:    unreachable
; CHECK:       eval_At_times_u.exit:
; CHECK-NEXT:    ret void
; CHECK:       meshBB:
; CHECK-NEXT:    [[INDVARS_IV8_I_SV_PHI24]] = phi i64 [ undef, [[FOR_BODY3_US_I]] ], [ [[TMP1]], [[FOR_INC8_US_I]] ]
; CHECK-NEXT:    [[MESHSTACKVARIABLE_PHI:%.*]] = phi i32 [ [[OPQ_SA_CALC12]], [[FOR_BODY3_US_I]] ], [ undef, [[FOR_INC8_US_I]] ]
; CHECK-NEXT:    [[SCEVGEP1]] = getelementptr i8, ptr [[SCEVGEP]], i64 8
; CHECK-NEXT:    [[LSR_IV_NEXT]] = add i32 [[TMP]], 1
; CHECK-NEXT:    br i1 [[ARG]], label [[FOR_BODY3_LR_PH_US_I_LOOPEXIT]], label [[FOR_BODY3_US_I]]
; CHECK:       meshBB1.loopexit:
; CHECK-NEXT:    br label [[MESHBB1]]
; CHECK:       meshBB1:
; CHECK-NEXT:    br label [[FOR_BODY3_LR_PH_US_I]]
; CHECK:       meshBB5:
; CHECK-NEXT:    br i1 [[ARG]], label [[EVAL_AT_TIMES_U_EXIT:%.*]], label [[FOR_INC8_US_I2:%.*]]
;
entry:
  br i1 %arg, label %meshBB1, label %meshBB5

for.inc8.us.i:                                    ; preds = %for.body3.us.i
  br i1 %arg, label %meshBB1, label %meshBB

for.body3.us.i:                                   ; preds = %meshBB, %for.body3.lr.ph.us.i
  %indvars.iv.i.SV.phi = phi i64 [ %indvars.iv.next.i, %meshBB ], [ 0, %for.body3.lr.ph.us.i ]
  %storemerge13.us.i.SV.phi = phi i32 [ 0, %meshBB ], [ 0, %for.body3.lr.ph.us.i ]
  %Opq.sa.calc12 = sub i32 undef, 227
  %0 = add nsw i64 %indvars.iv.i.SV.phi, %indvars.iv8.i.SV.phi26
  %1 = trunc i64 %0 to i32
  %mul.i.us.i = mul nsw i32 0, %1
  %arrayidx5.us.i = getelementptr inbounds double, ptr %u, i64 %indvars.iv.i.SV.phi
  %2 = load double, ptr %arrayidx5.us.i, align 8
  %indvars.iv.next.i = add i64 %indvars.iv.i.SV.phi, 1
  br i1 %arg, label %for.inc8.us.i, label %meshBB

for.body3.lr.ph.us.i:                             ; preds = %meshBB1, %meshBB
  %indvars.iv8.i.SV.phi26 = phi i64 [ undef, %meshBB1 ], [ %indvars.iv8.i.SV.phi24, %meshBB ]
  %arrayidx.us.i = getelementptr inbounds double, ptr undef, i64 %indvars.iv8.i.SV.phi26
  %3 = add i64 %indvars.iv8.i.SV.phi26, 1
  br label %for.body3.us.i

for.inc8.us.i2:                                   ; preds = %meshBB5
  unreachable

eval_At_times_u.exit:                             ; preds = %meshBB5
  ret void

meshBB:                                           ; preds = %for.body3.us.i, %for.inc8.us.i
  %indvars.iv8.i.SV.phi24 = phi i64 [ undef, %for.body3.us.i ], [ %3, %for.inc8.us.i ]
  %meshStackVariable.phi = phi i32 [ %Opq.sa.calc12, %for.body3.us.i ], [ undef, %for.inc8.us.i ]
  br i1 %arg, label %for.body3.lr.ph.us.i, label %for.body3.us.i

meshBB1:                                          ; preds = %for.inc8.us.i, %entry
  br label %for.body3.lr.ph.us.i

meshBB5:                                          ; preds = %entry
  br i1 %arg, label %eval_At_times_u.exit, label %for.inc8.us.i2
}
