; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals all --version 4
; RUN: opt -S -passes=attributor < %s | FileCheck %s

define void @null_ptr_is_valid_call_with_null() #0 {
; CHECK-LABEL: define void @null_ptr_is_valid_call_with_null(
; CHECK-SAME: ) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    call void @store_as0(ptr nofree noundef writeonly align 4294967296 null) #[[ATTR4:[0-9]+]]
; CHECK-NEXT:    ret void
;
  call void @store_as0(ptr null)
  ret void
}

define void @null_ptr_is_valid_call_with_undef() #0 {
; CHECK-LABEL: define void @null_ptr_is_valid_call_with_undef(
; CHECK-SAME: ) #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    call void @store_as0(ptr undef) #[[ATTR4]]
; CHECK-NEXT:    ret void
;
  call void @store_as0(ptr undef)
  ret void
}

define void @store_as0(ptr %0) {
; CHECK-LABEL: define void @store_as0(
; CHECK-SAME: ptr nocapture nofree noundef nonnull writeonly align 2 dereferenceable(2) [[TMP0:%.*]]) #[[ATTR2:[0-9]+]] {
; CHECK-NEXT:    store i16 0, ptr [[TMP0]], align 2
; CHECK-NEXT:    ret void
;
  store i16 0, ptr %0, align 2
  ret void
}

define void @call_store_as1() {
; CHECK-LABEL: define void @call_store_as1(
; CHECK-SAME: ) #[[ATTR3:[0-9]+]] {
; CHECK-NEXT:    call void @store_as1(ptr addrspace(1) nocapture nofree noundef writeonly align 4294967296 null) #[[ATTR4]]
; CHECK-NEXT:    ret void
;
  call void @store_as1(ptr addrspace(1) null)
  ret void
}

define void @store_as1(ptr addrspace(1) %arg) {
; CHECK-LABEL: define void @store_as1(
; CHECK-SAME: ptr addrspace(1) nocapture nofree noundef writeonly align 2 dereferenceable_or_null(2) [[ARG:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    store i16 0, ptr addrspace(1) [[ARG]], align 2
; CHECK-NEXT:    ret void
;
  store i16 0, ptr addrspace(1) %arg, align 2
  ret void
}

attributes #0 = { null_pointer_is_valid }
;.
; CHECK: attributes #[[ATTR0]] = { mustprogress nofree norecurse nosync nounwind null_pointer_is_valid willreturn memory(write) }
; CHECK: attributes #[[ATTR1]] = { mustprogress nofree norecurse nosync nounwind null_pointer_is_valid willreturn memory(none) }
; CHECK: attributes #[[ATTR2]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: write) }
; CHECK: attributes #[[ATTR3]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; CHECK: attributes #[[ATTR4]] = { nofree nosync nounwind willreturn memory(write) }
;.
