; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=GCN
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=tahiti -verify-machineinstrs < %s | FileCheck %s --check-prefixes=TAHITI
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=tonga -verify-machineinstrs < %s | FileCheck %s --check-prefixes=TONGA
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=r600 -mcpu=redwood -verify-machineinstrs < %s | FileCheck %s --check-prefixes=EG

define amdgpu_kernel void @srem_i16_7(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; GCN-LABEL: srem_i16_7:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    global_load_ushort v1, v0, s[2:3]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_readfirstlane_b32 s2, v1
; GCN-NEXT:    s_sext_i32_i16 s2, s2
; GCN-NEXT:    s_mulk_i32 s2, 0x4925
; GCN-NEXT:    s_lshr_b32 s3, s2, 31
; GCN-NEXT:    s_ashr_i32 s2, s2, 17
; GCN-NEXT:    s_add_i32 s2, s2, s3
; GCN-NEXT:    s_mul_i32 s2, s2, 7
; GCN-NEXT:    v_subrev_u32_e32 v1, s2, v1
; GCN-NEXT:    global_store_short v0, v1, s[0:1]
; GCN-NEXT:    s_endpgm
;
; TAHITI-LABEL: srem_i16_7:
; TAHITI:       ; %bb.0:
; TAHITI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; TAHITI-NEXT:    s_mov_b32 s7, 0xf000
; TAHITI-NEXT:    s_mov_b32 s6, -1
; TAHITI-NEXT:    s_mov_b32 s10, s6
; TAHITI-NEXT:    s_mov_b32 s11, s7
; TAHITI-NEXT:    s_waitcnt lgkmcnt(0)
; TAHITI-NEXT:    s_mov_b32 s8, s2
; TAHITI-NEXT:    s_mov_b32 s9, s3
; TAHITI-NEXT:    buffer_load_sshort v0, off, s[8:11], 0
; TAHITI-NEXT:    s_mov_b32 s4, s0
; TAHITI-NEXT:    s_mov_b32 s5, s1
; TAHITI-NEXT:    s_waitcnt vmcnt(0)
; TAHITI-NEXT:    v_readfirstlane_b32 s0, v0
; TAHITI-NEXT:    s_mulk_i32 s0, 0x4925
; TAHITI-NEXT:    s_lshr_b32 s1, s0, 31
; TAHITI-NEXT:    s_ashr_i32 s0, s0, 17
; TAHITI-NEXT:    s_add_i32 s0, s0, s1
; TAHITI-NEXT:    s_mul_i32 s0, s0, 7
; TAHITI-NEXT:    v_subrev_i32_e32 v0, vcc, s0, v0
; TAHITI-NEXT:    buffer_store_short v0, off, s[4:7], 0
; TAHITI-NEXT:    s_endpgm
;
; TONGA-LABEL: srem_i16_7:
; TONGA:       ; %bb.0:
; TONGA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; TONGA-NEXT:    s_waitcnt lgkmcnt(0)
; TONGA-NEXT:    v_mov_b32_e32 v0, s2
; TONGA-NEXT:    v_mov_b32_e32 v1, s3
; TONGA-NEXT:    flat_load_ushort v2, v[0:1]
; TONGA-NEXT:    v_mov_b32_e32 v0, s0
; TONGA-NEXT:    v_mov_b32_e32 v1, s1
; TONGA-NEXT:    s_waitcnt vmcnt(0)
; TONGA-NEXT:    v_readfirstlane_b32 s0, v2
; TONGA-NEXT:    s_sext_i32_i16 s0, s0
; TONGA-NEXT:    s_mulk_i32 s0, 0x4925
; TONGA-NEXT:    s_lshr_b32 s1, s0, 31
; TONGA-NEXT:    s_ashr_i32 s0, s0, 17
; TONGA-NEXT:    s_add_i32 s0, s0, s1
; TONGA-NEXT:    s_mul_i32 s0, s0, 7
; TONGA-NEXT:    v_subrev_u32_e32 v2, vcc, s0, v2
; TONGA-NEXT:    flat_store_short v[0:1], v2
; TONGA-NEXT:    s_endpgm
;
; EG-LABEL: srem_i16_7:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 22, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_16 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     BFE_INT * T0.W, T0.X, 0.0, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     MULLO_INT * T0.Y, PV.W, literal.x,
; EG-NEXT:    18725(2.623931e-41), 0(0.000000e+00)
; EG-NEXT:     ASHR T0.W, PS, literal.x,
; EG-NEXT:     LSHR * T1.W, PS, literal.y,
; EG-NEXT:    17(2.382207e-44), 31(4.344025e-44)
; EG-NEXT:     ADD_INT * T0.W, PV.W, PS,
; EG-NEXT:     MULLO_INT * T0.Y, PV.W, literal.x,
; EG-NEXT:    7(9.809089e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T0.W, KC0[2].Y, literal.x,
; EG-NEXT:     SUB_INT * T1.W, T0.X, PS,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T1.W, PS, literal.x,
; EG-NEXT:     LSHL * T0.W, PV.W, literal.y,
; EG-NEXT:    65535(9.183409e-41), 3(4.203895e-45)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %num = load i16, ptr addrspace(1) %in
  %result = srem i16 %num, 7
  store i16 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @srem_i32(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; GCN-LABEL: srem_i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    global_load_dwordx2 v[0:1], v2, s[2:3]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_readfirstlane_b32 s2, v1
; GCN-NEXT:    s_abs_i32 s2, s2
; GCN-NEXT:    v_cvt_f32_u32_e32 v1, s2
; GCN-NEXT:    v_readfirstlane_b32 s3, v0
; GCN-NEXT:    s_sub_i32 s5, 0, s2
; GCN-NEXT:    s_ashr_i32 s4, s3, 31
; GCN-NEXT:    v_rcp_iflag_f32_e32 v1, v1
; GCN-NEXT:    s_abs_i32 s3, s3
; GCN-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v1
; GCN-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GCN-NEXT:    v_readfirstlane_b32 s6, v0
; GCN-NEXT:    s_mul_i32 s5, s5, s6
; GCN-NEXT:    s_mul_hi_u32 s5, s6, s5
; GCN-NEXT:    s_add_i32 s6, s6, s5
; GCN-NEXT:    s_mul_hi_u32 s5, s3, s6
; GCN-NEXT:    s_mul_i32 s5, s5, s2
; GCN-NEXT:    s_sub_i32 s3, s3, s5
; GCN-NEXT:    s_sub_i32 s5, s3, s2
; GCN-NEXT:    s_cmp_ge_u32 s3, s2
; GCN-NEXT:    s_cselect_b32 s3, s5, s3
; GCN-NEXT:    s_sub_i32 s5, s3, s2
; GCN-NEXT:    s_cmp_ge_u32 s3, s2
; GCN-NEXT:    s_cselect_b32 s2, s5, s3
; GCN-NEXT:    s_xor_b32 s2, s2, s4
; GCN-NEXT:    s_sub_i32 s2, s2, s4
; GCN-NEXT:    v_mov_b32_e32 v0, s2
; GCN-NEXT:    global_store_dword v2, v0, s[0:1]
; GCN-NEXT:    s_endpgm
;
; TAHITI-LABEL: srem_i32:
; TAHITI:       ; %bb.0:
; TAHITI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; TAHITI-NEXT:    s_mov_b32 s7, 0xf000
; TAHITI-NEXT:    s_mov_b32 s6, -1
; TAHITI-NEXT:    s_mov_b32 s10, s6
; TAHITI-NEXT:    s_mov_b32 s11, s7
; TAHITI-NEXT:    s_waitcnt lgkmcnt(0)
; TAHITI-NEXT:    s_mov_b32 s8, s2
; TAHITI-NEXT:    s_mov_b32 s9, s3
; TAHITI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; TAHITI-NEXT:    s_mov_b32 s5, s1
; TAHITI-NEXT:    s_mov_b32 s4, s0
; TAHITI-NEXT:    s_waitcnt vmcnt(0)
; TAHITI-NEXT:    v_readfirstlane_b32 s2, v1
; TAHITI-NEXT:    s_abs_i32 s2, s2
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v1, s2
; TAHITI-NEXT:    s_sub_i32 s3, 0, s2
; TAHITI-NEXT:    v_rcp_iflag_f32_e32 v1, v1
; TAHITI-NEXT:    v_mul_f32_e32 v1, 0x4f7ffffe, v1
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v1, v1
; TAHITI-NEXT:    v_mul_lo_u32 v2, s3, v1
; TAHITI-NEXT:    v_readfirstlane_b32 s3, v0
; TAHITI-NEXT:    s_abs_i32 s8, s3
; TAHITI-NEXT:    s_ashr_i32 s0, s3, 31
; TAHITI-NEXT:    v_mul_hi_u32 v2, v1, v2
; TAHITI-NEXT:    v_add_i32_e32 v0, vcc, v1, v2
; TAHITI-NEXT:    v_mul_hi_u32 v0, s8, v0
; TAHITI-NEXT:    v_readfirstlane_b32 s1, v0
; TAHITI-NEXT:    s_mul_i32 s1, s1, s2
; TAHITI-NEXT:    s_sub_i32 s1, s8, s1
; TAHITI-NEXT:    s_sub_i32 s3, s1, s2
; TAHITI-NEXT:    s_cmp_ge_u32 s1, s2
; TAHITI-NEXT:    s_cselect_b32 s1, s3, s1
; TAHITI-NEXT:    s_sub_i32 s3, s1, s2
; TAHITI-NEXT:    s_cmp_ge_u32 s1, s2
; TAHITI-NEXT:    s_cselect_b32 s1, s3, s1
; TAHITI-NEXT:    s_xor_b32 s1, s1, s0
; TAHITI-NEXT:    s_sub_i32 s0, s1, s0
; TAHITI-NEXT:    v_mov_b32_e32 v0, s0
; TAHITI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; TAHITI-NEXT:    s_endpgm
;
; TONGA-LABEL: srem_i32:
; TONGA:       ; %bb.0:
; TONGA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; TONGA-NEXT:    s_waitcnt lgkmcnt(0)
; TONGA-NEXT:    v_mov_b32_e32 v0, s2
; TONGA-NEXT:    v_mov_b32_e32 v1, s3
; TONGA-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; TONGA-NEXT:    s_waitcnt vmcnt(0)
; TONGA-NEXT:    v_readfirstlane_b32 s2, v1
; TONGA-NEXT:    s_abs_i32 s2, s2
; TONGA-NEXT:    v_cvt_f32_u32_e32 v1, s2
; TONGA-NEXT:    s_sub_i32 s3, 0, s2
; TONGA-NEXT:    v_rcp_iflag_f32_e32 v1, v1
; TONGA-NEXT:    v_mul_f32_e32 v1, 0x4f7ffffe, v1
; TONGA-NEXT:    v_cvt_u32_f32_e32 v1, v1
; TONGA-NEXT:    v_mul_lo_u32 v2, s3, v1
; TONGA-NEXT:    v_readfirstlane_b32 s3, v0
; TONGA-NEXT:    s_abs_i32 s4, s3
; TONGA-NEXT:    v_mul_hi_u32 v2, v1, v2
; TONGA-NEXT:    v_add_u32_e32 v0, vcc, v1, v2
; TONGA-NEXT:    v_mul_hi_u32 v2, s4, v0
; TONGA-NEXT:    v_mov_b32_e32 v1, s1
; TONGA-NEXT:    v_mov_b32_e32 v0, s0
; TONGA-NEXT:    s_ashr_i32 s0, s3, 31
; TONGA-NEXT:    v_readfirstlane_b32 s1, v2
; TONGA-NEXT:    s_mul_i32 s1, s1, s2
; TONGA-NEXT:    s_sub_i32 s1, s4, s1
; TONGA-NEXT:    s_sub_i32 s3, s1, s2
; TONGA-NEXT:    s_cmp_ge_u32 s1, s2
; TONGA-NEXT:    s_cselect_b32 s1, s3, s1
; TONGA-NEXT:    s_sub_i32 s3, s1, s2
; TONGA-NEXT:    s_cmp_ge_u32 s1, s2
; TONGA-NEXT:    s_cselect_b32 s1, s3, s1
; TONGA-NEXT:    s_xor_b32 s1, s1, s0
; TONGA-NEXT:    s_sub_i32 s0, s1, s0
; TONGA-NEXT:    v_mov_b32_e32 v2, s0
; TONGA-NEXT:    flat_store_dword v[0:1], v2
; TONGA-NEXT:    s_endpgm
;
; EG-LABEL: srem_i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 23, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_64 T0.XY, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     SETGT_INT * T0.W, 0.0, T0.Y,
; EG-NEXT:     ADD_INT * T1.W, T0.Y, PV.W,
; EG-NEXT:     XOR_INT * T0.W, PV.W, T0.W,
; EG-NEXT:     SUB_INT T1.W, 0.0, PV.W,
; EG-NEXT:     RECIP_UINT * T0.Y, PV.W,
; EG-NEXT:     SETGT_INT T2.W, 0.0, T0.X,
; EG-NEXT:     MULLO_INT * T0.Z, PV.W, PS,
; EG-NEXT:     ADD_INT T1.W, T0.X, PV.W,
; EG-NEXT:     MULHI * T0.X, T0.Y, PS,
; EG-NEXT:     ADD_INT T3.W, T0.Y, PS,
; EG-NEXT:     XOR_INT * T1.W, PV.W, T2.W,
; EG-NEXT:     MULHI * T0.X, PS, PV.W,
; EG-NEXT:     MULLO_INT * T0.X, PS, T0.W,
; EG-NEXT:     SUB_INT * T1.W, T1.W, PS,
; EG-NEXT:     SETGE_UINT T3.W, PV.W, T0.W,
; EG-NEXT:     SUB_INT * T4.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT * T1.W, PV.W, T1.W, PS,
; EG-NEXT:     SETGE_UINT T3.W, PV.W, T0.W,
; EG-NEXT:     SUB_INT * T0.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT * T0.W, PV.W, T1.W, PS,
; EG-NEXT:     XOR_INT * T0.W, PV.W, T2.W,
; EG-NEXT:     SUB_INT T0.X, PV.W, T2.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %den_ptr = getelementptr i32, ptr addrspace(1) %in, i32 1
  %num = load i32, ptr addrspace(1) %in
  %den = load i32, ptr addrspace(1) %den_ptr
  %result = srem i32 %num, %den
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @srem_i32_4(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; GCN-LABEL: srem_i32_4:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    global_load_dword v1, v0, s[2:3]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_ashrrev_i32_e32 v2, 31, v1
; GCN-NEXT:    v_lshrrev_b32_e32 v2, 30, v2
; GCN-NEXT:    v_add_u32_e32 v2, v1, v2
; GCN-NEXT:    v_and_b32_e32 v2, -4, v2
; GCN-NEXT:    v_sub_u32_e32 v1, v1, v2
; GCN-NEXT:    global_store_dword v0, v1, s[0:1]
; GCN-NEXT:    s_endpgm
;
; TAHITI-LABEL: srem_i32_4:
; TAHITI:       ; %bb.0:
; TAHITI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; TAHITI-NEXT:    s_mov_b32 s7, 0xf000
; TAHITI-NEXT:    s_mov_b32 s6, -1
; TAHITI-NEXT:    s_mov_b32 s10, s6
; TAHITI-NEXT:    s_mov_b32 s11, s7
; TAHITI-NEXT:    s_waitcnt lgkmcnt(0)
; TAHITI-NEXT:    s_mov_b32 s8, s2
; TAHITI-NEXT:    s_mov_b32 s9, s3
; TAHITI-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; TAHITI-NEXT:    s_mov_b32 s4, s0
; TAHITI-NEXT:    s_mov_b32 s5, s1
; TAHITI-NEXT:    s_waitcnt vmcnt(0)
; TAHITI-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; TAHITI-NEXT:    v_lshrrev_b32_e32 v1, 30, v1
; TAHITI-NEXT:    v_add_i32_e32 v1, vcc, v1, v0
; TAHITI-NEXT:    v_and_b32_e32 v1, -4, v1
; TAHITI-NEXT:    v_subrev_i32_e32 v0, vcc, v1, v0
; TAHITI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; TAHITI-NEXT:    s_endpgm
;
; TONGA-LABEL: srem_i32_4:
; TONGA:       ; %bb.0:
; TONGA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; TONGA-NEXT:    s_waitcnt lgkmcnt(0)
; TONGA-NEXT:    v_mov_b32_e32 v0, s2
; TONGA-NEXT:    v_mov_b32_e32 v1, s3
; TONGA-NEXT:    flat_load_dword v2, v[0:1]
; TONGA-NEXT:    v_mov_b32_e32 v0, s0
; TONGA-NEXT:    v_mov_b32_e32 v1, s1
; TONGA-NEXT:    s_waitcnt vmcnt(0)
; TONGA-NEXT:    v_ashrrev_i32_e32 v3, 31, v2
; TONGA-NEXT:    v_lshrrev_b32_e32 v3, 30, v3
; TONGA-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; TONGA-NEXT:    v_and_b32_e32 v3, -4, v3
; TONGA-NEXT:    v_subrev_u32_e32 v2, vcc, v3, v2
; TONGA-NEXT:    flat_store_dword v[0:1], v2
; TONGA-NEXT:    s_endpgm
;
; EG-LABEL: srem_i32_4:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 9, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     ASHR * T0.W, T0.X, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR * T0.W, PV.W, literal.x,
; EG-NEXT:    30(4.203895e-44), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.W, T0.X, PV.W,
; EG-NEXT:     AND_INT * T0.W, PV.W, literal.x,
; EG-NEXT:    -4(nan), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T0.X, T0.X, PV.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %num = load i32, ptr addrspace(1) %in
  %result = srem i32 %num, 4
  store i32 %result, ptr addrspace(1) %out
  ret void
}

; FIXME: uniform i16 srem should not use VALU instructions
define amdgpu_kernel void @srem_i32_7(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; GCN-LABEL: srem_i32_7:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    global_load_dword v1, v0, s[2:3]
; GCN-NEXT:    s_mov_b32 s2, 0x92492493
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_mul_hi_i32 v2, v1, s2
; GCN-NEXT:    v_add_u32_e32 v2, v2, v1
; GCN-NEXT:    v_lshrrev_b32_e32 v3, 31, v2
; GCN-NEXT:    v_ashrrev_i32_e32 v2, 2, v2
; GCN-NEXT:    v_add_u32_e32 v2, v2, v3
; GCN-NEXT:    v_mul_lo_u32 v2, v2, 7
; GCN-NEXT:    v_sub_u32_e32 v1, v1, v2
; GCN-NEXT:    global_store_dword v0, v1, s[0:1]
; GCN-NEXT:    s_endpgm
;
; TAHITI-LABEL: srem_i32_7:
; TAHITI:       ; %bb.0:
; TAHITI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; TAHITI-NEXT:    s_mov_b32 s7, 0xf000
; TAHITI-NEXT:    s_mov_b32 s6, -1
; TAHITI-NEXT:    s_mov_b32 s10, s6
; TAHITI-NEXT:    s_mov_b32 s11, s7
; TAHITI-NEXT:    s_waitcnt lgkmcnt(0)
; TAHITI-NEXT:    s_mov_b32 s8, s2
; TAHITI-NEXT:    s_mov_b32 s9, s3
; TAHITI-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; TAHITI-NEXT:    s_mov_b32 s2, 0x92492493
; TAHITI-NEXT:    s_mov_b32 s4, s0
; TAHITI-NEXT:    s_mov_b32 s5, s1
; TAHITI-NEXT:    s_waitcnt vmcnt(0)
; TAHITI-NEXT:    v_mul_hi_i32 v1, v0, s2
; TAHITI-NEXT:    v_add_i32_e32 v1, vcc, v1, v0
; TAHITI-NEXT:    v_lshrrev_b32_e32 v2, 31, v1
; TAHITI-NEXT:    v_ashrrev_i32_e32 v1, 2, v1
; TAHITI-NEXT:    v_add_i32_e32 v1, vcc, v1, v2
; TAHITI-NEXT:    v_mul_lo_u32 v1, v1, 7
; TAHITI-NEXT:    v_subrev_i32_e32 v0, vcc, v1, v0
; TAHITI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; TAHITI-NEXT:    s_endpgm
;
; TONGA-LABEL: srem_i32_7:
; TONGA:       ; %bb.0:
; TONGA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; TONGA-NEXT:    s_waitcnt lgkmcnt(0)
; TONGA-NEXT:    v_mov_b32_e32 v0, s2
; TONGA-NEXT:    v_mov_b32_e32 v1, s3
; TONGA-NEXT:    flat_load_dword v2, v[0:1]
; TONGA-NEXT:    s_mov_b32 s2, 0x92492493
; TONGA-NEXT:    s_waitcnt vmcnt(0)
; TONGA-NEXT:    v_mul_hi_i32 v0, v2, s2
; TONGA-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; TONGA-NEXT:    v_lshrrev_b32_e32 v1, 31, v0
; TONGA-NEXT:    v_ashrrev_i32_e32 v0, 2, v0
; TONGA-NEXT:    v_add_u32_e32 v0, vcc, v0, v1
; TONGA-NEXT:    v_mul_lo_u32 v3, v0, 7
; TONGA-NEXT:    v_mov_b32_e32 v0, s0
; TONGA-NEXT:    v_mov_b32_e32 v1, s1
; TONGA-NEXT:    v_subrev_u32_e32 v2, vcc, v3, v2
; TONGA-NEXT:    flat_store_dword v[0:1], v2
; TONGA-NEXT:    s_endpgm
;
; EG-LABEL: srem_i32_7:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 11, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     MULHI_INT * T0.Y, T0.X, literal.x,
; EG-NEXT:    -1840700269(-6.346950e-28), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.W, PS, T0.X,
; EG-NEXT:     ASHR T1.W, PV.W, literal.x,
; EG-NEXT:     LSHR * T0.W, PV.W, literal.y,
; EG-NEXT:    2(2.802597e-45), 31(4.344025e-44)
; EG-NEXT:     ADD_INT * T0.W, PV.W, PS,
; EG-NEXT:     MULLO_INT * T0.Y, PV.W, literal.x,
; EG-NEXT:    7(9.809089e-45), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T0.X, T0.X, PS,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %num = load i32, ptr addrspace(1) %in
  %result = srem i32 %num, 7
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @srem_v2i32(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; GCN-LABEL: srem_v2i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v4, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    global_load_dwordx4 v[0:3], v4, s[2:3]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_readfirstlane_b32 s2, v2
; GCN-NEXT:    s_abs_i32 s2, s2
; GCN-NEXT:    v_cvt_f32_u32_e32 v2, s2
; GCN-NEXT:    v_readfirstlane_b32 s3, v0
; GCN-NEXT:    s_sub_i32 s6, 0, s2
; GCN-NEXT:    s_ashr_i32 s5, s3, 31
; GCN-NEXT:    v_rcp_iflag_f32_e32 v2, v2
; GCN-NEXT:    s_abs_i32 s3, s3
; GCN-NEXT:    v_readfirstlane_b32 s4, v3
; GCN-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v2
; GCN-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GCN-NEXT:    v_readfirstlane_b32 s7, v0
; GCN-NEXT:    s_mul_i32 s6, s6, s7
; GCN-NEXT:    s_mul_hi_u32 s6, s7, s6
; GCN-NEXT:    s_add_i32 s7, s7, s6
; GCN-NEXT:    s_mul_hi_u32 s6, s3, s7
; GCN-NEXT:    s_mul_i32 s6, s6, s2
; GCN-NEXT:    s_sub_i32 s3, s3, s6
; GCN-NEXT:    s_sub_i32 s6, s3, s2
; GCN-NEXT:    s_cmp_ge_u32 s3, s2
; GCN-NEXT:    s_cselect_b32 s3, s6, s3
; GCN-NEXT:    s_sub_i32 s6, s3, s2
; GCN-NEXT:    s_cmp_ge_u32 s3, s2
; GCN-NEXT:    s_cselect_b32 s2, s6, s3
; GCN-NEXT:    s_abs_i32 s3, s4
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, s3
; GCN-NEXT:    s_xor_b32 s2, s2, s5
; GCN-NEXT:    s_sub_i32 s7, 0, s3
; GCN-NEXT:    s_sub_i32 s2, s2, s5
; GCN-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; GCN-NEXT:    v_readfirstlane_b32 s4, v1
; GCN-NEXT:    s_ashr_i32 s6, s4, 31
; GCN-NEXT:    s_abs_i32 s4, s4
; GCN-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; GCN-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GCN-NEXT:    v_readfirstlane_b32 s5, v0
; GCN-NEXT:    s_mul_i32 s7, s7, s5
; GCN-NEXT:    s_mul_hi_u32 s7, s5, s7
; GCN-NEXT:    s_add_i32 s5, s5, s7
; GCN-NEXT:    s_mul_hi_u32 s5, s4, s5
; GCN-NEXT:    s_mul_i32 s5, s5, s3
; GCN-NEXT:    s_sub_i32 s4, s4, s5
; GCN-NEXT:    s_sub_i32 s5, s4, s3
; GCN-NEXT:    s_cmp_ge_u32 s4, s3
; GCN-NEXT:    s_cselect_b32 s4, s5, s4
; GCN-NEXT:    s_sub_i32 s5, s4, s3
; GCN-NEXT:    s_cmp_ge_u32 s4, s3
; GCN-NEXT:    s_cselect_b32 s3, s5, s4
; GCN-NEXT:    s_xor_b32 s3, s3, s6
; GCN-NEXT:    s_sub_i32 s3, s3, s6
; GCN-NEXT:    v_mov_b32_e32 v0, s2
; GCN-NEXT:    v_mov_b32_e32 v1, s3
; GCN-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GCN-NEXT:    s_endpgm
;
; TAHITI-LABEL: srem_v2i32:
; TAHITI:       ; %bb.0:
; TAHITI-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x9
; TAHITI-NEXT:    s_mov_b32 s3, 0xf000
; TAHITI-NEXT:    s_mov_b32 s2, -1
; TAHITI-NEXT:    s_mov_b32 s10, s2
; TAHITI-NEXT:    s_mov_b32 s11, s3
; TAHITI-NEXT:    s_waitcnt lgkmcnt(0)
; TAHITI-NEXT:    s_mov_b32 s8, s6
; TAHITI-NEXT:    s_mov_b32 s9, s7
; TAHITI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; TAHITI-NEXT:    s_waitcnt vmcnt(0)
; TAHITI-NEXT:    v_readfirstlane_b32 s0, v2
; TAHITI-NEXT:    s_abs_i32 s0, s0
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v2, s0
; TAHITI-NEXT:    s_sub_i32 s1, 0, s0
; TAHITI-NEXT:    v_readfirstlane_b32 s7, v3
; TAHITI-NEXT:    v_rcp_iflag_f32_e32 v2, v2
; TAHITI-NEXT:    v_mul_f32_e32 v2, 0x4f7ffffe, v2
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v2, v2
; TAHITI-NEXT:    v_mul_lo_u32 v4, s1, v2
; TAHITI-NEXT:    v_readfirstlane_b32 s1, v0
; TAHITI-NEXT:    s_abs_i32 s6, s1
; TAHITI-NEXT:    s_ashr_i32 s8, s1, 31
; TAHITI-NEXT:    v_mul_hi_u32 v4, v2, v4
; TAHITI-NEXT:    v_add_i32_e32 v0, vcc, v2, v4
; TAHITI-NEXT:    v_mul_hi_u32 v0, s6, v0
; TAHITI-NEXT:    v_readfirstlane_b32 s1, v0
; TAHITI-NEXT:    s_mul_i32 s1, s1, s0
; TAHITI-NEXT:    s_sub_i32 s1, s6, s1
; TAHITI-NEXT:    s_sub_i32 s6, s1, s0
; TAHITI-NEXT:    s_cmp_ge_u32 s1, s0
; TAHITI-NEXT:    s_cselect_b32 s1, s6, s1
; TAHITI-NEXT:    s_sub_i32 s6, s1, s0
; TAHITI-NEXT:    s_cmp_ge_u32 s1, s0
; TAHITI-NEXT:    s_cselect_b32 s6, s6, s1
; TAHITI-NEXT:    s_abs_i32 s7, s7
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v0, s7
; TAHITI-NEXT:    s_sub_i32 s0, 0, s7
; TAHITI-NEXT:    s_mov_b32 s1, s5
; TAHITI-NEXT:    s_xor_b32 s6, s6, s8
; TAHITI-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; TAHITI-NEXT:    s_sub_i32 s6, s6, s8
; TAHITI-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v0, v0
; TAHITI-NEXT:    v_mul_lo_u32 v2, s0, v0
; TAHITI-NEXT:    s_mov_b32 s0, s4
; TAHITI-NEXT:    v_readfirstlane_b32 s4, v1
; TAHITI-NEXT:    s_abs_i32 s5, s4
; TAHITI-NEXT:    v_mul_hi_u32 v2, v0, v2
; TAHITI-NEXT:    s_ashr_i32 s4, s4, 31
; TAHITI-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; TAHITI-NEXT:    v_mul_hi_u32 v0, s5, v0
; TAHITI-NEXT:    v_readfirstlane_b32 s8, v0
; TAHITI-NEXT:    s_mul_i32 s8, s8, s7
; TAHITI-NEXT:    s_sub_i32 s5, s5, s8
; TAHITI-NEXT:    s_sub_i32 s8, s5, s7
; TAHITI-NEXT:    s_cmp_ge_u32 s5, s7
; TAHITI-NEXT:    s_cselect_b32 s5, s8, s5
; TAHITI-NEXT:    s_sub_i32 s8, s5, s7
; TAHITI-NEXT:    s_cmp_ge_u32 s5, s7
; TAHITI-NEXT:    s_cselect_b32 s5, s8, s5
; TAHITI-NEXT:    s_xor_b32 s5, s5, s4
; TAHITI-NEXT:    s_sub_i32 s4, s5, s4
; TAHITI-NEXT:    v_mov_b32_e32 v0, s6
; TAHITI-NEXT:    v_mov_b32_e32 v1, s4
; TAHITI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; TAHITI-NEXT:    s_endpgm
;
; TONGA-LABEL: srem_v2i32:
; TONGA:       ; %bb.0:
; TONGA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; TONGA-NEXT:    s_waitcnt lgkmcnt(0)
; TONGA-NEXT:    v_mov_b32_e32 v0, s2
; TONGA-NEXT:    v_mov_b32_e32 v1, s3
; TONGA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; TONGA-NEXT:    s_waitcnt vmcnt(0)
; TONGA-NEXT:    v_readfirstlane_b32 s2, v2
; TONGA-NEXT:    s_abs_i32 s2, s2
; TONGA-NEXT:    v_cvt_f32_u32_e32 v2, s2
; TONGA-NEXT:    s_sub_i32 s3, 0, s2
; TONGA-NEXT:    v_readfirstlane_b32 s5, v3
; TONGA-NEXT:    v_mov_b32_e32 v3, s1
; TONGA-NEXT:    v_rcp_iflag_f32_e32 v2, v2
; TONGA-NEXT:    v_mul_f32_e32 v2, 0x4f7ffffe, v2
; TONGA-NEXT:    v_cvt_u32_f32_e32 v2, v2
; TONGA-NEXT:    v_mul_lo_u32 v4, s3, v2
; TONGA-NEXT:    v_readfirstlane_b32 s3, v0
; TONGA-NEXT:    s_abs_i32 s4, s3
; TONGA-NEXT:    s_ashr_i32 s3, s3, 31
; TONGA-NEXT:    v_mul_hi_u32 v4, v2, v4
; TONGA-NEXT:    v_add_u32_e32 v0, vcc, v2, v4
; TONGA-NEXT:    v_mul_hi_u32 v0, s4, v0
; TONGA-NEXT:    v_mov_b32_e32 v2, s0
; TONGA-NEXT:    v_readfirstlane_b32 s0, v1
; TONGA-NEXT:    v_readfirstlane_b32 s6, v0
; TONGA-NEXT:    s_mul_i32 s6, s6, s2
; TONGA-NEXT:    s_sub_i32 s4, s4, s6
; TONGA-NEXT:    s_sub_i32 s6, s4, s2
; TONGA-NEXT:    s_cmp_ge_u32 s4, s2
; TONGA-NEXT:    s_cselect_b32 s4, s6, s4
; TONGA-NEXT:    s_sub_i32 s6, s4, s2
; TONGA-NEXT:    s_cmp_ge_u32 s4, s2
; TONGA-NEXT:    s_cselect_b32 s2, s6, s4
; TONGA-NEXT:    s_abs_i32 s4, s5
; TONGA-NEXT:    v_cvt_f32_u32_e32 v0, s4
; TONGA-NEXT:    s_sub_i32 s5, 0, s4
; TONGA-NEXT:    s_abs_i32 s1, s0
; TONGA-NEXT:    s_xor_b32 s2, s2, s3
; TONGA-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; TONGA-NEXT:    s_sub_i32 s2, s2, s3
; TONGA-NEXT:    s_ashr_i32 s0, s0, 31
; TONGA-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; TONGA-NEXT:    v_cvt_u32_f32_e32 v0, v0
; TONGA-NEXT:    v_mul_lo_u32 v4, s5, v0
; TONGA-NEXT:    v_mul_hi_u32 v4, v0, v4
; TONGA-NEXT:    v_add_u32_e32 v0, vcc, v0, v4
; TONGA-NEXT:    v_mul_hi_u32 v0, s1, v0
; TONGA-NEXT:    v_readfirstlane_b32 s3, v0
; TONGA-NEXT:    s_mul_i32 s3, s3, s4
; TONGA-NEXT:    s_sub_i32 s1, s1, s3
; TONGA-NEXT:    s_sub_i32 s3, s1, s4
; TONGA-NEXT:    s_cmp_ge_u32 s1, s4
; TONGA-NEXT:    s_cselect_b32 s1, s3, s1
; TONGA-NEXT:    s_sub_i32 s3, s1, s4
; TONGA-NEXT:    s_cmp_ge_u32 s1, s4
; TONGA-NEXT:    s_cselect_b32 s1, s3, s1
; TONGA-NEXT:    s_xor_b32 s1, s1, s0
; TONGA-NEXT:    s_sub_i32 s0, s1, s0
; TONGA-NEXT:    v_mov_b32_e32 v0, s2
; TONGA-NEXT:    v_mov_b32_e32 v1, s0
; TONGA-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; TONGA-NEXT:    s_endpgm
;
; EG-LABEL: srem_v2i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 45, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     SETGT_INT * T1.W, 0.0, T0.W,
; EG-NEXT:     ADD_INT T0.W, T0.W, PV.W,
; EG-NEXT:     SETGT_INT * T2.W, 0.0, T0.Z,
; EG-NEXT:     XOR_INT * T0.W, PV.W, T1.W,
; EG-NEXT:     SUB_INT T1.Z, 0.0, PV.W,
; EG-NEXT:     ADD_INT T1.W, T0.Z, T2.W,
; EG-NEXT:     RECIP_UINT * T0.Z, PV.W,
; EG-NEXT:     XOR_INT T1.W, PV.W, T2.W,
; EG-NEXT:     MULLO_INT * T1.X, PV.Z, PS,
; EG-NEXT:     SUB_INT T2.W, 0.0, PV.W,
; EG-NEXT:     RECIP_UINT * T1.Y, PV.W,
; EG-NEXT:     SETGT_INT T3.W, 0.0, T0.X,
; EG-NEXT:     MULLO_INT * T1.Z, PV.W, PS,
; EG-NEXT:     SETGT_INT T2.Z, 0.0, T0.Y,
; EG-NEXT:     ADD_INT T2.W, T0.X, PV.W,
; EG-NEXT:     MULHI * T0.X, T1.Y, PS,
; EG-NEXT:     ADD_INT T1.Y, T1.Y, PS,
; EG-NEXT:     XOR_INT T1.Z, PV.W, T3.W,
; EG-NEXT:     ADD_INT T2.W, T0.Y, PV.Z, BS:VEC_120/SCL_212
; EG-NEXT:     MULHI * T0.X, T0.Z, T1.X,
; EG-NEXT:     ADD_INT T0.Z, T0.Z, PS,
; EG-NEXT:     XOR_INT T2.W, PV.W, T2.Z,
; EG-NEXT:     MULHI * T0.X, PV.Z, PV.Y,
; EG-NEXT:     MULHI * T0.Y, PV.W, PV.Z,
; EG-NEXT:     MULLO_INT * T0.Y, PS, T0.W,
; EG-NEXT:     SUB_INT T2.W, T2.W, PS,
; EG-NEXT:     MULLO_INT * T0.X, T0.X, T1.W,
; EG-NEXT:     SUB_INT T0.Z, T1.Z, PS,
; EG-NEXT:     SETGE_UINT T4.W, PV.W, T0.W,
; EG-NEXT:     SUB_INT * T5.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T1.Z, PV.W, T2.W, PS, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T2.W, PV.Z, T1.W,
; EG-NEXT:     SUB_INT * T4.W, PV.Z, T1.W,
; EG-NEXT:     CNDE_INT T0.Z, PV.W, T0.Z, PS,
; EG-NEXT:     SETGE_UINT T2.W, PV.Z, T0.W,
; EG-NEXT:     SUB_INT * T0.W, PV.Z, T0.W,
; EG-NEXT:     CNDE_INT T1.Z, PV.W, T1.Z, PS,
; EG-NEXT:     SETGE_UINT T0.W, PV.Z, T1.W,
; EG-NEXT:     SUB_INT * T1.W, PV.Z, T1.W,
; EG-NEXT:     CNDE_INT T0.W, PV.W, T0.Z, PS, BS:VEC_021/SCL_122
; EG-NEXT:     XOR_INT * T1.W, PV.Z, T2.Z,
; EG-NEXT:     SUB_INT T0.Y, PS, T2.Z,
; EG-NEXT:     XOR_INT * T0.W, PV.W, T3.W,
; EG-NEXT:     SUB_INT T0.X, PV.W, T3.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %den_ptr = getelementptr <2 x i32>, ptr addrspace(1) %in, i32 1
  %num = load <2 x i32>, ptr addrspace(1) %in
  %den = load <2 x i32>, ptr addrspace(1) %den_ptr
  %result = srem <2 x i32> %num, %den
  store <2 x i32> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @srem_v2i32_4(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; GCN-LABEL: srem_v2i32_4:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    global_load_dwordx2 v[0:1], v2, s[2:3]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_readfirstlane_b32 s2, v0
; GCN-NEXT:    v_readfirstlane_b32 s3, v1
; GCN-NEXT:    s_ashr_i32 s4, s2, 31
; GCN-NEXT:    s_ashr_i32 s5, s3, 31
; GCN-NEXT:    s_lshr_b32 s4, s4, 30
; GCN-NEXT:    s_lshr_b32 s5, s5, 30
; GCN-NEXT:    s_add_i32 s4, s2, s4
; GCN-NEXT:    s_add_i32 s5, s3, s5
; GCN-NEXT:    s_and_b32 s4, s4, -4
; GCN-NEXT:    s_and_b32 s5, s5, -4
; GCN-NEXT:    s_sub_i32 s2, s2, s4
; GCN-NEXT:    s_sub_i32 s3, s3, s5
; GCN-NEXT:    v_mov_b32_e32 v0, s2
; GCN-NEXT:    v_mov_b32_e32 v1, s3
; GCN-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GCN-NEXT:    s_endpgm
;
; TAHITI-LABEL: srem_v2i32_4:
; TAHITI:       ; %bb.0:
; TAHITI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; TAHITI-NEXT:    s_mov_b32 s7, 0xf000
; TAHITI-NEXT:    s_mov_b32 s6, -1
; TAHITI-NEXT:    s_mov_b32 s10, s6
; TAHITI-NEXT:    s_mov_b32 s11, s7
; TAHITI-NEXT:    s_waitcnt lgkmcnt(0)
; TAHITI-NEXT:    s_mov_b32 s8, s2
; TAHITI-NEXT:    s_mov_b32 s9, s3
; TAHITI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; TAHITI-NEXT:    s_mov_b32 s4, s0
; TAHITI-NEXT:    s_mov_b32 s5, s1
; TAHITI-NEXT:    s_waitcnt vmcnt(0)
; TAHITI-NEXT:    v_readfirstlane_b32 s0, v0
; TAHITI-NEXT:    v_readfirstlane_b32 s1, v1
; TAHITI-NEXT:    s_ashr_i32 s2, s0, 31
; TAHITI-NEXT:    s_ashr_i32 s3, s1, 31
; TAHITI-NEXT:    s_lshr_b32 s2, s2, 30
; TAHITI-NEXT:    s_lshr_b32 s3, s3, 30
; TAHITI-NEXT:    s_add_i32 s2, s0, s2
; TAHITI-NEXT:    s_add_i32 s3, s1, s3
; TAHITI-NEXT:    s_and_b32 s2, s2, -4
; TAHITI-NEXT:    s_and_b32 s3, s3, -4
; TAHITI-NEXT:    s_sub_i32 s0, s0, s2
; TAHITI-NEXT:    s_sub_i32 s1, s1, s3
; TAHITI-NEXT:    v_mov_b32_e32 v0, s0
; TAHITI-NEXT:    v_mov_b32_e32 v1, s1
; TAHITI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; TAHITI-NEXT:    s_endpgm
;
; TONGA-LABEL: srem_v2i32_4:
; TONGA:       ; %bb.0:
; TONGA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; TONGA-NEXT:    s_waitcnt lgkmcnt(0)
; TONGA-NEXT:    v_mov_b32_e32 v0, s2
; TONGA-NEXT:    v_mov_b32_e32 v1, s3
; TONGA-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; TONGA-NEXT:    v_mov_b32_e32 v2, s0
; TONGA-NEXT:    v_mov_b32_e32 v3, s1
; TONGA-NEXT:    s_waitcnt vmcnt(0)
; TONGA-NEXT:    v_readfirstlane_b32 s0, v0
; TONGA-NEXT:    v_readfirstlane_b32 s1, v1
; TONGA-NEXT:    s_ashr_i32 s2, s0, 31
; TONGA-NEXT:    s_ashr_i32 s3, s1, 31
; TONGA-NEXT:    s_lshr_b32 s2, s2, 30
; TONGA-NEXT:    s_lshr_b32 s3, s3, 30
; TONGA-NEXT:    s_add_i32 s2, s0, s2
; TONGA-NEXT:    s_add_i32 s3, s1, s3
; TONGA-NEXT:    s_and_b32 s2, s2, -4
; TONGA-NEXT:    s_and_b32 s3, s3, -4
; TONGA-NEXT:    s_sub_i32 s0, s0, s2
; TONGA-NEXT:    s_sub_i32 s1, s1, s3
; TONGA-NEXT:    v_mov_b32_e32 v0, s0
; TONGA-NEXT:    v_mov_b32_e32 v1, s1
; TONGA-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; TONGA-NEXT:    s_endpgm
;
; EG-LABEL: srem_v2i32_4:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 16, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_64 T0.XY, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     ASHR T0.W, T0.Y, literal.x,
; EG-NEXT:     ASHR * T1.W, T0.X, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR * T0.W, PV.W, literal.x,
; EG-NEXT:    30(4.203895e-44), 0(0.000000e+00)
; EG-NEXT:     ADD_INT T0.W, T0.Y, PV.W,
; EG-NEXT:     LSHR * T1.W, T1.W, literal.x,
; EG-NEXT:    30(4.203895e-44), 0(0.000000e+00)
; EG-NEXT:     ADD_INT T1.W, T0.X, PS,
; EG-NEXT:     AND_INT * T0.W, PV.W, literal.x,
; EG-NEXT:    -4(nan), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T0.Y, T0.Y, PS,
; EG-NEXT:     AND_INT * T0.W, PV.W, literal.x,
; EG-NEXT:    -4(nan), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T0.X, T0.X, PV.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %num = load <2 x i32>, ptr addrspace(1) %in
  %result = srem <2 x i32> %num, <i32 4, i32 4>
  store <2 x i32> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @srem_v4i32(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; GCN-LABEL: srem_v4i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    global_load_dwordx4 v[1:4], v0, s[2:3] offset:16
; GCN-NEXT:    global_load_dwordx4 v[5:8], v0, s[2:3]
; GCN-NEXT:    s_waitcnt vmcnt(1)
; GCN-NEXT:    v_readfirstlane_b32 s2, v1
; GCN-NEXT:    s_abs_i32 s2, s2
; GCN-NEXT:    v_cvt_f32_u32_e32 v1, s2
; GCN-NEXT:    s_sub_i32 s6, 0, s2
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_readfirstlane_b32 s4, v5
; GCN-NEXT:    s_ashr_i32 s5, s4, 31
; GCN-NEXT:    v_rcp_iflag_f32_e32 v1, v1
; GCN-NEXT:    s_abs_i32 s4, s4
; GCN-NEXT:    v_readfirstlane_b32 s3, v2
; GCN-NEXT:    v_mul_f32_e32 v1, 0x4f7ffffe, v1
; GCN-NEXT:    v_cvt_u32_f32_e32 v1, v1
; GCN-NEXT:    v_readfirstlane_b32 s7, v1
; GCN-NEXT:    s_mul_i32 s6, s6, s7
; GCN-NEXT:    s_mul_hi_u32 s6, s7, s6
; GCN-NEXT:    s_add_i32 s7, s7, s6
; GCN-NEXT:    s_mul_hi_u32 s6, s4, s7
; GCN-NEXT:    s_mul_i32 s6, s6, s2
; GCN-NEXT:    s_sub_i32 s4, s4, s6
; GCN-NEXT:    s_sub_i32 s6, s4, s2
; GCN-NEXT:    s_cmp_ge_u32 s4, s2
; GCN-NEXT:    s_cselect_b32 s4, s6, s4
; GCN-NEXT:    s_sub_i32 s6, s4, s2
; GCN-NEXT:    s_cmp_ge_u32 s4, s2
; GCN-NEXT:    s_cselect_b32 s2, s6, s4
; GCN-NEXT:    s_abs_i32 s3, s3
; GCN-NEXT:    v_cvt_f32_u32_e32 v1, s3
; GCN-NEXT:    s_xor_b32 s2, s2, s5
; GCN-NEXT:    s_sub_i32 s8, 0, s3
; GCN-NEXT:    s_sub_i32 s2, s2, s5
; GCN-NEXT:    v_rcp_iflag_f32_e32 v1, v1
; GCN-NEXT:    v_readfirstlane_b32 s6, v6
; GCN-NEXT:    s_ashr_i32 s7, s6, 31
; GCN-NEXT:    s_abs_i32 s6, s6
; GCN-NEXT:    v_mul_f32_e32 v1, 0x4f7ffffe, v1
; GCN-NEXT:    v_cvt_u32_f32_e32 v1, v1
; GCN-NEXT:    v_readfirstlane_b32 s4, v3
; GCN-NEXT:    v_readfirstlane_b32 s5, v1
; GCN-NEXT:    s_mul_i32 s8, s8, s5
; GCN-NEXT:    s_mul_hi_u32 s8, s5, s8
; GCN-NEXT:    s_add_i32 s5, s5, s8
; GCN-NEXT:    s_mul_hi_u32 s5, s6, s5
; GCN-NEXT:    s_mul_i32 s5, s5, s3
; GCN-NEXT:    s_sub_i32 s5, s6, s5
; GCN-NEXT:    s_sub_i32 s6, s5, s3
; GCN-NEXT:    s_cmp_ge_u32 s5, s3
; GCN-NEXT:    s_cselect_b32 s5, s6, s5
; GCN-NEXT:    s_sub_i32 s6, s5, s3
; GCN-NEXT:    s_cmp_ge_u32 s5, s3
; GCN-NEXT:    s_cselect_b32 s3, s6, s5
; GCN-NEXT:    s_abs_i32 s4, s4
; GCN-NEXT:    v_cvt_f32_u32_e32 v1, s4
; GCN-NEXT:    s_xor_b32 s3, s3, s7
; GCN-NEXT:    s_sub_i32 s9, 0, s4
; GCN-NEXT:    s_sub_i32 s3, s3, s7
; GCN-NEXT:    v_rcp_iflag_f32_e32 v1, v1
; GCN-NEXT:    v_readfirstlane_b32 s6, v7
; GCN-NEXT:    s_ashr_i32 s8, s6, 31
; GCN-NEXT:    s_abs_i32 s6, s6
; GCN-NEXT:    v_mul_f32_e32 v1, 0x4f7ffffe, v1
; GCN-NEXT:    v_cvt_u32_f32_e32 v1, v1
; GCN-NEXT:    v_readfirstlane_b32 s5, v4
; GCN-NEXT:    v_readfirstlane_b32 s7, v1
; GCN-NEXT:    s_mul_i32 s9, s9, s7
; GCN-NEXT:    s_mul_hi_u32 s9, s7, s9
; GCN-NEXT:    s_add_i32 s7, s7, s9
; GCN-NEXT:    s_mul_hi_u32 s7, s6, s7
; GCN-NEXT:    s_mul_i32 s7, s7, s4
; GCN-NEXT:    s_sub_i32 s6, s6, s7
; GCN-NEXT:    s_sub_i32 s7, s6, s4
; GCN-NEXT:    s_cmp_ge_u32 s6, s4
; GCN-NEXT:    s_cselect_b32 s6, s7, s6
; GCN-NEXT:    s_sub_i32 s7, s6, s4
; GCN-NEXT:    s_cmp_ge_u32 s6, s4
; GCN-NEXT:    s_cselect_b32 s4, s7, s6
; GCN-NEXT:    s_abs_i32 s5, s5
; GCN-NEXT:    v_cvt_f32_u32_e32 v2, s5
; GCN-NEXT:    v_readfirstlane_b32 s6, v8
; GCN-NEXT:    v_mov_b32_e32 v1, s2
; GCN-NEXT:    s_ashr_i32 s2, s6, 31
; GCN-NEXT:    v_rcp_iflag_f32_e32 v3, v2
; GCN-NEXT:    v_mov_b32_e32 v2, s3
; GCN-NEXT:    s_abs_i32 s3, s6
; GCN-NEXT:    s_sub_i32 s6, 0, s5
; GCN-NEXT:    v_mul_f32_e32 v3, 0x4f7ffffe, v3
; GCN-NEXT:    v_cvt_u32_f32_e32 v3, v3
; GCN-NEXT:    s_xor_b32 s4, s4, s8
; GCN-NEXT:    s_sub_i32 s4, s4, s8
; GCN-NEXT:    v_readfirstlane_b32 s7, v3
; GCN-NEXT:    s_mul_i32 s6, s6, s7
; GCN-NEXT:    s_mul_hi_u32 s6, s7, s6
; GCN-NEXT:    s_add_i32 s7, s7, s6
; GCN-NEXT:    s_mul_hi_u32 s6, s3, s7
; GCN-NEXT:    s_mul_i32 s6, s6, s5
; GCN-NEXT:    s_sub_i32 s3, s3, s6
; GCN-NEXT:    s_sub_i32 s6, s3, s5
; GCN-NEXT:    s_cmp_ge_u32 s3, s5
; GCN-NEXT:    s_cselect_b32 s3, s6, s3
; GCN-NEXT:    s_sub_i32 s6, s3, s5
; GCN-NEXT:    s_cmp_ge_u32 s3, s5
; GCN-NEXT:    s_cselect_b32 s3, s6, s3
; GCN-NEXT:    s_xor_b32 s3, s3, s2
; GCN-NEXT:    s_sub_i32 s2, s3, s2
; GCN-NEXT:    v_mov_b32_e32 v3, s4
; GCN-NEXT:    v_mov_b32_e32 v4, s2
; GCN-NEXT:    global_store_dwordx4 v0, v[1:4], s[0:1]
; GCN-NEXT:    s_endpgm
;
; TAHITI-LABEL: srem_v4i32:
; TAHITI:       ; %bb.0:
; TAHITI-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x9
; TAHITI-NEXT:    s_mov_b32 s3, 0xf000
; TAHITI-NEXT:    s_mov_b32 s2, -1
; TAHITI-NEXT:    s_mov_b32 s10, s2
; TAHITI-NEXT:    s_mov_b32 s11, s3
; TAHITI-NEXT:    s_waitcnt lgkmcnt(0)
; TAHITI-NEXT:    s_mov_b32 s8, s6
; TAHITI-NEXT:    s_mov_b32 s9, s7
; TAHITI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0 offset:16
; TAHITI-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0
; TAHITI-NEXT:    s_waitcnt vmcnt(1)
; TAHITI-NEXT:    v_readfirstlane_b32 s0, v0
; TAHITI-NEXT:    s_abs_i32 s0, s0
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v0, s0
; TAHITI-NEXT:    s_sub_i32 s1, 0, s0
; TAHITI-NEXT:    v_readfirstlane_b32 s7, v1
; TAHITI-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; TAHITI-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v0, v0
; TAHITI-NEXT:    v_mul_lo_u32 v8, s1, v0
; TAHITI-NEXT:    s_waitcnt vmcnt(0)
; TAHITI-NEXT:    v_readfirstlane_b32 s1, v4
; TAHITI-NEXT:    s_abs_i32 s6, s1
; TAHITI-NEXT:    s_ashr_i32 s1, s1, 31
; TAHITI-NEXT:    v_mul_hi_u32 v8, v0, v8
; TAHITI-NEXT:    v_add_i32_e32 v0, vcc, v0, v8
; TAHITI-NEXT:    v_mul_hi_u32 v0, s6, v0
; TAHITI-NEXT:    v_readfirstlane_b32 s8, v0
; TAHITI-NEXT:    s_mul_i32 s8, s8, s0
; TAHITI-NEXT:    s_sub_i32 s6, s6, s8
; TAHITI-NEXT:    s_sub_i32 s8, s6, s0
; TAHITI-NEXT:    s_cmp_ge_u32 s6, s0
; TAHITI-NEXT:    s_cselect_b32 s6, s8, s6
; TAHITI-NEXT:    s_sub_i32 s8, s6, s0
; TAHITI-NEXT:    s_cmp_ge_u32 s6, s0
; TAHITI-NEXT:    s_cselect_b32 s0, s8, s6
; TAHITI-NEXT:    s_abs_i32 s6, s7
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v0, s6
; TAHITI-NEXT:    s_sub_i32 s7, 0, s6
; TAHITI-NEXT:    v_readfirstlane_b32 s8, v5
; TAHITI-NEXT:    s_abs_i32 s9, s8
; TAHITI-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; TAHITI-NEXT:    s_xor_b32 s0, s0, s1
; TAHITI-NEXT:    s_sub_i32 s10, s0, s1
; TAHITI-NEXT:    s_ashr_i32 s8, s8, 31
; TAHITI-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v0, v0
; TAHITI-NEXT:    v_mul_lo_u32 v1, s7, v0
; TAHITI-NEXT:    v_readfirstlane_b32 s7, v2
; TAHITI-NEXT:    v_mul_hi_u32 v1, v0, v1
; TAHITI-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; TAHITI-NEXT:    v_mul_hi_u32 v0, s9, v0
; TAHITI-NEXT:    v_readfirstlane_b32 s0, v0
; TAHITI-NEXT:    s_mul_i32 s0, s0, s6
; TAHITI-NEXT:    s_sub_i32 s0, s9, s0
; TAHITI-NEXT:    s_sub_i32 s1, s0, s6
; TAHITI-NEXT:    s_cmp_ge_u32 s0, s6
; TAHITI-NEXT:    s_cselect_b32 s0, s1, s0
; TAHITI-NEXT:    s_sub_i32 s1, s0, s6
; TAHITI-NEXT:    s_cmp_ge_u32 s0, s6
; TAHITI-NEXT:    s_cselect_b32 s0, s1, s0
; TAHITI-NEXT:    s_abs_i32 s1, s7
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v0, s1
; TAHITI-NEXT:    s_sub_i32 s6, 0, s1
; TAHITI-NEXT:    v_readfirstlane_b32 s7, v6
; TAHITI-NEXT:    s_abs_i32 s9, s7
; TAHITI-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; TAHITI-NEXT:    s_xor_b32 s0, s0, s8
; TAHITI-NEXT:    s_sub_i32 s8, s0, s8
; TAHITI-NEXT:    s_ashr_i32 s7, s7, 31
; TAHITI-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v0, v0
; TAHITI-NEXT:    v_mul_lo_u32 v1, s6, v0
; TAHITI-NEXT:    v_readfirstlane_b32 s6, v3
; TAHITI-NEXT:    v_mul_hi_u32 v1, v0, v1
; TAHITI-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; TAHITI-NEXT:    v_mul_hi_u32 v0, s9, v0
; TAHITI-NEXT:    v_readfirstlane_b32 s0, v0
; TAHITI-NEXT:    s_mul_i32 s0, s0, s1
; TAHITI-NEXT:    s_sub_i32 s0, s9, s0
; TAHITI-NEXT:    s_sub_i32 s9, s0, s1
; TAHITI-NEXT:    s_cmp_ge_u32 s0, s1
; TAHITI-NEXT:    s_cselect_b32 s0, s9, s0
; TAHITI-NEXT:    s_sub_i32 s9, s0, s1
; TAHITI-NEXT:    s_cmp_ge_u32 s0, s1
; TAHITI-NEXT:    s_cselect_b32 s9, s9, s0
; TAHITI-NEXT:    s_abs_i32 s6, s6
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v0, s6
; TAHITI-NEXT:    s_sub_i32 s1, 0, s6
; TAHITI-NEXT:    s_mov_b32 s0, s4
; TAHITI-NEXT:    v_readfirstlane_b32 s4, v7
; TAHITI-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; TAHITI-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v2, v0
; TAHITI-NEXT:    v_mov_b32_e32 v0, s10
; TAHITI-NEXT:    v_mul_lo_u32 v1, s1, v2
; TAHITI-NEXT:    s_mov_b32 s1, s5
; TAHITI-NEXT:    s_abs_i32 s5, s4
; TAHITI-NEXT:    s_ashr_i32 s4, s4, 31
; TAHITI-NEXT:    v_mul_hi_u32 v3, v2, v1
; TAHITI-NEXT:    v_mov_b32_e32 v1, s8
; TAHITI-NEXT:    s_xor_b32 s8, s9, s7
; TAHITI-NEXT:    s_sub_i32 s7, s8, s7
; TAHITI-NEXT:    v_add_i32_e32 v2, vcc, v2, v3
; TAHITI-NEXT:    v_mul_hi_u32 v2, s5, v2
; TAHITI-NEXT:    v_readfirstlane_b32 s8, v2
; TAHITI-NEXT:    s_mul_i32 s8, s8, s6
; TAHITI-NEXT:    s_sub_i32 s5, s5, s8
; TAHITI-NEXT:    s_sub_i32 s8, s5, s6
; TAHITI-NEXT:    s_cmp_ge_u32 s5, s6
; TAHITI-NEXT:    s_cselect_b32 s5, s8, s5
; TAHITI-NEXT:    s_sub_i32 s8, s5, s6
; TAHITI-NEXT:    s_cmp_ge_u32 s5, s6
; TAHITI-NEXT:    s_cselect_b32 s5, s8, s5
; TAHITI-NEXT:    s_xor_b32 s5, s5, s4
; TAHITI-NEXT:    s_sub_i32 s4, s5, s4
; TAHITI-NEXT:    v_mov_b32_e32 v2, s7
; TAHITI-NEXT:    v_mov_b32_e32 v3, s4
; TAHITI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; TAHITI-NEXT:    s_endpgm
;
; TONGA-LABEL: srem_v4i32:
; TONGA:       ; %bb.0:
; TONGA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; TONGA-NEXT:    s_waitcnt lgkmcnt(0)
; TONGA-NEXT:    s_add_u32 s4, s2, 16
; TONGA-NEXT:    s_addc_u32 s5, s3, 0
; TONGA-NEXT:    v_mov_b32_e32 v0, s4
; TONGA-NEXT:    v_mov_b32_e32 v1, s5
; TONGA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; TONGA-NEXT:    v_mov_b32_e32 v5, s3
; TONGA-NEXT:    v_mov_b32_e32 v4, s2
; TONGA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; TONGA-NEXT:    s_waitcnt vmcnt(1)
; TONGA-NEXT:    v_readfirstlane_b32 s2, v0
; TONGA-NEXT:    s_abs_i32 s2, s2
; TONGA-NEXT:    v_cvt_f32_u32_e32 v0, s2
; TONGA-NEXT:    s_sub_i32 s3, 0, s2
; TONGA-NEXT:    v_readfirstlane_b32 s5, v1
; TONGA-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; TONGA-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; TONGA-NEXT:    v_cvt_u32_f32_e32 v0, v0
; TONGA-NEXT:    v_mul_lo_u32 v8, s3, v0
; TONGA-NEXT:    s_waitcnt vmcnt(0)
; TONGA-NEXT:    v_readfirstlane_b32 s3, v4
; TONGA-NEXT:    s_abs_i32 s4, s3
; TONGA-NEXT:    s_ashr_i32 s3, s3, 31
; TONGA-NEXT:    v_mul_hi_u32 v8, v0, v8
; TONGA-NEXT:    v_mov_b32_e32 v4, s0
; TONGA-NEXT:    v_add_u32_e32 v0, vcc, v0, v8
; TONGA-NEXT:    v_mul_hi_u32 v0, s4, v0
; TONGA-NEXT:    v_readfirstlane_b32 s6, v0
; TONGA-NEXT:    s_mul_i32 s6, s6, s2
; TONGA-NEXT:    s_sub_i32 s4, s4, s6
; TONGA-NEXT:    s_sub_i32 s6, s4, s2
; TONGA-NEXT:    s_cmp_ge_u32 s4, s2
; TONGA-NEXT:    s_cselect_b32 s4, s6, s4
; TONGA-NEXT:    s_sub_i32 s6, s4, s2
; TONGA-NEXT:    s_cmp_ge_u32 s4, s2
; TONGA-NEXT:    s_cselect_b32 s2, s6, s4
; TONGA-NEXT:    s_abs_i32 s4, s5
; TONGA-NEXT:    v_cvt_f32_u32_e32 v0, s4
; TONGA-NEXT:    s_sub_i32 s5, 0, s4
; TONGA-NEXT:    v_readfirstlane_b32 s6, v5
; TONGA-NEXT:    s_abs_i32 s7, s6
; TONGA-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; TONGA-NEXT:    s_xor_b32 s2, s2, s3
; TONGA-NEXT:    s_sub_i32 s2, s2, s3
; TONGA-NEXT:    s_ashr_i32 s6, s6, 31
; TONGA-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; TONGA-NEXT:    v_cvt_u32_f32_e32 v0, v0
; TONGA-NEXT:    v_mov_b32_e32 v5, s1
; TONGA-NEXT:    v_mul_lo_u32 v1, s5, v0
; TONGA-NEXT:    v_readfirstlane_b32 s5, v2
; TONGA-NEXT:    v_mul_hi_u32 v1, v0, v1
; TONGA-NEXT:    v_add_u32_e32 v0, vcc, v0, v1
; TONGA-NEXT:    v_mul_hi_u32 v0, s7, v0
; TONGA-NEXT:    v_readfirstlane_b32 s3, v0
; TONGA-NEXT:    s_mul_i32 s3, s3, s4
; TONGA-NEXT:    s_sub_i32 s3, s7, s3
; TONGA-NEXT:    s_sub_i32 s7, s3, s4
; TONGA-NEXT:    s_cmp_ge_u32 s3, s4
; TONGA-NEXT:    s_cselect_b32 s3, s7, s3
; TONGA-NEXT:    s_sub_i32 s7, s3, s4
; TONGA-NEXT:    s_cmp_ge_u32 s3, s4
; TONGA-NEXT:    s_cselect_b32 s3, s7, s3
; TONGA-NEXT:    s_abs_i32 s4, s5
; TONGA-NEXT:    v_cvt_f32_u32_e32 v0, s4
; TONGA-NEXT:    s_sub_i32 s5, 0, s4
; TONGA-NEXT:    v_readfirstlane_b32 s7, v6
; TONGA-NEXT:    s_abs_i32 s8, s7
; TONGA-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; TONGA-NEXT:    s_xor_b32 s3, s3, s6
; TONGA-NEXT:    s_sub_i32 s3, s3, s6
; TONGA-NEXT:    s_ashr_i32 s7, s7, 31
; TONGA-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; TONGA-NEXT:    v_cvt_u32_f32_e32 v0, v0
; TONGA-NEXT:    v_mul_lo_u32 v1, s5, v0
; TONGA-NEXT:    v_readfirstlane_b32 s5, v3
; TONGA-NEXT:    v_mul_hi_u32 v1, v0, v1
; TONGA-NEXT:    v_add_u32_e32 v0, vcc, v0, v1
; TONGA-NEXT:    v_mul_hi_u32 v0, s8, v0
; TONGA-NEXT:    v_readfirstlane_b32 s6, v0
; TONGA-NEXT:    s_mul_i32 s6, s6, s4
; TONGA-NEXT:    s_sub_i32 s6, s8, s6
; TONGA-NEXT:    s_sub_i32 s8, s6, s4
; TONGA-NEXT:    s_cmp_ge_u32 s6, s4
; TONGA-NEXT:    s_cselect_b32 s6, s8, s6
; TONGA-NEXT:    s_sub_i32 s8, s6, s4
; TONGA-NEXT:    s_cmp_ge_u32 s6, s4
; TONGA-NEXT:    s_cselect_b32 s4, s8, s6
; TONGA-NEXT:    s_abs_i32 s5, s5
; TONGA-NEXT:    v_cvt_f32_u32_e32 v0, s5
; TONGA-NEXT:    s_sub_i32 s0, 0, s5
; TONGA-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; TONGA-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; TONGA-NEXT:    v_cvt_u32_f32_e32 v2, v0
; TONGA-NEXT:    v_mov_b32_e32 v0, s2
; TONGA-NEXT:    s_xor_b32 s2, s4, s7
; TONGA-NEXT:    s_sub_i32 s2, s2, s7
; TONGA-NEXT:    v_mul_lo_u32 v1, s0, v2
; TONGA-NEXT:    v_readfirstlane_b32 s0, v7
; TONGA-NEXT:    s_abs_i32 s1, s0
; TONGA-NEXT:    s_ashr_i32 s0, s0, 31
; TONGA-NEXT:    v_mul_hi_u32 v3, v2, v1
; TONGA-NEXT:    v_mov_b32_e32 v1, s3
; TONGA-NEXT:    v_add_u32_e32 v2, vcc, v2, v3
; TONGA-NEXT:    v_mul_hi_u32 v2, s1, v2
; TONGA-NEXT:    v_readfirstlane_b32 s3, v2
; TONGA-NEXT:    s_mul_i32 s3, s3, s5
; TONGA-NEXT:    s_sub_i32 s1, s1, s3
; TONGA-NEXT:    s_sub_i32 s3, s1, s5
; TONGA-NEXT:    s_cmp_ge_u32 s1, s5
; TONGA-NEXT:    s_cselect_b32 s1, s3, s1
; TONGA-NEXT:    s_sub_i32 s3, s1, s5
; TONGA-NEXT:    s_cmp_ge_u32 s1, s5
; TONGA-NEXT:    s_cselect_b32 s1, s3, s1
; TONGA-NEXT:    s_xor_b32 s1, s1, s0
; TONGA-NEXT:    s_sub_i32 s0, s1, s0
; TONGA-NEXT:    v_mov_b32_e32 v2, s2
; TONGA-NEXT:    v_mov_b32_e32 v3, s0
; TONGA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; TONGA-NEXT:    s_endpgm
;
; EG-LABEL: srem_v4i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 89, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T2.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     SETGT_INT * T2.W, 0.0, T1.Z,
; EG-NEXT:     ADD_INT T3.W, T1.Z, PV.W,
; EG-NEXT:     SETGT_INT * T4.W, 0.0, T1.Y,
; EG-NEXT:     XOR_INT * T2.W, PV.W, T2.W,
; EG-NEXT:     SUB_INT T1.Z, 0.0, PV.W,
; EG-NEXT:     ADD_INT T3.W, T1.Y, T4.W,
; EG-NEXT:     RECIP_UINT * T1.Y, PV.W,
; EG-NEXT:     XOR_INT T3.W, PV.W, T4.W,
; EG-NEXT:     MULLO_INT * T1.Z, PV.Z, PS,
; EG-NEXT:     SUB_INT T4.W, 0.0, PV.W,
; EG-NEXT:     RECIP_UINT * T2.X, PV.W,
; EG-NEXT:     SETGT_INT T5.W, 0.0, T0.Y,
; EG-NEXT:     MULLO_INT * T2.Y, PV.W, PS,
; EG-NEXT:     SETGT_INT T2.Z, 0.0, T0.Z,
; EG-NEXT:     ADD_INT T4.W, T0.Y, PV.W,
; EG-NEXT:     MULHI * T0.Y, T2.X, PS,
; EG-NEXT:     ADD_INT T2.X, T2.X, PS,
; EG-NEXT:     XOR_INT T0.Y, PV.W, T5.W,
; EG-NEXT:     SETGT_INT T3.Z, 0.0, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     ADD_INT T4.W, T0.Z, PV.Z,
; EG-NEXT:     MULHI * T0.Z, T1.Y, T1.Z,
; EG-NEXT:     ADD_INT T1.Y, T1.Y, PS,
; EG-NEXT:     XOR_INT T0.Z, PV.W, T2.Z,
; EG-NEXT:     ADD_INT T1.W, T1.W, PV.Z,
; EG-NEXT:     MULHI * T1.Z, PV.Y, PV.X,
; EG-NEXT:     XOR_INT T1.W, PV.W, T3.Z,
; EG-NEXT:     MULHI * T1.Y, PV.Z, PV.Y,
; EG-NEXT:     SUB_INT T4.W, 0.0, PV.W,
; EG-NEXT:     RECIP_UINT * T2.X, PV.W,
; EG-NEXT:     SETGT_INT T6.W, 0.0, T0.W,
; EG-NEXT:     MULLO_INT * T2.Y, PV.W, PS,
; EG-NEXT:     ADD_INT T0.W, T0.W, PV.W,
; EG-NEXT:     MULHI * T2.Y, T2.X, PS,
; EG-NEXT:     ADD_INT T2.Y, T2.X, PS,
; EG-NEXT:     XOR_INT T3.Z, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGT_INT T0.W, 0.0, T1.X,
; EG-NEXT:     MULLO_INT * T1.Y, T1.Y, T2.W,
; EG-NEXT:     ADD_INT T4.W, T1.X, PV.W,
; EG-NEXT:     MULHI * T1.X, PV.Z, PV.Y,
; EG-NEXT:     XOR_INT T0.W, PV.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     MULLO_INT * T1.X, PS, T1.W,
; EG-NEXT:     SUB_INT T4.W, 0.0, PV.W,
; EG-NEXT:     RECIP_UINT * T2.X, PV.W,
; EG-NEXT:     SETGT_INT T7.W, 0.0, T0.X,
; EG-NEXT:     MULLO_INT * T2.Y, PV.W, PS,
; EG-NEXT:     ADD_INT T4.W, T0.X, PV.W,
; EG-NEXT:     MULHI * T0.X, T2.X, PS,
; EG-NEXT:     ADD_INT T0.X, T2.X, PS,
; EG-NEXT:     XOR_INT T2.Y, PV.W, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T3.Z, T3.Z, T1.X,
; EG-NEXT:     SUB_INT T4.W, T0.Z, T1.Y, BS:VEC_120/SCL_212
; EG-NEXT:     MULLO_INT * T0.Z, T1.Z, T3.W,
; EG-NEXT:     SETGE_UINT T1.X, PV.W, T2.W,
; EG-NEXT:     SUB_INT T0.Y, T0.Y, PS,
; EG-NEXT:     SETGE_UINT T0.Z, PV.Z, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T8.W, PV.Z, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     MULHI * T0.X, PV.Y, PV.X,
; EG-NEXT:     SUB_INT T2.X, T4.W, T2.W,
; EG-NEXT:     CNDE_INT T1.Y, PV.Z, T3.Z, PV.W,
; EG-NEXT:     SETGE_UINT T0.Z, PV.Y, T3.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT * T8.W, PV.Y, T3.W, BS:VEC_021/SCL_122
; EG-NEXT:     MULLO_INT * T0.X, T0.X, T0.W,
; EG-NEXT:     CNDE_INT T3.X, T0.Z, T0.Y, T8.W,
; EG-NEXT:     SETGE_UINT T0.Y, T1.Y, T1.W,
; EG-NEXT:     SUB_INT T0.Z, T1.Y, T1.W,
; EG-NEXT:     CNDE_INT T1.W, T1.X, T4.W, T2.X, BS:VEC_102/SCL_221
; EG-NEXT:     SUB_INT * T4.W, T2.Y, PS,
; EG-NEXT:     SETGE_UINT T0.X, PS, T0.W,
; EG-NEXT:     SUB_INT T2.Y, PS, T0.W,
; EG-NEXT:     SETGE_UINT T1.Z, PV.W, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T2.W, PV.W, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T8.W, PV.Y, T1.Y, PV.Z,
; EG-NEXT:     XOR_INT T1.X, PS, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.Z, T1.W, PV.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T0.Z, PV.X, T4.W, PV.Y, BS:VEC_102/SCL_221
; EG-NEXT:     SETGE_UINT T1.W, T3.X, T3.W,
; EG-NEXT:     SUB_INT * T2.W, T3.X, T3.W,
; EG-NEXT:     CNDE_INT T0.X, PV.W, T3.X, PS,
; EG-NEXT:     SETGE_UINT T1.Y, T0.Z, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T1.Z, T0.Z, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     XOR_INT T0.W, T0.Y, T2.Z,
; EG-NEXT:     SUB_INT * T2.W, T1.X, T6.W,
; EG-NEXT:     SUB_INT T2.Z, PV.W, T2.Z,
; EG-NEXT:     CNDE_INT T0.W, PV.Y, T0.Z, PV.Z, BS:VEC_021/SCL_122
; EG-NEXT:     XOR_INT * T1.W, PV.X, T5.W,
; EG-NEXT:     SUB_INT T2.Y, PS, T5.W,
; EG-NEXT:     XOR_INT * T0.W, PV.W, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T2.X, PV.W, T7.W,
; EG-NEXT:     LSHR * T0.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %den_ptr = getelementptr <4 x i32>, ptr addrspace(1) %in, i32 1
  %num = load <4 x i32>, ptr addrspace(1) %in
  %den = load <4 x i32>, ptr addrspace(1) %den_ptr
  %result = srem <4 x i32> %num, %den
  store <4 x i32> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @srem_v4i32_4(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; GCN-LABEL: srem_v4i32_4:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v4, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    global_load_dwordx4 v[0:3], v4, s[2:3]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_readfirstlane_b32 s2, v0
; GCN-NEXT:    v_readfirstlane_b32 s3, v1
; GCN-NEXT:    v_readfirstlane_b32 s4, v2
; GCN-NEXT:    v_readfirstlane_b32 s5, v3
; GCN-NEXT:    s_ashr_i32 s6, s2, 31
; GCN-NEXT:    s_ashr_i32 s7, s3, 31
; GCN-NEXT:    s_ashr_i32 s8, s4, 31
; GCN-NEXT:    s_ashr_i32 s9, s5, 31
; GCN-NEXT:    s_lshr_b32 s6, s6, 30
; GCN-NEXT:    s_lshr_b32 s7, s7, 30
; GCN-NEXT:    s_lshr_b32 s8, s8, 30
; GCN-NEXT:    s_lshr_b32 s9, s9, 30
; GCN-NEXT:    s_add_i32 s6, s2, s6
; GCN-NEXT:    s_add_i32 s7, s3, s7
; GCN-NEXT:    s_add_i32 s8, s4, s8
; GCN-NEXT:    s_add_i32 s9, s5, s9
; GCN-NEXT:    s_and_b32 s6, s6, -4
; GCN-NEXT:    s_and_b32 s7, s7, -4
; GCN-NEXT:    s_and_b32 s8, s8, -4
; GCN-NEXT:    s_and_b32 s9, s9, -4
; GCN-NEXT:    s_sub_i32 s2, s2, s6
; GCN-NEXT:    s_sub_i32 s3, s3, s7
; GCN-NEXT:    s_sub_i32 s4, s4, s8
; GCN-NEXT:    s_sub_i32 s5, s5, s9
; GCN-NEXT:    v_mov_b32_e32 v0, s2
; GCN-NEXT:    v_mov_b32_e32 v1, s3
; GCN-NEXT:    v_mov_b32_e32 v2, s4
; GCN-NEXT:    v_mov_b32_e32 v3, s5
; GCN-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GCN-NEXT:    s_endpgm
;
; TAHITI-LABEL: srem_v4i32_4:
; TAHITI:       ; %bb.0:
; TAHITI-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x9
; TAHITI-NEXT:    s_mov_b32 s3, 0xf000
; TAHITI-NEXT:    s_mov_b32 s2, -1
; TAHITI-NEXT:    s_mov_b32 s10, s2
; TAHITI-NEXT:    s_mov_b32 s11, s3
; TAHITI-NEXT:    s_waitcnt lgkmcnt(0)
; TAHITI-NEXT:    s_mov_b32 s8, s6
; TAHITI-NEXT:    s_mov_b32 s9, s7
; TAHITI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; TAHITI-NEXT:    s_mov_b32 s0, s4
; TAHITI-NEXT:    s_mov_b32 s1, s5
; TAHITI-NEXT:    s_waitcnt vmcnt(0)
; TAHITI-NEXT:    v_readfirstlane_b32 s4, v0
; TAHITI-NEXT:    v_readfirstlane_b32 s5, v1
; TAHITI-NEXT:    v_readfirstlane_b32 s6, v2
; TAHITI-NEXT:    v_readfirstlane_b32 s7, v3
; TAHITI-NEXT:    s_ashr_i32 s8, s4, 31
; TAHITI-NEXT:    s_ashr_i32 s9, s5, 31
; TAHITI-NEXT:    s_ashr_i32 s10, s6, 31
; TAHITI-NEXT:    s_ashr_i32 s11, s7, 31
; TAHITI-NEXT:    s_lshr_b32 s8, s8, 30
; TAHITI-NEXT:    s_lshr_b32 s9, s9, 30
; TAHITI-NEXT:    s_lshr_b32 s10, s10, 30
; TAHITI-NEXT:    s_lshr_b32 s11, s11, 30
; TAHITI-NEXT:    s_add_i32 s8, s4, s8
; TAHITI-NEXT:    s_add_i32 s9, s5, s9
; TAHITI-NEXT:    s_add_i32 s10, s6, s10
; TAHITI-NEXT:    s_add_i32 s11, s7, s11
; TAHITI-NEXT:    s_and_b32 s8, s8, -4
; TAHITI-NEXT:    s_and_b32 s9, s9, -4
; TAHITI-NEXT:    s_and_b32 s10, s10, -4
; TAHITI-NEXT:    s_and_b32 s11, s11, -4
; TAHITI-NEXT:    s_sub_i32 s4, s4, s8
; TAHITI-NEXT:    s_sub_i32 s5, s5, s9
; TAHITI-NEXT:    s_sub_i32 s6, s6, s10
; TAHITI-NEXT:    s_sub_i32 s7, s7, s11
; TAHITI-NEXT:    v_mov_b32_e32 v0, s4
; TAHITI-NEXT:    v_mov_b32_e32 v1, s5
; TAHITI-NEXT:    v_mov_b32_e32 v2, s6
; TAHITI-NEXT:    v_mov_b32_e32 v3, s7
; TAHITI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; TAHITI-NEXT:    s_endpgm
;
; TONGA-LABEL: srem_v4i32_4:
; TONGA:       ; %bb.0:
; TONGA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; TONGA-NEXT:    s_waitcnt lgkmcnt(0)
; TONGA-NEXT:    v_mov_b32_e32 v0, s2
; TONGA-NEXT:    v_mov_b32_e32 v1, s3
; TONGA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; TONGA-NEXT:    v_mov_b32_e32 v4, s0
; TONGA-NEXT:    v_mov_b32_e32 v5, s1
; TONGA-NEXT:    s_waitcnt vmcnt(0)
; TONGA-NEXT:    v_readfirstlane_b32 s0, v0
; TONGA-NEXT:    v_readfirstlane_b32 s1, v1
; TONGA-NEXT:    v_readfirstlane_b32 s2, v2
; TONGA-NEXT:    v_readfirstlane_b32 s3, v3
; TONGA-NEXT:    s_ashr_i32 s4, s0, 31
; TONGA-NEXT:    s_ashr_i32 s5, s1, 31
; TONGA-NEXT:    s_ashr_i32 s6, s2, 31
; TONGA-NEXT:    s_ashr_i32 s7, s3, 31
; TONGA-NEXT:    s_lshr_b32 s4, s4, 30
; TONGA-NEXT:    s_lshr_b32 s5, s5, 30
; TONGA-NEXT:    s_lshr_b32 s6, s6, 30
; TONGA-NEXT:    s_lshr_b32 s7, s7, 30
; TONGA-NEXT:    s_add_i32 s4, s0, s4
; TONGA-NEXT:    s_add_i32 s5, s1, s5
; TONGA-NEXT:    s_add_i32 s6, s2, s6
; TONGA-NEXT:    s_add_i32 s7, s3, s7
; TONGA-NEXT:    s_and_b32 s4, s4, -4
; TONGA-NEXT:    s_and_b32 s5, s5, -4
; TONGA-NEXT:    s_and_b32 s6, s6, -4
; TONGA-NEXT:    s_and_b32 s7, s7, -4
; TONGA-NEXT:    s_sub_i32 s0, s0, s4
; TONGA-NEXT:    s_sub_i32 s1, s1, s5
; TONGA-NEXT:    s_sub_i32 s2, s2, s6
; TONGA-NEXT:    s_sub_i32 s3, s3, s7
; TONGA-NEXT:    v_mov_b32_e32 v0, s0
; TONGA-NEXT:    v_mov_b32_e32 v1, s1
; TONGA-NEXT:    v_mov_b32_e32 v2, s2
; TONGA-NEXT:    v_mov_b32_e32 v3, s3
; TONGA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; TONGA-NEXT:    s_endpgm
;
; EG-LABEL: srem_v4i32_4:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 29, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     ASHR * T1.W, T0.W, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T1.W, PV.W, literal.x,
; EG-NEXT:     ASHR * T2.W, T0.Z, literal.y,
; EG-NEXT:    30(4.203895e-44), 31(4.344025e-44)
; EG-NEXT:     ASHR T1.Z, T0.Y, literal.x,
; EG-NEXT:     LSHR T2.W, PS, literal.y,
; EG-NEXT:     ADD_INT * T1.W, T0.W, PV.W,
; EG-NEXT:    31(4.344025e-44), 30(4.203895e-44)
; EG-NEXT:     AND_INT T1.Y, PS, literal.x,
; EG-NEXT:     ADD_INT T2.Z, T0.Z, PV.W,
; EG-NEXT:     ASHR T1.W, T0.X, literal.y,
; EG-NEXT:     LSHR * T2.W, PV.Z, literal.z,
; EG-NEXT:    -4(nan), 31(4.344025e-44)
; EG-NEXT:    30(4.203895e-44), 0(0.000000e+00)
; EG-NEXT:     ADD_INT T2.Y, T0.Y, PS,
; EG-NEXT:     LSHR T1.Z, PV.W, literal.x,
; EG-NEXT:     AND_INT T1.W, PV.Z, literal.y,
; EG-NEXT:     SUB_INT * T0.W, T0.W, PV.Y,
; EG-NEXT:    30(4.203895e-44), -4(nan)
; EG-NEXT:     SUB_INT T0.Z, T0.Z, PV.W,
; EG-NEXT:     ADD_INT T1.W, T0.X, PV.Z,
; EG-NEXT:     AND_INT * T2.W, PV.Y, literal.x,
; EG-NEXT:    -4(nan), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T0.Y, T0.Y, PS,
; EG-NEXT:     AND_INT * T1.W, PV.W, literal.x,
; EG-NEXT:    -4(nan), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T0.X, T0.X, PV.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %num = load <4 x i32>, ptr addrspace(1) %in
  %result = srem <4 x i32> %num, <i32 4, i32 4, i32 4, i32 4>
  store <4 x i32> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @srem_i64(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; GCN-LABEL: srem_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    global_load_dwordx4 v[0:3], v0, s[10:11]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_readfirstlane_b32 s7, v1
; GCN-NEXT:    v_readfirstlane_b32 s6, v0
; GCN-NEXT:    v_readfirstlane_b32 s5, v3
; GCN-NEXT:    v_readfirstlane_b32 s4, v2
; GCN-NEXT:    s_or_b64 s[0:1], s[6:7], s[4:5]
; GCN-NEXT:    s_mov_b32 s0, 0
; GCN-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GCN-NEXT:    s_cbranch_scc0 .LBB8_4
; GCN-NEXT:  ; %bb.1:
; GCN-NEXT:    s_ashr_i32 s0, s5, 31
; GCN-NEXT:    s_add_u32 s2, s4, s0
; GCN-NEXT:    s_mov_b32 s1, s0
; GCN-NEXT:    s_addc_u32 s3, s5, s0
; GCN-NEXT:    s_xor_b64 s[12:13], s[2:3], s[0:1]
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, s12
; GCN-NEXT:    v_cvt_f32_u32_e32 v1, s13
; GCN-NEXT:    s_sub_u32 s0, 0, s12
; GCN-NEXT:    s_subb_u32 s1, 0, s13
; GCN-NEXT:    v_madmk_f32 v0, v1, 0x4f800000, v0
; GCN-NEXT:    v_rcp_f32_e32 v0, v0
; GCN-NEXT:    v_mul_f32_e32 v0, 0x5f7ffffc, v0
; GCN-NEXT:    v_mul_f32_e32 v1, 0x2f800000, v0
; GCN-NEXT:    v_trunc_f32_e32 v1, v1
; GCN-NEXT:    v_madmk_f32 v0, v1, 0xcf800000, v0
; GCN-NEXT:    v_cvt_u32_f32_e32 v1, v1
; GCN-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GCN-NEXT:    v_readfirstlane_b32 s2, v1
; GCN-NEXT:    v_readfirstlane_b32 s3, v0
; GCN-NEXT:    s_mul_i32 s5, s0, s2
; GCN-NEXT:    s_mul_hi_u32 s15, s0, s3
; GCN-NEXT:    s_mul_i32 s14, s1, s3
; GCN-NEXT:    s_add_i32 s5, s15, s5
; GCN-NEXT:    s_add_i32 s5, s5, s14
; GCN-NEXT:    s_mul_i32 s16, s0, s3
; GCN-NEXT:    s_mul_hi_u32 s14, s3, s5
; GCN-NEXT:    s_mul_i32 s15, s3, s5
; GCN-NEXT:    s_mul_hi_u32 s3, s3, s16
; GCN-NEXT:    s_add_u32 s3, s3, s15
; GCN-NEXT:    s_addc_u32 s14, 0, s14
; GCN-NEXT:    s_mul_hi_u32 s17, s2, s16
; GCN-NEXT:    s_mul_i32 s16, s2, s16
; GCN-NEXT:    s_add_u32 s3, s3, s16
; GCN-NEXT:    s_mul_hi_u32 s15, s2, s5
; GCN-NEXT:    s_addc_u32 s3, s14, s17
; GCN-NEXT:    s_addc_u32 s14, s15, 0
; GCN-NEXT:    s_mul_i32 s5, s2, s5
; GCN-NEXT:    s_add_u32 s3, s3, s5
; GCN-NEXT:    s_addc_u32 s5, 0, s14
; GCN-NEXT:    v_add_co_u32_e32 v0, vcc, s3, v0
; GCN-NEXT:    s_cmp_lg_u64 vcc, 0
; GCN-NEXT:    s_addc_u32 s2, s2, s5
; GCN-NEXT:    v_readfirstlane_b32 s5, v0
; GCN-NEXT:    s_mul_i32 s3, s0, s2
; GCN-NEXT:    s_mul_hi_u32 s14, s0, s5
; GCN-NEXT:    s_add_i32 s3, s14, s3
; GCN-NEXT:    s_mul_i32 s1, s1, s5
; GCN-NEXT:    s_add_i32 s3, s3, s1
; GCN-NEXT:    s_mul_i32 s0, s0, s5
; GCN-NEXT:    s_mul_hi_u32 s14, s2, s0
; GCN-NEXT:    s_mul_i32 s15, s2, s0
; GCN-NEXT:    s_mul_i32 s17, s5, s3
; GCN-NEXT:    s_mul_hi_u32 s0, s5, s0
; GCN-NEXT:    s_mul_hi_u32 s16, s5, s3
; GCN-NEXT:    s_add_u32 s0, s0, s17
; GCN-NEXT:    s_addc_u32 s5, 0, s16
; GCN-NEXT:    s_add_u32 s0, s0, s15
; GCN-NEXT:    s_mul_hi_u32 s1, s2, s3
; GCN-NEXT:    s_addc_u32 s0, s5, s14
; GCN-NEXT:    s_addc_u32 s1, s1, 0
; GCN-NEXT:    s_mul_i32 s3, s2, s3
; GCN-NEXT:    s_add_u32 s0, s0, s3
; GCN-NEXT:    s_addc_u32 s1, 0, s1
; GCN-NEXT:    v_add_co_u32_e32 v0, vcc, s0, v0
; GCN-NEXT:    s_cmp_lg_u64 vcc, 0
; GCN-NEXT:    s_addc_u32 s2, s2, s1
; GCN-NEXT:    s_ashr_i32 s14, s7, 31
; GCN-NEXT:    s_add_u32 s0, s6, s14
; GCN-NEXT:    s_mov_b32 s15, s14
; GCN-NEXT:    s_addc_u32 s1, s7, s14
; GCN-NEXT:    s_xor_b64 s[16:17], s[0:1], s[14:15]
; GCN-NEXT:    v_readfirstlane_b32 s3, v0
; GCN-NEXT:    s_mul_i32 s1, s16, s2
; GCN-NEXT:    s_mul_hi_u32 s5, s16, s3
; GCN-NEXT:    s_mul_hi_u32 s0, s16, s2
; GCN-NEXT:    s_add_u32 s1, s5, s1
; GCN-NEXT:    s_addc_u32 s0, 0, s0
; GCN-NEXT:    s_mul_hi_u32 s7, s17, s3
; GCN-NEXT:    s_mul_i32 s3, s17, s3
; GCN-NEXT:    s_add_u32 s1, s1, s3
; GCN-NEXT:    s_mul_hi_u32 s5, s17, s2
; GCN-NEXT:    s_addc_u32 s0, s0, s7
; GCN-NEXT:    s_addc_u32 s1, s5, 0
; GCN-NEXT:    s_mul_i32 s2, s17, s2
; GCN-NEXT:    s_add_u32 s0, s0, s2
; GCN-NEXT:    s_addc_u32 s1, 0, s1
; GCN-NEXT:    s_mul_i32 s1, s12, s1
; GCN-NEXT:    s_mul_hi_u32 s2, s12, s0
; GCN-NEXT:    s_add_i32 s1, s2, s1
; GCN-NEXT:    s_mul_i32 s2, s13, s0
; GCN-NEXT:    s_mul_i32 s0, s12, s0
; GCN-NEXT:    s_add_i32 s5, s1, s2
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    s_sub_i32 s1, s17, s5
; GCN-NEXT:    v_sub_co_u32_e32 v0, vcc, s16, v0
; GCN-NEXT:    s_cmp_lg_u64 vcc, 0
; GCN-NEXT:    s_subb_u32 s7, s1, s13
; GCN-NEXT:    v_subrev_co_u32_e64 v1, s[0:1], s12, v0
; GCN-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GCN-NEXT:    s_subb_u32 s15, s7, 0
; GCN-NEXT:    s_cmp_ge_u32 s15, s13
; GCN-NEXT:    s_cselect_b32 s16, -1, 0
; GCN-NEXT:    v_cmp_le_u32_e64 s[2:3], s12, v1
; GCN-NEXT:    s_cmp_eq_u32 s15, s13
; GCN-NEXT:    v_cndmask_b32_e64 v2, 0, -1, s[2:3]
; GCN-NEXT:    v_mov_b32_e32 v3, s16
; GCN-NEXT:    s_cselect_b64 s[2:3], -1, 0
; GCN-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GCN-NEXT:    v_cndmask_b32_e64 v2, v3, v2, s[2:3]
; GCN-NEXT:    s_subb_u32 s2, s7, s13
; GCN-NEXT:    v_subrev_co_u32_e64 v3, s[0:1], s12, v1
; GCN-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GCN-NEXT:    s_subb_u32 s2, s2, 0
; GCN-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v1, v1, v3, s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v2, s15
; GCN-NEXT:    v_mov_b32_e32 v3, s2
; GCN-NEXT:    s_cmp_lg_u64 vcc, 0
; GCN-NEXT:    v_cndmask_b32_e64 v2, v2, v3, s[0:1]
; GCN-NEXT:    s_subb_u32 s0, s17, s5
; GCN-NEXT:    s_cmp_ge_u32 s0, s13
; GCN-NEXT:    s_cselect_b32 s1, -1, 0
; GCN-NEXT:    v_cmp_le_u32_e32 vcc, s12, v0
; GCN-NEXT:    s_cmp_eq_u32 s0, s13
; GCN-NEXT:    v_cndmask_b32_e64 v3, 0, -1, vcc
; GCN-NEXT:    v_mov_b32_e32 v4, s1
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    v_cndmask_b32_e32 v3, v4, v3, vcc
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GCN-NEXT:    v_mov_b32_e32 v4, s0
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GCN-NEXT:    v_xor_b32_e32 v0, s14, v0
; GCN-NEXT:    v_xor_b32_e32 v1, s14, v2
; GCN-NEXT:    v_mov_b32_e32 v2, s14
; GCN-NEXT:    v_subrev_co_u32_e32 v0, vcc, s14, v0
; GCN-NEXT:    v_subb_co_u32_e32 v1, vcc, v1, v2, vcc
; GCN-NEXT:    s_cbranch_execnz .LBB8_3
; GCN-NEXT:  .LBB8_2:
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, s4
; GCN-NEXT:    s_sub_i32 s0, 0, s4
; GCN-NEXT:    s_mov_b32 s1, 0
; GCN-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; GCN-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; GCN-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GCN-NEXT:    v_readfirstlane_b32 s2, v0
; GCN-NEXT:    s_mul_i32 s0, s0, s2
; GCN-NEXT:    s_mul_hi_u32 s0, s2, s0
; GCN-NEXT:    s_add_i32 s2, s2, s0
; GCN-NEXT:    s_mul_hi_u32 s0, s6, s2
; GCN-NEXT:    s_mul_i32 s0, s0, s4
; GCN-NEXT:    s_sub_i32 s0, s6, s0
; GCN-NEXT:    s_sub_i32 s2, s0, s4
; GCN-NEXT:    s_cmp_ge_u32 s0, s4
; GCN-NEXT:    s_cselect_b32 s0, s2, s0
; GCN-NEXT:    s_sub_i32 s2, s0, s4
; GCN-NEXT:    s_cmp_ge_u32 s0, s4
; GCN-NEXT:    s_cselect_b32 s0, s2, s0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:  .LBB8_3:
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    global_store_dwordx2 v2, v[0:1], s[8:9]
; GCN-NEXT:    s_endpgm
; GCN-NEXT:  .LBB8_4:
; GCN-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GCN-NEXT:    s_branch .LBB8_2
;
; TAHITI-LABEL: srem_i64:
; TAHITI:       ; %bb.0:
; TAHITI-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x9
; TAHITI-NEXT:    s_mov_b32 s3, 0xf000
; TAHITI-NEXT:    s_mov_b32 s2, -1
; TAHITI-NEXT:    v_mov_b32_e32 v4, 0
; TAHITI-NEXT:    s_waitcnt lgkmcnt(0)
; TAHITI-NEXT:    s_mov_b32 s0, s6
; TAHITI-NEXT:    s_mov_b32 s1, s7
; TAHITI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], 0
; TAHITI-NEXT:    s_waitcnt vmcnt(0)
; TAHITI-NEXT:    v_or_b32_e32 v5, v1, v3
; TAHITI-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; TAHITI-NEXT:    s_cbranch_vccz .LBB8_4
; TAHITI-NEXT:  ; %bb.1:
; TAHITI-NEXT:    v_ashrrev_i32_e32 v5, 31, v3
; TAHITI-NEXT:    v_add_i32_e32 v4, vcc, v2, v5
; TAHITI-NEXT:    v_addc_u32_e32 v3, vcc, v3, v5, vcc
; TAHITI-NEXT:    v_xor_b32_e32 v4, v4, v5
; TAHITI-NEXT:    v_xor_b32_e32 v3, v3, v5
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v5, v4
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v6, v3
; TAHITI-NEXT:    v_sub_i32_e32 v7, vcc, 0, v4
; TAHITI-NEXT:    v_subb_u32_e32 v8, vcc, 0, v3, vcc
; TAHITI-NEXT:    v_madmk_f32 v5, v6, 0x4f800000, v5
; TAHITI-NEXT:    v_rcp_f32_e32 v5, v5
; TAHITI-NEXT:    v_mul_f32_e32 v5, 0x5f7ffffc, v5
; TAHITI-NEXT:    v_mul_f32_e32 v6, 0x2f800000, v5
; TAHITI-NEXT:    v_trunc_f32_e32 v6, v6
; TAHITI-NEXT:    v_madmk_f32 v5, v6, 0xcf800000, v5
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v6, v6
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v5, v5
; TAHITI-NEXT:    v_mul_lo_u32 v10, v7, v6
; TAHITI-NEXT:    v_mul_hi_u32 v9, v7, v5
; TAHITI-NEXT:    v_mul_lo_u32 v11, v8, v5
; TAHITI-NEXT:    v_add_i32_e32 v9, vcc, v10, v9
; TAHITI-NEXT:    v_mul_lo_u32 v10, v7, v5
; TAHITI-NEXT:    v_add_i32_e32 v9, vcc, v9, v11
; TAHITI-NEXT:    v_mul_lo_u32 v11, v5, v9
; TAHITI-NEXT:    v_mul_hi_u32 v12, v5, v10
; TAHITI-NEXT:    v_mul_hi_u32 v13, v5, v9
; TAHITI-NEXT:    v_mul_hi_u32 v14, v6, v9
; TAHITI-NEXT:    v_mul_lo_u32 v9, v6, v9
; TAHITI-NEXT:    v_add_i32_e32 v11, vcc, v12, v11
; TAHITI-NEXT:    v_addc_u32_e32 v12, vcc, 0, v13, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v13, v6, v10
; TAHITI-NEXT:    v_mul_hi_u32 v10, v6, v10
; TAHITI-NEXT:    v_add_i32_e32 v11, vcc, v11, v13
; TAHITI-NEXT:    v_addc_u32_e32 v10, vcc, v12, v10, vcc
; TAHITI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v14, vcc
; TAHITI-NEXT:    v_add_i32_e32 v9, vcc, v10, v9
; TAHITI-NEXT:    v_addc_u32_e32 v10, vcc, 0, v11, vcc
; TAHITI-NEXT:    v_add_i32_e32 v5, vcc, v5, v9
; TAHITI-NEXT:    v_addc_u32_e32 v6, vcc, v6, v10, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v9, v7, v6
; TAHITI-NEXT:    v_mul_hi_u32 v10, v7, v5
; TAHITI-NEXT:    v_mul_lo_u32 v8, v8, v5
; TAHITI-NEXT:    v_mul_lo_u32 v7, v7, v5
; TAHITI-NEXT:    v_add_i32_e32 v9, vcc, v9, v10
; TAHITI-NEXT:    v_add_i32_e32 v8, vcc, v9, v8
; TAHITI-NEXT:    v_mul_lo_u32 v11, v5, v8
; TAHITI-NEXT:    v_mul_hi_u32 v12, v5, v7
; TAHITI-NEXT:    v_mul_hi_u32 v13, v5, v8
; TAHITI-NEXT:    v_mul_hi_u32 v10, v6, v7
; TAHITI-NEXT:    v_mul_lo_u32 v7, v6, v7
; TAHITI-NEXT:    v_mul_hi_u32 v9, v6, v8
; TAHITI-NEXT:    v_add_i32_e32 v11, vcc, v12, v11
; TAHITI-NEXT:    v_addc_u32_e32 v12, vcc, 0, v13, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v8, v6, v8
; TAHITI-NEXT:    v_add_i32_e32 v7, vcc, v11, v7
; TAHITI-NEXT:    v_addc_u32_e32 v7, vcc, v12, v10, vcc
; TAHITI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; TAHITI-NEXT:    v_add_i32_e32 v7, vcc, v7, v8
; TAHITI-NEXT:    v_addc_u32_e32 v8, vcc, 0, v9, vcc
; TAHITI-NEXT:    v_add_i32_e32 v5, vcc, v5, v7
; TAHITI-NEXT:    v_addc_u32_e32 v6, vcc, v6, v8, vcc
; TAHITI-NEXT:    v_ashrrev_i32_e32 v7, 31, v1
; TAHITI-NEXT:    v_add_i32_e32 v8, vcc, v0, v7
; TAHITI-NEXT:    v_xor_b32_e32 v8, v8, v7
; TAHITI-NEXT:    v_mul_lo_u32 v9, v8, v6
; TAHITI-NEXT:    v_mul_hi_u32 v10, v8, v5
; TAHITI-NEXT:    v_mul_hi_u32 v11, v8, v6
; TAHITI-NEXT:    v_addc_u32_e32 v1, vcc, v1, v7, vcc
; TAHITI-NEXT:    v_xor_b32_e32 v1, v1, v7
; TAHITI-NEXT:    v_add_i32_e32 v9, vcc, v10, v9
; TAHITI-NEXT:    v_addc_u32_e32 v10, vcc, 0, v11, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v11, v1, v5
; TAHITI-NEXT:    v_mul_hi_u32 v5, v1, v5
; TAHITI-NEXT:    v_mul_hi_u32 v12, v1, v6
; TAHITI-NEXT:    v_mul_lo_u32 v6, v1, v6
; TAHITI-NEXT:    v_add_i32_e32 v9, vcc, v9, v11
; TAHITI-NEXT:    v_addc_u32_e32 v5, vcc, v10, v5, vcc
; TAHITI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v12, vcc
; TAHITI-NEXT:    v_add_i32_e32 v5, vcc, v5, v6
; TAHITI-NEXT:    v_addc_u32_e32 v6, vcc, 0, v9, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v6, v4, v6
; TAHITI-NEXT:    v_mul_hi_u32 v9, v4, v5
; TAHITI-NEXT:    v_mul_lo_u32 v10, v3, v5
; TAHITI-NEXT:    v_mul_lo_u32 v5, v4, v5
; TAHITI-NEXT:    v_add_i32_e32 v6, vcc, v6, v9
; TAHITI-NEXT:    v_add_i32_e32 v6, vcc, v10, v6
; TAHITI-NEXT:    v_sub_i32_e32 v9, vcc, v1, v6
; TAHITI-NEXT:    v_sub_i32_e32 v5, vcc, v8, v5
; TAHITI-NEXT:    v_subb_u32_e64 v8, s[0:1], v9, v3, vcc
; TAHITI-NEXT:    v_sub_i32_e64 v9, s[0:1], v5, v4
; TAHITI-NEXT:    v_subbrev_u32_e64 v10, s[2:3], 0, v8, s[0:1]
; TAHITI-NEXT:    v_cmp_ge_u32_e64 s[2:3], v10, v3
; TAHITI-NEXT:    v_cndmask_b32_e64 v11, 0, -1, s[2:3]
; TAHITI-NEXT:    v_cmp_ge_u32_e64 s[2:3], v9, v4
; TAHITI-NEXT:    v_subb_u32_e32 v1, vcc, v1, v6, vcc
; TAHITI-NEXT:    v_cndmask_b32_e64 v12, 0, -1, s[2:3]
; TAHITI-NEXT:    v_cmp_eq_u32_e64 s[2:3], v10, v3
; TAHITI-NEXT:    v_subb_u32_e64 v8, s[0:1], v8, v3, s[0:1]
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v1, v3
; TAHITI-NEXT:    v_cndmask_b32_e64 v11, v11, v12, s[2:3]
; TAHITI-NEXT:    v_sub_i32_e64 v12, s[0:1], v9, v4
; TAHITI-NEXT:    v_cndmask_b32_e64 v6, 0, -1, vcc
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v5, v4
; TAHITI-NEXT:    v_subbrev_u32_e64 v8, s[0:1], 0, v8, s[0:1]
; TAHITI-NEXT:    v_cndmask_b32_e64 v4, 0, -1, vcc
; TAHITI-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v3
; TAHITI-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v11
; TAHITI-NEXT:    v_cndmask_b32_e32 v3, v6, v4, vcc
; TAHITI-NEXT:    v_cndmask_b32_e64 v9, v9, v12, s[0:1]
; TAHITI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; TAHITI-NEXT:    v_cndmask_b32_e64 v8, v10, v8, s[0:1]
; TAHITI-NEXT:    v_cndmask_b32_e32 v3, v5, v9, vcc
; TAHITI-NEXT:    v_cndmask_b32_e32 v1, v1, v8, vcc
; TAHITI-NEXT:    v_xor_b32_e32 v3, v3, v7
; TAHITI-NEXT:    v_xor_b32_e32 v1, v1, v7
; TAHITI-NEXT:    v_sub_i32_e32 v3, vcc, v3, v7
; TAHITI-NEXT:    v_subb_u32_e32 v4, vcc, v1, v7, vcc
; TAHITI-NEXT:    s_cbranch_execnz .LBB8_3
; TAHITI-NEXT:  .LBB8_2:
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v1, v2
; TAHITI-NEXT:    v_sub_i32_e32 v3, vcc, 0, v2
; TAHITI-NEXT:    v_mov_b32_e32 v4, 0
; TAHITI-NEXT:    v_rcp_iflag_f32_e32 v1, v1
; TAHITI-NEXT:    v_mul_f32_e32 v1, 0x4f7ffffe, v1
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v1, v1
; TAHITI-NEXT:    v_mul_lo_u32 v3, v3, v1
; TAHITI-NEXT:    v_mul_hi_u32 v3, v1, v3
; TAHITI-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; TAHITI-NEXT:    v_mul_hi_u32 v1, v0, v1
; TAHITI-NEXT:    v_mul_lo_u32 v1, v1, v2
; TAHITI-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; TAHITI-NEXT:    v_subrev_i32_e32 v1, vcc, v2, v0
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v2
; TAHITI-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; TAHITI-NEXT:    v_sub_i32_e32 v1, vcc, v0, v2
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v2
; TAHITI-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; TAHITI-NEXT:  .LBB8_3:
; TAHITI-NEXT:    s_mov_b32 s7, 0xf000
; TAHITI-NEXT:    s_mov_b32 s6, -1
; TAHITI-NEXT:    buffer_store_dwordx2 v[3:4], off, s[4:7], 0
; TAHITI-NEXT:    s_endpgm
; TAHITI-NEXT:  .LBB8_4:
; TAHITI-NEXT:    ; implicit-def: $vgpr3_vgpr4
; TAHITI-NEXT:    s_branch .LBB8_2
;
; TONGA-LABEL: srem_i64:
; TONGA:       ; %bb.0:
; TONGA-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x24
; TONGA-NEXT:    v_mov_b32_e32 v4, 0
; TONGA-NEXT:    s_waitcnt lgkmcnt(0)
; TONGA-NEXT:    v_mov_b32_e32 v0, s6
; TONGA-NEXT:    v_mov_b32_e32 v1, s7
; TONGA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; TONGA-NEXT:    s_waitcnt vmcnt(0)
; TONGA-NEXT:    v_or_b32_e32 v5, v1, v3
; TONGA-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; TONGA-NEXT:    s_cbranch_vccz .LBB8_4
; TONGA-NEXT:  ; %bb.1:
; TONGA-NEXT:    v_ashrrev_i32_e32 v4, 31, v3
; TONGA-NEXT:    v_add_u32_e32 v5, vcc, v2, v4
; TONGA-NEXT:    v_addc_u32_e32 v3, vcc, v3, v4, vcc
; TONGA-NEXT:    v_xor_b32_e32 v9, v5, v4
; TONGA-NEXT:    v_xor_b32_e32 v10, v3, v4
; TONGA-NEXT:    v_cvt_f32_u32_e32 v3, v9
; TONGA-NEXT:    v_cvt_f32_u32_e32 v4, v10
; TONGA-NEXT:    v_sub_u32_e32 v11, vcc, 0, v9
; TONGA-NEXT:    v_subb_u32_e32 v12, vcc, 0, v10, vcc
; TONGA-NEXT:    v_madmk_f32 v3, v4, 0x4f800000, v3
; TONGA-NEXT:    v_rcp_f32_e32 v3, v3
; TONGA-NEXT:    v_mul_f32_e32 v3, 0x5f7ffffc, v3
; TONGA-NEXT:    v_mul_f32_e32 v4, 0x2f800000, v3
; TONGA-NEXT:    v_trunc_f32_e32 v4, v4
; TONGA-NEXT:    v_madmk_f32 v3, v4, 0xcf800000, v3
; TONGA-NEXT:    v_cvt_u32_f32_e32 v7, v4
; TONGA-NEXT:    v_cvt_u32_f32_e32 v8, v3
; TONGA-NEXT:    v_mul_lo_u32 v5, v11, v7
; TONGA-NEXT:    v_mad_u64_u32 v[3:4], s[0:1], v11, v8, 0
; TONGA-NEXT:    v_mul_lo_u32 v6, v12, v8
; TONGA-NEXT:    v_add_u32_e32 v4, vcc, v4, v5
; TONGA-NEXT:    v_add_u32_e32 v6, vcc, v4, v6
; TONGA-NEXT:    v_mad_u64_u32 v[4:5], s[0:1], v8, v6, 0
; TONGA-NEXT:    v_mul_hi_u32 v13, v8, v3
; TONGA-NEXT:    v_add_u32_e32 v13, vcc, v13, v4
; TONGA-NEXT:    v_mad_u64_u32 v[3:4], s[0:1], v7, v3, 0
; TONGA-NEXT:    v_addc_u32_e32 v14, vcc, 0, v5, vcc
; TONGA-NEXT:    v_mad_u64_u32 v[5:6], s[0:1], v7, v6, 0
; TONGA-NEXT:    v_add_u32_e32 v3, vcc, v13, v3
; TONGA-NEXT:    v_addc_u32_e32 v3, vcc, v14, v4, vcc
; TONGA-NEXT:    v_addc_u32_e32 v4, vcc, 0, v6, vcc
; TONGA-NEXT:    v_add_u32_e32 v3, vcc, v3, v5
; TONGA-NEXT:    v_addc_u32_e32 v4, vcc, 0, v4, vcc
; TONGA-NEXT:    v_add_u32_e32 v13, vcc, v8, v3
; TONGA-NEXT:    v_addc_u32_e32 v14, vcc, v7, v4, vcc
; TONGA-NEXT:    v_mad_u64_u32 v[3:4], s[0:1], v11, v13, 0
; TONGA-NEXT:    v_mul_lo_u32 v7, v11, v14
; TONGA-NEXT:    v_mul_lo_u32 v8, v12, v13
; TONGA-NEXT:    v_mul_hi_u32 v11, v13, v3
; TONGA-NEXT:    v_mad_u64_u32 v[5:6], s[0:1], v14, v3, 0
; TONGA-NEXT:    v_add_u32_e32 v4, vcc, v7, v4
; TONGA-NEXT:    v_add_u32_e32 v4, vcc, v4, v8
; TONGA-NEXT:    v_mad_u64_u32 v[7:8], s[0:1], v13, v4, 0
; TONGA-NEXT:    v_mad_u64_u32 v[3:4], s[0:1], v14, v4, 0
; TONGA-NEXT:    v_add_u32_e32 v7, vcc, v11, v7
; TONGA-NEXT:    v_addc_u32_e32 v8, vcc, 0, v8, vcc
; TONGA-NEXT:    v_add_u32_e32 v5, vcc, v7, v5
; TONGA-NEXT:    v_addc_u32_e32 v5, vcc, v8, v6, vcc
; TONGA-NEXT:    v_addc_u32_e32 v4, vcc, 0, v4, vcc
; TONGA-NEXT:    v_add_u32_e32 v3, vcc, v5, v3
; TONGA-NEXT:    v_addc_u32_e32 v4, vcc, 0, v4, vcc
; TONGA-NEXT:    v_add_u32_e32 v5, vcc, v13, v3
; TONGA-NEXT:    v_addc_u32_e32 v6, vcc, v14, v4, vcc
; TONGA-NEXT:    v_ashrrev_i32_e32 v7, 31, v1
; TONGA-NEXT:    v_add_u32_e32 v3, vcc, v0, v7
; TONGA-NEXT:    v_xor_b32_e32 v8, v3, v7
; TONGA-NEXT:    v_mad_u64_u32 v[3:4], s[0:1], v8, v6, 0
; TONGA-NEXT:    v_mul_hi_u32 v11, v8, v5
; TONGA-NEXT:    v_addc_u32_e32 v1, vcc, v1, v7, vcc
; TONGA-NEXT:    v_xor_b32_e32 v1, v1, v7
; TONGA-NEXT:    v_add_u32_e32 v11, vcc, v11, v3
; TONGA-NEXT:    v_addc_u32_e32 v12, vcc, 0, v4, vcc
; TONGA-NEXT:    v_mad_u64_u32 v[3:4], s[0:1], v1, v5, 0
; TONGA-NEXT:    v_mad_u64_u32 v[5:6], s[0:1], v1, v6, 0
; TONGA-NEXT:    v_add_u32_e32 v3, vcc, v11, v3
; TONGA-NEXT:    v_addc_u32_e32 v3, vcc, v12, v4, vcc
; TONGA-NEXT:    v_addc_u32_e32 v4, vcc, 0, v6, vcc
; TONGA-NEXT:    v_add_u32_e32 v5, vcc, v3, v5
; TONGA-NEXT:    v_addc_u32_e32 v3, vcc, 0, v4, vcc
; TONGA-NEXT:    v_mul_lo_u32 v6, v9, v3
; TONGA-NEXT:    v_mad_u64_u32 v[3:4], s[0:1], v9, v5, 0
; TONGA-NEXT:    v_mul_lo_u32 v5, v10, v5
; TONGA-NEXT:    v_add_u32_e32 v4, vcc, v6, v4
; TONGA-NEXT:    v_add_u32_e32 v4, vcc, v5, v4
; TONGA-NEXT:    v_sub_u32_e32 v5, vcc, v1, v4
; TONGA-NEXT:    v_sub_u32_e32 v3, vcc, v8, v3
; TONGA-NEXT:    v_subb_u32_e64 v5, s[0:1], v5, v10, vcc
; TONGA-NEXT:    v_sub_u32_e64 v6, s[0:1], v3, v9
; TONGA-NEXT:    v_subbrev_u32_e64 v8, s[2:3], 0, v5, s[0:1]
; TONGA-NEXT:    v_cmp_ge_u32_e64 s[2:3], v8, v10
; TONGA-NEXT:    v_cndmask_b32_e64 v11, 0, -1, s[2:3]
; TONGA-NEXT:    v_cmp_ge_u32_e64 s[2:3], v6, v9
; TONGA-NEXT:    v_cndmask_b32_e64 v12, 0, -1, s[2:3]
; TONGA-NEXT:    v_cmp_eq_u32_e64 s[2:3], v8, v10
; TONGA-NEXT:    v_subb_u32_e64 v5, s[0:1], v5, v10, s[0:1]
; TONGA-NEXT:    v_cndmask_b32_e64 v11, v11, v12, s[2:3]
; TONGA-NEXT:    v_sub_u32_e64 v12, s[0:1], v6, v9
; TONGA-NEXT:    v_subb_u32_e32 v1, vcc, v1, v4, vcc
; TONGA-NEXT:    v_subbrev_u32_e64 v5, s[0:1], 0, v5, s[0:1]
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v1, v10
; TONGA-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v11
; TONGA-NEXT:    v_cndmask_b32_e64 v4, 0, -1, vcc
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v3, v9
; TONGA-NEXT:    v_cndmask_b32_e64 v5, v8, v5, s[0:1]
; TONGA-NEXT:    v_cndmask_b32_e64 v8, 0, -1, vcc
; TONGA-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v10
; TONGA-NEXT:    v_cndmask_b32_e32 v4, v4, v8, vcc
; TONGA-NEXT:    v_cndmask_b32_e64 v6, v6, v12, s[0:1]
; TONGA-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; TONGA-NEXT:    v_cndmask_b32_e32 v3, v3, v6, vcc
; TONGA-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; TONGA-NEXT:    v_xor_b32_e32 v3, v3, v7
; TONGA-NEXT:    v_xor_b32_e32 v1, v1, v7
; TONGA-NEXT:    v_sub_u32_e32 v3, vcc, v3, v7
; TONGA-NEXT:    v_subb_u32_e32 v4, vcc, v1, v7, vcc
; TONGA-NEXT:    s_cbranch_execnz .LBB8_3
; TONGA-NEXT:  .LBB8_2:
; TONGA-NEXT:    v_cvt_f32_u32_e32 v1, v2
; TONGA-NEXT:    v_sub_u32_e32 v3, vcc, 0, v2
; TONGA-NEXT:    v_mov_b32_e32 v4, 0
; TONGA-NEXT:    v_rcp_iflag_f32_e32 v1, v1
; TONGA-NEXT:    v_mul_f32_e32 v1, 0x4f7ffffe, v1
; TONGA-NEXT:    v_cvt_u32_f32_e32 v1, v1
; TONGA-NEXT:    v_mul_lo_u32 v3, v3, v1
; TONGA-NEXT:    v_mul_hi_u32 v3, v1, v3
; TONGA-NEXT:    v_add_u32_e32 v1, vcc, v1, v3
; TONGA-NEXT:    v_mul_hi_u32 v1, v0, v1
; TONGA-NEXT:    v_mul_lo_u32 v1, v1, v2
; TONGA-NEXT:    v_sub_u32_e32 v0, vcc, v0, v1
; TONGA-NEXT:    v_subrev_u32_e32 v1, vcc, v2, v0
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v2
; TONGA-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; TONGA-NEXT:    v_sub_u32_e32 v1, vcc, v0, v2
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v2
; TONGA-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; TONGA-NEXT:  .LBB8_3:
; TONGA-NEXT:    v_mov_b32_e32 v0, s4
; TONGA-NEXT:    v_mov_b32_e32 v1, s5
; TONGA-NEXT:    flat_store_dwordx2 v[0:1], v[3:4]
; TONGA-NEXT:    s_endpgm
; TONGA-NEXT:  .LBB8_4:
; TONGA-NEXT:    ; implicit-def: $vgpr3_vgpr4
; TONGA-NEXT:    s_branch .LBB8_2
;
; EG-LABEL: srem_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @14, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @12
; EG-NEXT:    ALU_PUSH_BEFORE 4, @15, KC0[], KC1[]
; EG-NEXT:    JUMP @9 POP:1
; EG-NEXT:    ALU 114, @20, KC0[], KC1[]
; EG-NEXT:    ALU 115, @135, KC0[], KC1[]
; EG-NEXT:    ALU 115, @251, KC0[], KC1[]
; EG-NEXT:    ALU 115, @367, KC0[], KC1[]
; EG-NEXT:    ALU_POP_AFTER 82, @483, KC0[], KC1[]
; EG-NEXT:    ALU 20, @566, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.XY, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 12:
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 15:
; EG-NEXT:     OR_INT T2.W, T0.Y, T0.W,
; EG-NEXT:     MOV * T1.W, literal.x,
; EG-NEXT:    1(1.401298e-45), 0(0.000000e+00)
; EG-NEXT:     SETNE_INT * T2.W, PV.W, 0.0,
; EG-NEXT:     PRED_SETNE_INT * ExecMask,PredicateBit (MASKED), PV.W, 0.0,
; EG-NEXT:    ALU clause starting at 20:
; EG-NEXT:     ASHR * T3.W, T0.W, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T1.W, T0.Z, PV.W,
; EG-NEXT:     XOR_INT * T2.W, PV.W, T3.W,
; EG-NEXT:     SUB_INT T1.Z, 0.0, PV.W,
; EG-NEXT:     ASHR T1.W, T0.Y, literal.x,
; EG-NEXT:     RECIP_UINT * T1.X, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ADD_INT T2.Z, T0.Y, PV.W,
; EG-NEXT:     ADDC_UINT T4.W, T0.X, PV.W,
; EG-NEXT:     MULLO_INT * T0.Y, PV.Z, PS,
; EG-NEXT:     ADD_INT T4.W, PV.Z, PV.W,
; EG-NEXT:     MULHI * T0.Y, T1.X, PS,
; EG-NEXT:     ADD_INT T5.W, T1.X, PS,
; EG-NEXT:     XOR_INT * T4.W, PV.W, T1.W,
; EG-NEXT:     MULHI * T0.Y, PS, PV.W,
; EG-NEXT:     MULLO_INT * T0.Y, PS, T2.W,
; EG-NEXT:     SUB_INT * T5.W, T4.W, PS,
; EG-NEXT:     SETGE_UINT T6.W, PV.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, PV.W, T2.W,
; EG-NEXT:     CNDE_INT T1.Z, PV.W, T5.W, PS, BS:VEC_021/SCL_122
; EG-NEXT:     ADD_INT T0.W, T0.W, T3.W,
; EG-NEXT:     ADDC_UINT * T5.W, T0.Z, T3.W,
; EG-NEXT:     ADD_INT T2.Z, PV.W, PS,
; EG-NEXT:     SETGE_UINT T0.W, PV.Z, T2.W,
; EG-NEXT:     SUB_INT * T5.W, PV.Z, T2.W,
; EG-NEXT:     ADD_INT T3.Z, T0.X, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T5.W, PV.W, T1.Z, PS,
; EG-NEXT:     XOR_INT * T0.W, PV.Z, T3.W,
; EG-NEXT:     CNDE_INT T4.W, PS, PV.W, T4.W,
; EG-NEXT:     XOR_INT * T3.W, PV.Z, T1.W,
; EG-NEXT:     BIT_ALIGN_INT T5.W, PV.W, PS, literal.x,
; EG-NEXT:     LSHR * T4.W, PV.W, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T1.Z, PS, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T6.W, PS, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T2.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.Z, PV.W, PS,
; EG-NEXT:     SUB_INT * T1.Z, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T6.W, T4.W, T0.W,
; EG-NEXT:     SUBB_UINT * T7.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT T6.W, T6.W, PV.W,
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    30(4.203895e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    29(4.063766e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    28(3.923636e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    27(3.783506e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    26(3.643376e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT * T1.Z, PS, T2.W,
; EG-NEXT:    ALU clause starting at 135:
; EG-NEXT:     SETE_INT T6.W, T4.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, T4.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, T1.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    25(3.503246e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    24(3.363116e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    23(3.222986e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    22(3.082857e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    21(2.942727e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    20(2.802597e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    19(2.662467e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT * T1.Z, T5.W, T2.W,
; EG-NEXT:    ALU clause starting at 251:
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    18(2.522337e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    17(2.382207e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    15(2.101948e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    14(1.961818e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    13(1.821688e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    12(1.681558e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:    ALU clause starting at 367:
; EG-NEXT:     LSHL T1.Z, T5.W, 1,
; EG-NEXT:     BFE_UINT * T7.W, T3.W, literal.x, 1, BS:VEC_120/SCL_212
; EG-NEXT:    11(1.541428e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T6.W,
; EG-NEXT:     BIT_ALIGN_INT T4.W, PV.W, T5.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT * T5.W, T1.Z, T7.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    10(1.401298e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    9(1.261169e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    8(1.121039e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    7(9.809089e-45), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    6(8.407791e-45), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    5(7.006492e-45), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    4(5.605194e-45), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 483:
; EG-NEXT:     BIT_ALIGN_INT T4.W, T4.W, T5.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT * T5.W, T1.Z, T7.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     BFE_UINT T7.W, T3.W, 1, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T5.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.Z, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.W, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT * T7.W, PV.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T5.W, T2.W,
; EG-NEXT:     SUBB_UINT * T6.W, T5.W, T2.W,
; EG-NEXT:     SUB_INT * T7.W, T4.W, T0.W,
; EG-NEXT:     SUB_INT T6.W, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T5.W, T0.Y, T5.W, T1.Z,
; EG-NEXT:     LSHL T1.Z, PS, 1,
; EG-NEXT:     AND_INT T3.W, T3.W, 1,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, PV.W,
; EG-NEXT:     BIT_ALIGN_INT T4.W, PS, T5.W, literal.x,
; EG-NEXT:     OR_INT * T3.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.X, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T0.Y, PV.W, T0.W,
; EG-NEXT:     SETGE_UINT T1.Z, PV.W, T0.W,
; EG-NEXT:     SUBB_UINT T5.W, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT * T0.W, PV.W, T0.W,
; EG-NEXT:     SUB_INT T2.Z, T3.W, T2.W,
; EG-NEXT:     SUB_INT T0.W, PS, PV.W,
; EG-NEXT:     CNDE_INT * T2.W, PV.Y, PV.Z, PV.X,
; EG-NEXT:     CNDE_INT T0.W, PS, T4.W, PV.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T2.W, PS, T3.W, PV.Z,
; EG-NEXT:     XOR_INT T2.W, PS, T1.W,
; EG-NEXT:     XOR_INT * T0.W, PV.W, T1.W,
; EG-NEXT:     SUB_INT T0.W, PS, T1.W,
; EG-NEXT:     SUBB_UINT * T3.W, PV.W, T1.W,
; EG-NEXT:     SUB_INT * T1.Y, PV.W, PS,
; EG-NEXT:     SUB_INT T1.X, T2.W, T1.W,
; EG-NEXT:     MOV * T1.W, literal.x,
; EG-NEXT:    0(0.000000e+00), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 566:
; EG-NEXT:     MOV T0.W, KC0[2].Y,
; EG-NEXT:     SETE_INT * T1.W, T1.W, 0.0,
; EG-NEXT:     PRED_SETNE_INT * Pred,PredicateBit (MASKED), PS, 0.0,
; EG-NEXT:     SUB_INT T1.W, 0.0, T0.Z, Pred_sel_zero
; EG-NEXT:     RECIP_UINT * T0.Y, T0.Z, Pred_sel_zero
; EG-NEXT:     MULLO_INT * T1.X, T1.W, T0.Y, Pred_sel_zero
; EG-NEXT:     MULHI * T1.X, T0.Y, T1.X, Pred_sel_zero
; EG-NEXT:     ADD_INT * T1.W, T0.Y, T1.X, Pred_sel_zero
; EG-NEXT:     MULHI * T0.Y, T0.X, T1.W, Pred_sel_zero
; EG-NEXT:     MULLO_INT * T0.Y, T0.Y, T0.Z, Pred_sel_zero
; EG-NEXT:     SUB_INT * T1.W, T0.X, T0.Y, Pred_sel_zero
; EG-NEXT:     SETGE_UINT T2.W, T1.W, T0.Z, Pred_sel_zero
; EG-NEXT:     SUB_INT * T3.W, T1.W, T0.Z, Pred_sel_zero
; EG-NEXT:     CNDE_INT * T1.W, T2.W, T1.W, T3.W, Pred_sel_zero
; EG-NEXT:     SETGE_UINT T2.W, T1.W, T0.Z, Pred_sel_zero
; EG-NEXT:     SUB_INT * T3.W, T1.W, T0.Z, Pred_sel_zero
; EG-NEXT:     CNDE_INT T1.X, T2.W, T1.W, T3.W, Pred_sel_zero
; EG-NEXT:     MOV * T1.Y, literal.x, Pred_sel_zero
; EG-NEXT:    0(0.000000e+00), 0(0.000000e+00)
; EG-NEXT:     LSHR * T0.X, T0.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %den_ptr = getelementptr i64, ptr addrspace(1) %in, i64 1
  %num = load i64, ptr addrspace(1) %in
  %den = load i64, ptr addrspace(1) %den_ptr
  %result = srem i64 %num, %den
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @srem_i64_4(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; GCN-LABEL: srem_i64_4:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    global_load_dwordx2 v[0:1], v2, s[2:3]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_ashrrev_i32_e32 v3, 31, v1
; GCN-NEXT:    v_lshrrev_b32_e32 v3, 30, v3
; GCN-NEXT:    v_add_co_u32_e32 v3, vcc, v0, v3
; GCN-NEXT:    v_addc_co_u32_e32 v4, vcc, 0, v1, vcc
; GCN-NEXT:    v_and_b32_e32 v3, -4, v3
; GCN-NEXT:    v_sub_co_u32_e32 v0, vcc, v0, v3
; GCN-NEXT:    v_subb_co_u32_e32 v1, vcc, v1, v4, vcc
; GCN-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GCN-NEXT:    s_endpgm
;
; TAHITI-LABEL: srem_i64_4:
; TAHITI:       ; %bb.0:
; TAHITI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; TAHITI-NEXT:    s_mov_b32 s7, 0xf000
; TAHITI-NEXT:    s_mov_b32 s6, -1
; TAHITI-NEXT:    s_mov_b32 s10, s6
; TAHITI-NEXT:    s_mov_b32 s11, s7
; TAHITI-NEXT:    s_waitcnt lgkmcnt(0)
; TAHITI-NEXT:    s_mov_b32 s8, s2
; TAHITI-NEXT:    s_mov_b32 s9, s3
; TAHITI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; TAHITI-NEXT:    s_mov_b32 s4, s0
; TAHITI-NEXT:    s_mov_b32 s5, s1
; TAHITI-NEXT:    s_waitcnt vmcnt(0)
; TAHITI-NEXT:    v_ashrrev_i32_e32 v2, 31, v1
; TAHITI-NEXT:    v_lshrrev_b32_e32 v2, 30, v2
; TAHITI-NEXT:    v_add_i32_e32 v2, vcc, v0, v2
; TAHITI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; TAHITI-NEXT:    v_and_b32_e32 v2, -4, v2
; TAHITI-NEXT:    v_sub_i32_e32 v0, vcc, v0, v2
; TAHITI-NEXT:    v_subb_u32_e32 v1, vcc, v1, v3, vcc
; TAHITI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; TAHITI-NEXT:    s_endpgm
;
; TONGA-LABEL: srem_i64_4:
; TONGA:       ; %bb.0:
; TONGA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; TONGA-NEXT:    s_waitcnt lgkmcnt(0)
; TONGA-NEXT:    v_mov_b32_e32 v0, s2
; TONGA-NEXT:    v_mov_b32_e32 v1, s3
; TONGA-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; TONGA-NEXT:    v_mov_b32_e32 v2, s0
; TONGA-NEXT:    v_mov_b32_e32 v3, s1
; TONGA-NEXT:    s_waitcnt vmcnt(0)
; TONGA-NEXT:    v_ashrrev_i32_e32 v4, 31, v1
; TONGA-NEXT:    v_lshrrev_b32_e32 v4, 30, v4
; TONGA-NEXT:    v_add_u32_e32 v4, vcc, v0, v4
; TONGA-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; TONGA-NEXT:    v_and_b32_e32 v4, -4, v4
; TONGA-NEXT:    v_sub_u32_e32 v0, vcc, v0, v4
; TONGA-NEXT:    v_subb_u32_e32 v1, vcc, v1, v5, vcc
; TONGA-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; TONGA-NEXT:    s_endpgm
;
; EG-LABEL: srem_i64_4:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 13, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_64 T0.XY, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     ASHR * T0.W, T0.Y, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR * T0.W, PV.W, literal.x,
; EG-NEXT:    30(4.203895e-44), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T1.W, T0.X, PV.W,
; EG-NEXT:     AND_INT T1.W, PV.W, literal.x,
; EG-NEXT:     ADDC_UINT * T0.W, T0.X, T0.W,
; EG-NEXT:    -4(nan), 0(0.000000e+00)
; EG-NEXT:     BFE_INT T0.W, PS, 0.0, 1,
; EG-NEXT:     SUBB_UINT * T2.W, T0.X, PV.W,
; EG-NEXT:     SUB_INT * T0.Y, PV.W, PS,
; EG-NEXT:     SUB_INT T0.X, T0.X, T1.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %num = load i64, ptr addrspace(1) %in
  %result = srem i64 %num, 4
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @srem_v2i64(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; GCN-LABEL: srem_v2i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v8, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    global_load_dwordx4 v[0:3], v8, s[10:11] offset:16
; GCN-NEXT:    global_load_dwordx4 v[4:7], v8, s[10:11]
; GCN-NEXT:    s_waitcnt vmcnt(1)
; GCN-NEXT:    v_readfirstlane_b32 s11, v1
; GCN-NEXT:    v_readfirstlane_b32 s10, v0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_readfirstlane_b32 s13, v5
; GCN-NEXT:    v_readfirstlane_b32 s12, v4
; GCN-NEXT:    s_or_b64 s[0:1], s[12:13], s[10:11]
; GCN-NEXT:    s_mov_b32 s0, 0
; GCN-NEXT:    v_readfirstlane_b32 s5, v3
; GCN-NEXT:    v_readfirstlane_b32 s4, v2
; GCN-NEXT:    v_readfirstlane_b32 s7, v7
; GCN-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GCN-NEXT:    v_readfirstlane_b32 s6, v6
; GCN-NEXT:    s_cbranch_scc0 .LBB10_7
; GCN-NEXT:  ; %bb.1:
; GCN-NEXT:    s_ashr_i32 s0, s11, 31
; GCN-NEXT:    s_add_u32 s2, s10, s0
; GCN-NEXT:    s_mov_b32 s1, s0
; GCN-NEXT:    s_addc_u32 s3, s11, s0
; GCN-NEXT:    s_xor_b64 s[16:17], s[2:3], s[0:1]
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, s16
; GCN-NEXT:    v_cvt_f32_u32_e32 v1, s17
; GCN-NEXT:    s_sub_u32 s0, 0, s16
; GCN-NEXT:    s_subb_u32 s1, 0, s17
; GCN-NEXT:    v_madmk_f32 v0, v1, 0x4f800000, v0
; GCN-NEXT:    v_rcp_f32_e32 v0, v0
; GCN-NEXT:    v_mul_f32_e32 v0, 0x5f7ffffc, v0
; GCN-NEXT:    v_mul_f32_e32 v1, 0x2f800000, v0
; GCN-NEXT:    v_trunc_f32_e32 v1, v1
; GCN-NEXT:    v_madmk_f32 v0, v1, 0xcf800000, v0
; GCN-NEXT:    v_cvt_u32_f32_e32 v1, v1
; GCN-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GCN-NEXT:    v_readfirstlane_b32 s2, v1
; GCN-NEXT:    v_readfirstlane_b32 s3, v0
; GCN-NEXT:    s_mul_i32 s11, s0, s2
; GCN-NEXT:    s_mul_hi_u32 s19, s0, s3
; GCN-NEXT:    s_mul_i32 s18, s1, s3
; GCN-NEXT:    s_add_i32 s11, s19, s11
; GCN-NEXT:    s_add_i32 s11, s11, s18
; GCN-NEXT:    s_mul_i32 s20, s0, s3
; GCN-NEXT:    s_mul_hi_u32 s18, s3, s11
; GCN-NEXT:    s_mul_i32 s19, s3, s11
; GCN-NEXT:    s_mul_hi_u32 s3, s3, s20
; GCN-NEXT:    s_add_u32 s3, s3, s19
; GCN-NEXT:    s_addc_u32 s18, 0, s18
; GCN-NEXT:    s_mul_hi_u32 s21, s2, s20
; GCN-NEXT:    s_mul_i32 s20, s2, s20
; GCN-NEXT:    s_add_u32 s3, s3, s20
; GCN-NEXT:    s_mul_hi_u32 s19, s2, s11
; GCN-NEXT:    s_addc_u32 s3, s18, s21
; GCN-NEXT:    s_addc_u32 s18, s19, 0
; GCN-NEXT:    s_mul_i32 s11, s2, s11
; GCN-NEXT:    s_add_u32 s3, s3, s11
; GCN-NEXT:    s_addc_u32 s11, 0, s18
; GCN-NEXT:    v_add_co_u32_e32 v0, vcc, s3, v0
; GCN-NEXT:    s_cmp_lg_u64 vcc, 0
; GCN-NEXT:    s_addc_u32 s2, s2, s11
; GCN-NEXT:    v_readfirstlane_b32 s11, v0
; GCN-NEXT:    s_mul_i32 s3, s0, s2
; GCN-NEXT:    s_mul_hi_u32 s18, s0, s11
; GCN-NEXT:    s_add_i32 s3, s18, s3
; GCN-NEXT:    s_mul_i32 s1, s1, s11
; GCN-NEXT:    s_add_i32 s3, s3, s1
; GCN-NEXT:    s_mul_i32 s0, s0, s11
; GCN-NEXT:    s_mul_hi_u32 s18, s2, s0
; GCN-NEXT:    s_mul_i32 s19, s2, s0
; GCN-NEXT:    s_mul_i32 s21, s11, s3
; GCN-NEXT:    s_mul_hi_u32 s0, s11, s0
; GCN-NEXT:    s_mul_hi_u32 s20, s11, s3
; GCN-NEXT:    s_add_u32 s0, s0, s21
; GCN-NEXT:    s_addc_u32 s11, 0, s20
; GCN-NEXT:    s_add_u32 s0, s0, s19
; GCN-NEXT:    s_mul_hi_u32 s1, s2, s3
; GCN-NEXT:    s_addc_u32 s0, s11, s18
; GCN-NEXT:    s_addc_u32 s1, s1, 0
; GCN-NEXT:    s_mul_i32 s3, s2, s3
; GCN-NEXT:    s_add_u32 s0, s0, s3
; GCN-NEXT:    s_addc_u32 s1, 0, s1
; GCN-NEXT:    v_add_co_u32_e32 v0, vcc, s0, v0
; GCN-NEXT:    s_cmp_lg_u64 vcc, 0
; GCN-NEXT:    s_addc_u32 s2, s2, s1
; GCN-NEXT:    s_ashr_i32 s18, s13, 31
; GCN-NEXT:    s_add_u32 s0, s12, s18
; GCN-NEXT:    s_mov_b32 s19, s18
; GCN-NEXT:    s_addc_u32 s1, s13, s18
; GCN-NEXT:    s_xor_b64 s[20:21], s[0:1], s[18:19]
; GCN-NEXT:    v_readfirstlane_b32 s3, v0
; GCN-NEXT:    s_mul_i32 s1, s20, s2
; GCN-NEXT:    s_mul_hi_u32 s11, s20, s3
; GCN-NEXT:    s_mul_hi_u32 s0, s20, s2
; GCN-NEXT:    s_add_u32 s1, s11, s1
; GCN-NEXT:    s_addc_u32 s0, 0, s0
; GCN-NEXT:    s_mul_hi_u32 s13, s21, s3
; GCN-NEXT:    s_mul_i32 s3, s21, s3
; GCN-NEXT:    s_add_u32 s1, s1, s3
; GCN-NEXT:    s_mul_hi_u32 s11, s21, s2
; GCN-NEXT:    s_addc_u32 s0, s0, s13
; GCN-NEXT:    s_addc_u32 s1, s11, 0
; GCN-NEXT:    s_mul_i32 s2, s21, s2
; GCN-NEXT:    s_add_u32 s0, s0, s2
; GCN-NEXT:    s_addc_u32 s1, 0, s1
; GCN-NEXT:    s_mul_i32 s1, s16, s1
; GCN-NEXT:    s_mul_hi_u32 s2, s16, s0
; GCN-NEXT:    s_add_i32 s1, s2, s1
; GCN-NEXT:    s_mul_i32 s2, s17, s0
; GCN-NEXT:    s_mul_i32 s0, s16, s0
; GCN-NEXT:    s_add_i32 s11, s1, s2
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    s_sub_i32 s1, s21, s11
; GCN-NEXT:    v_sub_co_u32_e32 v0, vcc, s20, v0
; GCN-NEXT:    s_cmp_lg_u64 vcc, 0
; GCN-NEXT:    s_subb_u32 s13, s1, s17
; GCN-NEXT:    v_subrev_co_u32_e64 v1, s[0:1], s16, v0
; GCN-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GCN-NEXT:    s_subb_u32 s19, s13, 0
; GCN-NEXT:    s_cmp_ge_u32 s19, s17
; GCN-NEXT:    s_cselect_b32 s20, -1, 0
; GCN-NEXT:    v_cmp_le_u32_e64 s[2:3], s16, v1
; GCN-NEXT:    s_cmp_eq_u32 s19, s17
; GCN-NEXT:    v_cndmask_b32_e64 v2, 0, -1, s[2:3]
; GCN-NEXT:    v_mov_b32_e32 v3, s20
; GCN-NEXT:    s_cselect_b64 s[2:3], -1, 0
; GCN-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GCN-NEXT:    v_cndmask_b32_e64 v2, v3, v2, s[2:3]
; GCN-NEXT:    s_subb_u32 s2, s13, s17
; GCN-NEXT:    v_subrev_co_u32_e64 v3, s[0:1], s16, v1
; GCN-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GCN-NEXT:    s_subb_u32 s2, s2, 0
; GCN-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v1, v1, v3, s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v2, s19
; GCN-NEXT:    v_mov_b32_e32 v3, s2
; GCN-NEXT:    s_cmp_lg_u64 vcc, 0
; GCN-NEXT:    v_cndmask_b32_e64 v2, v2, v3, s[0:1]
; GCN-NEXT:    s_subb_u32 s0, s21, s11
; GCN-NEXT:    s_cmp_ge_u32 s0, s17
; GCN-NEXT:    s_cselect_b32 s1, -1, 0
; GCN-NEXT:    v_cmp_le_u32_e32 vcc, s16, v0
; GCN-NEXT:    s_cmp_eq_u32 s0, s17
; GCN-NEXT:    v_cndmask_b32_e64 v3, 0, -1, vcc
; GCN-NEXT:    v_mov_b32_e32 v4, s1
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    v_cndmask_b32_e32 v3, v4, v3, vcc
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GCN-NEXT:    v_mov_b32_e32 v4, s0
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GCN-NEXT:    v_xor_b32_e32 v0, s18, v0
; GCN-NEXT:    v_xor_b32_e32 v1, s18, v2
; GCN-NEXT:    v_mov_b32_e32 v2, s18
; GCN-NEXT:    v_subrev_co_u32_e32 v0, vcc, s18, v0
; GCN-NEXT:    v_subb_co_u32_e32 v1, vcc, v1, v2, vcc
; GCN-NEXT:    s_cbranch_execnz .LBB10_3
; GCN-NEXT:  .LBB10_2:
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, s10
; GCN-NEXT:    s_sub_i32 s0, 0, s10
; GCN-NEXT:    s_mov_b32 s1, 0
; GCN-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; GCN-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; GCN-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GCN-NEXT:    v_readfirstlane_b32 s2, v0
; GCN-NEXT:    s_mul_i32 s0, s0, s2
; GCN-NEXT:    s_mul_hi_u32 s0, s2, s0
; GCN-NEXT:    s_add_i32 s2, s2, s0
; GCN-NEXT:    s_mul_hi_u32 s0, s12, s2
; GCN-NEXT:    s_mul_i32 s0, s0, s10
; GCN-NEXT:    s_sub_i32 s0, s12, s0
; GCN-NEXT:    s_sub_i32 s2, s0, s10
; GCN-NEXT:    s_cmp_ge_u32 s0, s10
; GCN-NEXT:    s_cselect_b32 s0, s2, s0
; GCN-NEXT:    s_sub_i32 s2, s0, s10
; GCN-NEXT:    s_cmp_ge_u32 s0, s10
; GCN-NEXT:    s_cselect_b32 s0, s2, s0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:  .LBB10_3:
; GCN-NEXT:    s_or_b64 s[0:1], s[6:7], s[4:5]
; GCN-NEXT:    s_mov_b32 s0, 0
; GCN-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GCN-NEXT:    s_cbranch_scc0 .LBB10_8
; GCN-NEXT:  ; %bb.4:
; GCN-NEXT:    s_ashr_i32 s0, s5, 31
; GCN-NEXT:    s_add_u32 s2, s4, s0
; GCN-NEXT:    s_mov_b32 s1, s0
; GCN-NEXT:    s_addc_u32 s3, s5, s0
; GCN-NEXT:    s_xor_b64 s[12:13], s[2:3], s[0:1]
; GCN-NEXT:    v_cvt_f32_u32_e32 v2, s12
; GCN-NEXT:    v_cvt_f32_u32_e32 v3, s13
; GCN-NEXT:    s_sub_u32 s0, 0, s12
; GCN-NEXT:    s_subb_u32 s1, 0, s13
; GCN-NEXT:    v_madmk_f32 v2, v3, 0x4f800000, v2
; GCN-NEXT:    v_rcp_f32_e32 v2, v2
; GCN-NEXT:    v_mul_f32_e32 v2, 0x5f7ffffc, v2
; GCN-NEXT:    v_mul_f32_e32 v3, 0x2f800000, v2
; GCN-NEXT:    v_trunc_f32_e32 v3, v3
; GCN-NEXT:    v_madmk_f32 v2, v3, 0xcf800000, v2
; GCN-NEXT:    v_cvt_u32_f32_e32 v3, v3
; GCN-NEXT:    v_cvt_u32_f32_e32 v2, v2
; GCN-NEXT:    v_readfirstlane_b32 s2, v3
; GCN-NEXT:    v_readfirstlane_b32 s3, v2
; GCN-NEXT:    s_mul_i32 s5, s0, s2
; GCN-NEXT:    s_mul_hi_u32 s15, s0, s3
; GCN-NEXT:    s_mul_i32 s14, s1, s3
; GCN-NEXT:    s_add_i32 s5, s15, s5
; GCN-NEXT:    s_add_i32 s5, s5, s14
; GCN-NEXT:    s_mul_i32 s16, s0, s3
; GCN-NEXT:    s_mul_hi_u32 s14, s3, s5
; GCN-NEXT:    s_mul_i32 s15, s3, s5
; GCN-NEXT:    s_mul_hi_u32 s3, s3, s16
; GCN-NEXT:    s_add_u32 s3, s3, s15
; GCN-NEXT:    s_addc_u32 s14, 0, s14
; GCN-NEXT:    s_mul_hi_u32 s17, s2, s16
; GCN-NEXT:    s_mul_i32 s16, s2, s16
; GCN-NEXT:    s_add_u32 s3, s3, s16
; GCN-NEXT:    s_mul_hi_u32 s15, s2, s5
; GCN-NEXT:    s_addc_u32 s3, s14, s17
; GCN-NEXT:    s_addc_u32 s14, s15, 0
; GCN-NEXT:    s_mul_i32 s5, s2, s5
; GCN-NEXT:    s_add_u32 s3, s3, s5
; GCN-NEXT:    s_addc_u32 s5, 0, s14
; GCN-NEXT:    v_add_co_u32_e32 v2, vcc, s3, v2
; GCN-NEXT:    s_cmp_lg_u64 vcc, 0
; GCN-NEXT:    s_addc_u32 s2, s2, s5
; GCN-NEXT:    v_readfirstlane_b32 s5, v2
; GCN-NEXT:    s_mul_i32 s3, s0, s2
; GCN-NEXT:    s_mul_hi_u32 s14, s0, s5
; GCN-NEXT:    s_add_i32 s3, s14, s3
; GCN-NEXT:    s_mul_i32 s1, s1, s5
; GCN-NEXT:    s_add_i32 s3, s3, s1
; GCN-NEXT:    s_mul_i32 s0, s0, s5
; GCN-NEXT:    s_mul_hi_u32 s14, s2, s0
; GCN-NEXT:    s_mul_i32 s15, s2, s0
; GCN-NEXT:    s_mul_i32 s17, s5, s3
; GCN-NEXT:    s_mul_hi_u32 s0, s5, s0
; GCN-NEXT:    s_mul_hi_u32 s16, s5, s3
; GCN-NEXT:    s_add_u32 s0, s0, s17
; GCN-NEXT:    s_addc_u32 s5, 0, s16
; GCN-NEXT:    s_add_u32 s0, s0, s15
; GCN-NEXT:    s_mul_hi_u32 s1, s2, s3
; GCN-NEXT:    s_addc_u32 s0, s5, s14
; GCN-NEXT:    s_addc_u32 s1, s1, 0
; GCN-NEXT:    s_mul_i32 s3, s2, s3
; GCN-NEXT:    s_add_u32 s0, s0, s3
; GCN-NEXT:    s_addc_u32 s1, 0, s1
; GCN-NEXT:    v_add_co_u32_e32 v2, vcc, s0, v2
; GCN-NEXT:    s_cmp_lg_u64 vcc, 0
; GCN-NEXT:    s_addc_u32 s2, s2, s1
; GCN-NEXT:    s_ashr_i32 s14, s7, 31
; GCN-NEXT:    s_add_u32 s0, s6, s14
; GCN-NEXT:    s_mov_b32 s15, s14
; GCN-NEXT:    s_addc_u32 s1, s7, s14
; GCN-NEXT:    s_xor_b64 s[16:17], s[0:1], s[14:15]
; GCN-NEXT:    v_readfirstlane_b32 s3, v2
; GCN-NEXT:    s_mul_i32 s1, s16, s2
; GCN-NEXT:    s_mul_hi_u32 s5, s16, s3
; GCN-NEXT:    s_mul_hi_u32 s0, s16, s2
; GCN-NEXT:    s_add_u32 s1, s5, s1
; GCN-NEXT:    s_addc_u32 s0, 0, s0
; GCN-NEXT:    s_mul_hi_u32 s7, s17, s3
; GCN-NEXT:    s_mul_i32 s3, s17, s3
; GCN-NEXT:    s_add_u32 s1, s1, s3
; GCN-NEXT:    s_mul_hi_u32 s5, s17, s2
; GCN-NEXT:    s_addc_u32 s0, s0, s7
; GCN-NEXT:    s_addc_u32 s1, s5, 0
; GCN-NEXT:    s_mul_i32 s2, s17, s2
; GCN-NEXT:    s_add_u32 s0, s0, s2
; GCN-NEXT:    s_addc_u32 s1, 0, s1
; GCN-NEXT:    s_mul_i32 s1, s12, s1
; GCN-NEXT:    s_mul_hi_u32 s2, s12, s0
; GCN-NEXT:    s_add_i32 s1, s2, s1
; GCN-NEXT:    s_mul_i32 s2, s13, s0
; GCN-NEXT:    s_mul_i32 s0, s12, s0
; GCN-NEXT:    s_add_i32 s5, s1, s2
; GCN-NEXT:    v_mov_b32_e32 v2, s0
; GCN-NEXT:    s_sub_i32 s1, s17, s5
; GCN-NEXT:    v_sub_co_u32_e32 v2, vcc, s16, v2
; GCN-NEXT:    s_cmp_lg_u64 vcc, 0
; GCN-NEXT:    s_subb_u32 s7, s1, s13
; GCN-NEXT:    v_subrev_co_u32_e64 v3, s[0:1], s12, v2
; GCN-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GCN-NEXT:    s_subb_u32 s15, s7, 0
; GCN-NEXT:    s_cmp_ge_u32 s15, s13
; GCN-NEXT:    s_cselect_b32 s16, -1, 0
; GCN-NEXT:    v_cmp_le_u32_e64 s[2:3], s12, v3
; GCN-NEXT:    s_cmp_eq_u32 s15, s13
; GCN-NEXT:    v_cndmask_b32_e64 v4, 0, -1, s[2:3]
; GCN-NEXT:    v_mov_b32_e32 v5, s16
; GCN-NEXT:    s_cselect_b64 s[2:3], -1, 0
; GCN-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GCN-NEXT:    v_cndmask_b32_e64 v4, v5, v4, s[2:3]
; GCN-NEXT:    s_subb_u32 s2, s7, s13
; GCN-NEXT:    v_subrev_co_u32_e64 v5, s[0:1], s12, v3
; GCN-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GCN-NEXT:    s_subb_u32 s2, s2, 0
; GCN-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v4
; GCN-NEXT:    v_cndmask_b32_e64 v3, v3, v5, s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v4, s15
; GCN-NEXT:    v_mov_b32_e32 v5, s2
; GCN-NEXT:    s_cmp_lg_u64 vcc, 0
; GCN-NEXT:    v_cndmask_b32_e64 v4, v4, v5, s[0:1]
; GCN-NEXT:    s_subb_u32 s0, s17, s5
; GCN-NEXT:    s_cmp_ge_u32 s0, s13
; GCN-NEXT:    s_cselect_b32 s1, -1, 0
; GCN-NEXT:    v_cmp_le_u32_e32 vcc, s12, v2
; GCN-NEXT:    s_cmp_eq_u32 s0, s13
; GCN-NEXT:    v_cndmask_b32_e64 v5, 0, -1, vcc
; GCN-NEXT:    v_mov_b32_e32 v6, s1
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    v_cndmask_b32_e32 v5, v6, v5, vcc
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v5
; GCN-NEXT:    v_mov_b32_e32 v6, s0
; GCN-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GCN-NEXT:    v_xor_b32_e32 v2, s14, v2
; GCN-NEXT:    v_xor_b32_e32 v3, s14, v4
; GCN-NEXT:    v_mov_b32_e32 v4, s14
; GCN-NEXT:    v_subrev_co_u32_e32 v2, vcc, s14, v2
; GCN-NEXT:    v_subb_co_u32_e32 v3, vcc, v3, v4, vcc
; GCN-NEXT:    s_cbranch_execnz .LBB10_6
; GCN-NEXT:  .LBB10_5:
; GCN-NEXT:    v_cvt_f32_u32_e32 v2, s4
; GCN-NEXT:    s_sub_i32 s0, 0, s4
; GCN-NEXT:    v_rcp_iflag_f32_e32 v2, v2
; GCN-NEXT:    v_mul_f32_e32 v2, 0x4f7ffffe, v2
; GCN-NEXT:    v_cvt_u32_f32_e32 v2, v2
; GCN-NEXT:    v_mul_lo_u32 v3, s0, v2
; GCN-NEXT:    v_mul_hi_u32 v3, v2, v3
; GCN-NEXT:    v_add_u32_e32 v2, v2, v3
; GCN-NEXT:    v_mul_hi_u32 v2, s6, v2
; GCN-NEXT:    v_mul_lo_u32 v2, v2, s4
; GCN-NEXT:    v_sub_u32_e32 v2, s6, v2
; GCN-NEXT:    v_subrev_u32_e32 v3, s4, v2
; GCN-NEXT:    v_cmp_le_u32_e32 vcc, s4, v2
; GCN-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GCN-NEXT:    v_subrev_u32_e32 v3, s4, v2
; GCN-NEXT:    v_cmp_le_u32_e32 vcc, s4, v2
; GCN-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GCN-NEXT:    v_mov_b32_e32 v3, 0
; GCN-NEXT:  .LBB10_6:
; GCN-NEXT:    v_mov_b32_e32 v4, 0
; GCN-NEXT:    global_store_dwordx4 v4, v[0:3], s[8:9]
; GCN-NEXT:    s_endpgm
; GCN-NEXT:  .LBB10_7:
; GCN-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GCN-NEXT:    s_branch .LBB10_2
; GCN-NEXT:  .LBB10_8:
; GCN-NEXT:    s_branch .LBB10_5
;
; TAHITI-LABEL: srem_v2i64:
; TAHITI:       ; %bb.0:
; TAHITI-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x9
; TAHITI-NEXT:    s_mov_b32 s3, 0xf000
; TAHITI-NEXT:    s_mov_b32 s2, -1
; TAHITI-NEXT:    v_mov_b32_e32 v8, 0
; TAHITI-NEXT:    s_waitcnt lgkmcnt(0)
; TAHITI-NEXT:    s_mov_b32 s0, s6
; TAHITI-NEXT:    s_mov_b32 s1, s7
; TAHITI-NEXT:    buffer_load_dwordx4 v[4:7], off, s[0:3], 0
; TAHITI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], 0 offset:16
; TAHITI-NEXT:    s_waitcnt vmcnt(0)
; TAHITI-NEXT:    v_or_b32_e32 v9, v5, v1
; TAHITI-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[8:9]
; TAHITI-NEXT:    s_cbranch_vccz .LBB10_7
; TAHITI-NEXT:  ; %bb.1:
; TAHITI-NEXT:    v_ashrrev_i32_e32 v9, 31, v1
; TAHITI-NEXT:    v_add_i32_e32 v8, vcc, v0, v9
; TAHITI-NEXT:    v_addc_u32_e32 v1, vcc, v1, v9, vcc
; TAHITI-NEXT:    v_xor_b32_e32 v8, v8, v9
; TAHITI-NEXT:    v_xor_b32_e32 v1, v1, v9
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v9, v8
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v10, v1
; TAHITI-NEXT:    v_sub_i32_e32 v11, vcc, 0, v8
; TAHITI-NEXT:    v_subb_u32_e32 v12, vcc, 0, v1, vcc
; TAHITI-NEXT:    v_madmk_f32 v9, v10, 0x4f800000, v9
; TAHITI-NEXT:    v_rcp_f32_e32 v9, v9
; TAHITI-NEXT:    v_mul_f32_e32 v9, 0x5f7ffffc, v9
; TAHITI-NEXT:    v_mul_f32_e32 v10, 0x2f800000, v9
; TAHITI-NEXT:    v_trunc_f32_e32 v10, v10
; TAHITI-NEXT:    v_madmk_f32 v9, v10, 0xcf800000, v9
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v10, v10
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v9, v9
; TAHITI-NEXT:    v_mul_lo_u32 v14, v11, v10
; TAHITI-NEXT:    v_mul_hi_u32 v13, v11, v9
; TAHITI-NEXT:    v_mul_lo_u32 v15, v12, v9
; TAHITI-NEXT:    v_add_i32_e32 v13, vcc, v14, v13
; TAHITI-NEXT:    v_mul_lo_u32 v14, v11, v9
; TAHITI-NEXT:    v_add_i32_e32 v13, vcc, v13, v15
; TAHITI-NEXT:    v_mul_lo_u32 v15, v9, v13
; TAHITI-NEXT:    v_mul_hi_u32 v16, v9, v14
; TAHITI-NEXT:    v_mul_hi_u32 v17, v9, v13
; TAHITI-NEXT:    v_mul_hi_u32 v18, v10, v13
; TAHITI-NEXT:    v_mul_lo_u32 v13, v10, v13
; TAHITI-NEXT:    v_add_i32_e32 v15, vcc, v16, v15
; TAHITI-NEXT:    v_addc_u32_e32 v16, vcc, 0, v17, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v17, v10, v14
; TAHITI-NEXT:    v_mul_hi_u32 v14, v10, v14
; TAHITI-NEXT:    v_add_i32_e32 v15, vcc, v15, v17
; TAHITI-NEXT:    v_addc_u32_e32 v14, vcc, v16, v14, vcc
; TAHITI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v18, vcc
; TAHITI-NEXT:    v_add_i32_e32 v13, vcc, v14, v13
; TAHITI-NEXT:    v_addc_u32_e32 v14, vcc, 0, v15, vcc
; TAHITI-NEXT:    v_add_i32_e32 v9, vcc, v9, v13
; TAHITI-NEXT:    v_addc_u32_e32 v10, vcc, v10, v14, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v13, v11, v10
; TAHITI-NEXT:    v_mul_hi_u32 v14, v11, v9
; TAHITI-NEXT:    v_mul_lo_u32 v12, v12, v9
; TAHITI-NEXT:    v_mul_lo_u32 v11, v11, v9
; TAHITI-NEXT:    v_add_i32_e32 v13, vcc, v13, v14
; TAHITI-NEXT:    v_add_i32_e32 v12, vcc, v13, v12
; TAHITI-NEXT:    v_mul_lo_u32 v15, v9, v12
; TAHITI-NEXT:    v_mul_hi_u32 v16, v9, v11
; TAHITI-NEXT:    v_mul_hi_u32 v17, v9, v12
; TAHITI-NEXT:    v_mul_hi_u32 v14, v10, v11
; TAHITI-NEXT:    v_mul_lo_u32 v11, v10, v11
; TAHITI-NEXT:    v_mul_hi_u32 v13, v10, v12
; TAHITI-NEXT:    v_add_i32_e32 v15, vcc, v16, v15
; TAHITI-NEXT:    v_addc_u32_e32 v16, vcc, 0, v17, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v12, v10, v12
; TAHITI-NEXT:    v_add_i32_e32 v11, vcc, v15, v11
; TAHITI-NEXT:    v_addc_u32_e32 v11, vcc, v16, v14, vcc
; TAHITI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; TAHITI-NEXT:    v_add_i32_e32 v11, vcc, v11, v12
; TAHITI-NEXT:    v_addc_u32_e32 v12, vcc, 0, v13, vcc
; TAHITI-NEXT:    v_add_i32_e32 v9, vcc, v9, v11
; TAHITI-NEXT:    v_addc_u32_e32 v10, vcc, v10, v12, vcc
; TAHITI-NEXT:    v_ashrrev_i32_e32 v11, 31, v5
; TAHITI-NEXT:    v_add_i32_e32 v12, vcc, v4, v11
; TAHITI-NEXT:    v_xor_b32_e32 v12, v12, v11
; TAHITI-NEXT:    v_mul_lo_u32 v13, v12, v10
; TAHITI-NEXT:    v_mul_hi_u32 v14, v12, v9
; TAHITI-NEXT:    v_mul_hi_u32 v15, v12, v10
; TAHITI-NEXT:    v_addc_u32_e32 v5, vcc, v5, v11, vcc
; TAHITI-NEXT:    v_xor_b32_e32 v5, v5, v11
; TAHITI-NEXT:    v_add_i32_e32 v13, vcc, v14, v13
; TAHITI-NEXT:    v_addc_u32_e32 v14, vcc, 0, v15, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v15, v5, v9
; TAHITI-NEXT:    v_mul_hi_u32 v9, v5, v9
; TAHITI-NEXT:    v_mul_hi_u32 v16, v5, v10
; TAHITI-NEXT:    v_mul_lo_u32 v10, v5, v10
; TAHITI-NEXT:    v_add_i32_e32 v13, vcc, v13, v15
; TAHITI-NEXT:    v_addc_u32_e32 v9, vcc, v14, v9, vcc
; TAHITI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v16, vcc
; TAHITI-NEXT:    v_add_i32_e32 v9, vcc, v9, v10
; TAHITI-NEXT:    v_addc_u32_e32 v10, vcc, 0, v13, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v10, v8, v10
; TAHITI-NEXT:    v_mul_hi_u32 v13, v8, v9
; TAHITI-NEXT:    v_mul_lo_u32 v14, v1, v9
; TAHITI-NEXT:    v_mul_lo_u32 v9, v8, v9
; TAHITI-NEXT:    v_add_i32_e32 v10, vcc, v10, v13
; TAHITI-NEXT:    v_add_i32_e32 v10, vcc, v14, v10
; TAHITI-NEXT:    v_sub_i32_e32 v13, vcc, v5, v10
; TAHITI-NEXT:    v_sub_i32_e32 v9, vcc, v12, v9
; TAHITI-NEXT:    v_subb_u32_e64 v12, s[0:1], v13, v1, vcc
; TAHITI-NEXT:    v_sub_i32_e64 v13, s[0:1], v9, v8
; TAHITI-NEXT:    v_subbrev_u32_e64 v14, s[2:3], 0, v12, s[0:1]
; TAHITI-NEXT:    v_cmp_ge_u32_e64 s[2:3], v14, v1
; TAHITI-NEXT:    v_cndmask_b32_e64 v15, 0, -1, s[2:3]
; TAHITI-NEXT:    v_cmp_ge_u32_e64 s[2:3], v13, v8
; TAHITI-NEXT:    v_subb_u32_e32 v5, vcc, v5, v10, vcc
; TAHITI-NEXT:    v_cndmask_b32_e64 v16, 0, -1, s[2:3]
; TAHITI-NEXT:    v_cmp_eq_u32_e64 s[2:3], v14, v1
; TAHITI-NEXT:    v_subb_u32_e64 v12, s[0:1], v12, v1, s[0:1]
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v5, v1
; TAHITI-NEXT:    v_cndmask_b32_e64 v15, v15, v16, s[2:3]
; TAHITI-NEXT:    v_sub_i32_e64 v16, s[0:1], v13, v8
; TAHITI-NEXT:    v_cndmask_b32_e64 v10, 0, -1, vcc
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v9, v8
; TAHITI-NEXT:    v_subbrev_u32_e64 v12, s[0:1], 0, v12, s[0:1]
; TAHITI-NEXT:    v_cndmask_b32_e64 v8, 0, -1, vcc
; TAHITI-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v1
; TAHITI-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v15
; TAHITI-NEXT:    v_cndmask_b32_e32 v1, v10, v8, vcc
; TAHITI-NEXT:    v_cndmask_b32_e64 v13, v13, v16, s[0:1]
; TAHITI-NEXT:    v_cndmask_b32_e64 v12, v14, v12, s[0:1]
; TAHITI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; TAHITI-NEXT:    v_cndmask_b32_e32 v1, v5, v12, vcc
; TAHITI-NEXT:    v_cndmask_b32_e32 v5, v9, v13, vcc
; TAHITI-NEXT:    v_xor_b32_e32 v5, v5, v11
; TAHITI-NEXT:    v_xor_b32_e32 v1, v1, v11
; TAHITI-NEXT:    v_sub_i32_e32 v8, vcc, v5, v11
; TAHITI-NEXT:    v_subb_u32_e32 v9, vcc, v1, v11, vcc
; TAHITI-NEXT:    s_cbranch_execnz .LBB10_3
; TAHITI-NEXT:  .LBB10_2:
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v1, v0
; TAHITI-NEXT:    v_sub_i32_e32 v5, vcc, 0, v0
; TAHITI-NEXT:    v_mov_b32_e32 v9, 0
; TAHITI-NEXT:    v_rcp_iflag_f32_e32 v1, v1
; TAHITI-NEXT:    v_mul_f32_e32 v1, 0x4f7ffffe, v1
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v1, v1
; TAHITI-NEXT:    v_mul_lo_u32 v5, v5, v1
; TAHITI-NEXT:    v_mul_hi_u32 v5, v1, v5
; TAHITI-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; TAHITI-NEXT:    v_mul_hi_u32 v1, v4, v1
; TAHITI-NEXT:    v_mul_lo_u32 v1, v1, v0
; TAHITI-NEXT:    v_sub_i32_e32 v1, vcc, v4, v1
; TAHITI-NEXT:    v_sub_i32_e32 v4, vcc, v1, v0
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v1, v0
; TAHITI-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; TAHITI-NEXT:    v_sub_i32_e32 v4, vcc, v1, v0
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v1, v0
; TAHITI-NEXT:    v_cndmask_b32_e32 v8, v1, v4, vcc
; TAHITI-NEXT:  .LBB10_3:
; TAHITI-NEXT:    v_or_b32_e32 v1, v7, v3
; TAHITI-NEXT:    v_mov_b32_e32 v0, 0
; TAHITI-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; TAHITI-NEXT:    s_cbranch_vccz .LBB10_8
; TAHITI-NEXT:  ; %bb.4:
; TAHITI-NEXT:    v_ashrrev_i32_e32 v0, 31, v3
; TAHITI-NEXT:    v_add_i32_e32 v1, vcc, v2, v0
; TAHITI-NEXT:    v_addc_u32_e32 v3, vcc, v3, v0, vcc
; TAHITI-NEXT:    v_xor_b32_e32 v1, v1, v0
; TAHITI-NEXT:    v_xor_b32_e32 v0, v3, v0
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v3, v1
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v4, v0
; TAHITI-NEXT:    v_sub_i32_e32 v5, vcc, 0, v1
; TAHITI-NEXT:    v_subb_u32_e32 v10, vcc, 0, v0, vcc
; TAHITI-NEXT:    v_madmk_f32 v3, v4, 0x4f800000, v3
; TAHITI-NEXT:    v_rcp_f32_e32 v3, v3
; TAHITI-NEXT:    v_mul_f32_e32 v3, 0x5f7ffffc, v3
; TAHITI-NEXT:    v_mul_f32_e32 v4, 0x2f800000, v3
; TAHITI-NEXT:    v_trunc_f32_e32 v4, v4
; TAHITI-NEXT:    v_madmk_f32 v3, v4, 0xcf800000, v3
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v4, v4
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v3, v3
; TAHITI-NEXT:    v_mul_lo_u32 v12, v5, v4
; TAHITI-NEXT:    v_mul_hi_u32 v11, v5, v3
; TAHITI-NEXT:    v_mul_lo_u32 v13, v10, v3
; TAHITI-NEXT:    v_add_i32_e32 v11, vcc, v12, v11
; TAHITI-NEXT:    v_mul_lo_u32 v12, v5, v3
; TAHITI-NEXT:    v_add_i32_e32 v11, vcc, v11, v13
; TAHITI-NEXT:    v_mul_lo_u32 v13, v3, v11
; TAHITI-NEXT:    v_mul_hi_u32 v14, v3, v12
; TAHITI-NEXT:    v_mul_hi_u32 v15, v3, v11
; TAHITI-NEXT:    v_mul_hi_u32 v16, v4, v11
; TAHITI-NEXT:    v_mul_lo_u32 v11, v4, v11
; TAHITI-NEXT:    v_add_i32_e32 v13, vcc, v14, v13
; TAHITI-NEXT:    v_addc_u32_e32 v14, vcc, 0, v15, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v15, v4, v12
; TAHITI-NEXT:    v_mul_hi_u32 v12, v4, v12
; TAHITI-NEXT:    v_add_i32_e32 v13, vcc, v13, v15
; TAHITI-NEXT:    v_addc_u32_e32 v12, vcc, v14, v12, vcc
; TAHITI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v16, vcc
; TAHITI-NEXT:    v_add_i32_e32 v11, vcc, v12, v11
; TAHITI-NEXT:    v_addc_u32_e32 v12, vcc, 0, v13, vcc
; TAHITI-NEXT:    v_add_i32_e32 v3, vcc, v3, v11
; TAHITI-NEXT:    v_addc_u32_e32 v4, vcc, v4, v12, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v11, v5, v4
; TAHITI-NEXT:    v_mul_hi_u32 v12, v5, v3
; TAHITI-NEXT:    v_mul_lo_u32 v10, v10, v3
; TAHITI-NEXT:    v_mul_lo_u32 v5, v5, v3
; TAHITI-NEXT:    v_add_i32_e32 v11, vcc, v11, v12
; TAHITI-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; TAHITI-NEXT:    v_mul_lo_u32 v13, v3, v10
; TAHITI-NEXT:    v_mul_hi_u32 v14, v3, v5
; TAHITI-NEXT:    v_mul_hi_u32 v15, v3, v10
; TAHITI-NEXT:    v_mul_hi_u32 v12, v4, v5
; TAHITI-NEXT:    v_mul_lo_u32 v5, v4, v5
; TAHITI-NEXT:    v_mul_hi_u32 v11, v4, v10
; TAHITI-NEXT:    v_add_i32_e32 v13, vcc, v14, v13
; TAHITI-NEXT:    v_addc_u32_e32 v14, vcc, 0, v15, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v10, v4, v10
; TAHITI-NEXT:    v_add_i32_e32 v5, vcc, v13, v5
; TAHITI-NEXT:    v_addc_u32_e32 v5, vcc, v14, v12, vcc
; TAHITI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; TAHITI-NEXT:    v_add_i32_e32 v5, vcc, v5, v10
; TAHITI-NEXT:    v_addc_u32_e32 v10, vcc, 0, v11, vcc
; TAHITI-NEXT:    v_add_i32_e32 v3, vcc, v3, v5
; TAHITI-NEXT:    v_addc_u32_e32 v4, vcc, v4, v10, vcc
; TAHITI-NEXT:    v_ashrrev_i32_e32 v5, 31, v7
; TAHITI-NEXT:    v_add_i32_e32 v10, vcc, v6, v5
; TAHITI-NEXT:    v_xor_b32_e32 v10, v10, v5
; TAHITI-NEXT:    v_mul_lo_u32 v11, v10, v4
; TAHITI-NEXT:    v_mul_hi_u32 v12, v10, v3
; TAHITI-NEXT:    v_mul_hi_u32 v13, v10, v4
; TAHITI-NEXT:    v_addc_u32_e32 v7, vcc, v7, v5, vcc
; TAHITI-NEXT:    v_xor_b32_e32 v7, v7, v5
; TAHITI-NEXT:    v_add_i32_e32 v11, vcc, v12, v11
; TAHITI-NEXT:    v_addc_u32_e32 v12, vcc, 0, v13, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v13, v7, v3
; TAHITI-NEXT:    v_mul_hi_u32 v3, v7, v3
; TAHITI-NEXT:    v_mul_hi_u32 v14, v7, v4
; TAHITI-NEXT:    v_mul_lo_u32 v4, v7, v4
; TAHITI-NEXT:    v_add_i32_e32 v11, vcc, v11, v13
; TAHITI-NEXT:    v_addc_u32_e32 v3, vcc, v12, v3, vcc
; TAHITI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v14, vcc
; TAHITI-NEXT:    v_add_i32_e32 v3, vcc, v3, v4
; TAHITI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v11, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v4, v1, v4
; TAHITI-NEXT:    v_mul_hi_u32 v11, v1, v3
; TAHITI-NEXT:    v_mul_lo_u32 v12, v0, v3
; TAHITI-NEXT:    v_mul_lo_u32 v3, v1, v3
; TAHITI-NEXT:    v_add_i32_e32 v4, vcc, v4, v11
; TAHITI-NEXT:    v_add_i32_e32 v4, vcc, v12, v4
; TAHITI-NEXT:    v_sub_i32_e32 v11, vcc, v7, v4
; TAHITI-NEXT:    v_sub_i32_e32 v3, vcc, v10, v3
; TAHITI-NEXT:    v_subb_u32_e64 v10, s[0:1], v11, v0, vcc
; TAHITI-NEXT:    v_sub_i32_e64 v11, s[0:1], v3, v1
; TAHITI-NEXT:    v_subbrev_u32_e64 v12, s[2:3], 0, v10, s[0:1]
; TAHITI-NEXT:    v_cmp_ge_u32_e64 s[2:3], v12, v0
; TAHITI-NEXT:    v_cndmask_b32_e64 v13, 0, -1, s[2:3]
; TAHITI-NEXT:    v_cmp_ge_u32_e64 s[2:3], v11, v1
; TAHITI-NEXT:    v_subb_u32_e32 v4, vcc, v7, v4, vcc
; TAHITI-NEXT:    v_cndmask_b32_e64 v14, 0, -1, s[2:3]
; TAHITI-NEXT:    v_cmp_eq_u32_e64 s[2:3], v12, v0
; TAHITI-NEXT:    v_subb_u32_e64 v10, s[0:1], v10, v0, s[0:1]
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v4, v0
; TAHITI-NEXT:    v_cndmask_b32_e64 v13, v13, v14, s[2:3]
; TAHITI-NEXT:    v_sub_i32_e64 v14, s[0:1], v11, v1
; TAHITI-NEXT:    v_cndmask_b32_e64 v7, 0, -1, vcc
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v3, v1
; TAHITI-NEXT:    v_subbrev_u32_e64 v10, s[0:1], 0, v10, s[0:1]
; TAHITI-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc
; TAHITI-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v0
; TAHITI-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v13
; TAHITI-NEXT:    v_cndmask_b32_e32 v0, v7, v1, vcc
; TAHITI-NEXT:    v_cndmask_b32_e64 v11, v11, v14, s[0:1]
; TAHITI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; TAHITI-NEXT:    v_cndmask_b32_e64 v10, v12, v10, s[0:1]
; TAHITI-NEXT:    v_cndmask_b32_e32 v1, v3, v11, vcc
; TAHITI-NEXT:    v_cndmask_b32_e32 v0, v4, v10, vcc
; TAHITI-NEXT:    v_xor_b32_e32 v1, v1, v5
; TAHITI-NEXT:    v_xor_b32_e32 v0, v0, v5
; TAHITI-NEXT:    v_sub_i32_e32 v10, vcc, v1, v5
; TAHITI-NEXT:    v_subb_u32_e32 v11, vcc, v0, v5, vcc
; TAHITI-NEXT:    s_cbranch_execnz .LBB10_6
; TAHITI-NEXT:  .LBB10_5:
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v0, v2
; TAHITI-NEXT:    v_sub_i32_e32 v1, vcc, 0, v2
; TAHITI-NEXT:    v_mov_b32_e32 v11, 0
; TAHITI-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; TAHITI-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v0, v0
; TAHITI-NEXT:    v_mul_lo_u32 v1, v1, v0
; TAHITI-NEXT:    v_mul_hi_u32 v1, v0, v1
; TAHITI-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; TAHITI-NEXT:    v_mul_hi_u32 v0, v6, v0
; TAHITI-NEXT:    v_mul_lo_u32 v0, v0, v2
; TAHITI-NEXT:    v_sub_i32_e32 v0, vcc, v6, v0
; TAHITI-NEXT:    v_subrev_i32_e32 v1, vcc, v2, v0
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v2
; TAHITI-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; TAHITI-NEXT:    v_subrev_i32_e32 v1, vcc, v2, v0
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v2
; TAHITI-NEXT:    v_cndmask_b32_e32 v10, v0, v1, vcc
; TAHITI-NEXT:  .LBB10_6:
; TAHITI-NEXT:    s_mov_b32 s7, 0xf000
; TAHITI-NEXT:    s_mov_b32 s6, -1
; TAHITI-NEXT:    buffer_store_dwordx4 v[8:11], off, s[4:7], 0
; TAHITI-NEXT:    s_endpgm
; TAHITI-NEXT:  .LBB10_7:
; TAHITI-NEXT:    ; implicit-def: $vgpr8_vgpr9
; TAHITI-NEXT:    s_branch .LBB10_2
; TAHITI-NEXT:  .LBB10_8:
; TAHITI-NEXT:    s_branch .LBB10_5
;
; TONGA-LABEL: srem_v2i64:
; TONGA:       ; %bb.0:
; TONGA-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x24
; TONGA-NEXT:    v_mov_b32_e32 v8, 0
; TONGA-NEXT:    s_waitcnt lgkmcnt(0)
; TONGA-NEXT:    s_add_u32 s0, s6, 16
; TONGA-NEXT:    v_mov_b32_e32 v4, s6
; TONGA-NEXT:    s_addc_u32 s1, s7, 0
; TONGA-NEXT:    v_mov_b32_e32 v0, s0
; TONGA-NEXT:    v_mov_b32_e32 v5, s7
; TONGA-NEXT:    v_mov_b32_e32 v1, s1
; TONGA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; TONGA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; TONGA-NEXT:    s_waitcnt vmcnt(0)
; TONGA-NEXT:    v_or_b32_e32 v9, v5, v1
; TONGA-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[8:9]
; TONGA-NEXT:    s_cbranch_vccz .LBB10_7
; TONGA-NEXT:  ; %bb.1:
; TONGA-NEXT:    v_ashrrev_i32_e32 v8, 31, v1
; TONGA-NEXT:    v_add_u32_e32 v9, vcc, v0, v8
; TONGA-NEXT:    v_addc_u32_e32 v1, vcc, v1, v8, vcc
; TONGA-NEXT:    v_xor_b32_e32 v14, v9, v8
; TONGA-NEXT:    v_xor_b32_e32 v1, v1, v8
; TONGA-NEXT:    v_cvt_f32_u32_e32 v8, v14
; TONGA-NEXT:    v_cvt_f32_u32_e32 v9, v1
; TONGA-NEXT:    v_sub_u32_e32 v15, vcc, 0, v14
; TONGA-NEXT:    v_subb_u32_e32 v16, vcc, 0, v1, vcc
; TONGA-NEXT:    v_madmk_f32 v8, v9, 0x4f800000, v8
; TONGA-NEXT:    v_rcp_f32_e32 v8, v8
; TONGA-NEXT:    v_mul_f32_e32 v8, 0x5f7ffffc, v8
; TONGA-NEXT:    v_mul_f32_e32 v9, 0x2f800000, v8
; TONGA-NEXT:    v_trunc_f32_e32 v9, v9
; TONGA-NEXT:    v_madmk_f32 v8, v9, 0xcf800000, v8
; TONGA-NEXT:    v_cvt_u32_f32_e32 v12, v9
; TONGA-NEXT:    v_cvt_u32_f32_e32 v13, v8
; TONGA-NEXT:    v_mul_lo_u32 v10, v15, v12
; TONGA-NEXT:    v_mad_u64_u32 v[8:9], s[0:1], v15, v13, 0
; TONGA-NEXT:    v_mul_lo_u32 v11, v16, v13
; TONGA-NEXT:    v_add_u32_e32 v9, vcc, v9, v10
; TONGA-NEXT:    v_add_u32_e32 v11, vcc, v9, v11
; TONGA-NEXT:    v_mad_u64_u32 v[9:10], s[0:1], v13, v11, 0
; TONGA-NEXT:    v_mul_hi_u32 v17, v13, v8
; TONGA-NEXT:    v_add_u32_e32 v17, vcc, v17, v9
; TONGA-NEXT:    v_mad_u64_u32 v[8:9], s[0:1], v12, v8, 0
; TONGA-NEXT:    v_addc_u32_e32 v18, vcc, 0, v10, vcc
; TONGA-NEXT:    v_mad_u64_u32 v[10:11], s[0:1], v12, v11, 0
; TONGA-NEXT:    v_add_u32_e32 v8, vcc, v17, v8
; TONGA-NEXT:    v_addc_u32_e32 v8, vcc, v18, v9, vcc
; TONGA-NEXT:    v_addc_u32_e32 v9, vcc, 0, v11, vcc
; TONGA-NEXT:    v_add_u32_e32 v8, vcc, v8, v10
; TONGA-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; TONGA-NEXT:    v_add_u32_e32 v17, vcc, v13, v8
; TONGA-NEXT:    v_addc_u32_e32 v18, vcc, v12, v9, vcc
; TONGA-NEXT:    v_mad_u64_u32 v[8:9], s[0:1], v15, v17, 0
; TONGA-NEXT:    v_mul_lo_u32 v12, v15, v18
; TONGA-NEXT:    v_mul_lo_u32 v13, v16, v17
; TONGA-NEXT:    v_mul_hi_u32 v15, v17, v8
; TONGA-NEXT:    v_mad_u64_u32 v[10:11], s[0:1], v18, v8, 0
; TONGA-NEXT:    v_add_u32_e32 v9, vcc, v12, v9
; TONGA-NEXT:    v_add_u32_e32 v9, vcc, v9, v13
; TONGA-NEXT:    v_mad_u64_u32 v[12:13], s[0:1], v17, v9, 0
; TONGA-NEXT:    v_mad_u64_u32 v[8:9], s[0:1], v18, v9, 0
; TONGA-NEXT:    v_add_u32_e32 v12, vcc, v15, v12
; TONGA-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; TONGA-NEXT:    v_add_u32_e32 v10, vcc, v12, v10
; TONGA-NEXT:    v_addc_u32_e32 v10, vcc, v13, v11, vcc
; TONGA-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; TONGA-NEXT:    v_add_u32_e32 v8, vcc, v10, v8
; TONGA-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; TONGA-NEXT:    v_add_u32_e32 v10, vcc, v17, v8
; TONGA-NEXT:    v_addc_u32_e32 v11, vcc, v18, v9, vcc
; TONGA-NEXT:    v_ashrrev_i32_e32 v12, 31, v5
; TONGA-NEXT:    v_add_u32_e32 v8, vcc, v4, v12
; TONGA-NEXT:    v_xor_b32_e32 v13, v8, v12
; TONGA-NEXT:    v_mad_u64_u32 v[8:9], s[0:1], v13, v11, 0
; TONGA-NEXT:    v_mul_hi_u32 v15, v13, v10
; TONGA-NEXT:    v_addc_u32_e32 v5, vcc, v5, v12, vcc
; TONGA-NEXT:    v_xor_b32_e32 v5, v5, v12
; TONGA-NEXT:    v_add_u32_e32 v15, vcc, v15, v8
; TONGA-NEXT:    v_addc_u32_e32 v16, vcc, 0, v9, vcc
; TONGA-NEXT:    v_mad_u64_u32 v[8:9], s[0:1], v5, v10, 0
; TONGA-NEXT:    v_mad_u64_u32 v[10:11], s[0:1], v5, v11, 0
; TONGA-NEXT:    v_add_u32_e32 v8, vcc, v15, v8
; TONGA-NEXT:    v_addc_u32_e32 v8, vcc, v16, v9, vcc
; TONGA-NEXT:    v_addc_u32_e32 v9, vcc, 0, v11, vcc
; TONGA-NEXT:    v_add_u32_e32 v10, vcc, v8, v10
; TONGA-NEXT:    v_addc_u32_e32 v8, vcc, 0, v9, vcc
; TONGA-NEXT:    v_mul_lo_u32 v11, v14, v8
; TONGA-NEXT:    v_mad_u64_u32 v[8:9], s[0:1], v14, v10, 0
; TONGA-NEXT:    v_mul_lo_u32 v10, v1, v10
; TONGA-NEXT:    v_add_u32_e32 v9, vcc, v11, v9
; TONGA-NEXT:    v_add_u32_e32 v9, vcc, v10, v9
; TONGA-NEXT:    v_sub_u32_e32 v10, vcc, v5, v9
; TONGA-NEXT:    v_sub_u32_e32 v8, vcc, v13, v8
; TONGA-NEXT:    v_subb_u32_e64 v10, s[0:1], v10, v1, vcc
; TONGA-NEXT:    v_sub_u32_e64 v11, s[0:1], v8, v14
; TONGA-NEXT:    v_subbrev_u32_e64 v13, s[2:3], 0, v10, s[0:1]
; TONGA-NEXT:    v_cmp_ge_u32_e64 s[2:3], v13, v1
; TONGA-NEXT:    v_cndmask_b32_e64 v15, 0, -1, s[2:3]
; TONGA-NEXT:    v_cmp_ge_u32_e64 s[2:3], v11, v14
; TONGA-NEXT:    v_cndmask_b32_e64 v16, 0, -1, s[2:3]
; TONGA-NEXT:    v_cmp_eq_u32_e64 s[2:3], v13, v1
; TONGA-NEXT:    v_subb_u32_e64 v10, s[0:1], v10, v1, s[0:1]
; TONGA-NEXT:    v_cndmask_b32_e64 v15, v15, v16, s[2:3]
; TONGA-NEXT:    v_sub_u32_e64 v16, s[0:1], v11, v14
; TONGA-NEXT:    v_subb_u32_e32 v5, vcc, v5, v9, vcc
; TONGA-NEXT:    v_subbrev_u32_e64 v10, s[0:1], 0, v10, s[0:1]
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v5, v1
; TONGA-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v15
; TONGA-NEXT:    v_cndmask_b32_e64 v9, 0, -1, vcc
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v8, v14
; TONGA-NEXT:    v_cndmask_b32_e64 v10, v13, v10, s[0:1]
; TONGA-NEXT:    v_cndmask_b32_e64 v13, 0, -1, vcc
; TONGA-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v1
; TONGA-NEXT:    v_cndmask_b32_e32 v1, v9, v13, vcc
; TONGA-NEXT:    v_cndmask_b32_e64 v11, v11, v16, s[0:1]
; TONGA-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; TONGA-NEXT:    v_cndmask_b32_e32 v1, v5, v10, vcc
; TONGA-NEXT:    v_cndmask_b32_e32 v5, v8, v11, vcc
; TONGA-NEXT:    v_xor_b32_e32 v5, v5, v12
; TONGA-NEXT:    v_xor_b32_e32 v1, v1, v12
; TONGA-NEXT:    v_sub_u32_e32 v8, vcc, v5, v12
; TONGA-NEXT:    v_subb_u32_e32 v9, vcc, v1, v12, vcc
; TONGA-NEXT:    s_cbranch_execnz .LBB10_3
; TONGA-NEXT:  .LBB10_2:
; TONGA-NEXT:    v_cvt_f32_u32_e32 v1, v0
; TONGA-NEXT:    v_sub_u32_e32 v5, vcc, 0, v0
; TONGA-NEXT:    v_mov_b32_e32 v9, 0
; TONGA-NEXT:    v_rcp_iflag_f32_e32 v1, v1
; TONGA-NEXT:    v_mul_f32_e32 v1, 0x4f7ffffe, v1
; TONGA-NEXT:    v_cvt_u32_f32_e32 v1, v1
; TONGA-NEXT:    v_mul_lo_u32 v5, v5, v1
; TONGA-NEXT:    v_mul_hi_u32 v5, v1, v5
; TONGA-NEXT:    v_add_u32_e32 v1, vcc, v1, v5
; TONGA-NEXT:    v_mul_hi_u32 v1, v4, v1
; TONGA-NEXT:    v_mul_lo_u32 v1, v1, v0
; TONGA-NEXT:    v_sub_u32_e32 v1, vcc, v4, v1
; TONGA-NEXT:    v_subrev_u32_e32 v4, vcc, v0, v1
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v1, v0
; TONGA-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; TONGA-NEXT:    v_sub_u32_e32 v4, vcc, v1, v0
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v1, v0
; TONGA-NEXT:    v_cndmask_b32_e32 v8, v1, v4, vcc
; TONGA-NEXT:  .LBB10_3:
; TONGA-NEXT:    v_or_b32_e32 v1, v7, v3
; TONGA-NEXT:    v_mov_b32_e32 v0, 0
; TONGA-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; TONGA-NEXT:    s_cbranch_vccz .LBB10_8
; TONGA-NEXT:  ; %bb.4:
; TONGA-NEXT:    v_ashrrev_i32_e32 v0, 31, v3
; TONGA-NEXT:    v_add_u32_e32 v1, vcc, v2, v0
; TONGA-NEXT:    v_addc_u32_e32 v3, vcc, v3, v0, vcc
; TONGA-NEXT:    v_xor_b32_e32 v5, v1, v0
; TONGA-NEXT:    v_xor_b32_e32 v12, v3, v0
; TONGA-NEXT:    v_cvt_f32_u32_e32 v0, v5
; TONGA-NEXT:    v_cvt_f32_u32_e32 v1, v12
; TONGA-NEXT:    v_sub_u32_e32 v13, vcc, 0, v5
; TONGA-NEXT:    v_subb_u32_e32 v14, vcc, 0, v12, vcc
; TONGA-NEXT:    v_madmk_f32 v0, v1, 0x4f800000, v0
; TONGA-NEXT:    v_rcp_f32_e32 v0, v0
; TONGA-NEXT:    v_mul_f32_e32 v0, 0x5f7ffffc, v0
; TONGA-NEXT:    v_mul_f32_e32 v1, 0x2f800000, v0
; TONGA-NEXT:    v_trunc_f32_e32 v1, v1
; TONGA-NEXT:    v_madmk_f32 v0, v1, 0xcf800000, v0
; TONGA-NEXT:    v_cvt_u32_f32_e32 v10, v1
; TONGA-NEXT:    v_cvt_u32_f32_e32 v11, v0
; TONGA-NEXT:    v_mul_lo_u32 v3, v13, v10
; TONGA-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v13, v11, 0
; TONGA-NEXT:    v_mul_lo_u32 v4, v14, v11
; TONGA-NEXT:    v_add_u32_e32 v1, vcc, v1, v3
; TONGA-NEXT:    v_add_u32_e32 v15, vcc, v1, v4
; TONGA-NEXT:    v_mad_u64_u32 v[3:4], s[0:1], v11, v15, 0
; TONGA-NEXT:    v_mul_hi_u32 v1, v11, v0
; TONGA-NEXT:    v_add_u32_e32 v16, vcc, v1, v3
; TONGA-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v10, v0, 0
; TONGA-NEXT:    v_addc_u32_e32 v17, vcc, 0, v4, vcc
; TONGA-NEXT:    v_mad_u64_u32 v[3:4], s[0:1], v10, v15, 0
; TONGA-NEXT:    v_add_u32_e32 v0, vcc, v16, v0
; TONGA-NEXT:    v_addc_u32_e32 v0, vcc, v17, v1, vcc
; TONGA-NEXT:    v_addc_u32_e32 v1, vcc, 0, v4, vcc
; TONGA-NEXT:    v_add_u32_e32 v0, vcc, v0, v3
; TONGA-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; TONGA-NEXT:    v_add_u32_e32 v15, vcc, v11, v0
; TONGA-NEXT:    v_addc_u32_e32 v16, vcc, v10, v1, vcc
; TONGA-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v13, v15, 0
; TONGA-NEXT:    v_mul_lo_u32 v10, v13, v16
; TONGA-NEXT:    v_mul_lo_u32 v11, v14, v15
; TONGA-NEXT:    v_mul_hi_u32 v13, v15, v0
; TONGA-NEXT:    v_mad_u64_u32 v[3:4], s[0:1], v16, v0, 0
; TONGA-NEXT:    v_add_u32_e32 v1, vcc, v10, v1
; TONGA-NEXT:    v_add_u32_e32 v1, vcc, v1, v11
; TONGA-NEXT:    v_mad_u64_u32 v[10:11], s[0:1], v15, v1, 0
; TONGA-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v16, v1, 0
; TONGA-NEXT:    v_add_u32_e32 v10, vcc, v13, v10
; TONGA-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; TONGA-NEXT:    v_add_u32_e32 v3, vcc, v10, v3
; TONGA-NEXT:    v_addc_u32_e32 v3, vcc, v11, v4, vcc
; TONGA-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; TONGA-NEXT:    v_add_u32_e32 v0, vcc, v3, v0
; TONGA-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; TONGA-NEXT:    v_add_u32_e32 v3, vcc, v15, v0
; TONGA-NEXT:    v_addc_u32_e32 v4, vcc, v16, v1, vcc
; TONGA-NEXT:    v_ashrrev_i32_e32 v11, 31, v7
; TONGA-NEXT:    v_add_u32_e32 v0, vcc, v6, v11
; TONGA-NEXT:    v_xor_b32_e32 v10, v0, v11
; TONGA-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v10, v4, 0
; TONGA-NEXT:    v_mul_hi_u32 v13, v10, v3
; TONGA-NEXT:    v_addc_u32_e32 v7, vcc, v7, v11, vcc
; TONGA-NEXT:    v_xor_b32_e32 v7, v7, v11
; TONGA-NEXT:    v_add_u32_e32 v13, vcc, v13, v0
; TONGA-NEXT:    v_addc_u32_e32 v14, vcc, 0, v1, vcc
; TONGA-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v7, v3, 0
; TONGA-NEXT:    v_mad_u64_u32 v[3:4], s[0:1], v7, v4, 0
; TONGA-NEXT:    v_add_u32_e32 v0, vcc, v13, v0
; TONGA-NEXT:    v_addc_u32_e32 v0, vcc, v14, v1, vcc
; TONGA-NEXT:    v_addc_u32_e32 v1, vcc, 0, v4, vcc
; TONGA-NEXT:    v_add_u32_e32 v3, vcc, v0, v3
; TONGA-NEXT:    v_addc_u32_e32 v0, vcc, 0, v1, vcc
; TONGA-NEXT:    v_mul_lo_u32 v4, v5, v0
; TONGA-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v5, v3, 0
; TONGA-NEXT:    v_mul_lo_u32 v3, v12, v3
; TONGA-NEXT:    v_add_u32_e32 v1, vcc, v4, v1
; TONGA-NEXT:    v_add_u32_e32 v1, vcc, v3, v1
; TONGA-NEXT:    v_sub_u32_e32 v3, vcc, v7, v1
; TONGA-NEXT:    v_sub_u32_e32 v0, vcc, v10, v0
; TONGA-NEXT:    v_subb_u32_e64 v3, s[0:1], v3, v12, vcc
; TONGA-NEXT:    v_sub_u32_e64 v4, s[0:1], v0, v5
; TONGA-NEXT:    v_subbrev_u32_e64 v10, s[2:3], 0, v3, s[0:1]
; TONGA-NEXT:    v_cmp_ge_u32_e64 s[2:3], v10, v12
; TONGA-NEXT:    v_cndmask_b32_e64 v13, 0, -1, s[2:3]
; TONGA-NEXT:    v_cmp_ge_u32_e64 s[2:3], v4, v5
; TONGA-NEXT:    v_subb_u32_e32 v1, vcc, v7, v1, vcc
; TONGA-NEXT:    v_cndmask_b32_e64 v14, 0, -1, s[2:3]
; TONGA-NEXT:    v_cmp_eq_u32_e64 s[2:3], v10, v12
; TONGA-NEXT:    v_subb_u32_e64 v3, s[0:1], v3, v12, s[0:1]
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v1, v12
; TONGA-NEXT:    v_cndmask_b32_e64 v13, v13, v14, s[2:3]
; TONGA-NEXT:    v_sub_u32_e64 v14, s[0:1], v4, v5
; TONGA-NEXT:    v_cndmask_b32_e64 v7, 0, -1, vcc
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v5
; TONGA-NEXT:    v_subbrev_u32_e64 v3, s[0:1], 0, v3, s[0:1]
; TONGA-NEXT:    v_cndmask_b32_e64 v5, 0, -1, vcc
; TONGA-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v12
; TONGA-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v13
; TONGA-NEXT:    v_cndmask_b32_e32 v5, v7, v5, vcc
; TONGA-NEXT:    v_cndmask_b32_e64 v4, v4, v14, s[0:1]
; TONGA-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v5
; TONGA-NEXT:    v_cndmask_b32_e64 v3, v10, v3, s[0:1]
; TONGA-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; TONGA-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; TONGA-NEXT:    v_xor_b32_e32 v0, v0, v11
; TONGA-NEXT:    v_xor_b32_e32 v1, v1, v11
; TONGA-NEXT:    v_sub_u32_e32 v10, vcc, v0, v11
; TONGA-NEXT:    v_subb_u32_e32 v11, vcc, v1, v11, vcc
; TONGA-NEXT:    s_cbranch_execnz .LBB10_6
; TONGA-NEXT:  .LBB10_5:
; TONGA-NEXT:    v_cvt_f32_u32_e32 v0, v2
; TONGA-NEXT:    v_sub_u32_e32 v1, vcc, 0, v2
; TONGA-NEXT:    v_mov_b32_e32 v11, 0
; TONGA-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; TONGA-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; TONGA-NEXT:    v_cvt_u32_f32_e32 v0, v0
; TONGA-NEXT:    v_mul_lo_u32 v1, v1, v0
; TONGA-NEXT:    v_mul_hi_u32 v1, v0, v1
; TONGA-NEXT:    v_add_u32_e32 v0, vcc, v0, v1
; TONGA-NEXT:    v_mul_hi_u32 v0, v6, v0
; TONGA-NEXT:    v_mul_lo_u32 v0, v0, v2
; TONGA-NEXT:    v_sub_u32_e32 v0, vcc, v6, v0
; TONGA-NEXT:    v_subrev_u32_e32 v1, vcc, v2, v0
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v2
; TONGA-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; TONGA-NEXT:    v_subrev_u32_e32 v1, vcc, v2, v0
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v2
; TONGA-NEXT:    v_cndmask_b32_e32 v10, v0, v1, vcc
; TONGA-NEXT:  .LBB10_6:
; TONGA-NEXT:    v_mov_b32_e32 v0, s4
; TONGA-NEXT:    v_mov_b32_e32 v1, s5
; TONGA-NEXT:    flat_store_dwordx4 v[0:1], v[8:11]
; TONGA-NEXT:    s_endpgm
; TONGA-NEXT:  .LBB10_7:
; TONGA-NEXT:    ; implicit-def: $vgpr8_vgpr9
; TONGA-NEXT:    s_branch .LBB10_2
; TONGA-NEXT:  .LBB10_8:
; TONGA-NEXT:    s_branch .LBB10_5
;
; EG-LABEL: srem_v2i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @18, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @14
; EG-NEXT:    ALU 112, @19, KC0[], KC1[]
; EG-NEXT:    ALU 111, @132, KC0[], KC1[]
; EG-NEXT:    ALU 112, @244, KC0[], KC1[]
; EG-NEXT:    ALU 111, @357, KC0[], KC1[]
; EG-NEXT:    ALU 112, @469, KC0[], KC1[]
; EG-NEXT:    ALU 112, @582, KC0[], KC1[]
; EG-NEXT:    ALU 111, @695, KC0[], KC1[]
; EG-NEXT:    ALU 112, @807, KC0[], KC1[]
; EG-NEXT:    ALU 112, @920, KC0[], KC1[]
; EG-NEXT:    ALU 47, @1033, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T5.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 14:
; EG-NEXT:     VTX_READ_128 T4.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 18:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 19:
; EG-NEXT:     ASHR * T5.W, T4.Y, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ADD_INT T0.W, T4.X, PV.W,
; EG-NEXT:     ASHR * T6.W, T4.W, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     XOR_INT * T2.W, PV.W, T5.W,
; EG-NEXT:     SUB_INT T0.Z, 0.0, PV.W,
; EG-NEXT:     ADD_INT T0.W, T4.Z, T6.W,
; EG-NEXT:     RECIP_UINT * T0.X, PV.W,
; EG-NEXT:     XOR_INT T3.W, PV.W, T6.W,
; EG-NEXT:     MULLO_INT * T0.Y, PV.Z, PS,
; EG-NEXT:     SUB_INT T0.Z, 0.0, PV.W,
; EG-NEXT:     ASHR T0.W, T1.W, literal.x,
; EG-NEXT:     RECIP_UINT * T2.X, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ADD_INT T2.Y, T1.W, PV.W,
; EG-NEXT:     ADDC_UINT T2.Z, T1.Z, PV.W,
; EG-NEXT:     ASHR T1.W, T1.Y, literal.x,
; EG-NEXT:     MULLO_INT * T0.Z, PV.Z, PS,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ADD_INT T1.Y, T1.Y, PV.W,
; EG-NEXT:     ADDC_UINT T3.Z, T1.X, PV.W,
; EG-NEXT:     ADD_INT T7.W, PV.Y, PV.Z,
; EG-NEXT:     MULHI * T0.Z, T2.X, PS,
; EG-NEXT:     ADD_INT T2.Y, T2.X, PS,
; EG-NEXT:     XOR_INT T0.Z, PV.W, T0.W,
; EG-NEXT:     ADD_INT T7.W, PV.Y, PV.Z,
; EG-NEXT:     MULHI * T0.Y, T0.X, T0.Y,
; EG-NEXT:     ADD_INT T2.Z, T0.X, PS,
; EG-NEXT:     XOR_INT T7.W, PV.W, T1.W,
; EG-NEXT:     MULHI * T0.X, PV.Z, PV.Y,
; EG-NEXT:     MULHI * T0.Y, PV.W, PV.Z,
; EG-NEXT:     MULLO_INT * T0.Y, PS, T2.W,
; EG-NEXT:     SUB_INT T8.W, T7.W, PS,
; EG-NEXT:     MULLO_INT * T0.X, T0.X, T3.W,
; EG-NEXT:     SETGE_UINT T2.X, PV.W, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T0.Y, PV.W, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T2.Z, T0.Z, PS,
; EG-NEXT:     ADD_INT T9.W, T4.Y, T5.W,
; EG-NEXT:     ADDC_UINT * T10.W, T4.X, T5.W,
; EG-NEXT:     ADD_INT T1.Y, PV.W, PS,
; EG-NEXT:     SETGE_UINT T3.Z, PV.Z, T3.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T9.W, PV.Z, T3.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T8.W, PV.X, T8.W, PV.Y,
; EG-NEXT:     SETGE_UINT T0.X, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T0.Y, PS, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T2.Z, PV.Z, T2.Z, PV.W,
; EG-NEXT:     ADD_INT T4.W, T4.W, T6.W,
; EG-NEXT:     ADDC_UINT * T9.W, T4.Z, T6.W,
; EG-NEXT:     ADD_INT T2.X, PV.W, PS,
; EG-NEXT:     SETGE_UINT T2.Y, PV.Z, T3.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T3.Z, PV.Z, T3.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T8.W, PV.X, T8.W, PV.Y, BS:VEC_102/SCL_221
; EG-NEXT:     XOR_INT * T4.W, T1.Y, T5.W,
; EG-NEXT:     CNDE_INT T0.X, PS, PV.W, T7.W,
; EG-NEXT:     ADD_INT T1.Y, T1.Z, T0.W,
; EG-NEXT:     CNDE_INT T1.Z, PV.Y, T2.Z, PV.Z,
; EG-NEXT:     XOR_INT * T5.W, PV.X, T6.W, BS:VEC_102/SCL_221
; EG-NEXT:     ADD_INT * T6.W, T1.X, T1.W,
; EG-NEXT:     XOR_INT T0.Y, PV.W, T1.W,
; EG-NEXT:     CNDE_INT T0.Z, T5.W, T1.Z, T0.Z,
; EG-NEXT:     XOR_INT T6.W, T1.Y, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     LSHR * T7.W, T0.X, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T1.Y, PS, T4.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.Z, PV.W, literal.x,
; EG-NEXT:     BIT_ALIGN_INT T8.W, T0.X, PV.Y, literal.x,
; EG-NEXT:     LSHR * T9.W, PV.Z, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T0.X, T7.W, T4.W,
; EG-NEXT:     SETGE_UINT * T2.Y, PV.W, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T0.Z, T9.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T10.W, T9.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT * T11.W, T1.Z, T3.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.Z, PV.W, PS,
; EG-NEXT:     SUB_INT T0.Z, T1.Z, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     CNDE_INT T10.W, T1.Y, T0.X, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T8.W, T2.W,
; EG-NEXT:     SUB_INT * T0.X, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT * T1.Y, T8.W, T2.W,
; EG-NEXT:     SUB_INT T2.Z, T9.W, T5.W,
; EG-NEXT:     SUBB_UINT * T12.W, T1.Z, T3.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T8.W, T10.W, T8.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T2.Z, T12.W, BS:VEC_201
; EG-NEXT:     SUB_INT T11.W, T0.X, T1.Y,
; EG-NEXT:     CNDE_INT * T12.W, T3.Y, T1.Z, T0.Z,
; EG-NEXT:    30(4.203895e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T0.Z, T10.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:    30(4.203895e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T9.W, T2.Z,
; EG-NEXT:     OR_INT * T9.W, T1.X, T2.Y,
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T12.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, T0.Z, T8.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, T0.X, T1.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T10.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T10.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T9.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T9.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:    ALU clause starting at 132:
; EG-NEXT:     CNDE_INT * T9.W, T10.W, T9.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    29(4.063766e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T10.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T10.W, PV.X, PV.Y,
; EG-NEXT:    29(4.063766e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T9.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T9.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T9.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T10.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T10.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T10.W, T9.W, T10.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    28(3.923636e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T9.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T9.W, PV.X, PV.Y,
; EG-NEXT:    28(3.923636e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T10.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T10.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T10.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T9.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T9.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T9.W, T10.W, T9.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    27(3.783506e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T10.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T10.W, PV.X, PV.Y,
; EG-NEXT:    27(3.783506e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T9.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T9.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T9.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T10.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T10.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T10.W, T9.W, T10.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    26(3.643376e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T9.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T9.W, PV.X, PV.Y,
; EG-NEXT:    26(3.643376e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T10.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT * T0.X, PV.W, T4.W,
; EG-NEXT:    ALU clause starting at 244:
; EG-NEXT:     SETGE_UINT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SETGE_UINT T0.Z, T8.W, T3.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T10.W, T1.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, T1.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T10.W, T0.X, T1.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T9.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T9.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T9.W, T10.W, T9.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    25(3.503246e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T10.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T10.W, PV.X, PV.Y,
; EG-NEXT:    25(3.503246e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T9.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T9.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T9.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T10.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T10.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T10.W, T9.W, T10.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    24(3.363116e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T9.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T9.W, PV.X, PV.Y,
; EG-NEXT:    24(3.363116e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T10.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T10.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T10.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T9.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T9.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T9.W, T10.W, T9.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    23(3.222986e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T10.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T10.W, PV.X, PV.Y,
; EG-NEXT:    23(3.222986e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T9.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T9.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T9.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T10.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T10.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T10.W, T9.W, T10.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    22(3.082857e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL * T0.X, PS, 1,
; EG-NEXT:    ALU clause starting at 357:
; EG-NEXT:     BFE_UINT * T1.Y, T6.W, literal.x, 1,
; EG-NEXT:    22(3.082857e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.Z, T9.W, T7.W, T11.W,
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, T2.Z,
; EG-NEXT:     OR_INT * T9.W, T1.X, T2.Y,
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T10.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, T0.X, T1.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T10.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T10.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T9.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T9.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T9.W, T10.W, T9.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    21(2.942727e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T10.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T10.W, PV.X, PV.Y,
; EG-NEXT:    21(2.942727e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T9.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T9.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T9.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T10.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T10.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T10.W, T9.W, T10.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    20(2.802597e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T9.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T9.W, PV.X, PV.Y,
; EG-NEXT:    20(2.802597e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T10.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T10.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T10.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T9.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T9.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T9.W, T10.W, T9.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    19(2.662467e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T10.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T10.W, PV.X, PV.Y,
; EG-NEXT:    19(2.662467e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T9.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T9.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T9.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T10.W, T2.W,
; EG-NEXT:    ALU clause starting at 469:
; EG-NEXT:     SUBB_UINT * T0.X, T10.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T10.W, T9.W, T10.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    18(2.522337e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T9.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T9.W, PV.X, PV.Y,
; EG-NEXT:    18(2.522337e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T10.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T10.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T10.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T9.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T9.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T9.W, T10.W, T9.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    17(2.382207e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T10.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T10.W, PV.X, PV.Y,
; EG-NEXT:    17(2.382207e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T9.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T9.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T9.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T10.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T10.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T10.W, T9.W, T10.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T9.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T9.W, PV.X, PV.Y,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T10.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T10.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T10.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T9.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T9.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T9.W, T10.W, T9.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    15(2.101948e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T10.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T10.W, PV.X, PV.Y,
; EG-NEXT:    15(2.101948e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT * T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 582:
; EG-NEXT:     BIT_ALIGN_INT T7.W, T0.Z, T9.W, literal.x,
; EG-NEXT:     OR_INT * T8.W, T0.X, T1.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T9.W, T1.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, T1.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T9.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T10.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T10.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T10.W, T9.W, T10.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    14(1.961818e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T9.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T9.W, PV.X, PV.Y,
; EG-NEXT:    14(1.961818e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T10.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T10.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T10.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T9.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T9.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T9.W, T10.W, T9.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    13(1.821688e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T10.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T10.W, PV.X, PV.Y,
; EG-NEXT:    13(1.821688e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T9.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T9.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T9.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T10.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T10.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T10.W, T9.W, T10.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    12(1.681558e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T9.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T9.W, PV.X, PV.Y,
; EG-NEXT:    12(1.681558e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T10.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T10.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T10.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T9.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T9.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T9.W, T10.W, T9.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT * T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:    11(1.541428e-44), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 695:
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X,
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T10.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T10.W, T1.X, T2.Y,
; EG-NEXT:    11(1.541428e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T9.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T9.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T9.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T10.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T10.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T10.W, T9.W, T10.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    10(1.401298e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T9.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T9.W, PV.X, PV.Y,
; EG-NEXT:    10(1.401298e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T10.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T10.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T10.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T9.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T9.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T9.W, T10.W, T9.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    9(1.261169e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T10.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T10.W, PV.X, PV.Y,
; EG-NEXT:    9(1.261169e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T9.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T9.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T9.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T10.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T10.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T10.W, T9.W, T10.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    8(1.121039e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T9.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T9.W, PV.X, PV.Y,
; EG-NEXT:    8(1.121039e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T10.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T10.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:    ALU clause starting at 807:
; EG-NEXT:     CNDE_INT * T3.Y, T10.W, T11.W, T0.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T10.W, T0.X, T1.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T9.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T9.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T9.W, T10.W, T9.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    7(9.809089e-45), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T10.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T10.W, PV.X, PV.Y,
; EG-NEXT:    7(9.809089e-45), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T9.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T9.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T9.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T10.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T10.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T10.W, T9.W, T10.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    6(8.407791e-45), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T9.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T9.W, PV.X, PV.Y,
; EG-NEXT:    6(8.407791e-45), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T10.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T10.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T10.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T9.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T9.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T9.W, T10.W, T9.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    5(7.006492e-45), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T10.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T10.W, PV.X, PV.Y,
; EG-NEXT:    5(7.006492e-45), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T9.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T9.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T9.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T10.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T10.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T10.W, T9.W, T10.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    4(5.605194e-45), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T9.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:    4(5.605194e-45), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 920:
; EG-NEXT:     OR_INT * T9.W, T1.X, T2.Y,
; EG-NEXT:     SETGE_UINT T2.Y, PV.W, T2.W,
; EG-NEXT:     BIT_ALIGN_INT * T1.Z, T7.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T7.W, T0.Z, T10.W, literal.x,
; EG-NEXT:     OR_INT * T8.W, T0.X, T1.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T10.W, T1.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, T1.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T10.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T9.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T9.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T9.W, T10.W, T9.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T10.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T10.W, PV.X, PV.Y,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T9.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T9.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T9.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T10.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T10.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T10.W, T9.W, T10.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, literal.x, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T0.Z, T9.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T9.W, PV.X, PV.Y,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T10.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T10.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T3.W,
; EG-NEXT:     CNDE_INT * T10.W, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT * T11.W, T9.W, T2.W,
; EG-NEXT:     SUBB_UINT * T0.X, T9.W, T2.W,
; EG-NEXT:     SUB_INT * T1.Y, T7.W, T4.W,
; EG-NEXT:     SUBB_UINT T2.Z, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T12.W, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T9.W, T10.W, T9.W, T11.W,
; EG-NEXT:     LSHL T1.X, PV.W, 1,
; EG-NEXT:     BFE_UINT T2.Y, T0.Y, 1, 1,
; EG-NEXT:     SUB_INT T2.Z, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T0.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:     LSHL T0.X, PS, 1,
; EG-NEXT:     BFE_UINT T1.Y, T6.W, 1, 1,
; EG-NEXT:     CNDE_INT T0.Z, T10.W, T7.W, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, T3.Y, T1.Z, PV.Z,
; EG-NEXT:     OR_INT * T10.W, PV.X, PV.Y,
; EG-NEXT:     SETGE_UINT T2.Y, PS, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T9.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T8.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T0.X, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PS, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T9.W, PV.Z, T5.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T5.W,
; EG-NEXT:     CNDE_INT T1.X, PV.W, PS, PV.Z,
; EG-NEXT:     CNDE_INT T1.Y, PV.X, PV.Y, T2.Y,
; EG-NEXT:     SUB_INT T0.Z, T10.W, T2.W,
; EG-NEXT:     SUBB_UINT * T9.W, T10.W, T2.W,
; EG-NEXT:     SUB_INT * T11.W, T7.W, T4.W,
; EG-NEXT:     SUB_INT T0.X, T8.W, T3.W,
; EG-NEXT:     SUBB_UINT T2.Y, T8.W, T3.W,
; EG-NEXT:     SUB_INT * T2.Z, T1.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T9.W, T11.W, T9.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T10.W, T1.Y, T10.W, T0.Z,
; EG-NEXT:    ALU clause starting at 1033:
; EG-NEXT:     LSHL T2.X, T10.W, 1,
; EG-NEXT:     AND_INT T0.Y, T0.Y, 1, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T0.Z, T1.Y, T7.W, T9.W,
; EG-NEXT:     SUB_INT * T7.W, T2.Z, T2.Y, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T8.W, T1.X, T8.W, T0.X,
; EG-NEXT:     LSHL T0.X, PV.W, 1,
; EG-NEXT:     AND_INT T1.Y, T6.W, 1,
; EG-NEXT:     CNDE_INT T1.Z, T1.X, T1.Z, T7.W,
; EG-NEXT:     BIT_ALIGN_INT T6.W, T0.Z, T10.W, literal.x,
; EG-NEXT:     OR_INT * T7.W, T2.X, T0.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T1.X, PS, T2.W,
; EG-NEXT:     SETE_INT T0.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T0.Z, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T8.W, PV.Z, T8.W, literal.x, BS:VEC_102/SCL_221
; EG-NEXT:     OR_INT * T9.W, PV.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T0.X, PS, T3.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T1.Y, PV.W, T5.W,
; EG-NEXT:     SETGE_UINT T1.Z, PV.W, T5.W,
; EG-NEXT:     SUBB_UINT T10.W, PS, T3.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT * T5.W, PV.W, T5.W,
; EG-NEXT:     SUBB_UINT * T2.X, T7.W, T2.W,
; EG-NEXT:     SUB_INT * T2.Y, T6.W, T4.W,
; EG-NEXT:     SUB_INT * T2.Z, T9.W, T3.W,
; EG-NEXT:     SUB_INT T3.W, T5.W, T10.W,
; EG-NEXT:     CNDE_INT * T4.W, T1.Y, T1.Z, T0.X,
; EG-NEXT:     CNDE_INT T0.X, PS, T8.W, PV.W,
; EG-NEXT:     CNDE_INT * T1.Y, PS, T9.W, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T1.Z, T7.W, T2.W,
; EG-NEXT:     SUB_INT T2.W, T2.Y, T2.X,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T0.Z, T1.X,
; EG-NEXT:     CNDE_INT T0.Y, PS, T6.W, PV.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T0.Z, PS, T7.W, PV.Z, BS:VEC_102/SCL_221
; EG-NEXT:     XOR_INT T2.W, T1.Y, T0.W,
; EG-NEXT:     XOR_INT * T3.W, T0.X, T0.W,
; EG-NEXT:     SUB_INT T1.Y, PS, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUBB_UINT T1.Z, PV.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     XOR_INT T3.W, PV.Z, T1.W,
; EG-NEXT:     XOR_INT * T4.W, PV.Y, T1.W,
; EG-NEXT:     SUB_INT T0.Z, PS, T1.W,
; EG-NEXT:     SUBB_UINT T4.W, PV.W, T1.W,
; EG-NEXT:     SUB_INT * T5.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT T5.Y, PV.Z, PV.W,
; EG-NEXT:     SUB_INT * T5.Z, T2.W, T0.W,
; EG-NEXT:     SUB_INT T5.X, T3.W, T1.W,
; EG-NEXT:     LSHR * T0.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %den_ptr = getelementptr <2 x i64>, ptr addrspace(1) %in, i64 1
  %num = load <2 x i64>, ptr addrspace(1) %in
  %den = load <2 x i64>, ptr addrspace(1) %den_ptr
  %result = srem <2 x i64> %num, %den
  store <2 x i64> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @srem_v2i64_4(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; GCN-LABEL: srem_v2i64_4:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v4, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    global_load_dwordx4 v[0:3], v4, s[2:3]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_ashrrev_i32_e32 v5, 31, v1
; GCN-NEXT:    v_lshrrev_b32_e32 v5, 30, v5
; GCN-NEXT:    v_ashrrev_i32_e32 v6, 31, v3
; GCN-NEXT:    v_add_co_u32_e32 v5, vcc, v0, v5
; GCN-NEXT:    v_lshrrev_b32_e32 v6, 30, v6
; GCN-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v1, vcc
; GCN-NEXT:    v_add_co_u32_e32 v6, vcc, v2, v6
; GCN-NEXT:    v_addc_co_u32_e32 v8, vcc, 0, v3, vcc
; GCN-NEXT:    v_and_b32_e32 v5, -4, v5
; GCN-NEXT:    v_sub_co_u32_e32 v0, vcc, v0, v5
; GCN-NEXT:    v_and_b32_e32 v6, -4, v6
; GCN-NEXT:    v_subb_co_u32_e32 v1, vcc, v1, v7, vcc
; GCN-NEXT:    v_sub_co_u32_e32 v2, vcc, v2, v6
; GCN-NEXT:    v_subb_co_u32_e32 v3, vcc, v3, v8, vcc
; GCN-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GCN-NEXT:    s_endpgm
;
; TAHITI-LABEL: srem_v2i64_4:
; TAHITI:       ; %bb.0:
; TAHITI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; TAHITI-NEXT:    s_mov_b32 s7, 0xf000
; TAHITI-NEXT:    s_mov_b32 s6, -1
; TAHITI-NEXT:    s_mov_b32 s10, s6
; TAHITI-NEXT:    s_mov_b32 s11, s7
; TAHITI-NEXT:    s_waitcnt lgkmcnt(0)
; TAHITI-NEXT:    s_mov_b32 s8, s2
; TAHITI-NEXT:    s_mov_b32 s9, s3
; TAHITI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; TAHITI-NEXT:    s_mov_b32 s4, s0
; TAHITI-NEXT:    s_mov_b32 s5, s1
; TAHITI-NEXT:    s_waitcnt vmcnt(0)
; TAHITI-NEXT:    v_ashrrev_i32_e32 v4, 31, v1
; TAHITI-NEXT:    v_lshrrev_b32_e32 v4, 30, v4
; TAHITI-NEXT:    v_ashrrev_i32_e32 v5, 31, v3
; TAHITI-NEXT:    v_add_i32_e32 v4, vcc, v0, v4
; TAHITI-NEXT:    v_lshrrev_b32_e32 v5, 30, v5
; TAHITI-NEXT:    v_addc_u32_e32 v6, vcc, 0, v1, vcc
; TAHITI-NEXT:    v_add_i32_e32 v5, vcc, v2, v5
; TAHITI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v3, vcc
; TAHITI-NEXT:    v_and_b32_e32 v4, -4, v4
; TAHITI-NEXT:    v_sub_i32_e32 v0, vcc, v0, v4
; TAHITI-NEXT:    v_and_b32_e32 v5, -4, v5
; TAHITI-NEXT:    v_subb_u32_e32 v1, vcc, v1, v6, vcc
; TAHITI-NEXT:    v_sub_i32_e32 v2, vcc, v2, v5
; TAHITI-NEXT:    v_subb_u32_e32 v3, vcc, v3, v7, vcc
; TAHITI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; TAHITI-NEXT:    s_endpgm
;
; TONGA-LABEL: srem_v2i64_4:
; TONGA:       ; %bb.0:
; TONGA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; TONGA-NEXT:    s_waitcnt lgkmcnt(0)
; TONGA-NEXT:    v_mov_b32_e32 v0, s2
; TONGA-NEXT:    v_mov_b32_e32 v1, s3
; TONGA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; TONGA-NEXT:    v_mov_b32_e32 v4, s0
; TONGA-NEXT:    v_mov_b32_e32 v5, s1
; TONGA-NEXT:    s_waitcnt vmcnt(0)
; TONGA-NEXT:    v_ashrrev_i32_e32 v6, 31, v1
; TONGA-NEXT:    v_lshrrev_b32_e32 v6, 30, v6
; TONGA-NEXT:    v_ashrrev_i32_e32 v7, 31, v3
; TONGA-NEXT:    v_add_u32_e32 v6, vcc, v0, v6
; TONGA-NEXT:    v_lshrrev_b32_e32 v7, 30, v7
; TONGA-NEXT:    v_addc_u32_e32 v8, vcc, 0, v1, vcc
; TONGA-NEXT:    v_add_u32_e32 v7, vcc, v2, v7
; TONGA-NEXT:    v_addc_u32_e32 v9, vcc, 0, v3, vcc
; TONGA-NEXT:    v_and_b32_e32 v6, -4, v6
; TONGA-NEXT:    v_sub_u32_e32 v0, vcc, v0, v6
; TONGA-NEXT:    v_and_b32_e32 v7, -4, v7
; TONGA-NEXT:    v_subb_u32_e32 v1, vcc, v1, v8, vcc
; TONGA-NEXT:    v_sub_u32_e32 v2, vcc, v2, v7
; TONGA-NEXT:    v_subb_u32_e32 v3, vcc, v3, v9, vcc
; TONGA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; TONGA-NEXT:    s_endpgm
;
; EG-LABEL: srem_v2i64_4:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 24, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T3.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     ASHR T0.W, T0.W, literal.x,
; EG-NEXT:     ASHR * T1.W, T0.Y, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR * T0.W, PV.W, literal.x,
; EG-NEXT:    30(4.203895e-44), 0(0.000000e+00)
; EG-NEXT:     ADD_INT T2.W, T0.Z, PV.W,
; EG-NEXT:     LSHR * T1.W, T1.W, literal.x,
; EG-NEXT:    30(4.203895e-44), 0(0.000000e+00)
; EG-NEXT:     ADD_INT T1.Z, T0.X, PS,
; EG-NEXT:     ADDC_UINT T0.W, T0.Z, T0.W,
; EG-NEXT:     AND_INT * T2.W, PV.W, literal.x,
; EG-NEXT:    -4(nan), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T0.Y, T0.Z, PS,
; EG-NEXT:     BFE_INT T2.Z, PV.W, 0.0, 1,
; EG-NEXT:     ADDC_UINT T0.W, T0.X, T1.W,
; EG-NEXT:     AND_INT * T1.W, PV.Z, literal.x,
; EG-NEXT:    -4(nan), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T1.Z, T0.X, PS,
; EG-NEXT:     BFE_INT T0.W, PV.W, 0.0, 1,
; EG-NEXT:     SUB_INT * T3.W, PV.Z, PV.Y,
; EG-NEXT:     SUB_INT T3.Y, PV.W, PV.Z,
; EG-NEXT:     SUB_INT * T3.Z, T0.Z, T2.W,
; EG-NEXT:     SUB_INT T3.X, T0.X, T1.W,
; EG-NEXT:     LSHR * T0.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %num = load <2 x i64>, ptr addrspace(1) %in
  %result = srem <2 x i64> %num, <i64 4, i64 4>
  store <2 x i64> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @srem_v4i64(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; GCN-LABEL: srem_v4i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v8, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    global_load_dwordx4 v[10:13], v8, s[10:11] offset:32
; GCN-NEXT:    global_load_dwordx4 v[14:17], v8, s[10:11]
; GCN-NEXT:    global_load_dwordx4 v[0:3], v8, s[10:11] offset:48
; GCN-NEXT:    global_load_dwordx4 v[4:7], v8, s[10:11] offset:16
; GCN-NEXT:    s_waitcnt vmcnt(3)
; GCN-NEXT:    v_readfirstlane_b32 s5, v11
; GCN-NEXT:    v_readfirstlane_b32 s4, v10
; GCN-NEXT:    s_waitcnt vmcnt(2)
; GCN-NEXT:    v_readfirstlane_b32 s7, v15
; GCN-NEXT:    v_readfirstlane_b32 s6, v14
; GCN-NEXT:    s_or_b64 s[0:1], s[6:7], s[4:5]
; GCN-NEXT:    s_mov_b32 s0, 0
; GCN-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GCN-NEXT:    s_cbranch_scc0 .LBB12_13
; GCN-NEXT:  ; %bb.1:
; GCN-NEXT:    s_ashr_i32 s0, s5, 31
; GCN-NEXT:    s_add_u32 s2, s4, s0
; GCN-NEXT:    s_mov_b32 s1, s0
; GCN-NEXT:    s_addc_u32 s3, s5, s0
; GCN-NEXT:    s_xor_b64 s[12:13], s[2:3], s[0:1]
; GCN-NEXT:    v_cvt_f32_u32_e32 v8, s12
; GCN-NEXT:    v_cvt_f32_u32_e32 v9, s13
; GCN-NEXT:    s_sub_u32 s0, 0, s12
; GCN-NEXT:    s_subb_u32 s1, 0, s13
; GCN-NEXT:    v_madmk_f32 v8, v9, 0x4f800000, v8
; GCN-NEXT:    v_rcp_f32_e32 v8, v8
; GCN-NEXT:    v_mul_f32_e32 v8, 0x5f7ffffc, v8
; GCN-NEXT:    v_mul_f32_e32 v9, 0x2f800000, v8
; GCN-NEXT:    v_trunc_f32_e32 v9, v9
; GCN-NEXT:    v_madmk_f32 v8, v9, 0xcf800000, v8
; GCN-NEXT:    v_cvt_u32_f32_e32 v9, v9
; GCN-NEXT:    v_cvt_u32_f32_e32 v8, v8
; GCN-NEXT:    v_readfirstlane_b32 s2, v9
; GCN-NEXT:    v_readfirstlane_b32 s3, v8
; GCN-NEXT:    s_mul_i32 s5, s0, s2
; GCN-NEXT:    s_mul_hi_u32 s15, s0, s3
; GCN-NEXT:    s_mul_i32 s14, s1, s3
; GCN-NEXT:    s_add_i32 s5, s15, s5
; GCN-NEXT:    s_add_i32 s5, s5, s14
; GCN-NEXT:    s_mul_i32 s16, s0, s3
; GCN-NEXT:    s_mul_hi_u32 s14, s3, s5
; GCN-NEXT:    s_mul_i32 s15, s3, s5
; GCN-NEXT:    s_mul_hi_u32 s3, s3, s16
; GCN-NEXT:    s_add_u32 s3, s3, s15
; GCN-NEXT:    s_addc_u32 s14, 0, s14
; GCN-NEXT:    s_mul_hi_u32 s17, s2, s16
; GCN-NEXT:    s_mul_i32 s16, s2, s16
; GCN-NEXT:    s_add_u32 s3, s3, s16
; GCN-NEXT:    s_mul_hi_u32 s15, s2, s5
; GCN-NEXT:    s_addc_u32 s3, s14, s17
; GCN-NEXT:    s_addc_u32 s14, s15, 0
; GCN-NEXT:    s_mul_i32 s5, s2, s5
; GCN-NEXT:    s_add_u32 s3, s3, s5
; GCN-NEXT:    s_addc_u32 s5, 0, s14
; GCN-NEXT:    v_add_co_u32_e32 v8, vcc, s3, v8
; GCN-NEXT:    s_cmp_lg_u64 vcc, 0
; GCN-NEXT:    s_addc_u32 s2, s2, s5
; GCN-NEXT:    v_readfirstlane_b32 s5, v8
; GCN-NEXT:    s_mul_i32 s3, s0, s2
; GCN-NEXT:    s_mul_hi_u32 s14, s0, s5
; GCN-NEXT:    s_add_i32 s3, s14, s3
; GCN-NEXT:    s_mul_i32 s1, s1, s5
; GCN-NEXT:    s_add_i32 s3, s3, s1
; GCN-NEXT:    s_mul_i32 s0, s0, s5
; GCN-NEXT:    s_mul_hi_u32 s14, s2, s0
; GCN-NEXT:    s_mul_i32 s15, s2, s0
; GCN-NEXT:    s_mul_i32 s17, s5, s3
; GCN-NEXT:    s_mul_hi_u32 s0, s5, s0
; GCN-NEXT:    s_mul_hi_u32 s16, s5, s3
; GCN-NEXT:    s_add_u32 s0, s0, s17
; GCN-NEXT:    s_addc_u32 s5, 0, s16
; GCN-NEXT:    s_add_u32 s0, s0, s15
; GCN-NEXT:    s_mul_hi_u32 s1, s2, s3
; GCN-NEXT:    s_addc_u32 s0, s5, s14
; GCN-NEXT:    s_addc_u32 s1, s1, 0
; GCN-NEXT:    s_mul_i32 s3, s2, s3
; GCN-NEXT:    s_add_u32 s0, s0, s3
; GCN-NEXT:    s_addc_u32 s1, 0, s1
; GCN-NEXT:    v_add_co_u32_e32 v8, vcc, s0, v8
; GCN-NEXT:    s_cmp_lg_u64 vcc, 0
; GCN-NEXT:    s_addc_u32 s2, s2, s1
; GCN-NEXT:    s_ashr_i32 s14, s7, 31
; GCN-NEXT:    s_add_u32 s0, s6, s14
; GCN-NEXT:    s_mov_b32 s15, s14
; GCN-NEXT:    s_addc_u32 s1, s7, s14
; GCN-NEXT:    s_xor_b64 s[16:17], s[0:1], s[14:15]
; GCN-NEXT:    v_readfirstlane_b32 s3, v8
; GCN-NEXT:    s_mul_i32 s1, s16, s2
; GCN-NEXT:    s_mul_hi_u32 s5, s16, s3
; GCN-NEXT:    s_mul_hi_u32 s0, s16, s2
; GCN-NEXT:    s_add_u32 s1, s5, s1
; GCN-NEXT:    s_addc_u32 s0, 0, s0
; GCN-NEXT:    s_mul_hi_u32 s7, s17, s3
; GCN-NEXT:    s_mul_i32 s3, s17, s3
; GCN-NEXT:    s_add_u32 s1, s1, s3
; GCN-NEXT:    s_mul_hi_u32 s5, s17, s2
; GCN-NEXT:    s_addc_u32 s0, s0, s7
; GCN-NEXT:    s_addc_u32 s1, s5, 0
; GCN-NEXT:    s_mul_i32 s2, s17, s2
; GCN-NEXT:    s_add_u32 s0, s0, s2
; GCN-NEXT:    s_addc_u32 s1, 0, s1
; GCN-NEXT:    s_mul_i32 s1, s12, s1
; GCN-NEXT:    s_mul_hi_u32 s2, s12, s0
; GCN-NEXT:    s_add_i32 s1, s2, s1
; GCN-NEXT:    s_mul_i32 s2, s13, s0
; GCN-NEXT:    s_mul_i32 s0, s12, s0
; GCN-NEXT:    s_add_i32 s5, s1, s2
; GCN-NEXT:    v_mov_b32_e32 v8, s0
; GCN-NEXT:    s_sub_i32 s1, s17, s5
; GCN-NEXT:    v_sub_co_u32_e32 v8, vcc, s16, v8
; GCN-NEXT:    s_cmp_lg_u64 vcc, 0
; GCN-NEXT:    s_subb_u32 s7, s1, s13
; GCN-NEXT:    v_subrev_co_u32_e64 v9, s[0:1], s12, v8
; GCN-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GCN-NEXT:    s_subb_u32 s15, s7, 0
; GCN-NEXT:    s_cmp_ge_u32 s15, s13
; GCN-NEXT:    s_cselect_b32 s16, -1, 0
; GCN-NEXT:    v_cmp_le_u32_e64 s[2:3], s12, v9
; GCN-NEXT:    s_cmp_eq_u32 s15, s13
; GCN-NEXT:    v_cndmask_b32_e64 v10, 0, -1, s[2:3]
; GCN-NEXT:    v_mov_b32_e32 v11, s16
; GCN-NEXT:    s_cselect_b64 s[2:3], -1, 0
; GCN-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GCN-NEXT:    v_cndmask_b32_e64 v10, v11, v10, s[2:3]
; GCN-NEXT:    s_subb_u32 s2, s7, s13
; GCN-NEXT:    v_subrev_co_u32_e64 v11, s[0:1], s12, v9
; GCN-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GCN-NEXT:    s_subb_u32 s2, s2, 0
; GCN-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v10
; GCN-NEXT:    v_cndmask_b32_e64 v9, v9, v11, s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v10, s15
; GCN-NEXT:    v_mov_b32_e32 v11, s2
; GCN-NEXT:    s_cmp_lg_u64 vcc, 0
; GCN-NEXT:    v_cndmask_b32_e64 v10, v10, v11, s[0:1]
; GCN-NEXT:    s_subb_u32 s0, s17, s5
; GCN-NEXT:    s_cmp_ge_u32 s0, s13
; GCN-NEXT:    s_cselect_b32 s1, -1, 0
; GCN-NEXT:    v_cmp_le_u32_e32 vcc, s12, v8
; GCN-NEXT:    s_cmp_eq_u32 s0, s13
; GCN-NEXT:    v_cndmask_b32_e64 v11, 0, -1, vcc
; GCN-NEXT:    v_mov_b32_e32 v14, s1
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    v_cndmask_b32_e32 v11, v14, v11, vcc
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v11
; GCN-NEXT:    v_mov_b32_e32 v14, s0
; GCN-NEXT:    v_cndmask_b32_e32 v8, v8, v9, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v10, v14, v10, vcc
; GCN-NEXT:    v_xor_b32_e32 v8, s14, v8
; GCN-NEXT:    v_xor_b32_e32 v9, s14, v10
; GCN-NEXT:    v_mov_b32_e32 v10, s14
; GCN-NEXT:    v_subrev_co_u32_e32 v8, vcc, s14, v8
; GCN-NEXT:    v_subb_co_u32_e32 v9, vcc, v9, v10, vcc
; GCN-NEXT:    s_cbranch_execnz .LBB12_3
; GCN-NEXT:  .LBB12_2:
; GCN-NEXT:    v_cvt_f32_u32_e32 v8, s4
; GCN-NEXT:    s_sub_i32 s0, 0, s4
; GCN-NEXT:    s_mov_b32 s1, 0
; GCN-NEXT:    v_rcp_iflag_f32_e32 v8, v8
; GCN-NEXT:    v_mul_f32_e32 v8, 0x4f7ffffe, v8
; GCN-NEXT:    v_cvt_u32_f32_e32 v8, v8
; GCN-NEXT:    v_readfirstlane_b32 s2, v8
; GCN-NEXT:    s_mul_i32 s0, s0, s2
; GCN-NEXT:    s_mul_hi_u32 s0, s2, s0
; GCN-NEXT:    s_add_i32 s2, s2, s0
; GCN-NEXT:    s_mul_hi_u32 s0, s6, s2
; GCN-NEXT:    s_mul_i32 s0, s0, s4
; GCN-NEXT:    s_sub_i32 s0, s6, s0
; GCN-NEXT:    s_sub_i32 s2, s0, s4
; GCN-NEXT:    s_cmp_ge_u32 s0, s4
; GCN-NEXT:    s_cselect_b32 s0, s2, s0
; GCN-NEXT:    s_sub_i32 s2, s0, s4
; GCN-NEXT:    s_cmp_ge_u32 s0, s4
; GCN-NEXT:    s_cselect_b32 s0, s2, s0
; GCN-NEXT:    v_mov_b32_e32 v9, s1
; GCN-NEXT:    v_mov_b32_e32 v8, s0
; GCN-NEXT:  .LBB12_3:
; GCN-NEXT:    v_or_b32_e32 v11, v17, v13
; GCN-NEXT:    v_mov_b32_e32 v10, 0
; GCN-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[10:11]
; GCN-NEXT:    s_cbranch_vccz .LBB12_14
; GCN-NEXT:  ; %bb.4:
; GCN-NEXT:    v_ashrrev_i32_e32 v10, 31, v13
; GCN-NEXT:    v_add_co_u32_e32 v11, vcc, v12, v10
; GCN-NEXT:    v_addc_co_u32_e32 v13, vcc, v13, v10, vcc
; GCN-NEXT:    v_xor_b32_e32 v11, v11, v10
; GCN-NEXT:    v_xor_b32_e32 v10, v13, v10
; GCN-NEXT:    v_cvt_f32_u32_e32 v13, v11
; GCN-NEXT:    v_cvt_f32_u32_e32 v14, v10
; GCN-NEXT:    v_sub_co_u32_e32 v15, vcc, 0, v11
; GCN-NEXT:    v_subb_co_u32_e32 v18, vcc, 0, v10, vcc
; GCN-NEXT:    v_madmk_f32 v13, v14, 0x4f800000, v13
; GCN-NEXT:    v_rcp_f32_e32 v13, v13
; GCN-NEXT:    v_mul_f32_e32 v13, 0x5f7ffffc, v13
; GCN-NEXT:    v_mul_f32_e32 v14, 0x2f800000, v13
; GCN-NEXT:    v_trunc_f32_e32 v14, v14
; GCN-NEXT:    v_madmk_f32 v13, v14, 0xcf800000, v13
; GCN-NEXT:    v_cvt_u32_f32_e32 v14, v14
; GCN-NEXT:    v_cvt_u32_f32_e32 v13, v13
; GCN-NEXT:    v_mul_lo_u32 v20, v15, v14
; GCN-NEXT:    v_mul_hi_u32 v19, v15, v13
; GCN-NEXT:    v_mul_lo_u32 v21, v18, v13
; GCN-NEXT:    v_mul_lo_u32 v22, v15, v13
; GCN-NEXT:    v_add_u32_e32 v19, v19, v20
; GCN-NEXT:    v_add_u32_e32 v19, v19, v21
; GCN-NEXT:    v_mul_lo_u32 v20, v13, v19
; GCN-NEXT:    v_mul_hi_u32 v21, v13, v22
; GCN-NEXT:    v_mul_hi_u32 v23, v13, v19
; GCN-NEXT:    v_mul_hi_u32 v24, v14, v19
; GCN-NEXT:    v_mul_lo_u32 v19, v14, v19
; GCN-NEXT:    v_add_co_u32_e32 v20, vcc, v21, v20
; GCN-NEXT:    v_addc_co_u32_e32 v21, vcc, 0, v23, vcc
; GCN-NEXT:    v_mul_lo_u32 v23, v14, v22
; GCN-NEXT:    v_mul_hi_u32 v22, v14, v22
; GCN-NEXT:    v_add_co_u32_e32 v20, vcc, v20, v23
; GCN-NEXT:    v_addc_co_u32_e32 v20, vcc, v21, v22, vcc
; GCN-NEXT:    v_addc_co_u32_e32 v21, vcc, 0, v24, vcc
; GCN-NEXT:    v_add_co_u32_e32 v19, vcc, v20, v19
; GCN-NEXT:    v_addc_co_u32_e32 v20, vcc, 0, v21, vcc
; GCN-NEXT:    v_add_co_u32_e32 v13, vcc, v13, v19
; GCN-NEXT:    v_addc_co_u32_e32 v14, vcc, v14, v20, vcc
; GCN-NEXT:    v_mul_lo_u32 v19, v15, v14
; GCN-NEXT:    v_mul_hi_u32 v20, v15, v13
; GCN-NEXT:    v_mul_lo_u32 v18, v18, v13
; GCN-NEXT:    v_mul_lo_u32 v15, v15, v13
; GCN-NEXT:    v_add_u32_e32 v19, v20, v19
; GCN-NEXT:    v_add_u32_e32 v18, v19, v18
; GCN-NEXT:    v_mul_lo_u32 v21, v13, v18
; GCN-NEXT:    v_mul_hi_u32 v22, v13, v15
; GCN-NEXT:    v_mul_hi_u32 v23, v13, v18
; GCN-NEXT:    v_mul_hi_u32 v20, v14, v15
; GCN-NEXT:    v_mul_lo_u32 v15, v14, v15
; GCN-NEXT:    v_mul_hi_u32 v19, v14, v18
; GCN-NEXT:    v_add_co_u32_e32 v21, vcc, v22, v21
; GCN-NEXT:    v_addc_co_u32_e32 v22, vcc, 0, v23, vcc
; GCN-NEXT:    v_mul_lo_u32 v18, v14, v18
; GCN-NEXT:    v_add_co_u32_e32 v15, vcc, v21, v15
; GCN-NEXT:    v_addc_co_u32_e32 v15, vcc, v22, v20, vcc
; GCN-NEXT:    v_addc_co_u32_e32 v19, vcc, 0, v19, vcc
; GCN-NEXT:    v_add_co_u32_e32 v15, vcc, v15, v18
; GCN-NEXT:    v_addc_co_u32_e32 v18, vcc, 0, v19, vcc
; GCN-NEXT:    v_add_co_u32_e32 v13, vcc, v13, v15
; GCN-NEXT:    v_addc_co_u32_e32 v14, vcc, v14, v18, vcc
; GCN-NEXT:    v_ashrrev_i32_e32 v15, 31, v17
; GCN-NEXT:    v_add_co_u32_e32 v18, vcc, v16, v15
; GCN-NEXT:    v_xor_b32_e32 v18, v18, v15
; GCN-NEXT:    v_mul_lo_u32 v19, v18, v14
; GCN-NEXT:    v_mul_hi_u32 v20, v18, v13
; GCN-NEXT:    v_mul_hi_u32 v21, v18, v14
; GCN-NEXT:    v_addc_co_u32_e32 v17, vcc, v17, v15, vcc
; GCN-NEXT:    v_xor_b32_e32 v17, v17, v15
; GCN-NEXT:    v_add_co_u32_e32 v19, vcc, v20, v19
; GCN-NEXT:    v_addc_co_u32_e32 v20, vcc, 0, v21, vcc
; GCN-NEXT:    v_mul_lo_u32 v21, v17, v13
; GCN-NEXT:    v_mul_hi_u32 v13, v17, v13
; GCN-NEXT:    v_mul_hi_u32 v22, v17, v14
; GCN-NEXT:    v_mul_lo_u32 v14, v17, v14
; GCN-NEXT:    v_add_co_u32_e32 v19, vcc, v19, v21
; GCN-NEXT:    v_addc_co_u32_e32 v13, vcc, v20, v13, vcc
; GCN-NEXT:    v_addc_co_u32_e32 v19, vcc, 0, v22, vcc
; GCN-NEXT:    v_add_co_u32_e32 v13, vcc, v13, v14
; GCN-NEXT:    v_addc_co_u32_e32 v14, vcc, 0, v19, vcc
; GCN-NEXT:    v_mul_lo_u32 v14, v11, v14
; GCN-NEXT:    v_mul_hi_u32 v19, v11, v13
; GCN-NEXT:    v_mul_lo_u32 v20, v10, v13
; GCN-NEXT:    v_mul_lo_u32 v13, v11, v13
; GCN-NEXT:    v_add_u32_e32 v14, v19, v14
; GCN-NEXT:    v_add_u32_e32 v14, v14, v20
; GCN-NEXT:    v_sub_u32_e32 v19, v17, v14
; GCN-NEXT:    v_sub_co_u32_e32 v13, vcc, v18, v13
; GCN-NEXT:    v_subb_co_u32_e64 v18, s[0:1], v19, v10, vcc
; GCN-NEXT:    v_sub_co_u32_e64 v19, s[0:1], v13, v11
; GCN-NEXT:    v_subbrev_co_u32_e64 v20, s[2:3], 0, v18, s[0:1]
; GCN-NEXT:    v_cmp_ge_u32_e64 s[2:3], v20, v10
; GCN-NEXT:    v_cndmask_b32_e64 v21, 0, -1, s[2:3]
; GCN-NEXT:    v_cmp_ge_u32_e64 s[2:3], v19, v11
; GCN-NEXT:    v_subb_co_u32_e32 v14, vcc, v17, v14, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v22, 0, -1, s[2:3]
; GCN-NEXT:    v_cmp_eq_u32_e64 s[2:3], v20, v10
; GCN-NEXT:    v_subb_co_u32_e64 v18, s[0:1], v18, v10, s[0:1]
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v14, v10
; GCN-NEXT:    v_cndmask_b32_e64 v21, v21, v22, s[2:3]
; GCN-NEXT:    v_sub_co_u32_e64 v22, s[0:1], v19, v11
; GCN-NEXT:    v_cndmask_b32_e64 v17, 0, -1, vcc
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v13, v11
; GCN-NEXT:    v_subbrev_co_u32_e64 v18, s[0:1], 0, v18, s[0:1]
; GCN-NEXT:    v_cndmask_b32_e64 v11, 0, -1, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, v14, v10
; GCN-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v21
; GCN-NEXT:    v_cndmask_b32_e32 v10, v17, v11, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v19, v19, v22, s[0:1]
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v10
; GCN-NEXT:    v_cndmask_b32_e64 v18, v20, v18, s[0:1]
; GCN-NEXT:    v_cndmask_b32_e32 v11, v13, v19, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v10, v14, v18, vcc
; GCN-NEXT:    v_xor_b32_e32 v11, v11, v15
; GCN-NEXT:    v_xor_b32_e32 v13, v10, v15
; GCN-NEXT:    v_sub_co_u32_e32 v10, vcc, v11, v15
; GCN-NEXT:    v_subb_co_u32_e32 v11, vcc, v13, v15, vcc
; GCN-NEXT:    s_cbranch_execnz .LBB12_6
; GCN-NEXT:  .LBB12_5:
; GCN-NEXT:    v_cvt_f32_u32_e32 v10, v12
; GCN-NEXT:    v_sub_u32_e32 v11, 0, v12
; GCN-NEXT:    v_rcp_iflag_f32_e32 v10, v10
; GCN-NEXT:    v_mul_f32_e32 v10, 0x4f7ffffe, v10
; GCN-NEXT:    v_cvt_u32_f32_e32 v10, v10
; GCN-NEXT:    v_mul_lo_u32 v11, v11, v10
; GCN-NEXT:    v_mul_hi_u32 v11, v10, v11
; GCN-NEXT:    v_add_u32_e32 v10, v10, v11
; GCN-NEXT:    v_mul_hi_u32 v10, v16, v10
; GCN-NEXT:    v_mul_lo_u32 v10, v10, v12
; GCN-NEXT:    v_sub_u32_e32 v10, v16, v10
; GCN-NEXT:    v_sub_u32_e32 v11, v10, v12
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v10, v12
; GCN-NEXT:    v_cndmask_b32_e32 v10, v10, v11, vcc
; GCN-NEXT:    v_sub_u32_e32 v11, v10, v12
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v10, v12
; GCN-NEXT:    v_cndmask_b32_e32 v10, v10, v11, vcc
; GCN-NEXT:    v_mov_b32_e32 v11, 0
; GCN-NEXT:  .LBB12_6:
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_or_b32_e32 v13, v5, v1
; GCN-NEXT:    v_mov_b32_e32 v12, 0
; GCN-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[12:13]
; GCN-NEXT:    s_cbranch_vccz .LBB12_15
; GCN-NEXT:  ; %bb.7:
; GCN-NEXT:    v_ashrrev_i32_e32 v13, 31, v1
; GCN-NEXT:    v_add_co_u32_e32 v12, vcc, v0, v13
; GCN-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v13, vcc
; GCN-NEXT:    v_xor_b32_e32 v12, v12, v13
; GCN-NEXT:    v_xor_b32_e32 v1, v1, v13
; GCN-NEXT:    v_cvt_f32_u32_e32 v13, v12
; GCN-NEXT:    v_cvt_f32_u32_e32 v14, v1
; GCN-NEXT:    v_sub_co_u32_e32 v15, vcc, 0, v12
; GCN-NEXT:    v_subb_co_u32_e32 v16, vcc, 0, v1, vcc
; GCN-NEXT:    v_madmk_f32 v13, v14, 0x4f800000, v13
; GCN-NEXT:    v_rcp_f32_e32 v13, v13
; GCN-NEXT:    v_mul_f32_e32 v13, 0x5f7ffffc, v13
; GCN-NEXT:    v_mul_f32_e32 v14, 0x2f800000, v13
; GCN-NEXT:    v_trunc_f32_e32 v14, v14
; GCN-NEXT:    v_madmk_f32 v13, v14, 0xcf800000, v13
; GCN-NEXT:    v_cvt_u32_f32_e32 v14, v14
; GCN-NEXT:    v_cvt_u32_f32_e32 v13, v13
; GCN-NEXT:    v_mul_lo_u32 v18, v15, v14
; GCN-NEXT:    v_mul_hi_u32 v17, v15, v13
; GCN-NEXT:    v_mul_lo_u32 v19, v16, v13
; GCN-NEXT:    v_mul_lo_u32 v20, v15, v13
; GCN-NEXT:    v_add_u32_e32 v17, v17, v18
; GCN-NEXT:    v_add_u32_e32 v17, v17, v19
; GCN-NEXT:    v_mul_lo_u32 v18, v13, v17
; GCN-NEXT:    v_mul_hi_u32 v19, v13, v20
; GCN-NEXT:    v_mul_hi_u32 v21, v13, v17
; GCN-NEXT:    v_mul_hi_u32 v22, v14, v17
; GCN-NEXT:    v_mul_lo_u32 v17, v14, v17
; GCN-NEXT:    v_add_co_u32_e32 v18, vcc, v19, v18
; GCN-NEXT:    v_addc_co_u32_e32 v19, vcc, 0, v21, vcc
; GCN-NEXT:    v_mul_lo_u32 v21, v14, v20
; GCN-NEXT:    v_mul_hi_u32 v20, v14, v20
; GCN-NEXT:    v_add_co_u32_e32 v18, vcc, v18, v21
; GCN-NEXT:    v_addc_co_u32_e32 v18, vcc, v19, v20, vcc
; GCN-NEXT:    v_addc_co_u32_e32 v19, vcc, 0, v22, vcc
; GCN-NEXT:    v_add_co_u32_e32 v17, vcc, v18, v17
; GCN-NEXT:    v_addc_co_u32_e32 v18, vcc, 0, v19, vcc
; GCN-NEXT:    v_add_co_u32_e32 v13, vcc, v13, v17
; GCN-NEXT:    v_addc_co_u32_e32 v14, vcc, v14, v18, vcc
; GCN-NEXT:    v_mul_lo_u32 v17, v15, v14
; GCN-NEXT:    v_mul_hi_u32 v18, v15, v13
; GCN-NEXT:    v_mul_lo_u32 v16, v16, v13
; GCN-NEXT:    v_mul_lo_u32 v15, v15, v13
; GCN-NEXT:    v_add_u32_e32 v17, v18, v17
; GCN-NEXT:    v_add_u32_e32 v16, v17, v16
; GCN-NEXT:    v_mul_lo_u32 v19, v13, v16
; GCN-NEXT:    v_mul_hi_u32 v20, v13, v15
; GCN-NEXT:    v_mul_hi_u32 v21, v13, v16
; GCN-NEXT:    v_mul_hi_u32 v18, v14, v15
; GCN-NEXT:    v_mul_lo_u32 v15, v14, v15
; GCN-NEXT:    v_mul_hi_u32 v17, v14, v16
; GCN-NEXT:    v_add_co_u32_e32 v19, vcc, v20, v19
; GCN-NEXT:    v_addc_co_u32_e32 v20, vcc, 0, v21, vcc
; GCN-NEXT:    v_mul_lo_u32 v16, v14, v16
; GCN-NEXT:    v_add_co_u32_e32 v15, vcc, v19, v15
; GCN-NEXT:    v_addc_co_u32_e32 v15, vcc, v20, v18, vcc
; GCN-NEXT:    v_addc_co_u32_e32 v17, vcc, 0, v17, vcc
; GCN-NEXT:    v_add_co_u32_e32 v15, vcc, v15, v16
; GCN-NEXT:    v_addc_co_u32_e32 v16, vcc, 0, v17, vcc
; GCN-NEXT:    v_add_co_u32_e32 v13, vcc, v13, v15
; GCN-NEXT:    v_addc_co_u32_e32 v14, vcc, v14, v16, vcc
; GCN-NEXT:    v_ashrrev_i32_e32 v15, 31, v5
; GCN-NEXT:    v_add_co_u32_e32 v16, vcc, v4, v15
; GCN-NEXT:    v_xor_b32_e32 v16, v16, v15
; GCN-NEXT:    v_mul_lo_u32 v17, v16, v14
; GCN-NEXT:    v_mul_hi_u32 v18, v16, v13
; GCN-NEXT:    v_mul_hi_u32 v19, v16, v14
; GCN-NEXT:    v_addc_co_u32_e32 v5, vcc, v5, v15, vcc
; GCN-NEXT:    v_xor_b32_e32 v5, v5, v15
; GCN-NEXT:    v_add_co_u32_e32 v17, vcc, v18, v17
; GCN-NEXT:    v_addc_co_u32_e32 v18, vcc, 0, v19, vcc
; GCN-NEXT:    v_mul_lo_u32 v19, v5, v13
; GCN-NEXT:    v_mul_hi_u32 v13, v5, v13
; GCN-NEXT:    v_mul_hi_u32 v20, v5, v14
; GCN-NEXT:    v_mul_lo_u32 v14, v5, v14
; GCN-NEXT:    v_add_co_u32_e32 v17, vcc, v17, v19
; GCN-NEXT:    v_addc_co_u32_e32 v13, vcc, v18, v13, vcc
; GCN-NEXT:    v_addc_co_u32_e32 v17, vcc, 0, v20, vcc
; GCN-NEXT:    v_add_co_u32_e32 v13, vcc, v13, v14
; GCN-NEXT:    v_addc_co_u32_e32 v14, vcc, 0, v17, vcc
; GCN-NEXT:    v_mul_lo_u32 v14, v12, v14
; GCN-NEXT:    v_mul_hi_u32 v17, v12, v13
; GCN-NEXT:    v_mul_lo_u32 v18, v1, v13
; GCN-NEXT:    v_mul_lo_u32 v13, v12, v13
; GCN-NEXT:    v_add_u32_e32 v14, v17, v14
; GCN-NEXT:    v_add_u32_e32 v14, v14, v18
; GCN-NEXT:    v_sub_u32_e32 v17, v5, v14
; GCN-NEXT:    v_sub_co_u32_e32 v13, vcc, v16, v13
; GCN-NEXT:    v_subb_co_u32_e64 v16, s[0:1], v17, v1, vcc
; GCN-NEXT:    v_sub_co_u32_e64 v17, s[0:1], v13, v12
; GCN-NEXT:    v_subbrev_co_u32_e64 v18, s[2:3], 0, v16, s[0:1]
; GCN-NEXT:    v_cmp_ge_u32_e64 s[2:3], v18, v1
; GCN-NEXT:    v_cndmask_b32_e64 v19, 0, -1, s[2:3]
; GCN-NEXT:    v_cmp_ge_u32_e64 s[2:3], v17, v12
; GCN-NEXT:    v_subb_co_u32_e32 v5, vcc, v5, v14, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v20, 0, -1, s[2:3]
; GCN-NEXT:    v_cmp_eq_u32_e64 s[2:3], v18, v1
; GCN-NEXT:    v_subb_co_u32_e64 v16, s[0:1], v16, v1, s[0:1]
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v5, v1
; GCN-NEXT:    v_cndmask_b32_e64 v19, v19, v20, s[2:3]
; GCN-NEXT:    v_sub_co_u32_e64 v20, s[0:1], v17, v12
; GCN-NEXT:    v_cndmask_b32_e64 v14, 0, -1, vcc
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v13, v12
; GCN-NEXT:    v_subbrev_co_u32_e64 v16, s[0:1], 0, v16, s[0:1]
; GCN-NEXT:    v_cndmask_b32_e64 v12, 0, -1, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v1
; GCN-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v19
; GCN-NEXT:    v_cndmask_b32_e32 v1, v14, v12, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v17, v17, v20, s[0:1]
; GCN-NEXT:    v_cndmask_b32_e64 v16, v18, v16, s[0:1]
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; GCN-NEXT:    v_cndmask_b32_e32 v1, v5, v16, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v5, v13, v17, vcc
; GCN-NEXT:    v_xor_b32_e32 v5, v5, v15
; GCN-NEXT:    v_xor_b32_e32 v1, v1, v15
; GCN-NEXT:    v_sub_co_u32_e32 v12, vcc, v5, v15
; GCN-NEXT:    v_subb_co_u32_e32 v13, vcc, v1, v15, vcc
; GCN-NEXT:    s_cbranch_execnz .LBB12_9
; GCN-NEXT:  .LBB12_8:
; GCN-NEXT:    v_cvt_f32_u32_e32 v1, v0
; GCN-NEXT:    v_sub_u32_e32 v5, 0, v0
; GCN-NEXT:    v_mov_b32_e32 v13, 0
; GCN-NEXT:    v_rcp_iflag_f32_e32 v1, v1
; GCN-NEXT:    v_mul_f32_e32 v1, 0x4f7ffffe, v1
; GCN-NEXT:    v_cvt_u32_f32_e32 v1, v1
; GCN-NEXT:    v_mul_lo_u32 v5, v5, v1
; GCN-NEXT:    v_mul_hi_u32 v5, v1, v5
; GCN-NEXT:    v_add_u32_e32 v1, v1, v5
; GCN-NEXT:    v_mul_hi_u32 v1, v4, v1
; GCN-NEXT:    v_mul_lo_u32 v1, v1, v0
; GCN-NEXT:    v_sub_u32_e32 v1, v4, v1
; GCN-NEXT:    v_sub_u32_e32 v4, v1, v0
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v1, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GCN-NEXT:    v_sub_u32_e32 v4, v1, v0
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v1, v0
; GCN-NEXT:    v_cndmask_b32_e32 v12, v1, v4, vcc
; GCN-NEXT:  .LBB12_9:
; GCN-NEXT:    v_or_b32_e32 v1, v7, v3
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GCN-NEXT:    s_cbranch_vccz .LBB12_16
; GCN-NEXT:  ; %bb.10:
; GCN-NEXT:    v_ashrrev_i32_e32 v0, 31, v3
; GCN-NEXT:    v_add_co_u32_e32 v1, vcc, v2, v0
; GCN-NEXT:    v_addc_co_u32_e32 v3, vcc, v3, v0, vcc
; GCN-NEXT:    v_xor_b32_e32 v1, v1, v0
; GCN-NEXT:    v_xor_b32_e32 v0, v3, v0
; GCN-NEXT:    v_cvt_f32_u32_e32 v3, v1
; GCN-NEXT:    v_cvt_f32_u32_e32 v4, v0
; GCN-NEXT:    v_sub_co_u32_e32 v5, vcc, 0, v1
; GCN-NEXT:    v_subb_co_u32_e32 v14, vcc, 0, v0, vcc
; GCN-NEXT:    v_madmk_f32 v3, v4, 0x4f800000, v3
; GCN-NEXT:    v_rcp_f32_e32 v3, v3
; GCN-NEXT:    v_mul_f32_e32 v3, 0x5f7ffffc, v3
; GCN-NEXT:    v_mul_f32_e32 v4, 0x2f800000, v3
; GCN-NEXT:    v_trunc_f32_e32 v4, v4
; GCN-NEXT:    v_madmk_f32 v3, v4, 0xcf800000, v3
; GCN-NEXT:    v_cvt_u32_f32_e32 v4, v4
; GCN-NEXT:    v_cvt_u32_f32_e32 v3, v3
; GCN-NEXT:    v_mul_lo_u32 v16, v5, v4
; GCN-NEXT:    v_mul_hi_u32 v15, v5, v3
; GCN-NEXT:    v_mul_lo_u32 v17, v14, v3
; GCN-NEXT:    v_mul_lo_u32 v18, v5, v3
; GCN-NEXT:    v_add_u32_e32 v15, v15, v16
; GCN-NEXT:    v_add_u32_e32 v15, v15, v17
; GCN-NEXT:    v_mul_lo_u32 v16, v3, v15
; GCN-NEXT:    v_mul_hi_u32 v17, v3, v18
; GCN-NEXT:    v_mul_hi_u32 v19, v3, v15
; GCN-NEXT:    v_mul_hi_u32 v20, v4, v15
; GCN-NEXT:    v_mul_lo_u32 v15, v4, v15
; GCN-NEXT:    v_add_co_u32_e32 v16, vcc, v17, v16
; GCN-NEXT:    v_addc_co_u32_e32 v17, vcc, 0, v19, vcc
; GCN-NEXT:    v_mul_lo_u32 v19, v4, v18
; GCN-NEXT:    v_mul_hi_u32 v18, v4, v18
; GCN-NEXT:    v_add_co_u32_e32 v16, vcc, v16, v19
; GCN-NEXT:    v_addc_co_u32_e32 v16, vcc, v17, v18, vcc
; GCN-NEXT:    v_addc_co_u32_e32 v17, vcc, 0, v20, vcc
; GCN-NEXT:    v_add_co_u32_e32 v15, vcc, v16, v15
; GCN-NEXT:    v_addc_co_u32_e32 v16, vcc, 0, v17, vcc
; GCN-NEXT:    v_add_co_u32_e32 v3, vcc, v3, v15
; GCN-NEXT:    v_addc_co_u32_e32 v4, vcc, v4, v16, vcc
; GCN-NEXT:    v_mul_lo_u32 v15, v5, v4
; GCN-NEXT:    v_mul_hi_u32 v16, v5, v3
; GCN-NEXT:    v_mul_lo_u32 v14, v14, v3
; GCN-NEXT:    v_mul_lo_u32 v5, v5, v3
; GCN-NEXT:    v_add_u32_e32 v15, v16, v15
; GCN-NEXT:    v_add_u32_e32 v14, v15, v14
; GCN-NEXT:    v_mul_lo_u32 v17, v3, v14
; GCN-NEXT:    v_mul_hi_u32 v18, v3, v5
; GCN-NEXT:    v_mul_hi_u32 v19, v3, v14
; GCN-NEXT:    v_mul_hi_u32 v16, v4, v5
; GCN-NEXT:    v_mul_lo_u32 v5, v4, v5
; GCN-NEXT:    v_mul_hi_u32 v15, v4, v14
; GCN-NEXT:    v_add_co_u32_e32 v17, vcc, v18, v17
; GCN-NEXT:    v_addc_co_u32_e32 v18, vcc, 0, v19, vcc
; GCN-NEXT:    v_mul_lo_u32 v14, v4, v14
; GCN-NEXT:    v_add_co_u32_e32 v5, vcc, v17, v5
; GCN-NEXT:    v_addc_co_u32_e32 v5, vcc, v18, v16, vcc
; GCN-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v15, vcc
; GCN-NEXT:    v_add_co_u32_e32 v5, vcc, v5, v14
; GCN-NEXT:    v_addc_co_u32_e32 v14, vcc, 0, v15, vcc
; GCN-NEXT:    v_add_co_u32_e32 v3, vcc, v3, v5
; GCN-NEXT:    v_addc_co_u32_e32 v4, vcc, v4, v14, vcc
; GCN-NEXT:    v_ashrrev_i32_e32 v5, 31, v7
; GCN-NEXT:    v_add_co_u32_e32 v14, vcc, v6, v5
; GCN-NEXT:    v_xor_b32_e32 v14, v14, v5
; GCN-NEXT:    v_mul_lo_u32 v15, v14, v4
; GCN-NEXT:    v_mul_hi_u32 v16, v14, v3
; GCN-NEXT:    v_mul_hi_u32 v17, v14, v4
; GCN-NEXT:    v_addc_co_u32_e32 v7, vcc, v7, v5, vcc
; GCN-NEXT:    v_xor_b32_e32 v7, v7, v5
; GCN-NEXT:    v_add_co_u32_e32 v15, vcc, v16, v15
; GCN-NEXT:    v_addc_co_u32_e32 v16, vcc, 0, v17, vcc
; GCN-NEXT:    v_mul_lo_u32 v17, v7, v3
; GCN-NEXT:    v_mul_hi_u32 v3, v7, v3
; GCN-NEXT:    v_mul_hi_u32 v18, v7, v4
; GCN-NEXT:    v_mul_lo_u32 v4, v7, v4
; GCN-NEXT:    v_add_co_u32_e32 v15, vcc, v15, v17
; GCN-NEXT:    v_addc_co_u32_e32 v3, vcc, v16, v3, vcc
; GCN-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v18, vcc
; GCN-NEXT:    v_add_co_u32_e32 v3, vcc, v3, v4
; GCN-NEXT:    v_addc_co_u32_e32 v4, vcc, 0, v15, vcc
; GCN-NEXT:    v_mul_lo_u32 v4, v1, v4
; GCN-NEXT:    v_mul_hi_u32 v15, v1, v3
; GCN-NEXT:    v_mul_lo_u32 v16, v0, v3
; GCN-NEXT:    v_mul_lo_u32 v3, v1, v3
; GCN-NEXT:    v_add_u32_e32 v4, v15, v4
; GCN-NEXT:    v_add_u32_e32 v4, v4, v16
; GCN-NEXT:    v_sub_u32_e32 v15, v7, v4
; GCN-NEXT:    v_sub_co_u32_e32 v3, vcc, v14, v3
; GCN-NEXT:    v_subb_co_u32_e64 v14, s[0:1], v15, v0, vcc
; GCN-NEXT:    v_sub_co_u32_e64 v15, s[0:1], v3, v1
; GCN-NEXT:    v_subbrev_co_u32_e64 v16, s[2:3], 0, v14, s[0:1]
; GCN-NEXT:    v_cmp_ge_u32_e64 s[2:3], v16, v0
; GCN-NEXT:    v_cndmask_b32_e64 v17, 0, -1, s[2:3]
; GCN-NEXT:    v_cmp_ge_u32_e64 s[2:3], v15, v1
; GCN-NEXT:    v_subb_co_u32_e32 v4, vcc, v7, v4, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v18, 0, -1, s[2:3]
; GCN-NEXT:    v_cmp_eq_u32_e64 s[2:3], v16, v0
; GCN-NEXT:    v_subb_co_u32_e64 v14, s[0:1], v14, v0, s[0:1]
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v4, v0
; GCN-NEXT:    v_cndmask_b32_e64 v17, v17, v18, s[2:3]
; GCN-NEXT:    v_sub_co_u32_e64 v18, s[0:1], v15, v1
; GCN-NEXT:    v_cndmask_b32_e64 v7, 0, -1, vcc
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v3, v1
; GCN-NEXT:    v_subbrev_co_u32_e64 v14, s[0:1], 0, v14, s[0:1]
; GCN-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v0
; GCN-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v17
; GCN-NEXT:    v_cndmask_b32_e32 v0, v7, v1, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v15, v15, v18, s[0:1]
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GCN-NEXT:    v_cndmask_b32_e64 v14, v16, v14, s[0:1]
; GCN-NEXT:    v_cndmask_b32_e32 v1, v3, v15, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v0, v4, v14, vcc
; GCN-NEXT:    v_xor_b32_e32 v1, v1, v5
; GCN-NEXT:    v_xor_b32_e32 v0, v0, v5
; GCN-NEXT:    v_sub_co_u32_e32 v14, vcc, v1, v5
; GCN-NEXT:    v_subb_co_u32_e32 v15, vcc, v0, v5, vcc
; GCN-NEXT:    s_cbranch_execnz .LBB12_12
; GCN-NEXT:  .LBB12_11:
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, v2
; GCN-NEXT:    v_sub_u32_e32 v1, 0, v2
; GCN-NEXT:    v_mov_b32_e32 v15, 0
; GCN-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; GCN-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; GCN-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GCN-NEXT:    v_mul_lo_u32 v1, v1, v0
; GCN-NEXT:    v_mul_hi_u32 v1, v0, v1
; GCN-NEXT:    v_add_u32_e32 v0, v0, v1
; GCN-NEXT:    v_mul_hi_u32 v0, v6, v0
; GCN-NEXT:    v_mul_lo_u32 v0, v0, v2
; GCN-NEXT:    v_sub_u32_e32 v0, v6, v0
; GCN-NEXT:    v_sub_u32_e32 v1, v0, v2
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v2
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GCN-NEXT:    v_sub_u32_e32 v1, v0, v2
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v2
; GCN-NEXT:    v_cndmask_b32_e32 v14, v0, v1, vcc
; GCN-NEXT:  .LBB12_12:
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    global_store_dwordx4 v0, v[12:15], s[8:9] offset:16
; GCN-NEXT:    global_store_dwordx4 v0, v[8:11], s[8:9]
; GCN-NEXT:    s_endpgm
; GCN-NEXT:  .LBB12_13:
; GCN-NEXT:    ; implicit-def: $vgpr8_vgpr9
; GCN-NEXT:    s_branch .LBB12_2
; GCN-NEXT:  .LBB12_14:
; GCN-NEXT:    s_branch .LBB12_5
; GCN-NEXT:  .LBB12_15:
; GCN-NEXT:    ; implicit-def: $vgpr12_vgpr13
; GCN-NEXT:    s_branch .LBB12_8
; GCN-NEXT:  .LBB12_16:
; GCN-NEXT:    s_branch .LBB12_11
;
; TAHITI-LABEL: srem_v4i64:
; TAHITI:       ; %bb.0:
; TAHITI-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x9
; TAHITI-NEXT:    s_mov_b32 s3, 0xf000
; TAHITI-NEXT:    s_mov_b32 s2, -1
; TAHITI-NEXT:    v_mov_b32_e32 v8, 0
; TAHITI-NEXT:    s_waitcnt lgkmcnt(0)
; TAHITI-NEXT:    s_mov_b32 s0, s6
; TAHITI-NEXT:    s_mov_b32 s1, s7
; TAHITI-NEXT:    buffer_load_dwordx4 v[10:13], off, s[0:3], 0 offset:32
; TAHITI-NEXT:    buffer_load_dwordx4 v[14:17], off, s[0:3], 0
; TAHITI-NEXT:    buffer_load_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; TAHITI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], 0 offset:48
; TAHITI-NEXT:    s_waitcnt vmcnt(2)
; TAHITI-NEXT:    v_or_b32_e32 v9, v15, v11
; TAHITI-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[8:9]
; TAHITI-NEXT:    s_cbranch_vccz .LBB12_13
; TAHITI-NEXT:  ; %bb.1:
; TAHITI-NEXT:    v_ashrrev_i32_e32 v8, 31, v11
; TAHITI-NEXT:    v_add_i32_e32 v9, vcc, v10, v8
; TAHITI-NEXT:    v_addc_u32_e32 v11, vcc, v11, v8, vcc
; TAHITI-NEXT:    v_xor_b32_e32 v9, v9, v8
; TAHITI-NEXT:    v_xor_b32_e32 v8, v11, v8
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v11, v9
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v18, v8
; TAHITI-NEXT:    v_sub_i32_e32 v19, vcc, 0, v9
; TAHITI-NEXT:    v_subb_u32_e32 v20, vcc, 0, v8, vcc
; TAHITI-NEXT:    v_madmk_f32 v11, v18, 0x4f800000, v11
; TAHITI-NEXT:    v_rcp_f32_e32 v11, v11
; TAHITI-NEXT:    v_mul_f32_e32 v11, 0x5f7ffffc, v11
; TAHITI-NEXT:    v_mul_f32_e32 v18, 0x2f800000, v11
; TAHITI-NEXT:    v_trunc_f32_e32 v18, v18
; TAHITI-NEXT:    v_madmk_f32 v11, v18, 0xcf800000, v11
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v18, v18
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v11, v11
; TAHITI-NEXT:    v_mul_lo_u32 v22, v19, v18
; TAHITI-NEXT:    v_mul_hi_u32 v21, v19, v11
; TAHITI-NEXT:    v_mul_lo_u32 v23, v20, v11
; TAHITI-NEXT:    v_add_i32_e32 v21, vcc, v22, v21
; TAHITI-NEXT:    v_mul_lo_u32 v22, v19, v11
; TAHITI-NEXT:    v_add_i32_e32 v21, vcc, v21, v23
; TAHITI-NEXT:    v_mul_lo_u32 v23, v11, v21
; TAHITI-NEXT:    v_mul_hi_u32 v24, v11, v22
; TAHITI-NEXT:    v_mul_hi_u32 v25, v11, v21
; TAHITI-NEXT:    v_mul_hi_u32 v26, v18, v21
; TAHITI-NEXT:    v_mul_lo_u32 v21, v18, v21
; TAHITI-NEXT:    v_add_i32_e32 v23, vcc, v24, v23
; TAHITI-NEXT:    v_addc_u32_e32 v24, vcc, 0, v25, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v25, v18, v22
; TAHITI-NEXT:    v_mul_hi_u32 v22, v18, v22
; TAHITI-NEXT:    v_add_i32_e32 v23, vcc, v23, v25
; TAHITI-NEXT:    v_addc_u32_e32 v22, vcc, v24, v22, vcc
; TAHITI-NEXT:    v_addc_u32_e32 v23, vcc, 0, v26, vcc
; TAHITI-NEXT:    v_add_i32_e32 v21, vcc, v22, v21
; TAHITI-NEXT:    v_addc_u32_e32 v22, vcc, 0, v23, vcc
; TAHITI-NEXT:    v_add_i32_e32 v11, vcc, v11, v21
; TAHITI-NEXT:    v_addc_u32_e32 v18, vcc, v18, v22, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v21, v19, v18
; TAHITI-NEXT:    v_mul_hi_u32 v22, v19, v11
; TAHITI-NEXT:    v_mul_lo_u32 v20, v20, v11
; TAHITI-NEXT:    v_mul_lo_u32 v19, v19, v11
; TAHITI-NEXT:    v_add_i32_e32 v21, vcc, v21, v22
; TAHITI-NEXT:    v_add_i32_e32 v20, vcc, v21, v20
; TAHITI-NEXT:    v_mul_lo_u32 v23, v11, v20
; TAHITI-NEXT:    v_mul_hi_u32 v24, v11, v19
; TAHITI-NEXT:    v_mul_hi_u32 v25, v11, v20
; TAHITI-NEXT:    v_mul_hi_u32 v22, v18, v19
; TAHITI-NEXT:    v_mul_lo_u32 v19, v18, v19
; TAHITI-NEXT:    v_mul_hi_u32 v21, v18, v20
; TAHITI-NEXT:    v_add_i32_e32 v23, vcc, v24, v23
; TAHITI-NEXT:    v_addc_u32_e32 v24, vcc, 0, v25, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v20, v18, v20
; TAHITI-NEXT:    v_add_i32_e32 v19, vcc, v23, v19
; TAHITI-NEXT:    v_addc_u32_e32 v19, vcc, v24, v22, vcc
; TAHITI-NEXT:    v_addc_u32_e32 v21, vcc, 0, v21, vcc
; TAHITI-NEXT:    v_add_i32_e32 v19, vcc, v19, v20
; TAHITI-NEXT:    v_addc_u32_e32 v20, vcc, 0, v21, vcc
; TAHITI-NEXT:    v_add_i32_e32 v11, vcc, v11, v19
; TAHITI-NEXT:    v_addc_u32_e32 v18, vcc, v18, v20, vcc
; TAHITI-NEXT:    v_ashrrev_i32_e32 v19, 31, v15
; TAHITI-NEXT:    v_add_i32_e32 v20, vcc, v14, v19
; TAHITI-NEXT:    v_xor_b32_e32 v20, v20, v19
; TAHITI-NEXT:    v_mul_lo_u32 v21, v20, v18
; TAHITI-NEXT:    v_mul_hi_u32 v22, v20, v11
; TAHITI-NEXT:    v_mul_hi_u32 v23, v20, v18
; TAHITI-NEXT:    v_addc_u32_e32 v15, vcc, v15, v19, vcc
; TAHITI-NEXT:    v_xor_b32_e32 v15, v15, v19
; TAHITI-NEXT:    v_add_i32_e32 v21, vcc, v22, v21
; TAHITI-NEXT:    v_addc_u32_e32 v22, vcc, 0, v23, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v23, v15, v11
; TAHITI-NEXT:    v_mul_hi_u32 v11, v15, v11
; TAHITI-NEXT:    v_mul_hi_u32 v24, v15, v18
; TAHITI-NEXT:    v_mul_lo_u32 v18, v15, v18
; TAHITI-NEXT:    v_add_i32_e32 v21, vcc, v21, v23
; TAHITI-NEXT:    v_addc_u32_e32 v11, vcc, v22, v11, vcc
; TAHITI-NEXT:    v_addc_u32_e32 v21, vcc, 0, v24, vcc
; TAHITI-NEXT:    v_add_i32_e32 v11, vcc, v11, v18
; TAHITI-NEXT:    v_addc_u32_e32 v18, vcc, 0, v21, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v18, v9, v18
; TAHITI-NEXT:    v_mul_hi_u32 v21, v9, v11
; TAHITI-NEXT:    v_mul_lo_u32 v22, v8, v11
; TAHITI-NEXT:    v_mul_lo_u32 v11, v9, v11
; TAHITI-NEXT:    v_add_i32_e32 v18, vcc, v18, v21
; TAHITI-NEXT:    v_add_i32_e32 v18, vcc, v22, v18
; TAHITI-NEXT:    v_sub_i32_e32 v21, vcc, v15, v18
; TAHITI-NEXT:    v_sub_i32_e32 v11, vcc, v20, v11
; TAHITI-NEXT:    v_subb_u32_e64 v20, s[0:1], v21, v8, vcc
; TAHITI-NEXT:    v_sub_i32_e64 v21, s[0:1], v11, v9
; TAHITI-NEXT:    v_subbrev_u32_e64 v22, s[2:3], 0, v20, s[0:1]
; TAHITI-NEXT:    v_cmp_ge_u32_e64 s[2:3], v22, v8
; TAHITI-NEXT:    v_cndmask_b32_e64 v23, 0, -1, s[2:3]
; TAHITI-NEXT:    v_cmp_ge_u32_e64 s[2:3], v21, v9
; TAHITI-NEXT:    v_subb_u32_e32 v15, vcc, v15, v18, vcc
; TAHITI-NEXT:    v_cndmask_b32_e64 v24, 0, -1, s[2:3]
; TAHITI-NEXT:    v_cmp_eq_u32_e64 s[2:3], v22, v8
; TAHITI-NEXT:    v_subb_u32_e64 v20, s[0:1], v20, v8, s[0:1]
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v15, v8
; TAHITI-NEXT:    v_cndmask_b32_e64 v23, v23, v24, s[2:3]
; TAHITI-NEXT:    v_sub_i32_e64 v24, s[0:1], v21, v9
; TAHITI-NEXT:    v_cndmask_b32_e64 v18, 0, -1, vcc
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v11, v9
; TAHITI-NEXT:    v_subbrev_u32_e64 v20, s[0:1], 0, v20, s[0:1]
; TAHITI-NEXT:    v_cndmask_b32_e64 v9, 0, -1, vcc
; TAHITI-NEXT:    v_cmp_eq_u32_e32 vcc, v15, v8
; TAHITI-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v23
; TAHITI-NEXT:    v_cndmask_b32_e32 v8, v18, v9, vcc
; TAHITI-NEXT:    v_cndmask_b32_e64 v21, v21, v24, s[0:1]
; TAHITI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; TAHITI-NEXT:    v_cndmask_b32_e64 v20, v22, v20, s[0:1]
; TAHITI-NEXT:    v_cndmask_b32_e32 v9, v11, v21, vcc
; TAHITI-NEXT:    v_cndmask_b32_e32 v8, v15, v20, vcc
; TAHITI-NEXT:    v_xor_b32_e32 v9, v9, v19
; TAHITI-NEXT:    v_xor_b32_e32 v11, v8, v19
; TAHITI-NEXT:    v_sub_i32_e32 v8, vcc, v9, v19
; TAHITI-NEXT:    v_subb_u32_e32 v9, vcc, v11, v19, vcc
; TAHITI-NEXT:    s_cbranch_execnz .LBB12_3
; TAHITI-NEXT:  .LBB12_2:
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v8, v10
; TAHITI-NEXT:    v_sub_i32_e32 v9, vcc, 0, v10
; TAHITI-NEXT:    v_rcp_iflag_f32_e32 v8, v8
; TAHITI-NEXT:    v_mul_f32_e32 v8, 0x4f7ffffe, v8
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v8, v8
; TAHITI-NEXT:    v_mul_lo_u32 v9, v9, v8
; TAHITI-NEXT:    v_mul_hi_u32 v9, v8, v9
; TAHITI-NEXT:    v_add_i32_e32 v8, vcc, v8, v9
; TAHITI-NEXT:    v_mul_hi_u32 v8, v14, v8
; TAHITI-NEXT:    v_mul_lo_u32 v8, v8, v10
; TAHITI-NEXT:    v_sub_i32_e32 v8, vcc, v14, v8
; TAHITI-NEXT:    v_sub_i32_e32 v9, vcc, v8, v10
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v8, v10
; TAHITI-NEXT:    v_cndmask_b32_e32 v8, v8, v9, vcc
; TAHITI-NEXT:    v_sub_i32_e32 v9, vcc, v8, v10
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v8, v10
; TAHITI-NEXT:    v_cndmask_b32_e32 v8, v8, v9, vcc
; TAHITI-NEXT:    v_mov_b32_e32 v9, 0
; TAHITI-NEXT:  .LBB12_3:
; TAHITI-NEXT:    v_or_b32_e32 v11, v17, v13
; TAHITI-NEXT:    v_mov_b32_e32 v10, 0
; TAHITI-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[10:11]
; TAHITI-NEXT:    s_cbranch_vccz .LBB12_14
; TAHITI-NEXT:  ; %bb.4:
; TAHITI-NEXT:    v_ashrrev_i32_e32 v10, 31, v13
; TAHITI-NEXT:    v_add_i32_e32 v11, vcc, v12, v10
; TAHITI-NEXT:    v_addc_u32_e32 v13, vcc, v13, v10, vcc
; TAHITI-NEXT:    v_xor_b32_e32 v11, v11, v10
; TAHITI-NEXT:    v_xor_b32_e32 v10, v13, v10
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v13, v11
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v14, v10
; TAHITI-NEXT:    v_sub_i32_e32 v15, vcc, 0, v11
; TAHITI-NEXT:    v_subb_u32_e32 v18, vcc, 0, v10, vcc
; TAHITI-NEXT:    v_madmk_f32 v13, v14, 0x4f800000, v13
; TAHITI-NEXT:    v_rcp_f32_e32 v13, v13
; TAHITI-NEXT:    v_mul_f32_e32 v13, 0x5f7ffffc, v13
; TAHITI-NEXT:    v_mul_f32_e32 v14, 0x2f800000, v13
; TAHITI-NEXT:    v_trunc_f32_e32 v14, v14
; TAHITI-NEXT:    v_madmk_f32 v13, v14, 0xcf800000, v13
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v14, v14
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v13, v13
; TAHITI-NEXT:    v_mul_lo_u32 v20, v15, v14
; TAHITI-NEXT:    v_mul_hi_u32 v19, v15, v13
; TAHITI-NEXT:    v_mul_lo_u32 v21, v18, v13
; TAHITI-NEXT:    v_add_i32_e32 v19, vcc, v20, v19
; TAHITI-NEXT:    v_mul_lo_u32 v20, v15, v13
; TAHITI-NEXT:    v_add_i32_e32 v19, vcc, v19, v21
; TAHITI-NEXT:    v_mul_lo_u32 v21, v13, v19
; TAHITI-NEXT:    v_mul_hi_u32 v22, v13, v20
; TAHITI-NEXT:    v_mul_hi_u32 v23, v13, v19
; TAHITI-NEXT:    v_mul_hi_u32 v24, v14, v19
; TAHITI-NEXT:    v_mul_lo_u32 v19, v14, v19
; TAHITI-NEXT:    v_add_i32_e32 v21, vcc, v22, v21
; TAHITI-NEXT:    v_addc_u32_e32 v22, vcc, 0, v23, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v23, v14, v20
; TAHITI-NEXT:    v_mul_hi_u32 v20, v14, v20
; TAHITI-NEXT:    v_add_i32_e32 v21, vcc, v21, v23
; TAHITI-NEXT:    v_addc_u32_e32 v20, vcc, v22, v20, vcc
; TAHITI-NEXT:    v_addc_u32_e32 v21, vcc, 0, v24, vcc
; TAHITI-NEXT:    v_add_i32_e32 v19, vcc, v20, v19
; TAHITI-NEXT:    v_addc_u32_e32 v20, vcc, 0, v21, vcc
; TAHITI-NEXT:    v_add_i32_e32 v13, vcc, v13, v19
; TAHITI-NEXT:    v_addc_u32_e32 v14, vcc, v14, v20, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v19, v15, v14
; TAHITI-NEXT:    v_mul_hi_u32 v20, v15, v13
; TAHITI-NEXT:    v_mul_lo_u32 v18, v18, v13
; TAHITI-NEXT:    v_mul_lo_u32 v15, v15, v13
; TAHITI-NEXT:    v_add_i32_e32 v19, vcc, v19, v20
; TAHITI-NEXT:    v_add_i32_e32 v18, vcc, v19, v18
; TAHITI-NEXT:    v_mul_lo_u32 v21, v13, v18
; TAHITI-NEXT:    v_mul_hi_u32 v22, v13, v15
; TAHITI-NEXT:    v_mul_hi_u32 v23, v13, v18
; TAHITI-NEXT:    v_mul_hi_u32 v20, v14, v15
; TAHITI-NEXT:    v_mul_lo_u32 v15, v14, v15
; TAHITI-NEXT:    v_mul_hi_u32 v19, v14, v18
; TAHITI-NEXT:    v_add_i32_e32 v21, vcc, v22, v21
; TAHITI-NEXT:    v_addc_u32_e32 v22, vcc, 0, v23, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v18, v14, v18
; TAHITI-NEXT:    v_add_i32_e32 v15, vcc, v21, v15
; TAHITI-NEXT:    v_addc_u32_e32 v15, vcc, v22, v20, vcc
; TAHITI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; TAHITI-NEXT:    v_add_i32_e32 v15, vcc, v15, v18
; TAHITI-NEXT:    v_addc_u32_e32 v18, vcc, 0, v19, vcc
; TAHITI-NEXT:    v_add_i32_e32 v13, vcc, v13, v15
; TAHITI-NEXT:    v_addc_u32_e32 v14, vcc, v14, v18, vcc
; TAHITI-NEXT:    v_ashrrev_i32_e32 v15, 31, v17
; TAHITI-NEXT:    v_add_i32_e32 v18, vcc, v16, v15
; TAHITI-NEXT:    v_xor_b32_e32 v18, v18, v15
; TAHITI-NEXT:    v_mul_lo_u32 v19, v18, v14
; TAHITI-NEXT:    v_mul_hi_u32 v20, v18, v13
; TAHITI-NEXT:    v_mul_hi_u32 v21, v18, v14
; TAHITI-NEXT:    v_addc_u32_e32 v17, vcc, v17, v15, vcc
; TAHITI-NEXT:    v_xor_b32_e32 v17, v17, v15
; TAHITI-NEXT:    v_add_i32_e32 v19, vcc, v20, v19
; TAHITI-NEXT:    v_addc_u32_e32 v20, vcc, 0, v21, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v21, v17, v13
; TAHITI-NEXT:    v_mul_hi_u32 v13, v17, v13
; TAHITI-NEXT:    v_mul_hi_u32 v22, v17, v14
; TAHITI-NEXT:    v_mul_lo_u32 v14, v17, v14
; TAHITI-NEXT:    v_add_i32_e32 v19, vcc, v19, v21
; TAHITI-NEXT:    v_addc_u32_e32 v13, vcc, v20, v13, vcc
; TAHITI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v22, vcc
; TAHITI-NEXT:    v_add_i32_e32 v13, vcc, v13, v14
; TAHITI-NEXT:    v_addc_u32_e32 v14, vcc, 0, v19, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v14, v11, v14
; TAHITI-NEXT:    v_mul_hi_u32 v19, v11, v13
; TAHITI-NEXT:    v_mul_lo_u32 v20, v10, v13
; TAHITI-NEXT:    v_mul_lo_u32 v13, v11, v13
; TAHITI-NEXT:    v_add_i32_e32 v14, vcc, v14, v19
; TAHITI-NEXT:    v_add_i32_e32 v14, vcc, v20, v14
; TAHITI-NEXT:    v_sub_i32_e32 v19, vcc, v17, v14
; TAHITI-NEXT:    v_sub_i32_e32 v13, vcc, v18, v13
; TAHITI-NEXT:    v_subb_u32_e64 v18, s[0:1], v19, v10, vcc
; TAHITI-NEXT:    v_sub_i32_e64 v19, s[0:1], v13, v11
; TAHITI-NEXT:    v_subbrev_u32_e64 v20, s[2:3], 0, v18, s[0:1]
; TAHITI-NEXT:    v_cmp_ge_u32_e64 s[2:3], v20, v10
; TAHITI-NEXT:    v_cndmask_b32_e64 v21, 0, -1, s[2:3]
; TAHITI-NEXT:    v_cmp_ge_u32_e64 s[2:3], v19, v11
; TAHITI-NEXT:    v_subb_u32_e32 v14, vcc, v17, v14, vcc
; TAHITI-NEXT:    v_cndmask_b32_e64 v22, 0, -1, s[2:3]
; TAHITI-NEXT:    v_cmp_eq_u32_e64 s[2:3], v20, v10
; TAHITI-NEXT:    v_subb_u32_e64 v18, s[0:1], v18, v10, s[0:1]
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v14, v10
; TAHITI-NEXT:    v_cndmask_b32_e64 v21, v21, v22, s[2:3]
; TAHITI-NEXT:    v_sub_i32_e64 v22, s[0:1], v19, v11
; TAHITI-NEXT:    v_cndmask_b32_e64 v17, 0, -1, vcc
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v13, v11
; TAHITI-NEXT:    v_subbrev_u32_e64 v18, s[0:1], 0, v18, s[0:1]
; TAHITI-NEXT:    v_cndmask_b32_e64 v11, 0, -1, vcc
; TAHITI-NEXT:    v_cmp_eq_u32_e32 vcc, v14, v10
; TAHITI-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v21
; TAHITI-NEXT:    v_cndmask_b32_e32 v10, v17, v11, vcc
; TAHITI-NEXT:    v_cndmask_b32_e64 v19, v19, v22, s[0:1]
; TAHITI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v10
; TAHITI-NEXT:    v_cndmask_b32_e64 v18, v20, v18, s[0:1]
; TAHITI-NEXT:    v_cndmask_b32_e32 v11, v13, v19, vcc
; TAHITI-NEXT:    v_cndmask_b32_e32 v10, v14, v18, vcc
; TAHITI-NEXT:    v_xor_b32_e32 v11, v11, v15
; TAHITI-NEXT:    v_xor_b32_e32 v13, v10, v15
; TAHITI-NEXT:    v_sub_i32_e32 v10, vcc, v11, v15
; TAHITI-NEXT:    v_subb_u32_e32 v11, vcc, v13, v15, vcc
; TAHITI-NEXT:    s_cbranch_execnz .LBB12_6
; TAHITI-NEXT:  .LBB12_5:
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v10, v12
; TAHITI-NEXT:    v_sub_i32_e32 v11, vcc, 0, v12
; TAHITI-NEXT:    v_rcp_iflag_f32_e32 v10, v10
; TAHITI-NEXT:    v_mul_f32_e32 v10, 0x4f7ffffe, v10
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v10, v10
; TAHITI-NEXT:    v_mul_lo_u32 v11, v11, v10
; TAHITI-NEXT:    v_mul_hi_u32 v11, v10, v11
; TAHITI-NEXT:    v_add_i32_e32 v10, vcc, v10, v11
; TAHITI-NEXT:    v_mul_hi_u32 v10, v16, v10
; TAHITI-NEXT:    v_mul_lo_u32 v10, v10, v12
; TAHITI-NEXT:    v_sub_i32_e32 v10, vcc, v16, v10
; TAHITI-NEXT:    v_subrev_i32_e32 v11, vcc, v12, v10
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v10, v12
; TAHITI-NEXT:    v_cndmask_b32_e32 v10, v10, v11, vcc
; TAHITI-NEXT:    v_subrev_i32_e32 v11, vcc, v12, v10
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v10, v12
; TAHITI-NEXT:    v_cndmask_b32_e32 v10, v10, v11, vcc
; TAHITI-NEXT:    v_mov_b32_e32 v11, 0
; TAHITI-NEXT:  .LBB12_6:
; TAHITI-NEXT:    s_waitcnt vmcnt(0)
; TAHITI-NEXT:    v_or_b32_e32 v13, v5, v1
; TAHITI-NEXT:    v_mov_b32_e32 v12, 0
; TAHITI-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[12:13]
; TAHITI-NEXT:    s_cbranch_vccz .LBB12_15
; TAHITI-NEXT:  ; %bb.7:
; TAHITI-NEXT:    v_ashrrev_i32_e32 v13, 31, v1
; TAHITI-NEXT:    v_add_i32_e32 v12, vcc, v0, v13
; TAHITI-NEXT:    v_addc_u32_e32 v1, vcc, v1, v13, vcc
; TAHITI-NEXT:    v_xor_b32_e32 v12, v12, v13
; TAHITI-NEXT:    v_xor_b32_e32 v1, v1, v13
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v13, v12
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v14, v1
; TAHITI-NEXT:    v_sub_i32_e32 v15, vcc, 0, v12
; TAHITI-NEXT:    v_subb_u32_e32 v16, vcc, 0, v1, vcc
; TAHITI-NEXT:    v_madmk_f32 v13, v14, 0x4f800000, v13
; TAHITI-NEXT:    v_rcp_f32_e32 v13, v13
; TAHITI-NEXT:    v_mul_f32_e32 v13, 0x5f7ffffc, v13
; TAHITI-NEXT:    v_mul_f32_e32 v14, 0x2f800000, v13
; TAHITI-NEXT:    v_trunc_f32_e32 v14, v14
; TAHITI-NEXT:    v_madmk_f32 v13, v14, 0xcf800000, v13
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v14, v14
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v13, v13
; TAHITI-NEXT:    v_mul_lo_u32 v18, v15, v14
; TAHITI-NEXT:    v_mul_hi_u32 v17, v15, v13
; TAHITI-NEXT:    v_mul_lo_u32 v19, v16, v13
; TAHITI-NEXT:    v_add_i32_e32 v17, vcc, v18, v17
; TAHITI-NEXT:    v_mul_lo_u32 v18, v15, v13
; TAHITI-NEXT:    v_add_i32_e32 v17, vcc, v17, v19
; TAHITI-NEXT:    v_mul_lo_u32 v19, v13, v17
; TAHITI-NEXT:    v_mul_hi_u32 v20, v13, v18
; TAHITI-NEXT:    v_mul_hi_u32 v21, v13, v17
; TAHITI-NEXT:    v_mul_hi_u32 v22, v14, v17
; TAHITI-NEXT:    v_mul_lo_u32 v17, v14, v17
; TAHITI-NEXT:    v_add_i32_e32 v19, vcc, v20, v19
; TAHITI-NEXT:    v_addc_u32_e32 v20, vcc, 0, v21, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v21, v14, v18
; TAHITI-NEXT:    v_mul_hi_u32 v18, v14, v18
; TAHITI-NEXT:    v_add_i32_e32 v19, vcc, v19, v21
; TAHITI-NEXT:    v_addc_u32_e32 v18, vcc, v20, v18, vcc
; TAHITI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v22, vcc
; TAHITI-NEXT:    v_add_i32_e32 v17, vcc, v18, v17
; TAHITI-NEXT:    v_addc_u32_e32 v18, vcc, 0, v19, vcc
; TAHITI-NEXT:    v_add_i32_e32 v13, vcc, v13, v17
; TAHITI-NEXT:    v_addc_u32_e32 v14, vcc, v14, v18, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v17, v15, v14
; TAHITI-NEXT:    v_mul_hi_u32 v18, v15, v13
; TAHITI-NEXT:    v_mul_lo_u32 v16, v16, v13
; TAHITI-NEXT:    v_mul_lo_u32 v15, v15, v13
; TAHITI-NEXT:    v_add_i32_e32 v17, vcc, v17, v18
; TAHITI-NEXT:    v_add_i32_e32 v16, vcc, v17, v16
; TAHITI-NEXT:    v_mul_lo_u32 v19, v13, v16
; TAHITI-NEXT:    v_mul_hi_u32 v20, v13, v15
; TAHITI-NEXT:    v_mul_hi_u32 v21, v13, v16
; TAHITI-NEXT:    v_mul_hi_u32 v18, v14, v15
; TAHITI-NEXT:    v_mul_lo_u32 v15, v14, v15
; TAHITI-NEXT:    v_mul_hi_u32 v17, v14, v16
; TAHITI-NEXT:    v_add_i32_e32 v19, vcc, v20, v19
; TAHITI-NEXT:    v_addc_u32_e32 v20, vcc, 0, v21, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v16, v14, v16
; TAHITI-NEXT:    v_add_i32_e32 v15, vcc, v19, v15
; TAHITI-NEXT:    v_addc_u32_e32 v15, vcc, v20, v18, vcc
; TAHITI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; TAHITI-NEXT:    v_add_i32_e32 v15, vcc, v15, v16
; TAHITI-NEXT:    v_addc_u32_e32 v16, vcc, 0, v17, vcc
; TAHITI-NEXT:    v_add_i32_e32 v13, vcc, v13, v15
; TAHITI-NEXT:    v_addc_u32_e32 v14, vcc, v14, v16, vcc
; TAHITI-NEXT:    v_ashrrev_i32_e32 v15, 31, v5
; TAHITI-NEXT:    v_add_i32_e32 v16, vcc, v4, v15
; TAHITI-NEXT:    v_xor_b32_e32 v16, v16, v15
; TAHITI-NEXT:    v_mul_lo_u32 v17, v16, v14
; TAHITI-NEXT:    v_mul_hi_u32 v18, v16, v13
; TAHITI-NEXT:    v_mul_hi_u32 v19, v16, v14
; TAHITI-NEXT:    v_addc_u32_e32 v5, vcc, v5, v15, vcc
; TAHITI-NEXT:    v_xor_b32_e32 v5, v5, v15
; TAHITI-NEXT:    v_add_i32_e32 v17, vcc, v18, v17
; TAHITI-NEXT:    v_addc_u32_e32 v18, vcc, 0, v19, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v19, v5, v13
; TAHITI-NEXT:    v_mul_hi_u32 v13, v5, v13
; TAHITI-NEXT:    v_mul_hi_u32 v20, v5, v14
; TAHITI-NEXT:    v_mul_lo_u32 v14, v5, v14
; TAHITI-NEXT:    v_add_i32_e32 v17, vcc, v17, v19
; TAHITI-NEXT:    v_addc_u32_e32 v13, vcc, v18, v13, vcc
; TAHITI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v20, vcc
; TAHITI-NEXT:    v_add_i32_e32 v13, vcc, v13, v14
; TAHITI-NEXT:    v_addc_u32_e32 v14, vcc, 0, v17, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v14, v12, v14
; TAHITI-NEXT:    v_mul_hi_u32 v17, v12, v13
; TAHITI-NEXT:    v_mul_lo_u32 v18, v1, v13
; TAHITI-NEXT:    v_mul_lo_u32 v13, v12, v13
; TAHITI-NEXT:    v_add_i32_e32 v14, vcc, v14, v17
; TAHITI-NEXT:    v_add_i32_e32 v14, vcc, v18, v14
; TAHITI-NEXT:    v_sub_i32_e32 v17, vcc, v5, v14
; TAHITI-NEXT:    v_sub_i32_e32 v13, vcc, v16, v13
; TAHITI-NEXT:    v_subb_u32_e64 v16, s[0:1], v17, v1, vcc
; TAHITI-NEXT:    v_sub_i32_e64 v17, s[0:1], v13, v12
; TAHITI-NEXT:    v_subbrev_u32_e64 v18, s[2:3], 0, v16, s[0:1]
; TAHITI-NEXT:    v_cmp_ge_u32_e64 s[2:3], v18, v1
; TAHITI-NEXT:    v_cndmask_b32_e64 v19, 0, -1, s[2:3]
; TAHITI-NEXT:    v_cmp_ge_u32_e64 s[2:3], v17, v12
; TAHITI-NEXT:    v_subb_u32_e32 v5, vcc, v5, v14, vcc
; TAHITI-NEXT:    v_cndmask_b32_e64 v20, 0, -1, s[2:3]
; TAHITI-NEXT:    v_cmp_eq_u32_e64 s[2:3], v18, v1
; TAHITI-NEXT:    v_subb_u32_e64 v16, s[0:1], v16, v1, s[0:1]
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v5, v1
; TAHITI-NEXT:    v_cndmask_b32_e64 v19, v19, v20, s[2:3]
; TAHITI-NEXT:    v_sub_i32_e64 v20, s[0:1], v17, v12
; TAHITI-NEXT:    v_cndmask_b32_e64 v14, 0, -1, vcc
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v13, v12
; TAHITI-NEXT:    v_subbrev_u32_e64 v16, s[0:1], 0, v16, s[0:1]
; TAHITI-NEXT:    v_cndmask_b32_e64 v12, 0, -1, vcc
; TAHITI-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v1
; TAHITI-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v19
; TAHITI-NEXT:    v_cndmask_b32_e32 v1, v14, v12, vcc
; TAHITI-NEXT:    v_cndmask_b32_e64 v17, v17, v20, s[0:1]
; TAHITI-NEXT:    v_cndmask_b32_e64 v16, v18, v16, s[0:1]
; TAHITI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; TAHITI-NEXT:    v_cndmask_b32_e32 v1, v5, v16, vcc
; TAHITI-NEXT:    v_cndmask_b32_e32 v5, v13, v17, vcc
; TAHITI-NEXT:    v_xor_b32_e32 v5, v5, v15
; TAHITI-NEXT:    v_xor_b32_e32 v1, v1, v15
; TAHITI-NEXT:    v_sub_i32_e32 v12, vcc, v5, v15
; TAHITI-NEXT:    v_subb_u32_e32 v13, vcc, v1, v15, vcc
; TAHITI-NEXT:    s_cbranch_execnz .LBB12_9
; TAHITI-NEXT:  .LBB12_8:
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v1, v0
; TAHITI-NEXT:    v_sub_i32_e32 v5, vcc, 0, v0
; TAHITI-NEXT:    v_mov_b32_e32 v13, 0
; TAHITI-NEXT:    v_rcp_iflag_f32_e32 v1, v1
; TAHITI-NEXT:    v_mul_f32_e32 v1, 0x4f7ffffe, v1
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v1, v1
; TAHITI-NEXT:    v_mul_lo_u32 v5, v5, v1
; TAHITI-NEXT:    v_mul_hi_u32 v5, v1, v5
; TAHITI-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; TAHITI-NEXT:    v_mul_hi_u32 v1, v4, v1
; TAHITI-NEXT:    v_mul_lo_u32 v1, v1, v0
; TAHITI-NEXT:    v_sub_i32_e32 v1, vcc, v4, v1
; TAHITI-NEXT:    v_subrev_i32_e32 v4, vcc, v0, v1
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v1, v0
; TAHITI-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; TAHITI-NEXT:    v_subrev_i32_e32 v4, vcc, v0, v1
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v1, v0
; TAHITI-NEXT:    v_cndmask_b32_e32 v12, v1, v4, vcc
; TAHITI-NEXT:  .LBB12_9:
; TAHITI-NEXT:    v_or_b32_e32 v1, v7, v3
; TAHITI-NEXT:    v_mov_b32_e32 v0, 0
; TAHITI-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; TAHITI-NEXT:    s_cbranch_vccz .LBB12_16
; TAHITI-NEXT:  ; %bb.10:
; TAHITI-NEXT:    v_ashrrev_i32_e32 v0, 31, v3
; TAHITI-NEXT:    v_add_i32_e32 v1, vcc, v2, v0
; TAHITI-NEXT:    v_addc_u32_e32 v3, vcc, v3, v0, vcc
; TAHITI-NEXT:    v_xor_b32_e32 v1, v1, v0
; TAHITI-NEXT:    v_xor_b32_e32 v0, v3, v0
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v3, v1
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v4, v0
; TAHITI-NEXT:    v_sub_i32_e32 v5, vcc, 0, v1
; TAHITI-NEXT:    v_subb_u32_e32 v14, vcc, 0, v0, vcc
; TAHITI-NEXT:    v_madmk_f32 v3, v4, 0x4f800000, v3
; TAHITI-NEXT:    v_rcp_f32_e32 v3, v3
; TAHITI-NEXT:    v_mul_f32_e32 v3, 0x5f7ffffc, v3
; TAHITI-NEXT:    v_mul_f32_e32 v4, 0x2f800000, v3
; TAHITI-NEXT:    v_trunc_f32_e32 v4, v4
; TAHITI-NEXT:    v_madmk_f32 v3, v4, 0xcf800000, v3
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v4, v4
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v3, v3
; TAHITI-NEXT:    v_mul_lo_u32 v16, v5, v4
; TAHITI-NEXT:    v_mul_hi_u32 v15, v5, v3
; TAHITI-NEXT:    v_mul_lo_u32 v17, v14, v3
; TAHITI-NEXT:    v_add_i32_e32 v15, vcc, v16, v15
; TAHITI-NEXT:    v_mul_lo_u32 v16, v5, v3
; TAHITI-NEXT:    v_add_i32_e32 v15, vcc, v15, v17
; TAHITI-NEXT:    v_mul_lo_u32 v17, v3, v15
; TAHITI-NEXT:    v_mul_hi_u32 v18, v3, v16
; TAHITI-NEXT:    v_mul_hi_u32 v19, v3, v15
; TAHITI-NEXT:    v_mul_hi_u32 v20, v4, v15
; TAHITI-NEXT:    v_mul_lo_u32 v15, v4, v15
; TAHITI-NEXT:    v_add_i32_e32 v17, vcc, v18, v17
; TAHITI-NEXT:    v_addc_u32_e32 v18, vcc, 0, v19, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v19, v4, v16
; TAHITI-NEXT:    v_mul_hi_u32 v16, v4, v16
; TAHITI-NEXT:    v_add_i32_e32 v17, vcc, v17, v19
; TAHITI-NEXT:    v_addc_u32_e32 v16, vcc, v18, v16, vcc
; TAHITI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v20, vcc
; TAHITI-NEXT:    v_add_i32_e32 v15, vcc, v16, v15
; TAHITI-NEXT:    v_addc_u32_e32 v16, vcc, 0, v17, vcc
; TAHITI-NEXT:    v_add_i32_e32 v3, vcc, v3, v15
; TAHITI-NEXT:    v_addc_u32_e32 v4, vcc, v4, v16, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v15, v5, v4
; TAHITI-NEXT:    v_mul_hi_u32 v16, v5, v3
; TAHITI-NEXT:    v_mul_lo_u32 v14, v14, v3
; TAHITI-NEXT:    v_mul_lo_u32 v5, v5, v3
; TAHITI-NEXT:    v_add_i32_e32 v15, vcc, v15, v16
; TAHITI-NEXT:    v_add_i32_e32 v14, vcc, v15, v14
; TAHITI-NEXT:    v_mul_lo_u32 v17, v3, v14
; TAHITI-NEXT:    v_mul_hi_u32 v18, v3, v5
; TAHITI-NEXT:    v_mul_hi_u32 v19, v3, v14
; TAHITI-NEXT:    v_mul_hi_u32 v16, v4, v5
; TAHITI-NEXT:    v_mul_lo_u32 v5, v4, v5
; TAHITI-NEXT:    v_mul_hi_u32 v15, v4, v14
; TAHITI-NEXT:    v_add_i32_e32 v17, vcc, v18, v17
; TAHITI-NEXT:    v_addc_u32_e32 v18, vcc, 0, v19, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v14, v4, v14
; TAHITI-NEXT:    v_add_i32_e32 v5, vcc, v17, v5
; TAHITI-NEXT:    v_addc_u32_e32 v5, vcc, v18, v16, vcc
; TAHITI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; TAHITI-NEXT:    v_add_i32_e32 v5, vcc, v5, v14
; TAHITI-NEXT:    v_addc_u32_e32 v14, vcc, 0, v15, vcc
; TAHITI-NEXT:    v_add_i32_e32 v3, vcc, v3, v5
; TAHITI-NEXT:    v_addc_u32_e32 v4, vcc, v4, v14, vcc
; TAHITI-NEXT:    v_ashrrev_i32_e32 v5, 31, v7
; TAHITI-NEXT:    v_add_i32_e32 v14, vcc, v6, v5
; TAHITI-NEXT:    v_xor_b32_e32 v14, v14, v5
; TAHITI-NEXT:    v_mul_lo_u32 v15, v14, v4
; TAHITI-NEXT:    v_mul_hi_u32 v16, v14, v3
; TAHITI-NEXT:    v_mul_hi_u32 v17, v14, v4
; TAHITI-NEXT:    v_addc_u32_e32 v7, vcc, v7, v5, vcc
; TAHITI-NEXT:    v_xor_b32_e32 v7, v7, v5
; TAHITI-NEXT:    v_add_i32_e32 v15, vcc, v16, v15
; TAHITI-NEXT:    v_addc_u32_e32 v16, vcc, 0, v17, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v17, v7, v3
; TAHITI-NEXT:    v_mul_hi_u32 v3, v7, v3
; TAHITI-NEXT:    v_mul_hi_u32 v18, v7, v4
; TAHITI-NEXT:    v_mul_lo_u32 v4, v7, v4
; TAHITI-NEXT:    v_add_i32_e32 v15, vcc, v15, v17
; TAHITI-NEXT:    v_addc_u32_e32 v3, vcc, v16, v3, vcc
; TAHITI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v18, vcc
; TAHITI-NEXT:    v_add_i32_e32 v3, vcc, v3, v4
; TAHITI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v15, vcc
; TAHITI-NEXT:    v_mul_lo_u32 v4, v1, v4
; TAHITI-NEXT:    v_mul_hi_u32 v15, v1, v3
; TAHITI-NEXT:    v_mul_lo_u32 v16, v0, v3
; TAHITI-NEXT:    v_mul_lo_u32 v3, v1, v3
; TAHITI-NEXT:    v_add_i32_e32 v4, vcc, v4, v15
; TAHITI-NEXT:    v_add_i32_e32 v4, vcc, v16, v4
; TAHITI-NEXT:    v_sub_i32_e32 v15, vcc, v7, v4
; TAHITI-NEXT:    v_sub_i32_e32 v3, vcc, v14, v3
; TAHITI-NEXT:    v_subb_u32_e64 v14, s[0:1], v15, v0, vcc
; TAHITI-NEXT:    v_sub_i32_e64 v15, s[0:1], v3, v1
; TAHITI-NEXT:    v_subbrev_u32_e64 v16, s[2:3], 0, v14, s[0:1]
; TAHITI-NEXT:    v_cmp_ge_u32_e64 s[2:3], v16, v0
; TAHITI-NEXT:    v_cndmask_b32_e64 v17, 0, -1, s[2:3]
; TAHITI-NEXT:    v_cmp_ge_u32_e64 s[2:3], v15, v1
; TAHITI-NEXT:    v_subb_u32_e32 v4, vcc, v7, v4, vcc
; TAHITI-NEXT:    v_cndmask_b32_e64 v18, 0, -1, s[2:3]
; TAHITI-NEXT:    v_cmp_eq_u32_e64 s[2:3], v16, v0
; TAHITI-NEXT:    v_subb_u32_e64 v14, s[0:1], v14, v0, s[0:1]
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v4, v0
; TAHITI-NEXT:    v_cndmask_b32_e64 v17, v17, v18, s[2:3]
; TAHITI-NEXT:    v_sub_i32_e64 v18, s[0:1], v15, v1
; TAHITI-NEXT:    v_cndmask_b32_e64 v7, 0, -1, vcc
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v3, v1
; TAHITI-NEXT:    v_subbrev_u32_e64 v14, s[0:1], 0, v14, s[0:1]
; TAHITI-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc
; TAHITI-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v0
; TAHITI-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v17
; TAHITI-NEXT:    v_cndmask_b32_e32 v0, v7, v1, vcc
; TAHITI-NEXT:    v_cndmask_b32_e64 v15, v15, v18, s[0:1]
; TAHITI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; TAHITI-NEXT:    v_cndmask_b32_e64 v14, v16, v14, s[0:1]
; TAHITI-NEXT:    v_cndmask_b32_e32 v1, v3, v15, vcc
; TAHITI-NEXT:    v_cndmask_b32_e32 v0, v4, v14, vcc
; TAHITI-NEXT:    v_xor_b32_e32 v1, v1, v5
; TAHITI-NEXT:    v_xor_b32_e32 v0, v0, v5
; TAHITI-NEXT:    v_sub_i32_e32 v14, vcc, v1, v5
; TAHITI-NEXT:    v_subb_u32_e32 v15, vcc, v0, v5, vcc
; TAHITI-NEXT:    s_cbranch_execnz .LBB12_12
; TAHITI-NEXT:  .LBB12_11:
; TAHITI-NEXT:    v_cvt_f32_u32_e32 v0, v2
; TAHITI-NEXT:    v_sub_i32_e32 v1, vcc, 0, v2
; TAHITI-NEXT:    v_mov_b32_e32 v15, 0
; TAHITI-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; TAHITI-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; TAHITI-NEXT:    v_cvt_u32_f32_e32 v0, v0
; TAHITI-NEXT:    v_mul_lo_u32 v1, v1, v0
; TAHITI-NEXT:    v_mul_hi_u32 v1, v0, v1
; TAHITI-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; TAHITI-NEXT:    v_mul_hi_u32 v0, v6, v0
; TAHITI-NEXT:    v_mul_lo_u32 v0, v0, v2
; TAHITI-NEXT:    v_sub_i32_e32 v0, vcc, v6, v0
; TAHITI-NEXT:    v_subrev_i32_e32 v1, vcc, v2, v0
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v2
; TAHITI-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; TAHITI-NEXT:    v_subrev_i32_e32 v1, vcc, v2, v0
; TAHITI-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v2
; TAHITI-NEXT:    v_cndmask_b32_e32 v14, v0, v1, vcc
; TAHITI-NEXT:  .LBB12_12:
; TAHITI-NEXT:    s_mov_b32 s7, 0xf000
; TAHITI-NEXT:    s_mov_b32 s6, -1
; TAHITI-NEXT:    buffer_store_dwordx4 v[12:15], off, s[4:7], 0 offset:16
; TAHITI-NEXT:    buffer_store_dwordx4 v[8:11], off, s[4:7], 0
; TAHITI-NEXT:    s_endpgm
; TAHITI-NEXT:  .LBB12_13:
; TAHITI-NEXT:    ; implicit-def: $vgpr8_vgpr9
; TAHITI-NEXT:    s_branch .LBB12_2
; TAHITI-NEXT:  .LBB12_14:
; TAHITI-NEXT:    s_branch .LBB12_5
; TAHITI-NEXT:  .LBB12_15:
; TAHITI-NEXT:    ; implicit-def: $vgpr12_vgpr13
; TAHITI-NEXT:    s_branch .LBB12_8
; TAHITI-NEXT:  .LBB12_16:
; TAHITI-NEXT:    s_branch .LBB12_11
;
; TONGA-LABEL: srem_v4i64:
; TONGA:       ; %bb.0:
; TONGA-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x24
; TONGA-NEXT:    v_mov_b32_e32 v8, 0
; TONGA-NEXT:    s_waitcnt lgkmcnt(0)
; TONGA-NEXT:    s_add_u32 s0, s6, 48
; TONGA-NEXT:    s_addc_u32 s1, s7, 0
; TONGA-NEXT:    s_add_u32 s2, s6, 32
; TONGA-NEXT:    v_mov_b32_e32 v0, s6
; TONGA-NEXT:    s_addc_u32 s3, s7, 0
; TONGA-NEXT:    v_mov_b32_e32 v2, s2
; TONGA-NEXT:    v_mov_b32_e32 v1, s7
; TONGA-NEXT:    v_mov_b32_e32 v3, s3
; TONGA-NEXT:    flat_load_dwordx4 v[10:13], v[2:3]
; TONGA-NEXT:    flat_load_dwordx4 v[14:17], v[0:1]
; TONGA-NEXT:    v_mov_b32_e32 v0, s0
; TONGA-NEXT:    v_mov_b32_e32 v1, s1
; TONGA-NEXT:    s_add_u32 s0, s6, 16
; TONGA-NEXT:    s_addc_u32 s1, s7, 0
; TONGA-NEXT:    v_mov_b32_e32 v5, s1
; TONGA-NEXT:    v_mov_b32_e32 v4, s0
; TONGA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; TONGA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; TONGA-NEXT:    s_waitcnt vmcnt(2)
; TONGA-NEXT:    v_or_b32_e32 v9, v15, v11
; TONGA-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[8:9]
; TONGA-NEXT:    s_cbranch_vccz .LBB12_13
; TONGA-NEXT:  ; %bb.1:
; TONGA-NEXT:    v_ashrrev_i32_e32 v8, 31, v11
; TONGA-NEXT:    v_add_u32_e32 v9, vcc, v10, v8
; TONGA-NEXT:    v_addc_u32_e32 v11, vcc, v11, v8, vcc
; TONGA-NEXT:    v_xor_b32_e32 v9, v9, v8
; TONGA-NEXT:    v_xor_b32_e32 v8, v11, v8
; TONGA-NEXT:    v_cvt_f32_u32_e32 v11, v9
; TONGA-NEXT:    v_cvt_f32_u32_e32 v18, v8
; TONGA-NEXT:    v_sub_u32_e32 v23, vcc, 0, v9
; TONGA-NEXT:    v_subb_u32_e32 v24, vcc, 0, v8, vcc
; TONGA-NEXT:    v_madmk_f32 v11, v18, 0x4f800000, v11
; TONGA-NEXT:    v_rcp_f32_e32 v11, v11
; TONGA-NEXT:    v_mul_f32_e32 v11, 0x5f7ffffc, v11
; TONGA-NEXT:    v_mul_f32_e32 v18, 0x2f800000, v11
; TONGA-NEXT:    v_trunc_f32_e32 v18, v18
; TONGA-NEXT:    v_madmk_f32 v11, v18, 0xcf800000, v11
; TONGA-NEXT:    v_cvt_u32_f32_e32 v22, v18
; TONGA-NEXT:    v_cvt_u32_f32_e32 v11, v11
; TONGA-NEXT:    v_mul_lo_u32 v20, v23, v22
; TONGA-NEXT:    v_mad_u64_u32 v[18:19], s[0:1], v23, v11, 0
; TONGA-NEXT:    v_mul_lo_u32 v21, v24, v11
; TONGA-NEXT:    v_add_u32_e32 v19, vcc, v19, v20
; TONGA-NEXT:    v_add_u32_e32 v21, vcc, v19, v21
; TONGA-NEXT:    v_mad_u64_u32 v[19:20], s[0:1], v11, v21, 0
; TONGA-NEXT:    v_mul_hi_u32 v25, v11, v18
; TONGA-NEXT:    v_add_u32_e32 v25, vcc, v25, v19
; TONGA-NEXT:    v_mad_u64_u32 v[18:19], s[0:1], v22, v18, 0
; TONGA-NEXT:    v_addc_u32_e32 v26, vcc, 0, v20, vcc
; TONGA-NEXT:    v_mad_u64_u32 v[20:21], s[0:1], v22, v21, 0
; TONGA-NEXT:    v_add_u32_e32 v18, vcc, v25, v18
; TONGA-NEXT:    v_addc_u32_e32 v18, vcc, v26, v19, vcc
; TONGA-NEXT:    v_addc_u32_e32 v19, vcc, 0, v21, vcc
; TONGA-NEXT:    v_add_u32_e32 v18, vcc, v18, v20
; TONGA-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; TONGA-NEXT:    v_add_u32_e32 v11, vcc, v11, v18
; TONGA-NEXT:    v_addc_u32_e32 v25, vcc, v22, v19, vcc
; TONGA-NEXT:    v_mad_u64_u32 v[18:19], s[0:1], v23, v11, 0
; TONGA-NEXT:    v_mul_lo_u32 v22, v23, v25
; TONGA-NEXT:    v_mul_lo_u32 v23, v24, v11
; TONGA-NEXT:    v_mul_hi_u32 v24, v11, v18
; TONGA-NEXT:    v_mad_u64_u32 v[20:21], s[0:1], v25, v18, 0
; TONGA-NEXT:    v_add_u32_e32 v19, vcc, v22, v19
; TONGA-NEXT:    v_add_u32_e32 v19, vcc, v19, v23
; TONGA-NEXT:    v_mad_u64_u32 v[22:23], s[0:1], v11, v19, 0
; TONGA-NEXT:    v_mad_u64_u32 v[18:19], s[0:1], v25, v19, 0
; TONGA-NEXT:    v_add_u32_e32 v22, vcc, v24, v22
; TONGA-NEXT:    v_addc_u32_e32 v23, vcc, 0, v23, vcc
; TONGA-NEXT:    v_add_u32_e32 v20, vcc, v22, v20
; TONGA-NEXT:    v_addc_u32_e32 v20, vcc, v23, v21, vcc
; TONGA-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; TONGA-NEXT:    v_add_u32_e32 v18, vcc, v20, v18
; TONGA-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; TONGA-NEXT:    v_add_u32_e32 v11, vcc, v11, v18
; TONGA-NEXT:    v_addc_u32_e32 v20, vcc, v25, v19, vcc
; TONGA-NEXT:    v_ashrrev_i32_e32 v22, 31, v15
; TONGA-NEXT:    v_add_u32_e32 v18, vcc, v14, v22
; TONGA-NEXT:    v_xor_b32_e32 v23, v18, v22
; TONGA-NEXT:    v_mad_u64_u32 v[18:19], s[0:1], v23, v20, 0
; TONGA-NEXT:    v_mul_hi_u32 v21, v23, v11
; TONGA-NEXT:    v_addc_u32_e32 v15, vcc, v15, v22, vcc
; TONGA-NEXT:    v_xor_b32_e32 v15, v15, v22
; TONGA-NEXT:    v_add_u32_e32 v24, vcc, v21, v18
; TONGA-NEXT:    v_addc_u32_e32 v25, vcc, 0, v19, vcc
; TONGA-NEXT:    v_mad_u64_u32 v[18:19], s[0:1], v15, v11, 0
; TONGA-NEXT:    v_mad_u64_u32 v[20:21], s[0:1], v15, v20, 0
; TONGA-NEXT:    v_add_u32_e32 v11, vcc, v24, v18
; TONGA-NEXT:    v_addc_u32_e32 v11, vcc, v25, v19, vcc
; TONGA-NEXT:    v_addc_u32_e32 v18, vcc, 0, v21, vcc
; TONGA-NEXT:    v_add_u32_e32 v11, vcc, v11, v20
; TONGA-NEXT:    v_addc_u32_e32 v18, vcc, 0, v18, vcc
; TONGA-NEXT:    v_mul_lo_u32 v20, v9, v18
; TONGA-NEXT:    v_mad_u64_u32 v[18:19], s[0:1], v9, v11, 0
; TONGA-NEXT:    v_mul_lo_u32 v11, v8, v11
; TONGA-NEXT:    v_add_u32_e32 v19, vcc, v20, v19
; TONGA-NEXT:    v_add_u32_e32 v11, vcc, v11, v19
; TONGA-NEXT:    v_sub_u32_e32 v19, vcc, v15, v11
; TONGA-NEXT:    v_sub_u32_e32 v18, vcc, v23, v18
; TONGA-NEXT:    v_subb_u32_e64 v19, s[0:1], v19, v8, vcc
; TONGA-NEXT:    v_sub_u32_e64 v20, s[0:1], v18, v9
; TONGA-NEXT:    v_subbrev_u32_e64 v21, s[2:3], 0, v19, s[0:1]
; TONGA-NEXT:    v_cmp_ge_u32_e64 s[2:3], v21, v8
; TONGA-NEXT:    v_cndmask_b32_e64 v23, 0, -1, s[2:3]
; TONGA-NEXT:    v_cmp_ge_u32_e64 s[2:3], v20, v9
; TONGA-NEXT:    v_subb_u32_e32 v11, vcc, v15, v11, vcc
; TONGA-NEXT:    v_cndmask_b32_e64 v24, 0, -1, s[2:3]
; TONGA-NEXT:    v_cmp_eq_u32_e64 s[2:3], v21, v8
; TONGA-NEXT:    v_subb_u32_e64 v19, s[0:1], v19, v8, s[0:1]
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v11, v8
; TONGA-NEXT:    v_cndmask_b32_e64 v23, v23, v24, s[2:3]
; TONGA-NEXT:    v_sub_u32_e64 v24, s[0:1], v20, v9
; TONGA-NEXT:    v_cndmask_b32_e64 v15, 0, -1, vcc
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v18, v9
; TONGA-NEXT:    v_subbrev_u32_e64 v19, s[0:1], 0, v19, s[0:1]
; TONGA-NEXT:    v_cndmask_b32_e64 v9, 0, -1, vcc
; TONGA-NEXT:    v_cmp_eq_u32_e32 vcc, v11, v8
; TONGA-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v23
; TONGA-NEXT:    v_cndmask_b32_e32 v8, v15, v9, vcc
; TONGA-NEXT:    v_cndmask_b32_e64 v20, v20, v24, s[0:1]
; TONGA-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; TONGA-NEXT:    v_cndmask_b32_e64 v19, v21, v19, s[0:1]
; TONGA-NEXT:    v_cndmask_b32_e32 v9, v18, v20, vcc
; TONGA-NEXT:    v_cndmask_b32_e32 v8, v11, v19, vcc
; TONGA-NEXT:    v_xor_b32_e32 v9, v9, v22
; TONGA-NEXT:    v_xor_b32_e32 v11, v8, v22
; TONGA-NEXT:    v_sub_u32_e32 v8, vcc, v9, v22
; TONGA-NEXT:    v_subb_u32_e32 v9, vcc, v11, v22, vcc
; TONGA-NEXT:    s_cbranch_execnz .LBB12_3
; TONGA-NEXT:  .LBB12_2:
; TONGA-NEXT:    v_cvt_f32_u32_e32 v8, v10
; TONGA-NEXT:    v_sub_u32_e32 v9, vcc, 0, v10
; TONGA-NEXT:    v_rcp_iflag_f32_e32 v8, v8
; TONGA-NEXT:    v_mul_f32_e32 v8, 0x4f7ffffe, v8
; TONGA-NEXT:    v_cvt_u32_f32_e32 v8, v8
; TONGA-NEXT:    v_mul_lo_u32 v9, v9, v8
; TONGA-NEXT:    v_mul_hi_u32 v9, v8, v9
; TONGA-NEXT:    v_add_u32_e32 v8, vcc, v8, v9
; TONGA-NEXT:    v_mul_hi_u32 v8, v14, v8
; TONGA-NEXT:    v_mul_lo_u32 v8, v8, v10
; TONGA-NEXT:    v_sub_u32_e32 v8, vcc, v14, v8
; TONGA-NEXT:    v_subrev_u32_e32 v9, vcc, v10, v8
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v8, v10
; TONGA-NEXT:    v_cndmask_b32_e32 v8, v8, v9, vcc
; TONGA-NEXT:    v_sub_u32_e32 v9, vcc, v8, v10
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v8, v10
; TONGA-NEXT:    v_cndmask_b32_e32 v8, v8, v9, vcc
; TONGA-NEXT:    v_mov_b32_e32 v9, 0
; TONGA-NEXT:  .LBB12_3:
; TONGA-NEXT:    v_or_b32_e32 v11, v17, v13
; TONGA-NEXT:    v_mov_b32_e32 v10, 0
; TONGA-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[10:11]
; TONGA-NEXT:    s_cbranch_vccz .LBB12_14
; TONGA-NEXT:  ; %bb.4:
; TONGA-NEXT:    v_ashrrev_i32_e32 v10, 31, v13
; TONGA-NEXT:    v_add_u32_e32 v11, vcc, v12, v10
; TONGA-NEXT:    v_addc_u32_e32 v13, vcc, v13, v10, vcc
; TONGA-NEXT:    v_xor_b32_e32 v15, v11, v10
; TONGA-NEXT:    v_xor_b32_e32 v20, v13, v10
; TONGA-NEXT:    v_cvt_f32_u32_e32 v10, v15
; TONGA-NEXT:    v_cvt_f32_u32_e32 v11, v20
; TONGA-NEXT:    v_sub_u32_e32 v21, vcc, 0, v15
; TONGA-NEXT:    v_subb_u32_e32 v22, vcc, 0, v20, vcc
; TONGA-NEXT:    v_madmk_f32 v10, v11, 0x4f800000, v10
; TONGA-NEXT:    v_rcp_f32_e32 v10, v10
; TONGA-NEXT:    v_mul_f32_e32 v10, 0x5f7ffffc, v10
; TONGA-NEXT:    v_mul_f32_e32 v11, 0x2f800000, v10
; TONGA-NEXT:    v_trunc_f32_e32 v11, v11
; TONGA-NEXT:    v_madmk_f32 v10, v11, 0xcf800000, v10
; TONGA-NEXT:    v_cvt_u32_f32_e32 v18, v11
; TONGA-NEXT:    v_cvt_u32_f32_e32 v19, v10
; TONGA-NEXT:    v_mul_lo_u32 v13, v21, v18
; TONGA-NEXT:    v_mad_u64_u32 v[10:11], s[0:1], v21, v19, 0
; TONGA-NEXT:    v_mul_lo_u32 v14, v22, v19
; TONGA-NEXT:    v_add_u32_e32 v11, vcc, v11, v13
; TONGA-NEXT:    v_add_u32_e32 v23, vcc, v11, v14
; TONGA-NEXT:    v_mad_u64_u32 v[13:14], s[0:1], v19, v23, 0
; TONGA-NEXT:    v_mul_hi_u32 v11, v19, v10
; TONGA-NEXT:    v_add_u32_e32 v24, vcc, v11, v13
; TONGA-NEXT:    v_mad_u64_u32 v[10:11], s[0:1], v18, v10, 0
; TONGA-NEXT:    v_addc_u32_e32 v25, vcc, 0, v14, vcc
; TONGA-NEXT:    v_mad_u64_u32 v[13:14], s[0:1], v18, v23, 0
; TONGA-NEXT:    v_add_u32_e32 v10, vcc, v24, v10
; TONGA-NEXT:    v_addc_u32_e32 v10, vcc, v25, v11, vcc
; TONGA-NEXT:    v_addc_u32_e32 v11, vcc, 0, v14, vcc
; TONGA-NEXT:    v_add_u32_e32 v10, vcc, v10, v13
; TONGA-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; TONGA-NEXT:    v_add_u32_e32 v23, vcc, v19, v10
; TONGA-NEXT:    v_addc_u32_e32 v24, vcc, v18, v11, vcc
; TONGA-NEXT:    v_mad_u64_u32 v[10:11], s[0:1], v21, v23, 0
; TONGA-NEXT:    v_mul_lo_u32 v18, v21, v24
; TONGA-NEXT:    v_mul_lo_u32 v19, v22, v23
; TONGA-NEXT:    v_mul_hi_u32 v21, v23, v10
; TONGA-NEXT:    v_mad_u64_u32 v[13:14], s[0:1], v24, v10, 0
; TONGA-NEXT:    v_add_u32_e32 v11, vcc, v18, v11
; TONGA-NEXT:    v_add_u32_e32 v11, vcc, v11, v19
; TONGA-NEXT:    v_mad_u64_u32 v[18:19], s[0:1], v23, v11, 0
; TONGA-NEXT:    v_mad_u64_u32 v[10:11], s[0:1], v24, v11, 0
; TONGA-NEXT:    v_add_u32_e32 v18, vcc, v21, v18
; TONGA-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; TONGA-NEXT:    v_add_u32_e32 v13, vcc, v18, v13
; TONGA-NEXT:    v_addc_u32_e32 v13, vcc, v19, v14, vcc
; TONGA-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; TONGA-NEXT:    v_add_u32_e32 v10, vcc, v13, v10
; TONGA-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; TONGA-NEXT:    v_add_u32_e32 v13, vcc, v23, v10
; TONGA-NEXT:    v_addc_u32_e32 v14, vcc, v24, v11, vcc
; TONGA-NEXT:    v_ashrrev_i32_e32 v18, 31, v17
; TONGA-NEXT:    v_add_u32_e32 v10, vcc, v16, v18
; TONGA-NEXT:    v_xor_b32_e32 v19, v10, v18
; TONGA-NEXT:    v_mad_u64_u32 v[10:11], s[0:1], v19, v14, 0
; TONGA-NEXT:    v_mul_hi_u32 v21, v19, v13
; TONGA-NEXT:    v_addc_u32_e32 v17, vcc, v17, v18, vcc
; TONGA-NEXT:    v_xor_b32_e32 v17, v17, v18
; TONGA-NEXT:    v_add_u32_e32 v21, vcc, v21, v10
; TONGA-NEXT:    v_addc_u32_e32 v22, vcc, 0, v11, vcc
; TONGA-NEXT:    v_mad_u64_u32 v[10:11], s[0:1], v17, v13, 0
; TONGA-NEXT:    v_mad_u64_u32 v[13:14], s[0:1], v17, v14, 0
; TONGA-NEXT:    v_add_u32_e32 v10, vcc, v21, v10
; TONGA-NEXT:    v_addc_u32_e32 v10, vcc, v22, v11, vcc
; TONGA-NEXT:    v_addc_u32_e32 v11, vcc, 0, v14, vcc
; TONGA-NEXT:    v_add_u32_e32 v13, vcc, v10, v13
; TONGA-NEXT:    v_addc_u32_e32 v10, vcc, 0, v11, vcc
; TONGA-NEXT:    v_mul_lo_u32 v14, v15, v10
; TONGA-NEXT:    v_mad_u64_u32 v[10:11], s[0:1], v15, v13, 0
; TONGA-NEXT:    v_mul_lo_u32 v13, v20, v13
; TONGA-NEXT:    v_add_u32_e32 v11, vcc, v14, v11
; TONGA-NEXT:    v_add_u32_e32 v11, vcc, v13, v11
; TONGA-NEXT:    v_sub_u32_e32 v13, vcc, v17, v11
; TONGA-NEXT:    v_sub_u32_e32 v10, vcc, v19, v10
; TONGA-NEXT:    v_subb_u32_e64 v13, s[0:1], v13, v20, vcc
; TONGA-NEXT:    v_sub_u32_e64 v14, s[0:1], v10, v15
; TONGA-NEXT:    v_subbrev_u32_e64 v19, s[2:3], 0, v13, s[0:1]
; TONGA-NEXT:    v_cmp_ge_u32_e64 s[2:3], v19, v20
; TONGA-NEXT:    v_cndmask_b32_e64 v21, 0, -1, s[2:3]
; TONGA-NEXT:    v_cmp_ge_u32_e64 s[2:3], v14, v15
; TONGA-NEXT:    v_subb_u32_e32 v11, vcc, v17, v11, vcc
; TONGA-NEXT:    v_cndmask_b32_e64 v22, 0, -1, s[2:3]
; TONGA-NEXT:    v_cmp_eq_u32_e64 s[2:3], v19, v20
; TONGA-NEXT:    v_subb_u32_e64 v13, s[0:1], v13, v20, s[0:1]
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v11, v20
; TONGA-NEXT:    v_cndmask_b32_e64 v21, v21, v22, s[2:3]
; TONGA-NEXT:    v_sub_u32_e64 v22, s[0:1], v14, v15
; TONGA-NEXT:    v_cndmask_b32_e64 v17, 0, -1, vcc
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v10, v15
; TONGA-NEXT:    v_subbrev_u32_e64 v13, s[0:1], 0, v13, s[0:1]
; TONGA-NEXT:    v_cndmask_b32_e64 v15, 0, -1, vcc
; TONGA-NEXT:    v_cmp_eq_u32_e32 vcc, v11, v20
; TONGA-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v21
; TONGA-NEXT:    v_cndmask_b32_e32 v15, v17, v15, vcc
; TONGA-NEXT:    v_cndmask_b32_e64 v14, v14, v22, s[0:1]
; TONGA-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v15
; TONGA-NEXT:    v_cndmask_b32_e64 v13, v19, v13, s[0:1]
; TONGA-NEXT:    v_cndmask_b32_e32 v10, v10, v14, vcc
; TONGA-NEXT:    v_cndmask_b32_e32 v11, v11, v13, vcc
; TONGA-NEXT:    v_xor_b32_e32 v10, v10, v18
; TONGA-NEXT:    v_xor_b32_e32 v11, v11, v18
; TONGA-NEXT:    v_sub_u32_e32 v10, vcc, v10, v18
; TONGA-NEXT:    v_subb_u32_e32 v11, vcc, v11, v18, vcc
; TONGA-NEXT:    s_cbranch_execnz .LBB12_6
; TONGA-NEXT:  .LBB12_5:
; TONGA-NEXT:    v_cvt_f32_u32_e32 v10, v12
; TONGA-NEXT:    v_sub_u32_e32 v11, vcc, 0, v12
; TONGA-NEXT:    v_rcp_iflag_f32_e32 v10, v10
; TONGA-NEXT:    v_mul_f32_e32 v10, 0x4f7ffffe, v10
; TONGA-NEXT:    v_cvt_u32_f32_e32 v10, v10
; TONGA-NEXT:    v_mul_lo_u32 v11, v11, v10
; TONGA-NEXT:    v_mul_hi_u32 v11, v10, v11
; TONGA-NEXT:    v_add_u32_e32 v10, vcc, v10, v11
; TONGA-NEXT:    v_mul_hi_u32 v10, v16, v10
; TONGA-NEXT:    v_mul_lo_u32 v10, v10, v12
; TONGA-NEXT:    v_sub_u32_e32 v10, vcc, v16, v10
; TONGA-NEXT:    v_subrev_u32_e32 v11, vcc, v12, v10
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v10, v12
; TONGA-NEXT:    v_cndmask_b32_e32 v10, v10, v11, vcc
; TONGA-NEXT:    v_subrev_u32_e32 v11, vcc, v12, v10
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v10, v12
; TONGA-NEXT:    v_cndmask_b32_e32 v10, v10, v11, vcc
; TONGA-NEXT:    v_mov_b32_e32 v11, 0
; TONGA-NEXT:  .LBB12_6:
; TONGA-NEXT:    s_waitcnt vmcnt(0)
; TONGA-NEXT:    v_or_b32_e32 v13, v5, v1
; TONGA-NEXT:    v_mov_b32_e32 v12, 0
; TONGA-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[12:13]
; TONGA-NEXT:    s_cbranch_vccz .LBB12_15
; TONGA-NEXT:  ; %bb.7:
; TONGA-NEXT:    v_ashrrev_i32_e32 v12, 31, v1
; TONGA-NEXT:    v_add_u32_e32 v13, vcc, v0, v12
; TONGA-NEXT:    v_addc_u32_e32 v1, vcc, v1, v12, vcc
; TONGA-NEXT:    v_xor_b32_e32 v18, v13, v12
; TONGA-NEXT:    v_xor_b32_e32 v1, v1, v12
; TONGA-NEXT:    v_cvt_f32_u32_e32 v12, v18
; TONGA-NEXT:    v_cvt_f32_u32_e32 v13, v1
; TONGA-NEXT:    v_sub_u32_e32 v19, vcc, 0, v18
; TONGA-NEXT:    v_subb_u32_e32 v20, vcc, 0, v1, vcc
; TONGA-NEXT:    v_madmk_f32 v12, v13, 0x4f800000, v12
; TONGA-NEXT:    v_rcp_f32_e32 v12, v12
; TONGA-NEXT:    v_mul_f32_e32 v12, 0x5f7ffffc, v12
; TONGA-NEXT:    v_mul_f32_e32 v13, 0x2f800000, v12
; TONGA-NEXT:    v_trunc_f32_e32 v13, v13
; TONGA-NEXT:    v_madmk_f32 v12, v13, 0xcf800000, v12
; TONGA-NEXT:    v_cvt_u32_f32_e32 v16, v13
; TONGA-NEXT:    v_cvt_u32_f32_e32 v17, v12
; TONGA-NEXT:    v_mul_lo_u32 v14, v19, v16
; TONGA-NEXT:    v_mad_u64_u32 v[12:13], s[0:1], v19, v17, 0
; TONGA-NEXT:    v_mul_lo_u32 v15, v20, v17
; TONGA-NEXT:    v_add_u32_e32 v13, vcc, v13, v14
; TONGA-NEXT:    v_add_u32_e32 v15, vcc, v13, v15
; TONGA-NEXT:    v_mad_u64_u32 v[13:14], s[0:1], v17, v15, 0
; TONGA-NEXT:    v_mul_hi_u32 v21, v17, v12
; TONGA-NEXT:    v_add_u32_e32 v21, vcc, v21, v13
; TONGA-NEXT:    v_mad_u64_u32 v[12:13], s[0:1], v16, v12, 0
; TONGA-NEXT:    v_addc_u32_e32 v22, vcc, 0, v14, vcc
; TONGA-NEXT:    v_mad_u64_u32 v[14:15], s[0:1], v16, v15, 0
; TONGA-NEXT:    v_add_u32_e32 v12, vcc, v21, v12
; TONGA-NEXT:    v_addc_u32_e32 v12, vcc, v22, v13, vcc
; TONGA-NEXT:    v_addc_u32_e32 v13, vcc, 0, v15, vcc
; TONGA-NEXT:    v_add_u32_e32 v12, vcc, v12, v14
; TONGA-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; TONGA-NEXT:    v_add_u32_e32 v21, vcc, v17, v12
; TONGA-NEXT:    v_addc_u32_e32 v22, vcc, v16, v13, vcc
; TONGA-NEXT:    v_mad_u64_u32 v[12:13], s[0:1], v19, v21, 0
; TONGA-NEXT:    v_mul_lo_u32 v16, v19, v22
; TONGA-NEXT:    v_mul_lo_u32 v17, v20, v21
; TONGA-NEXT:    v_mul_hi_u32 v19, v21, v12
; TONGA-NEXT:    v_mad_u64_u32 v[14:15], s[0:1], v22, v12, 0
; TONGA-NEXT:    v_add_u32_e32 v13, vcc, v16, v13
; TONGA-NEXT:    v_add_u32_e32 v13, vcc, v13, v17
; TONGA-NEXT:    v_mad_u64_u32 v[16:17], s[0:1], v21, v13, 0
; TONGA-NEXT:    v_mad_u64_u32 v[12:13], s[0:1], v22, v13, 0
; TONGA-NEXT:    v_add_u32_e32 v16, vcc, v19, v16
; TONGA-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; TONGA-NEXT:    v_add_u32_e32 v14, vcc, v16, v14
; TONGA-NEXT:    v_addc_u32_e32 v14, vcc, v17, v15, vcc
; TONGA-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; TONGA-NEXT:    v_add_u32_e32 v12, vcc, v14, v12
; TONGA-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; TONGA-NEXT:    v_add_u32_e32 v14, vcc, v21, v12
; TONGA-NEXT:    v_addc_u32_e32 v15, vcc, v22, v13, vcc
; TONGA-NEXT:    v_ashrrev_i32_e32 v16, 31, v5
; TONGA-NEXT:    v_add_u32_e32 v12, vcc, v4, v16
; TONGA-NEXT:    v_xor_b32_e32 v17, v12, v16
; TONGA-NEXT:    v_mad_u64_u32 v[12:13], s[0:1], v17, v15, 0
; TONGA-NEXT:    v_mul_hi_u32 v19, v17, v14
; TONGA-NEXT:    v_addc_u32_e32 v5, vcc, v5, v16, vcc
; TONGA-NEXT:    v_xor_b32_e32 v5, v5, v16
; TONGA-NEXT:    v_add_u32_e32 v19, vcc, v19, v12
; TONGA-NEXT:    v_addc_u32_e32 v20, vcc, 0, v13, vcc
; TONGA-NEXT:    v_mad_u64_u32 v[12:13], s[0:1], v5, v14, 0
; TONGA-NEXT:    v_mad_u64_u32 v[14:15], s[0:1], v5, v15, 0
; TONGA-NEXT:    v_add_u32_e32 v12, vcc, v19, v12
; TONGA-NEXT:    v_addc_u32_e32 v12, vcc, v20, v13, vcc
; TONGA-NEXT:    v_addc_u32_e32 v13, vcc, 0, v15, vcc
; TONGA-NEXT:    v_add_u32_e32 v14, vcc, v12, v14
; TONGA-NEXT:    v_addc_u32_e32 v12, vcc, 0, v13, vcc
; TONGA-NEXT:    v_mul_lo_u32 v15, v18, v12
; TONGA-NEXT:    v_mad_u64_u32 v[12:13], s[0:1], v18, v14, 0
; TONGA-NEXT:    v_mul_lo_u32 v14, v1, v14
; TONGA-NEXT:    v_add_u32_e32 v13, vcc, v15, v13
; TONGA-NEXT:    v_add_u32_e32 v13, vcc, v14, v13
; TONGA-NEXT:    v_sub_u32_e32 v14, vcc, v5, v13
; TONGA-NEXT:    v_sub_u32_e32 v12, vcc, v17, v12
; TONGA-NEXT:    v_subb_u32_e64 v14, s[0:1], v14, v1, vcc
; TONGA-NEXT:    v_sub_u32_e64 v15, s[0:1], v12, v18
; TONGA-NEXT:    v_subbrev_u32_e64 v17, s[2:3], 0, v14, s[0:1]
; TONGA-NEXT:    v_cmp_ge_u32_e64 s[2:3], v17, v1
; TONGA-NEXT:    v_cndmask_b32_e64 v19, 0, -1, s[2:3]
; TONGA-NEXT:    v_cmp_ge_u32_e64 s[2:3], v15, v18
; TONGA-NEXT:    v_cndmask_b32_e64 v20, 0, -1, s[2:3]
; TONGA-NEXT:    v_cmp_eq_u32_e64 s[2:3], v17, v1
; TONGA-NEXT:    v_subb_u32_e64 v14, s[0:1], v14, v1, s[0:1]
; TONGA-NEXT:    v_cndmask_b32_e64 v19, v19, v20, s[2:3]
; TONGA-NEXT:    v_sub_u32_e64 v20, s[0:1], v15, v18
; TONGA-NEXT:    v_subb_u32_e32 v5, vcc, v5, v13, vcc
; TONGA-NEXT:    v_subbrev_u32_e64 v14, s[0:1], 0, v14, s[0:1]
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v5, v1
; TONGA-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v19
; TONGA-NEXT:    v_cndmask_b32_e64 v13, 0, -1, vcc
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v12, v18
; TONGA-NEXT:    v_cndmask_b32_e64 v14, v17, v14, s[0:1]
; TONGA-NEXT:    v_cndmask_b32_e64 v17, 0, -1, vcc
; TONGA-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v1
; TONGA-NEXT:    v_cndmask_b32_e32 v1, v13, v17, vcc
; TONGA-NEXT:    v_cndmask_b32_e64 v15, v15, v20, s[0:1]
; TONGA-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; TONGA-NEXT:    v_cndmask_b32_e32 v1, v5, v14, vcc
; TONGA-NEXT:    v_cndmask_b32_e32 v5, v12, v15, vcc
; TONGA-NEXT:    v_xor_b32_e32 v5, v5, v16
; TONGA-NEXT:    v_xor_b32_e32 v1, v1, v16
; TONGA-NEXT:    v_sub_u32_e32 v12, vcc, v5, v16
; TONGA-NEXT:    v_subb_u32_e32 v13, vcc, v1, v16, vcc
; TONGA-NEXT:    s_cbranch_execnz .LBB12_9
; TONGA-NEXT:  .LBB12_8:
; TONGA-NEXT:    v_cvt_f32_u32_e32 v1, v0
; TONGA-NEXT:    v_sub_u32_e32 v5, vcc, 0, v0
; TONGA-NEXT:    v_mov_b32_e32 v13, 0
; TONGA-NEXT:    v_rcp_iflag_f32_e32 v1, v1
; TONGA-NEXT:    v_mul_f32_e32 v1, 0x4f7ffffe, v1
; TONGA-NEXT:    v_cvt_u32_f32_e32 v1, v1
; TONGA-NEXT:    v_mul_lo_u32 v5, v5, v1
; TONGA-NEXT:    v_mul_hi_u32 v5, v1, v5
; TONGA-NEXT:    v_add_u32_e32 v1, vcc, v1, v5
; TONGA-NEXT:    v_mul_hi_u32 v1, v4, v1
; TONGA-NEXT:    v_mul_lo_u32 v1, v1, v0
; TONGA-NEXT:    v_sub_u32_e32 v1, vcc, v4, v1
; TONGA-NEXT:    v_subrev_u32_e32 v4, vcc, v0, v1
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v1, v0
; TONGA-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; TONGA-NEXT:    v_subrev_u32_e32 v4, vcc, v0, v1
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v1, v0
; TONGA-NEXT:    v_cndmask_b32_e32 v12, v1, v4, vcc
; TONGA-NEXT:  .LBB12_9:
; TONGA-NEXT:    v_or_b32_e32 v1, v7, v3
; TONGA-NEXT:    v_mov_b32_e32 v0, 0
; TONGA-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; TONGA-NEXT:    s_cbranch_vccz .LBB12_16
; TONGA-NEXT:  ; %bb.10:
; TONGA-NEXT:    v_ashrrev_i32_e32 v0, 31, v3
; TONGA-NEXT:    v_add_u32_e32 v1, vcc, v2, v0
; TONGA-NEXT:    v_addc_u32_e32 v3, vcc, v3, v0, vcc
; TONGA-NEXT:    v_xor_b32_e32 v5, v1, v0
; TONGA-NEXT:    v_xor_b32_e32 v16, v3, v0
; TONGA-NEXT:    v_cvt_f32_u32_e32 v0, v5
; TONGA-NEXT:    v_cvt_f32_u32_e32 v1, v16
; TONGA-NEXT:    v_sub_u32_e32 v17, vcc, 0, v5
; TONGA-NEXT:    v_subb_u32_e32 v18, vcc, 0, v16, vcc
; TONGA-NEXT:    v_madmk_f32 v0, v1, 0x4f800000, v0
; TONGA-NEXT:    v_rcp_f32_e32 v0, v0
; TONGA-NEXT:    v_mul_f32_e32 v0, 0x5f7ffffc, v0
; TONGA-NEXT:    v_mul_f32_e32 v1, 0x2f800000, v0
; TONGA-NEXT:    v_trunc_f32_e32 v1, v1
; TONGA-NEXT:    v_madmk_f32 v0, v1, 0xcf800000, v0
; TONGA-NEXT:    v_cvt_u32_f32_e32 v14, v1
; TONGA-NEXT:    v_cvt_u32_f32_e32 v15, v0
; TONGA-NEXT:    v_mul_lo_u32 v3, v17, v14
; TONGA-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v17, v15, 0
; TONGA-NEXT:    v_mul_lo_u32 v4, v18, v15
; TONGA-NEXT:    v_add_u32_e32 v1, vcc, v1, v3
; TONGA-NEXT:    v_add_u32_e32 v19, vcc, v1, v4
; TONGA-NEXT:    v_mad_u64_u32 v[3:4], s[0:1], v15, v19, 0
; TONGA-NEXT:    v_mul_hi_u32 v1, v15, v0
; TONGA-NEXT:    v_add_u32_e32 v20, vcc, v1, v3
; TONGA-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v14, v0, 0
; TONGA-NEXT:    v_addc_u32_e32 v21, vcc, 0, v4, vcc
; TONGA-NEXT:    v_mad_u64_u32 v[3:4], s[0:1], v14, v19, 0
; TONGA-NEXT:    v_add_u32_e32 v0, vcc, v20, v0
; TONGA-NEXT:    v_addc_u32_e32 v0, vcc, v21, v1, vcc
; TONGA-NEXT:    v_addc_u32_e32 v1, vcc, 0, v4, vcc
; TONGA-NEXT:    v_add_u32_e32 v0, vcc, v0, v3
; TONGA-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; TONGA-NEXT:    v_add_u32_e32 v19, vcc, v15, v0
; TONGA-NEXT:    v_addc_u32_e32 v20, vcc, v14, v1, vcc
; TONGA-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v17, v19, 0
; TONGA-NEXT:    v_mul_lo_u32 v14, v17, v20
; TONGA-NEXT:    v_mul_lo_u32 v15, v18, v19
; TONGA-NEXT:    v_mul_hi_u32 v17, v19, v0
; TONGA-NEXT:    v_mad_u64_u32 v[3:4], s[0:1], v20, v0, 0
; TONGA-NEXT:    v_add_u32_e32 v1, vcc, v14, v1
; TONGA-NEXT:    v_add_u32_e32 v1, vcc, v1, v15
; TONGA-NEXT:    v_mad_u64_u32 v[14:15], s[0:1], v19, v1, 0
; TONGA-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v20, v1, 0
; TONGA-NEXT:    v_add_u32_e32 v14, vcc, v17, v14
; TONGA-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; TONGA-NEXT:    v_add_u32_e32 v3, vcc, v14, v3
; TONGA-NEXT:    v_addc_u32_e32 v3, vcc, v15, v4, vcc
; TONGA-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; TONGA-NEXT:    v_add_u32_e32 v0, vcc, v3, v0
; TONGA-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; TONGA-NEXT:    v_add_u32_e32 v3, vcc, v19, v0
; TONGA-NEXT:    v_addc_u32_e32 v4, vcc, v20, v1, vcc
; TONGA-NEXT:    v_ashrrev_i32_e32 v15, 31, v7
; TONGA-NEXT:    v_add_u32_e32 v0, vcc, v6, v15
; TONGA-NEXT:    v_xor_b32_e32 v14, v0, v15
; TONGA-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v14, v4, 0
; TONGA-NEXT:    v_mul_hi_u32 v17, v14, v3
; TONGA-NEXT:    v_addc_u32_e32 v7, vcc, v7, v15, vcc
; TONGA-NEXT:    v_xor_b32_e32 v7, v7, v15
; TONGA-NEXT:    v_add_u32_e32 v17, vcc, v17, v0
; TONGA-NEXT:    v_addc_u32_e32 v18, vcc, 0, v1, vcc
; TONGA-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v7, v3, 0
; TONGA-NEXT:    v_mad_u64_u32 v[3:4], s[0:1], v7, v4, 0
; TONGA-NEXT:    v_add_u32_e32 v0, vcc, v17, v0
; TONGA-NEXT:    v_addc_u32_e32 v0, vcc, v18, v1, vcc
; TONGA-NEXT:    v_addc_u32_e32 v1, vcc, 0, v4, vcc
; TONGA-NEXT:    v_add_u32_e32 v3, vcc, v0, v3
; TONGA-NEXT:    v_addc_u32_e32 v0, vcc, 0, v1, vcc
; TONGA-NEXT:    v_mul_lo_u32 v4, v5, v0
; TONGA-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], v5, v3, 0
; TONGA-NEXT:    v_mul_lo_u32 v3, v16, v3
; TONGA-NEXT:    v_add_u32_e32 v1, vcc, v4, v1
; TONGA-NEXT:    v_add_u32_e32 v1, vcc, v3, v1
; TONGA-NEXT:    v_sub_u32_e32 v3, vcc, v7, v1
; TONGA-NEXT:    v_sub_u32_e32 v0, vcc, v14, v0
; TONGA-NEXT:    v_subb_u32_e64 v3, s[0:1], v3, v16, vcc
; TONGA-NEXT:    v_sub_u32_e64 v4, s[0:1], v0, v5
; TONGA-NEXT:    v_subbrev_u32_e64 v14, s[2:3], 0, v3, s[0:1]
; TONGA-NEXT:    v_cmp_ge_u32_e64 s[2:3], v14, v16
; TONGA-NEXT:    v_cndmask_b32_e64 v17, 0, -1, s[2:3]
; TONGA-NEXT:    v_cmp_ge_u32_e64 s[2:3], v4, v5
; TONGA-NEXT:    v_subb_u32_e32 v1, vcc, v7, v1, vcc
; TONGA-NEXT:    v_cndmask_b32_e64 v18, 0, -1, s[2:3]
; TONGA-NEXT:    v_cmp_eq_u32_e64 s[2:3], v14, v16
; TONGA-NEXT:    v_subb_u32_e64 v3, s[0:1], v3, v16, s[0:1]
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v1, v16
; TONGA-NEXT:    v_cndmask_b32_e64 v17, v17, v18, s[2:3]
; TONGA-NEXT:    v_sub_u32_e64 v18, s[0:1], v4, v5
; TONGA-NEXT:    v_cndmask_b32_e64 v7, 0, -1, vcc
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v5
; TONGA-NEXT:    v_subbrev_u32_e64 v3, s[0:1], 0, v3, s[0:1]
; TONGA-NEXT:    v_cndmask_b32_e64 v5, 0, -1, vcc
; TONGA-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v16
; TONGA-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v17
; TONGA-NEXT:    v_cndmask_b32_e32 v5, v7, v5, vcc
; TONGA-NEXT:    v_cndmask_b32_e64 v4, v4, v18, s[0:1]
; TONGA-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v5
; TONGA-NEXT:    v_cndmask_b32_e64 v3, v14, v3, s[0:1]
; TONGA-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; TONGA-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; TONGA-NEXT:    v_xor_b32_e32 v0, v0, v15
; TONGA-NEXT:    v_xor_b32_e32 v1, v1, v15
; TONGA-NEXT:    v_sub_u32_e32 v14, vcc, v0, v15
; TONGA-NEXT:    v_subb_u32_e32 v15, vcc, v1, v15, vcc
; TONGA-NEXT:    s_cbranch_execnz .LBB12_12
; TONGA-NEXT:  .LBB12_11:
; TONGA-NEXT:    v_cvt_f32_u32_e32 v0, v2
; TONGA-NEXT:    v_sub_u32_e32 v1, vcc, 0, v2
; TONGA-NEXT:    v_mov_b32_e32 v15, 0
; TONGA-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; TONGA-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; TONGA-NEXT:    v_cvt_u32_f32_e32 v0, v0
; TONGA-NEXT:    v_mul_lo_u32 v1, v1, v0
; TONGA-NEXT:    v_mul_hi_u32 v1, v0, v1
; TONGA-NEXT:    v_add_u32_e32 v0, vcc, v0, v1
; TONGA-NEXT:    v_mul_hi_u32 v0, v6, v0
; TONGA-NEXT:    v_mul_lo_u32 v0, v0, v2
; TONGA-NEXT:    v_sub_u32_e32 v0, vcc, v6, v0
; TONGA-NEXT:    v_subrev_u32_e32 v1, vcc, v2, v0
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v2
; TONGA-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; TONGA-NEXT:    v_subrev_u32_e32 v1, vcc, v2, v0
; TONGA-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v2
; TONGA-NEXT:    v_cndmask_b32_e32 v14, v0, v1, vcc
; TONGA-NEXT:  .LBB12_12:
; TONGA-NEXT:    v_mov_b32_e32 v0, s4
; TONGA-NEXT:    v_mov_b32_e32 v1, s5
; TONGA-NEXT:    s_add_u32 s0, s4, 16
; TONGA-NEXT:    flat_store_dwordx4 v[0:1], v[8:11]
; TONGA-NEXT:    s_addc_u32 s1, s5, 0
; TONGA-NEXT:    v_mov_b32_e32 v0, s0
; TONGA-NEXT:    v_mov_b32_e32 v1, s1
; TONGA-NEXT:    flat_store_dwordx4 v[0:1], v[12:15]
; TONGA-NEXT:    s_endpgm
; TONGA-NEXT:  .LBB12_13:
; TONGA-NEXT:    ; implicit-def: $vgpr8_vgpr9
; TONGA-NEXT:    s_branch .LBB12_2
; TONGA-NEXT:  .LBB12_14:
; TONGA-NEXT:    s_branch .LBB12_5
; TONGA-NEXT:  .LBB12_15:
; TONGA-NEXT:    ; implicit-def: $vgpr12_vgpr13
; TONGA-NEXT:    s_branch .LBB12_8
; TONGA-NEXT:  .LBB12_16:
; TONGA-NEXT:    s_branch .LBB12_11
;
; EG-LABEL: srem_v4i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @34, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @26
; EG-NEXT:    ALU 114, @35, KC0[], KC1[]
; EG-NEXT:    ALU 115, @150, KC0[], KC1[]
; EG-NEXT:    ALU 115, @266, KC0[], KC1[]
; EG-NEXT:    ALU 111, @382, KC0[], KC1[]
; EG-NEXT:    TEX 1 @30
; EG-NEXT:    ALU 114, @494, KC0[], KC1[]
; EG-NEXT:    ALU 113, @609, KC0[], KC1[]
; EG-NEXT:    ALU 114, @723, KC0[], KC1[]
; EG-NEXT:    ALU 113, @838, KC0[], KC1[]
; EG-NEXT:    ALU 114, @952, KC0[], KC1[]
; EG-NEXT:    ALU 113, @1067, KC0[], KC1[]
; EG-NEXT:    ALU 114, @1181, KC0[], KC1[]
; EG-NEXT:    ALU 113, @1296, KC0[], KC1[]
; EG-NEXT:    ALU 114, @1410, KC0[], KC1[]
; EG-NEXT:    ALU 114, @1525, KC0[], KC1[]
; EG-NEXT:    ALU 114, @1640, KC0[], KC1[]
; EG-NEXT:    ALU 115, @1755, KC0[], KC1[]
; EG-NEXT:    ALU 113, @1871, KC0[], KC1[]
; EG-NEXT:    ALU 112, @1985, KC0[], KC1[]
; EG-NEXT:    ALU 99, @2098, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T4.XYZW, T1.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T7.XYZW, T0.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 26:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T2.X, 32, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T2.X, 0, #1
; EG-NEXT:    Fetch clause starting at 30:
; EG-NEXT:     VTX_READ_128 T9.XYZW, T2.X, 16, #1
; EG-NEXT:     VTX_READ_128 T10.XYZW, T2.X, 48, #1
; EG-NEXT:    ALU clause starting at 34:
; EG-NEXT:     MOV * T2.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 35:
; EG-NEXT:     ASHR * T3.W, T1.Y, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T2.W, T1.X, PV.W,
; EG-NEXT:     XOR_INT * T7.W, PV.W, T3.W,
; EG-NEXT:     SUB_INT T2.Z, 0.0, PV.W,
; EG-NEXT:     ASHR T2.W, T0.Y, literal.x,
; EG-NEXT:     RECIP_UINT * T2.Y, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ADD_INT T3.Z, T0.Y, PV.W,
; EG-NEXT:     ADDC_UINT T4.W, T0.X, PV.W,
; EG-NEXT:     MULLO_INT * T0.Y, PV.Z, PS,
; EG-NEXT:     ADD_INT T4.W, PV.Z, PV.W,
; EG-NEXT:     MULHI * T0.Y, T2.Y, PS,
; EG-NEXT:     ADD_INT T5.W, T2.Y, PS,
; EG-NEXT:     XOR_INT * T4.W, PV.W, T2.W,
; EG-NEXT:     MULHI * T0.Y, PS, PV.W,
; EG-NEXT:     MULLO_INT * T0.Y, PS, T7.W,
; EG-NEXT:     SUB_INT * T5.W, T4.W, PS,
; EG-NEXT:     SETGE_UINT T6.W, PV.W, T7.W,
; EG-NEXT:     SUB_INT * T8.W, PV.W, T7.W,
; EG-NEXT:     CNDE_INT T2.Z, PV.W, T5.W, PS, BS:VEC_021/SCL_122
; EG-NEXT:     ADD_INT T5.W, T1.Y, T3.W,
; EG-NEXT:     ADDC_UINT * T6.W, T1.X, T3.W,
; EG-NEXT:     ADD_INT T3.Z, PV.W, PS,
; EG-NEXT:     SETGE_UINT T5.W, PV.Z, T7.W,
; EG-NEXT:     SUB_INT * T6.W, PV.Z, T7.W,
; EG-NEXT:     ADD_INT T4.Z, T0.X, T2.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T5.W, PV.W, T2.Z, PS,
; EG-NEXT:     XOR_INT * T6.W, PV.Z, T3.W,
; EG-NEXT:     CNDE_INT T3.W, PS, PV.W, T4.W,
; EG-NEXT:     XOR_INT * T8.W, PV.Z, T2.W,
; EG-NEXT:     BIT_ALIGN_INT T4.W, PV.W, PS, literal.x,
; EG-NEXT:     LSHR * T3.W, PV.W, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T2.Z, PS, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T5.W, PS, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T7.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.Z, PV.W, PS,
; EG-NEXT:     SUB_INT * T2.Z, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T5.W, T3.W, T6.W,
; EG-NEXT:     SUBB_UINT * T9.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT T5.W, T5.W, PV.W,
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    30(4.203895e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    29(4.063766e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    28(3.923636e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    27(3.783506e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    26(3.643376e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT * T2.Z, PS, T7.W,
; EG-NEXT:    ALU clause starting at 150:
; EG-NEXT:     SETE_INT T5.W, T3.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, T3.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, T2.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    25(3.503246e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    24(3.363116e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    23(3.222986e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    22(3.082857e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    21(2.942727e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    20(2.802597e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    19(2.662467e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT * T2.Z, T4.W, T7.W,
; EG-NEXT:    ALU clause starting at 266:
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    18(2.522337e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    17(2.382207e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    15(2.101948e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    14(1.961818e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    13(1.821688e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    12(1.681558e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:    ALU clause starting at 382:
; EG-NEXT:     LSHL T2.Z, T4.W, 1,
; EG-NEXT:     BFE_UINT * T9.W, T8.W, literal.x, 1, BS:VEC_120/SCL_212
; EG-NEXT:    11(1.541428e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, T5.W,
; EG-NEXT:     BIT_ALIGN_INT T3.W, PV.W, T4.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT * T4.W, T2.Z, T9.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    10(1.401298e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    9(1.261169e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    8(1.121039e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    7(9.809089e-45), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    6(8.407791e-45), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T9.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    5(7.006492e-45), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T9.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:    ALU clause starting at 494:
; EG-NEXT:     LSHL T2.Z, T4.W, 1,
; EG-NEXT:     BFE_UINT * T11.W, T8.W, literal.x, 1, BS:VEC_120/SCL_212
; EG-NEXT:    4(5.605194e-45), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, T5.W,
; EG-NEXT:     BIT_ALIGN_INT T3.W, PV.W, T4.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT * T4.W, T2.Z, T11.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T11.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T2.Z, PS, 1,
; EG-NEXT:     BFE_UINT T11.W, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT * T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T3.W, PS, T4.W, literal.x,
; EG-NEXT:     OR_INT * T4.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.Z, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.W, PV.W, T6.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Z, T4.W, T7.W,
; EG-NEXT:     SUBB_UINT * T5.W, T4.W, T7.W,
; EG-NEXT:     SUB_INT * T11.W, T3.W, T6.W,
; EG-NEXT:     SUB_INT T5.W, PV.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T4.W, T0.Y, T4.W, T2.Z,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BFE_UINT T2.Z, T8.W, literal.x, 1,
; EG-NEXT:     CNDE_INT T3.W, T0.Y, T3.W, PV.W,
; EG-NEXT:     ASHR * T11.W, T10.Y, literal.y,
; EG-NEXT:    2(2.802597e-45), 31(4.344025e-44)
; EG-NEXT:     ADD_INT T3.Z, T10.X, PS,
; EG-NEXT:     BIT_ALIGN_INT T5.W, PV.W, T4.W, literal.x,
; EG-NEXT:     OR_INT * T12.W, PV.Y, PV.Z,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T0.Y, PS, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T2.Z, PV.W, T6.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETGE_UINT T3.W, PV.W, T6.W, BS:VEC_102/SCL_221
; EG-NEXT:     XOR_INT * T4.W, PV.Z, T11.W,
; EG-NEXT:     SUB_INT T13.W, 0.0, PS,
; EG-NEXT:     CNDE_INT * T14.W, PV.Z, PV.W, PV.Y,
; EG-NEXT:     SUB_INT T0.X, T12.W, T7.W,
; EG-NEXT:     SUBB_UINT * T0.Y, T12.W, T7.W,
; EG-NEXT:     SUB_INT T2.Z, T5.W, T6.W,
; EG-NEXT:     ASHR T3.W, T9.Y, literal.x,
; EG-NEXT:     RECIP_UINT * T1.X, T4.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ADD_INT T1.Y, T9.Y, PV.W,
; EG-NEXT:     SUB_INT T2.Z, PV.Z, T0.Y,
; EG-NEXT:     CNDE_INT T12.W, T14.W, T12.W, T0.X,
; EG-NEXT:     MULLO_INT * T0.X, T13.W, PS,
; EG-NEXT:     ADDC_UINT T2.X, T9.X, T3.W,
; EG-NEXT:     LSHL T0.Y, PV.W, 1,
; EG-NEXT:     BFE_UINT * T3.Z, T8.W, 1, 1,
; EG-NEXT:     CNDE_INT T5.W, T14.W, T5.W, T2.Z,
; EG-NEXT:     MULHI * T0.X, T1.X, T0.X,
; EG-NEXT:     ADD_INT T2.Y, T1.X, PS,
; EG-NEXT:     BIT_ALIGN_INT T4.Z, PV.W, T12.W, literal.x,
; EG-NEXT:     OR_INT T12.W, T0.Y, T3.Z,
; EG-NEXT:     ADD_INT * T5.W, T1.Y, T2.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     XOR_INT T1.X, PS, T3.W,
; EG-NEXT:     ASHR T0.Y, T10.W, literal.x,
; EG-NEXT:     SETGE_UINT * T2.Z, PV.W, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T5.W, T4.Z, T6.W,
; EG-NEXT:     SETGE_UINT * T13.W, T4.Z, T6.W,
; EG-NEXT:     CNDE_INT T1.Y, PV.W, PS, T2.Z,
; EG-NEXT:     SUB_INT T3.Z, T12.W, T7.W,
; EG-NEXT:     ADD_INT T5.W, T10.Z, T0.Y, BS:VEC_021/SCL_122
; EG-NEXT:     MULHI * T0.X, T1.X, T2.Y,
; EG-NEXT:     SUBB_UINT T2.X, T12.W, T7.W,
; EG-NEXT:     SUB_INT T2.Y, T4.Z, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     XOR_INT * T2.Z, PV.W, T0.Y,
; EG-NEXT:     ASHR T5.W, T9.W, literal.x,
; EG-NEXT:     MULLO_INT * T0.X, T0.X, T4.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ADD_INT T3.X, T9.W, PV.W,
; EG-NEXT:     SUB_INT T3.Y, 0.0, T2.Z,
; EG-NEXT:     SUB_INT T5.Z, T2.Y, T2.X,
; EG-NEXT:     CNDE_INT T9.W, T1.Y, T12.W, T3.Z, BS:VEC_120/SCL_212
; EG-NEXT:     RECIP_UINT * T2.X, T2.Z,
; EG-NEXT:     ADDC_UINT T4.X, T9.Z, T5.W,
; EG-NEXT:     LSHL T2.Y, PV.W, 1,
; EG-NEXT:     AND_INT T3.Z, T8.W, 1,
; EG-NEXT:     CNDE_INT T8.W, T1.Y, T4.Z, PV.Z,
; EG-NEXT:     MULLO_INT * T1.Y, PV.Y, PS,
; EG-NEXT:     BIT_ALIGN_INT T3.Y, PV.W, T9.W, literal.x,
; EG-NEXT:     OR_INT T5.Z, PV.Y, PV.Z,
; EG-NEXT:     ADD_INT T8.W, T3.X, PV.X,
; EG-NEXT:     MULHI * T1.Y, T2.X, PS,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ADD_INT T2.X, T2.X, PS,
; EG-NEXT:     XOR_INT T1.Y, PV.W, T5.W,
; EG-NEXT:     SETGE_UINT T3.Z, PV.Z, T7.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T8.W, PV.Y, T6.W, BS:VEC_102/SCL_221
; EG-NEXT:     SUB_INT * T9.W, T1.X, T0.X,
; EG-NEXT:     SETGE_UINT T0.X, T3.Y, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUBB_UINT T2.Y, T5.Z, T7.W, BS:VEC_102/SCL_221
; EG-NEXT:     SUB_INT T4.Z, T3.Y, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T6.W, PS, T4.W,
; EG-NEXT:     SUB_INT * T12.W, PS, T4.W,
; EG-NEXT:     CNDE_INT T3.X, PV.W, T9.W, PS,
; EG-NEXT:     ADD_INT T4.Y, T10.Y, T11.W, BS:VEC_102/SCL_221
; EG-NEXT:     ADDC_UINT T6.Z, T10.X, T11.W, BS:VEC_102/SCL_221
; EG-NEXT:     SUB_INT T6.W, PV.Z, PV.Y,
; EG-NEXT:     CNDE_INT * T8.W, T8.W, PV.X, T3.Z,
; EG-NEXT:     CNDE_INT T0.X, PS, T3.Y, PV.W,
; EG-NEXT:     ADD_INT * T2.Y, PV.Y, PV.Z,
; EG-NEXT:    ALU clause starting at 609:
; EG-NEXT:     SETGE_UINT T3.Z, T3.X, T4.W,
; EG-NEXT:     SUB_INT T6.W, T3.X, T4.W,
; EG-NEXT:     MULHI * T2.X, T1.Y, T2.X,
; EG-NEXT:     ASHR T4.X, T1.W, literal.x,
; EG-NEXT:     CNDE_INT T3.Y, PV.Z, T3.X, PV.W,
; EG-NEXT:     XOR_INT T3.Z, T2.Y, T11.W,
; EG-NEXT:     ADD_INT T6.W, T9.Z, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     MULLO_INT * T2.X, PS, T2.Z,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     XOR_INT T3.X, PV.W, T5.W,
; EG-NEXT:     CNDE_INT T2.Y, PV.Z, PV.Y, T1.X,
; EG-NEXT:     ADD_INT T4.Z, T1.Z, PV.X,
; EG-NEXT:     SUB_INT T9.W, T1.Y, PS,
; EG-NEXT:     ASHR * T6.W, T0.W, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ADD_INT T1.X, T0.W, PS,
; EG-NEXT:     ADDC_UINT T3.Y, T0.Z, PS,
; EG-NEXT:     SETGE_UINT T6.Z, PV.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, PV.W, T2.Z,
; EG-NEXT:     XOR_INT * T0.W, PV.Z, T4.X,
; EG-NEXT:     SUB_INT T2.X, 0.0, PS,
; EG-NEXT:     CNDE_INT T4.Y, PV.Z, T9.W, PV.W,
; EG-NEXT:     ADD_INT T4.Z, T10.W, T0.Y,
; EG-NEXT:     ADDC_UINT T9.W, T10.Z, T0.Y,
; EG-NEXT:     RECIP_UINT * T5.X, PS,
; EG-NEXT:     ADD_INT T6.X, PV.Z, PV.W,
; EG-NEXT:     SETGE_UINT T5.Y, PV.Y, T2.Z,
; EG-NEXT:     SUB_INT T4.Z, PV.Y, T2.Z,
; EG-NEXT:     ADD_INT T9.W, T9.X, T3.W,
; EG-NEXT:     MULLO_INT * T6.Y, PV.X, PS,
; EG-NEXT:     XOR_INT T2.X, PV.W, T3.W,
; EG-NEXT:     CNDE_INT T4.Y, PV.Y, T4.Y, PV.Z,
; EG-NEXT:     XOR_INT T4.Z, PV.X, T0.Y, BS:VEC_021/SCL_122
; EG-NEXT:     ADD_INT T9.W, T1.X, T3.Y, BS:VEC_102/SCL_221
; EG-NEXT:     MULHI * T0.Y, T5.X, PS,
; EG-NEXT:     ADD_INT T1.X, T5.X, PS,
; EG-NEXT:     XOR_INT T0.Y, PV.W, T6.W,
; EG-NEXT:     CNDE_INT T6.Z, PV.Z, PV.Y, T1.Y, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T9.W, T2.Y, PV.X, literal.x,
; EG-NEXT:     LSHR * T10.W, T2.Y, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T5.X, PS, T3.Z,
; EG-NEXT:     SETGE_UINT T1.Y, PS, T3.Z,
; EG-NEXT:     SETGE_UINT T7.Z, PV.W, T4.W,
; EG-NEXT:     LSHR T11.W, PV.Z, literal.x,
; EG-NEXT:     MULHI * T1.X, PV.Y, PV.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T6.X, PV.W, T4.Z,
; EG-NEXT:     CNDE_INT T1.Y, PV.X, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT T7.Z, T9.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T12.W, T6.Z, T3.X, literal.x,
; EG-NEXT:     MULLO_INT * T1.X, PS, T0.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T5.X, T11.W, T4.Z,
; EG-NEXT:     SETGE_UINT T2.Y, PV.W, T2.Z, BS:VEC_102/SCL_221
; EG-NEXT:     SUB_INT T6.Z, T0.Y, PS,
; EG-NEXT:     CNDE_INT T13.W, PV.Y, T9.W, PV.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT * T7.W, T5.Z, T7.W,
; EG-NEXT:     CNDE_INT T1.X, T8.W, T5.Z, PS,
; EG-NEXT:     LSHL T3.Y, PV.W, 1,
; EG-NEXT:     SETGE_UINT T5.Z, PV.Z, T0.W,
; EG-NEXT:     SUB_INT T7.W, PV.Z, T0.W,
; EG-NEXT:     CNDE_INT * T8.W, T6.X, PV.X, PV.Y,
; EG-NEXT:     SUB_INT T5.X, T12.W, T2.Z,
; EG-NEXT:     SUB_INT T2.Y, T11.W, T4.Z, BS:VEC_102/SCL_221
; EG-NEXT:     SUBB_UINT T7.Z, T12.W, T2.Z,
; EG-NEXT:     ADD_INT T1.W, T1.W, T4.X, BS:VEC_201
; EG-NEXT:     ADDC_UINT * T14.W, T1.Z, T4.X,
; EG-NEXT:     BFE_UINT T6.X, T2.X, literal.x, 1,
; EG-NEXT:     ADD_INT T4.Y, PV.W, PS,
; EG-NEXT:     SUB_INT T1.Z, PV.Y, PV.Z,
; EG-NEXT:     CNDE_INT T1.W, T8.W, T12.W, PV.X, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T7.W, T5.Z, T6.Z, T7.W,
; EG-NEXT:    30(4.203895e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T5.X, PS, T0.W, BS:VEC_102/SCL_221
; EG-NEXT:     SUB_INT T2.Y, PS, T0.W, BS:VEC_102/SCL_221
; EG-NEXT:     LSHL T5.Z, PV.W, 1,
; EG-NEXT:     BFE_UINT T12.W, T3.X, literal.x, 1,
; EG-NEXT:     CNDE_INT * T8.W, T8.W, T11.W, PV.Z,
; EG-NEXT:    30(4.203895e-44), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T7.X, PS, T1.W, literal.x,
; EG-NEXT:     OR_INT T5.Y, PV.Z, PV.W,
; EG-NEXT:     ADD_INT T0.Z, T0.Z, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T7.W, PV.X, T7.W, PV.Y, BS:VEC_102/SCL_221
; EG-NEXT:     XOR_INT * T1.W, T4.Y, T4.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T4.X, PS, PV.W, T0.Y,
; EG-NEXT:     XOR_INT T0.Y, PV.Z, T6.W,
; EG-NEXT:     SETGE_UINT T0.Z, PV.Y, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T7.W, PV.X, T4.Z,
; EG-NEXT:     SETGE_UINT * T8.W, PV.X, T4.Z,
; EG-NEXT:     SUB_INT T5.X, T10.W, T3.Z,
; EG-NEXT:     CNDE_INT T2.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T0.Z, T5.Y, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.X, PV.Y, literal.x,
; EG-NEXT:     LSHR * T8.W, PV.X, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T5.Y, T2.Z,
; EG-NEXT:     SUB_INT T4.Y, T7.X, T4.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T1.Z, PS, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T11.W, PS, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT * T12.W, PV.W, T0.W,
; EG-NEXT:     SUB_INT T8.X, T8.W, T1.W,
; EG-NEXT:     CNDE_INT * T6.Y, PV.Z, PV.W, PS,
; EG-NEXT:     SUB_INT T1.Z, T7.W, T0.W,
; EG-NEXT:     SUB_INT T11.W, T4.Y, T4.X,
; EG-NEXT:     CNDE_INT * T12.W, T2.Y, T5.Y, T0.Z,
; EG-NEXT:     SUBB_UINT T4.X, T7.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     LSHL T4.Y, PS, 1,
; EG-NEXT:     BFE_UINT T0.Z, T3.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T11.W, T2.Y, T7.X, PV.W,
; EG-NEXT:     CNDE_INT * T7.W, T6.Y, T7.W, PV.Z,
; EG-NEXT:    29(4.063766e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT * T7.X, T9.W, T4.W,
; EG-NEXT:    ALU clause starting at 723:
; EG-NEXT:     LSHL T2.Y, T7.W, 1,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, T11.W, T12.W, literal.x, BS:VEC_120/SCL_212
; EG-NEXT:     OR_INT T9.W, T4.Y, T0.Z,
; EG-NEXT:     SUB_INT * T11.W, T8.X, T4.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T4.X, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT T4.Y, T6.Y, T8.W, PS, BS:VEC_120/SCL_212
; EG-NEXT:     SETGE_UINT T0.Z, PV.W, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T8.W, PV.Z, T4.Z,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T4.Z,
; EG-NEXT:    30(4.203895e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T8.X, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T5.Y, T9.W, T2.Z,
; EG-NEXT:     BIT_ALIGN_INT T0.Z, PV.Y, T7.W, literal.x,
; EG-NEXT:     OR_INT T7.W, T2.Y, PV.X,
; EG-NEXT:     SUB_INT * T8.W, T5.X, T7.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T4.X, T1.Y, T10.W, PS,
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.Z, PV.Z, T1.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETGE_UINT * T8.W, PV.Z, T1.W, BS:VEC_102/SCL_221
; EG-NEXT:     CNDE_INT * T10.W, T8.X, T9.W, T5.Y,
; EG-NEXT:     LSHL T5.X, PV.W, 1,
; EG-NEXT:     CNDE_INT T1.Y, T5.Z, T8.W, T1.Y,
; EG-NEXT:     SUB_INT * T5.Z, T7.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T8.W, T4.X, T13.W, literal.x,
; EG-NEXT:     OR_INT * T11.W, T3.Y, T6.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T7.W, T0.W,
; EG-NEXT:     SUB_INT * T2.Y, T0.Z, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T6.Z, T11.W, T4.W,
; EG-NEXT:     SETE_INT T12.W, T8.W, T3.Z, BS:VEC_201
; EG-NEXT:     SETGE_UINT * T13.W, T8.W, T3.Z,
; EG-NEXT:     SUBB_UINT T6.X, T11.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T6.Z, T11.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T12.W, T2.Y, T4.X,
; EG-NEXT:     CNDE_INT * T7.W, T1.Y, T7.W, T5.Z,
; EG-NEXT:     SUB_INT T4.X, T8.W, T3.Z,
; EG-NEXT:     LSHL T2.Y, PS, 1,
; EG-NEXT:     BFE_UINT T5.Z, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT T12.W, T1.Y, T0.Z, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T11.W, PV.Y, T11.W, PV.Z,
; EG-NEXT:    29(4.063766e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T7.X, T3.X, literal.x, 1,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T0.Z, PV.W, T7.W, literal.y,
; EG-NEXT:     OR_INT T7.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T12.W, PV.X, T6.X,
; EG-NEXT:    28(3.923636e-44), 31(4.344025e-44)
; EG-NEXT:     BFE_UINT T4.X, T2.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T2.Y, T3.Y, T8.W, PS, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T5.Z, PV.W, T0.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T8.W, PV.Z, T1.W,
; EG-NEXT:     SETGE_UINT * T12.W, PV.Z, T1.W,
; EG-NEXT:    29(4.063766e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T6.X, T9.W, T2.Z,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT * T5.Z, T7.W, T0.W, BS:VEC_120/SCL_212
; EG-NEXT:     BIT_ALIGN_INT T8.W, T2.Y, T11.W, literal.x,
; EG-NEXT:     OR_INT * T9.W, T1.Y, T4.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T7.W, T0.W,
; EG-NEXT:     SUB_INT * T1.Y, T0.Z, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T6.Z, T9.W, T4.W,
; EG-NEXT:     SETE_INT T11.W, T8.W, T3.Z, BS:VEC_201
; EG-NEXT:     SETGE_UINT * T12.W, T8.W, T3.Z,
; EG-NEXT:     SUBB_UINT T9.X, T9.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T2.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T6.Z, T9.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T11.W, T1.Y, T4.X,
; EG-NEXT:     CNDE_INT * T7.W, T3.Y, T7.W, T5.Z,
; EG-NEXT:     SUB_INT T4.X, T8.W, T3.Z,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BFE_UINT T5.Z, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT T11.W, T3.Y, T0.Z, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T9.W, PV.Y, T9.W, PV.Z,
; EG-NEXT:    28(3.923636e-44), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T10.X, T1.Z, T4.Z,
; EG-NEXT:     LSHL T3.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T0.Z, PV.W, T7.W, literal.x,
; EG-NEXT:     OR_INT T7.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T11.W, PV.X, T9.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T4.X, T2.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T1.Y, T2.Y, T8.W, PS, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T5.Z, PV.W, T0.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T8.W, PV.Z, T1.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T1.W,
; EG-NEXT:    28(3.923636e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T9.X, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Y, T7.W, T0.W,
; EG-NEXT:     BIT_ALIGN_INT T5.Z, PV.Y, T9.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT T8.W, T3.Y, PV.X,
; EG-NEXT:     SUB_INT * T9.W, T10.X, T6.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T4.X, T8.X, T1.Z, PS,
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T1.Z, PV.Z, T3.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T9.W, PV.Z, T3.Z, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T11.W, PV.X, T7.W, PV.Y,
; EG-NEXT:     LSHL T6.X, PS, 1,
; EG-NEXT:     CNDE_INT T1.Y, PV.Z, PV.W, PV.Y,
; EG-NEXT:     SUB_INT T1.Z, T8.W, T4.W,
; EG-NEXT:     BIT_ALIGN_INT T9.W, PV.X, T10.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT * T10.W, T5.X, T7.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T8.W, T4.W,
; EG-NEXT:     SUB_INT T2.Y, T5.Z, T3.Z,
; EG-NEXT:     SETGE_UINT * T6.Z, PS, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T12.W, T9.W, T4.Z,
; EG-NEXT:     SETGE_UINT * T13.W, T9.W, T4.Z,
; EG-NEXT:     SUBB_UINT T5.X, T10.W, T2.Z,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, T6.Z,
; EG-NEXT:     SUB_INT * T6.Z, T10.W, T2.Z,
; EG-NEXT:    ALU clause starting at 838:
; EG-NEXT:     SUB_INT T12.W, T2.Y, T4.X,
; EG-NEXT:     CNDE_INT * T8.W, T1.Y, T8.W, T1.Z,
; EG-NEXT:     SUB_INT T4.X, T9.W, T4.Z,
; EG-NEXT:     LSHL T2.Y, PS, 1,
; EG-NEXT:     BFE_UINT T1.Z, T2.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T12.W, T1.Y, T5.Z, PV.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T10.W, T3.Y, T10.W, T6.Z,
; EG-NEXT:    27(3.783506e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T7.X, T0.Y, literal.x, 1,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T5.Z, PV.W, T8.W, literal.y,
; EG-NEXT:     OR_INT T8.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T12.W, PV.X, T5.X,
; EG-NEXT:    27(3.783506e-44), 31(4.344025e-44)
; EG-NEXT:     BFE_UINT T4.X, T3.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T2.Y, T3.Y, T9.W, PS,
; EG-NEXT:     SETGE_UINT T1.Z, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T9.W, PV.Z, T3.Z,
; EG-NEXT:     SETGE_UINT * T12.W, PV.Z, T3.Z,
; EG-NEXT:    27(3.783506e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T5.X, T7.W, T0.W,
; EG-NEXT:     CNDE_INT * T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T8.W, T4.W,
; EG-NEXT:     BIT_ALIGN_INT T7.W, T2.Y, T10.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT * T9.W, T1.Y, T4.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T8.W, T4.W,
; EG-NEXT:     SUB_INT T1.Y, T5.Z, T3.Z,
; EG-NEXT:     SETGE_UINT * T6.Z, PS, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T10.W, T7.W, T4.Z,
; EG-NEXT:     SETGE_UINT * T12.W, T7.W, T4.Z,
; EG-NEXT:     SUBB_UINT T8.X, T9.W, T2.Z,
; EG-NEXT:     CNDE_INT T2.Y, PV.W, PS, T6.Z,
; EG-NEXT:     SUB_INT T6.Z, T9.W, T2.Z,
; EG-NEXT:     SUB_INT T10.W, T1.Y, T4.X,
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T1.Z,
; EG-NEXT:     SUB_INT T4.X, T7.W, T4.Z,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BFE_UINT T1.Z, T2.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T10.W, T3.Y, T5.Z, PV.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T9.W, PV.Y, T9.W, PV.Z,
; EG-NEXT:    26(3.643376e-44), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T10.X, T0.Z, T1.W,
; EG-NEXT:     LSHL T3.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T5.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT T8.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T10.W, PV.X, T8.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T4.X, T3.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T1.Y, T2.Y, T7.W, PS,
; EG-NEXT:     SETGE_UINT T1.Z, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T7.W, PV.Z, T3.Z,
; EG-NEXT:     SETGE_UINT * T10.W, PV.Z, T3.Z,
; EG-NEXT:    26(3.643376e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T8.X, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Y, T8.W, T4.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.Y, T9.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT T7.W, T3.Y, PV.X,
; EG-NEXT:     SUB_INT * T9.W, T10.X, T5.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T4.X, T9.X, T0.Z, PS,
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T0.Z, PV.Z, T4.Z, BS:VEC_102/SCL_221
; EG-NEXT:     SETGE_UINT T9.W, PV.Z, T4.Z, BS:VEC_102/SCL_221
; EG-NEXT:     CNDE_INT * T10.W, PV.X, T8.W, PV.Y,
; EG-NEXT:     LSHL T5.X, PS, 1,
; EG-NEXT:     CNDE_INT T1.Y, PV.Z, PV.W, PV.Y,
; EG-NEXT:     SUB_INT T0.Z, T7.W, T2.Z,
; EG-NEXT:     BIT_ALIGN_INT T9.W, PV.X, T11.W, literal.x,
; EG-NEXT:     OR_INT * T11.W, T6.X, T7.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T7.W, T2.Z,
; EG-NEXT:     SUB_INT T2.Y, T1.Z, T4.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T6.Z, PS, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T12.W, PV.W, T1.W,
; EG-NEXT:     SETGE_UINT * T13.W, PV.W, T1.W,
; EG-NEXT:     SUBB_UINT T6.X, T11.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T6.Z, T11.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T12.W, PV.Y, PV.X,
; EG-NEXT:     CNDE_INT * T7.W, T1.Y, T7.W, T0.Z,
; EG-NEXT:     SUB_INT T4.X, T9.W, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     LSHL T2.Y, PS, 1,
; EG-NEXT:     BFE_UINT T0.Z, T3.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T12.W, T1.Y, T1.Z, PV.W,
; EG-NEXT:     CNDE_INT * T11.W, PV.Y, T11.W, PV.Z,
; EG-NEXT:    25(3.503246e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T7.X, T2.X, literal.x, 1,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T7.W, literal.y,
; EG-NEXT:     OR_INT T7.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T12.W, PV.X, T6.X,
; EG-NEXT:    25(3.503246e-44), 31(4.344025e-44)
; EG-NEXT:     BFE_UINT T4.X, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT T2.Y, T3.Y, T9.W, PS, BS:VEC_120/SCL_212
; EG-NEXT:     SETGE_UINT T0.Z, PV.W, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T9.W, PV.Z, T4.Z,
; EG-NEXT:     SETGE_UINT * T12.W, PV.Z, T4.Z,
; EG-NEXT:    26(3.643376e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T6.X, T8.W, T4.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT * T0.Z, T7.W, T2.Z, BS:VEC_201
; EG-NEXT:     BIT_ALIGN_INT T8.W, T2.Y, T11.W, literal.x,
; EG-NEXT:     OR_INT * T9.W, T1.Y, T4.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T7.W, T2.Z,
; EG-NEXT:     SUB_INT T1.Y, T1.Z, T4.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T6.Z, PS, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T11.W, PV.W, T1.W,
; EG-NEXT:     SETGE_UINT * T12.W, PV.W, T1.W,
; EG-NEXT:     SUBB_UINT T9.X, T9.W, T0.W,
; EG-NEXT:     CNDE_INT T2.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T6.Z, T9.W, T0.W,
; EG-NEXT:     SUB_INT * T11.W, PV.Y, PV.X,
; EG-NEXT:    ALU clause starting at 952:
; EG-NEXT:     CNDE_INT * T7.W, T3.Y, T7.W, T0.Z,
; EG-NEXT:     SUB_INT T4.X, T8.W, T1.W,
; EG-NEXT:     LSHL T1.Y, PV.W, 1,
; EG-NEXT:     BFE_UINT T0.Z, T3.X, literal.x, 1,
; EG-NEXT:     CNDE_INT * T11.W, T3.Y, T1.Z, T11.W,
; EG-NEXT:    24(3.363116e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT * T9.W, T2.Y, T9.W, T6.Z,
; EG-NEXT:     SUB_INT T10.X, T5.Z, T3.Z,
; EG-NEXT:     LSHL T3.Y, PV.W, 1,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, T11.W, T7.W, literal.x,
; EG-NEXT:     OR_INT T7.W, T1.Y, T0.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT * T11.W, T4.X, T9.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T4.X, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT T1.Y, T2.Y, T8.W, PS, BS:VEC_120/SCL_212
; EG-NEXT:     SETGE_UINT T0.Z, PV.W, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T8.W, PV.Z, T4.Z,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T4.Z,
; EG-NEXT:    25(3.503246e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T9.X, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Y, T7.W, T2.Z,
; EG-NEXT:     BIT_ALIGN_INT T0.Z, PV.Y, T9.W, literal.x,
; EG-NEXT:     OR_INT T8.W, T3.Y, PV.X,
; EG-NEXT:     SUB_INT * T9.W, T10.X, T6.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T4.X, T8.X, T5.Z, PS,
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.Z, PV.Z, T1.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETGE_UINT T9.W, PV.Z, T1.W, BS:VEC_102/SCL_221
; EG-NEXT:     CNDE_INT * T11.W, PV.X, T7.W, PV.Y,
; EG-NEXT:     LSHL T6.X, PS, 1,
; EG-NEXT:     CNDE_INT T1.Y, PV.Z, PV.W, PV.Y,
; EG-NEXT:     SUB_INT T5.Z, T8.W, T0.W,
; EG-NEXT:     BIT_ALIGN_INT T9.W, PV.X, T10.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT * T10.W, T5.X, T7.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T8.W, T0.W,
; EG-NEXT:     SUB_INT * T2.Y, T0.Z, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T6.Z, T10.W, T4.W,
; EG-NEXT:     SETE_INT T12.W, T9.W, T3.Z, BS:VEC_201
; EG-NEXT:     SETGE_UINT * T13.W, T9.W, T3.Z,
; EG-NEXT:     SUBB_UINT T5.X, T10.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T6.Z, T10.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T12.W, T2.Y, T4.X,
; EG-NEXT:     CNDE_INT * T8.W, T1.Y, T8.W, T5.Z,
; EG-NEXT:     SUB_INT T4.X, T9.W, T3.Z,
; EG-NEXT:     LSHL T2.Y, PS, 1,
; EG-NEXT:     BFE_UINT T5.Z, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT T12.W, T1.Y, T0.Z, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T10.W, PV.Y, T10.W, PV.Z,
; EG-NEXT:    24(3.363116e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T7.X, T3.X, literal.x, 1,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T0.Z, PV.W, T8.W, literal.y,
; EG-NEXT:     OR_INT T8.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T12.W, PV.X, T5.X,
; EG-NEXT:    23(3.222986e-44), 31(4.344025e-44)
; EG-NEXT:     BFE_UINT T4.X, T2.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T2.Y, T3.Y, T9.W, PS, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T5.Z, PV.W, T0.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T9.W, PV.Z, T1.W,
; EG-NEXT:     SETGE_UINT * T12.W, PV.Z, T1.W,
; EG-NEXT:    24(3.363116e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T5.X, T7.W, T2.Z,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT * T5.Z, T8.W, T0.W, BS:VEC_120/SCL_212
; EG-NEXT:     BIT_ALIGN_INT T7.W, T2.Y, T10.W, literal.x,
; EG-NEXT:     OR_INT * T9.W, T1.Y, T4.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T8.W, T0.W,
; EG-NEXT:     SUB_INT * T1.Y, T0.Z, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T6.Z, T9.W, T4.W,
; EG-NEXT:     SETE_INT T10.W, T7.W, T3.Z, BS:VEC_201
; EG-NEXT:     SETGE_UINT * T12.W, T7.W, T3.Z,
; EG-NEXT:     SUBB_UINT T8.X, T9.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T2.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T6.Z, T9.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T10.W, T1.Y, T4.X,
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T5.Z,
; EG-NEXT:     SUB_INT T4.X, T7.W, T3.Z,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BFE_UINT T5.Z, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT T10.W, T3.Y, T0.Z, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T9.W, PV.Y, T9.W, PV.Z,
; EG-NEXT:    23(3.222986e-44), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T10.X, T1.Z, T4.Z,
; EG-NEXT:     LSHL T3.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T0.Z, PV.W, T8.W, literal.x,
; EG-NEXT:     OR_INT T8.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T10.W, PV.X, T8.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T4.X, T2.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T1.Y, T2.Y, T7.W, PS, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T5.Z, PV.W, T0.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T7.W, PV.Z, T1.W,
; EG-NEXT:     SETGE_UINT * T10.W, PV.Z, T1.W,
; EG-NEXT:    23(3.222986e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T8.X, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Y, T8.W, T0.W,
; EG-NEXT:     BIT_ALIGN_INT T5.Z, PV.Y, T9.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT T7.W, T3.Y, PV.X,
; EG-NEXT:     SUB_INT * T9.W, T10.X, T5.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T4.X, T9.X, T1.Z, PS,
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T1.Z, PV.Z, T3.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T9.W, PV.Z, T3.Z, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T10.W, PV.X, T8.W, PV.Y,
; EG-NEXT:     LSHL T5.X, PS, 1,
; EG-NEXT:     CNDE_INT T1.Y, PV.Z, PV.W, PV.Y,
; EG-NEXT:     SUB_INT T1.Z, T7.W, T4.W,
; EG-NEXT:     BIT_ALIGN_INT T9.W, PV.X, T11.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT * T11.W, T6.X, T7.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 1067:
; EG-NEXT:     SUBB_UINT T4.X, T7.W, T4.W,
; EG-NEXT:     SUB_INT T2.Y, T5.Z, T3.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT * T6.Z, T11.W, T2.Z, BS:VEC_210
; EG-NEXT:     SETE_INT T12.W, T9.W, T4.Z,
; EG-NEXT:     SETGE_UINT * T13.W, T9.W, T4.Z,
; EG-NEXT:     SUBB_UINT T6.X, T11.W, T2.Z,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, T6.Z,
; EG-NEXT:     SUB_INT T6.Z, T11.W, T2.Z,
; EG-NEXT:     SUB_INT T12.W, T2.Y, T4.X,
; EG-NEXT:     CNDE_INT * T7.W, T1.Y, T7.W, T1.Z,
; EG-NEXT:     SUB_INT T4.X, T9.W, T4.Z,
; EG-NEXT:     LSHL T2.Y, PS, 1,
; EG-NEXT:     BFE_UINT T1.Z, T2.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T12.W, T1.Y, T5.Z, PV.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T11.W, PV.Y, T11.W, PV.Z,
; EG-NEXT:    22(3.082857e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T7.X, T0.Y, literal.x, 1,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T5.Z, PV.W, T7.W, literal.y,
; EG-NEXT:     OR_INT T7.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T12.W, PV.X, T6.X,
; EG-NEXT:    22(3.082857e-44), 31(4.344025e-44)
; EG-NEXT:     BFE_UINT T4.X, T3.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T2.Y, T3.Y, T9.W, PS,
; EG-NEXT:     SETGE_UINT T1.Z, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T9.W, PV.Z, T3.Z,
; EG-NEXT:     SETGE_UINT * T12.W, PV.Z, T3.Z,
; EG-NEXT:    22(3.082857e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T6.X, T8.W, T0.W,
; EG-NEXT:     CNDE_INT * T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T7.W, T4.W,
; EG-NEXT:     BIT_ALIGN_INT T8.W, T2.Y, T11.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT * T9.W, T1.Y, T4.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T7.W, T4.W,
; EG-NEXT:     SUB_INT T1.Y, T5.Z, T3.Z,
; EG-NEXT:     SETGE_UINT * T6.Z, PS, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T11.W, T8.W, T4.Z,
; EG-NEXT:     SETGE_UINT * T12.W, T8.W, T4.Z,
; EG-NEXT:     SUBB_UINT T9.X, T9.W, T2.Z,
; EG-NEXT:     CNDE_INT T2.Y, PV.W, PS, T6.Z,
; EG-NEXT:     SUB_INT T6.Z, T9.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T4.X,
; EG-NEXT:     CNDE_INT * T7.W, T3.Y, T7.W, T1.Z,
; EG-NEXT:     SUB_INT T4.X, T8.W, T4.Z,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BFE_UINT T1.Z, T2.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T11.W, T3.Y, T5.Z, PV.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T9.W, PV.Y, T9.W, PV.Z,
; EG-NEXT:    21(2.942727e-44), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T10.X, T0.Z, T1.W,
; EG-NEXT:     LSHL T3.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T5.Z, PV.W, T7.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT T7.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T11.W, PV.X, T9.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T4.X, T3.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T1.Y, T2.Y, T8.W, PS,
; EG-NEXT:     SETGE_UINT T1.Z, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T8.W, PV.Z, T3.Z,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T3.Z,
; EG-NEXT:    21(2.942727e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T9.X, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Y, T7.W, T4.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.Y, T9.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT T8.W, T3.Y, PV.X,
; EG-NEXT:     SUB_INT * T9.W, T10.X, T6.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T4.X, T8.X, T0.Z, PS,
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T0.Z, PV.Z, T4.Z, BS:VEC_102/SCL_221
; EG-NEXT:     SETGE_UINT T9.W, PV.Z, T4.Z, BS:VEC_102/SCL_221
; EG-NEXT:     CNDE_INT * T11.W, PV.X, T7.W, PV.Y,
; EG-NEXT:     LSHL T6.X, PS, 1,
; EG-NEXT:     CNDE_INT T1.Y, PV.Z, PV.W, PV.Y,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T2.Z,
; EG-NEXT:     BIT_ALIGN_INT T9.W, PV.X, T10.W, literal.x,
; EG-NEXT:     OR_INT * T10.W, T5.X, T7.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T8.W, T2.Z,
; EG-NEXT:     SUB_INT T2.Y, T1.Z, T4.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T6.Z, PS, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T12.W, PV.W, T1.W,
; EG-NEXT:     SETGE_UINT * T13.W, PV.W, T1.W,
; EG-NEXT:     SUBB_UINT T5.X, T10.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T6.Z, T10.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T12.W, PV.Y, PV.X,
; EG-NEXT:     CNDE_INT * T8.W, T1.Y, T8.W, T0.Z,
; EG-NEXT:     SUB_INT T4.X, T9.W, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     LSHL T2.Y, PS, 1,
; EG-NEXT:     BFE_UINT T0.Z, T3.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T12.W, T1.Y, T1.Z, PV.W,
; EG-NEXT:     CNDE_INT * T10.W, PV.Y, T10.W, PV.Z,
; EG-NEXT:    20(2.802597e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T7.X, T2.X, literal.x, 1,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.y,
; EG-NEXT:     OR_INT T8.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T12.W, PV.X, T5.X,
; EG-NEXT:    20(2.802597e-44), 31(4.344025e-44)
; EG-NEXT:     BFE_UINT T4.X, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT T2.Y, T3.Y, T9.W, PS, BS:VEC_120/SCL_212
; EG-NEXT:     SETGE_UINT T0.Z, PV.W, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T9.W, PV.Z, T4.Z,
; EG-NEXT:     SETGE_UINT * T12.W, PV.Z, T4.Z,
; EG-NEXT:    21(2.942727e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T5.X, T7.W, T4.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT * T0.Z, T8.W, T2.Z, BS:VEC_201
; EG-NEXT:     BIT_ALIGN_INT T7.W, T2.Y, T10.W, literal.x,
; EG-NEXT:     OR_INT * T9.W, T1.Y, T4.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT * T4.X, T8.W, T2.Z,
; EG-NEXT:    ALU clause starting at 1181:
; EG-NEXT:     SUB_INT T1.Y, T1.Z, T4.Z,
; EG-NEXT:     SETGE_UINT * T6.Z, T9.W, T0.W,
; EG-NEXT:     SETE_INT T10.W, T7.W, T1.W,
; EG-NEXT:     SETGE_UINT * T12.W, T7.W, T1.W,
; EG-NEXT:     SUBB_UINT T8.X, T9.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T2.Y, PV.W, PS, T6.Z,
; EG-NEXT:     SUB_INT T6.Z, T9.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T10.W, T1.Y, T4.X,
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:     SUB_INT T4.X, T7.W, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BFE_UINT T0.Z, T3.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T10.W, T3.Y, T1.Z, PV.W,
; EG-NEXT:     CNDE_INT * T9.W, PV.Y, T9.W, PV.Z,
; EG-NEXT:    19(2.662467e-44), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T10.X, T5.Z, T3.Z,
; EG-NEXT:     LSHL T3.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x,
; EG-NEXT:     OR_INT T8.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T10.W, PV.X, T8.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T4.X, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT T1.Y, T2.Y, T7.W, PS, BS:VEC_120/SCL_212
; EG-NEXT:     SETGE_UINT T0.Z, PV.W, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T7.W, PV.Z, T4.Z,
; EG-NEXT:     SETGE_UINT * T10.W, PV.Z, T4.Z,
; EG-NEXT:    20(2.802597e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T8.X, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Y, T8.W, T2.Z,
; EG-NEXT:     BIT_ALIGN_INT T0.Z, PV.Y, T9.W, literal.x,
; EG-NEXT:     OR_INT T7.W, T3.Y, PV.X,
; EG-NEXT:     SUB_INT * T9.W, T10.X, T5.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T4.X, T9.X, T5.Z, PS,
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.Z, PV.Z, T1.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETGE_UINT T9.W, PV.Z, T1.W, BS:VEC_102/SCL_221
; EG-NEXT:     CNDE_INT * T10.W, PV.X, T8.W, PV.Y,
; EG-NEXT:     LSHL T5.X, PS, 1,
; EG-NEXT:     CNDE_INT T1.Y, PV.Z, PV.W, PV.Y,
; EG-NEXT:     SUB_INT T5.Z, T7.W, T0.W,
; EG-NEXT:     BIT_ALIGN_INT T9.W, PV.X, T11.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT * T11.W, T6.X, T7.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T7.W, T0.W,
; EG-NEXT:     SUB_INT * T2.Y, T0.Z, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T6.Z, T11.W, T4.W,
; EG-NEXT:     SETE_INT T12.W, T9.W, T3.Z, BS:VEC_201
; EG-NEXT:     SETGE_UINT * T13.W, T9.W, T3.Z,
; EG-NEXT:     SUBB_UINT T6.X, T11.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T6.Z, T11.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T12.W, T2.Y, T4.X,
; EG-NEXT:     CNDE_INT * T7.W, T1.Y, T7.W, T5.Z,
; EG-NEXT:     SUB_INT T4.X, T9.W, T3.Z,
; EG-NEXT:     LSHL T2.Y, PS, 1,
; EG-NEXT:     BFE_UINT T5.Z, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT T12.W, T1.Y, T0.Z, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T11.W, PV.Y, T11.W, PV.Z,
; EG-NEXT:    19(2.662467e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T7.X, T3.X, literal.x, 1,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T0.Z, PV.W, T7.W, literal.y,
; EG-NEXT:     OR_INT T7.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T12.W, PV.X, T6.X,
; EG-NEXT:    18(2.522337e-44), 31(4.344025e-44)
; EG-NEXT:     BFE_UINT T4.X, T2.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T2.Y, T3.Y, T9.W, PS, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T5.Z, PV.W, T0.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T9.W, PV.Z, T1.W,
; EG-NEXT:     SETGE_UINT * T12.W, PV.Z, T1.W,
; EG-NEXT:    19(2.662467e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T6.X, T8.W, T2.Z,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT * T5.Z, T7.W, T0.W, BS:VEC_120/SCL_212
; EG-NEXT:     BIT_ALIGN_INT T8.W, T2.Y, T11.W, literal.x,
; EG-NEXT:     OR_INT * T9.W, T1.Y, T4.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T7.W, T0.W,
; EG-NEXT:     SUB_INT * T1.Y, T0.Z, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T6.Z, T9.W, T4.W,
; EG-NEXT:     SETE_INT T11.W, T8.W, T3.Z, BS:VEC_201
; EG-NEXT:     SETGE_UINT * T12.W, T8.W, T3.Z,
; EG-NEXT:     SUBB_UINT T9.X, T9.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T2.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T6.Z, T9.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T11.W, T1.Y, T4.X,
; EG-NEXT:     CNDE_INT * T7.W, T3.Y, T7.W, T5.Z,
; EG-NEXT:     SUB_INT T4.X, T8.W, T3.Z,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BFE_UINT T5.Z, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT T11.W, T3.Y, T0.Z, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T9.W, PV.Y, T9.W, PV.Z,
; EG-NEXT:    18(2.522337e-44), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T10.X, T1.Z, T4.Z,
; EG-NEXT:     LSHL T3.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T0.Z, PV.W, T7.W, literal.x,
; EG-NEXT:     OR_INT T7.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T11.W, PV.X, T9.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T4.X, T2.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T1.Y, T2.Y, T8.W, PS, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T5.Z, PV.W, T0.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T8.W, PV.Z, T1.W,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T1.W,
; EG-NEXT:    18(2.522337e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T9.X, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Y, T7.W, T0.W,
; EG-NEXT:     BIT_ALIGN_INT T5.Z, PV.Y, T9.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT T8.W, T3.Y, PV.X,
; EG-NEXT:     SUB_INT * T9.W, T10.X, T6.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T4.X, T8.X, T1.Z, PS,
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W,
; EG-NEXT:     SETE_INT * T1.Z, PV.Z, T3.Z, BS:VEC_021/SCL_122
; EG-NEXT:    ALU clause starting at 1296:
; EG-NEXT:     SETGE_UINT T9.W, T5.Z, T3.Z,
; EG-NEXT:     CNDE_INT * T11.W, T9.X, T7.W, T2.Y,
; EG-NEXT:     LSHL T6.X, PS, 1,
; EG-NEXT:     CNDE_INT T1.Y, T1.Z, PV.W, T1.Y,
; EG-NEXT:     SUB_INT T1.Z, T8.W, T4.W,
; EG-NEXT:     BIT_ALIGN_INT T9.W, T4.X, T10.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT * T10.W, T5.X, T7.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T8.W, T4.W,
; EG-NEXT:     SUB_INT T2.Y, T5.Z, T3.Z,
; EG-NEXT:     SETGE_UINT * T6.Z, PS, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T12.W, T9.W, T4.Z,
; EG-NEXT:     SETGE_UINT * T13.W, T9.W, T4.Z,
; EG-NEXT:     SUBB_UINT T5.X, T10.W, T2.Z,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, T6.Z,
; EG-NEXT:     SUB_INT T6.Z, T10.W, T2.Z,
; EG-NEXT:     SUB_INT T12.W, T2.Y, T4.X,
; EG-NEXT:     CNDE_INT * T8.W, T1.Y, T8.W, T1.Z,
; EG-NEXT:     SUB_INT T4.X, T9.W, T4.Z,
; EG-NEXT:     LSHL T2.Y, PS, 1,
; EG-NEXT:     BFE_UINT T1.Z, T2.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T12.W, T1.Y, T5.Z, PV.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T10.W, PV.Y, T10.W, PV.Z,
; EG-NEXT:    17(2.382207e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T7.X, T0.Y, literal.x, 1,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T5.Z, PV.W, T8.W, literal.y,
; EG-NEXT:     OR_INT T8.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T12.W, PV.X, T5.X,
; EG-NEXT:    17(2.382207e-44), 31(4.344025e-44)
; EG-NEXT:     BFE_UINT T4.X, T3.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T2.Y, T3.Y, T9.W, PS,
; EG-NEXT:     SETGE_UINT T1.Z, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T9.W, PV.Z, T3.Z,
; EG-NEXT:     SETGE_UINT * T12.W, PV.Z, T3.Z,
; EG-NEXT:    17(2.382207e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T5.X, T7.W, T0.W,
; EG-NEXT:     CNDE_INT * T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T8.W, T4.W,
; EG-NEXT:     BIT_ALIGN_INT T7.W, T2.Y, T10.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT * T9.W, T1.Y, T4.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T8.W, T4.W,
; EG-NEXT:     SUB_INT T1.Y, T5.Z, T3.Z,
; EG-NEXT:     SETGE_UINT * T6.Z, PS, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T10.W, T7.W, T4.Z,
; EG-NEXT:     SETGE_UINT * T12.W, T7.W, T4.Z,
; EG-NEXT:     SUBB_UINT T8.X, T9.W, T2.Z,
; EG-NEXT:     CNDE_INT T2.Y, PV.W, PS, T6.Z,
; EG-NEXT:     SUB_INT T6.Z, T9.W, T2.Z,
; EG-NEXT:     SUB_INT T10.W, T1.Y, T4.X,
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T1.Z,
; EG-NEXT:     SUB_INT T4.X, T7.W, T4.Z,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BFE_UINT T1.Z, T2.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T10.W, T3.Y, T5.Z, PV.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T9.W, PV.Y, T9.W, PV.Z,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T10.X, T0.Z, T1.W,
; EG-NEXT:     LSHL T3.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T5.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT T8.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T10.W, PV.X, T8.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T4.X, T3.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T1.Y, T2.Y, T7.W, PS,
; EG-NEXT:     SETGE_UINT T1.Z, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T7.W, PV.Z, T3.Z,
; EG-NEXT:     SETGE_UINT * T10.W, PV.Z, T3.Z,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T8.X, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Y, T8.W, T4.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.Y, T9.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT T7.W, T3.Y, PV.X,
; EG-NEXT:     SUB_INT * T9.W, T10.X, T5.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T4.X, T9.X, T0.Z, PS,
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T0.Z, PV.Z, T4.Z, BS:VEC_102/SCL_221
; EG-NEXT:     SETGE_UINT T9.W, PV.Z, T4.Z, BS:VEC_102/SCL_221
; EG-NEXT:     CNDE_INT * T10.W, PV.X, T8.W, PV.Y,
; EG-NEXT:     LSHL T5.X, PS, 1,
; EG-NEXT:     CNDE_INT T1.Y, PV.Z, PV.W, PV.Y,
; EG-NEXT:     SUB_INT T0.Z, T7.W, T2.Z,
; EG-NEXT:     BIT_ALIGN_INT T9.W, PV.X, T11.W, literal.x,
; EG-NEXT:     OR_INT * T11.W, T6.X, T7.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T7.W, T2.Z,
; EG-NEXT:     SUB_INT T2.Y, T1.Z, T4.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T6.Z, PS, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T12.W, PV.W, T1.W,
; EG-NEXT:     SETGE_UINT * T13.W, PV.W, T1.W,
; EG-NEXT:     SUBB_UINT T6.X, T11.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T6.Z, T11.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T12.W, PV.Y, PV.X,
; EG-NEXT:     CNDE_INT * T7.W, T1.Y, T7.W, T0.Z,
; EG-NEXT:     SUB_INT T4.X, T9.W, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     LSHL T2.Y, PS, 1,
; EG-NEXT:     BFE_UINT T0.Z, T3.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T12.W, T1.Y, T1.Z, PV.W,
; EG-NEXT:     CNDE_INT * T11.W, PV.Y, T11.W, PV.Z,
; EG-NEXT:    15(2.101948e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T7.X, T2.X, literal.x, 1,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T7.W, literal.y,
; EG-NEXT:     OR_INT T7.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T12.W, PV.X, T6.X,
; EG-NEXT:    15(2.101948e-44), 31(4.344025e-44)
; EG-NEXT:     BFE_UINT T4.X, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT T2.Y, T3.Y, T9.W, PS, BS:VEC_120/SCL_212
; EG-NEXT:     SETGE_UINT T0.Z, PV.W, T2.Z,
; EG-NEXT:     SETE_INT * T9.W, PV.Z, T4.Z, BS:VEC_021/SCL_122
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 1410:
; EG-NEXT:     SETGE_UINT * T12.W, T1.Z, T4.Z,
; EG-NEXT:     SUBB_UINT T6.X, T8.W, T4.W,
; EG-NEXT:     CNDE_INT * T3.Y, T9.W, PV.W, T0.Z, BS:VEC_201
; EG-NEXT:     SUB_INT T0.Z, T7.W, T2.Z,
; EG-NEXT:     BIT_ALIGN_INT T8.W, T2.Y, T11.W, literal.x,
; EG-NEXT:     OR_INT * T9.W, T1.Y, T4.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T7.W, T2.Z,
; EG-NEXT:     SUB_INT T1.Y, T1.Z, T4.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T6.Z, PS, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T11.W, PV.W, T1.W,
; EG-NEXT:     SETGE_UINT * T12.W, PV.W, T1.W,
; EG-NEXT:     SUBB_UINT T9.X, T9.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T2.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T6.Z, T9.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T11.W, PV.Y, PV.X,
; EG-NEXT:     CNDE_INT * T7.W, T3.Y, T7.W, T0.Z,
; EG-NEXT:     SUB_INT T4.X, T8.W, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BFE_UINT T0.Z, T3.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T11.W, T3.Y, T1.Z, PV.W,
; EG-NEXT:     CNDE_INT * T9.W, PV.Y, T9.W, PV.Z,
; EG-NEXT:    14(1.961818e-44), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T10.X, T5.Z, T3.Z,
; EG-NEXT:     LSHL T3.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T7.W, literal.x,
; EG-NEXT:     OR_INT T7.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T11.W, PV.X, T9.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T4.X, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT T1.Y, T2.Y, T8.W, PS, BS:VEC_120/SCL_212
; EG-NEXT:     SETGE_UINT T0.Z, PV.W, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T8.W, PV.Z, T4.Z,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T4.Z,
; EG-NEXT:    15(2.101948e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T9.X, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Y, T7.W, T2.Z,
; EG-NEXT:     BIT_ALIGN_INT T0.Z, PV.Y, T9.W, literal.x,
; EG-NEXT:     OR_INT T8.W, T3.Y, PV.X,
; EG-NEXT:     SUB_INT * T9.W, T10.X, T6.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T4.X, T8.X, T5.Z, PS,
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.Z, PV.Z, T1.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETGE_UINT T9.W, PV.Z, T1.W, BS:VEC_102/SCL_221
; EG-NEXT:     CNDE_INT * T11.W, PV.X, T7.W, PV.Y,
; EG-NEXT:     LSHL T6.X, PS, 1,
; EG-NEXT:     CNDE_INT T1.Y, PV.Z, PV.W, PV.Y,
; EG-NEXT:     SUB_INT T5.Z, T8.W, T0.W,
; EG-NEXT:     BIT_ALIGN_INT T9.W, PV.X, T10.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT * T10.W, T5.X, T7.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T8.W, T0.W,
; EG-NEXT:     SUB_INT * T2.Y, T0.Z, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T6.Z, T10.W, T4.W,
; EG-NEXT:     SETE_INT T12.W, T9.W, T3.Z, BS:VEC_201
; EG-NEXT:     SETGE_UINT * T13.W, T9.W, T3.Z,
; EG-NEXT:     SUBB_UINT T5.X, T10.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T6.Z, T10.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T12.W, T2.Y, T4.X,
; EG-NEXT:     CNDE_INT * T8.W, T1.Y, T8.W, T5.Z,
; EG-NEXT:     SUB_INT T4.X, T9.W, T3.Z,
; EG-NEXT:     LSHL T2.Y, PS, 1,
; EG-NEXT:     BFE_UINT T5.Z, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT T12.W, T1.Y, T0.Z, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T10.W, PV.Y, T10.W, PV.Z,
; EG-NEXT:    14(1.961818e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T7.X, T3.X, literal.x, 1,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T0.Z, PV.W, T8.W, literal.y,
; EG-NEXT:     OR_INT T8.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T12.W, PV.X, T5.X,
; EG-NEXT:    13(1.821688e-44), 31(4.344025e-44)
; EG-NEXT:     BFE_UINT T4.X, T2.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T2.Y, T3.Y, T9.W, PS, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T5.Z, PV.W, T0.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T9.W, PV.Z, T1.W,
; EG-NEXT:     SETGE_UINT * T12.W, PV.Z, T1.W,
; EG-NEXT:    14(1.961818e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T5.X, T7.W, T2.Z,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT * T5.Z, T8.W, T0.W, BS:VEC_120/SCL_212
; EG-NEXT:     BIT_ALIGN_INT T7.W, T2.Y, T10.W, literal.x,
; EG-NEXT:     OR_INT * T9.W, T1.Y, T4.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T8.W, T0.W,
; EG-NEXT:     SUB_INT * T1.Y, T0.Z, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T6.Z, T9.W, T4.W,
; EG-NEXT:     SETE_INT T10.W, T7.W, T3.Z, BS:VEC_201
; EG-NEXT:     SETGE_UINT * T12.W, T7.W, T3.Z,
; EG-NEXT:     SUBB_UINT T8.X, T9.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T2.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T6.Z, T9.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T10.W, T1.Y, T4.X,
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T5.Z,
; EG-NEXT:     SUB_INT T4.X, T7.W, T3.Z,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BFE_UINT T5.Z, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT T10.W, T3.Y, T0.Z, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T9.W, PV.Y, T9.W, PV.Z,
; EG-NEXT:    13(1.821688e-44), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T10.X, T1.Z, T4.Z,
; EG-NEXT:     LSHL T3.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T0.Z, PV.W, T8.W, literal.x,
; EG-NEXT:     OR_INT T8.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T10.W, PV.X, T8.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T4.X, T2.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T1.Y, T2.Y, T7.W, PS, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T5.Z, PV.W, T0.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T7.W, PV.Z, T1.W,
; EG-NEXT:     SETGE_UINT * T10.W, PV.Z, T1.W,
; EG-NEXT:    13(1.821688e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT * T8.X, PV.W, PS, PV.Z,
; EG-NEXT:    ALU clause starting at 1525:
; EG-NEXT:     SUB_INT T2.Y, T8.W, T0.W,
; EG-NEXT:     BIT_ALIGN_INT T5.Z, T1.Y, T9.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT T7.W, T3.Y, T4.X, BS:VEC_102/SCL_221
; EG-NEXT:     SUB_INT * T9.W, T10.X, T5.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T4.X, T9.X, T1.Z, PS,
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T1.Z, PV.Z, T3.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T9.W, PV.Z, T3.Z, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T10.W, T8.X, T8.W, PV.Y,
; EG-NEXT:     LSHL T5.X, PS, 1,
; EG-NEXT:     CNDE_INT T1.Y, PV.Z, PV.W, PV.Y,
; EG-NEXT:     SUB_INT T1.Z, T7.W, T4.W,
; EG-NEXT:     BIT_ALIGN_INT T9.W, PV.X, T11.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT * T11.W, T6.X, T7.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T7.W, T4.W,
; EG-NEXT:     SUB_INT T2.Y, T5.Z, T3.Z,
; EG-NEXT:     SETGE_UINT * T6.Z, PS, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T12.W, T9.W, T4.Z,
; EG-NEXT:     SETGE_UINT * T13.W, T9.W, T4.Z,
; EG-NEXT:     SUBB_UINT T6.X, T11.W, T2.Z,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, T6.Z,
; EG-NEXT:     SUB_INT T6.Z, T11.W, T2.Z,
; EG-NEXT:     SUB_INT T12.W, T2.Y, T4.X,
; EG-NEXT:     CNDE_INT * T7.W, T1.Y, T7.W, T1.Z,
; EG-NEXT:     SUB_INT T4.X, T9.W, T4.Z,
; EG-NEXT:     LSHL T2.Y, PS, 1,
; EG-NEXT:     BFE_UINT T1.Z, T2.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T12.W, T1.Y, T5.Z, PV.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T11.W, PV.Y, T11.W, PV.Z,
; EG-NEXT:    12(1.681558e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T7.X, T0.Y, literal.x, 1,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T5.Z, PV.W, T7.W, literal.y,
; EG-NEXT:     OR_INT T7.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T12.W, PV.X, T6.X,
; EG-NEXT:    12(1.681558e-44), 31(4.344025e-44)
; EG-NEXT:     BFE_UINT T4.X, T3.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T2.Y, T3.Y, T9.W, PS,
; EG-NEXT:     SETGE_UINT T1.Z, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T9.W, PV.Z, T3.Z,
; EG-NEXT:     SETGE_UINT * T12.W, PV.Z, T3.Z,
; EG-NEXT:    12(1.681558e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T6.X, T8.W, T0.W,
; EG-NEXT:     CNDE_INT * T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T7.W, T4.W,
; EG-NEXT:     BIT_ALIGN_INT T8.W, T2.Y, T11.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT * T9.W, T1.Y, T4.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T7.W, T4.W,
; EG-NEXT:     SUB_INT T1.Y, T5.Z, T3.Z,
; EG-NEXT:     SETGE_UINT * T6.Z, PS, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T11.W, T8.W, T4.Z,
; EG-NEXT:     SETGE_UINT * T12.W, T8.W, T4.Z,
; EG-NEXT:     SUBB_UINT T9.X, T9.W, T2.Z,
; EG-NEXT:     CNDE_INT T2.Y, PV.W, PS, T6.Z,
; EG-NEXT:     SUB_INT T6.Z, T9.W, T2.Z,
; EG-NEXT:     SUB_INT T11.W, T1.Y, T4.X,
; EG-NEXT:     CNDE_INT * T7.W, T3.Y, T7.W, T1.Z,
; EG-NEXT:     SUB_INT T4.X, T8.W, T4.Z,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BFE_UINT T1.Z, T2.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T11.W, T3.Y, T5.Z, PV.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T9.W, PV.Y, T9.W, PV.Z,
; EG-NEXT:    11(1.541428e-44), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T10.X, T0.Z, T1.W,
; EG-NEXT:     LSHL T3.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T5.Z, PV.W, T7.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT T7.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T11.W, PV.X, T9.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T4.X, T3.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T1.Y, T2.Y, T8.W, PS,
; EG-NEXT:     SETGE_UINT T1.Z, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T8.W, PV.Z, T3.Z,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T3.Z,
; EG-NEXT:    11(1.541428e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T9.X, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Y, T7.W, T4.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.Y, T9.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT T8.W, T3.Y, PV.X,
; EG-NEXT:     SUB_INT * T9.W, T10.X, T6.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T4.X, T8.X, T0.Z, PS,
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T0.Z, PV.Z, T4.Z, BS:VEC_102/SCL_221
; EG-NEXT:     SETGE_UINT T9.W, PV.Z, T4.Z, BS:VEC_102/SCL_221
; EG-NEXT:     CNDE_INT * T11.W, PV.X, T7.W, PV.Y,
; EG-NEXT:     LSHL T6.X, PS, 1,
; EG-NEXT:     CNDE_INT T1.Y, PV.Z, PV.W, PV.Y,
; EG-NEXT:     SUB_INT T0.Z, T8.W, T2.Z,
; EG-NEXT:     BIT_ALIGN_INT T9.W, PV.X, T10.W, literal.x,
; EG-NEXT:     OR_INT * T10.W, T5.X, T7.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T8.W, T2.Z,
; EG-NEXT:     SUB_INT T2.Y, T1.Z, T4.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T6.Z, PS, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T12.W, PV.W, T1.W,
; EG-NEXT:     SETGE_UINT * T13.W, PV.W, T1.W,
; EG-NEXT:     SUBB_UINT T5.X, T10.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T6.Z, T10.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T12.W, PV.Y, PV.X,
; EG-NEXT:     CNDE_INT * T8.W, T1.Y, T8.W, T0.Z,
; EG-NEXT:     SUB_INT T4.X, T9.W, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     LSHL T2.Y, PS, 1,
; EG-NEXT:     BFE_UINT T0.Z, T3.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T12.W, T1.Y, T1.Z, PV.W,
; EG-NEXT:     CNDE_INT * T10.W, PV.Y, T10.W, PV.Z,
; EG-NEXT:    10(1.401298e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T7.X, T2.X, literal.x, 1,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT * T1.Z, PV.W, T8.W, literal.y,
; EG-NEXT:    10(1.401298e-44), 31(4.344025e-44)
; EG-NEXT:    ALU clause starting at 1640:
; EG-NEXT:     OR_INT T8.W, T2.Y, T0.Z,
; EG-NEXT:     SUB_INT * T12.W, T4.X, T5.X,
; EG-NEXT:     BFE_UINT T4.X, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT T2.Y, T3.Y, T9.W, PS, BS:VEC_120/SCL_212
; EG-NEXT:     SETGE_UINT T0.Z, PV.W, T2.Z, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T9.W, T1.Z, T4.Z, BS:VEC_210
; EG-NEXT:     SETGE_UINT * T12.W, T1.Z, T4.Z,
; EG-NEXT:    11(1.541428e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T5.X, T7.W, T4.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT * T0.Z, T8.W, T2.Z, BS:VEC_201
; EG-NEXT:     BIT_ALIGN_INT T7.W, T2.Y, T10.W, literal.x,
; EG-NEXT:     OR_INT * T9.W, T1.Y, T4.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T8.W, T2.Z,
; EG-NEXT:     SUB_INT T1.Y, T1.Z, T4.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T6.Z, PS, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T10.W, PV.W, T1.W,
; EG-NEXT:     SETGE_UINT * T12.W, PV.W, T1.W,
; EG-NEXT:     SUBB_UINT T8.X, T9.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T2.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T6.Z, T9.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T10.W, PV.Y, PV.X,
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T0.Z,
; EG-NEXT:     SUB_INT T4.X, T7.W, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BFE_UINT T0.Z, T3.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T10.W, T3.Y, T1.Z, PV.W,
; EG-NEXT:     CNDE_INT * T9.W, PV.Y, T9.W, PV.Z,
; EG-NEXT:    9(1.261169e-44), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T10.X, T5.Z, T3.Z,
; EG-NEXT:     LSHL T3.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T8.W, literal.x,
; EG-NEXT:     OR_INT T8.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T10.W, PV.X, T8.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T4.X, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT T1.Y, T2.Y, T7.W, PS, BS:VEC_120/SCL_212
; EG-NEXT:     SETGE_UINT T0.Z, PV.W, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T7.W, PV.Z, T4.Z,
; EG-NEXT:     SETGE_UINT * T10.W, PV.Z, T4.Z,
; EG-NEXT:    10(1.401298e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T8.X, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Y, T8.W, T2.Z,
; EG-NEXT:     BIT_ALIGN_INT T0.Z, PV.Y, T9.W, literal.x,
; EG-NEXT:     OR_INT T7.W, T3.Y, PV.X,
; EG-NEXT:     SUB_INT * T9.W, T10.X, T5.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T4.X, T9.X, T5.Z, PS,
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.Z, PV.Z, T1.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETGE_UINT T9.W, PV.Z, T1.W, BS:VEC_102/SCL_221
; EG-NEXT:     CNDE_INT * T10.W, PV.X, T8.W, PV.Y,
; EG-NEXT:     LSHL T5.X, PS, 1,
; EG-NEXT:     CNDE_INT T1.Y, PV.Z, PV.W, PV.Y,
; EG-NEXT:     SUB_INT T5.Z, T7.W, T0.W,
; EG-NEXT:     BIT_ALIGN_INT T9.W, PV.X, T11.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT * T11.W, T6.X, T7.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T7.W, T0.W,
; EG-NEXT:     SUB_INT * T2.Y, T0.Z, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T6.Z, T11.W, T4.W,
; EG-NEXT:     SETE_INT T12.W, T9.W, T3.Z, BS:VEC_201
; EG-NEXT:     SETGE_UINT * T13.W, T9.W, T3.Z,
; EG-NEXT:     SUBB_UINT T6.X, T11.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T6.Z, T11.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T12.W, T2.Y, T4.X,
; EG-NEXT:     CNDE_INT * T7.W, T1.Y, T7.W, T5.Z,
; EG-NEXT:     SUB_INT T4.X, T9.W, T3.Z,
; EG-NEXT:     LSHL T2.Y, PS, 1,
; EG-NEXT:     BFE_UINT T5.Z, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT T12.W, T1.Y, T0.Z, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T11.W, PV.Y, T11.W, PV.Z,
; EG-NEXT:    9(1.261169e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T7.X, T3.X, literal.x, 1,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T0.Z, PV.W, T7.W, literal.y,
; EG-NEXT:     OR_INT T7.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T12.W, PV.X, T6.X,
; EG-NEXT:    8(1.121039e-44), 31(4.344025e-44)
; EG-NEXT:     BFE_UINT T4.X, T2.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T2.Y, T3.Y, T9.W, PS, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T5.Z, PV.W, T0.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETE_INT T9.W, PV.Z, T1.W,
; EG-NEXT:     SETGE_UINT * T12.W, PV.Z, T1.W,
; EG-NEXT:    9(1.261169e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T6.X, T8.W, T2.Z,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT * T5.Z, T7.W, T0.W, BS:VEC_120/SCL_212
; EG-NEXT:     BIT_ALIGN_INT T8.W, T2.Y, T11.W, literal.x,
; EG-NEXT:     OR_INT * T9.W, T1.Y, T4.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T7.W, T0.W,
; EG-NEXT:     SUB_INT * T1.Y, T0.Z, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T6.Z, T9.W, T4.W,
; EG-NEXT:     SETE_INT T11.W, T8.W, T3.Z, BS:VEC_201
; EG-NEXT:     SETGE_UINT * T12.W, T8.W, T3.Z,
; EG-NEXT:     SUBB_UINT T9.X, T9.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T2.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T6.Z, T9.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T11.W, T1.Y, T4.X,
; EG-NEXT:     CNDE_INT * T7.W, T3.Y, T7.W, T5.Z,
; EG-NEXT:     SUB_INT T4.X, T8.W, T3.Z,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BFE_UINT T5.Z, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT T11.W, T3.Y, T0.Z, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T9.W, PV.Y, T9.W, PV.Z,
; EG-NEXT:    8(1.121039e-44), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T10.X, T1.Z, T4.Z,
; EG-NEXT:     LSHL T3.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T0.Z, PV.W, T7.W, literal.x,
; EG-NEXT:     OR_INT T7.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T11.W, PV.X, T9.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 1755:
; EG-NEXT:     BFE_UINT T4.X, T2.X, literal.x, 1,
; EG-NEXT:     CNDE_INT * T1.Y, T2.Y, T8.W, T11.W,
; EG-NEXT:    8(1.121039e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T5.Z, T7.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T8.W, T0.Z, T1.W,
; EG-NEXT:     SETGE_UINT * T11.W, T0.Z, T1.W,
; EG-NEXT:     CNDE_INT T9.X, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Y, T7.W, T0.W,
; EG-NEXT:     BIT_ALIGN_INT T5.Z, T1.Y, T9.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT T8.W, T3.Y, T4.X, BS:VEC_102/SCL_221
; EG-NEXT:     SUB_INT * T9.W, T10.X, T6.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T4.X, T8.X, T1.Z, PS,
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T1.Z, PV.Z, T3.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T9.W, PV.Z, T3.Z, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T11.W, PV.X, T7.W, PV.Y,
; EG-NEXT:     LSHL T6.X, PS, 1,
; EG-NEXT:     CNDE_INT T1.Y, PV.Z, PV.W, PV.Y,
; EG-NEXT:     SUB_INT T1.Z, T8.W, T4.W,
; EG-NEXT:     BIT_ALIGN_INT T9.W, PV.X, T10.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT * T10.W, T5.X, T7.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T8.W, T4.W,
; EG-NEXT:     SUB_INT T2.Y, T5.Z, T3.Z,
; EG-NEXT:     SETGE_UINT * T6.Z, PS, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T12.W, T9.W, T4.Z,
; EG-NEXT:     SETGE_UINT * T13.W, T9.W, T4.Z,
; EG-NEXT:     SUBB_UINT T5.X, T10.W, T2.Z,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, T6.Z,
; EG-NEXT:     SUB_INT T6.Z, T10.W, T2.Z,
; EG-NEXT:     SUB_INT T12.W, T2.Y, T4.X,
; EG-NEXT:     CNDE_INT * T8.W, T1.Y, T8.W, T1.Z,
; EG-NEXT:     SUB_INT T4.X, T9.W, T4.Z,
; EG-NEXT:     LSHL T2.Y, PS, 1,
; EG-NEXT:     BFE_UINT T1.Z, T2.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T12.W, T1.Y, T5.Z, PV.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T10.W, PV.Y, T10.W, PV.Z,
; EG-NEXT:    7(9.809089e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T7.X, T0.Y, literal.x, 1,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T5.Z, PV.W, T8.W, literal.y,
; EG-NEXT:     OR_INT T8.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T12.W, PV.X, T5.X,
; EG-NEXT:    7(9.809089e-45), 31(4.344025e-44)
; EG-NEXT:     BFE_UINT T4.X, T3.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T2.Y, T3.Y, T9.W, PS,
; EG-NEXT:     SETGE_UINT T1.Z, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T9.W, PV.Z, T3.Z,
; EG-NEXT:     SETGE_UINT * T12.W, PV.Z, T3.Z,
; EG-NEXT:    7(9.809089e-45), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T5.X, T7.W, T0.W,
; EG-NEXT:     CNDE_INT * T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T1.Z, T8.W, T4.W,
; EG-NEXT:     BIT_ALIGN_INT T7.W, T2.Y, T10.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT * T9.W, T1.Y, T4.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T8.W, T4.W,
; EG-NEXT:     SUB_INT T1.Y, T5.Z, T3.Z,
; EG-NEXT:     SETGE_UINT * T6.Z, PS, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T10.W, T7.W, T4.Z,
; EG-NEXT:     SETGE_UINT * T12.W, T7.W, T4.Z,
; EG-NEXT:     SUBB_UINT T8.X, T9.W, T2.Z,
; EG-NEXT:     CNDE_INT T2.Y, PV.W, PS, T6.Z,
; EG-NEXT:     SUB_INT T6.Z, T9.W, T2.Z,
; EG-NEXT:     SUB_INT T10.W, T1.Y, T4.X,
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T1.Z,
; EG-NEXT:     SUB_INT T4.X, T7.W, T4.Z,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BFE_UINT T1.Z, T2.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T10.W, T3.Y, T5.Z, PV.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T9.W, PV.Y, T9.W, PV.Z,
; EG-NEXT:    6(8.407791e-45), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T10.X, T0.Z, T1.W,
; EG-NEXT:     LSHL T3.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T5.Z, PV.W, T8.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT T8.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T10.W, PV.X, T8.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T4.X, T3.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T1.Y, T2.Y, T7.W, PS,
; EG-NEXT:     SETGE_UINT T1.Z, PV.W, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T7.W, PV.Z, T3.Z,
; EG-NEXT:     SETGE_UINT * T10.W, PV.Z, T3.Z,
; EG-NEXT:    6(8.407791e-45), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T8.X, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Y, T8.W, T4.W,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.Y, T9.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT T7.W, T3.Y, PV.X,
; EG-NEXT:     SUB_INT * T9.W, T10.X, T5.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T4.X, T9.X, T0.Z, PS,
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T0.Z, PV.Z, T4.Z, BS:VEC_102/SCL_221
; EG-NEXT:     SETGE_UINT T9.W, PV.Z, T4.Z, BS:VEC_102/SCL_221
; EG-NEXT:     CNDE_INT * T10.W, PV.X, T8.W, PV.Y,
; EG-NEXT:     LSHL T5.X, PS, 1,
; EG-NEXT:     CNDE_INT T1.Y, PV.Z, PV.W, PV.Y,
; EG-NEXT:     SUB_INT T0.Z, T7.W, T2.Z,
; EG-NEXT:     BIT_ALIGN_INT T9.W, PV.X, T11.W, literal.x,
; EG-NEXT:     OR_INT * T11.W, T6.X, T7.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T7.W, T2.Z,
; EG-NEXT:     SUB_INT T2.Y, T1.Z, T4.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T6.Z, PS, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T12.W, PV.W, T1.W,
; EG-NEXT:     SETGE_UINT * T13.W, PV.W, T1.W,
; EG-NEXT:     SUBB_UINT T6.X, T11.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T6.Z, T11.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T12.W, PV.Y, PV.X,
; EG-NEXT:     CNDE_INT * T7.W, T1.Y, T7.W, T0.Z,
; EG-NEXT:     SUB_INT T4.X, T9.W, T1.W,
; EG-NEXT:     LSHL T2.Y, PS, 1,
; EG-NEXT:     BFE_UINT * T0.Z, T3.X, literal.x, 1,
; EG-NEXT:    5(7.006492e-45), 0(0.000000e+00)
; EG-NEXT:    ALU clause starting at 1871:
; EG-NEXT:     CNDE_INT T12.W, T1.Y, T1.Z, T12.W,
; EG-NEXT:     CNDE_INT * T11.W, T3.Y, T11.W, T6.Z,
; EG-NEXT:     BFE_UINT T7.X, T2.X, literal.x, 1,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T7.W, literal.y,
; EG-NEXT:     OR_INT T7.W, T2.Y, T0.Z,
; EG-NEXT:     SUB_INT * T12.W, T4.X, T6.X,
; EG-NEXT:    5(7.006492e-45), 31(4.344025e-44)
; EG-NEXT:     BFE_UINT T4.X, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT T2.Y, T3.Y, T9.W, PS, BS:VEC_120/SCL_212
; EG-NEXT:     SETGE_UINT T0.Z, PV.W, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T9.W, PV.Z, T4.Z,
; EG-NEXT:     SETGE_UINT * T12.W, PV.Z, T4.Z,
; EG-NEXT:    6(8.407791e-45), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T6.X, T8.W, T4.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT * T0.Z, T7.W, T2.Z, BS:VEC_201
; EG-NEXT:     BIT_ALIGN_INT T8.W, T2.Y, T11.W, literal.x,
; EG-NEXT:     OR_INT * T9.W, T1.Y, T4.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T4.X, T7.W, T2.Z,
; EG-NEXT:     SUB_INT T1.Y, T1.Z, T4.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T6.Z, PS, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T11.W, PV.W, T1.W,
; EG-NEXT:     SETGE_UINT * T12.W, PV.W, T1.W,
; EG-NEXT:     SUBB_UINT T9.X, T9.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T2.Y, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T6.Z, T9.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T11.W, PV.Y, PV.X,
; EG-NEXT:     CNDE_INT * T7.W, T3.Y, T7.W, T0.Z,
; EG-NEXT:     SUB_INT T4.X, T8.W, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BFE_UINT T0.Z, T3.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T11.W, T3.Y, T1.Z, PV.W,
; EG-NEXT:     CNDE_INT * T9.W, PV.Y, T9.W, PV.Z,
; EG-NEXT:    4(5.605194e-45), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T10.X, T5.Z, T3.Z,
; EG-NEXT:     LSHL T3.Y, PS, 1,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.W, T7.W, literal.x,
; EG-NEXT:     OR_INT T7.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T11.W, PV.X, T9.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T4.X, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT T1.Y, T2.Y, T8.W, PS, BS:VEC_120/SCL_212
; EG-NEXT:     SETGE_UINT T0.Z, PV.W, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T8.W, PV.Z, T4.Z,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T4.Z,
; EG-NEXT:    5(7.006492e-45), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T9.X, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T2.Y, T7.W, T2.Z,
; EG-NEXT:     BIT_ALIGN_INT T0.Z, PV.Y, T9.W, literal.x,
; EG-NEXT:     OR_INT T8.W, T3.Y, PV.X,
; EG-NEXT:     SUB_INT * T9.W, T10.X, T6.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T4.X, T8.X, T5.Z, PS,
; EG-NEXT:     SETGE_UINT T1.Y, PV.W, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T5.Z, PV.Z, T1.W, BS:VEC_102/SCL_221
; EG-NEXT:     SETGE_UINT T9.W, PV.Z, T1.W, BS:VEC_102/SCL_221
; EG-NEXT:     CNDE_INT * T11.W, PV.X, T7.W, PV.Y,
; EG-NEXT:     LSHL T6.X, PS, 1,
; EG-NEXT:     CNDE_INT T1.Y, PV.Z, PV.W, PV.Y,
; EG-NEXT:     SUB_INT T5.Z, T8.W, T0.W,
; EG-NEXT:     BIT_ALIGN_INT T9.W, PV.X, T10.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT * T10.W, T5.X, T7.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T4.X, T3.X, literal.x, 1,
; EG-NEXT:     SETGE_UINT T2.Y, PS, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T6.Z, PV.W, T3.Z,
; EG-NEXT:     SETGE_UINT T12.W, PV.W, T3.Z,
; EG-NEXT:     CNDE_INT * T13.W, PV.Y, T8.W, PV.Z,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     LSHL T5.X, PS, 1,
; EG-NEXT:     CNDE_INT T2.Y, PV.Z, PV.W, PV.Y,
; EG-NEXT:     SUB_INT T5.Z, T10.W, T4.W,
; EG-NEXT:     SUBB_UINT T12.W, T10.W, T4.W,
; EG-NEXT:     SUB_INT * T14.W, T9.W, T3.Z,
; EG-NEXT:     SUBB_UINT T7.X, T7.W, T2.Z,
; EG-NEXT:     SUBB_UINT * T3.Y, T8.W, T0.W, BS:VEC_120/SCL_212
; EG-NEXT:     SUB_INT T6.Z, T0.Z, T1.W,
; EG-NEXT:     SUB_INT * T7.W, T14.W, T12.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T8.W, T2.Y, T10.W, T5.Z,
; EG-NEXT:     SUB_INT T8.X, T1.Z, T4.Z,
; EG-NEXT:     LSHL T4.Y, PV.W, 1,
; EG-NEXT:     BFE_UINT T5.Z, T2.X, literal.x, 1,
; EG-NEXT:     CNDE_INT T7.W, T2.Y, T9.W, T7.W,
; EG-NEXT:     SUB_INT * T9.W, T6.Z, T3.Y,
; EG-NEXT:    4(5.605194e-45), 0(0.000000e+00)
; EG-NEXT:     BFE_UINT T10.X, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT T1.Y, T1.Y, T0.Z, PS, BS:VEC_120/SCL_212
; EG-NEXT:     BIT_ALIGN_INT T0.Z, PV.W, T8.W, literal.y,
; EG-NEXT:     OR_INT T7.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT * T8.W, PV.X, T7.X,
; EG-NEXT:    4(5.605194e-45), 31(4.344025e-44)
; EG-NEXT:     CNDE_INT T7.X, T9.X, T1.Z, PS,
; EG-NEXT:     SETGE_UINT T2.Y, PV.W, T4.W,
; EG-NEXT:     SETE_INT T1.Z, PV.Z, T3.Z, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T8.W, PV.Y, T13.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT * T9.W, T5.X, PV.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T5.X, T0.Z, T3.Z,
; EG-NEXT:     SUBB_UINT T1.Y, T7.W, T4.W,
; EG-NEXT:     SETGE_UINT * T5.Z, PS, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T10.W, T8.W, T1.W,
; EG-NEXT:     SETGE_UINT * T12.W, T8.W, T1.W,
; EG-NEXT:     SUB_INT T8.X, T0.Z, T3.Z,
; EG-NEXT:     CNDE_INT T3.Y, PV.W, PS, T5.Z,
; EG-NEXT:     SUB_INT T5.Z, T9.W, T0.W,
; EG-NEXT:     SUBB_UINT * T10.W, T9.W, T0.W,
; EG-NEXT:     SUB_INT * T12.W, T8.W, T1.W,
; EG-NEXT:     SUB_INT T9.X, PV.W, T10.W,
; EG-NEXT:     CNDE_INT * T4.Y, T3.Y, T9.W, T5.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T5.Z, T7.W, T4.W,
; EG-NEXT:     SUB_INT T9.W, T8.X, T1.Y,
; EG-NEXT:     CNDE_INT * T10.W, T1.Z, T5.X, T2.Y,
; EG-NEXT:    ALU clause starting at 1985:
; EG-NEXT:     CNDE_INT T5.X, T10.W, T0.Z, T9.W,
; EG-NEXT:     CNDE_INT T1.Y, T10.W, T7.W, T5.Z,
; EG-NEXT:     LSHL T0.Z, T4.Y, 1,
; EG-NEXT:     BFE_UINT * T7.W, T0.Y, literal.x, 1, BS:VEC_120/SCL_212
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT * T8.W, T3.Y, T8.W, T9.X,
; EG-NEXT:     BIT_ALIGN_INT T8.X, PV.W, T4.Y, literal.x,
; EG-NEXT:     OR_INT T2.Y, T0.Z, T7.W,
; EG-NEXT:     BIT_ALIGN_INT T0.Z, T5.X, T1.Y, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT * T7.W, T7.X, T11.W, literal.x, BS:VEC_120/SCL_212
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     OR_INT * T8.W, T6.X, T4.X,
; EG-NEXT:     SETGE_UINT T4.X, PV.W, T2.Z,
; EG-NEXT:     SETE_INT T3.Y, T7.W, T4.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T1.Z, T7.W, T4.Z, BS:VEC_021/SCL_122
; EG-NEXT:     BFE_UINT T9.W, T2.X, literal.x, 1,
; EG-NEXT:     LSHL * T10.W, T1.Y, 1,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     OR_INT T5.X, PS, PV.W,
; EG-NEXT:     CNDE_INT T1.Y, PV.Y, PV.Z, PV.X,
; EG-NEXT:     SUB_INT T1.Z, T8.W, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SUBB_UINT T9.W, T8.W, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT * T10.W, T7.W, T4.Z,
; EG-NEXT:     SUB_INT T4.X, PS, PV.W,
; EG-NEXT:     CNDE_INT T3.Y, PV.Y, T8.W, PV.Z,
; EG-NEXT:     SETGE_UINT T1.Z, PV.X, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T8.W, T0.Z, T3.Z,
; EG-NEXT:     SETGE_UINT * T9.W, T0.Z, T3.Z,
; EG-NEXT:     CNDE_INT T6.X, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT T4.Y, T5.X, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     LSHL T1.Z, PV.Y, 1,
; EG-NEXT:     BFE_UINT T8.W, T3.X, literal.x, 1, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT * T7.W, T1.Y, T7.W, PV.X,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     BIT_ALIGN_INT T4.X, PS, T3.Y, literal.x,
; EG-NEXT:     OR_INT T1.Y, PV.Z, PV.W,
; EG-NEXT:     CNDE_INT T1.Z, PV.X, T5.X, PV.Y,
; EG-NEXT:     SUBB_UINT T7.W, T2.Y, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT * T8.W, T8.X, T1.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T7.X, PS, PV.W,
; EG-NEXT:     LSHL T3.Y, PV.Z, 1,
; EG-NEXT:     SETGE_UINT T5.Z, PV.Y, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T7.W, PV.X, T4.Z,
; EG-NEXT:     SETGE_UINT * T8.W, PV.X, T4.Z,
; EG-NEXT:     BFE_UINT T9.X, T2.X, literal.x, 1,
; EG-NEXT:     SETGE_UINT T4.Y, T2.Y, T0.W,
; EG-NEXT:     SETE_INT T6.Z, T8.X, T1.W, BS:VEC_120/SCL_212
; EG-NEXT:     CNDE_INT T7.W, PV.W, PS, PV.Z,
; EG-NEXT:     SUB_INT * T8.W, T1.Y, T2.Z,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T10.X, T1.Y, T2.Z,
; EG-NEXT:     SUB_INT T5.Y, T4.X, T4.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SUBB_UINT * T5.Z, T5.X, T4.W, BS:VEC_120/SCL_212
; EG-NEXT:     SUB_INT T9.W, T0.Z, T3.Z,
; EG-NEXT:     CNDE_INT * T8.W, T7.W, T1.Y, T8.W,
; EG-NEXT:     SETGE_UINT T5.X, T8.X, T1.W,
; EG-NEXT:     LSHL T1.Y, PS, 1,
; EG-NEXT:     BFE_UINT T7.Z, T3.X, 1, 1, BS:VEC_201
; EG-NEXT:     SUB_INT T9.W, PV.W, T5.Z,
; EG-NEXT:     SUB_INT * T10.W, T5.Y, T10.X,
; EG-NEXT:     CNDE_INT T4.X, T7.W, T4.X, PS,
; EG-NEXT:     CNDE_INT T5.Y, T6.X, T0.Z, PV.W,
; EG-NEXT:     OR_INT T0.Z, PV.Y, PV.Z,
; EG-NEXT:     CNDE_INT T7.W, T6.Z, PV.X, T4.Y, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT * T9.W, T2.Y, T0.W,
; EG-NEXT:     CNDE_INT T5.X, PV.W, T2.Y, PS,
; EG-NEXT:     SETGE_UINT T1.Y, PV.Z, T2.Z,
; EG-NEXT:     BIT_ALIGN_INT T1.Z, PV.Y, T1.Z, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T8.W, PV.X, T8.W, literal.x,
; EG-NEXT:     OR_INT * T9.W, T3.Y, T9.X,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT T4.X, PV.W, T4.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T2.Y, PV.W, T4.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T5.Z, PS, T4.W,
; EG-NEXT:     SETE_INT T10.W, PV.Z, T3.Z,
; EG-NEXT:     SETGE_UINT * T11.W, PV.Z, T3.Z,
; EG-NEXT:     CNDE_INT T6.X, PV.W, PS, PV.Z,
; EG-NEXT:     CNDE_INT T1.Y, PV.X, PV.Y, T1.Y,
; EG-NEXT:     LSHL T5.Z, T5.X, 1, BS:VEC_201
; EG-NEXT:     BFE_UINT T10.W, T0.Y, literal.x, 1,
; EG-NEXT:     CNDE_INT * T7.W, T7.W, T8.X, T7.X,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T4.X, T0.Z, T2.Z,
; EG-NEXT:     SUBB_UINT T2.Y, T0.Z, T2.Z,
; EG-NEXT:     SUB_INT T6.Z, T8.W, T4.Z, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T7.W, PS, T5.X, literal.x,
; EG-NEXT:     OR_INT * T10.W, PV.Z, PV.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T5.X, PS, T0.W,
; EG-NEXT:     SETE_INT T3.Y, PV.W, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T5.Z, PV.W, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T11.W, PV.Z, PV.Y,
; EG-NEXT:     CNDE_INT * T12.W, T1.Y, T0.Z, PV.X,
; EG-NEXT:     SUBB_UINT * T4.X, T10.W, T0.W,
; EG-NEXT:     SUB_INT T2.Y, T7.W, T1.W,
; EG-NEXT:     LSHL T0.Z, T12.W, 1, BS:VEC_201
; EG-NEXT:     AND_INT * T13.W, T3.X, 1,
; EG-NEXT:     CNDE_INT * T8.W, T1.Y, T8.W, T11.W,
; EG-NEXT:     SUB_INT T3.X, T10.W, T0.W,
; EG-NEXT:     BIT_ALIGN_INT * T1.Y, PV.W, T12.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     OR_INT T0.Z, T0.Z, T13.W,
; EG-NEXT:     SUB_INT T8.W, T2.Y, T4.X,
; EG-NEXT:     CNDE_INT * T11.W, T3.Y, T5.Z, T5.X,
; EG-NEXT:     SUB_INT T4.X, T9.W, T4.W,
; EG-NEXT:     CNDE_INT T2.Y, PS, T7.W, PV.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T5.Z, PV.Z, T2.Z,
; EG-NEXT:     SETE_INT * T7.W, T1.Y, T4.Z, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT * T8.W, T11.W, T10.W, T3.X,
; EG-NEXT:     SETGE_UINT T3.X, T1.Y, T4.Z,
; EG-NEXT:     SUBB_UINT T3.Y, T0.Z, T2.Z, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT * T4.Z, T1.Y, T4.Z,
; EG-NEXT:    ALU clause starting at 2098:
; EG-NEXT:     BFE_UINT T10.W, T0.Y, 1, 1,
; EG-NEXT:     LSHL * T11.W, T8.W, 1,
; EG-NEXT:     SUBB_UINT T5.X, T9.W, T4.W,
; EG-NEXT:     SUB_INT T4.Y, T1.Z, T3.Z,
; EG-NEXT:     OR_INT T6.Z, PS, PV.W,
; EG-NEXT:     SUB_INT * T10.W, T4.Z, T3.Y, BS:VEC_201
; EG-NEXT:     CNDE_INT * T7.W, T7.W, T3.X, T5.Z,
; EG-NEXT:     CNDE_INT T3.X, PV.W, T1.Y, T10.W,
; EG-NEXT:     SETGE_UINT T1.Y, T6.Z, T0.W,
; EG-NEXT:     SUB_INT T4.Z, T4.Y, T5.X,
; EG-NEXT:     BIT_ALIGN_INT * T8.W, T2.Y, T8.W, literal.x, BS:VEC_201
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT * T9.W, T6.X, T9.W, T4.X,
; EG-NEXT:     SETE_INT T4.X, T8.W, T1.W,
; EG-NEXT:     SETGE_UINT T2.Y, T8.W, T1.W,
; EG-NEXT:     LSHL T5.Z, PV.W, 1,
; EG-NEXT:     BFE_UINT T10.W, T2.X, 1, 1,
; EG-NEXT:     CNDE_INT * T11.W, T6.X, T1.Z, T4.Z,
; EG-NEXT:     BIT_ALIGN_INT T5.X, PS, T9.W, literal.x, BS:VEC_021/SCL_122
; EG-NEXT:     OR_INT T3.Y, PV.Z, PV.W,
; EG-NEXT:     CNDE_INT T1.Z, PV.X, PV.Y, T1.Y,
; EG-NEXT:     SUB_INT T9.W, T6.Z, T0.W, BS:VEC_102/SCL_221
; EG-NEXT:     XOR_INT * T10.W, T3.X, T5.W,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SUB_INT T3.X, PS, T5.W,
; EG-NEXT:     CNDE_INT T1.Y, PV.Z, T6.Z, PV.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT T4.Z, PV.Y, T4.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETE_INT T9.W, PV.X, T3.Z,
; EG-NEXT:     SETGE_UINT * T10.W, PV.X, T3.Z,
; EG-NEXT:     CNDE_INT T4.X, PV.W, PS, PV.Z,
; EG-NEXT:     LSHL T2.Y, PV.Y, 1,
; EG-NEXT:     AND_INT T4.Z, T0.Y, 1,
; EG-NEXT:     SUBB_UINT T9.W, T6.Z, T0.W, BS:VEC_102/SCL_221
; EG-NEXT:     SUB_INT * T10.W, T8.W, T1.W,
; EG-NEXT:     SUB_INT T6.X, T3.Y, T4.W,
; EG-NEXT:     SUB_INT T0.Y, PS, PV.W,
; EG-NEXT:     SUBB_UINT T5.Z, T3.Y, T4.W,
; EG-NEXT:     SUB_INT T9.W, T5.X, T3.Z,
; EG-NEXT:     OR_INT * T10.W, PV.Y, PV.Z,
; EG-NEXT:     SUB_INT T7.X, PS, T0.W,
; EG-NEXT:     SUB_INT T2.Y, PV.W, PV.Z,
; EG-NEXT:     CNDE_INT T1.Z, T1.Z, T8.W, PV.Y, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T8.W, T4.X, T3.Y, PV.X,
; EG-NEXT:     SUB_INT * T9.W, T0.Z, T2.Z,
; EG-NEXT:     CNDE_INT T6.X, T7.W, T0.Z, PS,
; EG-NEXT:     LSHL T0.Y, PV.W, 1,
; EG-NEXT:     AND_INT T0.Z, T2.X, 1,
; EG-NEXT:     BIT_ALIGN_INT T7.W, PV.Z, T1.Y, literal.x,
; EG-NEXT:     CNDE_INT * T9.W, T4.X, T5.X, PV.Y,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T2.X, T10.W, T0.W,
; EG-NEXT:     SETE_INT T1.Y, PV.W, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     SETGE_UINT * T1.Z, PV.W, T1.W, BS:VEC_021/SCL_122
; EG-NEXT:     BIT_ALIGN_INT T8.W, T9.W, T8.W, literal.x,
; EG-NEXT:     OR_INT * T9.W, T0.Y, T0.Z,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     SETGE_UINT T4.X, PS, T4.W,
; EG-NEXT:     SETE_INT T0.Y, PV.W, T3.Z,
; EG-NEXT:     SETGE_UINT T0.Z, PV.W, T3.Z,
; EG-NEXT:     SUBB_UINT T11.W, PS, T4.W,
; EG-NEXT:     SUB_INT * T12.W, PV.W, T3.Z,
; EG-NEXT:     SUBB_UINT * T5.X, T10.W, T0.W,
; EG-NEXT:     SUB_INT * T2.Y, T7.W, T1.W,
; EG-NEXT:     SUB_INT * T2.Z, T9.W, T4.W,
; EG-NEXT:     SUB_INT T0.W, T12.W, T11.W,
; EG-NEXT:     CNDE_INT * T1.W, T0.Y, T0.Z, T4.X,
; EG-NEXT:     CNDE_INT T4.X, PS, T8.W, PV.W, BS:VEC_021/SCL_122
; EG-NEXT:     CNDE_INT T0.Y, PS, T9.W, T2.Z, BS:VEC_102/SCL_221
; EG-NEXT:     SUB_INT T0.Z, T2.Y, T5.X,
; EG-NEXT:     CNDE_INT T0.W, T1.Y, T1.Z, T2.X, BS:VEC_210
; EG-NEXT:     XOR_INT * T1.W, T6.X, T5.W,
; EG-NEXT:     SUBB_UINT T2.X, PS, T5.W,
; EG-NEXT:     CNDE_INT T1.Y, PV.W, T7.W, PV.Z, BS:VEC_021/SCL_122
; EG-NEXT:     XOR_INT T0.Z, PV.Y, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     XOR_INT * T4.W, PV.X, T3.W, BS:VEC_102/SCL_221
; EG-NEXT:     CNDE_INT * T0.W, T0.W, T10.W, T7.X,
; EG-NEXT:     XOR_INT T4.X, PV.W, T6.W,
; EG-NEXT:     SUB_INT T0.Y, T4.W, T3.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUBB_UINT T1.Z, T0.Z, T3.W, BS:VEC_021/SCL_122
; EG-NEXT:     XOR_INT T0.W, T1.Y, T6.W,
; EG-NEXT:     SUB_INT * T7.W, T3.X, T2.X,
; EG-NEXT:     SUB_INT T2.X, PV.W, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT T7.Y, PV.Y, PV.Z,
; EG-NEXT:     SUBB_UINT T1.Z, PV.X, T6.W, BS:VEC_021/SCL_122
; EG-NEXT:     XOR_INT T0.W, T1.X, T2.W,
; EG-NEXT:     XOR_INT * T4.W, T0.X, T2.W,
; EG-NEXT:     SUB_INT T0.Y, PS, T2.W,
; EG-NEXT:     SUB_INT T7.Z, T1.W, T5.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUBB_UINT T1.W, PV.W, T2.W,
; EG-NEXT:     SUB_INT * T4.W, PV.X, PV.Z,
; EG-NEXT:     SUB_INT T7.X, T0.Z, T3.W,
; EG-NEXT:     SUB_INT T4.Y, PV.Y, PV.W,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T0.X, PV.W, literal.x,
; EG-NEXT:     SUB_INT T4.Z, T4.X, T6.W, BS:VEC_102/SCL_221
; EG-NEXT:     SUB_INT * T4.X, T0.W, T2.W,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %den_ptr = getelementptr <4 x i64>, ptr addrspace(1) %in, i64 1
  %num = load <4 x i64>, ptr addrspace(1) %in
  %den = load <4 x i64>, ptr addrspace(1) %den_ptr
  %result = srem <4 x i64> %num, %den
  store <4 x i64> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @srem_v4i64_4(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; GCN-LABEL: srem_v4i64_4:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v8, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    global_load_dwordx4 v[0:3], v8, s[2:3]
; GCN-NEXT:    global_load_dwordx4 v[4:7], v8, s[2:3] offset:16
; GCN-NEXT:    s_waitcnt vmcnt(1)
; GCN-NEXT:    v_ashrrev_i32_e32 v9, 31, v1
; GCN-NEXT:    v_lshrrev_b32_e32 v9, 30, v9
; GCN-NEXT:    v_ashrrev_i32_e32 v10, 31, v3
; GCN-NEXT:    v_add_co_u32_e32 v9, vcc, v0, v9
; GCN-NEXT:    v_lshrrev_b32_e32 v10, 30, v10
; GCN-NEXT:    v_addc_co_u32_e32 v13, vcc, 0, v1, vcc
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_ashrrev_i32_e32 v11, 31, v5
; GCN-NEXT:    v_add_co_u32_e32 v10, vcc, v2, v10
; GCN-NEXT:    v_lshrrev_b32_e32 v11, 30, v11
; GCN-NEXT:    v_addc_co_u32_e32 v14, vcc, 0, v3, vcc
; GCN-NEXT:    v_ashrrev_i32_e32 v12, 31, v7
; GCN-NEXT:    v_add_co_u32_e32 v11, vcc, v4, v11
; GCN-NEXT:    v_lshrrev_b32_e32 v12, 30, v12
; GCN-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v5, vcc
; GCN-NEXT:    v_add_co_u32_e32 v12, vcc, v6, v12
; GCN-NEXT:    v_addc_co_u32_e32 v16, vcc, 0, v7, vcc
; GCN-NEXT:    v_and_b32_e32 v9, -4, v9
; GCN-NEXT:    v_sub_co_u32_e32 v0, vcc, v0, v9
; GCN-NEXT:    v_and_b32_e32 v10, -4, v10
; GCN-NEXT:    v_subb_co_u32_e32 v1, vcc, v1, v13, vcc
; GCN-NEXT:    v_sub_co_u32_e32 v2, vcc, v2, v10
; GCN-NEXT:    v_and_b32_e32 v11, -4, v11
; GCN-NEXT:    v_subb_co_u32_e32 v3, vcc, v3, v14, vcc
; GCN-NEXT:    v_sub_co_u32_e32 v4, vcc, v4, v11
; GCN-NEXT:    v_and_b32_e32 v12, -4, v12
; GCN-NEXT:    v_subb_co_u32_e32 v5, vcc, v5, v15, vcc
; GCN-NEXT:    v_sub_co_u32_e32 v6, vcc, v6, v12
; GCN-NEXT:    v_subb_co_u32_e32 v7, vcc, v7, v16, vcc
; GCN-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1] offset:16
; GCN-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1]
; GCN-NEXT:    s_endpgm
;
; TAHITI-LABEL: srem_v4i64_4:
; TAHITI:       ; %bb.0:
; TAHITI-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x9
; TAHITI-NEXT:    s_mov_b32 s3, 0xf000
; TAHITI-NEXT:    s_mov_b32 s2, -1
; TAHITI-NEXT:    s_mov_b32 s10, s2
; TAHITI-NEXT:    s_mov_b32 s11, s3
; TAHITI-NEXT:    s_waitcnt lgkmcnt(0)
; TAHITI-NEXT:    s_mov_b32 s8, s6
; TAHITI-NEXT:    s_mov_b32 s9, s7
; TAHITI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; TAHITI-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; TAHITI-NEXT:    s_mov_b32 s0, s4
; TAHITI-NEXT:    s_mov_b32 s1, s5
; TAHITI-NEXT:    s_waitcnt vmcnt(1)
; TAHITI-NEXT:    v_ashrrev_i32_e32 v8, 31, v1
; TAHITI-NEXT:    v_lshrrev_b32_e32 v8, 30, v8
; TAHITI-NEXT:    v_ashrrev_i32_e32 v9, 31, v3
; TAHITI-NEXT:    v_add_i32_e32 v8, vcc, v0, v8
; TAHITI-NEXT:    v_lshrrev_b32_e32 v9, 30, v9
; TAHITI-NEXT:    v_addc_u32_e32 v12, vcc, 0, v1, vcc
; TAHITI-NEXT:    s_waitcnt vmcnt(0)
; TAHITI-NEXT:    v_ashrrev_i32_e32 v10, 31, v5
; TAHITI-NEXT:    v_add_i32_e32 v9, vcc, v2, v9
; TAHITI-NEXT:    v_lshrrev_b32_e32 v10, 30, v10
; TAHITI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v3, vcc
; TAHITI-NEXT:    v_ashrrev_i32_e32 v11, 31, v7
; TAHITI-NEXT:    v_add_i32_e32 v10, vcc, v4, v10
; TAHITI-NEXT:    v_lshrrev_b32_e32 v11, 30, v11
; TAHITI-NEXT:    v_addc_u32_e32 v14, vcc, 0, v5, vcc
; TAHITI-NEXT:    v_add_i32_e32 v11, vcc, v6, v11
; TAHITI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v7, vcc
; TAHITI-NEXT:    v_and_b32_e32 v8, -4, v8
; TAHITI-NEXT:    v_sub_i32_e32 v0, vcc, v0, v8
; TAHITI-NEXT:    v_and_b32_e32 v9, -4, v9
; TAHITI-NEXT:    v_subb_u32_e32 v1, vcc, v1, v12, vcc
; TAHITI-NEXT:    v_sub_i32_e32 v2, vcc, v2, v9
; TAHITI-NEXT:    v_and_b32_e32 v10, -4, v10
; TAHITI-NEXT:    v_subb_u32_e32 v3, vcc, v3, v13, vcc
; TAHITI-NEXT:    v_sub_i32_e32 v4, vcc, v4, v10
; TAHITI-NEXT:    v_and_b32_e32 v11, -4, v11
; TAHITI-NEXT:    v_subb_u32_e32 v5, vcc, v5, v14, vcc
; TAHITI-NEXT:    v_sub_i32_e32 v6, vcc, v6, v11
; TAHITI-NEXT:    v_subb_u32_e32 v7, vcc, v7, v15, vcc
; TAHITI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; TAHITI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; TAHITI-NEXT:    s_endpgm
;
; TONGA-LABEL: srem_v4i64_4:
; TONGA:       ; %bb.0:
; TONGA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; TONGA-NEXT:    s_waitcnt lgkmcnt(0)
; TONGA-NEXT:    v_mov_b32_e32 v0, s2
; TONGA-NEXT:    v_mov_b32_e32 v1, s3
; TONGA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; TONGA-NEXT:    s_add_u32 s4, s2, 16
; TONGA-NEXT:    s_addc_u32 s5, s3, 0
; TONGA-NEXT:    v_mov_b32_e32 v4, s4
; TONGA-NEXT:    v_mov_b32_e32 v5, s5
; TONGA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; TONGA-NEXT:    v_mov_b32_e32 v9, s1
; TONGA-NEXT:    v_mov_b32_e32 v8, s0
; TONGA-NEXT:    s_add_u32 s0, s0, 16
; TONGA-NEXT:    s_addc_u32 s1, s1, 0
; TONGA-NEXT:    v_mov_b32_e32 v11, s1
; TONGA-NEXT:    v_mov_b32_e32 v10, s0
; TONGA-NEXT:    s_waitcnt vmcnt(1)
; TONGA-NEXT:    v_ashrrev_i32_e32 v12, 31, v1
; TONGA-NEXT:    v_lshrrev_b32_e32 v12, 30, v12
; TONGA-NEXT:    v_add_u32_e32 v12, vcc, v0, v12
; TONGA-NEXT:    v_addc_u32_e32 v16, vcc, 0, v1, vcc
; TONGA-NEXT:    v_and_b32_e32 v12, -4, v12
; TONGA-NEXT:    v_ashrrev_i32_e32 v13, 31, v3
; TONGA-NEXT:    v_sub_u32_e32 v0, vcc, v0, v12
; TONGA-NEXT:    v_lshrrev_b32_e32 v13, 30, v13
; TONGA-NEXT:    v_subb_u32_e32 v1, vcc, v1, v16, vcc
; TONGA-NEXT:    v_add_u32_e32 v12, vcc, v2, v13
; TONGA-NEXT:    v_addc_u32_e32 v13, vcc, 0, v3, vcc
; TONGA-NEXT:    v_and_b32_e32 v12, -4, v12
; TONGA-NEXT:    s_waitcnt vmcnt(0)
; TONGA-NEXT:    v_ashrrev_i32_e32 v14, 31, v5
; TONGA-NEXT:    v_ashrrev_i32_e32 v15, 31, v7
; TONGA-NEXT:    v_sub_u32_e32 v2, vcc, v2, v12
; TONGA-NEXT:    v_lshrrev_b32_e32 v14, 30, v14
; TONGA-NEXT:    v_lshrrev_b32_e32 v15, 30, v15
; TONGA-NEXT:    v_subb_u32_e32 v3, vcc, v3, v13, vcc
; TONGA-NEXT:    v_add_u32_e64 v12, s[0:1], v4, v14
; TONGA-NEXT:    v_add_u32_e32 v13, vcc, v6, v15
; TONGA-NEXT:    v_addc_u32_e32 v15, vcc, 0, v7, vcc
; TONGA-NEXT:    v_and_b32_e32 v12, -4, v12
; TONGA-NEXT:    v_addc_u32_e64 v14, s[0:1], 0, v5, s[0:1]
; TONGA-NEXT:    v_sub_u32_e32 v4, vcc, v4, v12
; TONGA-NEXT:    v_and_b32_e32 v13, -4, v13
; TONGA-NEXT:    v_subb_u32_e32 v5, vcc, v5, v14, vcc
; TONGA-NEXT:    v_sub_u32_e32 v6, vcc, v6, v13
; TONGA-NEXT:    v_subb_u32_e32 v7, vcc, v7, v15, vcc
; TONGA-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; TONGA-NEXT:    flat_store_dwordx4 v[10:11], v[4:7]
; TONGA-NEXT:    s_endpgm
;
; EG-LABEL: srem_v4i64_4:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 48, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T3.XYZW, T0.X, 0
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T4.XYZW, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T0.X, 16, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     ASHR * T1.W, T1.W, literal.x,
; EG-NEXT:    31(4.344025e-44), 0(0.000000e+00)
; EG-NEXT:     ASHR T2.Z, T0.Y, literal.x,
; EG-NEXT:     ASHR T2.W, T1.Y, literal.x, BS:VEC_120/SCL_212
; EG-NEXT:     LSHR * T1.W, PV.W, literal.y,
; EG-NEXT:    31(4.344025e-44), 30(4.203895e-44)
; EG-NEXT:     ADD_INT T0.Y, T1.Z, PS,
; EG-NEXT:     ASHR T3.Z, T0.W, literal.x,
; EG-NEXT:     LSHR T0.W, PV.W, literal.y,
; EG-NEXT:     LSHR * T2.W, PV.Z, literal.y,
; EG-NEXT:    31(4.344025e-44), 30(4.203895e-44)
; EG-NEXT:     ADD_INT T2.X, T0.X, PS,
; EG-NEXT:     ADD_INT T1.Y, T1.X, PV.W, BS:VEC_120/SCL_212
; EG-NEXT:     LSHR T2.Z, PV.Z, literal.x,
; EG-NEXT:     ADDC_UINT T1.W, T1.Z, T1.W,
; EG-NEXT:     AND_INT * T3.W, PV.Y, literal.y,
; EG-NEXT:    30(4.203895e-44), -4(nan)
; EG-NEXT:     SUBB_UINT T3.X, T1.Z, PS,
; EG-NEXT:     BFE_INT T0.Y, PV.W, 0.0, 1,
; EG-NEXT:     ADD_INT T3.Z, T0.Z, PV.Z, BS:VEC_120/SCL_212
; EG-NEXT:     ADDC_UINT T0.W, T1.X, T0.W,
; EG-NEXT:     AND_INT * T1.W, PV.Y, literal.x,
; EG-NEXT:    -4(nan), 0(0.000000e+00)
; EG-NEXT:     ADDC_UINT T4.X, T0.Z, T2.Z,
; EG-NEXT:     SUBB_UINT T1.Y, T1.X, PS,
; EG-NEXT:     BFE_INT T2.Z, PV.W, 0.0, 1,
; EG-NEXT:     AND_INT T0.W, PV.Z, literal.x,
; EG-NEXT:     SUB_INT * T4.W, PV.Y, PV.X,
; EG-NEXT:    -4(nan), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T3.X, T0.Z, PV.W,
; EG-NEXT:     SUB_INT T4.Y, PV.Z, PV.Y,
; EG-NEXT:     BFE_INT T2.Z, PV.X, 0.0, 1,
; EG-NEXT:     ADDC_UINT T2.W, T0.X, T2.W,
; EG-NEXT:     AND_INT * T5.W, T2.X, literal.x,
; EG-NEXT:    -4(nan), 0(0.000000e+00)
; EG-NEXT:     SUBB_UINT T0.Y, T0.X, PS,
; EG-NEXT:     SUB_INT T4.Z, T1.Z, T3.W,
; EG-NEXT:     BFE_INT T2.W, PV.W, 0.0, 1,
; EG-NEXT:     SUB_INT * T3.W, PV.Z, PV.X,
; EG-NEXT:     SUB_INT T4.X, T1.X, T1.W,
; EG-NEXT:     SUB_INT T3.Y, PV.W, PV.Y,
; EG-NEXT:     ADD_INT * T1.W, KC0[2].Y, literal.x,
; EG-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; EG-NEXT:     LSHR T1.X, PV.W, literal.x,
; EG-NEXT:     SUB_INT T3.Z, T0.Z, T0.W, BS:VEC_021/SCL_122
; EG-NEXT:     SUB_INT * T3.X, T0.X, T5.W,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     LSHR * T0.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %num = load <4 x i64>, ptr addrspace(1) %in
  %result = srem <4 x i64> %num, <i64 4, i64 4, i64 4, i64 4>
  store <4 x i64> %result, ptr addrspace(1) %out
  ret void
}
