; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals smart
; RUN: opt -passes=instcombine -S < %s | FileCheck %s

target datalayout = "e-m:e-p:64:64:64-i64:64-f80:128-n8:16:32:64-S128"

define i32 @test_load_cast_combine_tbaa(ptr %ptr) {
; Ensure (cast (load (...))) -> (load (cast (...))) preserves TBAA.
; CHECK-LABEL: @test_load_cast_combine_tbaa(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L1:%.*]] = load i32, ptr [[PTR:%.*]], align 4, !tbaa [[TBAA0:![0-9]+]]
; CHECK-NEXT:    ret i32 [[L1]]
;
entry:
  %l = load float, ptr %ptr, !tbaa !0
  %c = bitcast float %l to i32
  ret i32 %c
}

define i32 @test_load_cast_combine_noalias(ptr %ptr) {
; Ensure (cast (load (...))) -> (load (cast (...))) preserves no-alias metadata.
; CHECK-LABEL: @test_load_cast_combine_noalias(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L1:%.*]] = load i32, ptr [[PTR:%.*]], align 4, !alias.scope [[META3:![0-9]+]], !noalias [[META3]]
; CHECK-NEXT:    ret i32 [[L1]]
;
entry:
  %l = load float, ptr %ptr, !alias.scope !3, !noalias !3
  %c = bitcast float %l to i32
  ret i32 %c
}

define float @test_load_cast_combine_range(ptr %ptr) {
; Ensure (cast (load (...))) -> (load (cast (...))) drops range metadata. It
; would be nice to preserve or update it somehow but this is hard when moving
; between types.
; CHECK-LABEL: @test_load_cast_combine_range(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L1:%.*]] = load float, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    ret float [[L1]]
;
entry:
  %l = load i32, ptr %ptr, !range !6
  %c = bitcast i32 %l to float
  ret float %c
}

define i32 @test_load_cast_combine_invariant(ptr %ptr) {
; Ensure (cast (load (...))) -> (load (cast (...))) preserves invariant metadata.
; CHECK-LABEL: @test_load_cast_combine_invariant(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L1:%.*]] = load i32, ptr [[PTR:%.*]], align 4, !invariant.load [[META6:![0-9]+]]
; CHECK-NEXT:    ret i32 [[L1]]
;
entry:
  %l = load float, ptr %ptr, !invariant.load !7
  %c = bitcast float %l to i32
  ret i32 %c
}

define i32 @test_load_cast_combine_nontemporal(ptr %ptr) {
; Ensure (cast (load (...))) -> (load (cast (...))) preserves nontemporal
; metadata.
; CHECK-LABEL: @test_load_cast_combine_nontemporal(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L1:%.*]] = load i32, ptr [[PTR:%.*]], align 4, !nontemporal [[META7:![0-9]+]]
; CHECK-NEXT:    ret i32 [[L1]]
;
entry:
  %l = load float, ptr %ptr, !nontemporal !8
  %c = bitcast float %l to i32
  ret i32 %c
}

define ptr @test_load_cast_combine_align(ptr %ptr) {
; Ensure (cast (load (...))) -> (load (cast (...))) preserves align
; metadata.
; CHECK-LABEL: @test_load_cast_combine_align(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L:%.*]] = load ptr, ptr [[PTR:%.*]], align 8, !align [[META8:![0-9]+]]
; CHECK-NEXT:    ret ptr [[L]]
;
entry:
  %l = load ptr, ptr %ptr, !align !9
  ret ptr %l
}

define ptr @test_load_cast_combine_deref(ptr %ptr) {
; Ensure (cast (load (...))) -> (load (cast (...))) preserves dereferenceable
; metadata.
; CHECK-LABEL: @test_load_cast_combine_deref(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L:%.*]] = load ptr, ptr [[PTR:%.*]], align 8, !dereferenceable [[META8]]
; CHECK-NEXT:    ret ptr [[L]]
;
entry:
  %l = load ptr, ptr %ptr, !dereferenceable !9
  ret ptr %l
}

define ptr @test_load_cast_combine_deref_or_null(ptr %ptr) {
; Ensure (cast (load (...))) -> (load (cast (...))) preserves
; dereferenceable_or_null metadata.
; CHECK-LABEL: @test_load_cast_combine_deref_or_null(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L:%.*]] = load ptr, ptr [[PTR:%.*]], align 8, !dereferenceable_or_null [[META8]]
; CHECK-NEXT:    ret ptr [[L]]
;
entry:
  %l = load ptr, ptr %ptr, !dereferenceable_or_null !9
  ret ptr %l
}

define void @test_load_cast_combine_loop(ptr %src, ptr %dst, i32 %n) {
; Ensure (cast (load (...))) -> (load (cast (...))) preserves loop access
; metadata.
; CHECK-LABEL: @test_load_cast_combine_loop(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[I:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[I_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[TMP0:%.*]] = sext i32 [[I]] to i64
; CHECK-NEXT:    [[SRC_GEP:%.*]] = getelementptr inbounds float, ptr [[SRC:%.*]], i64 [[TMP0]]
; CHECK-NEXT:    [[TMP1:%.*]] = sext i32 [[I]] to i64
; CHECK-NEXT:    [[DST_GEP:%.*]] = getelementptr inbounds i32, ptr [[DST:%.*]], i64 [[TMP1]]
; CHECK-NEXT:    [[L1:%.*]] = load i32, ptr [[SRC_GEP]], align 4, !llvm.access.group [[ACC_GRP9:![0-9]+]]
; CHECK-NEXT:    store i32 [[L1]], ptr [[DST_GEP]], align 4
; CHECK-NEXT:    [[I_NEXT]] = add i32 [[I]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[I_NEXT]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[LOOP]], label [[EXIT:%.*]], !llvm.loop [[LOOP1:![0-9]+]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %i = phi i32 [ 0, %entry ], [ %i.next, %loop ]
  %src.gep = getelementptr inbounds float, ptr %src, i32 %i
  %dst.gep = getelementptr inbounds i32, ptr %dst, i32 %i
  %l = load float, ptr %src.gep, !llvm.access.group !10
  %c = bitcast float %l to i32
  store i32 %c, ptr %dst.gep
  %i.next = add i32 %i, 1
  %cmp = icmp slt i32 %i.next, %n
  br i1 %cmp, label %loop, label %exit, !llvm.loop !1

exit:
  ret void
}

define void @test_load_cast_combine_nonnull(ptr %ptr) {
; CHECK-LABEL: @test_load_cast_combine_nonnull(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[P:%.*]] = load ptr, ptr [[PTR:%.*]], align 8, !nonnull [[META6]]
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr i8, ptr [[PTR]], i64 336
; CHECK-NEXT:    store ptr [[P]], ptr [[GEP]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %p = load ptr, ptr %ptr, !nonnull !{}
  %gep = getelementptr ptr, ptr %ptr, i32 42
  store ptr %p, ptr %gep
  ret void
}

define i32 @test_load_cast_combine_noundef(ptr %ptr) {
; CHECK-LABEL: @test_load_cast_combine_noundef(
; CHECK-NEXT:    [[L1:%.*]] = load i32, ptr [[PTR:%.*]], align 4, !noundef [[META6]]
; CHECK-NEXT:    ret i32 [[L1]]
;
  %l = load float, ptr %ptr, !noundef !{}
  %c = bitcast float %l to i32
  ret i32 %c
}

define i32 @test_load_cast_combine_noalias_addrspace(ptr %ptr) {
; Ensure (cast (load (...))) -> (load (cast (...))) preserves TBAA.
; CHECK-LABEL: @test_load_cast_combine_noalias_addrspace(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L1:%.*]] = load i32, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    ret i32 [[L1]]
;
entry:
  %l = load float, ptr %ptr, align 4, !noalias.addrspace !11
  %c = bitcast float %l to i32
  ret i32 %c
}

; Preserve none-UB metadata on loads.
define ptr @preserve_load_metadata_after_select_transform1(i1 %c, ptr dereferenceable(8) %a, ptr dereferenceable(8) %b) {
; CHECK-LABEL: @preserve_load_metadata_after_select_transform1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B_VAL:%.*]] = load ptr, ptr [[B:%.*]], align 1, !nonnull [[META6]], !align [[META8]]
; CHECK-NEXT:    [[A_VAL:%.*]] = load ptr, ptr [[A:%.*]], align 1, !nonnull [[META6]], !align [[META8]]
; CHECK-NEXT:    [[L_SEL:%.*]] = select i1 [[C:%.*]], ptr [[B_VAL]], ptr [[A_VAL]]
; CHECK-NEXT:    ret ptr [[L_SEL]]
;
entry:
  %ptr.sel = select i1 %c, ptr %b, ptr %a
  %l.sel = load ptr, ptr %ptr.sel, align 1, !tbaa !0, !llvm.access.group !7, !dereferenceable !9, !noundef !{}, !invariant.load !7, !align !9, !nonnull !{}
  ret ptr %l.sel
}

; Preserve none-UB metadata on loads.
define i32 @preserve_load_metadata_after_select_transform_range(i1 %c, ptr dereferenceable(8) %a, ptr dereferenceable(8) %b) {
; CHECK-LABEL: @preserve_load_metadata_after_select_transform_range(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B_VAL:%.*]] = load i32, ptr [[B:%.*]], align 1, !range [[RNG10:![0-9]+]]
; CHECK-NEXT:    [[A_VAL:%.*]] = load i32, ptr [[A:%.*]], align 1, !range [[RNG10]]
; CHECK-NEXT:    [[L_SEL:%.*]] = select i1 [[C:%.*]], i32 [[B_VAL]], i32 [[A_VAL]]
; CHECK-NEXT:    ret i32 [[L_SEL]]
;
entry:
  %ptr.sel = select i1 %c, ptr %b, ptr %a
  %l.sel = load i32, ptr %ptr.sel, align 1, !tbaa !0, !llvm.access.group !7, !invariant.load !7, !noundef !{}, !range !6
  ret i32 %l.sel
}

define double @preserve_load_metadata_after_select_transform2(ptr %a, ptr %b) {
; CHECK-LABEL: @preserve_load_metadata_after_select_transform2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L_A:%.*]] = load double, ptr [[A:%.*]], align 8, !tbaa [[TBAA0]], !llvm.access.group [[META6]]
; CHECK-NEXT:    [[L_B:%.*]] = load double, ptr [[B:%.*]], align 8, !tbaa [[TBAA0]], !llvm.access.group [[META6]]
; CHECK-NEXT:    [[CMP_I:%.*]] = fcmp fast olt double [[L_A]], [[L_B]]
; CHECK-NEXT:    [[L_SEL:%.*]] = select i1 [[CMP_I]], double [[L_B]], double [[L_A]]
; CHECK-NEXT:    ret double [[L_SEL]]
;
entry:
  %l.a = load double, ptr %a, align 8, !tbaa !0, !llvm.access.group !7
  %l.b = load double, ptr %b, align 8, !tbaa !0, !llvm.access.group !7
  %cmp.i = fcmp fast olt double %l.a, %l.b
  %ptr.sel = select i1 %cmp.i, ptr %b, ptr %a
  %l.sel = load double, ptr %ptr.sel, align 8, !tbaa !0, !llvm.access.group !7
  ret double %l.sel
}

define double @preserve_load_metadata_after_select_transform_metadata_missing_1(ptr %a, ptr %b) {
; CHECK-LABEL: @preserve_load_metadata_after_select_transform_metadata_missing_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L_A:%.*]] = load double, ptr [[A:%.*]], align 8, !llvm.access.group [[META6]]
; CHECK-NEXT:    [[L_B:%.*]] = load double, ptr [[B:%.*]], align 8, !tbaa [[TBAA0]], !llvm.access.group [[META6]]
; CHECK-NEXT:    [[CMP_I:%.*]] = fcmp fast olt double [[L_A]], [[L_B]]
; CHECK-NEXT:    [[L_SEL:%.*]] = select i1 [[CMP_I]], double [[L_B]], double [[L_A]]
; CHECK-NEXT:    ret double [[L_SEL]]
;
entry:
  %l.a = load double, ptr %a, align 8, !llvm.access.group !7
  %l.b = load double, ptr %b, align 8, !tbaa !0, !llvm.access.group !7
  %cmp.i = fcmp fast olt double %l.a, %l.b
  %ptr.sel = select i1 %cmp.i, ptr %b, ptr %a
  %l.sel = load double, ptr %ptr.sel, align 8, !tbaa !0, !llvm.access.group !7
  ret double %l.sel
}

define double @preserve_load_metadata_after_select_transform_metadata_missing_2(ptr %a, ptr %b) {
; CHECK-LABEL: @preserve_load_metadata_after_select_transform_metadata_missing_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L_A:%.*]] = load double, ptr [[A:%.*]], align 8, !llvm.access.group [[META6]]
; CHECK-NEXT:    [[L_B:%.*]] = load double, ptr [[B:%.*]], align 8, !llvm.access.group [[META6]]
; CHECK-NEXT:    [[CMP_I:%.*]] = fcmp fast olt double [[L_A]], [[L_B]]
; CHECK-NEXT:    [[L_SEL:%.*]] = select i1 [[CMP_I]], double [[L_B]], double [[L_A]]
; CHECK-NEXT:    ret double [[L_SEL]]
;
entry:
  %l.a = load double, ptr %a, align 8, !llvm.access.group !7
  %l.b = load double, ptr %b, align 8, !llvm.access.group !7
  %cmp.i = fcmp fast olt double %l.a, %l.b
  %ptr.sel = select i1 %cmp.i, ptr %b, ptr %a
  %l.sel = load double, ptr %ptr.sel, align 8, !tbaa !0, !llvm.access.group !12
  ret double %l.sel
}

define double @preserve_load_metadata_after_select_transform_metadata_missing_3(ptr %a, ptr %b) {
; CHECK-LABEL: @preserve_load_metadata_after_select_transform_metadata_missing_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L_A:%.*]] = load double, ptr [[A:%.*]], align 8, !tbaa [[TBAA0]], !llvm.access.group [[META6]]
; CHECK-NEXT:    [[L_B:%.*]] = load double, ptr [[B:%.*]], align 8, !tbaa [[TBAA0]], !llvm.access.group [[META6]]
; CHECK-NEXT:    [[CMP_I:%.*]] = fcmp fast olt double [[L_A]], [[L_B]]
; CHECK-NEXT:    [[L_SEL:%.*]] = select i1 [[CMP_I]], double [[L_B]], double [[L_A]]
; CHECK-NEXT:    ret double [[L_SEL]]
;
entry:
  %l.a = load double, ptr %a, align 8, !tbaa !0, !llvm.access.group !7
  %l.b = load double, ptr %b, align 8, !tbaa !0, !llvm.access.group !7
  %cmp.i = fcmp fast olt double %l.a, %l.b
  %ptr.sel = select i1 %cmp.i, ptr %b, ptr %a
  %l.sel = load double, ptr %ptr.sel, align 8, !tbaa !0, !llvm.access.group !13
  ret double %l.sel
}

; Like preserve_load_metadata_after_select_transform_metadata_missing_3, but
; with different access groups on all loads.
define double @preserve_load_metadata_after_select_transform_metadata_missing_4(ptr %a, ptr %b) {
; CHECK-LABEL: @preserve_load_metadata_after_select_transform_metadata_missing_4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L_A:%.*]] = load double, ptr [[A:%.*]], align 8, !tbaa [[TBAA0]], !alias.scope [[META3]], !noalias [[META3]], !llvm.access.group [[META6]]
; CHECK-NEXT:    [[L_B:%.*]] = load double, ptr [[B:%.*]], align 8, !tbaa [[TBAA0]], !alias.scope [[META11:![0-9]+]], !noalias [[META11]], !llvm.access.group [[ACC_GRP14:![0-9]+]]
; CHECK-NEXT:    [[CMP_I:%.*]] = fcmp fast olt double [[L_A]], [[L_B]]
; CHECK-NEXT:    [[L_SEL:%.*]] = select i1 [[CMP_I]], double [[L_B]], double [[L_A]]
; CHECK-NEXT:    ret double [[L_SEL]]
;
entry:
  %l.a = load double, ptr %a, align 8, !tbaa !0, !llvm.access.group !7, !alias.scope !3, !noalias !3
  %l.b = load double, ptr %b, align 8, !tbaa !0, !llvm.access.group !12, !alias.scope !14, !noalias !14
  %cmp.i = fcmp fast olt double %l.a, %l.b
  %ptr.sel = select i1 %cmp.i, ptr %b, ptr %a
  %l.sel = load double, ptr %ptr.sel, align 8, !tbaa !0, !llvm.access.group !13
  ret double %l.sel
}

!0 = !{!1, !1, i64 0}
!1 = !{!"scalar type", !2}
!2 = !{!"root"}
!3 = !{!4}
!4 = distinct !{!4, !5}
!5 = distinct !{!5}
!6 = !{i32 0, i32 42}
!7 = !{}
!8 = !{i32 1}
!9 = !{i64 8}
!10 = distinct !{}
!11 = !{i32 5, i32 6}
!12 = distinct !{}
!13 = distinct !{}
!14 = !{!15}
!15 = distinct !{!15, !16}
!16 = distinct !{!16}

;.
; CHECK: [[TBAA0]] = !{[[LOOP1]], [[LOOP1]], i64 0}
; CHECK: [[LOOP1]] = !{!"scalar type", [[META2:![0-9]+]]}
; CHECK: [[META2]] = !{!"root"}
; CHECK: [[META3]] = !{[[META4:![0-9]+]]}
; CHECK: [[META4]] = distinct !{[[META4]], [[META5:![0-9]+]]}
; CHECK: [[META5]] = distinct !{[[META5]]}
; CHECK: [[META6]] = !{}
; CHECK: [[META7]] = !{i32 1}
; CHECK: [[META8]] = !{i64 8}
; CHECK: [[ACC_GRP9]] = distinct !{}
; CHECK: [[RNG10]] = !{i32 0, i32 42}
; CHECK: [[META11]] = !{[[META12:![0-9]+]]}
; CHECK: [[META12]] = distinct !{[[META12]], [[META13:![0-9]+]]}
; CHECK: [[META13]] = distinct !{[[META13]]}
; CHECK: [[ACC_GRP14]] = distinct !{}
;.
