; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=aarch64-linux -mattr=+neon,+fp8dot2,+fp8dot4 < %s | FileCheck %s

define <4 x half> @test_fdot_f16(<4 x half> %vd, <8 x i8> %vn, <8 x i8> %vm) {
; CHECK-LABEL: test_fdot_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fdot v0.4h, v1.8b, v2.8b
; CHECK-NEXT:    ret
  %res = call <4 x half> @llvm.aarch64.neon.fp8.fdot2.v4f16.v8i8(<4 x half> %vd, <8 x i8> %vn, <8 x i8> %vm)
  ret <4 x half> %res
}

define <8 x half> @test_fdotq_f16(<8 x half> %vd, <16 x i8> %vn, <16 x i8> %vm) {
; CHECK-LABEL: test_fdotq_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fdot v0.8h, v1.16b, v2.16b
; CHECK-NEXT:    ret
  %res = call <8 x half> @llvm.aarch64.neon.fp8.fdot2.v8f16.v16i8(<8 x half> %vd, <16 x i8> %vn, <16 x i8> %vm)
  ret <8 x half> %res
}

define <4 x half> @test_fdot_lane_f16(<4 x half> %vd, <8 x i8> %vn, <16 x i8> %vm) {
; CHECK-LABEL: test_fdot_lane_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fdot v0.4h, v1.8b, v2.2b[0]
; CHECK-NEXT:    ret
  %res = call <4 x half> @llvm.aarch64.neon.fp8.fdot2.lane.v4f16.v8i8(<4 x half> %vd, <8 x i8> %vn, <16 x i8> %vm, i32 0)
  ret <4 x half> %res
}

define <8 x half> @test_fdotq_lane_f16(<8 x half> %vd, <16 x i8> %vn, <16 x i8> %vm) {
; CHECK-LABEL: test_fdotq_lane_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fdot v0.8h, v1.16b, v2.2b[7]
; CHECK-NEXT:    ret
  %res = call <8 x half> @llvm.aarch64.neon.fp8.fdot2.lane.v8f16.v16i8(<8 x half> %vd, <16 x i8> %vn, <16 x i8> %vm, i32 7)
  ret <8 x half> %res
}

define <2 x float> @test_fdot_f32(<2 x float> %vd, <8 x i8> %vn, <8 x i8> %vm) {
; CHECK-LABEL: test_fdot_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fdot v0.2s, v1.8b, v2.8b
; CHECK-NEXT:    ret
  %res = call <2 x float> @llvm.aarch64.neon.fp8.fdot4.v2f32.v8i8(<2 x float> %vd, <8 x i8> %vn, <8 x i8> %vm)
  ret <2 x float> %res
}

define <4 x float> @test_fdotq_f32(<4 x float> %vd, <16 x i8> %vn, <16 x i8> %vm) {
; CHECK-LABEL: test_fdotq_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fdot v0.4s, v1.16b, v2.16b
; CHECK-NEXT:    ret
  %res = call <4 x float> @llvm.aarch64.neon.fp8.fdot4.v4f32.v16i8(<4 x float> %vd, <16 x i8> %vn, <16 x i8> %vm)
  ret <4 x float> %res
}

define <2 x float> @test_fdot_lane_f32(<2 x float> %vd, <8 x i8> %vn, <16 x i8> %vm) {
; CHECK-LABEL: test_fdot_lane_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fdot v0.2s, v1.8b, v2.4b[0]
; CHECK-NEXT:    ret
  %res = call <2 x float> @llvm.aarch64.neon.fp8.fdot4.lane.v2f32.v8i8(<2 x float> %vd, <8 x i8> %vn, <16 x i8> %vm, i32 0)
  ret <2 x float> %res
}

define <4 x float> @test_fdotq_lane_f32(<4 x float> %vd, <16 x i8> %vn, <16 x i8> %vm) {
; CHECK-LABEL: test_fdotq_lane_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fdot v0.4s, v1.16b, v2.4b[3]
; CHECK-NEXT:    ret
  %res = call <4 x float> @llvm.aarch64.neon.fp8.fdot4.lane.v4f32.v16i8(<4 x float> %vd, <16 x i8> %vn, <16 x i8> %vm, i32 3)
  ret <4 x float> %res
}
