; RUN: llc < %s -mtriple=i686-unknown-linux-gnu -mattr=+sse2 | FileCheck %s --check-prefixes=A,B
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu | FileCheck %s --allow-unused-prefixes=true --check-prefixes=C,A,UNUSED
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu | FileCheck %s --allow-unused-prefixes=true --check-prefixe=A

declare <2 x i64> @llvm.bswap.v2i64(<2 x i64>)

define <2 x i64> @fold_v2i64() {
; B-LABEL: fold_v2i64:
; B:       # %bb.0: # %entry
; B-NEXT:    movaps {{.*#+}} xmm0 = [0,4278190080,4294967295,4294967295]
; B-NEXT:    retl
;
; C-LABEL: fold_v2i64:
; C:       # %bb.0: # %entry
; C-NEXT:    movaps {{.*#+}} xmm0 = [18374686479671623680,18446744073709551615]
; C-NEXT:    retq
entry:
  %r = call <2 x i64> @llvm.bswap.v2i64(<2 x i64> <i64 255, i64 -1>)
  ret <2 x i64> %r
}

declare <4 x i32> @llvm.bswap.v4i32(<4 x i32>)

define <4 x i32> @test2(<4 x i32> %v) {
  %r = call <4 x i32> @llvm.bswap.v4i32(<4 x i32> %v)
  ret <4 x i32> %r
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; A: {{.*}}
; UNUSED: {{.*}}
