; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=instsimplify -S < %s | FileCheck %s

define i1 @sdiv_neg_neg_high_bits(i8 %x, i8 %y) {
; CHECK-LABEL: @sdiv_neg_neg_high_bits(
; CHECK-NEXT:    ret i1 false
;
  %num = or i8 %x, 128
  %denum = or i8 %y, 131
  %div = sdiv i8 %num, %denum
  %and = and i8 %div, 128
  %r = icmp eq i8 %and, 128
  ret i1 %r
}

define i1 @sdiv_pos_neg_high_bits(i8 %x, i8 %y) {
; CHECK-LABEL: @sdiv_pos_neg_high_bits(
; CHECK-NEXT:    ret i1 false
;
  %xx = and i8 %x, 127
  %num = or i8 %xx, 49
  %denum = or i8 %y, 241
  %div = sdiv i8 %num, %denum
  %and = and i8 %div, 128
  %r = icmp eq i8 %and, 0
  ret i1 %r
}

define i1 @sdiv_pos_neg_high_bits_fail_maybez(i8 %x, i8 %y) {
; CHECK-LABEL: @sdiv_pos_neg_high_bits_fail_maybez(
; CHECK-NEXT:    [[XX:%.*]] = and i8 [[X:%.*]], 127
; CHECK-NEXT:    [[NUM:%.*]] = or i8 [[XX]], 49
; CHECK-NEXT:    [[DENUM:%.*]] = or i8 [[Y:%.*]], -64
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i8 [[NUM]], [[DENUM]]
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[DIV]], -128
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[AND]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %xx = and i8 %x, 127
  %num = or i8 %xx, 49
  %denum = or i8 %y, 192
  %div = sdiv i8 %num, %denum
  %and = and i8 %div, 128
  %r = icmp eq i8 %and, 0
  ret i1 %r
}

define i1 @sdiv_exact_pos_neg_high_bits(i8 %x, i8 %y) {
; CHECK-LABEL: @sdiv_exact_pos_neg_high_bits(
; CHECK-NEXT:    ret i1 false
;
  %xx = and i8 %x, 127
  %num = or i8 %xx, 49
  %denum = or i8 %y, 192
  %div = sdiv exact i8 %num, %denum
  %and = and i8 %div, 128
  %r = icmp eq i8 %and, 0
  ret i1 %r
}

define i1 @sdiv_neg_pos_high_bits(i8 %x, i8 %y) {
; CHECK-LABEL: @sdiv_neg_pos_high_bits(
; CHECK-NEXT:    ret i1 false
;
  %xx = and i8 %x, 159
  %num = or i8 %xx, 129
  %yy = and i8 %y, 15
  %denum = or i8 %yy, 9
  %div = sdiv i8 %num, %denum
  %and = and i8 %div, 128
  %r = icmp eq i8 %and, 0
  ret i1 %r
}

define i1 @sdiv_neg_pos_high_bits_fail_maybez(i8 %x, i8 %y) {
; CHECK-LABEL: @sdiv_neg_pos_high_bits_fail_maybez(
; CHECK-NEXT:    [[NUM:%.*]] = or i8 [[X:%.*]], -128
; CHECK-NEXT:    [[YY:%.*]] = and i8 [[Y:%.*]], 15
; CHECK-NEXT:    [[DENUM:%.*]] = or i8 [[YY]], 9
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i8 [[NUM]], [[DENUM]]
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[DIV]], -128
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[AND]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %num = or i8 %x, 128
  %yy = and i8 %y, 15
  %denum = or i8 %yy, 9
  %div = sdiv i8 %num, %denum
  %and = and i8 %div, 128
  %r = icmp eq i8 %and, 0
  ret i1 %r
}

define i1 @sdiv_exact_odd_odd(i8 %x, i8 %y) {
; CHECK-LABEL: @sdiv_exact_odd_odd(
; CHECK-NEXT:    ret i1 false
;
  %num = or i8 %x, 1
  %denum = or i8 %y, 1
  %div = sdiv exact i8 %num, %denum
  %and = and i8 %div, 1
  %r = icmp eq i8 %and, 0
  ret i1 %r
}

define i1 @sdiv_exact_even_odd(i8 %x, i8 %y) {
; CHECK-LABEL: @sdiv_exact_even_odd(
; CHECK-NEXT:    ret i1 false
;
  %num = and i8 %x, -2
  %denum = or i8 %y, 1
  %div = sdiv exact i8 %num, %denum
  %and = and i8 %div, 1
  %r = icmp eq i8 %and, 1
  ret i1 %r
}

define i1 @sdiv_exact_even_even_fail_unknown(i8 %x, i8 %y) {
; CHECK-LABEL: @sdiv_exact_even_even_fail_unknown(
; CHECK-NEXT:    [[NUM:%.*]] = and i8 [[X:%.*]], -2
; CHECK-NEXT:    [[DENUM:%.*]] = and i8 [[Y:%.*]], -2
; CHECK-NEXT:    [[DIV:%.*]] = sdiv exact i8 [[NUM]], [[DENUM]]
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[DIV]], 1
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[AND]], 1
; CHECK-NEXT:    ret i1 [[R]]
;
  %num = and i8 %x, -2
  %denum = and i8 %y, -2
  %div = sdiv exact i8 %num, %denum
  %and = and i8 %div, 1
  %r = icmp eq i8 %and, 1
  ret i1 %r
}

define i1 @sdiv_exact_even_even_fail_unknown2(i8 %x, i8 %y) {
; CHECK-LABEL: @sdiv_exact_even_even_fail_unknown2(
; CHECK-NEXT:    [[NUM:%.*]] = and i8 [[X:%.*]], -2
; CHECK-NEXT:    [[DENUM:%.*]] = and i8 [[Y:%.*]], -2
; CHECK-NEXT:    [[DIV:%.*]] = sdiv exact i8 [[NUM]], [[DENUM]]
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[DIV]], 1
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[AND]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %num = and i8 %x, -2
  %denum = and i8 %y, -2
  %div = sdiv exact i8 %num, %denum
  %and = and i8 %div, 1
  %r = icmp eq i8 %and, 0
  ret i1 %r
}

define i1 @udiv_high_bits(i8 %x, i8 %y) {
; CHECK-LABEL: @udiv_high_bits(
; CHECK-NEXT:    ret i1 false
;
  %num = and i8 %x, 129
  %denum = or i8 %y, 31
  %div = udiv i8 %num, %denum
  %and = and i8 %div, 8
  %r = icmp eq i8 %and, 8
  ret i1 %r
}

define i1 @udiv_exact_odd_odd(i8 %x, i8 %y) {
; CHECK-LABEL: @udiv_exact_odd_odd(
; CHECK-NEXT:    ret i1 false
;
  %num = or i8 %x, 1
  %denum = or i8 %y, 1
  %div = udiv exact i8 %num, %denum
  %and = and i8 %div, 1
  %r = icmp eq i8 %and, 0
  ret i1 %r
}

define i1 @udiv_exact_even_odd(i8 %x, i8 %y) {
; CHECK-LABEL: @udiv_exact_even_odd(
; CHECK-NEXT:    ret i1 false
;
  %num = and i8 %x, -2
  %denum = or i8 %y, 1
  %div = udiv exact i8 %num, %denum
  %and = and i8 %div, 1
  %r = icmp eq i8 %and, 1
  ret i1 %r
}

define i1 @udiv_exact_even_even_fail_unknown(i8 %x, i8 %y) {
; CHECK-LABEL: @udiv_exact_even_even_fail_unknown(
; CHECK-NEXT:    [[NUM:%.*]] = and i8 [[X:%.*]], -2
; CHECK-NEXT:    [[DENUM:%.*]] = and i8 [[Y:%.*]], -2
; CHECK-NEXT:    [[DIV:%.*]] = udiv exact i8 [[NUM]], [[DENUM]]
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[DIV]], 1
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[AND]], 1
; CHECK-NEXT:    ret i1 [[R]]
;
  %num = and i8 %x, -2
  %denum = and i8 %y, -2
  %div = udiv exact i8 %num, %denum
  %and = and i8 %div, 1
  %r = icmp eq i8 %and, 1
  ret i1 %r
}

define i1 @udiv_exact_even_even_fail_unknown2(i8 %x, i8 %y) {
; CHECK-LABEL: @udiv_exact_even_even_fail_unknown2(
; CHECK-NEXT:    [[NUM:%.*]] = and i8 [[X:%.*]], -2
; CHECK-NEXT:    [[DENUM:%.*]] = and i8 [[Y:%.*]], -2
; CHECK-NEXT:    [[DIV:%.*]] = udiv exact i8 [[NUM]], [[DENUM]]
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[DIV]], 1
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[AND]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %num = and i8 %x, -2
  %denum = and i8 %y, -2
  %div = udiv exact i8 %num, %denum
  %and = and i8 %div, 1
  %r = icmp eq i8 %and, 0
  ret i1 %r
}
