; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=tahiti -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefix=GCN %s
; FIXME: Fails with -enable-var-scope

; Make sure 64-bit BFE pattern does a 32-bit BFE on the relevant half.

; Extract the high bit of the low half
define amdgpu_kernel void @v_uextract_bit_31_i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GCN-LABEL: v_uextract_bit_31_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_ashr_i32 s3, s2, 31
; GCN-NEXT:    s_lshl_b64 s[0:1], s[2:3], 3
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    s_mov_b32 s11, 0xf000
; GCN-NEXT:    s_mov_b32 s10, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GCN-NEXT:    s_mov_b64 s[6:7], s[10:11]
; GCN-NEXT:    v_mov_b32_e32 v3, 0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshrrev_b32_e32 v2, 31, v2
; GCN-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[4:7], 0 addr64
; GCN-NEXT:    s_endpgm
  %id.x = tail call i32 @llvm.amdgcn.workgroup.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %id.x
  %out.gep = getelementptr i64, ptr addrspace(1) %out, i32 %id.x
  %ld.64 = load i64, ptr addrspace(1) %in.gep
  %srl = lshr i64 %ld.64, 31
  %bit = and i64 %srl, 1
  store i64 %bit, ptr addrspace(1) %out.gep
  ret void
}

; Extract the high bit of the high half
define amdgpu_kernel void @v_uextract_bit_63_i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GCN-LABEL: v_uextract_bit_63_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GCN-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GCN-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64 offset:4
; GCN-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v3, v1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshrrev_b32_e32 v2, 31, v2
; GCN-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[4:7], 0 addr64
; GCN-NEXT:    s_endpgm
  %id.x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %id.x
  %out.gep = getelementptr i64, ptr addrspace(1) %out, i32 %id.x
  %ld.64 = load i64, ptr addrspace(1) %in.gep
  %srl = lshr i64 %ld.64, 63
  %bit = and i64 %srl, 1
  store i64 %bit, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_uextract_bit_1_i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GCN-LABEL: v_uextract_bit_1_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_ashr_i32 s3, s2, 31
; GCN-NEXT:    s_lshl_b64 s[0:1], s[2:3], 3
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    s_mov_b32 s11, 0xf000
; GCN-NEXT:    s_mov_b32 s10, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GCN-NEXT:    s_mov_b64 s[6:7], s[10:11]
; GCN-NEXT:    v_mov_b32_e32 v3, 0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_bfe_u32 v2, v2, 1, 1
; GCN-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[4:7], 0 addr64
; GCN-NEXT:    s_endpgm
  %id.x = tail call i32 @llvm.amdgcn.workgroup.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %id.x
  %out.gep = getelementptr i64, ptr addrspace(1) %out, i32 %id.x
  %ld.64 = load i64, ptr addrspace(1) %in.gep
  %srl = lshr i64 %ld.64, 1
  %bit = and i64 %srl, 1
  store i64 %bit, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_uextract_bit_20_i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GCN-LABEL: v_uextract_bit_20_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_ashr_i32 s3, s2, 31
; GCN-NEXT:    s_lshl_b64 s[0:1], s[2:3], 3
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    s_mov_b32 s11, 0xf000
; GCN-NEXT:    s_mov_b32 s10, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GCN-NEXT:    s_mov_b64 s[6:7], s[10:11]
; GCN-NEXT:    v_mov_b32_e32 v3, 0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_bfe_u32 v2, v2, 20, 1
; GCN-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[4:7], 0 addr64
; GCN-NEXT:    s_endpgm
  %id.x = tail call i32 @llvm.amdgcn.workgroup.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %id.x
  %out.gep = getelementptr i64, ptr addrspace(1) %out, i32 %id.x
  %ld.64 = load i64, ptr addrspace(1) %in.gep
  %srl = lshr i64 %ld.64, 20
  %bit = and i64 %srl, 1
  store i64 %bit, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_uextract_bit_32_i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GCN-LABEL: v_uextract_bit_32_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GCN-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GCN-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64 offset:4
; GCN-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v3, v1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v2, 1, v2
; GCN-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[4:7], 0 addr64
; GCN-NEXT:    s_endpgm
  %id.x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %id.x
  %out.gep = getelementptr i64, ptr addrspace(1) %out, i32 %id.x
  %ld.64 = load i64, ptr addrspace(1) %in.gep
  %srl = lshr i64 %ld.64, 32
  %bit = and i64 %srl, 1
  store i64 %bit, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_uextract_bit_33_i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GCN-LABEL: v_uextract_bit_33_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GCN-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GCN-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64 offset:4
; GCN-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v3, v1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_bfe_u32 v2, v2, 1, 1
; GCN-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[4:7], 0 addr64
; GCN-NEXT:    s_endpgm
  %id.x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %id.x
  %out.gep = getelementptr i64, ptr addrspace(1) %out, i32 %id.x
  %ld.64 = load i64, ptr addrspace(1) %in.gep
  %srl = lshr i64 %ld.64, 33
  %bit = and i64 %srl, 1
  store i64 %bit, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_uextract_bit_20_21_i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GCN-LABEL: v_uextract_bit_20_21_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_ashr_i32 s3, s2, 31
; GCN-NEXT:    s_lshl_b64 s[0:1], s[2:3], 3
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    s_mov_b32 s11, 0xf000
; GCN-NEXT:    s_mov_b32 s10, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GCN-NEXT:    s_mov_b64 s[6:7], s[10:11]
; GCN-NEXT:    v_mov_b32_e32 v3, 0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_bfe_u32 v2, v2, 20, 2
; GCN-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[4:7], 0 addr64
; GCN-NEXT:    s_endpgm
  %id.x = tail call i32 @llvm.amdgcn.workgroup.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %id.x
  %out.gep = getelementptr i64, ptr addrspace(1) %out, i32 %id.x
  %ld.64 = load i64, ptr addrspace(1) %in.gep
  %srl = lshr i64 %ld.64, 20
  %bit = and i64 %srl, 3
  store i64 %bit, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_uextract_bit_1_30_i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GCN-LABEL: v_uextract_bit_1_30_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_ashr_i32 s3, s2, 31
; GCN-NEXT:    s_lshl_b64 s[0:1], s[2:3], 3
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    s_mov_b32 s11, 0xf000
; GCN-NEXT:    s_mov_b32 s10, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GCN-NEXT:    s_mov_b64 s[6:7], s[10:11]
; GCN-NEXT:    v_mov_b32_e32 v3, 0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_bfe_u32 v2, v2, 1, 30
; GCN-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[4:7], 0 addr64
; GCN-NEXT:    s_endpgm
  %id.x = tail call i32 @llvm.amdgcn.workgroup.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %id.x
  %out.gep = getelementptr i64, ptr addrspace(1) %out, i32 %id.x
  %ld.64 = load i64, ptr addrspace(1) %in.gep
  %srl = lshr i64 %ld.64, 1
  %bit = and i64 %srl, 1073741823
  store i64 %bit, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_uextract_bit_1_31_i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GCN-LABEL: v_uextract_bit_1_31_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_ashr_i32 s3, s2, 31
; GCN-NEXT:    s_lshl_b64 s[0:1], s[2:3], 3
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    s_mov_b32 s11, 0xf000
; GCN-NEXT:    s_mov_b32 s10, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GCN-NEXT:    s_mov_b64 s[6:7], s[10:11]
; GCN-NEXT:    v_mov_b32_e32 v3, 0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshrrev_b32_e32 v2, 1, v2
; GCN-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[4:7], 0 addr64
; GCN-NEXT:    s_endpgm
  %id.x = tail call i32 @llvm.amdgcn.workgroup.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %id.x
  %out.gep = getelementptr i64, ptr addrspace(1) %out, i32 %id.x
  %ld.64 = load i64, ptr addrspace(1) %in.gep
  %srl = lshr i64 %ld.64, 1
  %bit = and i64 %srl, 2147483647
  store i64 %bit, ptr addrspace(1) %out.gep
  ret void
}

; Spans the dword boundary, so requires full shift.
; Truncated after the shift, so only low shift result is used.
define amdgpu_kernel void @v_uextract_bit_31_32_i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GCN-LABEL: v_uextract_bit_31_32_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    s_ashr_i32 s3, s2, 31
; GCN-NEXT:    s_lshl_b64 s[0:1], s[2:3], 3
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    s_mov_b32 s11, 0xf000
; GCN-NEXT:    s_mov_b32 s10, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_load_dwordx2 v[2:3], v[0:1], s[8:11], 0 addr64
; GCN-NEXT:    s_mov_b64 s[6:7], s[10:11]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_alignbit_b32 v2, v3, v2, 31
; GCN-NEXT:    v_and_b32_e32 v2, 3, v2
; GCN-NEXT:    v_mov_b32_e32 v3, 0
; GCN-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[4:7], 0 addr64
; GCN-NEXT:    s_endpgm
  %id.x = tail call i32 @llvm.amdgcn.workgroup.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %id.x
  %out.gep = getelementptr i64, ptr addrspace(1) %out, i32 %id.x
  %ld.64 = load i64, ptr addrspace(1) %in.gep
  %srl = lshr i64 %ld.64, 31
  %bit = and i64 %srl, 3
  store i64 %bit, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_uextract_bit_32_33_i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GCN-LABEL: v_uextract_bit_32_33_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GCN-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GCN-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64 offset:4
; GCN-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v3, v1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_bfe_u32 v2, v2, 1, 2
; GCN-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[4:7], 0 addr64
; GCN-NEXT:    s_endpgm
  %id.x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %id.x
  %out.gep = getelementptr i64, ptr addrspace(1) %out, i32 %id.x
  %ld.64 = load i64, ptr addrspace(1) %in.gep
  %srl = lshr i64 %ld.64, 33
  %bit = and i64 %srl, 3
  store i64 %bit, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_uextract_bit_30_60_i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GCN-LABEL: v_uextract_bit_30_60_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GCN-NEXT:    buffer_load_dwordx2 v[2:3], v[0:1], s[4:7], 0 addr64
; GCN-NEXT:    s_mov_b64 s[2:3], s[6:7]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_alignbit_b32 v2, v3, v2, 30
; GCN-NEXT:    v_and_b32_e32 v2, 0x3fffffff, v2
; GCN-NEXT:    v_mov_b32_e32 v3, v1
; GCN-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[0:3], 0 addr64
; GCN-NEXT:    s_endpgm
  %id.x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %id.x
  %out.gep = getelementptr i64, ptr addrspace(1) %out, i32 %id.x
  %ld.64 = load i64, ptr addrspace(1) %in.gep
  %srl = lshr i64 %ld.64, 30
  %bit = and i64 %srl, 1073741823
  store i64 %bit, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_uextract_bit_33_63_i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GCN-LABEL: v_uextract_bit_33_63_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GCN-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GCN-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64 offset:4
; GCN-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v3, v1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_bfe_u32 v2, v2, 1, 30
; GCN-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[4:7], 0 addr64
; GCN-NEXT:    s_endpgm
  %id.x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %id.x
  %out.gep = getelementptr i64, ptr addrspace(1) %out, i32 %id.x
  %ld.64 = load i64, ptr addrspace(1) %in.gep
  %srl = lshr i64 %ld.64, 33
  %bit = and i64 %srl, 1073741823
  store i64 %bit, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_uextract_bit_31_63_i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GCN-LABEL: v_uextract_bit_31_63_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s10, 0
; GCN-NEXT:    s_mov_b32 s11, s7
; GCN-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    buffer_load_dwordx2 v[2:3], v[0:1], s[8:11], 0 addr64
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_mov_b32 s4, s0
; GCN-NEXT:    s_mov_b32 s5, s1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_alignbit_b32 v0, v3, v2, 31
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
  %id.x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %id.x
  %out.gep = getelementptr i64, ptr addrspace(1) %out, i32 %id.x
  %ld.64 = load i64, ptr addrspace(1) %in.gep
  %srl = lshr i64 %ld.64, 31
  %and = and i64 %srl, 4294967295
  store i64 %and, ptr addrspace(1) %out
  ret void
}

; trunc applied before and mask
define amdgpu_kernel void @v_uextract_bit_31_i64_trunc_i32(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GCN-LABEL: v_uextract_bit_31_i64_trunc_i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 3, v0
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GCN-NEXT:    buffer_load_dword v3, v[1:2], s[4:7], 0 addr64
; GCN-NEXT:    s_mov_b64 s[2:3], s[6:7]
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshrrev_b32_e32 v0, 31, v3
; GCN-NEXT:    buffer_store_dword v0, v[1:2], s[0:3], 0 addr64
; GCN-NEXT:    s_endpgm
  %id.x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %id.x
  %out.gep = getelementptr i32, ptr addrspace(1) %out, i32 %id.x
  %ld.64 = load i64, ptr addrspace(1) %in.gep
  %srl = lshr i64 %ld.64, 31
  %trunc = trunc i64 %srl to i32
  %bit = and i32 %trunc, 1
  store i32 %bit, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_uextract_bit_3_i64_trunc_i32(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GCN-LABEL: v_uextract_bit_3_i64_trunc_i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 3, v0
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GCN-NEXT:    buffer_load_dword v3, v[1:2], s[4:7], 0 addr64
; GCN-NEXT:    s_mov_b64 s[2:3], s[6:7]
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_bfe_u32 v0, v3, 3, 1
; GCN-NEXT:    buffer_store_dword v0, v[1:2], s[0:3], 0 addr64
; GCN-NEXT:    s_endpgm
  %id.x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %id.x
  %out.gep = getelementptr i32, ptr addrspace(1) %out, i32 %id.x
  %ld.64 = load i64, ptr addrspace(1) %in.gep
  %srl = lshr i64 %ld.64, 3
  %trunc = trunc i64 %srl to i32
  %bit = and i32 %trunc, 1
  store i32 %bit, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_uextract_bit_33_i64_trunc_i32(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GCN-LABEL: v_uextract_bit_33_i64_trunc_i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 3, v0
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GCN-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GCN-NEXT:    buffer_load_dword v3, v[1:2], s[8:11], 0 addr64 offset:4
; GCN-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_bfe_u32 v0, v3, 1, 1
; GCN-NEXT:    buffer_store_dword v0, v[1:2], s[4:7], 0 addr64
; GCN-NEXT:    s_endpgm
  %id.x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %id.x
  %out.gep = getelementptr i32, ptr addrspace(1) %out, i32 %id.x
  %ld.64 = load i64, ptr addrspace(1) %in.gep
  %srl = lshr i64 %ld.64, 33
  %trunc = trunc i64 %srl to i32
  %bit = and i32 %trunc, 1
  store i32 %bit, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_uextract_bit_31_32_i64_trunc_i32(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GCN-LABEL: v_uextract_bit_31_32_i64_trunc_i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 3, v0
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GCN-NEXT:    buffer_load_dwordx2 v[3:4], v[1:2], s[4:7], 0 addr64
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GCN-NEXT:    s_mov_b64 s[2:3], s[6:7]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_alignbit_b32 v0, v4, v3, 31
; GCN-NEXT:    v_and_b32_e32 v0, 3, v0
; GCN-NEXT:    buffer_store_dword v0, v[1:2], s[0:3], 0 addr64
; GCN-NEXT:    s_endpgm
  %id.x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %id.x
  %out.gep = getelementptr i32, ptr addrspace(1) %out, i32 %id.x
  %ld.64 = load i64, ptr addrspace(1) %in.gep
  %srl = lshr i64 %ld.64, 31
  %trunc = trunc i64 %srl to i32
  %bit = and i32 %trunc, 3
  store i32 %bit, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @and_not_mask_i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GCN-LABEL: and_not_mask_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GCN-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; GCN-NEXT:    s_mov_b64 s[2:3], s[6:7]
; GCN-NEXT:    v_mov_b32_e32 v3, v1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshrrev_b32_e32 v2, 20, v2
; GCN-NEXT:    v_and_b32_e32 v2, 4, v2
; GCN-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[0:3], 0 addr64
; GCN-NEXT:    s_endpgm
  %id.x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %id.x
  %out.gep = getelementptr i64, ptr addrspace(1) %out, i32 %id.x
  %ld.64 = load i64, ptr addrspace(1) %in.gep
  %srl = lshr i64 %ld.64, 20
  %bit = and i64 %srl, 4
  store i64 %bit, ptr addrspace(1) %out.gep
  ret void
}

; The instruction count is the same with/without hasOneUse, but
; keeping the 32-bit and has a smaller encoding size than the bfe.
define amdgpu_kernel void @v_uextract_bit_27_29_multi_use_shift_i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GCN-LABEL: v_uextract_bit_27_29_multi_use_shift_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s10, 0
; GCN-NEXT:    s_mov_b32 s11, s7
; GCN-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    buffer_load_dwordx2 v[2:3], v[0:1], s[8:11], 0 addr64
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_mov_b32 s4, s0
; GCN-NEXT:    s_mov_b32 s5, s1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshr_b64 v[2:3], v[2:3], 27
; GCN-NEXT:    v_and_b32_e32 v0, 3, v2
; GCN-NEXT:    buffer_store_dwordx2 v[2:3], off, s[4:7], 0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_endpgm
  %id.x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %id.x
  %out.gep = getelementptr i64, ptr addrspace(1) %out, i32 %id.x
  %ld.64 = load i64, ptr addrspace(1) %in.gep
  %srl = lshr i64 %ld.64, 27
  %bit = and i64 %srl, 3
  store volatile i64 %srl, ptr addrspace(1) %out
  store volatile i64 %bit, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_uextract_bit_34_37_multi_use_shift_i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GCN-LABEL: v_uextract_bit_34_37_multi_use_shift_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    s_mov_b32 s10, 0
; GCN-NEXT:    s_mov_b32 s11, s7
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GCN-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64 offset:4
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_mov_b32 s4, s0
; GCN-NEXT:    s_mov_b32 s5, s1
; GCN-NEXT:    v_mov_b32_e32 v3, v1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshrrev_b32_e32 v0, 2, v2
; GCN-NEXT:    v_bfe_u32 v2, v2, 2, 3
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_dwordx2 v[2:3], off, s[4:7], 0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_endpgm
  %id.x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %id.x
  %out.gep = getelementptr i64, ptr addrspace(1) %out, i32 %id.x
  %ld.64 = load i64, ptr addrspace(1) %in.gep
  %srl = lshr i64 %ld.64, 34
  %bit = and i64 %srl, 7
  store volatile i64 %srl, ptr addrspace(1) %out
  store volatile i64 %bit, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_uextract_bit_33_36_use_upper_half_shift_i64(ptr addrspace(1) %out0, ptr addrspace(1) %out1, ptr addrspace(1) %in) #1 {
; GCN-LABEL: v_uextract_bit_33_36_use_upper_half_shift_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xd
; GCN-NEXT:    s_mov_b32 s2, 0
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 3, v0
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    buffer_load_dword v5, v[1:2], s[4:7], 0 addr64 offset:4
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GCN-NEXT:    v_mov_b32_e32 v6, v2
; GCN-NEXT:    s_mov_b64 s[10:11], s[2:3]
; GCN-NEXT:    v_lshlrev_b32_e32 v3, 2, v0
; GCN-NEXT:    v_mov_b32_e32 v4, v2
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[0:1], s[4:5]
; GCN-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_bfe_u32 v5, v5, 1, 3
; GCN-NEXT:    buffer_store_dwordx2 v[5:6], v[1:2], s[0:3], 0 addr64
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_dword v2, v[3:4], s[8:11], 0 addr64
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_endpgm
  %id.x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %id.x
  %out0.gep = getelementptr i64, ptr addrspace(1) %out0, i32 %id.x
  %out1.gep = getelementptr i32, ptr addrspace(1) %out1, i32 %id.x
  %ld.64 = load i64, ptr addrspace(1) %in.gep
  %srl = lshr i64 %ld.64, 33
  %bit = and i64 %srl, 7
  store volatile i64 %bit, ptr addrspace(1) %out0.gep

  %srl.srl32 = lshr i64 %srl, 32
  %srl.hi = trunc i64 %srl.srl32 to i32
  store volatile i32 %srl.hi, ptr addrspace(1) %out1.gep
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x() #0
declare i32 @llvm.amdgcn.workgroup.id.x() #0

attributes #0 = { nounwind readnone }
attributes #1 = { nounwind "amdgpu-no-dispatch-id" "amdgpu-no-dispatch-ptr" "amdgpu-no-implicitarg-ptr" "amdgpu-no-lds-kernel-id" "amdgpu-no-queue-ptr" "amdgpu-no-workgroup-id-y" "amdgpu-no-workgroup-id-z" "amdgpu-no-workitem-id-y" "amdgpu-no-workitem-id-z" }
