; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn -mcpu=gfx950 -global-isel=0 < %s | FileCheck -check-prefixes=GFX950,GFX950-SDAG %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx950 -global-isel=1 < %s | FileCheck -check-prefixes=GFX950,GFX950-GISEL %s

define <2 x half> @v_test_cvt_v2f32_v2f16(<2 x float> %src) {
; GFX950-LABEL: v_test_cvt_v2f32_v2f16:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_cvt_pk_f16_f32 v0, v0, v1
; GFX950-NEXT:    s_setpc_b64 s[30:31]
  %res = fptrunc <2 x float> %src to <2 x half>
  ret <2 x half> %res
}

define <3 x half> @v_test_cvt_v3f32_v3f16(<3 x float> %src) {
; GFX950-LABEL: v_test_cvt_v3f32_v3f16:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX950-NEXT:    v_cvt_pk_f16_f32 v0, v0, v1
; GFX950-NEXT:    v_mov_b32_e32 v1, v2
; GFX950-NEXT:    s_setpc_b64 s[30:31]
  %res = fptrunc <3 x float> %src to <3 x half>
  ret <3 x half> %res
}

define <4 x half> @v_test_cvt_v4f32_v4f16(<4 x float> %src) {
; GFX950-LABEL: v_test_cvt_v4f32_v4f16:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_cvt_pk_f16_f32 v0, v0, v1
; GFX950-NEXT:    v_cvt_pk_f16_f32 v1, v2, v3
; GFX950-NEXT:    s_setpc_b64 s[30:31]
  %res = fptrunc <4 x float> %src to <4 x half>
  ret <4 x half> %res
}

define <8 x half> @v_test_cvt_v8f32_v2f16(<8 x float> %src) {
; GFX950-LABEL: v_test_cvt_v8f32_v2f16:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_cvt_pk_f16_f32 v0, v0, v1
; GFX950-NEXT:    v_cvt_pk_f16_f32 v1, v2, v3
; GFX950-NEXT:    v_cvt_pk_f16_f32 v2, v4, v5
; GFX950-NEXT:    v_cvt_pk_f16_f32 v3, v6, v7
; GFX950-NEXT:    s_setpc_b64 s[30:31]
  %res = fptrunc <8 x float> %src to <8 x half>
  ret <8 x half> %res
}

define <16 x half> @v_test_cvt_v16f32_v16f16(<16 x float> %src) {
; GFX950-LABEL: v_test_cvt_v16f32_v16f16:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_cvt_pk_f16_f32 v0, v0, v1
; GFX950-NEXT:    v_cvt_pk_f16_f32 v1, v2, v3
; GFX950-NEXT:    v_cvt_pk_f16_f32 v2, v4, v5
; GFX950-NEXT:    v_cvt_pk_f16_f32 v3, v6, v7
; GFX950-NEXT:    v_cvt_pk_f16_f32 v4, v8, v9
; GFX950-NEXT:    v_cvt_pk_f16_f32 v5, v10, v11
; GFX950-NEXT:    v_cvt_pk_f16_f32 v6, v12, v13
; GFX950-NEXT:    v_cvt_pk_f16_f32 v7, v14, v15
; GFX950-NEXT:    s_setpc_b64 s[30:31]
  %res = fptrunc <16 x float> %src to <16 x half>
  ret <16 x half> %res
}

define half @fptrunc_v2f32_v2f16_extract_uses(<2 x float> %src) {
; GFX950-LABEL: fptrunc_v2f32_v2f16_extract_uses:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_cvt_pk_f16_f32 v0, v0, v1
; GFX950-NEXT:    v_add_f16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-NEXT:    s_setpc_b64 s[30:31]
  %vec_half = fptrunc <2 x float> %src to <2 x half>
  %f0 = extractelement <2 x half> %vec_half, i64 0
  %f1 = extractelement <2 x half> %vec_half, i64 1
  %rslt = fadd half %f0, %f1
  ret half %rslt
}

define half @fptrunc_v3f32_v3f16_extract_uses(<3 x float> %vec_float) {
; GFX950-SDAG-LABEL: fptrunc_v3f32_v3f16_extract_uses:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-SDAG-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX950-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX950-SDAG-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX950-SDAG-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX950-SDAG-NEXT:    v_add_f16_e32 v0, v2, v0
; GFX950-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-GISEL-LABEL: fptrunc_v3f32_v3f16_extract_uses:
; GFX950-GISEL:       ; %bb.0:
; GFX950-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-GISEL-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX950-GISEL-NEXT:    v_cvt_pk_f16_f32 v0, v0, v1
; GFX950-GISEL-NEXT:    v_add_f16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-GISEL-NEXT:    v_add_f16_e32 v0, v2, v0
; GFX950-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %vec_half = fptrunc <3 x float> %vec_float to <3 x half>
  %f0 = extractelement <3 x half> %vec_half, i64 0
  %f1 = extractelement <3 x half> %vec_half, i64 1
  %f2 = extractelement <3 x half> %vec_half, i64 2
  %sum0 = fadd half %f0, %f1
  %rslt = fadd half %f2, %sum0
  ret half %rslt
}

define half @fptrunc_v4f32_v4f16_extract_uses(<4 x float> %vec_float) {
; GFX950-SDAG-LABEL: fptrunc_v4f32_v4f16_extract_uses:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-SDAG-NEXT:    v_cvt_pk_f16_f32 v2, v2, v3
; GFX950-SDAG-NEXT:    v_cvt_pk_f16_f32 v0, v0, v1
; GFX950-SDAG-NEXT:    v_add_f16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-SDAG-NEXT:    v_add_f16_sdwa v1, v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-SDAG-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX950-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-GISEL-LABEL: fptrunc_v4f32_v4f16_extract_uses:
; GFX950-GISEL:       ; %bb.0:
; GFX950-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-GISEL-NEXT:    v_cvt_pk_f16_f32 v0, v0, v1
; GFX950-GISEL-NEXT:    v_cvt_pk_f16_f32 v1, v2, v3
; GFX950-GISEL-NEXT:    v_add_f16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-GISEL-NEXT:    v_add_f16_sdwa v1, v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-GISEL-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX950-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %vec_half = fptrunc <4 x float> %vec_float to <4 x half>
  %f0 = extractelement <4 x half> %vec_half, i64 0
  %f1 = extractelement <4 x half> %vec_half, i64 1
  %f2 = extractelement <4 x half> %vec_half, i64 2
  %f3 = extractelement <4 x half> %vec_half, i64 3
  %sum0 = fadd half %f0, %f1
  %sum1 = fadd half %f2, %f3
  %rslt = fadd half %sum0, %sum1
  ret half %rslt
}

define half @fptrunc_v8f32_v8f16_extract_uses(<8 x float> %vec_float) {
; GFX950-SDAG-LABEL: fptrunc_v8f32_v8f16_extract_uses:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-SDAG-NEXT:    v_cvt_pk_f16_f32 v6, v6, v7
; GFX950-SDAG-NEXT:    v_cvt_pk_f16_f32 v4, v4, v5
; GFX950-SDAG-NEXT:    v_cvt_pk_f16_f32 v2, v2, v3
; GFX950-SDAG-NEXT:    v_cvt_pk_f16_f32 v0, v0, v1
; GFX950-SDAG-NEXT:    v_add_f16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-SDAG-NEXT:    v_add_f16_sdwa v1, v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-SDAG-NEXT:    v_add_f16_sdwa v2, v4, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-SDAG-NEXT:    v_add_f16_sdwa v3, v6, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-SDAG-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX950-SDAG-NEXT:    v_add_f16_e32 v1, v2, v3
; GFX950-SDAG-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX950-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-GISEL-LABEL: fptrunc_v8f32_v8f16_extract_uses:
; GFX950-GISEL:       ; %bb.0:
; GFX950-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-GISEL-NEXT:    v_cvt_pk_f16_f32 v0, v0, v1
; GFX950-GISEL-NEXT:    v_cvt_pk_f16_f32 v1, v2, v3
; GFX950-GISEL-NEXT:    v_cvt_pk_f16_f32 v2, v4, v5
; GFX950-GISEL-NEXT:    v_cvt_pk_f16_f32 v3, v6, v7
; GFX950-GISEL-NEXT:    v_add_f16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-GISEL-NEXT:    v_add_f16_sdwa v1, v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-GISEL-NEXT:    v_add_f16_sdwa v2, v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-GISEL-NEXT:    v_add_f16_sdwa v3, v3, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-GISEL-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX950-GISEL-NEXT:    v_add_f16_e32 v1, v2, v3
; GFX950-GISEL-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX950-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %vec_half = fptrunc <8 x float> %vec_float to <8 x half>
  %f0 = extractelement <8 x half> %vec_half, i64 0
  %f1 = extractelement <8 x half> %vec_half, i64 1
  %f2 = extractelement <8 x half> %vec_half, i64 2
  %f3 = extractelement <8 x half> %vec_half, i64 3
  %f4 = extractelement <8 x half> %vec_half, i64 4
  %f5 = extractelement <8 x half> %vec_half, i64 5
  %f6 = extractelement <8 x half> %vec_half, i64 6
  %f7 = extractelement <8 x half> %vec_half, i64 7
  %sum0 = fadd half %f0, %f1
  %sum1 = fadd half %f2, %f3
  %sum2 = fadd half %f4, %f5
  %sum3 = fadd half %f6, %f7
  %sum4 = fadd half %sum0, %sum1
  %sum5 = fadd half %sum2, %sum3
  %rslt = fadd half %sum4, %sum5
  ret half %rslt
}

define half @fptrunc_v16f32_v16f16_extract_uses(<16 x float> %vec_float) {
; GFX950-SDAG-LABEL: fptrunc_v16f32_v16f16_extract_uses:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-SDAG-NEXT:    v_cvt_pk_f16_f32 v14, v14, v15
; GFX950-SDAG-NEXT:    v_cvt_pk_f16_f32 v12, v12, v13
; GFX950-SDAG-NEXT:    v_cvt_pk_f16_f32 v10, v10, v11
; GFX950-SDAG-NEXT:    v_cvt_pk_f16_f32 v8, v8, v9
; GFX950-SDAG-NEXT:    v_cvt_pk_f16_f32 v6, v6, v7
; GFX950-SDAG-NEXT:    v_cvt_pk_f16_f32 v4, v4, v5
; GFX950-SDAG-NEXT:    v_cvt_pk_f16_f32 v2, v2, v3
; GFX950-SDAG-NEXT:    v_cvt_pk_f16_f32 v0, v0, v1
; GFX950-SDAG-NEXT:    v_add_f16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-SDAG-NEXT:    v_add_f16_sdwa v1, v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-SDAG-NEXT:    v_add_f16_sdwa v2, v4, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-SDAG-NEXT:    v_add_f16_sdwa v3, v6, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-SDAG-NEXT:    v_add_f16_sdwa v4, v8, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-SDAG-NEXT:    v_add_f16_sdwa v5, v10, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-SDAG-NEXT:    v_add_f16_sdwa v6, v12, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-SDAG-NEXT:    v_add_f16_sdwa v7, v14, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-SDAG-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX950-SDAG-NEXT:    v_add_f16_e32 v1, v2, v3
; GFX950-SDAG-NEXT:    v_add_f16_e32 v2, v4, v5
; GFX950-SDAG-NEXT:    v_add_f16_e32 v3, v6, v7
; GFX950-SDAG-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX950-SDAG-NEXT:    v_add_f16_e32 v1, v2, v3
; GFX950-SDAG-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX950-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-GISEL-LABEL: fptrunc_v16f32_v16f16_extract_uses:
; GFX950-GISEL:       ; %bb.0:
; GFX950-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-GISEL-NEXT:    v_cvt_pk_f16_f32 v0, v0, v1
; GFX950-GISEL-NEXT:    v_cvt_pk_f16_f32 v1, v2, v3
; GFX950-GISEL-NEXT:    v_cvt_pk_f16_f32 v2, v4, v5
; GFX950-GISEL-NEXT:    v_cvt_pk_f16_f32 v3, v6, v7
; GFX950-GISEL-NEXT:    v_cvt_pk_f16_f32 v4, v8, v9
; GFX950-GISEL-NEXT:    v_cvt_pk_f16_f32 v5, v10, v11
; GFX950-GISEL-NEXT:    v_cvt_pk_f16_f32 v6, v12, v13
; GFX950-GISEL-NEXT:    v_cvt_pk_f16_f32 v7, v14, v15
; GFX950-GISEL-NEXT:    v_add_f16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-GISEL-NEXT:    v_add_f16_sdwa v1, v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-GISEL-NEXT:    v_add_f16_sdwa v2, v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-GISEL-NEXT:    v_add_f16_sdwa v3, v3, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-GISEL-NEXT:    v_add_f16_sdwa v4, v4, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-GISEL-NEXT:    v_add_f16_sdwa v5, v5, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-GISEL-NEXT:    v_add_f16_sdwa v6, v6, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-GISEL-NEXT:    v_add_f16_sdwa v7, v7, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX950-GISEL-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX950-GISEL-NEXT:    v_add_f16_e32 v1, v2, v3
; GFX950-GISEL-NEXT:    v_add_f16_e32 v2, v4, v5
; GFX950-GISEL-NEXT:    v_add_f16_e32 v3, v6, v7
; GFX950-GISEL-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX950-GISEL-NEXT:    v_add_f16_e32 v1, v2, v3
; GFX950-GISEL-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX950-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %vec_half = fptrunc <16 x float> %vec_float to <16 x half>
  %f0 = extractelement <16 x half> %vec_half, i64 0
  %f1 = extractelement <16 x half> %vec_half, i64 1
  %f2 = extractelement <16 x half> %vec_half, i64 2
  %f3 = extractelement <16 x half> %vec_half, i64 3
  %f4 = extractelement <16 x half> %vec_half, i64 4
  %f5 = extractelement <16 x half> %vec_half, i64 5
  %f6 = extractelement <16 x half> %vec_half, i64 6
  %f7 = extractelement <16 x half> %vec_half, i64 7
  %f8 = extractelement <16 x half> %vec_half, i64 8
  %f9 = extractelement <16 x half> %vec_half, i64 9
  %f10 = extractelement <16 x half> %vec_half, i64 10
  %f11 = extractelement <16 x half> %vec_half, i64 11
  %f12 = extractelement <16 x half> %vec_half, i64 12
  %f13 = extractelement <16 x half> %vec_half, i64 13
  %f14 = extractelement <16 x half> %vec_half, i64 14
  %f15 = extractelement <16 x half> %vec_half, i64 15
  %sum0 = fadd half %f0, %f1
  %sum1 = fadd half %f2, %f3
  %sum2 = fadd half %f4, %f5
  %sum3 = fadd half %f6, %f7
  %sum4 = fadd half %f8, %f9
  %sum5 = fadd half %f10, %f11
  %sum6 = fadd half %f12, %f13
  %sum7 = fadd half %f14, %f15
  %sum8 = fadd half %sum0, %sum1
  %sum9 = fadd half %sum2, %sum3
  %sum10 = fadd half %sum4, %sum5
  %sum11 = fadd half %sum6, %sum7
  %sum12 = fadd half %sum8, %sum9
  %sum13 = fadd half %sum10, %sum11
  %rslt = fadd half %sum12, %sum13
  ret half %rslt
}

define <2 x half> @v_test_cvt_v2f64_v2f16(<2 x double> %src) {
; GFX950-SDAG-LABEL: v_test_cvt_v2f64_v2f16:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-SDAG-NEXT:    s_movk_i32 s0, 0x1ff
; GFX950-SDAG-NEXT:    v_and_or_b32 v0, v1, s0, v0
; GFX950-SDAG-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX950-SDAG-NEXT:    v_lshrrev_b32_e32 v4, 8, v1
; GFX950-SDAG-NEXT:    s_movk_i32 s1, 0xffe
; GFX950-SDAG-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX950-SDAG-NEXT:    v_bfe_u32 v5, v1, 20, 11
; GFX950-SDAG-NEXT:    v_and_or_b32 v0, v4, s1, v0
; GFX950-SDAG-NEXT:    v_sub_u32_e32 v6, 0x3f1, v5
; GFX950-SDAG-NEXT:    v_or_b32_e32 v4, 0x1000, v0
; GFX950-SDAG-NEXT:    v_med3_i32 v6, v6, 0, 13
; GFX950-SDAG-NEXT:    v_lshrrev_b32_e32 v7, v6, v4
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v6, v6, v7
; GFX950-SDAG-NEXT:    v_cmp_ne_u32_e32 vcc, v6, v4
; GFX950-SDAG-NEXT:    v_add_u32_e32 v5, 0xfffffc10, v5
; GFX950-SDAG-NEXT:    v_lshl_or_b32 v6, v5, 12, v0
; GFX950-SDAG-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; GFX950-SDAG-NEXT:    v_or_b32_e32 v4, v7, v4
; GFX950-SDAG-NEXT:    v_cmp_gt_i32_e32 vcc, 1, v5
; GFX950-SDAG-NEXT:    s_movk_i32 s2, 0x40f
; GFX950-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX950-SDAG-NEXT:    v_and_b32_e32 v6, 7, v4
; GFX950-SDAG-NEXT:    v_cmp_lt_i32_e32 vcc, 5, v6
; GFX950-SDAG-NEXT:    v_lshrrev_b32_e32 v4, 2, v4
; GFX950-SDAG-NEXT:    s_mov_b32 s3, 0x8000
; GFX950-SDAG-NEXT:    v_cndmask_b32_e64 v7, 0, 1, vcc
; GFX950-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 3, v6
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e64 v6, 0, 1, vcc
; GFX950-SDAG-NEXT:    v_or_b32_e32 v6, v6, v7
; GFX950-SDAG-NEXT:    v_add_u32_e32 v4, v4, v6
; GFX950-SDAG-NEXT:    v_mov_b32_e32 v6, 0x7c00
; GFX950-SDAG-NEXT:    v_cmp_gt_i32_e32 vcc, 31, v5
; GFX950-SDAG-NEXT:    v_mov_b32_e32 v7, 0x7e00
; GFX950-SDAG-NEXT:    s_nop 0
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX950-SDAG-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v0, v6, v7, vcc
; GFX950-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, s2, v5
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX950-SDAG-NEXT:    v_and_or_b32 v0, v1, s3, v0
; GFX950-SDAG-NEXT:    v_and_or_b32 v1, v3, s0, v2
; GFX950-SDAG-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; GFX950-SDAG-NEXT:    v_lshrrev_b32_e32 v2, 8, v3
; GFX950-SDAG-NEXT:    v_bfe_u32 v4, v3, 20, 11
; GFX950-SDAG-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX950-SDAG-NEXT:    v_and_or_b32 v1, v2, s1, v1
; GFX950-SDAG-NEXT:    v_sub_u32_e32 v5, 0x3f1, v4
; GFX950-SDAG-NEXT:    v_or_b32_e32 v2, 0x1000, v1
; GFX950-SDAG-NEXT:    v_med3_i32 v5, v5, 0, 13
; GFX950-SDAG-NEXT:    v_lshrrev_b32_e32 v8, v5, v2
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v5, v5, v8
; GFX950-SDAG-NEXT:    v_cmp_ne_u32_e32 vcc, v5, v2
; GFX950-SDAG-NEXT:    v_add_u32_e32 v4, 0xfffffc10, v4
; GFX950-SDAG-NEXT:    v_lshl_or_b32 v5, v4, 12, v1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX950-SDAG-NEXT:    v_or_b32_e32 v2, v8, v2
; GFX950-SDAG-NEXT:    v_cmp_gt_i32_e32 vcc, 1, v4
; GFX950-SDAG-NEXT:    s_mov_b32 s0, 0x5040100
; GFX950-SDAG-NEXT:    s_nop 0
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v2, v5, v2, vcc
; GFX950-SDAG-NEXT:    v_and_b32_e32 v5, 7, v2
; GFX950-SDAG-NEXT:    v_cmp_lt_i32_e32 vcc, 5, v5
; GFX950-SDAG-NEXT:    v_lshrrev_b32_e32 v2, 2, v2
; GFX950-SDAG-NEXT:    s_nop 0
; GFX950-SDAG-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; GFX950-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, 3, v5
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; GFX950-SDAG-NEXT:    v_or_b32_e32 v5, v5, v8
; GFX950-SDAG-NEXT:    v_add_u32_e32 v2, v2, v5
; GFX950-SDAG-NEXT:    v_cmp_gt_i32_e32 vcc, 31, v4
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX950-SDAG-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v1, v6, v7, vcc
; GFX950-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, s2, v4
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GFX950-SDAG-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; GFX950-SDAG-NEXT:    v_and_or_b32 v1, v2, s3, v1
; GFX950-SDAG-NEXT:    v_perm_b32 v0, v1, v0, s0
; GFX950-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-GISEL-LABEL: v_test_cvt_v2f64_v2f16:
; GFX950-GISEL:       ; %bb.0:
; GFX950-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-GISEL-NEXT:    v_mov_b32_e32 v7, 0x1ff
; GFX950-GISEL-NEXT:    v_and_or_b32 v0, v1, v7, v0
; GFX950-GISEL-NEXT:    v_bfe_u32 v4, v1, 20, 11
; GFX950-GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX950-GISEL-NEXT:    v_add_u32_e32 v4, 0xfffffc10, v4
; GFX950-GISEL-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX950-GISEL-NEXT:    v_mov_b32_e32 v6, 0xffe
; GFX950-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX950-GISEL-NEXT:    v_and_or_b32 v0, v5, v6, v0
; GFX950-GISEL-NEXT:    v_sub_u32_e32 v10, 1, v4
; GFX950-GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX950-GISEL-NEXT:    v_lshl_or_b32 v9, v4, 12, v0
; GFX950-GISEL-NEXT:    v_med3_i32 v10, v10, 0, 13
; GFX950-GISEL-NEXT:    v_or_b32_e32 v0, 0x1000, v0
; GFX950-GISEL-NEXT:    v_lshrrev_b32_e32 v11, v10, v0
; GFX950-GISEL-NEXT:    v_lshlrev_b32_e32 v10, v10, v11
; GFX950-GISEL-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; GFX950-GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, v10, v0
; GFX950-GISEL-NEXT:    v_mov_b32_e32 v8, 0x7c00
; GFX950-GISEL-NEXT:    v_lshl_or_b32 v5, v5, 9, v8
; GFX950-GISEL-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX950-GISEL-NEXT:    v_or_b32_e32 v0, v11, v0
; GFX950-GISEL-NEXT:    v_cmp_gt_i32_e32 vcc, 1, v4
; GFX950-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX950-GISEL-NEXT:    v_and_or_b32 v2, v3, v7, v2
; GFX950-GISEL-NEXT:    v_cndmask_b32_e32 v0, v9, v0, vcc
; GFX950-GISEL-NEXT:    v_and_b32_e32 v9, 7, v0
; GFX950-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 3, v9
; GFX950-GISEL-NEXT:    v_cmp_lt_i32_e64 s[0:1], 5, v9
; GFX950-GISEL-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX950-GISEL-NEXT:    v_lshrrev_b32_e32 v0, 2, v0
; GFX950-GISEL-NEXT:    v_cndmask_b32_e64 v9, 0, 1, s[0:1]
; GFX950-GISEL-NEXT:    v_add_u32_e32 v0, v0, v9
; GFX950-GISEL-NEXT:    v_cmp_lt_i32_e32 vcc, 30, v4
; GFX950-GISEL-NEXT:    v_mov_b32_e32 v9, 0x40f
; GFX950-GISEL-NEXT:    s_nop 0
; GFX950-GISEL-NEXT:    v_cndmask_b32_e32 v0, v0, v8, vcc
; GFX950-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v9
; GFX950-GISEL-NEXT:    v_mov_b32_e32 v4, 0x8000
; GFX950-GISEL-NEXT:    s_nop 0
; GFX950-GISEL-NEXT:    v_cndmask_b32_e32 v0, v0, v5, vcc
; GFX950-GISEL-NEXT:    v_and_or_b32 v0, v1, v4, v0
; GFX950-GISEL-NEXT:    v_bfe_u32 v1, v3, 20, 11
; GFX950-GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX950-GISEL-NEXT:    v_add_u32_e32 v1, 0xfffffc10, v1
; GFX950-GISEL-NEXT:    v_lshrrev_b32_e32 v5, 8, v3
; GFX950-GISEL-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX950-GISEL-NEXT:    v_and_or_b32 v2, v5, v6, v2
; GFX950-GISEL-NEXT:    v_sub_u32_e32 v7, 1, v1
; GFX950-GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX950-GISEL-NEXT:    v_lshl_or_b32 v6, v1, 12, v2
; GFX950-GISEL-NEXT:    v_med3_i32 v7, v7, 0, 13
; GFX950-GISEL-NEXT:    v_or_b32_e32 v2, 0x1000, v2
; GFX950-GISEL-NEXT:    v_lshrrev_b32_e32 v10, v7, v2
; GFX950-GISEL-NEXT:    v_lshlrev_b32_e32 v7, v7, v10
; GFX950-GISEL-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; GFX950-GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, v7, v2
; GFX950-GISEL-NEXT:    v_lshl_or_b32 v5, v5, 9, v8
; GFX950-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX950-GISEL-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX950-GISEL-NEXT:    v_or_b32_e32 v2, v10, v2
; GFX950-GISEL-NEXT:    v_cmp_gt_i32_e32 vcc, 1, v1
; GFX950-GISEL-NEXT:    s_nop 1
; GFX950-GISEL-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX950-GISEL-NEXT:    v_and_b32_e32 v6, 7, v2
; GFX950-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, 3, v6
; GFX950-GISEL-NEXT:    v_cmp_lt_i32_e64 s[0:1], 5, v6
; GFX950-GISEL-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX950-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 2, v2
; GFX950-GISEL-NEXT:    v_cndmask_b32_e64 v6, 0, 1, s[0:1]
; GFX950-GISEL-NEXT:    v_add_u32_e32 v2, v2, v6
; GFX950-GISEL-NEXT:    v_cmp_lt_i32_e32 vcc, 30, v1
; GFX950-GISEL-NEXT:    s_nop 1
; GFX950-GISEL-NEXT:    v_cndmask_b32_e32 v2, v2, v8, vcc
; GFX950-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v9
; GFX950-GISEL-NEXT:    s_nop 1
; GFX950-GISEL-NEXT:    v_cndmask_b32_e32 v1, v2, v5, vcc
; GFX950-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; GFX950-GISEL-NEXT:    v_and_or_b32 v1, v2, v4, v1
; GFX950-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX950-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %res = fptrunc <2 x double> %src to <2 x half>
  ret <2 x half> %res
}
