; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --mtriple=aarch64-unknown-linux-gnu < %s | FileCheck %s

; Check that the following does not crash
; See https://github.com/llvm/llvm-project/issues/123029 for details

define ptr @fn(ptr %in, ptr %out) {
; CHECK-LABEL: fn:
; CHECK:       // %bb.0: // %fn
; CHECK-NEXT:    ldr d1, [x0]
; CHECK-NEXT:    movi v0.4h, #60, lsl #8
; CHECK-NEXT:    adrp x8, .LCPI0_0
; CHECK-NEXT:    fcvtl v1.4s, v1.4h
; CHECK-NEXT:    fcmgt v2.4s, v1.4s, #0.0
; CHECK-NEXT:    fcmlt v1.4s, v1.4s, #0.0
; CHECK-NEXT:    orr v1.16b, v1.16b, v2.16b
; CHECK-NEXT:    ldr h2, [x8, :lo12:.LCPI0_0]
; CHECK-NEXT:    xtn v1.4h, v1.4s
; CHECK-NEXT:    and v0.8b, v1.8b, v0.8b
; CHECK-NEXT:    movi d1, #0000000000000000
; CHECK-NEXT:    str d0, [x1]
; CHECK-NEXT:    ldr h0, [x0, #8]
; CHECK-NEXT:    mov x0, xzr
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    fcmp s0, #0.0
; CHECK-NEXT:    fcsel s1, s2, s1, mi
; CHECK-NEXT:    fcsel s1, s2, s1, gt
; CHECK-NEXT:    mvni v2.4s, #128, lsl #24
; CHECK-NEXT:    fcvt s1, h1
; CHECK-NEXT:    bit v0.16b, v1.16b, v2.16b
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    str h0, [x1, #8]
; CHECK-NEXT:    ret
fn:
  %1 = load <4 x half>, ptr %in
  %2 = fcmp one <4 x half> %1, zeroinitializer
  %3 = uitofp <4 x i1> %2 to <4 x half>
  store <4 x half> %3, ptr %out

  %4 = getelementptr inbounds nuw i8, ptr %in, i64 8
  %5 = load half, ptr %4
  %6 = fcmp one half %5, 0xH0000
  %7 = uitofp i1 %6 to half
  %8 = call half @llvm.copysign.f16(half %7, half %5)
  %9 = getelementptr inbounds nuw i8, ptr %out, i64 8
  store half %8, ptr %9
  ret ptr null
}
