// RUN: llvm-mc -triple i386-unknown-unknown --show-encoding %s | FileCheck %s

// CHECK: vfrczpd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x81,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vfrczpd -485498096(%edx,%eax,4), %xmm1

// CHECK: vfrczpd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x81,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vfrczpd 485498096(%edx,%eax,4), %xmm1

// CHECK: vfrczpd -485498096(%edx,%eax,4), %ymm4
// CHECK: encoding: [0x8f,0xe9,0x7c,0x81,0xa4,0x82,0x10,0xe3,0x0f,0xe3]
vfrczpd -485498096(%edx,%eax,4), %ymm4

// CHECK: vfrczpd 485498096(%edx,%eax,4), %ymm4
// CHECK: encoding: [0x8f,0xe9,0x7c,0x81,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]
vfrczpd 485498096(%edx,%eax,4), %ymm4

// CHECK: vfrczpd 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x81,0x8a,0xf0,0x1c,0xf0,0x1c]
vfrczpd 485498096(%edx), %xmm1

// CHECK: vfrczpd 485498096(%edx), %ymm4
// CHECK: encoding: [0x8f,0xe9,0x7c,0x81,0xa2,0xf0,0x1c,0xf0,0x1c]
vfrczpd 485498096(%edx), %ymm4

// CHECK: vfrczpd 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x81,0x0d,0xf0,0x1c,0xf0,0x1c]
vfrczpd 485498096, %xmm1

// CHECK: vfrczpd 485498096, %ymm4
// CHECK: encoding: [0x8f,0xe9,0x7c,0x81,0x25,0xf0,0x1c,0xf0,0x1c]
vfrczpd 485498096, %ymm4

// CHECK: vfrczpd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x81,0x4c,0x02,0x40]
vfrczpd 64(%edx,%eax), %xmm1

// CHECK: vfrczpd 64(%edx,%eax), %ymm4
// CHECK: encoding: [0x8f,0xe9,0x7c,0x81,0x64,0x02,0x40]
vfrczpd 64(%edx,%eax), %ymm4

// CHECK: vfrczpd (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x81,0x0a]
vfrczpd (%edx), %xmm1

// CHECK: vfrczpd (%edx), %ymm4
// CHECK: encoding: [0x8f,0xe9,0x7c,0x81,0x22]
vfrczpd (%edx), %ymm4

// CHECK: vfrczpd %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x81,0xc9]
vfrczpd %xmm1, %xmm1

// CHECK: vfrczpd %ymm4, %ymm4
// CHECK: encoding: [0x8f,0xe9,0x7c,0x81,0xe4]
vfrczpd %ymm4, %ymm4

// CHECK: vfrczps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x80,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vfrczps -485498096(%edx,%eax,4), %xmm1

// CHECK: vfrczps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x80,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vfrczps 485498096(%edx,%eax,4), %xmm1

// CHECK: vfrczps -485498096(%edx,%eax,4), %ymm4
// CHECK: encoding: [0x8f,0xe9,0x7c,0x80,0xa4,0x82,0x10,0xe3,0x0f,0xe3]
vfrczps -485498096(%edx,%eax,4), %ymm4

// CHECK: vfrczps 485498096(%edx,%eax,4), %ymm4
// CHECK: encoding: [0x8f,0xe9,0x7c,0x80,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]
vfrczps 485498096(%edx,%eax,4), %ymm4

// CHECK: vfrczps 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x80,0x8a,0xf0,0x1c,0xf0,0x1c]
vfrczps 485498096(%edx), %xmm1

// CHECK: vfrczps 485498096(%edx), %ymm4
// CHECK: encoding: [0x8f,0xe9,0x7c,0x80,0xa2,0xf0,0x1c,0xf0,0x1c]
vfrczps 485498096(%edx), %ymm4

// CHECK: vfrczps 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x80,0x0d,0xf0,0x1c,0xf0,0x1c]
vfrczps 485498096, %xmm1

// CHECK: vfrczps 485498096, %ymm4
// CHECK: encoding: [0x8f,0xe9,0x7c,0x80,0x25,0xf0,0x1c,0xf0,0x1c]
vfrczps 485498096, %ymm4

// CHECK: vfrczps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x80,0x4c,0x02,0x40]
vfrczps 64(%edx,%eax), %xmm1

// CHECK: vfrczps 64(%edx,%eax), %ymm4
// CHECK: encoding: [0x8f,0xe9,0x7c,0x80,0x64,0x02,0x40]
vfrczps 64(%edx,%eax), %ymm4

// CHECK: vfrczps (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x80,0x0a]
vfrczps (%edx), %xmm1

// CHECK: vfrczps (%edx), %ymm4
// CHECK: encoding: [0x8f,0xe9,0x7c,0x80,0x22]
vfrczps (%edx), %ymm4

// CHECK: vfrczps %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x80,0xc9]
vfrczps %xmm1, %xmm1

// CHECK: vfrczps %ymm4, %ymm4
// CHECK: encoding: [0x8f,0xe9,0x7c,0x80,0xe4]
vfrczps %ymm4, %ymm4

// CHECK: vfrczsd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x83,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vfrczsd -485498096(%edx,%eax,4), %xmm1

// CHECK: vfrczsd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x83,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vfrczsd 485498096(%edx,%eax,4), %xmm1

// CHECK: vfrczsd 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x83,0x8a,0xf0,0x1c,0xf0,0x1c]
vfrczsd 485498096(%edx), %xmm1

// CHECK: vfrczsd 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x83,0x0d,0xf0,0x1c,0xf0,0x1c]
vfrczsd 485498096, %xmm1

// CHECK: vfrczsd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x83,0x4c,0x02,0x40]
vfrczsd 64(%edx,%eax), %xmm1

// CHECK: vfrczsd (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x83,0x0a]
vfrczsd (%edx), %xmm1

// CHECK: vfrczsd %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x83,0xc9]
vfrczsd %xmm1, %xmm1

// CHECK: vfrczss -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x82,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vfrczss -485498096(%edx,%eax,4), %xmm1

// CHECK: vfrczss 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x82,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vfrczss 485498096(%edx,%eax,4), %xmm1

// CHECK: vfrczss 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x82,0x8a,0xf0,0x1c,0xf0,0x1c]
vfrczss 485498096(%edx), %xmm1

// CHECK: vfrczss 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x82,0x0d,0xf0,0x1c,0xf0,0x1c]
vfrczss 485498096, %xmm1

// CHECK: vfrczss 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x82,0x4c,0x02,0x40]
vfrczss 64(%edx,%eax), %xmm1

// CHECK: vfrczss (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x82,0x0a]
vfrczss (%edx), %xmm1

// CHECK: vfrczss %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0x82,0xc9]
vfrczss %xmm1, %xmm1

// CHECK: vpcmov -485498096(%edx,%eax,4), %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0xf0,0xa2,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x10]
vpcmov -485498096(%edx,%eax,4), %xmm1, %xmm1, %xmm1

// CHECK: vpcmov 485498096(%edx,%eax,4), %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0xf0,0xa2,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x10]
vpcmov 485498096(%edx,%eax,4), %xmm1, %xmm1, %xmm1

// CHECK: vpcmov -485498096(%edx,%eax,4), %ymm4, %ymm4, %ymm4
// CHECK: encoding: [0x8f,0xe8,0xdc,0xa2,0xa4,0x82,0x10,0xe3,0x0f,0xe3,0x40]
vpcmov -485498096(%edx,%eax,4), %ymm4, %ymm4, %ymm4

// CHECK: vpcmov 485498096(%edx,%eax,4), %ymm4, %ymm4, %ymm4
// CHECK: encoding: [0x8f,0xe8,0xdc,0xa2,0xa4,0x82,0xf0,0x1c,0xf0,0x1c,0x40]
vpcmov 485498096(%edx,%eax,4), %ymm4, %ymm4, %ymm4

// CHECK: vpcmov 485498096(%edx), %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0xf0,0xa2,0x8a,0xf0,0x1c,0xf0,0x1c,0x10]
vpcmov 485498096(%edx), %xmm1, %xmm1, %xmm1

// CHECK: vpcmov 485498096(%edx), %ymm4, %ymm4, %ymm4
// CHECK: encoding: [0x8f,0xe8,0xdc,0xa2,0xa2,0xf0,0x1c,0xf0,0x1c,0x40]
vpcmov 485498096(%edx), %ymm4, %ymm4, %ymm4

// CHECK: vpcmov 485498096, %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0xf0,0xa2,0x0d,0xf0,0x1c,0xf0,0x1c,0x10]
vpcmov 485498096, %xmm1, %xmm1, %xmm1

// CHECK: vpcmov 485498096, %ymm4, %ymm4, %ymm4
// CHECK: encoding: [0x8f,0xe8,0xdc,0xa2,0x25,0xf0,0x1c,0xf0,0x1c,0x40]
vpcmov 485498096, %ymm4, %ymm4, %ymm4

// CHECK: vpcmov 64(%edx,%eax), %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0xf0,0xa2,0x4c,0x02,0x40,0x10]
vpcmov 64(%edx,%eax), %xmm1, %xmm1, %xmm1

// CHECK: vpcmov 64(%edx,%eax), %ymm4, %ymm4, %ymm4
// CHECK: encoding: [0x8f,0xe8,0xdc,0xa2,0x64,0x02,0x40,0x40]
vpcmov 64(%edx,%eax), %ymm4, %ymm4, %ymm4

// CHECK: vpcmov (%edx), %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0xf0,0xa2,0x0a,0x10]
vpcmov (%edx), %xmm1, %xmm1, %xmm1

// CHECK: vpcmov (%edx), %ymm4, %ymm4, %ymm4
// CHECK: encoding: [0x8f,0xe8,0xdc,0xa2,0x22,0x40]
vpcmov (%edx), %ymm4, %ymm4, %ymm4

// CHECK: vpcmov %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xa2,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x10]
vpcmov %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpcmov %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xa2,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x10]
vpcmov %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpcmov %xmm1, 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xa2,0x8a,0xf0,0x1c,0xf0,0x1c,0x10]
vpcmov %xmm1, 485498096(%edx), %xmm1, %xmm1

// CHECK: vpcmov %xmm1, 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xa2,0x0d,0xf0,0x1c,0xf0,0x1c,0x10]
vpcmov %xmm1, 485498096, %xmm1, %xmm1

// CHECK: vpcmov %xmm1, 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xa2,0x4c,0x02,0x40,0x10]
vpcmov %xmm1, 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpcmov %xmm1, (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xa2,0x0a,0x10]
vpcmov %xmm1, (%edx), %xmm1, %xmm1

// CHECK: vpcmov %xmm1, %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xa2,0xc9,0x10]
vpcmov %xmm1, %xmm1, %xmm1, %xmm1

// CHECK: vpcmov %ymm4, -485498096(%edx,%eax,4), %ymm4, %ymm4
// CHECK: encoding: [0x8f,0xe8,0x5c,0xa2,0xa4,0x82,0x10,0xe3,0x0f,0xe3,0x40]
vpcmov %ymm4, -485498096(%edx,%eax,4), %ymm4, %ymm4

// CHECK: vpcmov %ymm4, 485498096(%edx,%eax,4), %ymm4, %ymm4
// CHECK: encoding: [0x8f,0xe8,0x5c,0xa2,0xa4,0x82,0xf0,0x1c,0xf0,0x1c,0x40]
vpcmov %ymm4, 485498096(%edx,%eax,4), %ymm4, %ymm4

// CHECK: vpcmov %ymm4, 485498096(%edx), %ymm4, %ymm4
// CHECK: encoding: [0x8f,0xe8,0x5c,0xa2,0xa2,0xf0,0x1c,0xf0,0x1c,0x40]
vpcmov %ymm4, 485498096(%edx), %ymm4, %ymm4

// CHECK: vpcmov %ymm4, 485498096, %ymm4, %ymm4
// CHECK: encoding: [0x8f,0xe8,0x5c,0xa2,0x25,0xf0,0x1c,0xf0,0x1c,0x40]
vpcmov %ymm4, 485498096, %ymm4, %ymm4

// CHECK: vpcmov %ymm4, 64(%edx,%eax), %ymm4, %ymm4
// CHECK: encoding: [0x8f,0xe8,0x5c,0xa2,0x64,0x02,0x40,0x40]
vpcmov %ymm4, 64(%edx,%eax), %ymm4, %ymm4

// CHECK: vpcmov %ymm4, (%edx), %ymm4, %ymm4
// CHECK: encoding: [0x8f,0xe8,0x5c,0xa2,0x22,0x40]
vpcmov %ymm4, (%edx), %ymm4, %ymm4

// CHECK: vpcmov %ymm4, %ymm4, %ymm4, %ymm4
// CHECK: encoding: [0x8f,0xe8,0x5c,0xa2,0xe4,0x40]
vpcmov %ymm4, %ymm4, %ymm4, %ymm4

// CHECK: vpcomltb -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xcc,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
vpcomltb -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpcomltb 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xcc,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltb 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpcomltb 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xcc,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltb 485498096(%edx), %xmm1, %xmm1

// CHECK: vpcomltb 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xcc,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltb 485498096, %xmm1, %xmm1

// CHECK: vpcomltb 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xcc,0x4c,0x02,0x40,0x00]
vpcomltb 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpcomltb (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xcc,0x0a,0x00]
vpcomltb (%edx), %xmm1, %xmm1

// CHECK: vpcomltb %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xcc,0xc9,0x00]
vpcomltb %xmm1, %xmm1, %xmm1

// CHECK: vpcomltd -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xce,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
vpcomltd -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpcomltd 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xce,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltd 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpcomltd 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xce,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltd 485498096(%edx), %xmm1, %xmm1

// CHECK: vpcomltd 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xce,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltd 485498096, %xmm1, %xmm1

// CHECK: vpcomltd 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xce,0x4c,0x02,0x40,0x00]
vpcomltd 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpcomltd (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xce,0x0a,0x00]
vpcomltd (%edx), %xmm1, %xmm1

// CHECK: vpcomltd %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xce,0xc9,0x00]
vpcomltd %xmm1, %xmm1, %xmm1

// CHECK: vpcomltq -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xcf,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
vpcomltq -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpcomltq 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xcf,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltq 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpcomltq 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xcf,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltq 485498096(%edx), %xmm1, %xmm1

// CHECK: vpcomltq 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xcf,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltq 485498096, %xmm1, %xmm1

// CHECK: vpcomltq 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xcf,0x4c,0x02,0x40,0x00]
vpcomltq 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpcomltq (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xcf,0x0a,0x00]
vpcomltq (%edx), %xmm1, %xmm1

// CHECK: vpcomltq %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xcf,0xc9,0x00]
vpcomltq %xmm1, %xmm1, %xmm1

// CHECK: vpcomltub -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xec,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
vpcomltub -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpcomltub 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xec,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltub 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpcomltub 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xec,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltub 485498096(%edx), %xmm1, %xmm1

// CHECK: vpcomltub 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xec,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltub 485498096, %xmm1, %xmm1

// CHECK: vpcomltub 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xec,0x4c,0x02,0x40,0x00]
vpcomltub 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpcomltub (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xec,0x0a,0x00]
vpcomltub (%edx), %xmm1, %xmm1

// CHECK: vpcomltub %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xec,0xc9,0x00]
vpcomltub %xmm1, %xmm1, %xmm1

// CHECK: vpcomltud -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xee,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
vpcomltud -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpcomltud 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xee,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltud 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpcomltud 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xee,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltud 485498096(%edx), %xmm1, %xmm1

// CHECK: vpcomltud 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xee,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltud 485498096, %xmm1, %xmm1

// CHECK: vpcomltud 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xee,0x4c,0x02,0x40,0x00]
vpcomltud 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpcomltud (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xee,0x0a,0x00]
vpcomltud (%edx), %xmm1, %xmm1

// CHECK: vpcomltud %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xee,0xc9,0x00]
vpcomltud %xmm1, %xmm1, %xmm1

// CHECK: vpcomltuq -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xef,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
vpcomltuq -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpcomltuq 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xef,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltuq 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpcomltuq 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xef,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltuq 485498096(%edx), %xmm1, %xmm1

// CHECK: vpcomltuq 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xef,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltuq 485498096, %xmm1, %xmm1

// CHECK: vpcomltuq 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xef,0x4c,0x02,0x40,0x00]
vpcomltuq 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpcomltuq (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xef,0x0a,0x00]
vpcomltuq (%edx), %xmm1, %xmm1

// CHECK: vpcomltuq %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xef,0xc9,0x00]
vpcomltuq %xmm1, %xmm1, %xmm1

// CHECK: vpcomltuw -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xed,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
vpcomltuw -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpcomltuw 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xed,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltuw 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpcomltuw 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xed,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltuw 485498096(%edx), %xmm1, %xmm1

// CHECK: vpcomltuw 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xed,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltuw 485498096, %xmm1, %xmm1

// CHECK: vpcomltuw 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xed,0x4c,0x02,0x40,0x00]
vpcomltuw 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpcomltuw (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xed,0x0a,0x00]
vpcomltuw (%edx), %xmm1, %xmm1

// CHECK: vpcomltuw %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xed,0xc9,0x00]
vpcomltuw %xmm1, %xmm1, %xmm1

// CHECK: vpcomltw -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xcd,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
vpcomltw -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpcomltw 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xcd,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltw 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpcomltw 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xcd,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltw 485498096(%edx), %xmm1, %xmm1

// CHECK: vpcomltw 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xcd,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltw 485498096, %xmm1, %xmm1

// CHECK: vpcomltw 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xcd,0x4c,0x02,0x40,0x00]
vpcomltw 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpcomltw (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xcd,0x0a,0x00]
vpcomltw (%edx), %xmm1, %xmm1

// CHECK: vpcomltw %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xcd,0xc9,0x00]
vpcomltw %xmm1, %xmm1, %xmm1

// CHECK: vpermil2pd $0, -485498096(%edx,%eax,4), %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0xf1,0x49,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x10]
vpermil2pd $0, -485498096(%edx,%eax,4), %xmm1, %xmm1, %xmm1

// CHECK: vpermil2pd $0, 485498096(%edx,%eax,4), %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0xf1,0x49,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x10]
vpermil2pd $0, 485498096(%edx,%eax,4), %xmm1, %xmm1, %xmm1

// CHECK: vpermil2pd $0, -485498096(%edx,%eax,4), %ymm4, %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0xdd,0x49,0xa4,0x82,0x10,0xe3,0x0f,0xe3,0x40]
vpermil2pd $0, -485498096(%edx,%eax,4), %ymm4, %ymm4, %ymm4

// CHECK: vpermil2pd $0, 485498096(%edx,%eax,4), %ymm4, %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0xdd,0x49,0xa4,0x82,0xf0,0x1c,0xf0,0x1c,0x40]
vpermil2pd $0, 485498096(%edx,%eax,4), %ymm4, %ymm4, %ymm4

// CHECK: vpermil2pd $0, 485498096(%edx), %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0xf1,0x49,0x8a,0xf0,0x1c,0xf0,0x1c,0x10]
vpermil2pd $0, 485498096(%edx), %xmm1, %xmm1, %xmm1

// CHECK: vpermil2pd $0, 485498096(%edx), %ymm4, %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0xdd,0x49,0xa2,0xf0,0x1c,0xf0,0x1c,0x40]
vpermil2pd $0, 485498096(%edx), %ymm4, %ymm4, %ymm4

// CHECK: vpermil2pd $0, 485498096, %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0xf1,0x49,0x0d,0xf0,0x1c,0xf0,0x1c,0x10]
vpermil2pd $0, 485498096, %xmm1, %xmm1, %xmm1

// CHECK: vpermil2pd $0, 485498096, %ymm4, %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0xdd,0x49,0x25,0xf0,0x1c,0xf0,0x1c,0x40]
vpermil2pd $0, 485498096, %ymm4, %ymm4, %ymm4

// CHECK: vpermil2pd $0, 64(%edx,%eax), %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0xf1,0x49,0x4c,0x02,0x40,0x10]
vpermil2pd $0, 64(%edx,%eax), %xmm1, %xmm1, %xmm1

// CHECK: vpermil2pd $0, 64(%edx,%eax), %ymm4, %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0xdd,0x49,0x64,0x02,0x40,0x40]
vpermil2pd $0, 64(%edx,%eax), %ymm4, %ymm4, %ymm4

// CHECK: vpermil2pd $0, (%edx), %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0xf1,0x49,0x0a,0x10]
vpermil2pd $0, (%edx), %xmm1, %xmm1, %xmm1

// CHECK: vpermil2pd $0, (%edx), %ymm4, %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0xdd,0x49,0x22,0x40]
vpermil2pd $0, (%edx), %ymm4, %ymm4, %ymm4

// CHECK: vpermil2pd $0, %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0x71,0x49,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x10]
vpermil2pd $0, %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpermil2pd $0, %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0x71,0x49,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x10]
vpermil2pd $0, %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpermil2pd $0, %xmm1, 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0x71,0x49,0x8a,0xf0,0x1c,0xf0,0x1c,0x10]
vpermil2pd $0, %xmm1, 485498096(%edx), %xmm1, %xmm1

// CHECK: vpermil2pd $0, %xmm1, 485498096, %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0x71,0x49,0x0d,0xf0,0x1c,0xf0,0x1c,0x10]
vpermil2pd $0, %xmm1, 485498096, %xmm1, %xmm1

// CHECK: vpermil2pd $0, %xmm1, 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0x71,0x49,0x4c,0x02,0x40,0x10]
vpermil2pd $0, %xmm1, 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpermil2pd $0, %xmm1, (%edx), %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0x71,0x49,0x0a,0x10]
vpermil2pd $0, %xmm1, (%edx), %xmm1, %xmm1

// CHECK: vpermil2pd $0, %xmm1, %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0x71,0x49,0xc9,0x10]
vpermil2pd $0, %xmm1, %xmm1, %xmm1, %xmm1

// CHECK: vpermil2pd $0, %ymm4, -485498096(%edx,%eax,4), %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0x5d,0x49,0xa4,0x82,0x10,0xe3,0x0f,0xe3,0x40]
vpermil2pd $0, %ymm4, -485498096(%edx,%eax,4), %ymm4, %ymm4

// CHECK: vpermil2pd $0, %ymm4, 485498096(%edx,%eax,4), %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0x5d,0x49,0xa4,0x82,0xf0,0x1c,0xf0,0x1c,0x40]
vpermil2pd $0, %ymm4, 485498096(%edx,%eax,4), %ymm4, %ymm4

// CHECK: vpermil2pd $0, %ymm4, 485498096(%edx), %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0x5d,0x49,0xa2,0xf0,0x1c,0xf0,0x1c,0x40]
vpermil2pd $0, %ymm4, 485498096(%edx), %ymm4, %ymm4

// CHECK: vpermil2pd $0, %ymm4, 485498096, %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0x5d,0x49,0x25,0xf0,0x1c,0xf0,0x1c,0x40]
vpermil2pd $0, %ymm4, 485498096, %ymm4, %ymm4

// CHECK: vpermil2pd $0, %ymm4, 64(%edx,%eax), %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0x5d,0x49,0x64,0x02,0x40,0x40]
vpermil2pd $0, %ymm4, 64(%edx,%eax), %ymm4, %ymm4

// CHECK: vpermil2pd $0, %ymm4, (%edx), %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0x5d,0x49,0x22,0x40]
vpermil2pd $0, %ymm4, (%edx), %ymm4, %ymm4

// CHECK: vpermil2pd $0, %ymm4, %ymm4, %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0x5d,0x49,0xe4,0x40]
vpermil2pd $0, %ymm4, %ymm4, %ymm4, %ymm4

// CHECK: vpermil2ps $0, -485498096(%edx,%eax,4), %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0xf1,0x48,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x10]
vpermil2ps $0, -485498096(%edx,%eax,4), %xmm1, %xmm1, %xmm1

// CHECK: vpermil2ps $0, 485498096(%edx,%eax,4), %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0xf1,0x48,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x10]
vpermil2ps $0, 485498096(%edx,%eax,4), %xmm1, %xmm1, %xmm1

// CHECK: vpermil2ps $0, -485498096(%edx,%eax,4), %ymm4, %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0xdd,0x48,0xa4,0x82,0x10,0xe3,0x0f,0xe3,0x40]
vpermil2ps $0, -485498096(%edx,%eax,4), %ymm4, %ymm4, %ymm4

// CHECK: vpermil2ps $0, 485498096(%edx,%eax,4), %ymm4, %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0xdd,0x48,0xa4,0x82,0xf0,0x1c,0xf0,0x1c,0x40]
vpermil2ps $0, 485498096(%edx,%eax,4), %ymm4, %ymm4, %ymm4

// CHECK: vpermil2ps $0, 485498096(%edx), %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0xf1,0x48,0x8a,0xf0,0x1c,0xf0,0x1c,0x10]
vpermil2ps $0, 485498096(%edx), %xmm1, %xmm1, %xmm1

// CHECK: vpermil2ps $0, 485498096(%edx), %ymm4, %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0xdd,0x48,0xa2,0xf0,0x1c,0xf0,0x1c,0x40]
vpermil2ps $0, 485498096(%edx), %ymm4, %ymm4, %ymm4

// CHECK: vpermil2ps $0, 485498096, %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0xf1,0x48,0x0d,0xf0,0x1c,0xf0,0x1c,0x10]
vpermil2ps $0, 485498096, %xmm1, %xmm1, %xmm1

// CHECK: vpermil2ps $0, 485498096, %ymm4, %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0xdd,0x48,0x25,0xf0,0x1c,0xf0,0x1c,0x40]
vpermil2ps $0, 485498096, %ymm4, %ymm4, %ymm4

// CHECK: vpermil2ps $0, 64(%edx,%eax), %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0xf1,0x48,0x4c,0x02,0x40,0x10]
vpermil2ps $0, 64(%edx,%eax), %xmm1, %xmm1, %xmm1

// CHECK: vpermil2ps $0, 64(%edx,%eax), %ymm4, %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0xdd,0x48,0x64,0x02,0x40,0x40]
vpermil2ps $0, 64(%edx,%eax), %ymm4, %ymm4, %ymm4

// CHECK: vpermil2ps $0, (%edx), %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0xf1,0x48,0x0a,0x10]
vpermil2ps $0, (%edx), %xmm1, %xmm1, %xmm1

// CHECK: vpermil2ps $0, (%edx), %ymm4, %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0xdd,0x48,0x22,0x40]
vpermil2ps $0, (%edx), %ymm4, %ymm4, %ymm4

// CHECK: vpermil2ps $0, %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0x71,0x48,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x10]
vpermil2ps $0, %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpermil2ps $0, %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0x71,0x48,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x10]
vpermil2ps $0, %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpermil2ps $0, %xmm1, 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0x71,0x48,0x8a,0xf0,0x1c,0xf0,0x1c,0x10]
vpermil2ps $0, %xmm1, 485498096(%edx), %xmm1, %xmm1

// CHECK: vpermil2ps $0, %xmm1, 485498096, %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0x71,0x48,0x0d,0xf0,0x1c,0xf0,0x1c,0x10]
vpermil2ps $0, %xmm1, 485498096, %xmm1, %xmm1

// CHECK: vpermil2ps $0, %xmm1, 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0x71,0x48,0x4c,0x02,0x40,0x10]
vpermil2ps $0, %xmm1, 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpermil2ps $0, %xmm1, (%edx), %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0x71,0x48,0x0a,0x10]
vpermil2ps $0, %xmm1, (%edx), %xmm1, %xmm1

// CHECK: vpermil2ps $0, %xmm1, %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0xc4,0xe3,0x71,0x48,0xc9,0x10]
vpermil2ps $0, %xmm1, %xmm1, %xmm1, %xmm1

// CHECK: vpermil2ps $0, %ymm4, -485498096(%edx,%eax,4), %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0x5d,0x48,0xa4,0x82,0x10,0xe3,0x0f,0xe3,0x40]
vpermil2ps $0, %ymm4, -485498096(%edx,%eax,4), %ymm4, %ymm4

// CHECK: vpermil2ps $0, %ymm4, 485498096(%edx,%eax,4), %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0x5d,0x48,0xa4,0x82,0xf0,0x1c,0xf0,0x1c,0x40]
vpermil2ps $0, %ymm4, 485498096(%edx,%eax,4), %ymm4, %ymm4

// CHECK: vpermil2ps $0, %ymm4, 485498096(%edx), %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0x5d,0x48,0xa2,0xf0,0x1c,0xf0,0x1c,0x40]
vpermil2ps $0, %ymm4, 485498096(%edx), %ymm4, %ymm4

// CHECK: vpermil2ps $0, %ymm4, 485498096, %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0x5d,0x48,0x25,0xf0,0x1c,0xf0,0x1c,0x40]
vpermil2ps $0, %ymm4, 485498096, %ymm4, %ymm4

// CHECK: vpermil2ps $0, %ymm4, 64(%edx,%eax), %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0x5d,0x48,0x64,0x02,0x40,0x40]
vpermil2ps $0, %ymm4, 64(%edx,%eax), %ymm4, %ymm4

// CHECK: vpermil2ps $0, %ymm4, (%edx), %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0x5d,0x48,0x22,0x40]
vpermil2ps $0, %ymm4, (%edx), %ymm4, %ymm4

// CHECK: vpermil2ps $0, %ymm4, %ymm4, %ymm4, %ymm4
// CHECK: encoding: [0xc4,0xe3,0x5d,0x48,0xe4,0x40]
vpermil2ps $0, %ymm4, %ymm4, %ymm4, %ymm4

// CHECK: vphaddbd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc2,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vphaddbd -485498096(%edx,%eax,4), %xmm1

// CHECK: vphaddbd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc2,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vphaddbd 485498096(%edx,%eax,4), %xmm1

// CHECK: vphaddbd 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc2,0x8a,0xf0,0x1c,0xf0,0x1c]
vphaddbd 485498096(%edx), %xmm1

// CHECK: vphaddbd 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc2,0x0d,0xf0,0x1c,0xf0,0x1c]
vphaddbd 485498096, %xmm1

// CHECK: vphaddbd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc2,0x4c,0x02,0x40]
vphaddbd 64(%edx,%eax), %xmm1

// CHECK: vphaddbd (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc2,0x0a]
vphaddbd (%edx), %xmm1

// CHECK: vphaddbd %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc2,0xc9]
vphaddbd %xmm1, %xmm1

// CHECK: vphaddbq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc3,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vphaddbq -485498096(%edx,%eax,4), %xmm1

// CHECK: vphaddbq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc3,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vphaddbq 485498096(%edx,%eax,4), %xmm1

// CHECK: vphaddbq 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc3,0x8a,0xf0,0x1c,0xf0,0x1c]
vphaddbq 485498096(%edx), %xmm1

// CHECK: vphaddbq 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc3,0x0d,0xf0,0x1c,0xf0,0x1c]
vphaddbq 485498096, %xmm1

// CHECK: vphaddbq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc3,0x4c,0x02,0x40]
vphaddbq 64(%edx,%eax), %xmm1

// CHECK: vphaddbq (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc3,0x0a]
vphaddbq (%edx), %xmm1

// CHECK: vphaddbq %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc3,0xc9]
vphaddbq %xmm1, %xmm1

// CHECK: vphaddbw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc1,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vphaddbw -485498096(%edx,%eax,4), %xmm1

// CHECK: vphaddbw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc1,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vphaddbw 485498096(%edx,%eax,4), %xmm1

// CHECK: vphaddbw 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc1,0x8a,0xf0,0x1c,0xf0,0x1c]
vphaddbw 485498096(%edx), %xmm1

// CHECK: vphaddbw 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc1,0x0d,0xf0,0x1c,0xf0,0x1c]
vphaddbw 485498096, %xmm1

// CHECK: vphaddbw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc1,0x4c,0x02,0x40]
vphaddbw 64(%edx,%eax), %xmm1

// CHECK: vphaddbw (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc1,0x0a]
vphaddbw (%edx), %xmm1

// CHECK: vphaddbw %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc1,0xc9]
vphaddbw %xmm1, %xmm1

// CHECK: vphadddq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xcb,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vphadddq -485498096(%edx,%eax,4), %xmm1

// CHECK: vphadddq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xcb,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vphadddq 485498096(%edx,%eax,4), %xmm1

// CHECK: vphadddq 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xcb,0x8a,0xf0,0x1c,0xf0,0x1c]
vphadddq 485498096(%edx), %xmm1

// CHECK: vphadddq 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xcb,0x0d,0xf0,0x1c,0xf0,0x1c]
vphadddq 485498096, %xmm1

// CHECK: vphadddq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xcb,0x4c,0x02,0x40]
vphadddq 64(%edx,%eax), %xmm1

// CHECK: vphadddq (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xcb,0x0a]
vphadddq (%edx), %xmm1

// CHECK: vphadddq %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xcb,0xc9]
vphadddq %xmm1, %xmm1

// CHECK: vphaddubd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd2,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vphaddubd -485498096(%edx,%eax,4), %xmm1

// CHECK: vphaddubd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd2,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vphaddubd 485498096(%edx,%eax,4), %xmm1

// CHECK: vphaddubd 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd2,0x8a,0xf0,0x1c,0xf0,0x1c]
vphaddubd 485498096(%edx), %xmm1

// CHECK: vphaddubd 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd2,0x0d,0xf0,0x1c,0xf0,0x1c]
vphaddubd 485498096, %xmm1

// CHECK: vphaddubd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd2,0x4c,0x02,0x40]
vphaddubd 64(%edx,%eax), %xmm1

// CHECK: vphaddubd (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd2,0x0a]
vphaddubd (%edx), %xmm1

// CHECK: vphaddubd %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd2,0xc9]
vphaddubd %xmm1, %xmm1

// CHECK: vphaddubq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd3,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vphaddubq -485498096(%edx,%eax,4), %xmm1

// CHECK: vphaddubq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd3,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vphaddubq 485498096(%edx,%eax,4), %xmm1

// CHECK: vphaddubq 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd3,0x8a,0xf0,0x1c,0xf0,0x1c]
vphaddubq 485498096(%edx), %xmm1

// CHECK: vphaddubq 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd3,0x0d,0xf0,0x1c,0xf0,0x1c]
vphaddubq 485498096, %xmm1

// CHECK: vphaddubq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd3,0x4c,0x02,0x40]
vphaddubq 64(%edx,%eax), %xmm1

// CHECK: vphaddubq (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd3,0x0a]
vphaddubq (%edx), %xmm1

// CHECK: vphaddubq %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd3,0xc9]
vphaddubq %xmm1, %xmm1

// CHECK: vphaddubw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd1,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vphaddubw -485498096(%edx,%eax,4), %xmm1

// CHECK: vphaddubw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd1,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vphaddubw 485498096(%edx,%eax,4), %xmm1

// CHECK: vphaddubw 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd1,0x8a,0xf0,0x1c,0xf0,0x1c]
vphaddubw 485498096(%edx), %xmm1

// CHECK: vphaddubw 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd1,0x0d,0xf0,0x1c,0xf0,0x1c]
vphaddubw 485498096, %xmm1

// CHECK: vphaddubw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd1,0x4c,0x02,0x40]
vphaddubw 64(%edx,%eax), %xmm1

// CHECK: vphaddubw (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd1,0x0a]
vphaddubw (%edx), %xmm1

// CHECK: vphaddubw %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd1,0xc9]
vphaddubw %xmm1, %xmm1

// CHECK: vphaddudq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xdb,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vphaddudq -485498096(%edx,%eax,4), %xmm1

// CHECK: vphaddudq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xdb,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vphaddudq 485498096(%edx,%eax,4), %xmm1

// CHECK: vphaddudq 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xdb,0x8a,0xf0,0x1c,0xf0,0x1c]
vphaddudq 485498096(%edx), %xmm1

// CHECK: vphaddudq 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xdb,0x0d,0xf0,0x1c,0xf0,0x1c]
vphaddudq 485498096, %xmm1

// CHECK: vphaddudq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xdb,0x4c,0x02,0x40]
vphaddudq 64(%edx,%eax), %xmm1

// CHECK: vphaddudq (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xdb,0x0a]
vphaddudq (%edx), %xmm1

// CHECK: vphaddudq %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xdb,0xc9]
vphaddudq %xmm1, %xmm1

// CHECK: vphadduwd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd6,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vphadduwd -485498096(%edx,%eax,4), %xmm1

// CHECK: vphadduwd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd6,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vphadduwd 485498096(%edx,%eax,4), %xmm1

// CHECK: vphadduwd 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd6,0x8a,0xf0,0x1c,0xf0,0x1c]
vphadduwd 485498096(%edx), %xmm1

// CHECK: vphadduwd 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd6,0x0d,0xf0,0x1c,0xf0,0x1c]
vphadduwd 485498096, %xmm1

// CHECK: vphadduwd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd6,0x4c,0x02,0x40]
vphadduwd 64(%edx,%eax), %xmm1

// CHECK: vphadduwd (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd6,0x0a]
vphadduwd (%edx), %xmm1

// CHECK: vphadduwd %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd6,0xc9]
vphadduwd %xmm1, %xmm1

// CHECK: vphadduwq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd7,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vphadduwq -485498096(%edx,%eax,4), %xmm1

// CHECK: vphadduwq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd7,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vphadduwq 485498096(%edx,%eax,4), %xmm1

// CHECK: vphadduwq 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd7,0x8a,0xf0,0x1c,0xf0,0x1c]
vphadduwq 485498096(%edx), %xmm1

// CHECK: vphadduwq 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd7,0x0d,0xf0,0x1c,0xf0,0x1c]
vphadduwq 485498096, %xmm1

// CHECK: vphadduwq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd7,0x4c,0x02,0x40]
vphadduwq 64(%edx,%eax), %xmm1

// CHECK: vphadduwq (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd7,0x0a]
vphadduwq (%edx), %xmm1

// CHECK: vphadduwq %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xd7,0xc9]
vphadduwq %xmm1, %xmm1

// CHECK: vphaddwd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc6,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vphaddwd -485498096(%edx,%eax,4), %xmm1

// CHECK: vphaddwd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc6,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vphaddwd 485498096(%edx,%eax,4), %xmm1

// CHECK: vphaddwd 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc6,0x8a,0xf0,0x1c,0xf0,0x1c]
vphaddwd 485498096(%edx), %xmm1

// CHECK: vphaddwd 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc6,0x0d,0xf0,0x1c,0xf0,0x1c]
vphaddwd 485498096, %xmm1

// CHECK: vphaddwd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc6,0x4c,0x02,0x40]
vphaddwd 64(%edx,%eax), %xmm1

// CHECK: vphaddwd (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc6,0x0a]
vphaddwd (%edx), %xmm1

// CHECK: vphaddwd %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc6,0xc9]
vphaddwd %xmm1, %xmm1

// CHECK: vphaddwq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc7,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vphaddwq -485498096(%edx,%eax,4), %xmm1

// CHECK: vphaddwq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc7,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vphaddwq 485498096(%edx,%eax,4), %xmm1

// CHECK: vphaddwq 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc7,0x8a,0xf0,0x1c,0xf0,0x1c]
vphaddwq 485498096(%edx), %xmm1

// CHECK: vphaddwq 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc7,0x0d,0xf0,0x1c,0xf0,0x1c]
vphaddwq 485498096, %xmm1

// CHECK: vphaddwq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc7,0x4c,0x02,0x40]
vphaddwq 64(%edx,%eax), %xmm1

// CHECK: vphaddwq (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc7,0x0a]
vphaddwq (%edx), %xmm1

// CHECK: vphaddwq %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xc7,0xc9]
vphaddwq %xmm1, %xmm1

// CHECK: vphsubbw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xe1,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vphsubbw -485498096(%edx,%eax,4), %xmm1

// CHECK: vphsubbw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xe1,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vphsubbw 485498096(%edx,%eax,4), %xmm1

// CHECK: vphsubbw 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xe1,0x8a,0xf0,0x1c,0xf0,0x1c]
vphsubbw 485498096(%edx), %xmm1

// CHECK: vphsubbw 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xe1,0x0d,0xf0,0x1c,0xf0,0x1c]
vphsubbw 485498096, %xmm1

// CHECK: vphsubbw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xe1,0x4c,0x02,0x40]
vphsubbw 64(%edx,%eax), %xmm1

// CHECK: vphsubbw (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xe1,0x0a]
vphsubbw (%edx), %xmm1

// CHECK: vphsubbw %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xe1,0xc9]
vphsubbw %xmm1, %xmm1

// CHECK: vphsubdq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xe3,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vphsubdq -485498096(%edx,%eax,4), %xmm1

// CHECK: vphsubdq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xe3,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vphsubdq 485498096(%edx,%eax,4), %xmm1

// CHECK: vphsubdq 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xe3,0x8a,0xf0,0x1c,0xf0,0x1c]
vphsubdq 485498096(%edx), %xmm1

// CHECK: vphsubdq 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xe3,0x0d,0xf0,0x1c,0xf0,0x1c]
vphsubdq 485498096, %xmm1

// CHECK: vphsubdq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xe3,0x4c,0x02,0x40]
vphsubdq 64(%edx,%eax), %xmm1

// CHECK: vphsubdq (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xe3,0x0a]
vphsubdq (%edx), %xmm1

// CHECK: vphsubdq %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xe3,0xc9]
vphsubdq %xmm1, %xmm1

// CHECK: vphsubwd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xe2,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vphsubwd -485498096(%edx,%eax,4), %xmm1

// CHECK: vphsubwd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xe2,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vphsubwd 485498096(%edx,%eax,4), %xmm1

// CHECK: vphsubwd 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xe2,0x8a,0xf0,0x1c,0xf0,0x1c]
vphsubwd 485498096(%edx), %xmm1

// CHECK: vphsubwd 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xe2,0x0d,0xf0,0x1c,0xf0,0x1c]
vphsubwd 485498096, %xmm1

// CHECK: vphsubwd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xe2,0x4c,0x02,0x40]
vphsubwd 64(%edx,%eax), %xmm1

// CHECK: vphsubwd (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xe2,0x0a]
vphsubwd (%edx), %xmm1

// CHECK: vphsubwd %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x78,0xe2,0xc9]
vphsubwd %xmm1, %xmm1

// CHECK: vpmacsdd %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x9e,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x10]
vpmacsdd %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmacsdd %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x9e,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacsdd %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmacsdd %xmm1, 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x9e,0x8a,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacsdd %xmm1, 485498096(%edx), %xmm1, %xmm1

// CHECK: vpmacsdd %xmm1, 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x9e,0x0d,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacsdd %xmm1, 485498096, %xmm1, %xmm1

// CHECK: vpmacsdd %xmm1, 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x9e,0x4c,0x02,0x40,0x10]
vpmacsdd %xmm1, 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpmacsdd %xmm1, (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x9e,0x0a,0x10]
vpmacsdd %xmm1, (%edx), %xmm1, %xmm1

// CHECK: vpmacsdd %xmm1, %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x9e,0xc9,0x10]
vpmacsdd %xmm1, %xmm1, %xmm1, %xmm1

// CHECK: vpmacsdqh %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x9f,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x10]
vpmacsdqh %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmacsdqh %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x9f,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacsdqh %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmacsdqh %xmm1, 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x9f,0x8a,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacsdqh %xmm1, 485498096(%edx), %xmm1, %xmm1

// CHECK: vpmacsdqh %xmm1, 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x9f,0x0d,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacsdqh %xmm1, 485498096, %xmm1, %xmm1

// CHECK: vpmacsdqh %xmm1, 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x9f,0x4c,0x02,0x40,0x10]
vpmacsdqh %xmm1, 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpmacsdqh %xmm1, (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x9f,0x0a,0x10]
vpmacsdqh %xmm1, (%edx), %xmm1, %xmm1

// CHECK: vpmacsdqh %xmm1, %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x9f,0xc9,0x10]
vpmacsdqh %xmm1, %xmm1, %xmm1, %xmm1

// CHECK: vpmacsdql %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x97,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x10]
vpmacsdql %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmacsdql %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x97,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacsdql %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmacsdql %xmm1, 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x97,0x8a,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacsdql %xmm1, 485498096(%edx), %xmm1, %xmm1

// CHECK: vpmacsdql %xmm1, 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x97,0x0d,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacsdql %xmm1, 485498096, %xmm1, %xmm1

// CHECK: vpmacsdql %xmm1, 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x97,0x4c,0x02,0x40,0x10]
vpmacsdql %xmm1, 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpmacsdql %xmm1, (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x97,0x0a,0x10]
vpmacsdql %xmm1, (%edx), %xmm1, %xmm1

// CHECK: vpmacsdql %xmm1, %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x97,0xc9,0x10]
vpmacsdql %xmm1, %xmm1, %xmm1, %xmm1

// CHECK: vpmacssdd %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x8e,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x10]
vpmacssdd %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmacssdd %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x8e,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacssdd %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmacssdd %xmm1, 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x8e,0x8a,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacssdd %xmm1, 485498096(%edx), %xmm1, %xmm1

// CHECK: vpmacssdd %xmm1, 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x8e,0x0d,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacssdd %xmm1, 485498096, %xmm1, %xmm1

// CHECK: vpmacssdd %xmm1, 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x8e,0x4c,0x02,0x40,0x10]
vpmacssdd %xmm1, 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpmacssdd %xmm1, (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x8e,0x0a,0x10]
vpmacssdd %xmm1, (%edx), %xmm1, %xmm1

// CHECK: vpmacssdd %xmm1, %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x8e,0xc9,0x10]
vpmacssdd %xmm1, %xmm1, %xmm1, %xmm1

// CHECK: vpmacssdqh %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x8f,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x10]
vpmacssdqh %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmacssdqh %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x8f,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacssdqh %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmacssdqh %xmm1, 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x8f,0x8a,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacssdqh %xmm1, 485498096(%edx), %xmm1, %xmm1

// CHECK: vpmacssdqh %xmm1, 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x8f,0x0d,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacssdqh %xmm1, 485498096, %xmm1, %xmm1

// CHECK: vpmacssdqh %xmm1, 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x8f,0x4c,0x02,0x40,0x10]
vpmacssdqh %xmm1, 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpmacssdqh %xmm1, (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x8f,0x0a,0x10]
vpmacssdqh %xmm1, (%edx), %xmm1, %xmm1

// CHECK: vpmacssdqh %xmm1, %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x8f,0xc9,0x10]
vpmacssdqh %xmm1, %xmm1, %xmm1, %xmm1

// CHECK: vpmacssdql %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x87,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x10]
vpmacssdql %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmacssdql %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x87,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacssdql %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmacssdql %xmm1, 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x87,0x8a,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacssdql %xmm1, 485498096(%edx), %xmm1, %xmm1

// CHECK: vpmacssdql %xmm1, 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x87,0x0d,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacssdql %xmm1, 485498096, %xmm1, %xmm1

// CHECK: vpmacssdql %xmm1, 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x87,0x4c,0x02,0x40,0x10]
vpmacssdql %xmm1, 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpmacssdql %xmm1, (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x87,0x0a,0x10]
vpmacssdql %xmm1, (%edx), %xmm1, %xmm1

// CHECK: vpmacssdql %xmm1, %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x87,0xc9,0x10]
vpmacssdql %xmm1, %xmm1, %xmm1, %xmm1

// CHECK: vpmacsswd %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x86,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x10]
vpmacsswd %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmacsswd %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x86,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacsswd %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmacsswd %xmm1, 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x86,0x8a,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacsswd %xmm1, 485498096(%edx), %xmm1, %xmm1

// CHECK: vpmacsswd %xmm1, 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x86,0x0d,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacsswd %xmm1, 485498096, %xmm1, %xmm1

// CHECK: vpmacsswd %xmm1, 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x86,0x4c,0x02,0x40,0x10]
vpmacsswd %xmm1, 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpmacsswd %xmm1, (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x86,0x0a,0x10]
vpmacsswd %xmm1, (%edx), %xmm1, %xmm1

// CHECK: vpmacsswd %xmm1, %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x86,0xc9,0x10]
vpmacsswd %xmm1, %xmm1, %xmm1, %xmm1

// CHECK: vpmacssww %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x85,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x10]
vpmacssww %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmacssww %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x85,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacssww %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmacssww %xmm1, 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x85,0x8a,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacssww %xmm1, 485498096(%edx), %xmm1, %xmm1

// CHECK: vpmacssww %xmm1, 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x85,0x0d,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacssww %xmm1, 485498096, %xmm1, %xmm1

// CHECK: vpmacssww %xmm1, 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x85,0x4c,0x02,0x40,0x10]
vpmacssww %xmm1, 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpmacssww %xmm1, (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x85,0x0a,0x10]
vpmacssww %xmm1, (%edx), %xmm1, %xmm1

// CHECK: vpmacssww %xmm1, %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x85,0xc9,0x10]
vpmacssww %xmm1, %xmm1, %xmm1, %xmm1

// CHECK: vpmacswd %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x96,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x10]
vpmacswd %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmacswd %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x96,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacswd %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmacswd %xmm1, 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x96,0x8a,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacswd %xmm1, 485498096(%edx), %xmm1, %xmm1

// CHECK: vpmacswd %xmm1, 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x96,0x0d,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacswd %xmm1, 485498096, %xmm1, %xmm1

// CHECK: vpmacswd %xmm1, 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x96,0x4c,0x02,0x40,0x10]
vpmacswd %xmm1, 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpmacswd %xmm1, (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x96,0x0a,0x10]
vpmacswd %xmm1, (%edx), %xmm1, %xmm1

// CHECK: vpmacswd %xmm1, %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x96,0xc9,0x10]
vpmacswd %xmm1, %xmm1, %xmm1, %xmm1

// CHECK: vpmacsww %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x95,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x10]
vpmacsww %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmacsww %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x95,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacsww %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmacsww %xmm1, 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x95,0x8a,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacsww %xmm1, 485498096(%edx), %xmm1, %xmm1

// CHECK: vpmacsww %xmm1, 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x95,0x0d,0xf0,0x1c,0xf0,0x1c,0x10]
vpmacsww %xmm1, 485498096, %xmm1, %xmm1

// CHECK: vpmacsww %xmm1, 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x95,0x4c,0x02,0x40,0x10]
vpmacsww %xmm1, 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpmacsww %xmm1, (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x95,0x0a,0x10]
vpmacsww %xmm1, (%edx), %xmm1, %xmm1

// CHECK: vpmacsww %xmm1, %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0x95,0xc9,0x10]
vpmacsww %xmm1, %xmm1, %xmm1, %xmm1

// CHECK: vpmadcsswd %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xa6,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x10]
vpmadcsswd %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmadcsswd %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xa6,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x10]
vpmadcsswd %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmadcsswd %xmm1, 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xa6,0x8a,0xf0,0x1c,0xf0,0x1c,0x10]
vpmadcsswd %xmm1, 485498096(%edx), %xmm1, %xmm1

// CHECK: vpmadcsswd %xmm1, 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xa6,0x0d,0xf0,0x1c,0xf0,0x1c,0x10]
vpmadcsswd %xmm1, 485498096, %xmm1, %xmm1

// CHECK: vpmadcsswd %xmm1, 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xa6,0x4c,0x02,0x40,0x10]
vpmadcsswd %xmm1, 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpmadcsswd %xmm1, (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xa6,0x0a,0x10]
vpmadcsswd %xmm1, (%edx), %xmm1, %xmm1

// CHECK: vpmadcsswd %xmm1, %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xa6,0xc9,0x10]
vpmadcsswd %xmm1, %xmm1, %xmm1, %xmm1

// CHECK: vpmadcswd %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xb6,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x10]
vpmadcswd %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmadcswd %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xb6,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x10]
vpmadcswd %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpmadcswd %xmm1, 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xb6,0x8a,0xf0,0x1c,0xf0,0x1c,0x10]
vpmadcswd %xmm1, 485498096(%edx), %xmm1, %xmm1

// CHECK: vpmadcswd %xmm1, 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xb6,0x0d,0xf0,0x1c,0xf0,0x1c,0x10]
vpmadcswd %xmm1, 485498096, %xmm1, %xmm1

// CHECK: vpmadcswd %xmm1, 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xb6,0x4c,0x02,0x40,0x10]
vpmadcswd %xmm1, 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpmadcswd %xmm1, (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xb6,0x0a,0x10]
vpmadcswd %xmm1, (%edx), %xmm1, %xmm1

// CHECK: vpmadcswd %xmm1, %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xb6,0xc9,0x10]
vpmadcswd %xmm1, %xmm1, %xmm1, %xmm1

// CHECK: vpperm -485498096(%edx,%eax,4), %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0xf0,0xa3,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x10]
vpperm -485498096(%edx,%eax,4), %xmm1, %xmm1, %xmm1

// CHECK: vpperm 485498096(%edx,%eax,4), %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0xf0,0xa3,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x10]
vpperm 485498096(%edx,%eax,4), %xmm1, %xmm1, %xmm1

// CHECK: vpperm 485498096(%edx), %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0xf0,0xa3,0x8a,0xf0,0x1c,0xf0,0x1c,0x10]
vpperm 485498096(%edx), %xmm1, %xmm1, %xmm1

// CHECK: vpperm 485498096, %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0xf0,0xa3,0x0d,0xf0,0x1c,0xf0,0x1c,0x10]
vpperm 485498096, %xmm1, %xmm1, %xmm1

// CHECK: vpperm 64(%edx,%eax), %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0xf0,0xa3,0x4c,0x02,0x40,0x10]
vpperm 64(%edx,%eax), %xmm1, %xmm1, %xmm1

// CHECK: vpperm (%edx), %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0xf0,0xa3,0x0a,0x10]
vpperm (%edx), %xmm1, %xmm1, %xmm1

// CHECK: vpperm %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xa3,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x10]
vpperm %xmm1, -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpperm %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xa3,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x10]
vpperm %xmm1, 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpperm %xmm1, 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xa3,0x8a,0xf0,0x1c,0xf0,0x1c,0x10]
vpperm %xmm1, 485498096(%edx), %xmm1, %xmm1

// CHECK: vpperm %xmm1, 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xa3,0x0d,0xf0,0x1c,0xf0,0x1c,0x10]
vpperm %xmm1, 485498096, %xmm1, %xmm1

// CHECK: vpperm %xmm1, 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xa3,0x4c,0x02,0x40,0x10]
vpperm %xmm1, 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpperm %xmm1, (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xa3,0x0a,0x10]
vpperm %xmm1, (%edx), %xmm1, %xmm1

// CHECK: vpperm %xmm1, %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x70,0xa3,0xc9,0x10]
vpperm %xmm1, %xmm1, %xmm1, %xmm1

// CHECK: vprotb $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc0,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
vprotb $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: vprotb $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc0,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
vprotb $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: vprotb $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc0,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
vprotb $0, 485498096(%edx), %xmm1

// CHECK: vprotb $0, 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc0,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
vprotb $0, 485498096, %xmm1

// CHECK: vprotb $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc0,0x4c,0x02,0x40,0x00]
vprotb $0, 64(%edx,%eax), %xmm1

// CHECK: vprotb $0, (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc0,0x0a,0x00]
vprotb $0, (%edx), %xmm1

// CHECK: vprotb $0, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc0,0xc9,0x00]
vprotb $0, %xmm1, %xmm1

// CHECK: vprotb -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x90,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vprotb -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vprotb 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x90,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vprotb 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vprotb 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x90,0x8a,0xf0,0x1c,0xf0,0x1c]
vprotb 485498096(%edx), %xmm1, %xmm1

// CHECK: vprotb 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x90,0x0d,0xf0,0x1c,0xf0,0x1c]
vprotb 485498096, %xmm1, %xmm1

// CHECK: vprotb 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x90,0x4c,0x02,0x40]
vprotb 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vprotb (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x90,0x0a]
vprotb (%edx), %xmm1, %xmm1

// CHECK: vprotb %xmm1, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x90,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vprotb %xmm1, -485498096(%edx,%eax,4), %xmm1

// CHECK: vprotb %xmm1, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x90,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vprotb %xmm1, 485498096(%edx,%eax,4), %xmm1

// CHECK: vprotb %xmm1, 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x90,0x8a,0xf0,0x1c,0xf0,0x1c]
vprotb %xmm1, 485498096(%edx), %xmm1

// CHECK: vprotb %xmm1, 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x90,0x0d,0xf0,0x1c,0xf0,0x1c]
vprotb %xmm1, 485498096, %xmm1

// CHECK: vprotb %xmm1, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x90,0x4c,0x02,0x40]
vprotb %xmm1, 64(%edx,%eax), %xmm1

// CHECK: vprotb %xmm1, (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x90,0x0a]
vprotb %xmm1, (%edx), %xmm1

// CHECK: vprotb %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x90,0xc9]
vprotb %xmm1, %xmm1, %xmm1

// CHECK: vprotd $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc2,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
vprotd $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: vprotd $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc2,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
vprotd $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: vprotd $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc2,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
vprotd $0, 485498096(%edx), %xmm1

// CHECK: vprotd $0, 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc2,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
vprotd $0, 485498096, %xmm1

// CHECK: vprotd $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc2,0x4c,0x02,0x40,0x00]
vprotd $0, 64(%edx,%eax), %xmm1

// CHECK: vprotd $0, (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc2,0x0a,0x00]
vprotd $0, (%edx), %xmm1

// CHECK: vprotd $0, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc2,0xc9,0x00]
vprotd $0, %xmm1, %xmm1

// CHECK: vprotd -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x92,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vprotd -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vprotd 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x92,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vprotd 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vprotd 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x92,0x8a,0xf0,0x1c,0xf0,0x1c]
vprotd 485498096(%edx), %xmm1, %xmm1

// CHECK: vprotd 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x92,0x0d,0xf0,0x1c,0xf0,0x1c]
vprotd 485498096, %xmm1, %xmm1

// CHECK: vprotd 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x92,0x4c,0x02,0x40]
vprotd 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vprotd (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x92,0x0a]
vprotd (%edx), %xmm1, %xmm1

// CHECK: vprotd %xmm1, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x92,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vprotd %xmm1, -485498096(%edx,%eax,4), %xmm1

// CHECK: vprotd %xmm1, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x92,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vprotd %xmm1, 485498096(%edx,%eax,4), %xmm1

// CHECK: vprotd %xmm1, 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x92,0x8a,0xf0,0x1c,0xf0,0x1c]
vprotd %xmm1, 485498096(%edx), %xmm1

// CHECK: vprotd %xmm1, 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x92,0x0d,0xf0,0x1c,0xf0,0x1c]
vprotd %xmm1, 485498096, %xmm1

// CHECK: vprotd %xmm1, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x92,0x4c,0x02,0x40]
vprotd %xmm1, 64(%edx,%eax), %xmm1

// CHECK: vprotd %xmm1, (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x92,0x0a]
vprotd %xmm1, (%edx), %xmm1

// CHECK: vprotd %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x92,0xc9]
vprotd %xmm1, %xmm1, %xmm1

// CHECK: vprotq $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc3,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
vprotq $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: vprotq $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc3,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
vprotq $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: vprotq $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc3,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
vprotq $0, 485498096(%edx), %xmm1

// CHECK: vprotq $0, 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc3,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
vprotq $0, 485498096, %xmm1

// CHECK: vprotq $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc3,0x4c,0x02,0x40,0x00]
vprotq $0, 64(%edx,%eax), %xmm1

// CHECK: vprotq $0, (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc3,0x0a,0x00]
vprotq $0, (%edx), %xmm1

// CHECK: vprotq $0, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc3,0xc9,0x00]
vprotq $0, %xmm1, %xmm1

// CHECK: vprotq -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x93,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vprotq -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vprotq 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x93,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vprotq 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vprotq 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x93,0x8a,0xf0,0x1c,0xf0,0x1c]
vprotq 485498096(%edx), %xmm1, %xmm1

// CHECK: vprotq 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x93,0x0d,0xf0,0x1c,0xf0,0x1c]
vprotq 485498096, %xmm1, %xmm1

// CHECK: vprotq 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x93,0x4c,0x02,0x40]
vprotq 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vprotq (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x93,0x0a]
vprotq (%edx), %xmm1, %xmm1

// CHECK: vprotq %xmm1, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x93,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vprotq %xmm1, -485498096(%edx,%eax,4), %xmm1

// CHECK: vprotq %xmm1, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x93,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vprotq %xmm1, 485498096(%edx,%eax,4), %xmm1

// CHECK: vprotq %xmm1, 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x93,0x8a,0xf0,0x1c,0xf0,0x1c]
vprotq %xmm1, 485498096(%edx), %xmm1

// CHECK: vprotq %xmm1, 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x93,0x0d,0xf0,0x1c,0xf0,0x1c]
vprotq %xmm1, 485498096, %xmm1

// CHECK: vprotq %xmm1, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x93,0x4c,0x02,0x40]
vprotq %xmm1, 64(%edx,%eax), %xmm1

// CHECK: vprotq %xmm1, (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x93,0x0a]
vprotq %xmm1, (%edx), %xmm1

// CHECK: vprotq %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x93,0xc9]
vprotq %xmm1, %xmm1, %xmm1

// CHECK: vprotw $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc1,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
vprotw $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: vprotw $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc1,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
vprotw $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: vprotw $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc1,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
vprotw $0, 485498096(%edx), %xmm1

// CHECK: vprotw $0, 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc1,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
vprotw $0, 485498096, %xmm1

// CHECK: vprotw $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc1,0x4c,0x02,0x40,0x00]
vprotw $0, 64(%edx,%eax), %xmm1

// CHECK: vprotw $0, (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc1,0x0a,0x00]
vprotw $0, (%edx), %xmm1

// CHECK: vprotw $0, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe8,0x78,0xc1,0xc9,0x00]
vprotw $0, %xmm1, %xmm1

// CHECK: vprotw -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x91,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vprotw -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vprotw 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x91,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vprotw 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vprotw 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x91,0x8a,0xf0,0x1c,0xf0,0x1c]
vprotw 485498096(%edx), %xmm1, %xmm1

// CHECK: vprotw 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x91,0x0d,0xf0,0x1c,0xf0,0x1c]
vprotw 485498096, %xmm1, %xmm1

// CHECK: vprotw 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x91,0x4c,0x02,0x40]
vprotw 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vprotw (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x91,0x0a]
vprotw (%edx), %xmm1, %xmm1

// CHECK: vprotw %xmm1, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x91,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vprotw %xmm1, -485498096(%edx,%eax,4), %xmm1

// CHECK: vprotw %xmm1, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x91,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vprotw %xmm1, 485498096(%edx,%eax,4), %xmm1

// CHECK: vprotw %xmm1, 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x91,0x8a,0xf0,0x1c,0xf0,0x1c]
vprotw %xmm1, 485498096(%edx), %xmm1

// CHECK: vprotw %xmm1, 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x91,0x0d,0xf0,0x1c,0xf0,0x1c]
vprotw %xmm1, 485498096, %xmm1

// CHECK: vprotw %xmm1, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x91,0x4c,0x02,0x40]
vprotw %xmm1, 64(%edx,%eax), %xmm1

// CHECK: vprotw %xmm1, (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x91,0x0a]
vprotw %xmm1, (%edx), %xmm1

// CHECK: vprotw %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x91,0xc9]
vprotw %xmm1, %xmm1, %xmm1

// CHECK: vpshab -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x98,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vpshab -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpshab 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x98,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vpshab 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpshab 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x98,0x8a,0xf0,0x1c,0xf0,0x1c]
vpshab 485498096(%edx), %xmm1, %xmm1

// CHECK: vpshab 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x98,0x0d,0xf0,0x1c,0xf0,0x1c]
vpshab 485498096, %xmm1, %xmm1

// CHECK: vpshab 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x98,0x4c,0x02,0x40]
vpshab 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpshab (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x98,0x0a]
vpshab (%edx), %xmm1, %xmm1

// CHECK: vpshab %xmm1, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x98,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vpshab %xmm1, -485498096(%edx,%eax,4), %xmm1

// CHECK: vpshab %xmm1, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x98,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vpshab %xmm1, 485498096(%edx,%eax,4), %xmm1

// CHECK: vpshab %xmm1, 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x98,0x8a,0xf0,0x1c,0xf0,0x1c]
vpshab %xmm1, 485498096(%edx), %xmm1

// CHECK: vpshab %xmm1, 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x98,0x0d,0xf0,0x1c,0xf0,0x1c]
vpshab %xmm1, 485498096, %xmm1

// CHECK: vpshab %xmm1, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x98,0x4c,0x02,0x40]
vpshab %xmm1, 64(%edx,%eax), %xmm1

// CHECK: vpshab %xmm1, (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x98,0x0a]
vpshab %xmm1, (%edx), %xmm1

// CHECK: vpshab %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x98,0xc9]
vpshab %xmm1, %xmm1, %xmm1

// CHECK: vpshad -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x9a,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vpshad -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpshad 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x9a,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vpshad 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpshad 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x9a,0x8a,0xf0,0x1c,0xf0,0x1c]
vpshad 485498096(%edx), %xmm1, %xmm1

// CHECK: vpshad 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x9a,0x0d,0xf0,0x1c,0xf0,0x1c]
vpshad 485498096, %xmm1, %xmm1

// CHECK: vpshad 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x9a,0x4c,0x02,0x40]
vpshad 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpshad (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x9a,0x0a]
vpshad (%edx), %xmm1, %xmm1

// CHECK: vpshad %xmm1, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x9a,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vpshad %xmm1, -485498096(%edx,%eax,4), %xmm1

// CHECK: vpshad %xmm1, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x9a,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vpshad %xmm1, 485498096(%edx,%eax,4), %xmm1

// CHECK: vpshad %xmm1, 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x9a,0x8a,0xf0,0x1c,0xf0,0x1c]
vpshad %xmm1, 485498096(%edx), %xmm1

// CHECK: vpshad %xmm1, 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x9a,0x0d,0xf0,0x1c,0xf0,0x1c]
vpshad %xmm1, 485498096, %xmm1

// CHECK: vpshad %xmm1, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x9a,0x4c,0x02,0x40]
vpshad %xmm1, 64(%edx,%eax), %xmm1

// CHECK: vpshad %xmm1, (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x9a,0x0a]
vpshad %xmm1, (%edx), %xmm1

// CHECK: vpshad %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x9a,0xc9]
vpshad %xmm1, %xmm1, %xmm1

// CHECK: vpshaq -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x9b,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vpshaq -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpshaq 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x9b,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vpshaq 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpshaq 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x9b,0x8a,0xf0,0x1c,0xf0,0x1c]
vpshaq 485498096(%edx), %xmm1, %xmm1

// CHECK: vpshaq 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x9b,0x0d,0xf0,0x1c,0xf0,0x1c]
vpshaq 485498096, %xmm1, %xmm1

// CHECK: vpshaq 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x9b,0x4c,0x02,0x40]
vpshaq 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpshaq (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x9b,0x0a]
vpshaq (%edx), %xmm1, %xmm1

// CHECK: vpshaq %xmm1, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x9b,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vpshaq %xmm1, -485498096(%edx,%eax,4), %xmm1

// CHECK: vpshaq %xmm1, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x9b,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vpshaq %xmm1, 485498096(%edx,%eax,4), %xmm1

// CHECK: vpshaq %xmm1, 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x9b,0x8a,0xf0,0x1c,0xf0,0x1c]
vpshaq %xmm1, 485498096(%edx), %xmm1

// CHECK: vpshaq %xmm1, 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x9b,0x0d,0xf0,0x1c,0xf0,0x1c]
vpshaq %xmm1, 485498096, %xmm1

// CHECK: vpshaq %xmm1, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x9b,0x4c,0x02,0x40]
vpshaq %xmm1, 64(%edx,%eax), %xmm1

// CHECK: vpshaq %xmm1, (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x9b,0x0a]
vpshaq %xmm1, (%edx), %xmm1

// CHECK: vpshaq %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x9b,0xc9]
vpshaq %xmm1, %xmm1, %xmm1

// CHECK: vpshaw -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x99,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vpshaw -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpshaw 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x99,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vpshaw 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpshaw 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x99,0x8a,0xf0,0x1c,0xf0,0x1c]
vpshaw 485498096(%edx), %xmm1, %xmm1

// CHECK: vpshaw 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x99,0x0d,0xf0,0x1c,0xf0,0x1c]
vpshaw 485498096, %xmm1, %xmm1

// CHECK: vpshaw 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x99,0x4c,0x02,0x40]
vpshaw 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpshaw (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x99,0x0a]
vpshaw (%edx), %xmm1, %xmm1

// CHECK: vpshaw %xmm1, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x99,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vpshaw %xmm1, -485498096(%edx,%eax,4), %xmm1

// CHECK: vpshaw %xmm1, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x99,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vpshaw %xmm1, 485498096(%edx,%eax,4), %xmm1

// CHECK: vpshaw %xmm1, 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x99,0x8a,0xf0,0x1c,0xf0,0x1c]
vpshaw %xmm1, 485498096(%edx), %xmm1

// CHECK: vpshaw %xmm1, 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x99,0x0d,0xf0,0x1c,0xf0,0x1c]
vpshaw %xmm1, 485498096, %xmm1

// CHECK: vpshaw %xmm1, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x99,0x4c,0x02,0x40]
vpshaw %xmm1, 64(%edx,%eax), %xmm1

// CHECK: vpshaw %xmm1, (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x99,0x0a]
vpshaw %xmm1, (%edx), %xmm1

// CHECK: vpshaw %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x99,0xc9]
vpshaw %xmm1, %xmm1, %xmm1

// CHECK: vpshlb -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x94,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vpshlb -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpshlb 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x94,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vpshlb 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpshlb 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x94,0x8a,0xf0,0x1c,0xf0,0x1c]
vpshlb 485498096(%edx), %xmm1, %xmm1

// CHECK: vpshlb 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x94,0x0d,0xf0,0x1c,0xf0,0x1c]
vpshlb 485498096, %xmm1, %xmm1

// CHECK: vpshlb 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x94,0x4c,0x02,0x40]
vpshlb 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpshlb (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x94,0x0a]
vpshlb (%edx), %xmm1, %xmm1

// CHECK: vpshlb %xmm1, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x94,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vpshlb %xmm1, -485498096(%edx,%eax,4), %xmm1

// CHECK: vpshlb %xmm1, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x94,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vpshlb %xmm1, 485498096(%edx,%eax,4), %xmm1

// CHECK: vpshlb %xmm1, 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x94,0x8a,0xf0,0x1c,0xf0,0x1c]
vpshlb %xmm1, 485498096(%edx), %xmm1

// CHECK: vpshlb %xmm1, 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x94,0x0d,0xf0,0x1c,0xf0,0x1c]
vpshlb %xmm1, 485498096, %xmm1

// CHECK: vpshlb %xmm1, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x94,0x4c,0x02,0x40]
vpshlb %xmm1, 64(%edx,%eax), %xmm1

// CHECK: vpshlb %xmm1, (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x94,0x0a]
vpshlb %xmm1, (%edx), %xmm1

// CHECK: vpshlb %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x94,0xc9]
vpshlb %xmm1, %xmm1, %xmm1

// CHECK: vpshld -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x96,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vpshld -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpshld 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x96,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vpshld 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpshld 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x96,0x8a,0xf0,0x1c,0xf0,0x1c]
vpshld 485498096(%edx), %xmm1, %xmm1

// CHECK: vpshld 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x96,0x0d,0xf0,0x1c,0xf0,0x1c]
vpshld 485498096, %xmm1, %xmm1

// CHECK: vpshld 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x96,0x4c,0x02,0x40]
vpshld 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpshld (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x96,0x0a]
vpshld (%edx), %xmm1, %xmm1

// CHECK: vpshld %xmm1, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x96,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vpshld %xmm1, -485498096(%edx,%eax,4), %xmm1

// CHECK: vpshld %xmm1, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x96,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vpshld %xmm1, 485498096(%edx,%eax,4), %xmm1

// CHECK: vpshld %xmm1, 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x96,0x8a,0xf0,0x1c,0xf0,0x1c]
vpshld %xmm1, 485498096(%edx), %xmm1

// CHECK: vpshld %xmm1, 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x96,0x0d,0xf0,0x1c,0xf0,0x1c]
vpshld %xmm1, 485498096, %xmm1

// CHECK: vpshld %xmm1, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x96,0x4c,0x02,0x40]
vpshld %xmm1, 64(%edx,%eax), %xmm1

// CHECK: vpshld %xmm1, (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x96,0x0a]
vpshld %xmm1, (%edx), %xmm1

// CHECK: vpshld %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x96,0xc9]
vpshld %xmm1, %xmm1, %xmm1

// CHECK: vpshlq -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x97,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vpshlq -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpshlq 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x97,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vpshlq 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpshlq 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x97,0x8a,0xf0,0x1c,0xf0,0x1c]
vpshlq 485498096(%edx), %xmm1, %xmm1

// CHECK: vpshlq 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x97,0x0d,0xf0,0x1c,0xf0,0x1c]
vpshlq 485498096, %xmm1, %xmm1

// CHECK: vpshlq 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x97,0x4c,0x02,0x40]
vpshlq 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpshlq (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x97,0x0a]
vpshlq (%edx), %xmm1, %xmm1

// CHECK: vpshlq %xmm1, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x97,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vpshlq %xmm1, -485498096(%edx,%eax,4), %xmm1

// CHECK: vpshlq %xmm1, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x97,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vpshlq %xmm1, 485498096(%edx,%eax,4), %xmm1

// CHECK: vpshlq %xmm1, 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x97,0x8a,0xf0,0x1c,0xf0,0x1c]
vpshlq %xmm1, 485498096(%edx), %xmm1

// CHECK: vpshlq %xmm1, 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x97,0x0d,0xf0,0x1c,0xf0,0x1c]
vpshlq %xmm1, 485498096, %xmm1

// CHECK: vpshlq %xmm1, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x97,0x4c,0x02,0x40]
vpshlq %xmm1, 64(%edx,%eax), %xmm1

// CHECK: vpshlq %xmm1, (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x97,0x0a]
vpshlq %xmm1, (%edx), %xmm1

// CHECK: vpshlq %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x97,0xc9]
vpshlq %xmm1, %xmm1, %xmm1

// CHECK: vpshlw -485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x95,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vpshlw -485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpshlw 485498096(%edx,%eax,4), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x95,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vpshlw 485498096(%edx,%eax,4), %xmm1, %xmm1

// CHECK: vpshlw 485498096(%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x95,0x8a,0xf0,0x1c,0xf0,0x1c]
vpshlw 485498096(%edx), %xmm1, %xmm1

// CHECK: vpshlw 485498096, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x95,0x0d,0xf0,0x1c,0xf0,0x1c]
vpshlw 485498096, %xmm1, %xmm1

// CHECK: vpshlw 64(%edx,%eax), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x95,0x4c,0x02,0x40]
vpshlw 64(%edx,%eax), %xmm1, %xmm1

// CHECK: vpshlw (%edx), %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0xf0,0x95,0x0a]
vpshlw (%edx), %xmm1, %xmm1

// CHECK: vpshlw %xmm1, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x95,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
vpshlw %xmm1, -485498096(%edx,%eax,4), %xmm1

// CHECK: vpshlw %xmm1, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x95,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
vpshlw %xmm1, 485498096(%edx,%eax,4), %xmm1

// CHECK: vpshlw %xmm1, 485498096(%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x95,0x8a,0xf0,0x1c,0xf0,0x1c]
vpshlw %xmm1, 485498096(%edx), %xmm1

// CHECK: vpshlw %xmm1, 485498096, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x95,0x0d,0xf0,0x1c,0xf0,0x1c]
vpshlw %xmm1, 485498096, %xmm1

// CHECK: vpshlw %xmm1, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x95,0x4c,0x02,0x40]
vpshlw %xmm1, 64(%edx,%eax), %xmm1

// CHECK: vpshlw %xmm1, (%edx), %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x95,0x0a]
vpshlw %xmm1, (%edx), %xmm1

// CHECK: vpshlw %xmm1, %xmm1, %xmm1
// CHECK: encoding: [0x8f,0xe9,0x70,0x95,0xc9]
vpshlw %xmm1, %xmm1, %xmm1

