; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; Verify that strlen calls with variable offsets into elements of constant
; arrays are folded.
;
; TODO: None of these cases is folded at the moment due to a limitation
; in LibCallSimplifier::optimizeStringLength.
;
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare i64 @strlen(ptr)

@a5_4 = constant [5 x [4 x i8]] [[4 x i8] c"123\00", [4 x i8] c"12\00\00", [4 x i8] c"1\00\00\00", [4 x i8] zeroinitializer, [4 x i8] zeroinitializer]


; Fold strlen(&a5_4[0][I]) to I <= 3 ? 3 - I : 0.

define i64 @fold_a5_4_i0_pI(i64 %I) {
; CHECK-LABEL: @fold_a5_4_i0_pI(
; CHECK-NEXT:    [[PTR:%.*]] = getelementptr [5 x [4 x i8]], ptr @a5_4, i64 0, i64 0, i64 [[I:%.*]]
; CHECK-NEXT:    [[LEN:%.*]] = call i64 @strlen(ptr noundef nonnull dereferenceable(1) [[PTR]])
; CHECK-NEXT:    ret i64 [[LEN]]
;
  %ptr = getelementptr [5 x [4 x i8]], ptr @a5_4, i64 0, i64 0, i64 %I
  %len = call i64 @strlen(ptr %ptr)
  ret i64 %len
}


; Fold strlen(&a5_4[1][I]) to I <= 2 ? 2 - I : 0.

define i64 @fold_a5_4_i1_pI(i64 %I) {
; CHECK-LABEL: @fold_a5_4_i1_pI(
; CHECK-NEXT:    [[PTR:%.*]] = getelementptr [5 x [4 x i8]], ptr @a5_4, i64 0, i64 1, i64 [[I:%.*]]
; CHECK-NEXT:    [[LEN:%.*]] = call i64 @strlen(ptr noundef nonnull dereferenceable(1) [[PTR]])
; CHECK-NEXT:    ret i64 [[LEN]]
;
  %ptr = getelementptr [5 x [4 x i8]], ptr @a5_4, i64 0, i64 1, i64 %I
  %len = call i64 @strlen(ptr %ptr)
  ret i64 %len
}


; Fold strlen(&a5_4[2][I]) to i <= 1 ? 1 - I : 0.

define i64 @fold_a5_4_i2_pI(i64 %I) {
; CHECK-LABEL: @fold_a5_4_i2_pI(
; CHECK-NEXT:    [[PTR:%.*]] = getelementptr [5 x [4 x i8]], ptr @a5_4, i64 0, i64 2, i64 [[I:%.*]]
; CHECK-NEXT:    [[LEN:%.*]] = call i64 @strlen(ptr noundef nonnull dereferenceable(1) [[PTR]])
; CHECK-NEXT:    ret i64 [[LEN]]
;
  %ptr = getelementptr [5 x [4 x i8]], ptr @a5_4, i64 0, i64 2, i64 %I
  %len = call i64 @strlen(ptr %ptr)
  ret i64 %len
}


; Fold strlen(&a5_4[3][I]) to 0.

define i64 @fold_a5_4_i3_pI_to_0(i64 %I) {
; CHECK-LABEL: @fold_a5_4_i3_pI_to_0(
; CHECK-NEXT:    [[PTR:%.*]] = getelementptr [5 x [4 x i8]], ptr @a5_4, i64 0, i64 3, i64 [[I:%.*]]
; CHECK-NEXT:    [[LEN:%.*]] = call i64 @strlen(ptr noundef nonnull dereferenceable(1) [[PTR]])
; CHECK-NEXT:    ret i64 [[LEN]]
;
  %ptr = getelementptr [5 x [4 x i8]], ptr @a5_4, i64 0, i64 3, i64 %I
  %len = call i64 @strlen(ptr %ptr)
  ret i64 %len
}


; Fold strlen(&a5_4[4][I]) to 0.

define i64 @fold_a5_4_i4_pI_to_0(i64 %I) {
; CHECK-LABEL: @fold_a5_4_i4_pI_to_0(
; CHECK-NEXT:    [[PTR:%.*]] = getelementptr [5 x [4 x i8]], ptr @a5_4, i64 0, i64 4, i64 [[I:%.*]]
; CHECK-NEXT:    [[LEN:%.*]] = call i64 @strlen(ptr noundef nonnull dereferenceable(1) [[PTR]])
; CHECK-NEXT:    ret i64 [[LEN]]
;
  %ptr = getelementptr [5 x [4 x i8]], ptr @a5_4, i64 0, i64 4, i64 %I
  %len = call i64 @strlen(ptr %ptr)
  ret i64 %len
}
