; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i386-unknown -mattr=+sse2 | FileCheck %s --check-prefix=SSE
; RUN: llc < %s -mtriple=i386-unknown -mattr=+avx  | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=i386-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX256,AVX2
; RUN: llc < %s -mtriple=i386-unknown -mcpu=knl | FileCheck %s --check-prefixes=AVX,AVX256,AVX512
; RUN: llc < %s -mtriple=i386-unknown -mcpu=skx | FileCheck %s --check-prefixes=AVX,AVX256,AVX512
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+sse2 | FileCheck %s --check-prefix=SSE
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+avx  | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX256,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown -mcpu=knl | FileCheck %s --check-prefixes=AVX,AVX256,AVX512
; RUN: llc < %s -mtriple=x86_64-unknown -mcpu=skx | FileCheck %s --check-prefixes=AVX,AVX256,AVX512

define <16 x i8> @allones_v16i8() nounwind {
; SSE-LABEL: allones_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: allones_v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  ret <16 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
}

define <8 x i16> @allones_v8i16() nounwind {
; SSE-LABEL: allones_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: allones_v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  ret <8 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
}

define <4 x i32> @allones_v4i32() nounwind {
; SSE-LABEL: allones_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: allones_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  ret <4 x i32> <i32 -1, i32 -1, i32 -1, i32 -1>
}

define <2 x i64> @allones_v2i64() nounwind {
; SSE-LABEL: allones_v2i64:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: allones_v2i64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  ret <2 x i64> <i64 -1, i64 -1>
}

define <2 x double> @allones_v2f64() nounwind {
; SSE-LABEL: allones_v2f64:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: allones_v2f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  ret <2 x double> <double 0xffffffffffffffff, double 0xffffffffffffffff>
}

define <4 x float> @allones_v4f32() nounwind {
; SSE-LABEL: allones_v4f32:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: allones_v4f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  ret <4 x float> <float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000>
}

define <32 x i8> @allones_v32i8() nounwind {
; SSE-LABEL: allones_v32i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: allones_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vcmptrueps %ymm0, %ymm0, %ymm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX256-LABEL: allones_v32i8:
; AVX256:       # %bb.0:
; AVX256-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX256-NEXT:    ret{{[l|q]}}
  ret <32 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
}

define <16 x i16> @allones_v16i16() nounwind {
; SSE-LABEL: allones_v16i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: allones_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vcmptrueps %ymm0, %ymm0, %ymm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX256-LABEL: allones_v16i16:
; AVX256:       # %bb.0:
; AVX256-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX256-NEXT:    ret{{[l|q]}}
  ret <16 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
}

define <8 x i32> @allones_v8i32() nounwind {
; SSE-LABEL: allones_v8i32:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: allones_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vcmptrueps %ymm0, %ymm0, %ymm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX256-LABEL: allones_v8i32:
; AVX256:       # %bb.0:
; AVX256-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX256-NEXT:    ret{{[l|q]}}
  ret <8 x i32> <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>
}

define <4 x i64> @allones_v4i64() nounwind {
; SSE-LABEL: allones_v4i64:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: allones_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vcmptrueps %ymm0, %ymm0, %ymm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX256-LABEL: allones_v4i64:
; AVX256:       # %bb.0:
; AVX256-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX256-NEXT:    ret{{[l|q]}}
  ret <4 x i64> <i64 -1, i64 -1, i64 -1, i64 -1>
}

define <4 x double> @allones_v4f64() nounwind {
; SSE-LABEL: allones_v4f64:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: allones_v4f64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vcmptrueps %ymm0, %ymm0, %ymm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX256-LABEL: allones_v4f64:
; AVX256:       # %bb.0:
; AVX256-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX256-NEXT:    ret{{[l|q]}}
  ret <4 x double> <double 0xffffffffffffffff, double 0xffffffffffffffff, double 0xffffffffffffffff, double 0xffffffffffffffff>
}

define <4 x double> @allones_v4f64_optsize() nounwind optsize {
; SSE-LABEL: allones_v4f64_optsize:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: allones_v4f64_optsize:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vcmptrueps %ymm0, %ymm0, %ymm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX256-LABEL: allones_v4f64_optsize:
; AVX256:       # %bb.0:
; AVX256-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX256-NEXT:    ret{{[l|q]}}
  ret <4 x double> <double 0xffffffffffffffff, double 0xffffffffffffffff, double 0xffffffffffffffff, double 0xffffffffffffffff>
}

define <8 x float> @allones_v8f32() nounwind {
; SSE-LABEL: allones_v8f32:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: allones_v8f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vcmptrueps %ymm0, %ymm0, %ymm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX256-LABEL: allones_v8f32:
; AVX256:       # %bb.0:
; AVX256-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX256-NEXT:    ret{{[l|q]}}
  ret <8 x float> <float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000>
}

define <8 x float> @allones_v8f32_optsize() nounwind optsize {
; SSE-LABEL: allones_v8f32_optsize:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: allones_v8f32_optsize:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vcmptrueps %ymm0, %ymm0, %ymm0
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX256-LABEL: allones_v8f32_optsize:
; AVX256:       # %bb.0:
; AVX256-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX256-NEXT:    ret{{[l|q]}}
  ret <8 x float> <float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000>
}

define <64 x i8> @allones_v64i8() nounwind {
; SSE-LABEL: allones_v64i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: allones_v64i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vcmptrueps %ymm0, %ymm0, %ymm0
; AVX1-NEXT:    vmovaps %ymm0, %ymm1
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX2-LABEL: allones_v64i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: allones_v64i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0
; AVX512-NEXT:    ret{{[l|q]}}
  ret <64 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
}

define <32 x i16> @allones_v32i16() nounwind {
; SSE-LABEL: allones_v32i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: allones_v32i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vcmptrueps %ymm0, %ymm0, %ymm0
; AVX1-NEXT:    vmovaps %ymm0, %ymm1
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX2-LABEL: allones_v32i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: allones_v32i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0
; AVX512-NEXT:    ret{{[l|q]}}
  ret <32 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
}

define <16 x i32> @allones_v16i32() nounwind {
; SSE-LABEL: allones_v16i32:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: allones_v16i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vcmptrueps %ymm0, %ymm0, %ymm0
; AVX1-NEXT:    vmovaps %ymm0, %ymm1
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX2-LABEL: allones_v16i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: allones_v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0
; AVX512-NEXT:    ret{{[l|q]}}
  ret <16 x i32> <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>
}

define <8 x i64> @allones_v8i64() nounwind {
; SSE-LABEL: allones_v8i64:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: allones_v8i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vcmptrueps %ymm0, %ymm0, %ymm0
; AVX1-NEXT:    vmovaps %ymm0, %ymm1
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX2-LABEL: allones_v8i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: allones_v8i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0
; AVX512-NEXT:    ret{{[l|q]}}
  ret <8 x i64> <i64 -1, i64 -1, i64 -1, i64 -1, i64 -1, i64 -1, i64 -1, i64 -1>
}

define <8 x double> @allones_v8f64() nounwind {
; SSE-LABEL: allones_v8f64:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: allones_v8f64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vcmptrueps %ymm0, %ymm0, %ymm0
; AVX1-NEXT:    vmovaps %ymm0, %ymm1
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX2-LABEL: allones_v8f64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: allones_v8f64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0
; AVX512-NEXT:    ret{{[l|q]}}
  ret <8 x double> <double 0xffffffffffffffff, double 0xffffffffffffffff, double 0xffffffffffffffff, double 0xffffffffffffffff, double 0xffffffffffffffff, double 0xffffffffffffffff, double 0xffffffffffffffff, double 0xffffffffffffffff>
}

define <16 x float> @allones_v16f32() nounwind {
; SSE-LABEL: allones_v16f32:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: allones_v16f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vcmptrueps %ymm0, %ymm0, %ymm0
; AVX1-NEXT:    vmovaps %ymm0, %ymm1
; AVX1-NEXT:    ret{{[l|q]}}
;
; AVX2-LABEL: allones_v16f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    ret{{[l|q]}}
;
; AVX512-LABEL: allones_v16f32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0
; AVX512-NEXT:    ret{{[l|q]}}
  ret <16 x float> <float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000, float 0xffffffffe0000000>
}
