; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; Test vector intrinsics added with z17.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z17 | FileCheck %s

declare <16 x i8> @llvm.s390.vgemb(<8 x i16>)
declare <8 x i16> @llvm.s390.vgemh(<16 x i8>)
declare <4 x i32> @llvm.s390.vgemf(<16 x i8>)
declare <2 x i64> @llvm.s390.vgemg(<16 x i8>)
declare i128 @llvm.s390.vgemq(<16 x i8>)

declare i128 @llvm.s390.vuphg(<2 x i64>)
declare i128 @llvm.s390.vuplhg(<2 x i64>)
declare i128 @llvm.s390.vuplg(<2 x i64>)
declare i128 @llvm.s390.vupllg(<2 x i64>)

declare i128 @llvm.s390.vavgq(i128, i128)
declare i128 @llvm.s390.vavglq(i128, i128)

declare <16 x i8> @llvm.s390.veval(<16 x i8>, <16 x i8>, <16 x i8>, i32)

declare <2 x i64> @llvm.s390.vmahg(<2 x i64>, <2 x i64>, <2 x i64>)
declare i128 @llvm.s390.vmahq(i128, i128, i128)
declare <2 x i64> @llvm.s390.vmalhg(<2 x i64>, <2 x i64>, <2 x i64>)
declare i128 @llvm.s390.vmalhq(i128, i128, i128)

declare i128 @llvm.s390.vmaeg(<2 x i64>, <2 x i64>, i128)
declare i128 @llvm.s390.vmaleg(<2 x i64>, <2 x i64>, i128)
declare i128 @llvm.s390.vmaog(<2 x i64>, <2 x i64>, i128)
declare i128 @llvm.s390.vmalog(<2 x i64>, <2 x i64>, i128)

declare <2 x i64> @llvm.s390.vmhg(<2 x i64>, <2 x i64>)
declare i128 @llvm.s390.vmhq(i128, i128)
declare <2 x i64> @llvm.s390.vmlhg(<2 x i64>, <2 x i64>)
declare i128 @llvm.s390.vmlhq(i128, i128)

declare i128 @llvm.s390.vmeg(<2 x i64>, <2 x i64>)
declare i128 @llvm.s390.vmleg(<2 x i64>, <2 x i64>)
declare i128 @llvm.s390.vmog(<2 x i64>, <2 x i64>)
declare i128 @llvm.s390.vmlog(<2 x i64>, <2 x i64>)

declare {i128, i32} @llvm.s390.vceqqs(i128, i128)
declare {i128, i32} @llvm.s390.vchqs(i128, i128)
declare {i128, i32} @llvm.s390.vchlqs(i128, i128)

; VGEMB.
define <16 x i8> @test_vgemb(<8 x i16> %a) {
; CHECK-LABEL: test_vgemb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgemb %v24, %v24
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vgemb(<8 x i16> %a)
  ret <16 x i8> %res
}

; VGEMH.
define <8 x i16> @test_vgemh(<16 x i8> %a) {
; CHECK-LABEL: test_vgemh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgemh %v24, %v24
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vgemh(<16 x i8> %a)
  ret <8 x i16> %res
}

; VGEMF.
define <4 x i32> @test_vgemf(<16 x i8> %a) {
; CHECK-LABEL: test_vgemf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgemf %v24, %v24
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vgemf(<16 x i8> %a)
  ret <4 x i32> %res
}

; VGEMG.
define <2 x i64> @test_vgemg(<16 x i8> %a) {
; CHECK-LABEL: test_vgemg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgemg %v24, %v24
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vgemg(<16 x i8> %a)
  ret <2 x i64> %res
}

; VGEMQ.
define i128 @test_vgemq(<16 x i8> %a) {
; CHECK-LABEL: test_vgemq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgemq %v0, %v24
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vgemq(<16 x i8> %a)
  ret i128 %res
}

; VUPHG.
define i128 @test_vuphg(<2 x i64> %a) {
; CHECK-LABEL: test_vuphg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vuphg %v0, %v24
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vuphg(<2 x i64> %a)
  ret i128 %res
}

; VUPLHG.
define i128 @test_vuplhg(<2 x i64> %a) {
; CHECK-LABEL: test_vuplhg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vuplhg %v0, %v24
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vuplhg(<2 x i64> %a)
  ret i128 %res
}

; VUPLG.
define i128 @test_vuplg(<2 x i64> %a) {
; CHECK-LABEL: test_vuplg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vuplg %v0, %v24
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vuplg(<2 x i64> %a)
  ret i128 %res
}

; VUPLLG.
define i128 @test_vupllg(<2 x i64> %a) {
; CHECK-LABEL: test_vupllg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vupllg %v0, %v24
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vupllg(<2 x i64> %a)
  ret i128 %res
}

; VAVGQ.
define i128 @test_vavgq(i128 %a, i128 %b) {
; CHECK-LABEL: test_vavgq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vavgq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vavgq(i128 %a, i128 %b)
  ret i128 %res
}

; VAVGLQ.
define i128 @test_vavglq(i128 %a, i128 %b) {
; CHECK-LABEL: test_vavglq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vavglq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vavglq(i128 %a, i128 %b)
  ret i128 %res
}

; VEVAL.
define <16 x i8> @test_veval(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c) {
; CHECK-LABEL: test_veval:
; CHECK:       # %bb.0:
; CHECK-NEXT:    veval %v24, %v24, %v26, %v28, 123
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.veval(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c, i32 123)
  ret <16 x i8> %res
}

; VMAHG.
define <2 x i64> @test_vmahg(<2 x i64> %a, <2 x i64> %b, <2 x i64> %c) {
; CHECK-LABEL: test_vmahg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmahg %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vmahg(<2 x i64> %a, <2 x i64> %b,
                                         <2 x i64> %c)
  ret <2 x i64> %res
}

; VMAHQ.
define i128 @test_vmahq(i128 %a, i128 %b, i128 %c) {
; CHECK-LABEL: test_vmahq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r5), 3
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    vl %v2, 0(%r3), 3
; CHECK-NEXT:    vmahq %v0, %v2, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vmahq(i128 %a, i128 %b, i128 %c)
  ret i128 %res
}

; VMALHG.
define <2 x i64> @test_vmalhg(<2 x i64> %a, <2 x i64> %b, <2 x i64> %c) {
; CHECK-LABEL: test_vmalhg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmalhg %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vmalhg(<2 x i64> %a, <2 x i64> %b,
                                          <2 x i64> %c)
  ret <2 x i64> %res
}

; VMALHQ.
define i128 @test_vmalhq(i128 %a, i128 %b, i128 %c) {
; CHECK-LABEL: test_vmalhq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r5), 3
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    vl %v2, 0(%r3), 3
; CHECK-NEXT:    vmalhq %v0, %v2, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vmalhq(i128 %a, i128 %b, i128 %c)
  ret i128 %res
}

; VMAEG.
define i128 @test_vmaeg(<2 x i64> %a, <2 x i64> %b, i128 %c) {
; CHECK-LABEL: test_vmaeg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vmaeg %v0, %v24, %v26, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vmaeg(<2 x i64> %a, <2 x i64> %b, i128 %c)
  ret i128 %res
}

; VMALEG.
define i128 @test_vmaleg(<2 x i64> %a, <2 x i64> %b, i128 %c) {
; CHECK-LABEL: test_vmaleg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vmaleg %v0, %v24, %v26, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vmaleg(<2 x i64> %a, <2 x i64> %b, i128 %c)
  ret i128 %res
}

; VMAOG.
define i128 @test_vmaog(<2 x i64> %a, <2 x i64> %b, i128 %c) {
; CHECK-LABEL: test_vmaog:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vmaog %v0, %v24, %v26, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vmaog(<2 x i64> %a, <2 x i64> %b, i128 %c)
  ret i128 %res
}

; VMALOG.
define i128 @test_vmalog(<2 x i64> %a, <2 x i64> %b, i128 %c) {
; CHECK-LABEL: test_vmalog:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vmalog %v0, %v24, %v26, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vmalog(<2 x i64> %a, <2 x i64> %b, i128 %c)
  ret i128 %res
}

; VMHG.
define <2 x i64> @test_vmhg(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_vmhg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmhg %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vmhg(<2 x i64> %a, <2 x i64> %b)
  ret <2 x i64> %res
}

; VMHQ.
define i128 @test_vmhq(i128 %a, i128 %b) {
; CHECK-LABEL: test_vmhq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vmhq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vmhq(i128 %a, i128 %b)
  ret i128 %res
}

; VMLHG.
define <2 x i64> @test_vmlhg(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_vmlhg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmlhg %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vmlhg(<2 x i64> %a, <2 x i64> %b)
  ret <2 x i64> %res
}

; VMLHQ.
define i128 @test_vmlhq(i128 %a, i128 %b) {
; CHECK-LABEL: test_vmlhq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vmlhq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vmlhq(i128 %a, i128 %b)
  ret i128 %res
}

; VMEG.
define i128 @test_vmeg(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_vmeg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmeg %v0, %v24, %v26
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vmeg(<2 x i64> %a, <2 x i64> %b)
  ret i128 %res
}

; VMLEG.
define i128 @test_vmleg(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_vmleg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmleg %v0, %v24, %v26
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vmleg(<2 x i64> %a, <2 x i64> %b)
  ret i128 %res
}

; VMOG.
define i128 @test_vmog(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_vmog:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmog %v0, %v24, %v26
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vmog(<2 x i64> %a, <2 x i64> %b)
  ret i128 %res
}

; VMLOG.
define i128 @test_vmlog(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_vmlog:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmlog %v0, %v24, %v26
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vmlog(<2 x i64> %a, <2 x i64> %b)
  ret i128 %res
}

; VCEQGS with no processing of the result.
define i32 @test_vceqqs(i128 %a, i128 %b) {
; CHECK-LABEL: test_vceqqs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r2), 3
; CHECK-NEXT:    vceqqs %v0, %v1, %v0
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    srl %r2, 28
; CHECK-NEXT:    br %r14
  %call = call {i128, i32} @llvm.s390.vceqqs(i128 %a, i128 %b)
  %res = extractvalue {i128, i32} %call, 1
  ret i32 %res
}

; VCEQGS returning 1 if all elements are equal (CC == 0).
define i32 @test_vceqqs_all_bool(i128 %a, i128 %b) {
; CHECK-LABEL: test_vceqqs_all_bool:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r2), 3
; CHECK-NEXT:    vceqqs %v0, %v1, %v0
; CHECK-NEXT:    lhi %r2, 0
; CHECK-NEXT:    lochie %r2, 1
; CHECK-NEXT:    br %r14
  %call = call {i128, i32} @llvm.s390.vceqqs(i128 %a, i128 %b)
  %res = extractvalue {i128, i32} %call, 1
  %cmp = icmp ult i32 %res, 1
  %ext = zext i1 %cmp to i32
  ret i32 %ext
}

; VCEQGS, storing to %ptr if all elements are equal.
define i128 @test_vceqqs_all_store(i128 %a, i128 %b, ptr %ptr) {
; CHECK-LABEL: test_vceqqs_all_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vceqqs %v0, %v1, %v0
; CHECK-NEXT:    jnhe .LBB30_2
; CHECK-NEXT:  # %bb.1: # %store
; CHECK-NEXT:    mvhi 0(%r5), 0
; CHECK-NEXT:  .LBB30_2: # %exit
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %call = call {i128, i32} @llvm.s390.vceqqs(i128 %a, i128 %b)
  %res = extractvalue {i128, i32} %call, 0
  %cc = extractvalue {i128, i32} %call, 1
  %cmp = icmp sle i32 %cc, 0
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret i128 %res
}

; VCHGS with no processing of the result.
define i32 @test_vchqs(i128 %a, i128 %b) {
; CHECK-LABEL: test_vchqs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r2), 3
; CHECK-NEXT:    vchqs %v0, %v1, %v0
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    srl %r2, 28
; CHECK-NEXT:    br %r14
  %call = call {i128, i32} @llvm.s390.vchqs(i128 %a, i128 %b)
  %res = extractvalue {i128, i32} %call, 1
  ret i32 %res
}

; VCHGS returning 1 if all elements are higher (CC == 0).
define i32 @test_vchqs_all_bool(i128 %a, i128 %b) {
; CHECK-LABEL: test_vchqs_all_bool:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r2), 3
; CHECK-NEXT:    vchqs %v0, %v1, %v0
; CHECK-NEXT:    lhi %r2, 0
; CHECK-NEXT:    lochie %r2, 1
; CHECK-NEXT:    br %r14
  %call = call {i128, i32} @llvm.s390.vchqs(i128 %a, i128 %b)
  %res = extractvalue {i128, i32} %call, 1
  %cmp = icmp ult i32 %res, 1
  %ext = zext i1 %cmp to i32
  ret i32 %ext
}

; VCHGS, storing to %ptr if all elements are higher.
define i128 @test_vchqs_all_store(i128 %a, i128 %b, ptr %ptr) {
; CHECK-LABEL: test_vchqs_all_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vchqs %v0, %v1, %v0
; CHECK-NEXT:    jnhe .LBB33_2
; CHECK-NEXT:  # %bb.1: # %store
; CHECK-NEXT:    mvhi 0(%r5), 0
; CHECK-NEXT:  .LBB33_2: # %exit
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %call = call {i128, i32} @llvm.s390.vchqs(i128 %a, i128 %b)
  %res = extractvalue {i128, i32} %call, 0
  %cc = extractvalue {i128, i32} %call, 1
  %cmp = icmp sle i32 %cc, 0
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret i128 %res
}

; VCHLQS with no processing of the result.
define i32 @test_vchlqs(i128 %a, i128 %b) {
; CHECK-LABEL: test_vchlqs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r2), 3
; CHECK-NEXT:    vchlqs %v0, %v1, %v0
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    srl %r2, 28
; CHECK-NEXT:    br %r14
  %call = call {i128, i32} @llvm.s390.vchlqs(i128 %a, i128 %b)
  %res = extractvalue {i128, i32} %call, 1
  ret i32 %res
}

; VCHLQS returning 1 if all elements are higher (CC == 0).
define i32 @test_vchlqs_all_bool(i128 %a, i128 %b) {
; CHECK-LABEL: test_vchlqs_all_bool:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r2), 3
; CHECK-NEXT:    vchlqs %v0, %v1, %v0
; CHECK-NEXT:    lhi %r2, 0
; CHECK-NEXT:    lochie %r2, 1
; CHECK-NEXT:    br %r14
  %call = call {i128, i32} @llvm.s390.vchlqs(i128 %a, i128 %b)
  %res = extractvalue {i128, i32} %call, 1
  %cmp = icmp slt i32 %res, 1
  %ext = zext i1 %cmp to i32
  ret i32 %ext
}

; VCHLQS, storing to %ptr if all elements are higher.
define i128 @test_vchlqs_all_store(i128 %a, i128 %b, ptr %ptr) {
; CHECK-LABEL: test_vchlqs_all_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vchlqs %v0, %v1, %v0
; CHECK-NEXT:    jnhe .LBB36_2
; CHECK-NEXT:  # %bb.1: # %store
; CHECK-NEXT:    mvhi 0(%r5), 0
; CHECK-NEXT:  .LBB36_2: # %exit
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %call = call {i128, i32} @llvm.s390.vchlqs(i128 %a, i128 %b)
  %res = extractvalue {i128, i32} %call, 0
  %cc = extractvalue {i128, i32} %call, 1
  %cmp = icmp ule i32 %cc, 0
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret i128 %res
}

