; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main -mattr=+mve -verify-machineinstrs -o - %s | FileCheck %s --check-prefixes=CHECK,CHECK-LE
; RUN: llc -mtriple=thumbebv8.1m.main -mattr=+mve -verify-machineinstrs -o - %s | FileCheck %s --check-prefixes=CHECK,CHECK-BE

define arm_aapcs_vfpcc <8 x i16> @test_vbicq_n_u16_sh0(<8 x i16> %a) {
; CHECK-LE-LABEL: test_vbicq_n_u16_sh0:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vbic.i16 q0, #0x64
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vbicq_n_u16_sh0:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.16 q1, q0
; CHECK-BE-NEXT:    vbic.i16 q1, #0x64
; CHECK-BE-NEXT:    vrev64.16 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = and <8 x i16> %a, <i16 -101, i16 -101, i16 -101, i16 -101, i16 -101, i16 -101, i16 -101, i16 -101>
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <8 x i16> @test_vbicq_n_u16_sh8(<8 x i16> %a) {
; CHECK-LE-LABEL: test_vbicq_n_u16_sh8:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vbic.i16 q0, #0x6400
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vbicq_n_u16_sh8:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.16 q1, q0
; CHECK-BE-NEXT:    vbic.i16 q1, #0x6400
; CHECK-BE-NEXT:    vrev64.16 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = and <8 x i16> %a, <i16 -25601, i16 -25601, i16 -25601, i16 -25601, i16 -25601, i16 -25601, i16 -25601, i16 -25601>
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vbicq_n_u32_sh0(<4 x i32> %a) {
; CHECK-LE-LABEL: test_vbicq_n_u32_sh0:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vbic.i32 q0, #0x64
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vbicq_n_u32_sh0:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.32 q1, q0
; CHECK-BE-NEXT:    vbic.i32 q1, #0x64
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = and <4 x i32> %a, <i32 -101, i32 -101, i32 -101, i32 -101>
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vbicq_n_u32_sh8(<4 x i32> %a) {
; CHECK-LE-LABEL: test_vbicq_n_u32_sh8:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vbic.i32 q0, #0x6400
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vbicq_n_u32_sh8:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.32 q1, q0
; CHECK-BE-NEXT:    vbic.i32 q1, #0x6400
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = and <4 x i32> %a, <i32 -25601, i32 -25601, i32 -25601, i32 -25601>
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vbicq_n_u32_sh16(<4 x i32> %a) {
; CHECK-LE-LABEL: test_vbicq_n_u32_sh16:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vbic.i32 q0, #0x640000
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vbicq_n_u32_sh16:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.32 q1, q0
; CHECK-BE-NEXT:    vbic.i32 q1, #0x640000
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = and <4 x i32> %a, <i32 -6553601, i32 -6553601, i32 -6553601, i32 -6553601>
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vbicq_n_u32_sh24(<4 x i32> %a) {
; CHECK-LE-LABEL: test_vbicq_n_u32_sh24:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vbic.i32 q0, #0x64000000
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vbicq_n_u32_sh24:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.32 q1, q0
; CHECK-BE-NEXT:    vbic.i32 q1, #0x64000000
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = and <4 x i32> %a, <i32 -1677721601, i32 -1677721601, i32 -1677721601, i32 -1677721601>
  ret <4 x i32> %0
}

; The immediate in this case is legal for a VMVN but not for a VBIC,
; so in this case we expect to see the constant being prepared in
; another register.
define arm_aapcs_vfpcc <4 x i32> @test_vbicq_n_u32_illegal(<4 x i32> %a) {
; CHECK-LE-LABEL: test_vbicq_n_u32_illegal:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmvn.i32 q1, #0x54ff
; CHECK-LE-NEXT:    vand q0, q0, q1
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vbicq_n_u32_illegal:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.32 q1, q0
; CHECK-BE-NEXT:    vmvn.i32 q0, #0x54ff
; CHECK-BE-NEXT:    vand q1, q1, q0
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = and <4 x i32> %a, <i32 -21760, i32 -21760, i32 -21760, i32 -21760>
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <8 x i16> @test_vorrq_n_u16_sh0(<8 x i16> %a) {
; CHECK-LE-LABEL: test_vorrq_n_u16_sh0:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vorr.i16 q0, #0x64
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vorrq_n_u16_sh0:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.16 q1, q0
; CHECK-BE-NEXT:    vorr.i16 q1, #0x64
; CHECK-BE-NEXT:    vrev64.16 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = or <8 x i16> %a, <i16 100, i16 100, i16 100, i16 100, i16 100, i16 100, i16 100, i16 100>
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <8 x i16> @test_vorrq_n_u16_sh8(<8 x i16> %a) {
; CHECK-LE-LABEL: test_vorrq_n_u16_sh8:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vorr.i16 q0, #0x6400
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vorrq_n_u16_sh8:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.16 q1, q0
; CHECK-BE-NEXT:    vorr.i16 q1, #0x6400
; CHECK-BE-NEXT:    vrev64.16 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = or <8 x i16> %a, <i16 25600, i16 25600, i16 25600, i16 25600, i16 25600, i16 25600, i16 25600, i16 25600>
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vorrq_n_u32_sh0(<4 x i32> %a) {
; CHECK-LE-LABEL: test_vorrq_n_u32_sh0:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vorr.i32 q0, #0x64
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vorrq_n_u32_sh0:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.32 q1, q0
; CHECK-BE-NEXT:    vorr.i32 q1, #0x64
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = or <4 x i32> %a, <i32 100, i32 100, i32 100, i32 100>
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vorrq_n_u32_sh8(<4 x i32> %a) {
; CHECK-LE-LABEL: test_vorrq_n_u32_sh8:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vorr.i32 q0, #0x6400
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vorrq_n_u32_sh8:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.32 q1, q0
; CHECK-BE-NEXT:    vorr.i32 q1, #0x6400
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = or <4 x i32> %a, <i32 25600, i32 25600, i32 25600, i32 25600>
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vorrq_n_u32_sh16(<4 x i32> %a) {
; CHECK-LE-LABEL: test_vorrq_n_u32_sh16:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vorr.i32 q0, #0x640000
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vorrq_n_u32_sh16:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.32 q1, q0
; CHECK-BE-NEXT:    vorr.i32 q1, #0x640000
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = or <4 x i32> %a, <i32 6553600, i32 6553600, i32 6553600, i32 6553600>
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vorrq_n_u32_sh24(<4 x i32> %a) {
; CHECK-LE-LABEL: test_vorrq_n_u32_sh24:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vorr.i32 q0, #0x64000000
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vorrq_n_u32_sh24:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.32 q1, q0
; CHECK-BE-NEXT:    vorr.i32 q1, #0x64000000
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = or <4 x i32> %a, <i32 1677721600, i32 1677721600, i32 1677721600, i32 1677721600>
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <8 x i16> @test_vbicq_m_n_u16_sh0(<8 x i16> %a, i16 zeroext %p) {
; CHECK-LE-LABEL: test_vbicq_m_n_u16_sh0:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmsr p0, r0
; CHECK-LE-NEXT:    vpst
; CHECK-LE-NEXT:    vbict.i16 q0, #0x64
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vbicq_m_n_u16_sh0:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.16 q1, q0
; CHECK-BE-NEXT:    vmsr p0, r0
; CHECK-BE-NEXT:    vpst
; CHECK-BE-NEXT:    vbict.i16 q1, #0x64
; CHECK-BE-NEXT:    vrev64.16 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = tail call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = and <8 x i16> %a, <i16 -101, i16 -101, i16 -101, i16 -101, i16 -101, i16 -101, i16 -101, i16 -101>
  %3 = select <8 x i1> %1, <8 x i16> %2, <8 x i16> %a
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @test_vbicq_m_n_u16_sh8(<8 x i16> %a, i16 zeroext %p) {
; CHECK-LE-LABEL: test_vbicq_m_n_u16_sh8:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmsr p0, r0
; CHECK-LE-NEXT:    vpst
; CHECK-LE-NEXT:    vbict.i16 q0, #0x6400
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vbicq_m_n_u16_sh8:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.16 q1, q0
; CHECK-BE-NEXT:    vmsr p0, r0
; CHECK-BE-NEXT:    vpst
; CHECK-BE-NEXT:    vbict.i16 q1, #0x6400
; CHECK-BE-NEXT:    vrev64.16 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = tail call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = and <8 x i16> %a, <i16 -25601, i16 -25601, i16 -25601, i16 -25601, i16 -25601, i16 -25601, i16 -25601, i16 -25601>
  %3 = select <8 x i1> %1, <8 x i16> %2, <8 x i16> %a
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <4 x i32> @test_vbicq_m_n_u32_sh0(<4 x i32> %a, i16 zeroext %p) {
; CHECK-LE-LABEL: test_vbicq_m_n_u32_sh0:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmsr p0, r0
; CHECK-LE-NEXT:    vpst
; CHECK-LE-NEXT:    vbict.i32 q0, #0x64
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vbicq_m_n_u32_sh0:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.32 q1, q0
; CHECK-BE-NEXT:    vmsr p0, r0
; CHECK-BE-NEXT:    vpst
; CHECK-BE-NEXT:    vbict.i32 q1, #0x64
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = tail call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = and <4 x i32> %a, <i32 -101, i32 -101, i32 -101, i32 -101>
  %3 = select <4 x i1> %1, <4 x i32> %2, <4 x i32> %a
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @test_vbicq_m_n_u32_sh8(<4 x i32> %a, i16 zeroext %p) {
; CHECK-LE-LABEL: test_vbicq_m_n_u32_sh8:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmsr p0, r0
; CHECK-LE-NEXT:    vpst
; CHECK-LE-NEXT:    vbict.i32 q0, #0x6400
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vbicq_m_n_u32_sh8:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.32 q1, q0
; CHECK-BE-NEXT:    vmsr p0, r0
; CHECK-BE-NEXT:    vpst
; CHECK-BE-NEXT:    vbict.i32 q1, #0x6400
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = tail call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = and <4 x i32> %a, <i32 -25601, i32 -25601, i32 -25601, i32 -25601>
  %3 = select <4 x i1> %1, <4 x i32> %2, <4 x i32> %a
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @test_vbicq_m_n_u32_sh16(<4 x i32> %a, i16 zeroext %p) {
; CHECK-LE-LABEL: test_vbicq_m_n_u32_sh16:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmsr p0, r0
; CHECK-LE-NEXT:    vpst
; CHECK-LE-NEXT:    vbict.i32 q0, #0x640000
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vbicq_m_n_u32_sh16:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.32 q1, q0
; CHECK-BE-NEXT:    vmsr p0, r0
; CHECK-BE-NEXT:    vpst
; CHECK-BE-NEXT:    vbict.i32 q1, #0x640000
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = tail call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = and <4 x i32> %a, <i32 -6553601, i32 -6553601, i32 -6553601, i32 -6553601>
  %3 = select <4 x i1> %1, <4 x i32> %2, <4 x i32> %a
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @test_vbicq_m_n_u32_sh24(<4 x i32> %a, i16 zeroext %p) {
; CHECK-LE-LABEL: test_vbicq_m_n_u32_sh24:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmsr p0, r0
; CHECK-LE-NEXT:    vpst
; CHECK-LE-NEXT:    vbict.i32 q0, #0x64000000
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vbicq_m_n_u32_sh24:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.32 q1, q0
; CHECK-BE-NEXT:    vmsr p0, r0
; CHECK-BE-NEXT:    vpst
; CHECK-BE-NEXT:    vbict.i32 q1, #0x64000000
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = tail call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = and <4 x i32> %a, <i32 -1677721601, i32 -1677721601, i32 -1677721601, i32 -1677721601>
  %3 = select <4 x i1> %1, <4 x i32> %2, <4 x i32> %a
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <8 x i16> @test_vorrq_m_n_u16_sh0(<8 x i16> %a, i16 zeroext %p) {
; CHECK-LE-LABEL: test_vorrq_m_n_u16_sh0:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmsr p0, r0
; CHECK-LE-NEXT:    vpst
; CHECK-LE-NEXT:    vorrt.i16 q0, #0x64
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vorrq_m_n_u16_sh0:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.16 q1, q0
; CHECK-BE-NEXT:    vmsr p0, r0
; CHECK-BE-NEXT:    vpst
; CHECK-BE-NEXT:    vorrt.i16 q1, #0x64
; CHECK-BE-NEXT:    vrev64.16 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = tail call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = or <8 x i16> %a, <i16 100, i16 100, i16 100, i16 100, i16 100, i16 100, i16 100, i16 100>
  %3 = select <8 x i1> %1, <8 x i16> %2, <8 x i16> %a
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @test_vorrq_m_n_u16_sh8(<8 x i16> %a, i16 zeroext %p) {
; CHECK-LE-LABEL: test_vorrq_m_n_u16_sh8:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmsr p0, r0
; CHECK-LE-NEXT:    vpst
; CHECK-LE-NEXT:    vorrt.i16 q0, #0x6400
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vorrq_m_n_u16_sh8:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.16 q1, q0
; CHECK-BE-NEXT:    vmsr p0, r0
; CHECK-BE-NEXT:    vpst
; CHECK-BE-NEXT:    vorrt.i16 q1, #0x6400
; CHECK-BE-NEXT:    vrev64.16 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = tail call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = or <8 x i16> %a, <i16 25600, i16 25600, i16 25600, i16 25600, i16 25600, i16 25600, i16 25600, i16 25600>
  %3 = select <8 x i1> %1, <8 x i16> %2, <8 x i16> %a
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <4 x i32> @test_vorrq_m_n_u32_sh0(<4 x i32> %a, i16 zeroext %p) {
; CHECK-LE-LABEL: test_vorrq_m_n_u32_sh0:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmsr p0, r0
; CHECK-LE-NEXT:    vpst
; CHECK-LE-NEXT:    vorrt.i32 q0, #0x64
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vorrq_m_n_u32_sh0:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.32 q1, q0
; CHECK-BE-NEXT:    vmsr p0, r0
; CHECK-BE-NEXT:    vpst
; CHECK-BE-NEXT:    vorrt.i32 q1, #0x64
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = tail call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = or <4 x i32> %a, <i32 100, i32 100, i32 100, i32 100>
  %3 = select <4 x i1> %1, <4 x i32> %2, <4 x i32> %a
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @test_vorrq_m_n_u32_sh8(<4 x i32> %a, i16 zeroext %p) {
; CHECK-LE-LABEL: test_vorrq_m_n_u32_sh8:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmsr p0, r0
; CHECK-LE-NEXT:    vpst
; CHECK-LE-NEXT:    vorrt.i32 q0, #0x6400
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vorrq_m_n_u32_sh8:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.32 q1, q0
; CHECK-BE-NEXT:    vmsr p0, r0
; CHECK-BE-NEXT:    vpst
; CHECK-BE-NEXT:    vorrt.i32 q1, #0x6400
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = tail call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = or <4 x i32> %a, <i32 25600, i32 25600, i32 25600, i32 25600>
  %3 = select <4 x i1> %1, <4 x i32> %2, <4 x i32> %a
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @test_vorrq_m_n_u32_sh16(<4 x i32> %a, i16 zeroext %p) {
; CHECK-LE-LABEL: test_vorrq_m_n_u32_sh16:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmsr p0, r0
; CHECK-LE-NEXT:    vpst
; CHECK-LE-NEXT:    vorrt.i32 q0, #0x640000
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vorrq_m_n_u32_sh16:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.32 q1, q0
; CHECK-BE-NEXT:    vmsr p0, r0
; CHECK-BE-NEXT:    vpst
; CHECK-BE-NEXT:    vorrt.i32 q1, #0x640000
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = tail call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = or <4 x i32> %a, <i32 6553600, i32 6553600, i32 6553600, i32 6553600>
  %3 = select <4 x i1> %1, <4 x i32> %2, <4 x i32> %a
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @test_vorrq_m_n_u32_sh24(<4 x i32> %a, i16 zeroext %p) {
; CHECK-LE-LABEL: test_vorrq_m_n_u32_sh24:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmsr p0, r0
; CHECK-LE-NEXT:    vpst
; CHECK-LE-NEXT:    vorrt.i32 q0, #0x64000000
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vorrq_m_n_u32_sh24:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.32 q1, q0
; CHECK-BE-NEXT:    vmsr p0, r0
; CHECK-BE-NEXT:    vpst
; CHECK-BE-NEXT:    vorrt.i32 q1, #0x64000000
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = tail call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = or <4 x i32> %a, <i32 1677721600, i32 1677721600, i32 1677721600, i32 1677721600>
  %3 = select <4 x i1> %1, <4 x i32> %2, <4 x i32> %a
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <8 x i16> @test_vmvnq_n_u16() {
; CHECK-LABEL: test_vmvnq_n_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmvn.i16 q0, #0xaa00
; CHECK-NEXT:    bx lr
entry:
  ret <8 x i16> <i16 -43521, i16 -43521, i16 -43521, i16 -43521, i16 -43521, i16 -43521, i16 -43521, i16 -43521>
}

define arm_aapcs_vfpcc <4 x i32> @test_vmvnq_n_u32() {
; CHECK-LABEL: test_vmvnq_n_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmvn.i32 q0, #0xaa00
; CHECK-NEXT:    bx lr
entry:
  ret <4 x i32> <i32 -43521, i32 -43521, i32 -43521, i32 -43521>
}

define arm_aapcs_vfpcc <8 x i16> @test_vmvnq_m_n_u16(<8 x i16> %inactive, i16 zeroext %p) {
; CHECK-LE-LABEL: test_vmvnq_m_n_u16:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmsr p0, r0
; CHECK-LE-NEXT:    vpst
; CHECK-LE-NEXT:    vmvnt.i16 q0, #0xaa00
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vmvnq_m_n_u16:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.16 q1, q0
; CHECK-BE-NEXT:    vmsr p0, r0
; CHECK-BE-NEXT:    vpst
; CHECK-BE-NEXT:    vmvnt.i16 q1, #0xaa00
; CHECK-BE-NEXT:    vrev64.16 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = tail call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = select <8 x i1> %1, <8 x i16> <i16 -43521, i16 -43521, i16 -43521, i16 -43521, i16 -43521, i16 -43521, i16 -43521, i16 -43521>, <8 x i16> %inactive
  ret <8 x i16> %2
}

define arm_aapcs_vfpcc <4 x i32> @test_vmvnq_m_n_u32(<4 x i32> %inactive, i16 zeroext %p) {
; CHECK-LE-LABEL: test_vmvnq_m_n_u32:
; CHECK-LE:       @ %bb.0: @ %entry
; CHECK-LE-NEXT:    vmsr p0, r0
; CHECK-LE-NEXT:    vpst
; CHECK-LE-NEXT:    vmvnt.i32 q0, #0xaa00
; CHECK-LE-NEXT:    bx lr
;
; CHECK-BE-LABEL: test_vmvnq_m_n_u32:
; CHECK-BE:       @ %bb.0: @ %entry
; CHECK-BE-NEXT:    vrev64.32 q1, q0
; CHECK-BE-NEXT:    vmsr p0, r0
; CHECK-BE-NEXT:    vpst
; CHECK-BE-NEXT:    vmvnt.i32 q1, #0xaa00
; CHECK-BE-NEXT:    vrev64.32 q0, q1
; CHECK-BE-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = tail call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = select <4 x i1> %1, <4 x i32> <i32 -43521, i32 -43521, i32 -43521, i32 -43521>, <4 x i32> %inactive
  ret <4 x i32> %2
}

declare <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32)
declare <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32)
