; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple aarch64 | FileCheck %s -check-prefixes=CHECK-LE
; RUN: llc < %s -mtriple aarch64_be | FileCheck %s -check-prefixes=CHECK-BE

declare dso_local void @main()

define dso_local void @naked() naked "frame-pointer"="all" {
; CHECK-LE-LABEL: naked:
; CHECK-LE:       // %bb.0:
; CHECK-LE-NEXT:    bl main
;
; CHECK-BE-LABEL: naked:
; CHECK-BE:       // %bb.0:
; CHECK-BE-NEXT:    bl main
  call void @main()
  unreachable
}

define dso_local void @normal() "frame-pointer"="all" {
; CHECK-LE-LABEL: normal:
; CHECK-LE:       // %bb.0:
; CHECK-LE-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-LE-NEXT:    mov x29, sp
; CHECK-LE-NEXT:    .cfi_def_cfa w29, 16
; CHECK-LE-NEXT:    .cfi_offset w30, -8
; CHECK-LE-NEXT:    .cfi_offset w29, -16
; CHECK-LE-NEXT:    bl main
;
; CHECK-BE-LABEL: normal:
; CHECK-BE:       // %bb.0:
; CHECK-BE-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-BE-NEXT:    mov x29, sp
; CHECK-BE-NEXT:    .cfi_def_cfa w29, 16
; CHECK-BE-NEXT:    .cfi_offset w30, -8
; CHECK-BE-NEXT:    .cfi_offset w29, -16
; CHECK-BE-NEXT:    bl main
  call void @main()
  unreachable
}
