; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=nsan -nsan-shadow-type-mapping=dqq -S | FileCheck %s
target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"

; Tests with more involved control flow to check lazy construction of the
; shadow values.

define float @forward_use() sanitize_numerical_stability {
; CHECK-LABEL: @forward_use(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[BLOCK1:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[D:%.*]] = fadd float [[B:%.*]], 2.000000e+00
; CHECK-NEXT:    [[TMP0:%.*]] = fadd double [[TMP2:%.*]], 2.000000e+00
; CHECK-NEXT:    br label [[BLOCK1]]
; CHECK:       block1:
; CHECK-NEXT:    [[A:%.*]] = phi float [ [[D]], [[LOOP:%.*]] ], [ 1.000000e+00, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TMP1:%.*]] = phi double [ [[TMP0]], [[LOOP]] ], [ 1.000000e+00, [[ENTRY]] ]
; CHECK-NEXT:    [[B]] = fadd float [[A]], 1.000000e+00
; CHECK-NEXT:    [[TMP2]] = fadd double [[TMP1]], 1.000000e+00
; CHECK-NEXT:    br label [[LOOP]]
;

entry:
  br label %block1

loop:
  %d = fadd float %b, 2.0 ; this is a forward reference, requiring shadow(%b) to be available.
  br label %block1

block1:
  %a = phi float [ %d, %loop], [ 1.0, %entry ]
  %b = fadd float %a, 1.0
  br label %loop
}

define float @forward_use_with_load(float* %p) sanitize_numerical_stability {
; CHECK-LABEL: @forward_use_with_load(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[BLOCK1:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[D:%.*]] = fadd float [[B:%.*]], 2.000000e+00
; CHECK-NEXT:    [[TMP0:%.*]] = fadd double [[TMP10:%.*]], 2.000000e+00
; CHECK-NEXT:    br label [[BLOCK1]]
; CHECK:       block1:
; CHECK-NEXT:    [[A:%.*]] = phi float [ [[D]], [[LOOP:%.*]] ], [ 1.000000e+00, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TMP1:%.*]] = phi double [ [[TMP0]], [[LOOP]] ], [ 1.000000e+00, [[ENTRY]] ]
; CHECK-NEXT:    [[L:%.*]] = load float, ptr [[P:%.*]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = call ptr @__nsan_get_shadow_ptr_for_float_load(ptr [[P]], i64 1)
; CHECK-NEXT:    [[TMP3:%.*]] = icmp eq ptr [[TMP2]], null
; CHECK-NEXT:    br i1 [[TMP3]], label [[TMP6:%.*]], label [[TMP4:%.*]]
; CHECK:       4:
; CHECK-NEXT:    [[TMP5:%.*]] = load double, ptr [[TMP2]], align 1
; CHECK-NEXT:    br label [[TMP8:%.*]]
; CHECK:       6:
; CHECK-NEXT:    [[TMP7:%.*]] = fpext float [[L]] to double
; CHECK-NEXT:    br label [[TMP8]]
; CHECK:       8:
; CHECK-NEXT:    [[TMP9:%.*]] = phi double [ [[TMP5]], [[TMP4]] ], [ [[TMP7]], [[TMP6]] ]
; CHECK-NEXT:    [[B]] = fadd float [[L]], 1.000000e+00
; CHECK-NEXT:    [[TMP10]] = fadd double [[TMP9]], 1.000000e+00
; CHECK-NEXT:    br label [[LOOP]]
;

entry:
  br label %block1

loop:
  %d = fadd float %b, 2.0 ; this is a forward reference, requiring shadow(%b) to be available.
  br label %block1

block1:
  %a = phi float [ %d, %loop], [ 1.0, %entry ]
  %l = load float, float* %p ; the load creates a new block
  %b = fadd float %l, 1.0 ; this requires shadow(%l).
  br label %loop
}

define float @forward_use_with_two_uses() sanitize_numerical_stability {
; CHECK-LABEL: @forward_use_with_two_uses(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[BLOCK1:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[D:%.*]] = fadd float [[B:%.*]], 2.000000e+00
; CHECK-NEXT:    [[TMP0:%.*]] = fadd double [[TMP4:%.*]], 2.000000e+00
; CHECK-NEXT:    br label [[BLOCK1]]
; CHECK:       block1:
; CHECK-NEXT:    [[A:%.*]] = phi float [ [[D]], [[LOOP:%.*]] ], [ 1.000000e+00, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TMP1:%.*]] = phi double [ [[TMP0]], [[LOOP]] ], [ 1.000000e+00, [[ENTRY]] ]
; CHECK-NEXT:    [[T1:%.*]] = fadd float [[A]], 1.000000e+00
; CHECK-NEXT:    [[TMP2:%.*]] = fadd double [[TMP1]], 1.000000e+00
; CHECK-NEXT:    [[T2:%.*]] = fadd float [[T1]], 3.000000e+00
; CHECK-NEXT:    [[TMP3:%.*]] = fadd double [[TMP2]], 3.000000e+00
; CHECK-NEXT:    [[B]] = fadd float [[T1]], [[T2]]
; CHECK-NEXT:    [[TMP4]] = fadd double [[TMP2]], [[TMP3]]
; CHECK-NEXT:    br label [[LOOP]]
;

entry:
  br label %block1

loop:
  %d = fadd float %b, 2.0 ; this is a forward reference, requiring shadow(%b) to be available.
  br label %block1

block1:
  %a = phi float [ %d, %loop], [ 1.0, %entry ]
  %t1 = fadd float %a, 1.0
  %t2 = fadd float %t1, 3.0 ; this requires shadow(%t1)
  %b = fadd float %t1, %t2 ; this requires shadow(%t2) and shadow(%t1).
  br label %loop
}
