; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc --mtriple=loongarch64 --mattr=+lasx,-frecipe < %s | FileCheck %s --check-prefix=FAULT
; RUN: llc --mtriple=loongarch64 --mattr=+lasx,+frecipe < %s | FileCheck %s

define void @fdiv_v8f32(ptr %res, ptr %a0, ptr %a1) nounwind {
; FAULT-LABEL: fdiv_v8f32:
; FAULT:       # %bb.0:
; FAULT-NEXT:    xvld	$xr0, $a1, 0
; FAULT-NEXT:    xvld	$xr1, $a2, 0
; FAULT-NEXT:    xvfdiv.s	$xr0, $xr0, $xr1
; FAULT-NEXT:    xvst	$xr0, $a0, 0
; FAULT-NEXT:    ret
;
; CHECK-LABEL: fdiv_v8f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xvld	$xr0, $a2, 0
; CHECK-NEXT:    xvld	$xr1, $a1, 0
; CHECK-NEXT:    xvfrecipe.s	$xr2, $xr0
; CHECK-NEXT:    xvfmul.s	$xr3, $xr1, $xr2
; CHECK-NEXT:    xvfnmsub.s	$xr0, $xr0, $xr3, $xr1
; CHECK-NEXT:    xvfmadd.s	$xr0, $xr2, $xr0, $xr3
; CHECK-NEXT:    xvst	$xr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <8 x float>, ptr %a0
  %v1 = load <8 x float>, ptr %a1
  %v2 = fdiv fast <8 x float> %v0, %v1
  store <8 x float> %v2, ptr %res
  ret void
}

define void @fdiv_v4f64(ptr %res, ptr %a0, ptr %a1) nounwind {
; FAULT-LABEL: fdiv_v4f64:
; FAULT:       # %bb.0:
; FAULT-NEXT:    xvld	$xr0, $a1, 0
; FAULT-NEXT:    xvld	$xr1, $a2, 0
; FAULT-NEXT:    xvfdiv.d	$xr0, $xr0, $xr1
; FAULT-NEXT:    xvst	$xr0, $a0, 0
; FAULT-NEXT:    ret
;
; CHECK-LABEL: fdiv_v4f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xvld	$xr0, $a2, 0
; CHECK-NEXT:    xvld	$xr1, $a1, 0
; CHECK-NEXT:    lu52i.d	$a1, $zero, -1025
; CHECK-NEXT:    xvreplgr2vr.d	$xr2, $a1
; CHECK-NEXT:    xvfrecipe.d	$xr3, $xr0
; CHECK-NEXT:    xvfmadd.d	$xr2, $xr0, $xr3, $xr2
; CHECK-NEXT:    xvfnmsub.d	$xr2, $xr2, $xr3, $xr3
; CHECK-NEXT:    xvfmul.d	$xr3, $xr1, $xr2
; CHECK-NEXT:    xvfnmsub.d	$xr0, $xr0, $xr3, $xr1
; CHECK-NEXT:    xvfmadd.d	$xr0, $xr2, $xr0, $xr3
; CHECK-NEXT:    xvst	$xr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0
  %v1 = load <4 x double>, ptr %a1
  %v2 = fdiv fast <4 x double> %v0, %v1
  store <4 x double> %v2, ptr %res
  ret void
}

;; 1.0 / vec
define void @one_fdiv_v8f32(ptr %res, ptr %a0) nounwind {
; FAULT-LABEL: one_fdiv_v8f32:
; FAULT:       # %bb.0:
; FAULT-NEXT:    xvld	$xr0, $a1, 0
; FAULT-NEXT:    xvfrecip.s	$xr0, $xr0
; FAULT-NEXT:    xvst	$xr0, $a0, 0
; FAULT-NEXT:    ret
;
; CHECK-LABEL: one_fdiv_v8f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xvld	$xr0, $a1, 0
; CHECK-NEXT:    xvfrecipe.s	$xr1, $xr0
; CHECK-NEXT:    lu12i.w	$a1, -264192
; CHECK-NEXT:    xvreplgr2vr.w	$xr2, $a1
; CHECK-NEXT:    xvfmadd.s	$xr0, $xr0, $xr1, $xr2
; CHECK-NEXT:    xvfnmsub.s	$xr0, $xr0, $xr1, $xr1
; CHECK-NEXT:    xvst	$xr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <8 x float>, ptr %a0
  %div = fdiv fast <8 x float> <float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0>, %v0
  store <8 x float> %div, ptr %res
  ret void
}

define void @one_fdiv_v4f64(ptr %res, ptr %a0) nounwind {
; FAULT-LABEL: one_fdiv_v4f64:
; FAULT:       # %bb.0:
; FAULT-NEXT:    xvld	$xr0, $a1, 0
; FAULT-NEXT:    xvfrecip.d	$xr0, $xr0
; FAULT-NEXT:    xvst	$xr0, $a0, 0
; FAULT-NEXT:    ret
;
; CHECK-LABEL: one_fdiv_v4f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xvld	$xr0, $a1, 0
; CHECK-NEXT:    xvfrecipe.d	$xr1, $xr0
; CHECK-NEXT:    lu52i.d	$a1, $zero, 1023
; CHECK-NEXT:    xvreplgr2vr.d	$xr2, $a1
; CHECK-NEXT:    xvfnmsub.d	$xr3, $xr0, $xr1, $xr2
; CHECK-NEXT:    xvfmadd.d	$xr1, $xr1, $xr3, $xr1
; CHECK-NEXT:    xvfnmsub.d	$xr0, $xr0, $xr1, $xr2
; CHECK-NEXT:    xvfmadd.d	$xr0, $xr1, $xr0, $xr1
; CHECK-NEXT:    xvst	$xr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0
  %div = fdiv fast <4 x double> <double 1.0, double 1.0, double 1.0, double 1.0>, %v0
  store <4 x double> %div, ptr %res
  ret void
}
