; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --mtriple=loongarch64 --mattr=-lsx < %s | FileCheck %s --check-prefix=NOLSX
; RUN: llc --mtriple=loongarch64 --mattr=+lsx < %s | FileCheck %s --check-prefix=LSX

;; ceilf
define float @ceil_f32(float %i) nounwind {
; NOLSX-LABEL: ceil_f32:
; NOLSX:       # %bb.0: # %entry
; NOLSX-NEXT:    b %plt(ceilf)
;
; LSX-LABEL: ceil_f32:
; LSX:       # %bb.0: # %entry
; LSX-NEXT:    # kill: def $f0 killed $f0 def $vr0
; LSX-NEXT:    vreplvei.w $vr0, $vr0, 0
; LSX-NEXT:    vfrintrp.s $vr0, $vr0
; LSX-NEXT:    # kill: def $f0 killed $f0 killed $vr0
; LSX-NEXT:    ret
entry:
  %0 = call float @llvm.ceil.f32(float %i)
  ret float %0
}

;; ceil
define double @ceil_f64(double %i) nounwind {
; NOLSX-LABEL: ceil_f64:
; NOLSX:       # %bb.0: # %entry
; NOLSX-NEXT:    b %plt(ceil)
;
; LSX-LABEL: ceil_f64:
; LSX:       # %bb.0: # %entry
; LSX-NEXT:    # kill: def $f0_64 killed $f0_64 def $vr0
; LSX-NEXT:    vreplvei.d $vr0, $vr0, 0
; LSX-NEXT:    vfrintrp.d $vr0, $vr0
; LSX-NEXT:    # kill: def $f0_64 killed $f0_64 killed $vr0
; LSX-NEXT:    ret
entry:
  %0 = call double @llvm.ceil.f64(double %i)
  ret double %0
}

;; floorf
define float @floor_f32(float %i) nounwind {
; NOLSX-LABEL: floor_f32:
; NOLSX:       # %bb.0: # %entry
; NOLSX-NEXT:    b %plt(floorf)
;
; LSX-LABEL: floor_f32:
; LSX:       # %bb.0: # %entry
; LSX-NEXT:    # kill: def $f0 killed $f0 def $vr0
; LSX-NEXT:    vreplvei.w $vr0, $vr0, 0
; LSX-NEXT:    vfrintrm.s $vr0, $vr0
; LSX-NEXT:    # kill: def $f0 killed $f0 killed $vr0
; LSX-NEXT:    ret
entry:
  %0 = call float @llvm.floor.f32(float %i)
  ret float %0
}

;; floor
define double @floor_f64(double %i) nounwind {
; NOLSX-LABEL: floor_f64:
; NOLSX:       # %bb.0: # %entry
; NOLSX-NEXT:    b %plt(floor)
;
; LSX-LABEL: floor_f64:
; LSX:       # %bb.0: # %entry
; LSX-NEXT:    # kill: def $f0_64 killed $f0_64 def $vr0
; LSX-NEXT:    vreplvei.d $vr0, $vr0, 0
; LSX-NEXT:    vfrintrm.d $vr0, $vr0
; LSX-NEXT:    # kill: def $f0_64 killed $f0_64 killed $vr0
; LSX-NEXT:    ret
entry:
  %0 = call double @llvm.floor.f64(double %i)
  ret double %0
}

;; truncf
define float @trunc_f32(float %i) nounwind {
; NOLSX-LABEL: trunc_f32:
; NOLSX:       # %bb.0: # %entry
; NOLSX-NEXT:    b %plt(truncf)
;
; LSX-LABEL: trunc_f32:
; LSX:       # %bb.0: # %entry
; LSX-NEXT:    # kill: def $f0 killed $f0 def $vr0
; LSX-NEXT:    vreplvei.w $vr0, $vr0, 0
; LSX-NEXT:    vfrintrz.s $vr0, $vr0
; LSX-NEXT:    # kill: def $f0 killed $f0 killed $vr0
; LSX-NEXT:    ret
entry:
  %0 = call float @llvm.trunc.f32(float %i)
  ret float %0
}

;; trunc
define double @trunc_f64(double %i) nounwind {
; NOLSX-LABEL: trunc_f64:
; NOLSX:       # %bb.0: # %entry
; NOLSX-NEXT:    b %plt(trunc)
;
; LSX-LABEL: trunc_f64:
; LSX:       # %bb.0: # %entry
; LSX-NEXT:    # kill: def $f0_64 killed $f0_64 def $vr0
; LSX-NEXT:    vreplvei.d $vr0, $vr0, 0
; LSX-NEXT:    vfrintrz.d $vr0, $vr0
; LSX-NEXT:    # kill: def $f0_64 killed $f0_64 killed $vr0
; LSX-NEXT:    ret
entry:
  %0 = call double @llvm.trunc.f64(double %i)
  ret double %0
}

;; roundevenf
define float @roundeven_f32(float %i) nounwind {
; NOLSX-LABEL: roundeven_f32:
; NOLSX:       # %bb.0: # %entry
; NOLSX-NEXT:    b %plt(roundevenf)
;
; LSX-LABEL: roundeven_f32:
; LSX:       # %bb.0: # %entry
; LSX-NEXT:    # kill: def $f0 killed $f0 def $vr0
; LSX-NEXT:    vreplvei.w $vr0, $vr0, 0
; LSX-NEXT:    vfrintrne.s $vr0, $vr0
; LSX-NEXT:    # kill: def $f0 killed $f0 killed $vr0
; LSX-NEXT:    ret
entry:
  %0 = call float @llvm.roundeven.f32(float %i)
  ret float %0
}

;; roundeven
define double @roundeven_f64(double %i) nounwind {
; NOLSX-LABEL: roundeven_f64:
; NOLSX:       # %bb.0: # %entry
; NOLSX-NEXT:    b %plt(roundeven)
;
; LSX-LABEL: roundeven_f64:
; LSX:       # %bb.0: # %entry
; LSX-NEXT:    # kill: def $f0_64 killed $f0_64 def $vr0
; LSX-NEXT:    vreplvei.d $vr0, $vr0, 0
; LSX-NEXT:    vfrintrne.d $vr0, $vr0
; LSX-NEXT:    # kill: def $f0_64 killed $f0_64 killed $vr0
; LSX-NEXT:    ret
entry:
  %0 = call double @llvm.roundeven.f64(double %i)
  ret double %0
}

declare float @llvm.ceil.f32(float)
declare double @llvm.ceil.f64(double)
declare float @llvm.floor.f32(float)
declare double @llvm.floor.f64(double)
declare float @llvm.trunc.f32(float)
declare double @llvm.trunc.f64(double)
declare float @llvm.roundeven.f32(float)
declare double @llvm.roundeven.f64(double)
