; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -o - < %s -mcpu=sm_70 -mattr=+ptx76 | FileCheck %s
; RUN: %if ptxas %{ llc < %s -mcpu=sm_70 -mattr=+ptx76 | %ptxas-verify -arch=sm_70 %}

target triple = "nvptx64-unknown-cuda"

define i32 @bmsk_wrap(i32 %a, i32 %b) {
; CHECK-LABEL: bmsk_wrap(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [bmsk_wrap_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [bmsk_wrap_param_1];
; CHECK-NEXT:    bmsk.wrap.b32 %r3, %r1, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %c = call i32 @llvm.nvvm.bmsk.wrap(i32 %a, i32 %b)
  ret i32 %c
}

define i32 @bmsk_clamp(i32 %a, i32 %b) {
; CHECK-LABEL: bmsk_clamp(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [bmsk_clamp_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [bmsk_clamp_param_1];
; CHECK-NEXT:    bmsk.clamp.b32 %r3, %r1, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %c = call i32 @llvm.nvvm.bmsk.clamp(i32 %a, i32 %b)
  ret i32 %c
}

define i32 @bmsk_wrap_ii() {
; CHECK-LABEL: bmsk_wrap_ii(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    mov.b32 %r1, 5;
; CHECK-NEXT:    bmsk.wrap.b32 %r2, %r1, 6;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r2;
; CHECK-NEXT:    ret;
  %c = call i32 @llvm.nvvm.bmsk.wrap(i32 5, i32 6)
  ret i32 %c
}

define i32 @bmsk_clamp_ir(i32 %a) {
; CHECK-LABEL: bmsk_clamp_ir(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [bmsk_clamp_ir_param_0];
; CHECK-NEXT:    bmsk.clamp.b32 %r2, %r1, 7;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r2;
; CHECK-NEXT:    ret;
  %c = call i32 @llvm.nvvm.bmsk.clamp(i32 %a, i32 7)
  ret i32 %c
}

define i32 @bmsk_wrap_ri(i32 %a) {
; CHECK-LABEL: bmsk_wrap_ri(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [bmsk_wrap_ri_param_0];
; CHECK-NEXT:    bmsk.wrap.b32 %r2, 5, %r1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r2;
; CHECK-NEXT:    ret;
  %c = call i32 @llvm.nvvm.bmsk.wrap(i32 5, i32 %a)
  ret i32 %c
}
