; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 --verify-machineinstrs < %s | FileCheck %s --check-prefix=LA32S
; RUN: llc --mtriple=loongarch32 --mattr=+f -target-abi=ilp32s --verify-machineinstrs < %s | FileCheck %s --check-prefix=LA32F-ILP32S
; RUN: llc --mtriple=loongarch32 --mattr=+f -target-abi=ilp32d --verify-machineinstrs < %s | FileCheck %s --check-prefix=LA32F-ILP32D
; RUN: llc --mtriple=loongarch32 --mattr=+d -target-abi=ilp32s --verify-machineinstrs < %s | FileCheck %s --check-prefix=LA32D-ILP32S
; RUN: llc --mtriple=loongarch32 --mattr=+d -target-abi=ilp32d --verify-machineinstrs < %s | FileCheck %s --check-prefix=LA32D-ILP32D
; RUN: llc --mtriple=loongarch64 --verify-machineinstrs < %s | FileCheck %s --check-prefix=LA64S
; RUN: llc --mtriple=loongarch64 --mattr=+f -target-abi=lp64s --verify-machineinstrs < %s | FileCheck %s --check-prefix=LA64F-LP64S
; RUN: llc --mtriple=loongarch64 --mattr=+f -target-abi=lp64d --verify-machineinstrs < %s | FileCheck %s --check-prefix=LA64F-LP64D
; RUN: llc --mtriple=loongarch64 --mattr=+d -target-abi=lp64s --verify-machineinstrs < %s | FileCheck %s --check-prefix=LA64D-LP64S
; RUN: llc --mtriple=loongarch64 --mattr=+d -target-abi=lp64d --verify-machineinstrs < %s | FileCheck %s --check-prefix=LA64D-LP64D

define half @f(half %a, half %b, half %c) {
; LA32S-LABEL: f:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -32
; LA32S-NEXT:    .cfi_def_cfa_offset 32
; LA32S-NEXT:    st.w $ra, $sp, 28 # 4-byte Folded Spill
; LA32S-NEXT:    st.w $fp, $sp, 24 # 4-byte Folded Spill
; LA32S-NEXT:    st.w $s0, $sp, 20 # 4-byte Folded Spill
; LA32S-NEXT:    st.w $s1, $sp, 16 # 4-byte Folded Spill
; LA32S-NEXT:    st.w $s2, $sp, 12 # 4-byte Folded Spill
; LA32S-NEXT:    .cfi_offset 1, -4
; LA32S-NEXT:    .cfi_offset 22, -8
; LA32S-NEXT:    .cfi_offset 23, -12
; LA32S-NEXT:    .cfi_offset 24, -16
; LA32S-NEXT:    .cfi_offset 25, -20
; LA32S-NEXT:    move $fp, $a2
; LA32S-NEXT:    move $s0, $a1
; LA32S-NEXT:    lu12i.w $a1, 15
; LA32S-NEXT:    ori $s2, $a1, 4095
; LA32S-NEXT:    and $a0, $a0, $s2
; LA32S-NEXT:    bl __extendhfsf2
; LA32S-NEXT:    move $s1, $a0
; LA32S-NEXT:    and $a0, $s0, $s2
; LA32S-NEXT:    bl __extendhfsf2
; LA32S-NEXT:    move $a1, $a0
; LA32S-NEXT:    move $a0, $s1
; LA32S-NEXT:    bl __addsf3
; LA32S-NEXT:    bl __truncsfhf2
; LA32S-NEXT:    move $s0, $a0
; LA32S-NEXT:    and $a0, $fp, $s2
; LA32S-NEXT:    bl __extendhfsf2
; LA32S-NEXT:    move $fp, $a0
; LA32S-NEXT:    and $a0, $s0, $s2
; LA32S-NEXT:    bl __extendhfsf2
; LA32S-NEXT:    move $a1, $fp
; LA32S-NEXT:    bl __addsf3
; LA32S-NEXT:    bl __truncsfhf2
; LA32S-NEXT:    ld.w $s2, $sp, 12 # 4-byte Folded Reload
; LA32S-NEXT:    ld.w $s1, $sp, 16 # 4-byte Folded Reload
; LA32S-NEXT:    ld.w $s0, $sp, 20 # 4-byte Folded Reload
; LA32S-NEXT:    ld.w $fp, $sp, 24 # 4-byte Folded Reload
; LA32S-NEXT:    ld.w $ra, $sp, 28 # 4-byte Folded Reload
; LA32S-NEXT:    addi.w $sp, $sp, 32
; LA32S-NEXT:    ret
;
; LA32F-ILP32S-LABEL: f:
; LA32F-ILP32S:       # %bb.0:
; LA32F-ILP32S-NEXT:    addi.w $sp, $sp, -16
; LA32F-ILP32S-NEXT:    .cfi_def_cfa_offset 16
; LA32F-ILP32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32F-ILP32S-NEXT:    st.w $fp, $sp, 8 # 4-byte Folded Spill
; LA32F-ILP32S-NEXT:    st.w $s0, $sp, 4 # 4-byte Folded Spill
; LA32F-ILP32S-NEXT:    .cfi_offset 1, -4
; LA32F-ILP32S-NEXT:    .cfi_offset 22, -8
; LA32F-ILP32S-NEXT:    .cfi_offset 23, -12
; LA32F-ILP32S-NEXT:    move $fp, $a2
; LA32F-ILP32S-NEXT:    move $s0, $a0
; LA32F-ILP32S-NEXT:    move $a0, $a1
; LA32F-ILP32S-NEXT:    bl __extendhfsf2
; LA32F-ILP32S-NEXT:    movgr2fr.w $fa0, $a0
; LA32F-ILP32S-NEXT:    fst.s $fa0, $sp, 0 # 4-byte Folded Spill
; LA32F-ILP32S-NEXT:    move $a0, $s0
; LA32F-ILP32S-NEXT:    bl __extendhfsf2
; LA32F-ILP32S-NEXT:    movgr2fr.w $fa0, $a0
; LA32F-ILP32S-NEXT:    fld.s $fa1, $sp, 0 # 4-byte Folded Reload
; LA32F-ILP32S-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA32F-ILP32S-NEXT:    movfr2gr.s $a0, $fa0
; LA32F-ILP32S-NEXT:    bl __truncsfhf2
; LA32F-ILP32S-NEXT:    bl __extendhfsf2
; LA32F-ILP32S-NEXT:    movgr2fr.w $fa0, $a0
; LA32F-ILP32S-NEXT:    fst.s $fa0, $sp, 0 # 4-byte Folded Spill
; LA32F-ILP32S-NEXT:    move $a0, $fp
; LA32F-ILP32S-NEXT:    bl __extendhfsf2
; LA32F-ILP32S-NEXT:    movgr2fr.w $fa0, $a0
; LA32F-ILP32S-NEXT:    fld.s $fa1, $sp, 0 # 4-byte Folded Reload
; LA32F-ILP32S-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA32F-ILP32S-NEXT:    movfr2gr.s $a0, $fa0
; LA32F-ILP32S-NEXT:    bl __truncsfhf2
; LA32F-ILP32S-NEXT:    lu12i.w $a1, -16
; LA32F-ILP32S-NEXT:    or $a0, $a0, $a1
; LA32F-ILP32S-NEXT:    ld.w $s0, $sp, 4 # 4-byte Folded Reload
; LA32F-ILP32S-NEXT:    ld.w $fp, $sp, 8 # 4-byte Folded Reload
; LA32F-ILP32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32F-ILP32S-NEXT:    addi.w $sp, $sp, 16
; LA32F-ILP32S-NEXT:    ret
;
; LA32F-ILP32D-LABEL: f:
; LA32F-ILP32D:       # %bb.0:
; LA32F-ILP32D-NEXT:    addi.w $sp, $sp, -16
; LA32F-ILP32D-NEXT:    .cfi_def_cfa_offset 16
; LA32F-ILP32D-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32F-ILP32D-NEXT:    fst.s $fs0, $sp, 8 # 4-byte Folded Spill
; LA32F-ILP32D-NEXT:    fst.s $fs1, $sp, 4 # 4-byte Folded Spill
; LA32F-ILP32D-NEXT:    fst.s $fs2, $sp, 0 # 4-byte Folded Spill
; LA32F-ILP32D-NEXT:    .cfi_offset 1, -4
; LA32F-ILP32D-NEXT:    .cfi_offset 56, -8
; LA32F-ILP32D-NEXT:    .cfi_offset 57, -12
; LA32F-ILP32D-NEXT:    .cfi_offset 58, -16
; LA32F-ILP32D-NEXT:    fmov.s $fs0, $fa2
; LA32F-ILP32D-NEXT:    fmov.s $fs1, $fa0
; LA32F-ILP32D-NEXT:    fmov.s $fa0, $fa1
; LA32F-ILP32D-NEXT:    bl __extendhfsf2
; LA32F-ILP32D-NEXT:    fmov.s $fs2, $fa0
; LA32F-ILP32D-NEXT:    fmov.s $fa0, $fs1
; LA32F-ILP32D-NEXT:    bl __extendhfsf2
; LA32F-ILP32D-NEXT:    fadd.s $fa0, $fa0, $fs2
; LA32F-ILP32D-NEXT:    bl __truncsfhf2
; LA32F-ILP32D-NEXT:    bl __extendhfsf2
; LA32F-ILP32D-NEXT:    fmov.s $fs1, $fa0
; LA32F-ILP32D-NEXT:    fmov.s $fa0, $fs0
; LA32F-ILP32D-NEXT:    bl __extendhfsf2
; LA32F-ILP32D-NEXT:    fadd.s $fa0, $fs1, $fa0
; LA32F-ILP32D-NEXT:    bl __truncsfhf2
; LA32F-ILP32D-NEXT:    movfr2gr.s $a0, $fa0
; LA32F-ILP32D-NEXT:    lu12i.w $a1, -16
; LA32F-ILP32D-NEXT:    or $a0, $a0, $a1
; LA32F-ILP32D-NEXT:    movgr2fr.w $fa0, $a0
; LA32F-ILP32D-NEXT:    fld.s $fs2, $sp, 0 # 4-byte Folded Reload
; LA32F-ILP32D-NEXT:    fld.s $fs1, $sp, 4 # 4-byte Folded Reload
; LA32F-ILP32D-NEXT:    fld.s $fs0, $sp, 8 # 4-byte Folded Reload
; LA32F-ILP32D-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32F-ILP32D-NEXT:    addi.w $sp, $sp, 16
; LA32F-ILP32D-NEXT:    ret
;
; LA32D-ILP32S-LABEL: f:
; LA32D-ILP32S:       # %bb.0:
; LA32D-ILP32S-NEXT:    addi.w $sp, $sp, -16
; LA32D-ILP32S-NEXT:    .cfi_def_cfa_offset 16
; LA32D-ILP32S-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32D-ILP32S-NEXT:    st.w $fp, $sp, 8 # 4-byte Folded Spill
; LA32D-ILP32S-NEXT:    st.w $s0, $sp, 4 # 4-byte Folded Spill
; LA32D-ILP32S-NEXT:    .cfi_offset 1, -4
; LA32D-ILP32S-NEXT:    .cfi_offset 22, -8
; LA32D-ILP32S-NEXT:    .cfi_offset 23, -12
; LA32D-ILP32S-NEXT:    move $fp, $a2
; LA32D-ILP32S-NEXT:    move $s0, $a0
; LA32D-ILP32S-NEXT:    move $a0, $a1
; LA32D-ILP32S-NEXT:    bl __extendhfsf2
; LA32D-ILP32S-NEXT:    movgr2fr.w $fa0, $a0
; LA32D-ILP32S-NEXT:    fst.s $fa0, $sp, 0 # 4-byte Folded Spill
; LA32D-ILP32S-NEXT:    move $a0, $s0
; LA32D-ILP32S-NEXT:    bl __extendhfsf2
; LA32D-ILP32S-NEXT:    movgr2fr.w $fa0, $a0
; LA32D-ILP32S-NEXT:    fld.s $fa1, $sp, 0 # 4-byte Folded Reload
; LA32D-ILP32S-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA32D-ILP32S-NEXT:    movfr2gr.s $a0, $fa0
; LA32D-ILP32S-NEXT:    bl __truncsfhf2
; LA32D-ILP32S-NEXT:    bl __extendhfsf2
; LA32D-ILP32S-NEXT:    movgr2fr.w $fa0, $a0
; LA32D-ILP32S-NEXT:    fst.s $fa0, $sp, 0 # 4-byte Folded Spill
; LA32D-ILP32S-NEXT:    move $a0, $fp
; LA32D-ILP32S-NEXT:    bl __extendhfsf2
; LA32D-ILP32S-NEXT:    movgr2fr.w $fa0, $a0
; LA32D-ILP32S-NEXT:    fld.s $fa1, $sp, 0 # 4-byte Folded Reload
; LA32D-ILP32S-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA32D-ILP32S-NEXT:    movfr2gr.s $a0, $fa0
; LA32D-ILP32S-NEXT:    bl __truncsfhf2
; LA32D-ILP32S-NEXT:    lu12i.w $a1, -16
; LA32D-ILP32S-NEXT:    or $a0, $a0, $a1
; LA32D-ILP32S-NEXT:    ld.w $s0, $sp, 4 # 4-byte Folded Reload
; LA32D-ILP32S-NEXT:    ld.w $fp, $sp, 8 # 4-byte Folded Reload
; LA32D-ILP32S-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32D-ILP32S-NEXT:    addi.w $sp, $sp, 16
; LA32D-ILP32S-NEXT:    ret
;
; LA32D-ILP32D-LABEL: f:
; LA32D-ILP32D:       # %bb.0:
; LA32D-ILP32D-NEXT:    addi.w $sp, $sp, -32
; LA32D-ILP32D-NEXT:    .cfi_def_cfa_offset 32
; LA32D-ILP32D-NEXT:    st.w $ra, $sp, 28 # 4-byte Folded Spill
; LA32D-ILP32D-NEXT:    fst.d $fs0, $sp, 16 # 8-byte Folded Spill
; LA32D-ILP32D-NEXT:    fst.d $fs1, $sp, 8 # 8-byte Folded Spill
; LA32D-ILP32D-NEXT:    fst.d $fs2, $sp, 0 # 8-byte Folded Spill
; LA32D-ILP32D-NEXT:    .cfi_offset 1, -4
; LA32D-ILP32D-NEXT:    .cfi_offset 56, -16
; LA32D-ILP32D-NEXT:    .cfi_offset 57, -24
; LA32D-ILP32D-NEXT:    .cfi_offset 58, -32
; LA32D-ILP32D-NEXT:    fmov.s $fs0, $fa2
; LA32D-ILP32D-NEXT:    fmov.s $fs1, $fa0
; LA32D-ILP32D-NEXT:    fmov.s $fa0, $fa1
; LA32D-ILP32D-NEXT:    bl __extendhfsf2
; LA32D-ILP32D-NEXT:    fmov.s $fs2, $fa0
; LA32D-ILP32D-NEXT:    fmov.s $fa0, $fs1
; LA32D-ILP32D-NEXT:    bl __extendhfsf2
; LA32D-ILP32D-NEXT:    fadd.s $fa0, $fa0, $fs2
; LA32D-ILP32D-NEXT:    bl __truncsfhf2
; LA32D-ILP32D-NEXT:    bl __extendhfsf2
; LA32D-ILP32D-NEXT:    fmov.s $fs1, $fa0
; LA32D-ILP32D-NEXT:    fmov.s $fa0, $fs0
; LA32D-ILP32D-NEXT:    bl __extendhfsf2
; LA32D-ILP32D-NEXT:    fadd.s $fa0, $fs1, $fa0
; LA32D-ILP32D-NEXT:    bl __truncsfhf2
; LA32D-ILP32D-NEXT:    movfr2gr.s $a0, $fa0
; LA32D-ILP32D-NEXT:    lu12i.w $a1, -16
; LA32D-ILP32D-NEXT:    or $a0, $a0, $a1
; LA32D-ILP32D-NEXT:    movgr2fr.w $fa0, $a0
; LA32D-ILP32D-NEXT:    fld.d $fs2, $sp, 0 # 8-byte Folded Reload
; LA32D-ILP32D-NEXT:    fld.d $fs1, $sp, 8 # 8-byte Folded Reload
; LA32D-ILP32D-NEXT:    fld.d $fs0, $sp, 16 # 8-byte Folded Reload
; LA32D-ILP32D-NEXT:    ld.w $ra, $sp, 28 # 4-byte Folded Reload
; LA32D-ILP32D-NEXT:    addi.w $sp, $sp, 32
; LA32D-ILP32D-NEXT:    ret
;
; LA64S-LABEL: f:
; LA64S:       # %bb.0:
; LA64S-NEXT:    addi.d $sp, $sp, -32
; LA64S-NEXT:    .cfi_def_cfa_offset 32
; LA64S-NEXT:    st.d $ra, $sp, 24 # 8-byte Folded Spill
; LA64S-NEXT:    fst.d $fs0, $sp, 16 # 8-byte Folded Spill
; LA64S-NEXT:    fst.d $fs1, $sp, 8 # 8-byte Folded Spill
; LA64S-NEXT:    fst.d $fs2, $sp, 0 # 8-byte Folded Spill
; LA64S-NEXT:    .cfi_offset 1, -8
; LA64S-NEXT:    .cfi_offset 56, -16
; LA64S-NEXT:    .cfi_offset 57, -24
; LA64S-NEXT:    .cfi_offset 58, -32
; LA64S-NEXT:    fmov.s $fs0, $fa2
; LA64S-NEXT:    fmov.s $fs1, $fa0
; LA64S-NEXT:    fmov.s $fa0, $fa1
; LA64S-NEXT:    pcaddu18i $ra, %call36(__extendhfsf2)
; LA64S-NEXT:    jirl $ra, $ra, 0
; LA64S-NEXT:    fmov.s $fs2, $fa0
; LA64S-NEXT:    fmov.s $fa0, $fs1
; LA64S-NEXT:    pcaddu18i $ra, %call36(__extendhfsf2)
; LA64S-NEXT:    jirl $ra, $ra, 0
; LA64S-NEXT:    fadd.s $fa0, $fa0, $fs2
; LA64S-NEXT:    pcaddu18i $ra, %call36(__truncsfhf2)
; LA64S-NEXT:    jirl $ra, $ra, 0
; LA64S-NEXT:    pcaddu18i $ra, %call36(__extendhfsf2)
; LA64S-NEXT:    jirl $ra, $ra, 0
; LA64S-NEXT:    fmov.s $fs1, $fa0
; LA64S-NEXT:    fmov.s $fa0, $fs0
; LA64S-NEXT:    pcaddu18i $ra, %call36(__extendhfsf2)
; LA64S-NEXT:    jirl $ra, $ra, 0
; LA64S-NEXT:    fadd.s $fa0, $fs1, $fa0
; LA64S-NEXT:    pcaddu18i $ra, %call36(__truncsfhf2)
; LA64S-NEXT:    jirl $ra, $ra, 0
; LA64S-NEXT:    movfr2gr.s $a0, $fa0
; LA64S-NEXT:    lu12i.w $a1, -16
; LA64S-NEXT:    or $a0, $a0, $a1
; LA64S-NEXT:    movgr2fr.w $fa0, $a0
; LA64S-NEXT:    fld.d $fs2, $sp, 0 # 8-byte Folded Reload
; LA64S-NEXT:    fld.d $fs1, $sp, 8 # 8-byte Folded Reload
; LA64S-NEXT:    fld.d $fs0, $sp, 16 # 8-byte Folded Reload
; LA64S-NEXT:    ld.d $ra, $sp, 24 # 8-byte Folded Reload
; LA64S-NEXT:    addi.d $sp, $sp, 32
; LA64S-NEXT:    ret
;
; LA64F-LP64S-LABEL: f:
; LA64F-LP64S:       # %bb.0:
; LA64F-LP64S-NEXT:    addi.d $sp, $sp, -32
; LA64F-LP64S-NEXT:    .cfi_def_cfa_offset 32
; LA64F-LP64S-NEXT:    st.d $ra, $sp, 24 # 8-byte Folded Spill
; LA64F-LP64S-NEXT:    st.d $fp, $sp, 16 # 8-byte Folded Spill
; LA64F-LP64S-NEXT:    st.d $s0, $sp, 8 # 8-byte Folded Spill
; LA64F-LP64S-NEXT:    .cfi_offset 1, -8
; LA64F-LP64S-NEXT:    .cfi_offset 22, -16
; LA64F-LP64S-NEXT:    .cfi_offset 23, -24
; LA64F-LP64S-NEXT:    move $fp, $a2
; LA64F-LP64S-NEXT:    move $s0, $a0
; LA64F-LP64S-NEXT:    move $a0, $a1
; LA64F-LP64S-NEXT:    pcaddu18i $ra, %call36(__extendhfsf2)
; LA64F-LP64S-NEXT:    jirl $ra, $ra, 0
; LA64F-LP64S-NEXT:    movgr2fr.w $fa0, $a0
; LA64F-LP64S-NEXT:    fst.s $fa0, $sp, 4 # 4-byte Folded Spill
; LA64F-LP64S-NEXT:    move $a0, $s0
; LA64F-LP64S-NEXT:    pcaddu18i $ra, %call36(__extendhfsf2)
; LA64F-LP64S-NEXT:    jirl $ra, $ra, 0
; LA64F-LP64S-NEXT:    movgr2fr.w $fa0, $a0
; LA64F-LP64S-NEXT:    fld.s $fa1, $sp, 4 # 4-byte Folded Reload
; LA64F-LP64S-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA64F-LP64S-NEXT:    movfr2gr.s $a0, $fa0
; LA64F-LP64S-NEXT:    pcaddu18i $ra, %call36(__truncsfhf2)
; LA64F-LP64S-NEXT:    jirl $ra, $ra, 0
; LA64F-LP64S-NEXT:    pcaddu18i $ra, %call36(__extendhfsf2)
; LA64F-LP64S-NEXT:    jirl $ra, $ra, 0
; LA64F-LP64S-NEXT:    movgr2fr.w $fa0, $a0
; LA64F-LP64S-NEXT:    fst.s $fa0, $sp, 4 # 4-byte Folded Spill
; LA64F-LP64S-NEXT:    move $a0, $fp
; LA64F-LP64S-NEXT:    pcaddu18i $ra, %call36(__extendhfsf2)
; LA64F-LP64S-NEXT:    jirl $ra, $ra, 0
; LA64F-LP64S-NEXT:    movgr2fr.w $fa0, $a0
; LA64F-LP64S-NEXT:    fld.s $fa1, $sp, 4 # 4-byte Folded Reload
; LA64F-LP64S-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64F-LP64S-NEXT:    movfr2gr.s $a0, $fa0
; LA64F-LP64S-NEXT:    pcaddu18i $ra, %call36(__truncsfhf2)
; LA64F-LP64S-NEXT:    jirl $ra, $ra, 0
; LA64F-LP64S-NEXT:    lu12i.w $a1, -16
; LA64F-LP64S-NEXT:    or $a0, $a0, $a1
; LA64F-LP64S-NEXT:    ld.d $s0, $sp, 8 # 8-byte Folded Reload
; LA64F-LP64S-NEXT:    ld.d $fp, $sp, 16 # 8-byte Folded Reload
; LA64F-LP64S-NEXT:    ld.d $ra, $sp, 24 # 8-byte Folded Reload
; LA64F-LP64S-NEXT:    addi.d $sp, $sp, 32
; LA64F-LP64S-NEXT:    ret
;
; LA64F-LP64D-LABEL: f:
; LA64F-LP64D:       # %bb.0:
; LA64F-LP64D-NEXT:    addi.d $sp, $sp, -32
; LA64F-LP64D-NEXT:    .cfi_def_cfa_offset 32
; LA64F-LP64D-NEXT:    st.d $ra, $sp, 24 # 8-byte Folded Spill
; LA64F-LP64D-NEXT:    fst.d $fs0, $sp, 16 # 8-byte Folded Spill
; LA64F-LP64D-NEXT:    fst.d $fs1, $sp, 8 # 8-byte Folded Spill
; LA64F-LP64D-NEXT:    fst.d $fs2, $sp, 0 # 8-byte Folded Spill
; LA64F-LP64D-NEXT:    .cfi_offset 1, -8
; LA64F-LP64D-NEXT:    .cfi_offset 56, -16
; LA64F-LP64D-NEXT:    .cfi_offset 57, -24
; LA64F-LP64D-NEXT:    .cfi_offset 58, -32
; LA64F-LP64D-NEXT:    fmov.s $fs0, $fa2
; LA64F-LP64D-NEXT:    fmov.s $fs1, $fa0
; LA64F-LP64D-NEXT:    fmov.s $fa0, $fa1
; LA64F-LP64D-NEXT:    pcaddu18i $ra, %call36(__extendhfsf2)
; LA64F-LP64D-NEXT:    jirl $ra, $ra, 0
; LA64F-LP64D-NEXT:    fmov.s $fs2, $fa0
; LA64F-LP64D-NEXT:    fmov.s $fa0, $fs1
; LA64F-LP64D-NEXT:    pcaddu18i $ra, %call36(__extendhfsf2)
; LA64F-LP64D-NEXT:    jirl $ra, $ra, 0
; LA64F-LP64D-NEXT:    fadd.s $fa0, $fa0, $fs2
; LA64F-LP64D-NEXT:    pcaddu18i $ra, %call36(__truncsfhf2)
; LA64F-LP64D-NEXT:    jirl $ra, $ra, 0
; LA64F-LP64D-NEXT:    pcaddu18i $ra, %call36(__extendhfsf2)
; LA64F-LP64D-NEXT:    jirl $ra, $ra, 0
; LA64F-LP64D-NEXT:    fmov.s $fs1, $fa0
; LA64F-LP64D-NEXT:    fmov.s $fa0, $fs0
; LA64F-LP64D-NEXT:    pcaddu18i $ra, %call36(__extendhfsf2)
; LA64F-LP64D-NEXT:    jirl $ra, $ra, 0
; LA64F-LP64D-NEXT:    fadd.s $fa0, $fs1, $fa0
; LA64F-LP64D-NEXT:    pcaddu18i $ra, %call36(__truncsfhf2)
; LA64F-LP64D-NEXT:    jirl $ra, $ra, 0
; LA64F-LP64D-NEXT:    movfr2gr.s $a0, $fa0
; LA64F-LP64D-NEXT:    lu12i.w $a1, -16
; LA64F-LP64D-NEXT:    or $a0, $a0, $a1
; LA64F-LP64D-NEXT:    movgr2fr.w $fa0, $a0
; LA64F-LP64D-NEXT:    fld.d $fs2, $sp, 0 # 8-byte Folded Reload
; LA64F-LP64D-NEXT:    fld.d $fs1, $sp, 8 # 8-byte Folded Reload
; LA64F-LP64D-NEXT:    fld.d $fs0, $sp, 16 # 8-byte Folded Reload
; LA64F-LP64D-NEXT:    ld.d $ra, $sp, 24 # 8-byte Folded Reload
; LA64F-LP64D-NEXT:    addi.d $sp, $sp, 32
; LA64F-LP64D-NEXT:    ret
;
; LA64D-LP64S-LABEL: f:
; LA64D-LP64S:       # %bb.0:
; LA64D-LP64S-NEXT:    addi.d $sp, $sp, -32
; LA64D-LP64S-NEXT:    .cfi_def_cfa_offset 32
; LA64D-LP64S-NEXT:    st.d $ra, $sp, 24 # 8-byte Folded Spill
; LA64D-LP64S-NEXT:    st.d $fp, $sp, 16 # 8-byte Folded Spill
; LA64D-LP64S-NEXT:    st.d $s0, $sp, 8 # 8-byte Folded Spill
; LA64D-LP64S-NEXT:    .cfi_offset 1, -8
; LA64D-LP64S-NEXT:    .cfi_offset 22, -16
; LA64D-LP64S-NEXT:    .cfi_offset 23, -24
; LA64D-LP64S-NEXT:    move $fp, $a2
; LA64D-LP64S-NEXT:    move $s0, $a0
; LA64D-LP64S-NEXT:    move $a0, $a1
; LA64D-LP64S-NEXT:    pcaddu18i $ra, %call36(__extendhfsf2)
; LA64D-LP64S-NEXT:    jirl $ra, $ra, 0
; LA64D-LP64S-NEXT:    movgr2fr.w $fa0, $a0
; LA64D-LP64S-NEXT:    fst.s $fa0, $sp, 4 # 4-byte Folded Spill
; LA64D-LP64S-NEXT:    move $a0, $s0
; LA64D-LP64S-NEXT:    pcaddu18i $ra, %call36(__extendhfsf2)
; LA64D-LP64S-NEXT:    jirl $ra, $ra, 0
; LA64D-LP64S-NEXT:    movgr2fr.w $fa0, $a0
; LA64D-LP64S-NEXT:    fld.s $fa1, $sp, 4 # 4-byte Folded Reload
; LA64D-LP64S-NEXT:    fadd.s $fa0, $fa0, $fa1
; LA64D-LP64S-NEXT:    movfr2gr.s $a0, $fa0
; LA64D-LP64S-NEXT:    pcaddu18i $ra, %call36(__truncsfhf2)
; LA64D-LP64S-NEXT:    jirl $ra, $ra, 0
; LA64D-LP64S-NEXT:    pcaddu18i $ra, %call36(__extendhfsf2)
; LA64D-LP64S-NEXT:    jirl $ra, $ra, 0
; LA64D-LP64S-NEXT:    movgr2fr.w $fa0, $a0
; LA64D-LP64S-NEXT:    fst.s $fa0, $sp, 4 # 4-byte Folded Spill
; LA64D-LP64S-NEXT:    move $a0, $fp
; LA64D-LP64S-NEXT:    pcaddu18i $ra, %call36(__extendhfsf2)
; LA64D-LP64S-NEXT:    jirl $ra, $ra, 0
; LA64D-LP64S-NEXT:    movgr2fr.w $fa0, $a0
; LA64D-LP64S-NEXT:    fld.s $fa1, $sp, 4 # 4-byte Folded Reload
; LA64D-LP64S-NEXT:    fadd.s $fa0, $fa1, $fa0
; LA64D-LP64S-NEXT:    movfr2gr.s $a0, $fa0
; LA64D-LP64S-NEXT:    pcaddu18i $ra, %call36(__truncsfhf2)
; LA64D-LP64S-NEXT:    jirl $ra, $ra, 0
; LA64D-LP64S-NEXT:    lu12i.w $a1, -16
; LA64D-LP64S-NEXT:    or $a0, $a0, $a1
; LA64D-LP64S-NEXT:    ld.d $s0, $sp, 8 # 8-byte Folded Reload
; LA64D-LP64S-NEXT:    ld.d $fp, $sp, 16 # 8-byte Folded Reload
; LA64D-LP64S-NEXT:    ld.d $ra, $sp, 24 # 8-byte Folded Reload
; LA64D-LP64S-NEXT:    addi.d $sp, $sp, 32
; LA64D-LP64S-NEXT:    ret
;
; LA64D-LP64D-LABEL: f:
; LA64D-LP64D:       # %bb.0:
; LA64D-LP64D-NEXT:    addi.d $sp, $sp, -32
; LA64D-LP64D-NEXT:    .cfi_def_cfa_offset 32
; LA64D-LP64D-NEXT:    st.d $ra, $sp, 24 # 8-byte Folded Spill
; LA64D-LP64D-NEXT:    fst.d $fs0, $sp, 16 # 8-byte Folded Spill
; LA64D-LP64D-NEXT:    fst.d $fs1, $sp, 8 # 8-byte Folded Spill
; LA64D-LP64D-NEXT:    fst.d $fs2, $sp, 0 # 8-byte Folded Spill
; LA64D-LP64D-NEXT:    .cfi_offset 1, -8
; LA64D-LP64D-NEXT:    .cfi_offset 56, -16
; LA64D-LP64D-NEXT:    .cfi_offset 57, -24
; LA64D-LP64D-NEXT:    .cfi_offset 58, -32
; LA64D-LP64D-NEXT:    fmov.s $fs0, $fa2
; LA64D-LP64D-NEXT:    fmov.s $fs1, $fa0
; LA64D-LP64D-NEXT:    fmov.s $fa0, $fa1
; LA64D-LP64D-NEXT:    pcaddu18i $ra, %call36(__extendhfsf2)
; LA64D-LP64D-NEXT:    jirl $ra, $ra, 0
; LA64D-LP64D-NEXT:    fmov.s $fs2, $fa0
; LA64D-LP64D-NEXT:    fmov.s $fa0, $fs1
; LA64D-LP64D-NEXT:    pcaddu18i $ra, %call36(__extendhfsf2)
; LA64D-LP64D-NEXT:    jirl $ra, $ra, 0
; LA64D-LP64D-NEXT:    fadd.s $fa0, $fa0, $fs2
; LA64D-LP64D-NEXT:    pcaddu18i $ra, %call36(__truncsfhf2)
; LA64D-LP64D-NEXT:    jirl $ra, $ra, 0
; LA64D-LP64D-NEXT:    pcaddu18i $ra, %call36(__extendhfsf2)
; LA64D-LP64D-NEXT:    jirl $ra, $ra, 0
; LA64D-LP64D-NEXT:    fmov.s $fs1, $fa0
; LA64D-LP64D-NEXT:    fmov.s $fa0, $fs0
; LA64D-LP64D-NEXT:    pcaddu18i $ra, %call36(__extendhfsf2)
; LA64D-LP64D-NEXT:    jirl $ra, $ra, 0
; LA64D-LP64D-NEXT:    fadd.s $fa0, $fs1, $fa0
; LA64D-LP64D-NEXT:    pcaddu18i $ra, %call36(__truncsfhf2)
; LA64D-LP64D-NEXT:    jirl $ra, $ra, 0
; LA64D-LP64D-NEXT:    movfr2gr.s $a0, $fa0
; LA64D-LP64D-NEXT:    lu12i.w $a1, -16
; LA64D-LP64D-NEXT:    or $a0, $a0, $a1
; LA64D-LP64D-NEXT:    movgr2fr.w $fa0, $a0
; LA64D-LP64D-NEXT:    fld.d $fs2, $sp, 0 # 8-byte Folded Reload
; LA64D-LP64D-NEXT:    fld.d $fs1, $sp, 8 # 8-byte Folded Reload
; LA64D-LP64D-NEXT:    fld.d $fs0, $sp, 16 # 8-byte Folded Reload
; LA64D-LP64D-NEXT:    ld.d $ra, $sp, 24 # 8-byte Folded Reload
; LA64D-LP64D-NEXT:    addi.d $sp, $sp, 32
; LA64D-LP64D-NEXT:    ret
    %d = fadd half %a, %b
    %e = fadd half %d, %c
    ret half %e
}
