; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sve2p1,+bf16 < %s | FileCheck %s --check-prefixes=CHECK,SVE
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sme2p1,+bf16 -force-streaming < %s | FileCheck %s --check-prefixes=CHECK,SME

define void @dupq_i8_256b(ptr %addr) #0 {
; CHECK-LABEL: dupq_i8_256b:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr z0, [x0]
; CHECK-NEXT:    dupq z0.b, z0.b[15]
; CHECK-NEXT:    str z0, [x0]
; CHECK-NEXT:    ret
  %load = load <32 x i8>, ptr %addr
  %splat.lanes = shufflevector <32 x i8> %load, <32 x i8> poison, <32 x i32> <i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15, i32 15,
                                                                              i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31>
  store <32 x i8> %splat.lanes, ptr %addr
  ret void
}

define void @dupq_i16_256b(ptr %addr) #0 {
; CHECK-LABEL: dupq_i16_256b:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr z0, [x0]
; CHECK-NEXT:    dupq z0.h, z0.h[2]
; CHECK-NEXT:    str z0, [x0]
; CHECK-NEXT:    ret
  %load = load <16 x i16>, ptr %addr
  %splat.lanes = shufflevector <16 x i16> %load, <16 x i16> poison, <16 x i32> <i32  2, i32  2, i32  2, i32  2, i32  2, i32  2, i32  2, i32  2,
                                                                                i32 10, i32 10, i32 10, i32 10, i32 10, i32 10, i32 10, i32 10>
  store <16 x i16> %splat.lanes, ptr %addr
  ret void
}

define void @dupq_i32_256b(ptr %addr) #0 {
; CHECK-LABEL: dupq_i32_256b:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr z0, [x0]
; CHECK-NEXT:    dupq z0.s, z0.s[3]
; CHECK-NEXT:    str z0, [x0]
; CHECK-NEXT:    ret
  %load = load <8 x i32>, ptr %addr
  %splat.lanes = shufflevector <8 x i32> %load, <8 x i32> poison, <8 x i32> <i32 3, i32 3, i32 3, i32 3,
                                                                             i32 7, i32 7, i32 7, i32 7>
  store <8 x i32> %splat.lanes, ptr %addr
  ret void
}

define void @dupq_i64_256b(ptr %addr) #0 {
; CHECK-LABEL: dupq_i64_256b:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr z0, [x0]
; CHECK-NEXT:    trn1 z0.d, z0.d, z0.d
; CHECK-NEXT:    str z0, [x0]
; CHECK-NEXT:    ret
  %load = load <4 x i64>, ptr %addr
  %splat.lanes = shufflevector <4 x i64> %load, <4 x i64> poison, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  store <4 x i64> %splat.lanes, ptr %addr
  ret void
}

define void @dupq_f16_256b(ptr %addr) #0 {
; CHECK-LABEL: dupq_f16_256b:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr z0, [x0]
; CHECK-NEXT:    dupq z0.h, z0.h[2]
; CHECK-NEXT:    str z0, [x0]
; CHECK-NEXT:    ret
  %load = load <16 x half>, ptr %addr
  %splat.lanes = shufflevector <16 x half> %load, <16 x half> poison, <16 x i32> <i32  2, i32  2, i32  2, i32  2, i32  2, i32  2, i32  2, i32  2,
                                                                                  i32 10, i32 10, i32 10, i32 10, i32 10, i32 10, i32 10, i32 10>
  store <16 x half> %splat.lanes, ptr %addr
  ret void
}

define void @dupq_bf16_256b(ptr %addr) #0 {
; SVE-LABEL: dupq_bf16_256b:
; SVE:       // %bb.0:
; SVE-NEXT:    ldp q0, q1, [x0]
; SVE-NEXT:    dup v0.8h, v0.h[2]
; SVE-NEXT:    dup v1.8h, v1.h[2]
; SVE-NEXT:    stp q0, q1, [x0]
; SVE-NEXT:    ret
;
; SME-LABEL: dupq_bf16_256b:
; SME:       // %bb.0:
; SME-NEXT:    ldp q1, q0, [x0]
; SME-NEXT:    str q0, [sp, #-64]!
; SME-NEXT:    .cfi_def_cfa_offset 64
; SME-NEXT:    ldr h0, [sp, #4]
; SME-NEXT:    str q1, [sp, #32]
; SME-NEXT:    str h0, [sp, #30]
; SME-NEXT:    str h0, [sp, #28]
; SME-NEXT:    str h0, [sp, #26]
; SME-NEXT:    str h0, [sp, #24]
; SME-NEXT:    str h0, [sp, #22]
; SME-NEXT:    str h0, [sp, #20]
; SME-NEXT:    str h0, [sp, #18]
; SME-NEXT:    str h0, [sp, #16]
; SME-NEXT:    ldr h0, [sp, #36]
; SME-NEXT:    ldr q1, [sp, #16]
; SME-NEXT:    str h0, [sp, #62]
; SME-NEXT:    str h0, [sp, #60]
; SME-NEXT:    str h0, [sp, #58]
; SME-NEXT:    str h0, [sp, #56]
; SME-NEXT:    str h0, [sp, #54]
; SME-NEXT:    str h0, [sp, #52]
; SME-NEXT:    str h0, [sp, #50]
; SME-NEXT:    str h0, [sp, #48]
; SME-NEXT:    ldr q0, [sp, #48]
; SME-NEXT:    stp q0, q1, [x0]
; SME-NEXT:    add sp, sp, #64
; SME-NEXT:    ret
  %load = load <16 x bfloat>, ptr %addr
  %splat.lanes = shufflevector <16 x bfloat> %load, <16 x bfloat> poison, <16 x i32> <i32  2, i32  2, i32  2, i32  2, i32  2, i32  2, i32  2, i32  2,
                                                                                      i32 10, i32 10, i32 10, i32 10, i32 10, i32 10, i32 10, i32 10>
  store <16 x bfloat> %splat.lanes, ptr %addr
  ret void
}

define void @dupq_f32_256b(ptr %addr) #0 {
; CHECK-LABEL: dupq_f32_256b:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr z0, [x0]
; CHECK-NEXT:    dupq z0.s, z0.s[3]
; CHECK-NEXT:    str z0, [x0]
; CHECK-NEXT:    ret
  %load = load <8 x float>, ptr %addr
  %splat.lanes = shufflevector <8 x float> %load, <8 x float> poison, <8 x i32> <i32 3, i32 3, i32 3, i32 3,
                                                                                 i32 7, i32 7, i32 7, i32 7>
  store <8 x float> %splat.lanes, ptr %addr
  ret void
}

define void @dupq_f64_256b(ptr %addr) #0 {
; CHECK-LABEL: dupq_f64_256b:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr z0, [x0]
; CHECK-NEXT:    trn1 z0.d, z0.d, z0.d
; CHECK-NEXT:    str z0, [x0]
; CHECK-NEXT:    ret
  %load = load <4 x double>, ptr %addr
  %splat.lanes = shufflevector <4 x double> %load, <4 x double> poison, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  store <4 x double> %splat.lanes, ptr %addr
  ret void
}

define void @dupq_f32_256b_with_poison(ptr %addr) #0 {
; CHECK-LABEL: dupq_f32_256b_with_poison:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr z0, [x0]
; CHECK-NEXT:    dupq z0.s, z0.s[3]
; CHECK-NEXT:    str z0, [x0]
; CHECK-NEXT:    ret
  %load = load <8 x float>, ptr %addr
  %splat.lanes = shufflevector <8 x float> %load, <8 x float> poison, <8 x i32> <i32 3, i32 poison, i32 3, i32 3,
                                                                                 i32 7, i32 7, i32 7, i32 poison>
  store <8 x float> %splat.lanes, ptr %addr
  ret void
}

attributes #0 = { noinline vscale_range(2,2) }
