; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=nary-reassociate -S | FileCheck %s

target datalayout = "e-p:64:64-p1:32:32:32-p2:128:128:128:32-i64:64-v16:16-v32:32-n32:64"

; Even though addrspace(2) has 128 bit pointers, no sign extension needed
; becasue it has 32-bit offsets.
define void @no_sext_fat_pointer(ptr addrspace(2) %a, i32 %i, i32 %j) {
; CHECK-LABEL: @no_sext_fat_pointer(
; CHECK-NEXT:    [[V2:%.*]] = getelementptr float, ptr addrspace(2) [[A:%.*]], i32 [[I:%.*]]
; CHECK-NEXT:    call void @foo(ptr addrspace(2) [[V2]])
; CHECK-NEXT:    [[V3:%.*]] = getelementptr float, ptr addrspace(2) [[V2]], i32 [[J:%.*]]
; CHECK-NEXT:    call void @foo(ptr addrspace(2) [[V3]])
; CHECK-NEXT:    ret void
;
  %v1 = add i32 %i, %j
  %v2 = getelementptr float, ptr addrspace(2) %a, i32 %i
  call void @foo(ptr addrspace(2) %v2)
  %v3 = getelementptr float, ptr addrspace(2) %a, i32 %v1
  call void @foo(ptr addrspace(2) %v3)
  ret void
}

define ptr addrspace(2) @zext_fat_pointer_crash(ptr addrspace(2) %p, i32 %a) {
; CHECK-LABEL: @zext_fat_pointer_crash(
; CHECK-NEXT:    [[C:%.*]] = add i32 [[A:%.*]], 1
; CHECK-NEXT:    [[Q:%.*]] = getelementptr double, ptr addrspace(2) [[P:%.*]], i32 [[C]]
; CHECK-NEXT:    ret ptr addrspace(2) [[Q]]
;
  %c = add i32 %a, 1
  %q = getelementptr double, ptr addrspace(2) %p, i32 %c
  ret ptr addrspace(2) %q
}

define void @or_disjoint(ptr addrspace(2) %a, i32 %i, i32 %j, i32 %k) {
; CHECK-LABEL: @or_disjoint(
; CHECK-NEXT:    [[OR:%.*]] = or disjoint i32 [[I:%.*]], [[J:%.*]]
; CHECK-NEXT:    [[V2:%.*]] = getelementptr float, ptr addrspace(2) [[A:%.*]], i32 [[OR]]
; CHECK-NEXT:    call void @foo(ptr addrspace(2) [[V2]])
; CHECK-NEXT:    [[ADD1:%.*]] = add nuw nsw i32 [[I]], [[J]]
; CHECK-NEXT:    [[ADD2:%.*]] = add nuw nsw i32 [[ADD1]], [[K:%.*]]
; CHECK-NEXT:    [[V3:%.*]] = getelementptr float, ptr addrspace(2) [[A]], i32 [[ADD2]]
; CHECK-NEXT:    call void @foo(ptr addrspace(2) [[V3]])
; CHECK-NEXT:    ret void
;
  %or = or disjoint i32 %i, %j
  %v2 = getelementptr float, ptr addrspace(2) %a, i32 %or
  call void @foo(ptr addrspace(2) %v2)
  %add1 = add nuw nsw i32 %i, %j
  %add2 = add nuw nsw i32 %add1, %k
  %v3 = getelementptr float, ptr addrspace(2) %a, i32 %add2
  call void @foo(ptr addrspace(2) %v3)
  ret void
}

define void @drop_nuw_nsw(ptr addrspace(2) %a, i32 %i, i32 %j, i32 %k) {
; CHECK-LABEL: @drop_nuw_nsw(
; CHECK-NEXT:    [[ADD0:%.*]] = add i32 [[I:%.*]], [[J:%.*]]
; CHECK-NEXT:    [[V2:%.*]] = getelementptr float, ptr addrspace(2) [[A:%.*]], i32 [[ADD0]]
; CHECK-NEXT:    call void @foo(ptr addrspace(2) [[V2]])
; CHECK-NEXT:    [[V3:%.*]] = getelementptr float, ptr addrspace(2) [[V2]], i32 [[K:%.*]]
; CHECK-NEXT:    call void @foo(ptr addrspace(2) [[V3]])
; CHECK-NEXT:    ret void
;
  %add0 = add nuw nsw i32 %i, %j
  %v2 = getelementptr float, ptr addrspace(2) %a, i32 %add0
  call void @foo(ptr addrspace(2) %v2)
  %add1 = add i32 %i, %j
  %add2 = add nuw nsw i32 %add1, %k
  %v3 = getelementptr float, ptr addrspace(2) %a, i32 %add2
  call void @foo(ptr addrspace(2) %v3)
  ret void
}

declare void @foo(ptr addrspace(2))
