; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -mtriple=thumbv8m.main -passes=indvars -S < %s | FileCheck %s --check-prefix=CHECK-V8M
; RUN: opt -mtriple=thumbv8a -passes=indvars -S < %s | FileCheck %s --check-prefix=CHECK-V8A

define i32 @remove_loop(i32 %size) #0 {
; CHECK-V8M-LABEL: @remove_loop(
; CHECK-V8M-SAME: i32 [[SIZE:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-V8M-NEXT:  entry:
; CHECK-V8M-NEXT:    br label %[[WHILE_COND:.*]]
; CHECK-V8M:       while.cond:
; CHECK-V8M-NEXT:    br i1 false, label %[[WHILE_COND]], label %[[WHILE_END:.*]]
; CHECK-V8M:       while.end:
; CHECK-V8M-NEXT:    [[TMP0:%.*]] = add i32 [[SIZE]], 31
; CHECK-V8M-NEXT:    [[UMIN:%.*]] = call i32 @llvm.umin.i32(i32 [[SIZE]], i32 31)
; CHECK-V8M-NEXT:    [[TMP1:%.*]] = sub i32 [[TMP0]], [[UMIN]]
; CHECK-V8M-NEXT:    [[TMP2:%.*]] = lshr i32 [[TMP1]], 5
; CHECK-V8M-NEXT:    [[TMP3:%.*]] = shl nuw i32 [[TMP2]], 5
; CHECK-V8M-NEXT:    [[TMP4:%.*]] = sub i32 [[SIZE]], [[TMP3]]
; CHECK-V8M-NEXT:    ret i32 [[TMP4]]
;
; CHECK-V8A-LABEL: @remove_loop(
; CHECK-V8A-SAME: i32 [[SIZE:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-V8A-NEXT:  entry:
; CHECK-V8A-NEXT:    br label %[[WHILE_COND:.*]]
; CHECK-V8A:       while.cond:
; CHECK-V8A-NEXT:    br i1 false, label %[[WHILE_COND]], label %[[WHILE_END:.*]]
; CHECK-V8A:       while.end:
; CHECK-V8A-NEXT:    [[TMP0:%.*]] = add i32 [[SIZE]], 31
; CHECK-V8A-NEXT:    [[UMIN:%.*]] = call i32 @llvm.umin.i32(i32 [[SIZE]], i32 31)
; CHECK-V8A-NEXT:    [[TMP1:%.*]] = sub i32 [[TMP0]], [[UMIN]]
; CHECK-V8A-NEXT:    [[TMP2:%.*]] = lshr i32 [[TMP1]], 5
; CHECK-V8A-NEXT:    [[TMP3:%.*]] = shl nuw i32 [[TMP2]], 5
; CHECK-V8A-NEXT:    [[TMP4:%.*]] = sub i32 [[SIZE]], [[TMP3]]
; CHECK-V8A-NEXT:    ret i32 [[TMP4]]
;
entry:
  br label %while.cond

while.cond:                                       ; preds = %while.cond, %entry
  %size.addr.0 = phi i32 [ %size, %entry ], [ %sub, %while.cond ]
  %cmp = icmp ugt i32 %size.addr.0, 31
  %sub = add i32 %size.addr.0, -32
  br i1 %cmp, label %while.cond, label %while.end

while.end:                                        ; preds = %while.cond
  %size.lcssa = phi i32 [ %size.addr.0, %while.cond ]
  ret i32 %size.lcssa
}

define void @expandOuterRecurrence(i32 %arg) nounwind #0 {
; CHECK-V8M-LABEL: @expandOuterRecurrence(
; CHECK-V8M-NEXT:  entry:
; CHECK-V8M-NEXT:    [[SUB1:%.*]] = sub nsw i32 [[ARG:%.*]], 1
; CHECK-V8M-NEXT:    [[CMP1:%.*]] = icmp slt i32 0, [[SUB1]]
; CHECK-V8M-NEXT:    br i1 [[CMP1]], label [[OUTER_PREHEADER:%.*]], label [[EXIT:%.*]]
; CHECK-V8M:       outer.preheader:
; CHECK-V8M-NEXT:    br label [[OUTER:%.*]]
; CHECK-V8M:       outer:
; CHECK-V8M-NEXT:    [[I:%.*]] = phi i32 [ [[I_INC:%.*]], [[OUTER_INC:%.*]] ], [ 0, [[OUTER_PREHEADER]] ]
; CHECK-V8M-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[ARG]], [[I]]
; CHECK-V8M-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[SUB2]], 1
; CHECK-V8M-NEXT:    [[CMP2:%.*]] = icmp slt i32 0, [[SUB3]]
; CHECK-V8M-NEXT:    br i1 [[CMP2]], label [[INNER_PH:%.*]], label [[OUTER_INC]]
; CHECK-V8M:       inner.ph:
; CHECK-V8M-NEXT:    br label [[INNER:%.*]]
; CHECK-V8M:       inner:
; CHECK-V8M-NEXT:    br i1 false, label [[INNER]], label [[OUTER_INC_LOOPEXIT:%.*]]
; CHECK-V8M:       outer.inc.loopexit:
; CHECK-V8M-NEXT:    br label [[OUTER_INC]]
; CHECK-V8M:       outer.inc:
; CHECK-V8M-NEXT:    [[I_INC]] = add nuw nsw i32 [[I]], 1
; CHECK-V8M-NEXT:    br i1 false, label [[OUTER]], label [[EXIT_LOOPEXIT:%.*]]
; CHECK-V8M:       exit.loopexit:
; CHECK-V8M-NEXT:    br label [[EXIT]]
; CHECK-V8M:       exit:
; CHECK-V8M-NEXT:    ret void
;
; CHECK-V8A-LABEL: @expandOuterRecurrence(
; CHECK-V8A-NEXT:  entry:
; CHECK-V8A-NEXT:    [[SUB1:%.*]] = sub nsw i32 [[ARG:%.*]], 1
; CHECK-V8A-NEXT:    [[CMP1:%.*]] = icmp slt i32 0, [[SUB1]]
; CHECK-V8A-NEXT:    br i1 [[CMP1]], label [[OUTER_PREHEADER:%.*]], label [[EXIT:%.*]]
; CHECK-V8A:       outer.preheader:
; CHECK-V8A-NEXT:    br label [[OUTER:%.*]]
; CHECK-V8A:       outer:
; CHECK-V8A-NEXT:    [[I:%.*]] = phi i32 [ [[I_INC:%.*]], [[OUTER_INC:%.*]] ], [ 0, [[OUTER_PREHEADER]] ]
; CHECK-V8A-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[ARG]], [[I]]
; CHECK-V8A-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[SUB2]], 1
; CHECK-V8A-NEXT:    [[CMP2:%.*]] = icmp slt i32 0, [[SUB3]]
; CHECK-V8A-NEXT:    br i1 [[CMP2]], label [[INNER_PH:%.*]], label [[OUTER_INC]]
; CHECK-V8A:       inner.ph:
; CHECK-V8A-NEXT:    br label [[INNER:%.*]]
; CHECK-V8A:       inner:
; CHECK-V8A-NEXT:    br i1 false, label [[INNER]], label [[OUTER_INC_LOOPEXIT:%.*]]
; CHECK-V8A:       outer.inc.loopexit:
; CHECK-V8A-NEXT:    br label [[OUTER_INC]]
; CHECK-V8A:       outer.inc:
; CHECK-V8A-NEXT:    [[I_INC]] = add nuw nsw i32 [[I]], 1
; CHECK-V8A-NEXT:    br i1 false, label [[OUTER]], label [[EXIT_LOOPEXIT:%.*]]
; CHECK-V8A:       exit.loopexit:
; CHECK-V8A-NEXT:    br label [[EXIT]]
; CHECK-V8A:       exit:
; CHECK-V8A-NEXT:    ret void
;
entry:
  %sub1 = sub nsw i32 %arg, 1
  %cmp1 = icmp slt i32 0, %sub1
  br i1 %cmp1, label %outer, label %exit

outer:
  %i = phi i32 [ 0, %entry ], [ %i.inc, %outer.inc ]
  %sub2 = sub nsw i32 %arg, %i
  %sub3 = sub nsw i32 %sub2, 1
  %cmp2 = icmp slt i32 0, %sub3
  br i1 %cmp2, label %inner.ph, label %outer.inc

inner.ph:
  br label %inner

inner:
  %j = phi i32 [ 0, %inner.ph ], [ %j.inc, %inner ]
  %j.inc = add nsw i32 %j, 1
  %cmp3 = icmp slt i32 %j.inc, %sub3
  br i1 %cmp3, label %inner, label %outer.inc

outer.inc:
  %i.inc = add nsw i32 %i, 1
  %cmp4 = icmp slt i32 %i.inc, %sub1
  br i1 %cmp4, label %outer, label %exit

exit:
  ret void
}

define i32 @test1(ptr %array, i32 %length, i32 %n) #0 {
; CHECK-V8M-LABEL: @test1(
; CHECK-V8M-NEXT:  loop.preheader:
; CHECK-V8M-NEXT:    [[UMAX:%.*]] = call i32 @llvm.umax.i32(i32 [[N:%.*]], i32 1)
; CHECK-V8M-NEXT:    [[TMP0:%.*]] = add i32 [[UMAX]], -1
; CHECK-V8M-NEXT:    [[TMP1:%.*]] = freeze i32 [[TMP0]]
; CHECK-V8M-NEXT:    [[UMIN:%.*]] = call i32 @llvm.umin.i32(i32 [[TMP1]], i32 [[LENGTH:%.*]])
; CHECK-V8M-NEXT:    [[TMP2:%.*]] = icmp ne i32 [[LENGTH]], [[UMIN]]
; CHECK-V8M-NEXT:    br label [[LOOP:%.*]]
; CHECK-V8M:       loop:
; CHECK-V8M-NEXT:    [[LOOP_ACC:%.*]] = phi i32 [ [[LOOP_ACC_NEXT:%.*]], [[GUARDED:%.*]] ], [ 0, [[LOOP_PREHEADER:%.*]] ]
; CHECK-V8M-NEXT:    [[I:%.*]] = phi i32 [ [[I_NEXT:%.*]], [[GUARDED]] ], [ 0, [[LOOP_PREHEADER]] ]
; CHECK-V8M-NEXT:    br i1 [[TMP2]], label [[GUARDED]], label [[DEOPT:%.*]], !prof [[PROF0:![0-9]+]]
; CHECK-V8M:       deopt:
; CHECK-V8M-NEXT:    call void @prevent_merging()
; CHECK-V8M-NEXT:    ret i32 -1
; CHECK-V8M:       guarded:
; CHECK-V8M-NEXT:    [[I_I64:%.*]] = zext i32 [[I]] to i64
; CHECK-V8M-NEXT:    [[ARRAY_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY:%.*]], i64 [[I_I64]]
; CHECK-V8M-NEXT:    [[ARRAY_I:%.*]] = load i32, ptr [[ARRAY_I_PTR]], align 4
; CHECK-V8M-NEXT:    [[LOOP_ACC_NEXT]] = add i32 [[LOOP_ACC]], [[ARRAY_I]]
; CHECK-V8M-NEXT:    [[I_NEXT]] = add nuw i32 [[I]], 1
; CHECK-V8M-NEXT:    [[CONTINUE:%.*]] = icmp ult i32 [[I_NEXT]], [[N]]
; CHECK-V8M-NEXT:    br i1 [[CONTINUE]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK-V8M:       exit:
; CHECK-V8M-NEXT:    [[RESULT:%.*]] = phi i32 [ [[LOOP_ACC_NEXT]], [[GUARDED]] ]
; CHECK-V8M-NEXT:    ret i32 [[RESULT]]
;
; CHECK-V8A-LABEL: @test1(
; CHECK-V8A-NEXT:  loop.preheader:
; CHECK-V8A-NEXT:    [[UMAX:%.*]] = call i32 @llvm.umax.i32(i32 [[N:%.*]], i32 1)
; CHECK-V8A-NEXT:    [[TMP0:%.*]] = add i32 [[UMAX]], -1
; CHECK-V8A-NEXT:    [[TMP1:%.*]] = freeze i32 [[TMP0]]
; CHECK-V8A-NEXT:    [[UMIN:%.*]] = call i32 @llvm.umin.i32(i32 [[TMP1]], i32 [[LENGTH:%.*]])
; CHECK-V8A-NEXT:    [[TMP2:%.*]] = icmp ne i32 [[LENGTH]], [[UMIN]]
; CHECK-V8A-NEXT:    br label [[LOOP:%.*]]
; CHECK-V8A:       loop:
; CHECK-V8A-NEXT:    [[LOOP_ACC:%.*]] = phi i32 [ [[LOOP_ACC_NEXT:%.*]], [[GUARDED:%.*]] ], [ 0, [[LOOP_PREHEADER:%.*]] ]
; CHECK-V8A-NEXT:    [[I:%.*]] = phi i32 [ [[I_NEXT:%.*]], [[GUARDED]] ], [ 0, [[LOOP_PREHEADER]] ]
; CHECK-V8A-NEXT:    br i1 [[TMP2]], label [[GUARDED]], label [[DEOPT:%.*]], !prof [[PROF0:![0-9]+]]
; CHECK-V8A:       deopt:
; CHECK-V8A-NEXT:    call void @prevent_merging()
; CHECK-V8A-NEXT:    ret i32 -1
; CHECK-V8A:       guarded:
; CHECK-V8A-NEXT:    [[I_I64:%.*]] = zext i32 [[I]] to i64
; CHECK-V8A-NEXT:    [[ARRAY_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY:%.*]], i64 [[I_I64]]
; CHECK-V8A-NEXT:    [[ARRAY_I:%.*]] = load i32, ptr [[ARRAY_I_PTR]], align 4
; CHECK-V8A-NEXT:    [[LOOP_ACC_NEXT]] = add i32 [[LOOP_ACC]], [[ARRAY_I]]
; CHECK-V8A-NEXT:    [[I_NEXT]] = add nuw i32 [[I]], 1
; CHECK-V8A-NEXT:    [[CONTINUE:%.*]] = icmp ult i32 [[I_NEXT]], [[N]]
; CHECK-V8A-NEXT:    br i1 [[CONTINUE]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK-V8A:       exit:
; CHECK-V8A-NEXT:    [[RESULT:%.*]] = phi i32 [ [[LOOP_ACC_NEXT]], [[GUARDED]] ]
; CHECK-V8A-NEXT:    ret i32 [[RESULT]]
;
loop.preheader:                                   ; preds = %entry
  br label %loop

loop:                                             ; preds = %guarded, %loop.preheader
  %loop.acc = phi i32 [ %loop.acc.next, %guarded ], [ 0, %loop.preheader ]
  %i = phi i32 [ %i.next, %guarded ], [ 0, %loop.preheader ]
  %within.bounds = icmp ult i32 %i, %length
  br i1 %within.bounds, label %guarded, label %deopt, !prof !0

deopt:                                            ; preds = %loop
  call void @prevent_merging()
  ret i32 -1

guarded:                                          ; preds = %loop
  %i.i64 = zext i32 %i to i64
  %array.i.ptr = getelementptr inbounds i32, ptr %array, i64 %i.i64
  %array.i = load i32, ptr %array.i.ptr, align 4
  %loop.acc.next = add i32 %loop.acc, %array.i
  %i.next = add nuw i32 %i, 1
  %continue = icmp ult i32 %i.next, %n
  br i1 %continue, label %loop, label %exit

exit:                                             ; preds = %guarded, %entry
  %result = phi i32 [ %loop.acc.next, %guarded ]
  ret i32 %result
}

declare void @maythrow()

define i32 @test2(ptr %array, i32 %length, i32 %n) #0 {
; CHECK-V8M-LABEL: @test2(
; CHECK-V8M-NEXT:  loop.preheader:
; CHECK-V8M-NEXT:    [[TMP0:%.*]] = add i32 [[N:%.*]], -1
; CHECK-V8M-NEXT:    [[TMP1:%.*]] = freeze i32 [[TMP0]]
; CHECK-V8M-NEXT:    [[UMIN:%.*]] = call i32 @llvm.umin.i32(i32 [[TMP1]], i32 [[LENGTH:%.*]])
; CHECK-V8M-NEXT:    [[TMP2:%.*]] = icmp ne i32 [[LENGTH]], [[UMIN]]
; CHECK-V8M-NEXT:    br label [[LOOP:%.*]]
; CHECK-V8M:       loop:
; CHECK-V8M-NEXT:    [[LOOP_ACC:%.*]] = phi i32 [ [[LOOP_ACC_NEXT:%.*]], [[GUARDED:%.*]] ], [ 0, [[LOOP_PREHEADER:%.*]] ]
; CHECK-V8M-NEXT:    [[I:%.*]] = phi i32 [ [[I_NEXT:%.*]], [[GUARDED]] ], [ 0, [[LOOP_PREHEADER]] ]
; CHECK-V8M-NEXT:    br i1 [[TMP2]], label [[GUARDED]], label [[DEOPT:%.*]], !prof [[PROF0]]
; CHECK-V8M:       deopt:
; CHECK-V8M-NEXT:    call void @prevent_merging()
; CHECK-V8M-NEXT:    ret i32 -1
; CHECK-V8M:       guarded:
; CHECK-V8M-NEXT:    [[I_I64:%.*]] = zext i32 [[I]] to i64
; CHECK-V8M-NEXT:    [[ARRAY_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY:%.*]], i64 [[I_I64]]
; CHECK-V8M-NEXT:    [[ARRAY_I:%.*]] = load i32, ptr [[ARRAY_I_PTR]], align 4
; CHECK-V8M-NEXT:    [[LOOP_ACC_NEXT]] = add i32 [[LOOP_ACC]], [[ARRAY_I]]
; CHECK-V8M-NEXT:    [[I_NEXT]] = add nuw i32 [[I]], 1
; CHECK-V8M-NEXT:    [[CONTINUE:%.*]] = icmp ne i32 [[I_NEXT]], [[N]]
; CHECK-V8M-NEXT:    br i1 [[CONTINUE]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK-V8M:       exit:
; CHECK-V8M-NEXT:    [[RESULT:%.*]] = phi i32 [ [[LOOP_ACC_NEXT]], [[GUARDED]] ]
; CHECK-V8M-NEXT:    ret i32 [[RESULT]]
;
; CHECK-V8A-LABEL: @test2(
; CHECK-V8A-NEXT:  loop.preheader:
; CHECK-V8A-NEXT:    [[TMP0:%.*]] = add i32 [[N:%.*]], -1
; CHECK-V8A-NEXT:    [[TMP1:%.*]] = freeze i32 [[TMP0]]
; CHECK-V8A-NEXT:    [[UMIN:%.*]] = call i32 @llvm.umin.i32(i32 [[TMP1]], i32 [[LENGTH:%.*]])
; CHECK-V8A-NEXT:    [[TMP2:%.*]] = icmp ne i32 [[LENGTH]], [[UMIN]]
; CHECK-V8A-NEXT:    br label [[LOOP:%.*]]
; CHECK-V8A:       loop:
; CHECK-V8A-NEXT:    [[LOOP_ACC:%.*]] = phi i32 [ [[LOOP_ACC_NEXT:%.*]], [[GUARDED:%.*]] ], [ 0, [[LOOP_PREHEADER:%.*]] ]
; CHECK-V8A-NEXT:    [[I:%.*]] = phi i32 [ [[I_NEXT:%.*]], [[GUARDED]] ], [ 0, [[LOOP_PREHEADER]] ]
; CHECK-V8A-NEXT:    br i1 [[TMP2]], label [[GUARDED]], label [[DEOPT:%.*]], !prof [[PROF0]]
; CHECK-V8A:       deopt:
; CHECK-V8A-NEXT:    call void @prevent_merging()
; CHECK-V8A-NEXT:    ret i32 -1
; CHECK-V8A:       guarded:
; CHECK-V8A-NEXT:    [[I_I64:%.*]] = zext i32 [[I]] to i64
; CHECK-V8A-NEXT:    [[ARRAY_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY:%.*]], i64 [[I_I64]]
; CHECK-V8A-NEXT:    [[ARRAY_I:%.*]] = load i32, ptr [[ARRAY_I_PTR]], align 4
; CHECK-V8A-NEXT:    [[LOOP_ACC_NEXT]] = add i32 [[LOOP_ACC]], [[ARRAY_I]]
; CHECK-V8A-NEXT:    [[I_NEXT]] = add nuw i32 [[I]], 1
; CHECK-V8A-NEXT:    [[CONTINUE:%.*]] = icmp ne i32 [[I_NEXT]], [[N]]
; CHECK-V8A-NEXT:    br i1 [[CONTINUE]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK-V8A:       exit:
; CHECK-V8A-NEXT:    [[RESULT:%.*]] = phi i32 [ [[LOOP_ACC_NEXT]], [[GUARDED]] ]
; CHECK-V8A-NEXT:    ret i32 [[RESULT]]
;
loop.preheader:                                   ; preds = %entry
  br label %loop

loop:                                             ; preds = %guarded, %loop.preheader
  %loop.acc = phi i32 [ %loop.acc.next, %guarded ], [ 0, %loop.preheader ]
  %i = phi i32 [ %i.next, %guarded ], [ 0, %loop.preheader ]
  %within.bounds = icmp ne i32 %i, %length
  br i1 %within.bounds, label %guarded, label %deopt, !prof !0

deopt:                                            ; preds = %loop
  call void @prevent_merging()
  ret i32 -1

guarded:                                          ; preds = %loop
  %i.i64 = zext i32 %i to i64
  %array.i.ptr = getelementptr inbounds i32, ptr %array, i64 %i.i64
  %array.i = load i32, ptr %array.i.ptr, align 4
  %loop.acc.next = add i32 %loop.acc, %array.i
  %i.next = add nuw i32 %i, 1
  %continue = icmp ne i32 %i.next, %n
  br i1 %continue, label %loop, label %exit

exit:                                             ; preds = %guarded, %entry
  %result = phi i32 [ %loop.acc.next, %guarded ]
  ret i32 %result
}

define i32 @two_range_checks(ptr %array.1, i32 %length.1, ptr %array.2, i32 %length.2, i32 %n) #0 {
; CHECK-V8M-LABEL: @two_range_checks(
; CHECK-V8M-NEXT:  loop.preheader:
; CHECK-V8M-NEXT:    [[UMIN:%.*]] = call i32 @llvm.umin.i32(i32 [[LENGTH_2:%.*]], i32 [[LENGTH_1:%.*]])
; CHECK-V8M-NEXT:    [[UMAX:%.*]] = call i32 @llvm.umax.i32(i32 [[N:%.*]], i32 1)
; CHECK-V8M-NEXT:    [[TMP0:%.*]] = add i32 [[UMAX]], -1
; CHECK-V8M-NEXT:    [[TMP1:%.*]] = freeze i32 [[TMP0]]
; CHECK-V8M-NEXT:    [[UMIN1:%.*]] = call i32 @llvm.umin.i32(i32 [[TMP1]], i32 [[UMIN]])
; CHECK-V8M-NEXT:    [[TMP2:%.*]] = icmp ne i32 [[UMIN]], [[UMIN1]]
; CHECK-V8M-NEXT:    br label [[LOOP:%.*]]
; CHECK-V8M:       loop:
; CHECK-V8M-NEXT:    [[LOOP_ACC:%.*]] = phi i32 [ [[LOOP_ACC_NEXT:%.*]], [[GUARDED:%.*]] ], [ 0, [[LOOP_PREHEADER:%.*]] ]
; CHECK-V8M-NEXT:    [[I:%.*]] = phi i32 [ [[I_NEXT:%.*]], [[GUARDED]] ], [ 0, [[LOOP_PREHEADER]] ]
; CHECK-V8M-NEXT:    br i1 [[TMP2]], label [[GUARDED]], label [[DEOPT:%.*]], !prof [[PROF0]]
; CHECK-V8M:       deopt:
; CHECK-V8M-NEXT:    call void @prevent_merging()
; CHECK-V8M-NEXT:    ret i32 -1
; CHECK-V8M:       guarded:
; CHECK-V8M-NEXT:    [[I_I64:%.*]] = zext i32 [[I]] to i64
; CHECK-V8M-NEXT:    [[ARRAY_1_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY_1:%.*]], i64 [[I_I64]]
; CHECK-V8M-NEXT:    [[ARRAY_1_I:%.*]] = load i32, ptr [[ARRAY_1_I_PTR]], align 4
; CHECK-V8M-NEXT:    [[LOOP_ACC_1:%.*]] = add i32 [[LOOP_ACC]], [[ARRAY_1_I]]
; CHECK-V8M-NEXT:    [[ARRAY_2_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY_2:%.*]], i64 [[I_I64]]
; CHECK-V8M-NEXT:    [[ARRAY_2_I:%.*]] = load i32, ptr [[ARRAY_2_I_PTR]], align 4
; CHECK-V8M-NEXT:    [[LOOP_ACC_NEXT]] = add i32 [[LOOP_ACC_1]], [[ARRAY_2_I]]
; CHECK-V8M-NEXT:    [[I_NEXT]] = add nuw i32 [[I]], 1
; CHECK-V8M-NEXT:    [[CONTINUE:%.*]] = icmp ult i32 [[I_NEXT]], [[N]]
; CHECK-V8M-NEXT:    br i1 [[CONTINUE]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK-V8M:       exit:
; CHECK-V8M-NEXT:    [[RESULT:%.*]] = phi i32 [ [[LOOP_ACC_NEXT]], [[GUARDED]] ]
; CHECK-V8M-NEXT:    ret i32 [[RESULT]]
;
; CHECK-V8A-LABEL: @two_range_checks(
; CHECK-V8A-NEXT:  loop.preheader:
; CHECK-V8A-NEXT:    [[UMIN:%.*]] = call i32 @llvm.umin.i32(i32 [[LENGTH_2:%.*]], i32 [[LENGTH_1:%.*]])
; CHECK-V8A-NEXT:    [[UMAX:%.*]] = call i32 @llvm.umax.i32(i32 [[N:%.*]], i32 1)
; CHECK-V8A-NEXT:    [[TMP0:%.*]] = add i32 [[UMAX]], -1
; CHECK-V8A-NEXT:    [[TMP1:%.*]] = freeze i32 [[TMP0]]
; CHECK-V8A-NEXT:    [[UMIN1:%.*]] = call i32 @llvm.umin.i32(i32 [[TMP1]], i32 [[UMIN]])
; CHECK-V8A-NEXT:    [[TMP2:%.*]] = icmp ne i32 [[UMIN]], [[UMIN1]]
; CHECK-V8A-NEXT:    br label [[LOOP:%.*]]
; CHECK-V8A:       loop:
; CHECK-V8A-NEXT:    [[LOOP_ACC:%.*]] = phi i32 [ [[LOOP_ACC_NEXT:%.*]], [[GUARDED:%.*]] ], [ 0, [[LOOP_PREHEADER:%.*]] ]
; CHECK-V8A-NEXT:    [[I:%.*]] = phi i32 [ [[I_NEXT:%.*]], [[GUARDED]] ], [ 0, [[LOOP_PREHEADER]] ]
; CHECK-V8A-NEXT:    br i1 [[TMP2]], label [[GUARDED]], label [[DEOPT:%.*]], !prof [[PROF0]]
; CHECK-V8A:       deopt:
; CHECK-V8A-NEXT:    call void @prevent_merging()
; CHECK-V8A-NEXT:    ret i32 -1
; CHECK-V8A:       guarded:
; CHECK-V8A-NEXT:    [[I_I64:%.*]] = zext i32 [[I]] to i64
; CHECK-V8A-NEXT:    [[ARRAY_1_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY_1:%.*]], i64 [[I_I64]]
; CHECK-V8A-NEXT:    [[ARRAY_1_I:%.*]] = load i32, ptr [[ARRAY_1_I_PTR]], align 4
; CHECK-V8A-NEXT:    [[LOOP_ACC_1:%.*]] = add i32 [[LOOP_ACC]], [[ARRAY_1_I]]
; CHECK-V8A-NEXT:    [[ARRAY_2_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY_2:%.*]], i64 [[I_I64]]
; CHECK-V8A-NEXT:    [[ARRAY_2_I:%.*]] = load i32, ptr [[ARRAY_2_I_PTR]], align 4
; CHECK-V8A-NEXT:    [[LOOP_ACC_NEXT]] = add i32 [[LOOP_ACC_1]], [[ARRAY_2_I]]
; CHECK-V8A-NEXT:    [[I_NEXT]] = add nuw i32 [[I]], 1
; CHECK-V8A-NEXT:    [[CONTINUE:%.*]] = icmp ult i32 [[I_NEXT]], [[N]]
; CHECK-V8A-NEXT:    br i1 [[CONTINUE]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK-V8A:       exit:
; CHECK-V8A-NEXT:    [[RESULT:%.*]] = phi i32 [ [[LOOP_ACC_NEXT]], [[GUARDED]] ]
; CHECK-V8A-NEXT:    ret i32 [[RESULT]]
;
loop.preheader:                                   ; preds = %entry
  br label %loop

loop:                                             ; preds = %guarded, %loop.preheader
  %loop.acc = phi i32 [ %loop.acc.next, %guarded ], [ 0, %loop.preheader ]
  %i = phi i32 [ %i.next, %guarded ], [ 0, %loop.preheader ]
  %within.bounds.1 = icmp ult i32 %i, %length.1
  %within.bounds.2 = icmp ult i32 %i, %length.2
  %within.bounds = and i1 %within.bounds.1, %within.bounds.2
  br i1 %within.bounds, label %guarded, label %deopt, !prof !0

deopt:                                            ; preds = %loop
  call void @prevent_merging()
  ret i32 -1

guarded:                                          ; preds = %loop
  %i.i64 = zext i32 %i to i64
  %array.1.i.ptr = getelementptr inbounds i32, ptr %array.1, i64 %i.i64
  %array.1.i = load i32, ptr %array.1.i.ptr, align 4
  %loop.acc.1 = add i32 %loop.acc, %array.1.i
  %array.2.i.ptr = getelementptr inbounds i32, ptr %array.2, i64 %i.i64
  %array.2.i = load i32, ptr %array.2.i.ptr, align 4
  %loop.acc.next = add i32 %loop.acc.1, %array.2.i
  %i.next = add nuw i32 %i, 1
  %continue = icmp ult i32 %i.next, %n
  br i1 %continue, label %loop, label %exit

exit:                                             ; preds = %guarded, %entry
  %result = phi i32 [ %loop.acc.next, %guarded ]
  ret i32 %result
}

define i32 @three_range_checks(ptr %array.1, i32 %length.1, ptr %array.2, i32 %length.2, ptr %array.3, i32 %length.3, i32 %n) #0 {
; CHECK-V8M-LABEL: @three_range_checks(
; CHECK-V8M-NEXT:  loop.preheader:
; CHECK-V8M-NEXT:    [[UMIN:%.*]] = call i32 @llvm.umin.i32(i32 [[LENGTH_3:%.*]], i32 [[LENGTH_2:%.*]])
; CHECK-V8M-NEXT:    [[UMIN1:%.*]] = call i32 @llvm.umin.i32(i32 [[UMIN]], i32 [[LENGTH_1:%.*]])
; CHECK-V8M-NEXT:    [[UMAX:%.*]] = call i32 @llvm.umax.i32(i32 [[N:%.*]], i32 1)
; CHECK-V8M-NEXT:    [[TMP0:%.*]] = add i32 [[UMAX]], -1
; CHECK-V8M-NEXT:    [[TMP1:%.*]] = freeze i32 [[TMP0]]
; CHECK-V8M-NEXT:    [[UMIN2:%.*]] = call i32 @llvm.umin.i32(i32 [[TMP1]], i32 [[UMIN1]])
; CHECK-V8M-NEXT:    [[TMP2:%.*]] = icmp ne i32 [[UMIN1]], [[UMIN2]]
; CHECK-V8M-NEXT:    br label [[LOOP:%.*]]
; CHECK-V8M:       loop:
; CHECK-V8M-NEXT:    [[LOOP_ACC:%.*]] = phi i32 [ [[LOOP_ACC_NEXT:%.*]], [[GUARDED:%.*]] ], [ 0, [[LOOP_PREHEADER:%.*]] ]
; CHECK-V8M-NEXT:    [[I:%.*]] = phi i32 [ [[I_NEXT:%.*]], [[GUARDED]] ], [ 0, [[LOOP_PREHEADER]] ]
; CHECK-V8M-NEXT:    br i1 [[TMP2]], label [[GUARDED]], label [[DEOPT:%.*]], !prof [[PROF0]]
; CHECK-V8M:       deopt:
; CHECK-V8M-NEXT:    call void @prevent_merging()
; CHECK-V8M-NEXT:    ret i32 -1
; CHECK-V8M:       guarded:
; CHECK-V8M-NEXT:    [[I_I64:%.*]] = zext i32 [[I]] to i64
; CHECK-V8M-NEXT:    [[ARRAY_1_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY_1:%.*]], i64 [[I_I64]]
; CHECK-V8M-NEXT:    [[ARRAY_1_I:%.*]] = load i32, ptr [[ARRAY_1_I_PTR]], align 4
; CHECK-V8M-NEXT:    [[LOOP_ACC_1:%.*]] = add i32 [[LOOP_ACC]], [[ARRAY_1_I]]
; CHECK-V8M-NEXT:    [[ARRAY_2_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY_2:%.*]], i64 [[I_I64]]
; CHECK-V8M-NEXT:    [[ARRAY_2_I:%.*]] = load i32, ptr [[ARRAY_2_I_PTR]], align 4
; CHECK-V8M-NEXT:    [[LOOP_ACC_2:%.*]] = add i32 [[LOOP_ACC_1]], [[ARRAY_2_I]]
; CHECK-V8M-NEXT:    [[ARRAY_3_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY_3:%.*]], i64 [[I_I64]]
; CHECK-V8M-NEXT:    [[ARRAY_3_I:%.*]] = load i32, ptr [[ARRAY_3_I_PTR]], align 4
; CHECK-V8M-NEXT:    [[LOOP_ACC_NEXT]] = add i32 [[LOOP_ACC_2]], [[ARRAY_3_I]]
; CHECK-V8M-NEXT:    [[I_NEXT]] = add nuw i32 [[I]], 1
; CHECK-V8M-NEXT:    [[CONTINUE:%.*]] = icmp ult i32 [[I_NEXT]], [[N]]
; CHECK-V8M-NEXT:    br i1 [[CONTINUE]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK-V8M:       exit:
; CHECK-V8M-NEXT:    [[RESULT:%.*]] = phi i32 [ [[LOOP_ACC_NEXT]], [[GUARDED]] ]
; CHECK-V8M-NEXT:    ret i32 [[RESULT]]
;
; CHECK-V8A-LABEL: @three_range_checks(
; CHECK-V8A-NEXT:  loop.preheader:
; CHECK-V8A-NEXT:    [[UMIN:%.*]] = call i32 @llvm.umin.i32(i32 [[LENGTH_3:%.*]], i32 [[LENGTH_2:%.*]])
; CHECK-V8A-NEXT:    [[UMIN1:%.*]] = call i32 @llvm.umin.i32(i32 [[UMIN]], i32 [[LENGTH_1:%.*]])
; CHECK-V8A-NEXT:    [[UMAX:%.*]] = call i32 @llvm.umax.i32(i32 [[N:%.*]], i32 1)
; CHECK-V8A-NEXT:    [[TMP0:%.*]] = add i32 [[UMAX]], -1
; CHECK-V8A-NEXT:    [[TMP1:%.*]] = freeze i32 [[TMP0]]
; CHECK-V8A-NEXT:    [[UMIN2:%.*]] = call i32 @llvm.umin.i32(i32 [[TMP1]], i32 [[UMIN1]])
; CHECK-V8A-NEXT:    [[TMP2:%.*]] = icmp ne i32 [[UMIN1]], [[UMIN2]]
; CHECK-V8A-NEXT:    br label [[LOOP:%.*]]
; CHECK-V8A:       loop:
; CHECK-V8A-NEXT:    [[LOOP_ACC:%.*]] = phi i32 [ [[LOOP_ACC_NEXT:%.*]], [[GUARDED:%.*]] ], [ 0, [[LOOP_PREHEADER:%.*]] ]
; CHECK-V8A-NEXT:    [[I:%.*]] = phi i32 [ [[I_NEXT:%.*]], [[GUARDED]] ], [ 0, [[LOOP_PREHEADER]] ]
; CHECK-V8A-NEXT:    br i1 [[TMP2]], label [[GUARDED]], label [[DEOPT:%.*]], !prof [[PROF0]]
; CHECK-V8A:       deopt:
; CHECK-V8A-NEXT:    call void @prevent_merging()
; CHECK-V8A-NEXT:    ret i32 -1
; CHECK-V8A:       guarded:
; CHECK-V8A-NEXT:    [[I_I64:%.*]] = zext i32 [[I]] to i64
; CHECK-V8A-NEXT:    [[ARRAY_1_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY_1:%.*]], i64 [[I_I64]]
; CHECK-V8A-NEXT:    [[ARRAY_1_I:%.*]] = load i32, ptr [[ARRAY_1_I_PTR]], align 4
; CHECK-V8A-NEXT:    [[LOOP_ACC_1:%.*]] = add i32 [[LOOP_ACC]], [[ARRAY_1_I]]
; CHECK-V8A-NEXT:    [[ARRAY_2_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY_2:%.*]], i64 [[I_I64]]
; CHECK-V8A-NEXT:    [[ARRAY_2_I:%.*]] = load i32, ptr [[ARRAY_2_I_PTR]], align 4
; CHECK-V8A-NEXT:    [[LOOP_ACC_2:%.*]] = add i32 [[LOOP_ACC_1]], [[ARRAY_2_I]]
; CHECK-V8A-NEXT:    [[ARRAY_3_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY_3:%.*]], i64 [[I_I64]]
; CHECK-V8A-NEXT:    [[ARRAY_3_I:%.*]] = load i32, ptr [[ARRAY_3_I_PTR]], align 4
; CHECK-V8A-NEXT:    [[LOOP_ACC_NEXT]] = add i32 [[LOOP_ACC_2]], [[ARRAY_3_I]]
; CHECK-V8A-NEXT:    [[I_NEXT]] = add nuw i32 [[I]], 1
; CHECK-V8A-NEXT:    [[CONTINUE:%.*]] = icmp ult i32 [[I_NEXT]], [[N]]
; CHECK-V8A-NEXT:    br i1 [[CONTINUE]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK-V8A:       exit:
; CHECK-V8A-NEXT:    [[RESULT:%.*]] = phi i32 [ [[LOOP_ACC_NEXT]], [[GUARDED]] ]
; CHECK-V8A-NEXT:    ret i32 [[RESULT]]
;
loop.preheader:                                   ; preds = %entry
  br label %loop

loop:                                             ; preds = %guarded, %loop.preheader
  %loop.acc = phi i32 [ %loop.acc.next, %guarded ], [ 0, %loop.preheader ]
  %i = phi i32 [ %i.next, %guarded ], [ 0, %loop.preheader ]
  %within.bounds.1 = icmp ult i32 %i, %length.1
  %within.bounds.2 = icmp ult i32 %i, %length.2
  %within.bounds.3 = icmp ult i32 %i, %length.3
  %within.bounds.1.and.2 = and i1 %within.bounds.1, %within.bounds.2
  %within.bounds = and i1 %within.bounds.1.and.2, %within.bounds.3
  br i1 %within.bounds, label %guarded, label %deopt, !prof !0

deopt:                                            ; preds = %loop
  call void @prevent_merging()
  ret i32 -1

guarded:                                          ; preds = %loop
  %i.i64 = zext i32 %i to i64
  %array.1.i.ptr = getelementptr inbounds i32, ptr %array.1, i64 %i.i64
  %array.1.i = load i32, ptr %array.1.i.ptr, align 4
  %loop.acc.1 = add i32 %loop.acc, %array.1.i
  %array.2.i.ptr = getelementptr inbounds i32, ptr %array.2, i64 %i.i64
  %array.2.i = load i32, ptr %array.2.i.ptr, align 4
  %loop.acc.2 = add i32 %loop.acc.1, %array.2.i
  %array.3.i.ptr = getelementptr inbounds i32, ptr %array.3, i64 %i.i64
  %array.3.i = load i32, ptr %array.3.i.ptr, align 4
  %loop.acc.next = add i32 %loop.acc.2, %array.3.i
  %i.next = add nuw i32 %i, 1
  %continue = icmp ult i32 %i.next, %n
  br i1 %continue, label %loop, label %exit

exit:                                             ; preds = %guarded, %entry
  %result = phi i32 [ %loop.acc.next, %guarded ]
  ret i32 %result
}

; Analogous to the above, but with two distinct branches (on different conditions)
define i32 @distinct_checks(ptr %array.1, i32 %length.1, ptr %array.2, i32 %length.2, ptr %array.3, i32 %length.3, i32 %n) #0 {
; CHECK-V8M-LABEL: @distinct_checks(
; CHECK-V8M-NEXT:  loop.preheader:
; CHECK-V8M-NEXT:    [[UMAX:%.*]] = call i32 @llvm.umax.i32(i32 [[N:%.*]], i32 1)
; CHECK-V8M-NEXT:    [[TMP0:%.*]] = add i32 [[UMAX]], -1
; CHECK-V8M-NEXT:    [[TMP1:%.*]] = freeze i32 [[TMP0]]
; CHECK-V8M-NEXT:    [[TMP2:%.*]] = freeze i32 [[LENGTH_2:%.*]]
; CHECK-V8M-NEXT:    [[UMIN:%.*]] = call i32 @llvm.umin.i32(i32 [[TMP1]], i32 [[TMP2]])
; CHECK-V8M-NEXT:    [[UMIN1:%.*]] = call i32 @llvm.umin.i32(i32 [[UMIN]], i32 [[LENGTH_1:%.*]])
; CHECK-V8M-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[LENGTH_1]], [[UMIN1]]
; CHECK-V8M-NEXT:    [[TMP4:%.*]] = icmp ne i32 [[LENGTH_2]], [[UMIN1]]
; CHECK-V8M-NEXT:    br label [[LOOP:%.*]]
; CHECK-V8M:       loop:
; CHECK-V8M-NEXT:    [[LOOP_ACC:%.*]] = phi i32 [ [[LOOP_ACC_NEXT:%.*]], [[GUARDED1:%.*]] ], [ 0, [[LOOP_PREHEADER:%.*]] ]
; CHECK-V8M-NEXT:    [[I:%.*]] = phi i32 [ [[I_NEXT:%.*]], [[GUARDED1]] ], [ 0, [[LOOP_PREHEADER]] ]
; CHECK-V8M-NEXT:    br i1 [[TMP3]], label [[GUARDED:%.*]], label [[DEOPT:%.*]], !prof [[PROF0]]
; CHECK-V8M:       deopt:
; CHECK-V8M-NEXT:    call void @prevent_merging()
; CHECK-V8M-NEXT:    ret i32 -1
; CHECK-V8M:       guarded:
; CHECK-V8M-NEXT:    [[I_I64:%.*]] = zext i32 [[I]] to i64
; CHECK-V8M-NEXT:    [[ARRAY_1_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY_1:%.*]], i64 [[I_I64]]
; CHECK-V8M-NEXT:    [[ARRAY_1_I:%.*]] = load i32, ptr [[ARRAY_1_I_PTR]], align 4
; CHECK-V8M-NEXT:    [[LOOP_ACC_1:%.*]] = add i32 [[LOOP_ACC]], [[ARRAY_1_I]]
; CHECK-V8M-NEXT:    br i1 [[TMP4]], label [[GUARDED1]], label [[DEOPT2:%.*]], !prof [[PROF0]]
; CHECK-V8M:       deopt2:
; CHECK-V8M-NEXT:    call void @prevent_merging()
; CHECK-V8M-NEXT:    ret i32 -1
; CHECK-V8M:       guarded1:
; CHECK-V8M-NEXT:    [[ARRAY_3_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY_3:%.*]], i64 [[I_I64]]
; CHECK-V8M-NEXT:    [[ARRAY_3_I:%.*]] = load i32, ptr [[ARRAY_3_I_PTR]], align 4
; CHECK-V8M-NEXT:    [[LOOP_ACC_NEXT]] = add i32 [[LOOP_ACC_1]], [[ARRAY_3_I]]
; CHECK-V8M-NEXT:    [[I_NEXT]] = add nuw i32 [[I]], 1
; CHECK-V8M-NEXT:    [[CONTINUE:%.*]] = icmp ult i32 [[I_NEXT]], [[N]]
; CHECK-V8M-NEXT:    br i1 [[CONTINUE]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK-V8M:       exit:
; CHECK-V8M-NEXT:    [[RESULT:%.*]] = phi i32 [ [[LOOP_ACC_NEXT]], [[GUARDED1]] ]
; CHECK-V8M-NEXT:    ret i32 [[RESULT]]
;
; CHECK-V8A-LABEL: @distinct_checks(
; CHECK-V8A-NEXT:  loop.preheader:
; CHECK-V8A-NEXT:    [[UMAX:%.*]] = call i32 @llvm.umax.i32(i32 [[N:%.*]], i32 1)
; CHECK-V8A-NEXT:    [[TMP0:%.*]] = add i32 [[UMAX]], -1
; CHECK-V8A-NEXT:    [[TMP1:%.*]] = freeze i32 [[TMP0]]
; CHECK-V8A-NEXT:    [[TMP2:%.*]] = freeze i32 [[LENGTH_2:%.*]]
; CHECK-V8A-NEXT:    [[UMIN:%.*]] = call i32 @llvm.umin.i32(i32 [[TMP1]], i32 [[TMP2]])
; CHECK-V8A-NEXT:    [[UMIN1:%.*]] = call i32 @llvm.umin.i32(i32 [[UMIN]], i32 [[LENGTH_1:%.*]])
; CHECK-V8A-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[LENGTH_1]], [[UMIN1]]
; CHECK-V8A-NEXT:    [[TMP4:%.*]] = icmp ne i32 [[LENGTH_2]], [[UMIN1]]
; CHECK-V8A-NEXT:    br label [[LOOP:%.*]]
; CHECK-V8A:       loop:
; CHECK-V8A-NEXT:    [[LOOP_ACC:%.*]] = phi i32 [ [[LOOP_ACC_NEXT:%.*]], [[GUARDED1:%.*]] ], [ 0, [[LOOP_PREHEADER:%.*]] ]
; CHECK-V8A-NEXT:    [[I:%.*]] = phi i32 [ [[I_NEXT:%.*]], [[GUARDED1]] ], [ 0, [[LOOP_PREHEADER]] ]
; CHECK-V8A-NEXT:    br i1 [[TMP3]], label [[GUARDED:%.*]], label [[DEOPT:%.*]], !prof [[PROF0]]
; CHECK-V8A:       deopt:
; CHECK-V8A-NEXT:    call void @prevent_merging()
; CHECK-V8A-NEXT:    ret i32 -1
; CHECK-V8A:       guarded:
; CHECK-V8A-NEXT:    [[I_I64:%.*]] = zext i32 [[I]] to i64
; CHECK-V8A-NEXT:    [[ARRAY_1_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY_1:%.*]], i64 [[I_I64]]
; CHECK-V8A-NEXT:    [[ARRAY_1_I:%.*]] = load i32, ptr [[ARRAY_1_I_PTR]], align 4
; CHECK-V8A-NEXT:    [[LOOP_ACC_1:%.*]] = add i32 [[LOOP_ACC]], [[ARRAY_1_I]]
; CHECK-V8A-NEXT:    br i1 [[TMP4]], label [[GUARDED1]], label [[DEOPT2:%.*]], !prof [[PROF0]]
; CHECK-V8A:       deopt2:
; CHECK-V8A-NEXT:    call void @prevent_merging()
; CHECK-V8A-NEXT:    ret i32 -1
; CHECK-V8A:       guarded1:
; CHECK-V8A-NEXT:    [[ARRAY_3_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY_3:%.*]], i64 [[I_I64]]
; CHECK-V8A-NEXT:    [[ARRAY_3_I:%.*]] = load i32, ptr [[ARRAY_3_I_PTR]], align 4
; CHECK-V8A-NEXT:    [[LOOP_ACC_NEXT]] = add i32 [[LOOP_ACC_1]], [[ARRAY_3_I]]
; CHECK-V8A-NEXT:    [[I_NEXT]] = add nuw i32 [[I]], 1
; CHECK-V8A-NEXT:    [[CONTINUE:%.*]] = icmp ult i32 [[I_NEXT]], [[N]]
; CHECK-V8A-NEXT:    br i1 [[CONTINUE]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK-V8A:       exit:
; CHECK-V8A-NEXT:    [[RESULT:%.*]] = phi i32 [ [[LOOP_ACC_NEXT]], [[GUARDED1]] ]
; CHECK-V8A-NEXT:    ret i32 [[RESULT]]
;
loop.preheader:                                   ; preds = %entry
  br label %loop

loop:                                             ; preds = %guarded4, %loop.preheader
  %loop.acc = phi i32 [ %loop.acc.next, %guarded1 ], [ 0, %loop.preheader ]
  %i = phi i32 [ %i.next, %guarded1 ], [ 0, %loop.preheader ]
  %within.bounds.1 = icmp ult i32 %i, %length.1
  br i1 %within.bounds.1, label %guarded, label %deopt, !prof !0

deopt:                                            ; preds = %loop
  call void @prevent_merging()
  ret i32 -1

guarded:                                          ; preds = %loop
  %i.i64 = zext i32 %i to i64
  %array.1.i.ptr = getelementptr inbounds i32, ptr %array.1, i64 %i.i64
  %array.1.i = load i32, ptr %array.1.i.ptr, align 4
  %loop.acc.1 = add i32 %loop.acc, %array.1.i
  %within.bounds.2 = icmp ult i32 %i, %length.2
  br i1 %within.bounds.2, label %guarded1, label %deopt2, !prof !0

deopt2:                                           ; preds = %guarded
  call void @prevent_merging()
  ret i32 -1

guarded1:                                         ; preds = %guarded1
  %array.3.i.ptr = getelementptr inbounds i32, ptr %array.3, i64 %i.i64
  %array.3.i = load i32, ptr %array.3.i.ptr, align 4
  %loop.acc.next = add i32 %loop.acc.1, %array.3.i
  %i.next = add nuw i32 %i, 1
  %continue = icmp ult i32 %i.next, %n
  br i1 %continue, label %loop, label %exit

exit:
  %result = phi i32 [ %loop.acc.next, %guarded1 ]
  ret i32 %result
}

define i32 @duplicate_checks(ptr %array.1, ptr %array.2, ptr %array.3, i32 %length, i32 %n) #0 {
; CHECK-V8M-LABEL: @duplicate_checks(
; CHECK-V8M-NEXT:  loop.preheader:
; CHECK-V8M-NEXT:    [[UMAX:%.*]] = call i32 @llvm.umax.i32(i32 [[N:%.*]], i32 1)
; CHECK-V8M-NEXT:    [[TMP0:%.*]] = add i32 [[UMAX]], -1
; CHECK-V8M-NEXT:    [[TMP1:%.*]] = freeze i32 [[TMP0]]
; CHECK-V8M-NEXT:    [[UMIN:%.*]] = call i32 @llvm.umin.i32(i32 [[TMP1]], i32 [[LENGTH:%.*]])
; CHECK-V8M-NEXT:    [[TMP2:%.*]] = icmp ne i32 [[LENGTH]], [[UMIN]]
; CHECK-V8M-NEXT:    br label [[LOOP:%.*]]
; CHECK-V8M:       loop:
; CHECK-V8M-NEXT:    [[LOOP_ACC:%.*]] = phi i32 [ [[LOOP_ACC_NEXT:%.*]], [[GUARDED1:%.*]] ], [ 0, [[LOOP_PREHEADER:%.*]] ]
; CHECK-V8M-NEXT:    [[I:%.*]] = phi i32 [ [[I_NEXT:%.*]], [[GUARDED1]] ], [ 0, [[LOOP_PREHEADER]] ]
; CHECK-V8M-NEXT:    br i1 [[TMP2]], label [[GUARDED:%.*]], label [[DEOPT:%.*]], !prof [[PROF0]]
; CHECK-V8M:       deopt:
; CHECK-V8M-NEXT:    call void @prevent_merging()
; CHECK-V8M-NEXT:    ret i32 -1
; CHECK-V8M:       guarded:
; CHECK-V8M-NEXT:    [[I_I64:%.*]] = zext i32 [[I]] to i64
; CHECK-V8M-NEXT:    [[ARRAY_1_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY_1:%.*]], i64 [[I_I64]]
; CHECK-V8M-NEXT:    [[ARRAY_1_I:%.*]] = load i32, ptr [[ARRAY_1_I_PTR]], align 4
; CHECK-V8M-NEXT:    [[LOOP_ACC_1:%.*]] = add i32 [[LOOP_ACC]], [[ARRAY_1_I]]
; CHECK-V8M-NEXT:    br i1 true, label [[GUARDED1]], label [[DEOPT2:%.*]], !prof [[PROF0]]
; CHECK-V8M:       deopt2:
; CHECK-V8M-NEXT:    call void @prevent_merging()
; CHECK-V8M-NEXT:    ret i32 -1
; CHECK-V8M:       guarded1:
; CHECK-V8M-NEXT:    [[ARRAY_3_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY_3:%.*]], i64 [[I_I64]]
; CHECK-V8M-NEXT:    [[ARRAY_3_I:%.*]] = load i32, ptr [[ARRAY_3_I_PTR]], align 4
; CHECK-V8M-NEXT:    [[LOOP_ACC_NEXT]] = add i32 [[LOOP_ACC_1]], [[ARRAY_3_I]]
; CHECK-V8M-NEXT:    [[I_NEXT]] = add nuw i32 [[I]], 1
; CHECK-V8M-NEXT:    [[CONTINUE:%.*]] = icmp ult i32 [[I_NEXT]], [[N]]
; CHECK-V8M-NEXT:    br i1 [[CONTINUE]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK-V8M:       exit:
; CHECK-V8M-NEXT:    [[RESULT:%.*]] = phi i32 [ [[LOOP_ACC_NEXT]], [[GUARDED1]] ]
; CHECK-V8M-NEXT:    ret i32 [[RESULT]]
;
; CHECK-V8A-LABEL: @duplicate_checks(
; CHECK-V8A-NEXT:  loop.preheader:
; CHECK-V8A-NEXT:    [[UMAX:%.*]] = call i32 @llvm.umax.i32(i32 [[N:%.*]], i32 1)
; CHECK-V8A-NEXT:    [[TMP0:%.*]] = add i32 [[UMAX]], -1
; CHECK-V8A-NEXT:    [[TMP1:%.*]] = freeze i32 [[TMP0]]
; CHECK-V8A-NEXT:    [[UMIN:%.*]] = call i32 @llvm.umin.i32(i32 [[TMP1]], i32 [[LENGTH:%.*]])
; CHECK-V8A-NEXT:    [[TMP2:%.*]] = icmp ne i32 [[LENGTH]], [[UMIN]]
; CHECK-V8A-NEXT:    br label [[LOOP:%.*]]
; CHECK-V8A:       loop:
; CHECK-V8A-NEXT:    [[LOOP_ACC:%.*]] = phi i32 [ [[LOOP_ACC_NEXT:%.*]], [[GUARDED1:%.*]] ], [ 0, [[LOOP_PREHEADER:%.*]] ]
; CHECK-V8A-NEXT:    [[I:%.*]] = phi i32 [ [[I_NEXT:%.*]], [[GUARDED1]] ], [ 0, [[LOOP_PREHEADER]] ]
; CHECK-V8A-NEXT:    br i1 [[TMP2]], label [[GUARDED:%.*]], label [[DEOPT:%.*]], !prof [[PROF0]]
; CHECK-V8A:       deopt:
; CHECK-V8A-NEXT:    call void @prevent_merging()
; CHECK-V8A-NEXT:    ret i32 -1
; CHECK-V8A:       guarded:
; CHECK-V8A-NEXT:    [[I_I64:%.*]] = zext i32 [[I]] to i64
; CHECK-V8A-NEXT:    [[ARRAY_1_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY_1:%.*]], i64 [[I_I64]]
; CHECK-V8A-NEXT:    [[ARRAY_1_I:%.*]] = load i32, ptr [[ARRAY_1_I_PTR]], align 4
; CHECK-V8A-NEXT:    [[LOOP_ACC_1:%.*]] = add i32 [[LOOP_ACC]], [[ARRAY_1_I]]
; CHECK-V8A-NEXT:    br i1 true, label [[GUARDED1]], label [[DEOPT2:%.*]], !prof [[PROF0]]
; CHECK-V8A:       deopt2:
; CHECK-V8A-NEXT:    call void @prevent_merging()
; CHECK-V8A-NEXT:    ret i32 -1
; CHECK-V8A:       guarded1:
; CHECK-V8A-NEXT:    [[ARRAY_3_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY_3:%.*]], i64 [[I_I64]]
; CHECK-V8A-NEXT:    [[ARRAY_3_I:%.*]] = load i32, ptr [[ARRAY_3_I_PTR]], align 4
; CHECK-V8A-NEXT:    [[LOOP_ACC_NEXT]] = add i32 [[LOOP_ACC_1]], [[ARRAY_3_I]]
; CHECK-V8A-NEXT:    [[I_NEXT]] = add nuw i32 [[I]], 1
; CHECK-V8A-NEXT:    [[CONTINUE:%.*]] = icmp ult i32 [[I_NEXT]], [[N]]
; CHECK-V8A-NEXT:    br i1 [[CONTINUE]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK-V8A:       exit:
; CHECK-V8A-NEXT:    [[RESULT:%.*]] = phi i32 [ [[LOOP_ACC_NEXT]], [[GUARDED1]] ]
; CHECK-V8A-NEXT:    ret i32 [[RESULT]]
;
loop.preheader:                                   ; preds = %entry
  br label %loop

loop:                                             ; preds = %guarded4, %loop.preheader
  %loop.acc = phi i32 [ %loop.acc.next, %guarded1 ], [ 0, %loop.preheader ]
  %i = phi i32 [ %i.next, %guarded1 ], [ 0, %loop.preheader ]
  %within.bounds.1 = icmp ult i32 %i, %length
  br i1 %within.bounds.1, label %guarded, label %deopt, !prof !0

deopt:                                            ; preds = %loop
  call void @prevent_merging()
  ret i32 -1

guarded:                                          ; preds = %loop
  %i.i64 = zext i32 %i to i64
  %array.1.i.ptr = getelementptr inbounds i32, ptr %array.1, i64 %i.i64
  %array.1.i = load i32, ptr %array.1.i.ptr, align 4
  %loop.acc.1 = add i32 %loop.acc, %array.1.i
  %within.bounds.2 = icmp ult i32 %i, %length
  br i1 %within.bounds.2, label %guarded1, label %deopt2, !prof !0

deopt2:                                           ; preds = %guarded
  call void @prevent_merging()
  ret i32 -1

guarded1:                                         ; preds = %guarded1
  %array.3.i.ptr = getelementptr inbounds i32, ptr %array.3, i64 %i.i64
  %array.3.i = load i32, ptr %array.3.i.ptr, align 4
  %loop.acc.next = add i32 %loop.acc.1, %array.3.i
  %i.next = add nuw i32 %i, 1
  %continue = icmp ult i32 %i.next, %n
  br i1 %continue, label %loop, label %exit

exit:
  %result = phi i32 [ %loop.acc.next, %guarded1 ]
  ret i32 %result
}

; Demonstrate that this approach works with IVs of different steps, and types
; This version uses a manually lftred exit condition to work around an issue described
; in detail on next test.
define i32 @different_ivs(ptr %array, i32 %length, i32 %n) #0 {
; CHECK-V8M-LABEL: @different_ivs(
; CHECK-V8M-NEXT:  loop.preheader:
; CHECK-V8M-NEXT:    [[N64:%.*]] = zext i32 [[N:%.*]] to i64
; CHECK-V8M-NEXT:    [[UMAX:%.*]] = call i64 @llvm.umax.i64(i64 [[N64]], i64 1)
; CHECK-V8M-NEXT:    [[TMP0:%.*]] = add nsw i64 [[UMAX]], -1
; CHECK-V8M-NEXT:    [[TMP1:%.*]] = freeze i64 [[TMP0]]
; CHECK-V8M-NEXT:    [[TMP2:%.*]] = zext i32 [[LENGTH:%.*]] to i64
; CHECK-V8M-NEXT:    [[UMIN:%.*]] = call i64 @llvm.umin.i64(i64 [[TMP1]], i64 [[TMP2]])
; CHECK-V8M-NEXT:    [[TMP3:%.*]] = zext i32 [[LENGTH]] to i64
; CHECK-V8M-NEXT:    [[TMP4:%.*]] = icmp ne i64 [[TMP3]], [[UMIN]]
; CHECK-V8M-NEXT:    br label [[LOOP:%.*]]
; CHECK-V8M:       loop:
; CHECK-V8M-NEXT:    [[LOOP_ACC:%.*]] = phi i32 [ [[LOOP_ACC_NEXT:%.*]], [[GUARDED:%.*]] ], [ 0, [[LOOP_PREHEADER:%.*]] ]
; CHECK-V8M-NEXT:    [[I:%.*]] = phi i64 [ [[I_NEXT:%.*]], [[GUARDED]] ], [ 0, [[LOOP_PREHEADER]] ]
; CHECK-V8M-NEXT:    br i1 [[TMP4]], label [[GUARDED]], label [[DEOPT:%.*]], !prof [[PROF0]]
; CHECK-V8M:       deopt:
; CHECK-V8M-NEXT:    call void @prevent_merging()
; CHECK-V8M-NEXT:    ret i32 -1
; CHECK-V8M:       guarded:
; CHECK-V8M-NEXT:    [[ARRAY_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY:%.*]], i64 [[I]]
; CHECK-V8M-NEXT:    [[ARRAY_I:%.*]] = load i32, ptr [[ARRAY_I_PTR]], align 4
; CHECK-V8M-NEXT:    [[LOOP_ACC_NEXT]] = add i32 [[LOOP_ACC]], [[ARRAY_I]]
; CHECK-V8M-NEXT:    [[I_NEXT]] = add nuw nsw i64 [[I]], 1
; CHECK-V8M-NEXT:    [[CONTINUE:%.*]] = icmp ult i64 [[I_NEXT]], [[N64]]
; CHECK-V8M-NEXT:    br i1 [[CONTINUE]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK-V8M:       exit:
; CHECK-V8M-NEXT:    [[RESULT:%.*]] = phi i32 [ [[LOOP_ACC_NEXT]], [[GUARDED]] ]
; CHECK-V8M-NEXT:    ret i32 [[RESULT]]
;
; CHECK-V8A-LABEL: @different_ivs(
; CHECK-V8A-NEXT:  loop.preheader:
; CHECK-V8A-NEXT:    [[N64:%.*]] = zext i32 [[N:%.*]] to i64
; CHECK-V8A-NEXT:    [[UMAX:%.*]] = call i64 @llvm.umax.i64(i64 [[N64]], i64 1)
; CHECK-V8A-NEXT:    [[TMP0:%.*]] = add nsw i64 [[UMAX]], -1
; CHECK-V8A-NEXT:    [[TMP1:%.*]] = freeze i64 [[TMP0]]
; CHECK-V8A-NEXT:    [[TMP2:%.*]] = zext i32 [[LENGTH:%.*]] to i64
; CHECK-V8A-NEXT:    [[UMIN:%.*]] = call i64 @llvm.umin.i64(i64 [[TMP1]], i64 [[TMP2]])
; CHECK-V8A-NEXT:    [[TMP3:%.*]] = zext i32 [[LENGTH]] to i64
; CHECK-V8A-NEXT:    [[TMP4:%.*]] = icmp ne i64 [[TMP3]], [[UMIN]]
; CHECK-V8A-NEXT:    br label [[LOOP:%.*]]
; CHECK-V8A:       loop:
; CHECK-V8A-NEXT:    [[LOOP_ACC:%.*]] = phi i32 [ [[LOOP_ACC_NEXT:%.*]], [[GUARDED:%.*]] ], [ 0, [[LOOP_PREHEADER:%.*]] ]
; CHECK-V8A-NEXT:    [[I:%.*]] = phi i64 [ [[I_NEXT:%.*]], [[GUARDED]] ], [ 0, [[LOOP_PREHEADER]] ]
; CHECK-V8A-NEXT:    br i1 [[TMP4]], label [[GUARDED]], label [[DEOPT:%.*]], !prof [[PROF0]]
; CHECK-V8A:       deopt:
; CHECK-V8A-NEXT:    call void @prevent_merging()
; CHECK-V8A-NEXT:    ret i32 -1
; CHECK-V8A:       guarded:
; CHECK-V8A-NEXT:    [[ARRAY_I_PTR:%.*]] = getelementptr inbounds i32, ptr [[ARRAY:%.*]], i64 [[I]]
; CHECK-V8A-NEXT:    [[ARRAY_I:%.*]] = load i32, ptr [[ARRAY_I_PTR]], align 4
; CHECK-V8A-NEXT:    [[LOOP_ACC_NEXT]] = add i32 [[LOOP_ACC]], [[ARRAY_I]]
; CHECK-V8A-NEXT:    [[I_NEXT]] = add nuw nsw i64 [[I]], 1
; CHECK-V8A-NEXT:    [[CONTINUE:%.*]] = icmp ult i64 [[I_NEXT]], [[N64]]
; CHECK-V8A-NEXT:    br i1 [[CONTINUE]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK-V8A:       exit:
; CHECK-V8A-NEXT:    [[RESULT:%.*]] = phi i32 [ [[LOOP_ACC_NEXT]], [[GUARDED]] ]
; CHECK-V8A-NEXT:    ret i32 [[RESULT]]
;
loop.preheader:
  %j.start = sub nuw nsw i32 %length, 1
  %n64 = zext i32 %n to i64
  br label %loop

loop:
  %loop.acc = phi i32 [ %loop.acc.next, %guarded ], [ 0, %loop.preheader ]
  %i = phi i64 [ %i.next, %guarded ], [ 0, %loop.preheader ]
  %j = phi i32 [ %j.next, %guarded ], [ %j.start, %loop.preheader ]
  %within.bounds = icmp ne i32 %j, -1
  br i1 %within.bounds, label %guarded, label %deopt, !prof !0

deopt:
  call void @prevent_merging()
  ret i32 -1

guarded:
  %array.i.ptr = getelementptr inbounds i32, ptr %array, i64 %i
  %array.i = load i32, ptr %array.i.ptr, align 4
  %loop.acc.next = add i32 %loop.acc, %array.i
  %i.next = add nuw i64 %i, 1
  %j.next = sub nuw i32 %j, 1
  %continue = icmp ult i64 %i.next, %n64
  br i1 %continue, label %loop, label %exit

exit:
  %result = phi i32 [ %loop.acc.next, %guarded ]
  ret i32 %result
}

declare void @prevent_merging()
declare void @call()

!0 = !{!"branch_weights", i32 1048576, i32 1}
!1 = !{i32 1, i32 -2147483648}
!2 = !{i32 0, i32 50}

attributes #0 = { minsize optsize }
