; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

; Test from PR63896
define i1 @umax_ugt(i32 %x, i32 %y) {
; CHECK-LABEL: define i1 @umax_ugt
; CHECK-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[MAX:%.*]] = call i32 @llvm.umax.i32(i32 [[X]], i32 1)
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[Y]], [[MAX]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[END:%.*]]
; CHECK:       if:
; CHECK-NEXT:    [[RET:%.*]] = xor i1 true, true
; CHECK-NEXT:    ret i1 [[RET]]
; CHECK:       end:
; CHECK-NEXT:    ret i1 false
;
  %max = call i32 @llvm.umax.i32(i32 %x, i32 1)
  %cmp = icmp ugt i32 %y, %max
  br i1 %cmp, label %if, label %end

if:
  %cmp2 = icmp ugt i32 %y, %x
  %cmp3 = icmp uge i32 %y, %x
  %ret = xor i1 %cmp2, %cmp3
  ret i1 %ret

end:
  ret i1 false
}

define i1 @umax_uge(i32 %x, i32 %y) {
; CHECK-LABEL: define i1 @umax_uge
; CHECK-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[MAX:%.*]] = call i32 @llvm.umax.i32(i32 [[X]], i32 1)
; CHECK-NEXT:    [[CMP:%.*]] = icmp uge i32 [[Y]], [[MAX]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[END:%.*]]
; CHECK:       if:
; CHECK-NEXT:    [[CMP2:%.*]] = icmp ugt i32 [[Y]], [[X]]
; CHECK-NEXT:    [[RET:%.*]] = xor i1 [[CMP2]], true
; CHECK-NEXT:    ret i1 [[RET]]
; CHECK:       end:
; CHECK-NEXT:    ret i1 false
;
  %max = call i32 @llvm.umax.i32(i32 %x, i32 1)
  %cmp = icmp uge i32 %y, %max
  br i1 %cmp, label %if, label %end

if:
  %cmp2 = icmp ugt i32 %y, %x
  %cmp3 = icmp uge i32 %y, %x
  %ret = xor i1 %cmp2, %cmp3
  ret i1 %ret

end:
  ret i1 false
}

define i1 @umin_ult(i32 %x, i32 %y) {
; CHECK-LABEL: define i1 @umin_ult
; CHECK-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[MIN:%.*]] = call i32 @llvm.umin.i32(i32 [[X]], i32 1)
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[Y]], [[MIN]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[END:%.*]]
; CHECK:       if:
; CHECK-NEXT:    [[RET:%.*]] = xor i1 true, true
; CHECK-NEXT:    ret i1 [[RET]]
; CHECK:       end:
; CHECK-NEXT:    ret i1 false
;
  %min = call i32 @llvm.umin.i32(i32 %x, i32 1)
  %cmp = icmp ult i32 %y, %min
  br i1 %cmp, label %if, label %end

if:
  %cmp2 = icmp ult i32 %y, %x
  %cmp3 = icmp ule i32 %y, %x
  %ret = xor i1 %cmp2, %cmp3
  ret i1 %ret

end:
  ret i1 false
}

define i1 @umin_ule(i32 %x, i32 %y) {
; CHECK-LABEL: define i1 @umin_ule
; CHECK-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[MIN:%.*]] = call i32 @llvm.umin.i32(i32 [[X]], i32 1)
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule i32 [[Y]], [[MIN]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[END:%.*]]
; CHECK:       if:
; CHECK-NEXT:    [[CMP2:%.*]] = icmp ult i32 [[Y]], [[X]]
; CHECK-NEXT:    [[RET:%.*]] = xor i1 [[CMP2]], true
; CHECK-NEXT:    ret i1 [[RET]]
; CHECK:       end:
; CHECK-NEXT:    ret i1 false
;
  %min = call i32 @llvm.umin.i32(i32 %x, i32 1)
  %cmp = icmp ule i32 %y, %min
  br i1 %cmp, label %if, label %end

if:
  %cmp2 = icmp ult i32 %y, %x
  %cmp3 = icmp ule i32 %y, %x
  %ret = xor i1 %cmp2, %cmp3
  ret i1 %ret

end:
  ret i1 false
}

define i1 @smax_sgt(i32 %x, i32 %y) {
; CHECK-LABEL: define i1 @smax_sgt
; CHECK-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[MAX:%.*]] = call i32 @llvm.smax.i32(i32 [[X]], i32 1)
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[Y]], [[MAX]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[END:%.*]]
; CHECK:       if:
; CHECK-NEXT:    [[RET:%.*]] = xor i1 true, true
; CHECK-NEXT:    ret i1 [[RET]]
; CHECK:       end:
; CHECK-NEXT:    ret i1 false
;
  %max = call i32 @llvm.smax.i32(i32 %x, i32 1)
  %cmp = icmp sgt i32 %y, %max
  br i1 %cmp, label %if, label %end

if:
  %cmp2 = icmp sgt i32 %y, %x
  %cmp3 = icmp sge i32 %y, %x
  %ret = xor i1 %cmp2, %cmp3
  ret i1 %ret

end:
  ret i1 false
}

define i1 @smax_sge(i32 %x, i32 %y) {
; CHECK-LABEL: define i1 @smax_sge
; CHECK-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[MAX:%.*]] = call i32 @llvm.smax.i32(i32 [[X]], i32 1)
; CHECK-NEXT:    [[CMP:%.*]] = icmp sge i32 [[Y]], [[MAX]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[END:%.*]]
; CHECK:       if:
; CHECK-NEXT:    [[CMP2:%.*]] = icmp sgt i32 [[Y]], [[X]]
; CHECK-NEXT:    [[RET:%.*]] = xor i1 [[CMP2]], true
; CHECK-NEXT:    ret i1 [[RET]]
; CHECK:       end:
; CHECK-NEXT:    ret i1 false
;
  %max = call i32 @llvm.smax.i32(i32 %x, i32 1)
  %cmp = icmp sge i32 %y, %max
  br i1 %cmp, label %if, label %end

if:
  %cmp2 = icmp sgt i32 %y, %x
  %cmp3 = icmp sge i32 %y, %x
  %ret = xor i1 %cmp2, %cmp3
  ret i1 %ret

end:
  ret i1 false
}

define i1 @smin_slt(i32 %x, i32 %y) {
; CHECK-LABEL: define i1 @smin_slt
; CHECK-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[MIN:%.*]] = call i32 @llvm.smin.i32(i32 [[X]], i32 1)
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[Y]], [[MIN]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[END:%.*]]
; CHECK:       if:
; CHECK-NEXT:    [[RET:%.*]] = xor i1 true, true
; CHECK-NEXT:    ret i1 [[RET]]
; CHECK:       end:
; CHECK-NEXT:    ret i1 false
;
  %min = call i32 @llvm.smin.i32(i32 %x, i32 1)
  %cmp = icmp slt i32 %y, %min
  br i1 %cmp, label %if, label %end

if:
  %cmp2 = icmp slt i32 %y, %x
  %cmp3 = icmp sle i32 %y, %x
  %ret = xor i1 %cmp2, %cmp3
  ret i1 %ret

end:
  ret i1 false
}

define i1 @smin_sle(i32 %x, i32 %y) {
; CHECK-LABEL: define i1 @smin_sle
; CHECK-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[MIN:%.*]] = call i32 @llvm.smin.i32(i32 [[X]], i32 1)
; CHECK-NEXT:    [[CMP:%.*]] = icmp sle i32 [[Y]], [[MIN]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[END:%.*]]
; CHECK:       if:
; CHECK-NEXT:    [[CMP2:%.*]] = icmp slt i32 [[Y]], [[X]]
; CHECK-NEXT:    [[RET:%.*]] = xor i1 [[CMP2]], true
; CHECK-NEXT:    ret i1 [[RET]]
; CHECK:       end:
; CHECK-NEXT:    ret i1 false
;
  %min = call i32 @llvm.smin.i32(i32 %x, i32 1)
  %cmp = icmp sle i32 %y, %min
  br i1 %cmp, label %if, label %end

if:
  %cmp2 = icmp slt i32 %y, %x
  %cmp3 = icmp sle i32 %y, %x
  %ret = xor i1 %cmp2, %cmp3
  ret i1 %ret

end:
  ret i1 false
}

define i1 @umax_uge_ugt_with_add_nuw(i32 %x, i32 %y) {
; CHECK-LABEL: define i1 @umax_uge_ugt_with_add_nuw
; CHECK-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[MAX:%.*]] = call i32 @llvm.umax.i32(i32 [[X]], i32 1)
; CHECK-NEXT:    [[SUM:%.*]] = add nuw i32 [[MAX]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp uge i32 [[Y]], [[SUM]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[END:%.*]]
; CHECK:       if:
; CHECK-NEXT:    ret i1 true
; CHECK:       end:
; CHECK-NEXT:    ret i1 false
;
  %max = call i32 @llvm.umax.i32(i32 %x, i32 1)
  %sum = add nuw i32 %max, 1
  %cmp = icmp uge i32 %y, %sum
  br i1 %cmp, label %if, label %end

if:
  %cmp2 = icmp ugt i32 %y, %x
  ret i1 %cmp2

end:
  ret i1 false
}

define i1 @smin_ule_mixed(i32 %x, i32 %y) {
; CHECK-LABEL: define i1 @smin_ule_mixed
; CHECK-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[MIN:%.*]] = call i32 @llvm.smin.i32(i32 [[X]], i32 1)
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule i32 [[Y]], [[MIN]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[END:%.*]]
; CHECK:       if:
; CHECK-NEXT:    [[CMP2:%.*]] = icmp slt i32 [[Y]], [[X]]
; CHECK-NEXT:    [[CMP3:%.*]] = icmp sle i32 [[Y]], [[X]]
; CHECK-NEXT:    [[CMP4:%.*]] = icmp ult i32 [[Y]], [[X]]
; CHECK-NEXT:    [[CMP5:%.*]] = icmp ule i32 [[Y]], [[X]]
; CHECK-NEXT:    [[XOR1:%.*]] = xor i1 [[CMP2]], [[CMP3]]
; CHECK-NEXT:    [[XOR2:%.*]] = xor i1 [[CMP4]], [[CMP5]]
; CHECK-NEXT:    [[RET:%.*]] = xor i1 [[XOR1]], [[XOR2]]
; CHECK-NEXT:    ret i1 [[RET]]
; CHECK:       end:
; CHECK-NEXT:    ret i1 false
;
  %min = call i32 @llvm.smin.i32(i32 %x, i32 1)
  %cmp = icmp ule i32 %y, %min
  br i1 %cmp, label %if, label %end

if:
  %cmp2 = icmp slt i32 %y, %x
  %cmp3 = icmp sle i32 %y, %x
  %cmp4 = icmp ult i32 %y, %x
  %cmp5 = icmp ule i32 %y, %x
  %xor1 = xor i1 %cmp2, %cmp3
  %xor2 = xor i1 %cmp4, %cmp5
  %ret = xor i1 %xor1, %xor2
  ret i1 %ret

end:
  ret i1 false
}

define i1 @umax_ugt_ugt_both(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: define i1 @umax_ugt_ugt_both
; CHECK-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]]) {
; CHECK-NEXT:    [[MAX:%.*]] = call i32 @llvm.umax.i32(i32 [[X]], i32 [[Y]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[Z]], [[MAX]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[END:%.*]]
; CHECK:       if:
; CHECK-NEXT:    [[AND:%.*]] = xor i1 true, true
; CHECK-NEXT:    ret i1 [[AND]]
; CHECK:       end:
; CHECK-NEXT:    ret i1 false
;
  %max = call i32 @llvm.umax.i32(i32 %x, i32 %y)
  %cmp = icmp ugt i32 %z, %max
  br i1 %cmp, label %if, label %end

if:
  %cmp2 = icmp ugt i32 %z, %x
  %cmp3 = icmp ugt i32 %z, %y
  %and = xor i1 %cmp2, %cmp3
  ret i1 %and

end:
  ret i1 false
}

define i1 @smin_branchless(i32 %x, i32 %y) {
; CHECK-LABEL: define i1 @smin_branchless
; CHECK-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[MIN:%.*]] = call i32 @llvm.smin.i32(i32 [[X]], i32 [[Y]])
; CHECK-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[MIN]], [[X]]
; CHECK-NEXT:    [[CMP2:%.*]] = icmp sgt i32 [[MIN]], [[X]]
; CHECK-NEXT:    [[RET:%.*]] = xor i1 [[CMP1]], [[CMP2]]
; CHECK-NEXT:    ret i1 [[RET]]
;
entry:
  %min = call i32 @llvm.smin.i32(i32 %x, i32 %y)
  %cmp1 = icmp sle i32 %min, %x
  %cmp2 = icmp sgt i32 %min, %x
  %ret = xor i1 %cmp1, %cmp2
  ret i1 %ret
}

define i32 @simplify_smax(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: define i32 @simplify_smax
; CHECK-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[X]], [[Y]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[END:%.*]]
; CHECK:       if:
; CHECK-NEXT:    [[MAX1:%.*]] = call i32 @llvm.smax.i32(i32 [[X]], i32 [[Z]])
; CHECK-NEXT:    [[MAX2:%.*]] = call i32 @llvm.smax.i32(i32 [[Y]], i32 [[MAX1]])
; CHECK-NEXT:    ret i32 [[MAX2]]
; CHECK:       end:
; CHECK-NEXT:    ret i32 0
;
entry:
  %cmp = icmp slt i32 %x, %y
  br i1 %cmp, label %if, label %end
if:
  %max1 = call i32 @llvm.smax.i32(i32 %x, i32 %z)
  %max2 = call i32 @llvm.smax.i32(i32 %y, i32 %max1)
  ret i32 %max2
end:
  ret i32 0
}

; Test from PR75155
define i32 @simplify_slt_smax_val(i32 %a, i32 %b) {
; CHECK-LABEL: define i32 @simplify_slt_smax_val
; CHECK-SAME: (i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:  start:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[A]], [[B]]
; CHECK-NEXT:    br i1 [[CMP]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[A]], 1
; CHECK-NEXT:    ret i32 [[B]]
; CHECK:       else:
; CHECK-NEXT:    ret i32 -1
;
start:
  %cmp = icmp slt i32 %a, %b
  br i1 %cmp, label %then, label %else
then:
  %add = add nsw i32 %a, 1
  %max = call i32 @llvm.smax.i32(i32 %b, i32 %add)
  ret i32 %max
else:
  ret i32 -1
}

define i32 @simplify_slt_smax_val_commuted(i32 %a, i32 %b) {
; CHECK-LABEL: define i32 @simplify_slt_smax_val_commuted
; CHECK-SAME: (i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:  start:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[A]], [[B]]
; CHECK-NEXT:    br i1 [[CMP]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[A]], 1
; CHECK-NEXT:    ret i32 [[B]]
; CHECK:       else:
; CHECK-NEXT:    ret i32 -1
;
start:
  %cmp = icmp slt i32 %a, %b
  br i1 %cmp, label %then, label %else
then:
  %add = add nsw i32 %a, 1
  %max = call i32 @llvm.smax.i32(i32 %add, i32 %b)
  ret i32 %max
else:
  ret i32 -1
}

define i32 @simplify_slt_smax_val_at_use(i32 %a, i32 %b) {
; CHECK-LABEL: define i32 @simplify_slt_smax_val_at_use
; CHECK-SAME: (i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:  start:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[A]], [[B]]
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[A]], 1
; CHECK-NEXT:    [[MAX:%.*]] = call i32 @llvm.smax.i32(i32 [[B]], i32 [[ADD]])
; CHECK-NEXT:    br i1 [[CMP]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    ret i32 [[MAX]]
; CHECK:       else:
; CHECK-NEXT:    ret i32 -1
;
start:
  %cmp = icmp slt i32 %a, %b
  %add = add nsw i32 %a, 1
  %max = call i32 @llvm.smax.i32(i32 %b, i32 %add)
  br i1 %cmp, label %then, label %else
then:
  ret i32 %max
else:
  ret i32 -1
}

define i32 @simplify_sgt_smax_val(i32 %a, i32 %b) {
; CHECK-LABEL: define i32 @simplify_sgt_smax_val
; CHECK-SAME: (i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:  start:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[A]], [[B]]
; CHECK-NEXT:    br i1 [[CMP]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[A]], 1
; CHECK-NEXT:    ret i32 [[ADD]]
; CHECK:       else:
; CHECK-NEXT:    ret i32 -1
;
start:
  %cmp = icmp sgt i32 %a, %b
  br i1 %cmp, label %then, label %else
then:
  %add = add nsw i32 %a, 1
  %max = call i32 @llvm.smax.i32(i32 %b, i32 %add)
  ret i32 %max
else:
  ret i32 -1
}

define i32 @simplify_sle_smax_val(i32 %a, i32 %b) {
; CHECK-LABEL: define i32 @simplify_sle_smax_val
; CHECK-SAME: (i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:  start:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sle i32 [[A]], [[B]]
; CHECK-NEXT:    br i1 [[CMP]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[A]], 1
; CHECK-NEXT:    [[MAX:%.*]] = call i32 @llvm.smax.i32(i32 [[B]], i32 [[ADD]])
; CHECK-NEXT:    ret i32 [[MAX]]
; CHECK:       else:
; CHECK-NEXT:    ret i32 -1
;
start:
  %cmp = icmp sle i32 %a, %b
  br i1 %cmp, label %then, label %else
then:
  %add = add nsw i32 %a, 1
  %max = call i32 @llvm.smax.i32(i32 %b, i32 %add)
  ret i32 %max
else:
  ret i32 -1
}

define i32 @simplify_sge_smax_val(i32 %a, i32 %b) {
; CHECK-LABEL: define i32 @simplify_sge_smax_val
; CHECK-SAME: (i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:  start:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sge i32 [[A]], [[B]]
; CHECK-NEXT:    br i1 [[CMP]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[A]], 1
; CHECK-NEXT:    ret i32 [[ADD]]
; CHECK:       else:
; CHECK-NEXT:    ret i32 -1
;
start:
  %cmp = icmp sge i32 %a, %b
  br i1 %cmp, label %then, label %else
then:
  %add = add nsw i32 %a, 1
  %max = call i32 @llvm.smax.i32(i32 %b, i32 %add)
  ret i32 %max
else:
  ret i32 -1
}

define i32 @simplify_ult_umax_val(i32 %a, i32 %b) {
; CHECK-LABEL: define i32 @simplify_ult_umax_val
; CHECK-SAME: (i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:  start:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[A]], [[B]]
; CHECK-NEXT:    br i1 [[CMP]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i32 [[A]], 1
; CHECK-NEXT:    ret i32 [[B]]
; CHECK:       else:
; CHECK-NEXT:    ret i32 -1
;
start:
  %cmp = icmp ult i32 %a, %b
  br i1 %cmp, label %then, label %else
then:
  %add = add nuw i32 %a, 1
  %max = call i32 @llvm.umax.i32(i32 %b, i32 %add)
  ret i32 %max
else:
  ret i32 -1
}

define i32 @simplify_slt_smin_val(i32 %a, i32 %b) {
; CHECK-LABEL: define i32 @simplify_slt_smin_val
; CHECK-SAME: (i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:  start:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[A]], [[B]]
; CHECK-NEXT:    br i1 [[CMP]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[A]], 1
; CHECK-NEXT:    ret i32 [[ADD]]
; CHECK:       else:
; CHECK-NEXT:    ret i32 -1
;
start:
  %cmp = icmp slt i32 %a, %b
  br i1 %cmp, label %then, label %else
then:
  %add = add nsw i32 %a, 1
  %max = call i32 @llvm.smin.i32(i32 %b, i32 %add)
  ret i32 %max
else:
  ret i32 -1
}

define i32 @simplify_ult_umin_val(i32 %a, i32 %b) {
; CHECK-LABEL: define i32 @simplify_ult_umin_val
; CHECK-SAME: (i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:  start:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[A]], [[B]]
; CHECK-NEXT:    br i1 [[CMP]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i32 [[A]], 1
; CHECK-NEXT:    ret i32 [[ADD]]
; CHECK:       else:
; CHECK-NEXT:    ret i32 -1
;
start:
  %cmp = icmp ult i32 %a, %b
  br i1 %cmp, label %then, label %else
then:
  %add = add nuw i32 %a, 1
  %max = call i32 @llvm.umin.i32(i32 %b, i32 %add)
  ret i32 %max
else:
  ret i32 -1
}

define i32 @simplify_slt_smax_val_fail1(i32 %a, i32 %b) {
; CHECK-LABEL: define i32 @simplify_slt_smax_val_fail1
; CHECK-SAME: (i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:  start:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[A]], [[B]]
; CHECK-NEXT:    br i1 [[CMP]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[A]], 2
; CHECK-NEXT:    [[MAX:%.*]] = call i32 @llvm.smax.i32(i32 [[B]], i32 [[ADD]])
; CHECK-NEXT:    ret i32 [[MAX]]
; CHECK:       else:
; CHECK-NEXT:    ret i32 -1
;
start:
  %cmp = icmp slt i32 %a, %b
  br i1 %cmp, label %then, label %else
then:
  %add = add nsw i32 %a, 2
  %max = call i32 @llvm.smax.i32(i32 %b, i32 %add)
  ret i32 %max
else:
  ret i32 -1
}

define i32 @simplify_ult_smax_val_fail2(i32 %a, i32 %b) {
; CHECK-LABEL: define i32 @simplify_ult_smax_val_fail2
; CHECK-SAME: (i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:  start:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[A]], [[B]]
; CHECK-NEXT:    br i1 [[CMP]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[A]], 1
; CHECK-NEXT:    [[MAX:%.*]] = call i32 @llvm.smax.i32(i32 [[B]], i32 [[ADD]])
; CHECK-NEXT:    ret i32 [[MAX]]
; CHECK:       else:
; CHECK-NEXT:    ret i32 -1
;
start:
  %cmp = icmp ult i32 %a, %b
  br i1 %cmp, label %then, label %else
then:
  %add = add nsw i32 %a, 1
  %max = call i32 @llvm.smax.i32(i32 %b, i32 %add)
  ret i32 %max
else:
  ret i32 -1
}

define i64 @pr82271(i32 %a, i32 %b){
; CHECK-LABEL: define i64 @pr82271
; CHECK-SAME: (i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[A]], [[B]]
; CHECK-NEXT:    br i1 [[CMP]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[SA:%.*]] = sext i32 [[A]] to i64
; CHECK-NEXT:    [[SB:%.*]] = sext i32 [[B]] to i64
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i64 [[SA]], 1
; CHECK-NEXT:    ret i64 [[SB]]
; CHECK:       else:
; CHECK-NEXT:    ret i64 0
;
entry:
  %cmp = icmp slt i32 %a, %b
  br i1 %cmp, label %then, label %else

then:
  %sa = sext i32 %a to i64
  %sb = sext i32 %b to i64
  %add = add nsw i64 %sa, 1
  %smax = call i64 @llvm.smax.i64(i64 %sb, i64 %add)
  ret i64 %smax

else:
  ret i64 0
}

define i64 @pr82271_sext_zext_nneg(i32 %a, i32 %b){
; CHECK-LABEL: define i64 @pr82271_sext_zext_nneg
; CHECK-SAME: (i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[A]], [[B]]
; CHECK-NEXT:    br i1 [[CMP]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[SA:%.*]] = sext i32 [[A]] to i64
; CHECK-NEXT:    [[SB:%.*]] = zext nneg i32 [[B]] to i64
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i64 [[SA]], 1
; CHECK-NEXT:    ret i64 [[SB]]
; CHECK:       else:
; CHECK-NEXT:    ret i64 0
;
entry:
  %cmp = icmp slt i32 %a, %b
  br i1 %cmp, label %then, label %else

then:
  %sa = sext i32 %a to i64
  %sb = zext nneg i32 %b to i64
  %add = add nsw i64 %sa, 1
  %smax = call i64 @llvm.smax.i64(i64 %sb, i64 %add)
  ret i64 %smax

else:
  ret i64 0
}

define i64 @pr82271_zext_nneg(i32 %a, i32 %b){
; CHECK-LABEL: define i64 @pr82271_zext_nneg
; CHECK-SAME: (i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[A]], [[B]]
; CHECK-NEXT:    br i1 [[CMP]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[SA:%.*]] = zext nneg i32 [[A]] to i64
; CHECK-NEXT:    [[SB:%.*]] = zext nneg i32 [[B]] to i64
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i64 [[SA]], 1
; CHECK-NEXT:    ret i64 [[SB]]
; CHECK:       else:
; CHECK-NEXT:    ret i64 0
;
entry:
  %cmp = icmp slt i32 %a, %b
  br i1 %cmp, label %then, label %else

then:
  %sa = zext nneg i32 %a to i64
  %sb = zext nneg i32 %b to i64
  %add = add nsw i64 %sa, 1
  %smax = call i64 @llvm.smax.i64(i64 %sb, i64 %add)
  ret i64 %smax

else:
  ret i64 0
}

define i64 @pr82271_zext(i32 %a, i32 %b){
; CHECK-LABEL: define i64 @pr82271_zext
; CHECK-SAME: (i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[A]], [[B]]
; CHECK-NEXT:    br i1 [[CMP]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[SA:%.*]] = zext i32 [[A]] to i64
; CHECK-NEXT:    [[SB:%.*]] = zext i32 [[B]] to i64
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i64 [[SA]], 1
; CHECK-NEXT:    [[SMAX:%.*]] = call i64 @llvm.smax.i64(i64 [[SB]], i64 [[ADD]])
; CHECK-NEXT:    ret i64 [[SMAX]]
; CHECK:       else:
; CHECK-NEXT:    ret i64 0
;
entry:
  %cmp = icmp slt i32 %a, %b
  br i1 %cmp, label %then, label %else

then:
  %sa = zext i32 %a to i64
  %sb = zext i32 %b to i64
  %add = add nsw i64 %sa, 1
  %smax = call i64 @llvm.smax.i64(i64 %sb, i64 %add)
  ret i64 %smax

else:
  ret i64 0
}

declare i32 @llvm.smin.i32(i32, i32)
declare i32 @llvm.smax.i32(i32, i32)
declare i32 @llvm.umin.i32(i32, i32)
declare i32 @llvm.umax.i32(i32, i32)
