; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=xtensa --mattr=+minmax -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=XTENSA %s

declare i32 @llvm.smin.i32(i32, i32)
declare i32 @llvm.umin.i32(i32, i32)
declare i32 @llvm.smax.i32(i32, i32)
declare i32 @llvm.umax.i32(i32, i32)

define i32 @test_smin(i32 %x, i32 %y) {
; XTENSA-LABEL: test_smin:
; XTENSA:         .cfi_startproc
; XTENSA-NEXT:  # %bb.0: # %entry
; XTENSA-NEXT:    min a2, a2, a3
; XTENSA-NEXT:    ret
entry:
  %res = call i32 @llvm.smin.i32(i32 %x, i32 %y)
  ret i32 %res
}

define i32 @test_umin(i32 %x, i32 %y) {
; XTENSA-LABEL: test_umin:
; XTENSA:         .cfi_startproc
; XTENSA-NEXT:  # %bb.0: # %entry
; XTENSA-NEXT:    minu a2, a2, a3
; XTENSA-NEXT:    ret
entry:
  %res = call i32 @llvm.umin.i32(i32 %x, i32 %y)
  ret i32 %res
}

define i32 @test_smax(i32 %x, i32 %y) {
; XTENSA-LABEL: test_smax:
; XTENSA:         .cfi_startproc
; XTENSA-NEXT:  # %bb.0: # %entry
; XTENSA-NEXT:    max a2, a2, a3
; XTENSA-NEXT:    ret
entry:
  %res = call i32 @llvm.smax.i32(i32 %x, i32 %y)
  ret i32 %res
}

define i32 @test_umax(i32 %x, i32 %y) {
; XTENSA-LABEL: test_umax:
; XTENSA:         .cfi_startproc
; XTENSA-NEXT:  # %bb.0: # %entry
; XTENSA-NEXT:    maxu a2, a2, a3
; XTENSA-NEXT:    ret
entry:
  %res = call i32 @llvm.umax.i32(i32 %x, i32 %y)
  ret i32 %res
}
