; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i386-apple-darwin -mattr=+sse3 -show-mc-encoding | FileCheck %s --check-prefixes=X86,SSE,X86-SSE
; RUN: llc < %s -mtriple=i386-apple-darwin -mattr=+avx -show-mc-encoding | FileCheck %s --check-prefixes=X86,AVX,X86-AVX
; RUN: llc < %s -mtriple=i386-apple-darwin -mattr=+avx512f,+avx512bw,+avx512dq,+avx512vl -show-mc-encoding | FileCheck %s --check-prefixes=X86,AVX,X86-AVX
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=+sse3 -show-mc-encoding | FileCheck %s --check-prefixes=X64,SSE,X64-SSE
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=+avx -show-mc-encoding | FileCheck %s --check-prefixes=X64,AVX,X64-AVX
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=+avx512f,+avx512bw,+avx512dq,+avx512vl -show-mc-encoding | FileCheck %s --check-prefixes=X64,AVX,X64-AVX

define <2 x double> @test_x86_sse3_addsub_pd(<2 x double> %a0, <2 x double> %a1) {
; SSE-LABEL: test_x86_sse3_addsub_pd:
; SSE:       ## %bb.0:
; SSE-NEXT:    addsubpd %xmm1, %xmm0 ## encoding: [0x66,0x0f,0xd0,0xc1]
; SSE-NEXT:    ret{{[l|q]}} ## encoding: [0xc3]
;
; AVX-LABEL: test_x86_sse3_addsub_pd:
; AVX:       ## %bb.0:
; AVX-NEXT:    vaddsubpd %xmm1, %xmm0, %xmm0 ## encoding: [0xc5,0xf9,0xd0,0xc1]
; AVX-NEXT:    ret{{[l|q]}} ## encoding: [0xc3]
  %res = call <2 x double> @llvm.x86.sse3.addsub.pd(<2 x double> %a0, <2 x double> %a1) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse3.addsub.pd(<2 x double>, <2 x double>) nounwind readnone


define <4 x float> @test_x86_sse3_addsub_ps(<4 x float> %a0, <4 x float> %a1) {
; SSE-LABEL: test_x86_sse3_addsub_ps:
; SSE:       ## %bb.0:
; SSE-NEXT:    addsubps %xmm1, %xmm0 ## encoding: [0xf2,0x0f,0xd0,0xc1]
; SSE-NEXT:    ret{{[l|q]}} ## encoding: [0xc3]
;
; AVX-LABEL: test_x86_sse3_addsub_ps:
; AVX:       ## %bb.0:
; AVX-NEXT:    vaddsubps %xmm1, %xmm0, %xmm0 ## encoding: [0xc5,0xfb,0xd0,0xc1]
; AVX-NEXT:    ret{{[l|q]}} ## encoding: [0xc3]
  %res = call <4 x float> @llvm.x86.sse3.addsub.ps(<4 x float> %a0, <4 x float> %a1) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse3.addsub.ps(<4 x float>, <4 x float>) nounwind readnone


define <2 x double> @test_x86_sse3_hadd_pd(<2 x double> %a0, <2 x double> %a1) {
; SSE-LABEL: test_x86_sse3_hadd_pd:
; SSE:       ## %bb.0:
; SSE-NEXT:    haddpd %xmm1, %xmm0 ## encoding: [0x66,0x0f,0x7c,0xc1]
; SSE-NEXT:    ret{{[l|q]}} ## encoding: [0xc3]
;
; AVX-LABEL: test_x86_sse3_hadd_pd:
; AVX:       ## %bb.0:
; AVX-NEXT:    vhaddpd %xmm1, %xmm0, %xmm0 ## encoding: [0xc5,0xf9,0x7c,0xc1]
; AVX-NEXT:    ret{{[l|q]}} ## encoding: [0xc3]
  %res = call <2 x double> @llvm.x86.sse3.hadd.pd(<2 x double> %a0, <2 x double> %a1) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse3.hadd.pd(<2 x double>, <2 x double>) nounwind readnone


define <4 x float> @test_x86_sse3_hadd_ps(<4 x float> %a0, <4 x float> %a1) {
; SSE-LABEL: test_x86_sse3_hadd_ps:
; SSE:       ## %bb.0:
; SSE-NEXT:    haddps %xmm1, %xmm0 ## encoding: [0xf2,0x0f,0x7c,0xc1]
; SSE-NEXT:    ret{{[l|q]}} ## encoding: [0xc3]
;
; AVX-LABEL: test_x86_sse3_hadd_ps:
; AVX:       ## %bb.0:
; AVX-NEXT:    vhaddps %xmm1, %xmm0, %xmm0 ## encoding: [0xc5,0xfb,0x7c,0xc1]
; AVX-NEXT:    ret{{[l|q]}} ## encoding: [0xc3]
  %res = call <4 x float> @llvm.x86.sse3.hadd.ps(<4 x float> %a0, <4 x float> %a1) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse3.hadd.ps(<4 x float>, <4 x float>) nounwind readnone


define <2 x double> @test_x86_sse3_hsub_pd(<2 x double> %a0, <2 x double> %a1) {
; SSE-LABEL: test_x86_sse3_hsub_pd:
; SSE:       ## %bb.0:
; SSE-NEXT:    hsubpd %xmm1, %xmm0 ## encoding: [0x66,0x0f,0x7d,0xc1]
; SSE-NEXT:    ret{{[l|q]}} ## encoding: [0xc3]
;
; AVX-LABEL: test_x86_sse3_hsub_pd:
; AVX:       ## %bb.0:
; AVX-NEXT:    vhsubpd %xmm1, %xmm0, %xmm0 ## encoding: [0xc5,0xf9,0x7d,0xc1]
; AVX-NEXT:    ret{{[l|q]}} ## encoding: [0xc3]
  %res = call <2 x double> @llvm.x86.sse3.hsub.pd(<2 x double> %a0, <2 x double> %a1) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse3.hsub.pd(<2 x double>, <2 x double>) nounwind readnone


define <4 x float> @test_x86_sse3_hsub_ps(<4 x float> %a0, <4 x float> %a1) {
; SSE-LABEL: test_x86_sse3_hsub_ps:
; SSE:       ## %bb.0:
; SSE-NEXT:    hsubps %xmm1, %xmm0 ## encoding: [0xf2,0x0f,0x7d,0xc1]
; SSE-NEXT:    ret{{[l|q]}} ## encoding: [0xc3]
;
; AVX-LABEL: test_x86_sse3_hsub_ps:
; AVX:       ## %bb.0:
; AVX-NEXT:    vhsubps %xmm1, %xmm0, %xmm0 ## encoding: [0xc5,0xfb,0x7d,0xc1]
; AVX-NEXT:    ret{{[l|q]}} ## encoding: [0xc3]
  %res = call <4 x float> @llvm.x86.sse3.hsub.ps(<4 x float> %a0, <4 x float> %a1) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse3.hsub.ps(<4 x float>, <4 x float>) nounwind readnone


define <16 x i8> @test_x86_sse3_ldu_dq(ptr %a0) {
; X86-SSE-LABEL: test_x86_sse3_ldu_dq:
; X86-SSE:       ## %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax ## encoding: [0x8b,0x44,0x24,0x04]
; X86-SSE-NEXT:    lddqu (%eax), %xmm0 ## encoding: [0xf2,0x0f,0xf0,0x00]
; X86-SSE-NEXT:    retl ## encoding: [0xc3]
;
; X86-AVX-LABEL: test_x86_sse3_ldu_dq:
; X86-AVX:       ## %bb.0:
; X86-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax ## encoding: [0x8b,0x44,0x24,0x04]
; X86-AVX-NEXT:    vlddqu (%eax), %xmm0 ## encoding: [0xc5,0xfb,0xf0,0x00]
; X86-AVX-NEXT:    retl ## encoding: [0xc3]
;
; X64-SSE-LABEL: test_x86_sse3_ldu_dq:
; X64-SSE:       ## %bb.0:
; X64-SSE-NEXT:    lddqu (%rdi), %xmm0 ## encoding: [0xf2,0x0f,0xf0,0x07]
; X64-SSE-NEXT:    retq ## encoding: [0xc3]
;
; X64-AVX-LABEL: test_x86_sse3_ldu_dq:
; X64-AVX:       ## %bb.0:
; X64-AVX-NEXT:    vlddqu (%rdi), %xmm0 ## encoding: [0xc5,0xfb,0xf0,0x07]
; X64-AVX-NEXT:    retq ## encoding: [0xc3]
  %res = call <16 x i8> @llvm.x86.sse3.ldu.dq(ptr %a0) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.sse3.ldu.dq(ptr) nounwind readonly

; Make sure instructions with no AVX equivalents, but are associated with SSEX feature flags still work

define void @monitor(ptr %P, i32 %E, i32 %H) nounwind {
; X86-LABEL: monitor:
; X86:       ## %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax ## encoding: [0x8b,0x44,0x24,0x04]
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx ## encoding: [0x8b,0x4c,0x24,0x08]
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx ## encoding: [0x8b,0x54,0x24,0x0c]
; X86-NEXT:    monitor ## encoding: [0x0f,0x01,0xc8]
; X86-NEXT:    retl ## encoding: [0xc3]
;
; X64-LABEL: monitor:
; X64:       ## %bb.0:
; X64-NEXT:    movl %esi, %ecx ## encoding: [0x89,0xf1]
; X64-NEXT:    movq %rdi, %rax ## encoding: [0x48,0x89,0xf8]
; X64-NEXT:    monitor ## encoding: [0x0f,0x01,0xc8]
; X64-NEXT:    retq ## encoding: [0xc3]
  tail call void @llvm.x86.sse3.monitor(ptr %P, i32 %E, i32 %H)
  ret void
}
declare void @llvm.x86.sse3.monitor(ptr, i32, i32) nounwind

define void @mwait(i32 %E, i32 %H) nounwind {
; X86-LABEL: mwait:
; X86:       ## %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx ## encoding: [0x8b,0x4c,0x24,0x04]
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax ## encoding: [0x8b,0x44,0x24,0x08]
; X86-NEXT:    mwait ## encoding: [0x0f,0x01,0xc9]
; X86-NEXT:    retl ## encoding: [0xc3]
;
; X64-LABEL: mwait:
; X64:       ## %bb.0:
; X64-NEXT:    movl %esi, %eax ## encoding: [0x89,0xf0]
; X64-NEXT:    movl %edi, %ecx ## encoding: [0x89,0xf9]
; X64-NEXT:    mwait ## encoding: [0x0f,0x01,0xc9]
; X64-NEXT:    retq ## encoding: [0xc3]
  tail call void @llvm.x86.sse3.mwait(i32 %E, i32 %H)
  ret void
}
declare void @llvm.x86.sse3.mwait(i32, i32) nounwind
