; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=x86_64-- --start-before=x86-isel -mattr=+avx,+fma %s -o - | FileCheck %s
; RUN: llc -mtriple=x86_64-- --start-before=x86-isel -mattr=+avx,+fma %s -o - -fp-contract=fast | FileCheck %s

define double @fma_folding(double %x) {
; CHECK-LABEL: fma_folding:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovsd {{.*#+}} xmm0 = [1.0E+0,0.0E+0]
; CHECK-NEXT:    retq
 %prod = fmul contract ninf nnan double %x, 0.0
 %fused = fadd contract ninf nnan double %prod, 1.0
 ret double %fused
}

define double @fma_no_folding(double %x) {
; CHECK-LABEL: fma_no_folding:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vfmadd213sd {{.*#+}} xmm0 = (xmm1 * xmm0) + mem
; CHECK-NEXT:    retq
  %fused = call contract nnan ninf double @llvm.fma.f64(double %x, double 0.0, double -0.0)
  ret double %fused
}

define double @fma_no_fold_potential_nan(double %x) {
; CHECK-LABEL: fma_no_fold_potential_nan:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vfmadd213sd {{.*#+}} xmm0 = (xmm1 * xmm0) + mem
; CHECK-NEXT:    retq
 %fused = call contract double @llvm.fma.f64(double %x, double 0.0, double 1.0)
 ret double %fused
}

