; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -O3 -mtriple=riscv32 -mattr=+xcvmem -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK

define <2 x i32> @lb_ri_inc(ptr %a) {
; CHECK-LABEL: lb_ri_inc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.lb a1, (a0), 42
; CHECK-NEXT:    ret
  %1 = load i8, ptr %a
  %2 = sext i8 %1 to i32
  %3 = getelementptr i8, ptr %a, i32 42
  %4 = ptrtoint ptr %3 to i32
  %5 = insertelement <2 x i32> undef, i32 %4, i32 0
  %6 = insertelement <2 x i32> %5, i32 %2, i32 1
  ret <2 x i32> %6
}

define <2 x i32> @lb_rr_inc(ptr %a, i32 %b) {
; CHECK-LABEL: lb_rr_inc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.lb a1, (a0), a1
; CHECK-NEXT:    ret
  %1 = load i8, ptr %a
  %2 = sext i8 %1 to i32
  %3 = getelementptr i8, ptr %a, i32 %b
  %4 = ptrtoint ptr %3 to i32
  %5 = insertelement <2 x i32> undef, i32 %4, i32 0
  %6 = insertelement <2 x i32> %5, i32 %2, i32 1
  ret <2 x i32> %6
}

define i32 @lb_rr(ptr %a, i32 %b) {
; CHECK-LABEL: lb_rr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.lb a0, a1(a0)
; CHECK-NEXT:    ret
  %1 = getelementptr i8, ptr %a, i32 %b
  %2 = load i8, ptr %1
  %3 = sext i8 %2 to i32
  ret i32 %3
}

define <2 x i32> @lbu_ri_inc(ptr %a) {
; CHECK-LABEL: lbu_ri_inc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.lbu a1, (a0), 42
; CHECK-NEXT:    ret
  %1 = load i8, ptr %a
  %2 = zext i8 %1 to i32
  %3 = getelementptr i8, ptr %a, i32 42
  %4 = ptrtoint ptr %3 to i32
  %5 = insertelement <2 x i32> undef, i32 %4, i32 0
  %6 = insertelement <2 x i32> %5, i32 %2, i32 1
  ret <2 x i32> %6
}

define <2 x i32> @lbu_rr_inc(ptr %a, i32 %b) {
; CHECK-LABEL: lbu_rr_inc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.lbu a1, (a0), a1
; CHECK-NEXT:    ret
  %1 = load i8, ptr %a
  %2 = zext i8 %1 to i32
  %3 = getelementptr i8, ptr %a, i32 %b
  %4 = ptrtoint ptr %3 to i32
  %5 = insertelement <2 x i32> undef, i32 %4, i32 0
  %6 = insertelement <2 x i32> %5, i32 %2, i32 1
  ret <2 x i32> %6
}

define i32 @lbu_rr(ptr %a, i32 %b) {
; CHECK-LABEL: lbu_rr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.lbu a0, a1(a0)
; CHECK-NEXT:    ret
  %1 = getelementptr i8, ptr %a, i32 %b
  %2 = load i8, ptr %1
  %3 = zext i8 %2 to i32
  ret i32 %3
}

define <2 x i32> @lh_ri_inc(ptr %a) {
; CHECK-LABEL: lh_ri_inc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.lh a1, (a0), 84
; CHECK-NEXT:    ret
  %1 = load i16, ptr %a
  %2 = sext i16 %1 to i32
  %3 = getelementptr i16, ptr %a, i32 42
  %4 = ptrtoint ptr %3 to i32
  %5 = insertelement <2 x i32> undef, i32 %4, i32 0
  %6 = insertelement <2 x i32> %5, i32 %2, i32 1
  ret <2 x i32> %6
}

define <2 x i32> @lh_rr_inc(ptr %a, i32 %b) {
; CHECK-LABEL: lh_rr_inc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a1, a1, 1
; CHECK-NEXT:    cv.lh a1, (a0), a1
; CHECK-NEXT:    ret
  %1 = load i16, ptr %a
  %2 = sext i16 %1 to i32
  %3 = getelementptr i16, ptr %a, i32 %b
  %4 = ptrtoint ptr %3 to i32
  %5 = insertelement <2 x i32> undef, i32 %4, i32 0
  %6 = insertelement <2 x i32> %5, i32 %2, i32 1
  ret <2 x i32> %6
}

define i32 @lh_rr(ptr %a, i32 %b) {
; CHECK-LABEL: lh_rr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a1, a1, 1
; CHECK-NEXT:    cv.lh a0, a1(a0)
; CHECK-NEXT:    ret
  %1 = getelementptr i16, ptr %a, i32 %b
  %2 = load i16, ptr %1
  %3 = sext i16 %2 to i32
  ret i32 %3
}

define <2 x i32> @lhu_ri_inc(ptr %a) {
; CHECK-LABEL: lhu_ri_inc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.lhu a1, (a0), 84
; CHECK-NEXT:    ret
  %1 = load i16, ptr %a
  %2 = zext i16 %1 to i32
  %3 = getelementptr i16, ptr %a, i32 42
  %4 = ptrtoint ptr %3 to i32
  %5 = insertelement <2 x i32> undef, i32 %4, i32 0
  %6 = insertelement <2 x i32> %5, i32 %2, i32 1
  ret <2 x i32> %6
}

define <2 x i32> @lhu_rr_inc(ptr %a, i32 %b) {
; CHECK-LABEL: lhu_rr_inc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a1, a1, 1
; CHECK-NEXT:    cv.lhu a1, (a0), a1
; CHECK-NEXT:    ret
  %1 = load i16, ptr %a
  %2 = zext i16 %1 to i32
  %3 = getelementptr i16, ptr %a, i32 %b
  %4 = ptrtoint ptr %3 to i32
  %5 = insertelement <2 x i32> undef, i32 %4, i32 0
  %6 = insertelement <2 x i32> %5, i32 %2, i32 1
  ret <2 x i32> %6
}

define i32 @lhu_rr(ptr %a, i32 %b) {
; CHECK-LABEL: lhu_rr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a1, a1, 1
; CHECK-NEXT:    cv.lhu a0, a1(a0)
; CHECK-NEXT:    ret
  %1 = getelementptr i16, ptr %a, i32 %b
  %2 = load i16, ptr %1
  %3 = zext i16 %2 to i32
  ret i32 %3
}

define <2 x i32> @lw_ri_inc(ptr %a) {
; CHECK-LABEL: lw_ri_inc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.lw a1, (a0), 168
; CHECK-NEXT:    ret
  %1 = load i32, ptr %a
  %2 = getelementptr i32, ptr %a, i32 42
  %3 = ptrtoint ptr %2 to i32
  %4 = insertelement <2 x i32> undef, i32 %3, i32 0
  %5 = insertelement <2 x i32> %4, i32 %1, i32 1
  ret <2 x i32> %5
}

define <2 x i32> @lw_rr_inc(ptr %a, i32 %b) {
; CHECK-LABEL: lw_rr_inc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a1, a1, 2
; CHECK-NEXT:    cv.lw a1, (a0), a1
; CHECK-NEXT:    ret
  %1 = load i32, ptr %a
  %2 = getelementptr i32, ptr %a, i32 %b
  %3 = ptrtoint ptr %2 to i32
  %4 = insertelement <2 x i32> undef, i32 %3, i32 0
  %5 = insertelement <2 x i32> %4, i32 %1, i32 1
  ret <2 x i32> %5
}

define i32 @lw_rr(ptr %a, i32 %b) {
; CHECK-LABEL: lw_rr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a1, a1, 2
; CHECK-NEXT:    cv.lw a0, a1(a0)
; CHECK-NEXT:    ret
  %1 = getelementptr i32, ptr %a, i32 %b
  %2 = load i32, ptr %1
  ret i32 %2
}

define ptr @sb_ri_inc(ptr %a, i8 %b) {
; CHECK-LABEL: sb_ri_inc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.sb a1, (a0), 42
; CHECK-NEXT:    ret
  store i8 %b, ptr %a
  %1 = getelementptr i8, ptr %a, i32 42
  ret ptr %1
}

define ptr @sb_rr_inc(ptr %a, i8 %b, i32 %c) {
; CHECK-LABEL: sb_rr_inc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.sb a1, (a0), a2
; CHECK-NEXT:    ret
  store i8 %b, ptr %a
  %1 = getelementptr i8, ptr %a, i32 %c
  ret ptr %1
}

define void @sb_rr(ptr %a, i8 %b, i32 %c) {
; CHECK-LABEL: sb_rr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.sb a1, a2(a0)
; CHECK-NEXT:    ret
  %1 = getelementptr i8, ptr %a, i32 %c
  store i8 %b, ptr %1
  ret void
}

define ptr @sh_ri_inc(ptr %a, i16 %b) {
; CHECK-LABEL: sh_ri_inc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.sh a1, (a0), 84
; CHECK-NEXT:    ret
  store i16 %b, ptr %a
  %1 = getelementptr i16, ptr %a, i32 42
  ret ptr %1
}

define ptr @sh_rr_inc(ptr %a, i16 %b, i32 %c) {
; CHECK-LABEL: sh_rr_inc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a2, a2, 1
; CHECK-NEXT:    cv.sh a1, (a0), a2
; CHECK-NEXT:    ret
  store i16 %b, ptr %a
  %1 = getelementptr i16, ptr %a, i32 %c
  ret ptr %1
}

define void @sh_rr(ptr %a, i16 %b, i32 %c) {
; CHECK-LABEL: sh_rr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a2, a2, 1
; CHECK-NEXT:    cv.sh a1, a2(a0)
; CHECK-NEXT:    ret
  %1 = getelementptr i16, ptr %a, i32 %c
  store i16 %b, ptr %1
  ret void
}

define ptr @sw_ri_inc(ptr %a, i32 %b) {
; CHECK-LABEL: sw_ri_inc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cv.sw a1, (a0), 168
; CHECK-NEXT:    ret
  store i32 %b, ptr %a
  %1 = getelementptr i32, ptr %a, i32 42
  ret ptr %1
}

define ptr @sw_rr_inc(ptr %a, i32 %b, i32 %c) {
; CHECK-LABEL: sw_rr_inc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a2, a2, 2
; CHECK-NEXT:    cv.sw a1, (a0), a2
; CHECK-NEXT:    ret
  store i32 %b, ptr %a
  %1 = getelementptr i32, ptr %a, i32 %c
  ret ptr %1
}

define void @sw_rr(ptr %a, i32 %b, i32 %c) {
; CHECK-LABEL: sw_rr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a2, a2, 2
; CHECK-NEXT:    cv.sw a1, a2(a0)
; CHECK-NEXT:    ret
  %1 = getelementptr i32, ptr %a, i32 %c
  store i32 %b, ptr %1
  ret void
}
